---
sidebarDepth: 2
editLink: false
---
# Executors
---

## Functions
|top-level functions: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-utilities-executors-run-task-with-timeout'><p class="prefect-class">prefect.utilities.executors.run_task_with_timeout</p>(task, args=(), kwargs=None, logger=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/utilities/executors.py#L427">[source]</a></span></div>
<p class="methods">Helper function for implementing timeouts on task executions.<br><br>The exact implementation varies depending on whether this function is being run in the main thread or a non-daemonic subprocess.  If this is run from a daemonic subprocess or on Windows, the task is run in a `ThreadPoolExecutor` and only a soft timeout is enforced, meaning a `TaskTimeoutSignal` is raised at the appropriate time but the task continues running in the background.<br><br>The task is passed instead of a function so we can give better logs and messages. If you need to run generic functions with timeout handlers, `run_with_thread_timeout` or `run_with_multiprocess_timeout` can be called directly<br><br>**Args**:     <ul class="args"><li class="args">`task (Task)`: the task to execute         `task.timeout` specifies the number of seconds to allow `task.run` to run         for before terminating     </li><li class="args">`args (Sequence)`: arguments to pass to the function     </li><li class="args">`kwargs (Mapping)`: keyword arguments to pass to the function     </li><li class="args">`logger (Logger)`: an optional logger to use. If not passed, a logger for the         `prefect.run_task_with_timeout_handler` namespace will be created.</li></ul> **Returns**:     <ul class="args"><li class="args">the result of `f(*args, **kwargs)`</li></ul>**Raises**:     <ul class="args"><li class="args">`TaskTimeoutSignal`: if function execution exceeds the allowed timeout</li></ul></p>|

<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on February 23, 2022 at 19:26 UTC</p>