---
sidebarDepth: 2
editLink: false
---
# Debugging Tools
---

## Functions
|top-level functions: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-utilities-debug-is-serializable'><p class="prefect-class">prefect.utilities.debug.is_serializable</p>(obj, raise_on_error=False)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/utilities/debug.py#L14">[source]</a></span></div>
<p class="methods">Checks whether a given object can be registered with Prefect Cloud.  This requires that the object can be serialized in the current process and deserialized in a fresh process.<br><br>**Args**:     <ul class="args"><li class="args">`obj (Any)`: the object to check     </li><li class="args">`raise_on_error(bool, optional)`: if `True`, raises the `CalledProcessError` for       inspection; the `output` attribute of this exception can contain useful information       about why the object is not registrable</li></ul> **Returns**:     <ul class="args"><li class="args">`bool`: `True` if registrable, `False` otherwise</li></ul> **Raises**:     <ul class="args"><li class="args">`subprocess.CalledProcessError`: if `raise_on_error=True` and the object is not registrable</li></ul></p>|
 | <div class='method-sig' id='prefect-utilities-debug-raise-on-exception'><p class="prefect-class">prefect.utilities.debug.raise_on_exception</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/utilities/debug.py#L71">[source]</a></span></div>
<p class="methods">Context manager for raising exceptions when they occur instead of trapping them. Intended to be used only for local debugging and testing.<br><br>**Example**:     <br><pre class="language-python"><code class="language-python">    <span class="token keyword">from</span> prefect <span class="token keyword">import</span> Flow<span class="token punctuation">,</span> task<br>    <span class="token keyword">from</span> prefect.utilities.debug <span class="token keyword">import</span> raise_on_exception<br><br>    <span class="token decorator">@task</span><br>    <span class="token keyword">def</span> <span class="token function">div</span><span class="token punctuation">(</span>x<span class="token punctuation">)</span><span class="token punctuation">:</span><br>        <span class="token keyword">return</span> <span class="token number">1</span> <span class="token operator">/</span> x<br><br>    <span class="token keyword">with</span> Flow<span class="token punctuation">(</span><span class="token string">"</span><span class="token string">My Flow</span><span class="token string">"</span><span class="token punctuation">)</span> <span class="token keyword">as</span> f<span class="token punctuation">:</span><br>        res <span class="token operator">=</span> div<span class="token punctuation">(</span><span class="token number">0</span><span class="token punctuation">)</span><br><br>    <span class="token keyword">with</span> raise_on_exception<span class="token punctuation">(</span><span class="token punctuation">)</span><span class="token punctuation">:</span><br>        f<span class="token operator">.</span>run<span class="token punctuation">(</span><span class="token punctuation">)</span> <span class="token comment"># raises ZeroDivisionError</span><br>    <br></code></pre><br></p>|

<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on February 23, 2022 at 19:26 UTC</p>