---
sidebarDepth: 2
editLink: false
---
# Zendesk Tasks
---
This module contains a collection of tasks to export data from Zendesk.
 ## ZendeskTicketsIncrementalExportTask
 <div class='class-sig' id='prefect-tasks-zendesk-zendesk-tasks-zendeskticketsincrementalexporttask'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.zendesk.zendesk_tasks.ZendeskTicketsIncrementalExportTask</p>(subdomain=None, email_address=None, api_token=None, api_token_env_var=None, start_time=None, cursor=None, exclude_deleted=False, include_entities=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/zendesk/zendesk_tasks.py#L14">[source]</a></span></div>

This task can be used to perform an incremental export of tickets from Zendesk. More info at https://developer.zendesk.com/api-reference/ticketing/ticket-management/incremental_exports/#incremental-ticket-export.

**Args**:     <ul class="args"><li class="args">`subdomain (str, optional)`: The Zendesk subdomain to use to export tickets.     </li><li class="args">`email_address (str, optional)`: The email address to use to authenticate on Zendesk.     </li><li class="args">`api_token (str, optional)`: The API token to use to athenticate on Zendesk         If passed, it will take precedence over `api_token_env_var`.     </li><li class="args">`api_token_env_var (str, optional)`: The name of the env var which contains the         API token to use to authenticate on Zendesk.     </li><li class="args">`start_time (int, datetime, optional)`: The start time to use to export tickets.         Can be passed as an epoch timestamp or a `datetime` object.     </li><li class="args">`cursor (str, optional)`: The cursor to use to export tickets.         If passed, it will take precedence over `start_time`.     </li><li class="args">`exclude_deleted`: (bool, optional): Whether to exclude deleted tickets or not.         Default to `False`.     </li><li class="args">`include_entities`: (str, list, optional): Optional list of entities to side load.       More info at       https://developer.zendesk.com/documentation/ticketing/using-the-zendesk-api/side_loading/.     </li><li class="args">`**kwargs (dict, optional)`: Additional keyword arguments to pass to the         Task constructor.</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-zendesk-zendesk-tasks-zendeskticketsincrementalexporttask-run'><p class="prefect-class">prefect.tasks.zendesk.zendesk_tasks.ZendeskTicketsIncrementalExportTask.run</p>(subdomain=None, email_address=None, api_token=None, api_token_env_var=None, start_time=None, cursor=None, exclude_deleted=None, include_entities=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/zendesk/zendesk_tasks.py#L64">[source]</a></span></div>
<p class="methods">Task run method to perform an incremental export of tickets from Zendesk. **Args**:     <ul class="args"><li class="args">`subdomain (str, optional)`: The Zendesk subdomain to use to export tickets.     </li><li class="args">`email_address (str, optional)`: The email address to use to authenticate on Zendesk.     </li><li class="args">`api_token (str, optional)`: The API token to use to athenticate on Zendesk         If passed, it will take precedence over `api_token_env_var`.     </li><li class="args">`api_token_env_var (str, optional)`: The name of the env var which contains the         API token to use to authenticate on Zendesk.     </li><li class="args">`start_time (int, datetime, optional)`: The start time to use to export tickets.         Can be passed as an epoch timestamp or a `datetime` object.     </li><li class="args">`cursor (str, optional)`: The cursor to use to export tickets.         If passed, it will take precedence over `start_time`.     </li><li class="args">`exclude_deleted`: (bool, optional): Whether to exclude deleted tickets or not.         Default to `False`.     </li><li class="args">`include_entities`: (str, list, optional): Optional list of entities to side load.         More info at         https://developer.zendesk.com/documentation/ticketing/using-the-zendesk-api/side_loading/.</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError` if both `api_token` and `api_token_env_var` are missing.     - `ValueError` if `api_token` is missing and `api_token_env_var` cannot be found.     - `ValueError` if `subdomain` is missing.     - `ValueError` if `email_address` is missing.     - `ValueError` if both `start_time` and `cursor` are missing.     - `prefect.engine.signals.FAIL` if the Zendesk API call fails.</li></ul><br><br>**Returns**:     <ul class="args"><li class="args">A `dict` containing the list of tickets and, optionally, the included       entities.</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on February 23, 2022 at 19:26 UTC</p>