---
sidebarDepth: 2
editLink: false
---
# SendGrid Tasks
---
Tasks for interacting with SendGrid.
 ## SendEmail
 <div class='class-sig' id='prefect-tasks-sendgrid-sendgrid-sendemail'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.sendgrid.sendgrid.SendEmail</p>(from_email=&quot;notifications@prefect.io&quot;, to_emails=None, subject=None, html_content=None, category=None, attachment_file_path=None, sendgrid_api_key=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/sendgrid/sendgrid.py#L9">[source]</a></span></div>

A task for sending an email via Twilio SendGrid.

**Args**:     <ul class="args"><li class="args">`from_email (str)`: The email address of the sender; defaults to notifications@prefect.io     </li><li class="args">`to_emails (Union[str, Tuple[str, str], List[str], List[Tuple[str, str]]])`:         The email address of the recipient(s); can also be provided at runtime.         Refer to [SendGrid-Python](https://github.com/sendgrid/sendgrid-python) for specifics.     </li><li class="args">`subject (str, optional)`: The subject of the email; can also be provided at runtime     </li><li class="args">`html_content (str)`: The html body of the email; can also be provided at runtime     </li><li class="args">`category (Union[str, List[str]], optional)`: The category/categories to use for the email;         can also be provided at runtime     </li><li class="args">`attachment_file_path (Union[str, Path], optional)`: The file path of the email attachment;         can also be provided at runtime     </li><li class="args">`sendgrid_api_key (str)`: The SendGrid API key used for authentication;         can also be provided at runtime, which is preferred since a secret can be used     </li><li class="args">`**kwargs (optional)`: additional kwargs to pass to the `Task` constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-sendgrid-sendgrid-sendemail-run'><p class="prefect-class">prefect.tasks.sendgrid.sendgrid.SendEmail.run</p>(from_email=&quot;notifications@prefect.io&quot;, to_emails=None, subject=None, html_content=None, category=None, attachment_file_path=None, sendgrid_api_key=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/sendgrid/sendgrid.py#L49">[source]</a></span></div>
<p class="methods">Run message which sends an email via SendGrid.<br><br>**Args**:     <ul class="args"><li class="args">`from_email (str)`: The email address of the sender;         defaults to the one provided at initialization     </li><li class="args">`to_emails (Union[str, Tuple[str, str], List[str], List[Tuple[str, str]]])`:         The email address of the recipient(s); defaults to the one provided at initialization.         Refer to [SendGrid-Python](https://github.com/sendgrid/sendgrid-python) for specifics.     </li><li class="args">`subject (str, optional)`: The subject of the email;         defaults to the one provided at initialization     </li><li class="args">`html_content (str)`: The html body of the email;         defaults to the one provided at initialization     </li><li class="args">`category (Union[str, List[str]], optional)`: The category/categories to use for the email;         defaults to those provided at initialization     </li><li class="args">`attachment_file_path (Union[str, Path], optional)`: The file path of the email attachment;         defaults to the one provided at initialization     </li><li class="args">`sendgrid_api_key (str, optional)`: The SendGrid API key used for authentication;         if not provided here, will use the value provided at initialization</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if no API key is provided</li></ul> **Returns**:     <ul class="args"><li class="args">`python_http_client.client.Response`:         A [Python-HTTP-Client](https://github.com/sendgrid/python-http-client) object         indicating the status of the response</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on February 23, 2022 at 19:26 UTC</p>