---
sidebarDepth: 2
editLink: false
---
# Prefect Tasks
---
Tasks for interacting with the Prefect API
 ## StartFlowRun
 <div class='class-sig' id='prefect-tasks-prefect-flow-run-startflowrun'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.prefect.flow_run.StartFlowRun</p>(flow_name=None, project_name=None, parameters=None, run_config=None, wait=False, new_flow_context=None, run_name=None, scheduled_start_time=None, poll_interval=datetime.timedelta(seconds=10), **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/prefect/flow_run.py#L282">[source]</a></span></div>

Task used to kick off a flow run using Prefect Core's server or Prefect Cloud.  If multiple versions of the flow are found, this task will kick off the most recent unarchived version.

**Args**:     <ul class="args"><li class="args">`flow_name (str, optional)`: the name of the flow to schedule; this value may also be         provided at run time     </li><li class="args">`project_name (str, optional)`: if running with Cloud as a backend, this is the project         in which the flow is located; this value may also be provided at runtime. If         running with Prefect Core's server as the backend, this should not be provided.     </li><li class="args">`parameters (dict, optional)`: the parameters to pass to the flow run being scheduled;         this value may also be provided at run time     </li><li class="args">`run_config (RunConfig, optional)`: a run-config to use for this flow         run, overriding any existing flow settings.     </li><li class="args">`wait (bool, optional)`: whether to wait the triggered flow run's state; if True, this         task will wait until the flow run is complete, and then reflect the corresponding         state as the state of this task.  Defaults to `False`.     </li><li class="args">`new_flow_context (dict, optional)`: the optional run context for the new flow run     </li><li class="args">`run_name (str, optional)`: name to be set for the flow run     </li><li class="args">`scheduled_start_time (datetime, optional)`: the time to schedule the execution         for; if not provided, defaults to now     </li><li class="args">`poll_interval (timedelta)`: the time to wait between each check if the flow is finished.             Has to be >= 3 seconds. Used only if `wait=True`. Defaults to 10 seconds.     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-prefect-flow-run-startflowrun-run'><p class="prefect-class">prefect.tasks.prefect.flow_run.StartFlowRun.run</p>(flow_name=None, project_name=None, parameters=None, run_config=None, new_flow_context=None, run_name=None, idempotency_key=None, scheduled_start_time=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/prefect/flow_run.py#L352">[source]</a></span></div>
<p class="methods">Run method for the task; responsible for scheduling the specified flow run.<br><br>**Args**:     <ul class="args"><li class="args">`flow_name (str, optional)`: the name of the flow to schedule; if not provided,         this method will use the flow name provided at initialization     </li><li class="args">`project_name (str, optional)`: the Cloud project in which the flow is located; if         not provided, this method will use the project provided at initialization. If         running with Prefect Core's server as the backend, this should not be provided.     </li><li class="args">`parameters (dict, optional)`: the parameters to pass to the flow run being         scheduled; if not provided, this method will use the parameters provided at         initialization     </li><li class="args">`run_config (RunConfig, optional)`: a run-config to use for this flow         run, overriding any existing flow settings.     </li><li class="args">`new_flow_context (dict, optional)`: the optional run context for the new flow run     </li><li class="args">`run_name (str, optional)`: name to be set for the flow run     </li><li class="args">`idempotency_key (str, optional)`: a unique idempotency key for scheduling the         flow run. Duplicate flow runs with the same idempotency key will only create         a single flow run. This is useful for ensuring that only one run is created         if this task is retried. If not provided, defaults to the active `task_run_id`.     </li><li class="args">`scheduled_start_time (datetime, optional)`: the time to schedule the execution         for; if not provided, defaults to now</li></ul> **Returns**:     <ul class="args"><li class="args">`str`: the ID of the newly-scheduled flow run</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if flow was not provided, cannot be found, or if a project name was         not provided while using Cloud as a backend</li></ul> **Example**:     <br><pre class="language-python"><code class="language-python">    <span class="token keyword">from</span> prefect.tasks.prefect.flow_run <span class="token keyword">import</span> StartFlowRun<br><br>    kickoff_task <span class="token operator">=</span> StartFlowRun<span class="token punctuation">(</span>project_name<span class="token operator">=</span><span class="token string">"</span><span class="token string">Hello, World!</span><span class="token string">"</span><span class="token punctuation">,</span> flow_name<span class="token operator">=</span><span class="token string">"</span><span class="token string">My Cloud Flow</span><span class="token string">"</span><span class="token punctuation">)</span><br>    <br></code></pre><br></p>|

---
<br>

 ## RenameFlowRun
 <div class='class-sig' id='prefect-tasks-prefect-flow-run-rename-renameflowrun'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.prefect.flow_run_rename.RenameFlowRun</p>(flow_run_id=None, flow_run_name=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/prefect/flow_run_rename.py#L9">[source]</a></span></div>

Task used to rename a running flow.

**Args**:     <ul class="args"><li class="args">`flow_run_id (str, optional)`: The ID of the flow run to rename.     </li><li class="args">`flow_run_name (str, optional)`: The new flow run name.     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-prefect-flow-run-rename-renameflowrun-run'><p class="prefect-class">prefect.tasks.prefect.flow_run_rename.RenameFlowRun.run</p>(flow_run_id, flow_run_name)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/prefect/flow_run_rename.py#L29">[source]</a></span></div>
<p class="methods">**Args**:     <ul class="args"><li class="args">`flow_run_id (str, optional)`: The ID of the flow run to rename. If `None`,         the `flow_run_id` from `prefect.context` will be used as default value     </li><li class="args">`flow_run_name (str, optional)`: The new flow run name</li></ul> **Returns**:     <ul class="args"><li class="args">`bool`: Boolean representing whether the flow run was renamed successfully or not.</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: If `flow_run_id` is not provided and `flow_run_id` does not exist         in `prefect.context`     </li><li class="args">`ValueError`: If `flow_run_name` is not provided</li></ul> **Example**:     <br><pre class="language-python"><code class="language-python">    <span class="token keyword">from</span> prefect.tasks.prefect.flow_rename <span class="token keyword">import</span> FlowRenameTask<br><br>    rename_flow <span class="token operator">=</span> FlowRenameTask<span class="token punctuation">(</span>flow_name<span class="token operator">=</span><span class="token string">"</span><span class="token string">A new flow run name</span><span class="token string">"</span><span class="token punctuation">)</span><br>    <br></code></pre><br></p>|

---
<br>

 ## CancelFlowRun
 <div class='class-sig' id='prefect-tasks-prefect-flow-run-cancel-cancelflowrun'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.prefect.flow_run_cancel.CancelFlowRun</p>(flow_run_id=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/prefect/flow_run_cancel.py#L9">[source]</a></span></div>

Task to cancel a flow run. If `flow_run_id` is not provided, `flow_run_id` from `prefect.context` will be used by default

**Args**:     <ul class="args"><li class="args">`flow_run_id (str, optional)`: The ID of the flow run to cancel     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-prefect-flow-run-cancel-cancelflowrun-run'><p class="prefect-class">prefect.tasks.prefect.flow_run_cancel.CancelFlowRun.run</p>(flow_run_id=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/prefect/flow_run_cancel.py#L27">[source]</a></span></div>
<p class="methods">**Args**:     <ul class="args"><li class="args">`flow_run_id (str, optional)`: The ID of the flow run to cancel</li></ul> **Returns**:     <ul class="args"><li class="args">`bool`: Whether the flow run was canceled successfully or not</li></ul></p>|

---
<br>

 ### create_flow_run
 <div class='method-sig' id='prefect-tasks-prefect-flow-run-create-flow-run'><p class="prefect-class">prefect.tasks.prefect.flow_run.create_flow_run</p>(flow_id=None, flow_name=None, project_name=&quot;&quot;, parameters=None, context=None, labels=None, run_name=None, run_config=None, scheduled_start_time=None, idempotency_key=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/prefect/flow_run.py#L62">[source]</a></span></div>

Task to create a flow run in the Prefect backend.

The flow to run must be registered and an agent must be available to deploy the flow run.

**Args**:     <ul class="args"><li class="args">`flow_id`: The flow or flow group uuid to lookup the flow to run     </li><li class="args">`flow_name`: The flow name to lookup the flow to run     </li><li class="args">`project_name`: The project name to lookup the flow to run. For use with         `flow_name` if you have flows with the same name in multiple projects     </li><li class="args">`parameters`: An optional dictionary of parameters to pass to the flow run     </li><li class="args">`context`: An optional dictionary of context variables to pass to the flow run     </li><li class="args">`labels`: An optional iterable of labels to set on the flow run; if not         provided, the default set of labels for the flow will be used     </li><li class="args">`run_name`: An optional name for the flow run; if not provided, the name will         be generated as "{current_run_name}-{flow_name}"     </li><li class="args">`run_config`: An optional run config to use for the flow run; will override any         existing run config settings     </li><li class="args">`scheduled_start_time`: An optional time in the future to schedule flow run         execution for. If not provided, the flow run will be scheduled to start now     </li><li class="args">`idempotency_key`: a unique idempotency key for scheduling the         flow run. Duplicate flow runs with the same idempotency key will only create         a single flow run. This is useful for ensuring that only one run is created         if this task is retried. If not provided, defaults to the active `task_run_id`.</li></ul> **Returns**:     str: The UUID of the created flow run

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-prefect-flow-run-create-flow-run'><p class="prefect-class">prefect.tasks.prefect.flow_run.create_flow_run</p>(flow_id=None, flow_name=None, project_name=&quot;&quot;, parameters=None, context=None, labels=None, run_name=None, run_config=None, scheduled_start_time=None, idempotency_key=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/prefect/flow_run.py#L62">[source]</a></span></div>
<p class="methods">Task to create a flow run in the Prefect backend.<br><br>The flow to run must be registered and an agent must be available to deploy the flow run.<br><br>**Args**:     <ul class="args"><li class="args">`flow_id`: The flow or flow group uuid to lookup the flow to run     </li><li class="args">`flow_name`: The flow name to lookup the flow to run     </li><li class="args">`project_name`: The project name to lookup the flow to run. For use with         `flow_name` if you have flows with the same name in multiple projects     </li><li class="args">`parameters`: An optional dictionary of parameters to pass to the flow run     </li><li class="args">`context`: An optional dictionary of context variables to pass to the flow run     </li><li class="args">`labels`: An optional iterable of labels to set on the flow run; if not         provided, the default set of labels for the flow will be used     </li><li class="args">`run_name`: An optional name for the flow run; if not provided, the name will         be generated as "{current_run_name}-{flow_name}"     </li><li class="args">`run_config`: An optional run config to use for the flow run; will override any         existing run config settings     </li><li class="args">`scheduled_start_time`: An optional time in the future to schedule flow run         execution for. If not provided, the flow run will be scheduled to start now     </li><li class="args">`idempotency_key`: a unique idempotency key for scheduling the         flow run. Duplicate flow runs with the same idempotency key will only create         a single flow run. This is useful for ensuring that only one run is created         if this task is retried. If not provided, defaults to the active `task_run_id`.</li></ul> **Returns**:     str: The UUID of the created flow run</p>|

---
<br>

 ### get_task_run_result
 <div class='method-sig' id='prefect-tasks-prefect-flow-run-get-task-run-result'><p class="prefect-class">prefect.tasks.prefect.flow_run.get_task_run_result</p>(flow_run_id, task_slug, map_index=-1, poll_time=5)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/prefect/flow_run.py#L170">[source]</a></span></div>

Task to get the result of a task from a flow run.

Will wait for the flow run to finish entirely or dynamic task run results will not be properly populated.

Results are loaded from the `Result` location of the task which may not be accessible from where this task is executed. You will need to ensure results can be accessed.

**Args**:     <ul class="args"><li class="args">`flow_run_id`: The flow run the task run belongs to     </li><li class="args">`task_slug`: The 'slug' of the task run you want to get the result of     </li><li class="args">`map_index`: If the task is mapped, the index you would like to access. By         default, if given a mapped task, all of the child results will be loaded.     </li><li class="args">`poll_time`: The amount of time to wait while polling to check if the sub-flow         has finished</li></ul> **Returns**:     Any: The return value of the task

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-prefect-flow-run-get-task-run-result'><p class="prefect-class">prefect.tasks.prefect.flow_run.get_task_run_result</p>(flow_run_id, task_slug, map_index=-1, poll_time=5)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/prefect/flow_run.py#L170">[source]</a></span></div>
<p class="methods">Task to get the result of a task from a flow run.<br><br>Will wait for the flow run to finish entirely or dynamic task run results will not be properly populated.<br><br>Results are loaded from the `Result` location of the task which may not be accessible from where this task is executed. You will need to ensure results can be accessed.<br><br>**Args**:     <ul class="args"><li class="args">`flow_run_id`: The flow run the task run belongs to     </li><li class="args">`task_slug`: The 'slug' of the task run you want to get the result of     </li><li class="args">`map_index`: If the task is mapped, the index you would like to access. By         default, if given a mapped task, all of the child results will be loaded.     </li><li class="args">`poll_time`: The amount of time to wait while polling to check if the sub-flow         has finished</li></ul> **Returns**:     Any: The return value of the task</p>|

---
<br>

 ### wait_for_flow_run
 <div class='method-sig' id='prefect-tasks-prefect-flow-run-wait-for-flow-run'><p class="prefect-class">prefect.tasks.prefect.flow_run.wait_for_flow_run</p>(flow_run_id, stream_states=True, stream_logs=False, raise_final_state=False)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/prefect/flow_run.py#L236">[source]</a></span></div>

Task to wait for a flow run to finish executing, streaming state and log information

**Args**:     <ul class="args"><li class="args">`flow_run_id`: The flow run id to wait for     </li><li class="args">`stream_states`: Stream information about the flow run state changes     </li><li class="args">`stream_logs`: Stream flow run logs; if `stream_state` is `False` this will be         ignored     </li><li class="args">`raise_final_state`: If set, the state of this task will be set to the final         state of the child flow run on completion.</li></ul> **Returns**:     FlowRunView: A view of the flow run after completion

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-prefect-flow-run-wait-for-flow-run'><p class="prefect-class">prefect.tasks.prefect.flow_run.wait_for_flow_run</p>(flow_run_id, stream_states=True, stream_logs=False, raise_final_state=False)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/prefect/flow_run.py#L236">[source]</a></span></div>
<p class="methods">Task to wait for a flow run to finish executing, streaming state and log information<br><br>**Args**:     <ul class="args"><li class="args">`flow_run_id`: The flow run id to wait for     </li><li class="args">`stream_states`: Stream information about the flow run state changes     </li><li class="args">`stream_logs`: Stream flow run logs; if `stream_state` is `False` this will be         ignored     </li><li class="args">`raise_final_state`: If set, the state of this task will be set to the final         state of the child flow run on completion.</li></ul> **Returns**:     FlowRunView: A view of the flow run after completion</p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on February 23, 2022 at 19:26 UTC</p>