---
sidebarDepth: 2
editLink: false
---
# Mixpanel Tasks
---
This module contains a collection of tasks to interact with Mixpanel APIs.
 ## MixpanelExportTask
 <div class='class-sig' id='prefect-tasks-mixpanel-mixpanel-tasks-mixpanelexporttask'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.mixpanel.mixpanel_tasks.MixpanelExportTask</p>(api_secret=None, api_secret_env_var=None, from_date=&quot;2011-07-10&quot;, to_date=&quot;2022-02-23&quot;, limit=None, event=None, where=None, parse_response=False, use_eu_server=False, group_events=False, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/mixpanel/mixpanel_tasks.py#L15">[source]</a></span></div>

Task for performing an export using the Mixpanel Export API. More info about the API can be found at https://developer.mixpanel.com/reference/raw-event-export.

**Args**:     <ul class="args"><li class="args">`api_secret (str, optional)`: The API secret key to use to authenticate         to Mixpanel. Can be provided also via env var.     </li><li class="args">`api_secret_env_var (str, optional)`: The name of the env var that contains         the API secret key to use to authenticate to Mixpanel.         `api_secret` takes precedence over `api_secret_env_var`.     </li><li class="args">`from_date (str, optional)`: Start date of the export request.         If provided as a string, it should be in the format `YYYY-MM-DD`.         Default value is `2011-07-10`. This date is inclusive.     </li><li class="args">`to_date (str, optional)`: End date of the export request.         If provided as a string, it should be in the format `YYYY-MM-DD`.         Default value is `prefect.context.today`. This date is inclusive.     </li><li class="args">`limit (int, optional)`: The max number of events to return.     </li><li class="args">`event (str, list, optional)`: The event, or events, that you wish         to get the data for.     </li><li class="args">`where (str, optional)`: An expression to filter events by.         More info on expression sequence structure can be found         at https://developer.mixpanel.com/reference/segmentation-expressions.     </li><li class="args">`parse_response (bool, optional)`: Whether to parse the response into a JSON object.         Default value is `False`.     </li><li class="args">`use_eu_server (bool, optional)`: Whether to use the Mixpanel EU server to retrieve data.         More info at https://help.mixpanel.com/hc/en-us/articles/360039135652-Data-Residency-in-EU.         Default is `False`.     </li><li class="args">`group_events`: Whether to group events with the same name.         This is taken into account only if `parse_response` is True.     </li><li class="args">`**kwargs (dict, optional)`: Additional keyword arguments to pass to the         Task constructor.</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-mixpanel-mixpanel-tasks-mixpanelexporttask-run'><p class="prefect-class">prefect.tasks.mixpanel.mixpanel_tasks.MixpanelExportTask.run</p>(api_secret=None, api_secret_env_var=None, from_date=None, to_date=None, limit=None, event=None, where=None, parse_response=False, use_eu_server=False, group_events=False)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/mixpanel/mixpanel_tasks.py#L75">[source]</a></span></div>
<p class="methods">Task run method to request a data export from Mixpanel using the Export API.<br><br>**Args**:     <ul class="args"><li class="args">`api_secret (str, optional)`: The API secret key to use to authenticate         to Mixpanel. Can be provided also via env var.     </li><li class="args">`api_secret_env_var (str, optional)`: The name of the env var that contains         the API secret key to use to authenticate to Mixpanel.         `api_secret` takes precedence over `api_secret_env_var`.     </li><li class="args">`from_date (str, optional)`: Start date of the export request.         If provided as a string, it should be in the format `YYYY-MM-DD`.         Default value is `2011-07-10`. This date is inclusive.     </li><li class="args">`to_date (str, optional)`: End date of the export request.         If provided as a string, it should be in the format `YYYY-MM-DD`.         Default value is `prefect.context.today`. This date is inclusive.     </li><li class="args">`limit (int, optional)`: The max number of events to return.     </li><li class="args">`event (str, list, optional)`: The event, or events, that you wish         to get the data for.     </li><li class="args">`where (str, optional)`: An expression to filter events by.         More info on expression sequence structure can be found         at https://developer.mixpanel.com/reference/segmentation-expressions.     </li><li class="args">`parse_response (bool, optional)`: Whether to parse the response into a JSON object.         Default value is `False`.     </li><li class="args">`use_eu_server (bool, optional)`: Whether to use the Mixpanel EU server to retrieve data.         More info at         https://help.mixpanel.com/hc/en-us/articles/360039135652-Data-Residency-in-EU.         Default is `False`.     </li><li class="args">`group_events`: Whether to group events with the same name.         This is taken into account only if `parse_response is True`.</li></ul> **Returns**:     <ul class="args"><li class="args">if `parse_response` is False, then returns a `str` response pulled         from the Export API, (which is basically a JSONL string).     - if `parse_response` is True and `group_events` is True, then returns a `dict` where         each key contains homogeneous events.     - if `parse_response` is True and `group_events` is False, then returns         a `list` of JSON objects obtained by parsing the response.</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError` if both `api_secret` and `api_secret_env_var` are missing.     - `ValueError` if `api_secret` is missing and `api_secret_env_var` is not found.     - `prefect.engine.signals.FAIL` if the Mixpanel API returns an error.</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on February 23, 2022 at 19:26 UTC</p>