---
sidebarDepth: 2
editLink: false
---
# Cube.js Tasks
---
This is a collection of tasks to interact with a Cube.js or Cube Cloud environment.
 ## CubeJSQueryTask
 <div class='class-sig' id='prefect-tasks-cubejs-cubejs-tasks-cubejsquerytask'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.cubejs.cubejs_tasks.CubeJSQueryTask</p>(subdomain=None, url=None, api_secret=None, api_secret_env_var=&quot;CUBEJS_API_SECRET&quot;, query=None, security_context=None, wait_time_between_api_calls=10, max_wait_time=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/cubejs/cubejs_tasks.py#L12">[source]</a></span></div>

This task calls Cueb.js load API and returns the result as a JSON object. More info about Cube.js load API at https://cube.dev/docs/rest-api#api-reference-v-1-load.

**Args**:     <ul class="args"><li class="args">`subdomain (str, optional)`: The subdomain to use to get the data.         If provided, `subdomain` takes precedence over `url`.         This is likely to be useful to Cube Cloud users.     </li><li class="args">`url (str, optional)`: The URL to use to get the data.         This is likely to be useful to users of self-hosted Cube.js.     </li><li class="args">`api_secret (str, optional)`: The API secret used to generate an         API token for authentication.         If provided, it takes precedence over `api_secret_env_var`.     </li><li class="args">`api_secret_env_var (str, optional)`: The name of the env var that contains         the API secret to use to generate an API token for authentication.         Defaults to `CUBEJS_API_SECRET`.     </li><li class="args">`query (dict, list, optional)`: `dict` or `list` representing         valid Cube.js queries.         If you pass multiple queries, then be aware of Cube.js Data Blending.         More info at https://cube.dev/docs/rest-api#api-reference-v-1-load         and at https://cube.dev/docs/schema/advanced/data-blending.         Query format can be found at: https://cube.dev/docs/query-format.     </li><li class="args">`security_context (str, dict, optional)`: The security context to use         during authentication.         If the security context does not contain an expiration period,         then a 7-day expiration period is added automatically.         More info at: https://cube.dev/docs/security/context.     </li><li class="args">`wait_time_between_api_calls (int, optional)`: The number of seconds to         wait between API calls.         Default to 10.     </li><li class="args">`max_wait_time (int, optional)`: The number of seconds to wait for the         Cube.js load API to return a response.     </li><li class="args">`**kwargs (optional)`: Additional keyword arguments to pass to the         standard Task initalization.</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-cubejs-cubejs-tasks-cubejsquerytask-run'><p class="prefect-class">prefect.tasks.cubejs.cubejs_tasks.CubeJSQueryTask.run</p>(subdomain=None, url=None, api_secret=None, api_secret_env_var=&quot;CUBEJS_API_SECRET&quot;, query=None, security_context=None, wait_time_between_api_calls=10, max_wait_time=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/cubejs/cubejs_tasks.py#L77">[source]</a></span></div>
<p class="methods">Task run method to perform a query using Cube.js load API.<br><br>**Args**:     <ul class="args"><li class="args">`subdomain (str, optional)`: The subdomain to use to get the data.         If provided, `subdomain` takes precedence over `url`.         This is likely to be useful to Cube Cloud users.     </li><li class="args">`url (str, optional)`: The URL to use to get the data.         This is likely to be useful to users of self-hosted Cube.js.     </li><li class="args">`api_secret (str, optional)`: The API secret used to generate an         API token for authentication.         If provided, it takes precedence over `api_secret_env_var`.     </li><li class="args">`api_secret_env_var (str, optional)`: The name of the env var that contains         the API secret to use to generate an API token for authentication.         Defaults to `CUBEJS_API_SECRET`.     </li><li class="args">`query (dict, list, optional)`: `dict` or `list` representing         valid Cube.js queries.         If you pass multiple queries, then be aware of Cube.js Data Blending.         More info at https://cube.dev/docs/rest-api#api-reference-v-1-load         and at https://cube.dev/docs/schema/advanced/data-blending.         Query format can be found at: https://cube.dev/docs/query-format.     </li><li class="args">`security_context (str, dict, optional)`: The security context to use         during authentication.         If the security context does not contain an expiration period,         then a 7-day expiration period is added automatically.         More info at https://cube.dev/docs/security/context.     </li><li class="args">`wait_time_between_api_calls (int, optional)`: The number of seconds to         wait between API calls.         Default to 10.     </li><li class="args">`max_wait_time (int, optional)`: The number of seconds to wait for the         Cube.js load API to return a response.</li></ul> **Raises**:     <ul class="args"><li class="args">ValueError if both `subdomain` and `url` are missing.     - ValueError if `api_token` is missing and `api_token_env_var` cannot be found.     - ValueError if `query` is missing.     - `prefect.engine.signals.FAIL` if the Cube.js load API fails.     - `prefect.engine.signals.FAIL` if the Cube.js load API takes more than         `max_wait_time` seconds to respond.</li></ul><br><br>**Returns**:     <ul class="args"><li class="args">The Cube.js JSON response.</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on February 23, 2022 at 19:26 UTC</p>