---
sidebarDepth: 2
editLink: false
---
# Census Tasks
---
This module contains a task for starting and monitoring [Census](https://getcensus.com/) sync jobs
 ## CensusSyncTask
 <div class='class-sig' id='prefect-tasks-census-census-censussynctask'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.census.census.CensusSyncTask</p>(api_trigger=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/census/census.py#L13">[source]</a></span></div>

Task for running Census connector sync jobs.

This task assumes the user has a Census sync already configured and is attempting to orchestrate the sync using Prefect task to send a post to the API within a prefect flow. Copy and paste from the api trigger section on the configuration page in the `api_trigger` param to set a default sync.

**Args**:     <ul class="args"><li class="args">`api_trigger (str, optional)`: default sync to trigger, if none is specified in `run`     </li><li class="args">`**kwargs (dict, optional)`: additional kwargs to pass to the base Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-census-census-censussynctask-check-invalid-api'><p class="prefect-class">prefect.tasks.census.census.CensusSyncTask.check_invalid_api</p>(api_trigger)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/census/census.py#L116">[source]</a></span></div>
<p class="methods">Makes sure the url for the api trigger matches the Census format specified below. If it does not, it will raise a ValueError before returning.<br><br>Format of api_trigger:     - "https://bearer:secret-token:s3cr3t@app.getcensus.com/api/v1/syncs/123/trigger"<br><br>**Args**:     <ul class="args"><li class="args">`api_trigger (str)`: if specified in the constructor, will call this validation there</li></ul> **Returns**:     <ul class="args"><li class="args">`confirmed_pattern (Match Object`: https://docs.python.org/3/library/re.html#match-objects)</li></ul></p>|
 | <div class='method-sig' id='prefect-tasks-census-census-censussynctask-run'><p class="prefect-class">prefect.tasks.census.census.CensusSyncTask.run</p>(api_trigger, poll_status_every_n_seconds=60)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/census/census.py#L32">[source]</a></span></div>
<p class="methods">Task run method for Census syncs.<br><br>An invocation of `run` will attempt to start a sync job for the specified `api_trigger`. `run` will poll Census for the sync status, and will only complete when the sync has completed or when it receives an error status code from the trigger API call.<br><br>**Args**:     <ul class="args"><li class="args">`api_trigger (str)`: if not specified in run, it will pull from the default for the         CensusSyncTask constructor. Keyword argument.     </li><li class="args">`poll_status_every_n_seconds (int, optional)`: this task polls the Census API for the sync's         status. If provided, this value will override the default polling time of         60 seconds and it has a minimum wait time of 5 seconds. Keyword argument.</li></ul> **Returns**:     <ul class="args"><li class="args">`dict`: dictionary of statistics returned by Census on the specified sync, structure below.</li></ul> Structure:     <br><pre class="language-python"><code class="language-python">    <span class="token punctuation">{</span><br>        <span class="token string">'</span><span class="token string">error_message</span><span class="token string">'</span><span class="token punctuation">:</span> <span class="token keyword">None</span> <span class="token operator">/</span> <span class="token builtin">str</span><span class="token punctuation">,</span><br>        <span class="token string">'</span><span class="token string">records_failed</span><span class="token string">'</span><span class="token punctuation">:</span> <span class="token builtin">int</span> <span class="token operator">/</span> <span class="token keyword">None</span><span class="token punctuation">,</span><br>        <span class="token string">'</span><span class="token string">records_invalid</span><span class="token string">'</span><span class="token punctuation">:</span> <span class="token builtin">int</span> <span class="token operator">/</span> <span class="token keyword">None</span><span class="token punctuation">,</span><br>        <span class="token string">'</span><span class="token string">records_processed</span><span class="token string">'</span><span class="token punctuation">:</span> <span class="token builtin">int</span> <span class="token operator">/</span> <span class="token keyword">None</span><span class="token punctuation">,</span><br>        <span class="token string">'</span><span class="token string">records_updated</span><span class="token string">'</span><span class="token punctuation">:</span> <span class="token builtin">int</span> <span class="token operator">/</span> <span class="token keyword">None</span><span class="token punctuation">,</span><br>        <span class="token string">'</span><span class="token string">status</span><span class="token string">'</span><span class="token punctuation">:</span> <span class="token string">'</span><span class="token string">completed</span><span class="token string">'</span><span class="token operator">/</span><span class="token string">'</span><span class="token string">working</span><span class="token string">'</span><span class="token operator">/</span><span class="token string">'</span><span class="token string">failed</span><span class="token string">'</span><br>    <span class="token punctuation">}</span><br>    <br></code></pre><br></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on February 23, 2022 at 19:26 UTC</p>