---
sidebarDepth: 2
editLink: false
---
# Filters
---
Schedule filters are functions that accept a candidate `datetime` and return `True` if
the candidate is valid, and `False` otherwise.

Filters have the signature `Callable[[datetime], bool]`.

## Functions
|top-level functions: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-schedules-filters-at-time'><p class="prefect-class">prefect.schedules.filters.at_time</p>(t)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/schedules/filters.py#L99">[source]</a></span></div>
<p class="methods">Filter that allows events that match a specific time.<br><br>For example, `at_time(datetime.time(4))` would only allow runs at 4 AM in the given timezone.<br><br>**Args**:     <ul class="args"><li class="args">`t (time)`: the time to match</li></ul> **Returns**:     <ul class="args"><li class="args">`Callable[[datetime], bool]`: a filter function</li></ul></p>|
 | <div class='method-sig' id='prefect-schedules-filters-between-datetimes'><p class="prefect-class">prefect.schedules.filters.between_datetimes</p>(start, end)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/schedules/filters.py#L31">[source]</a></span></div>
<p class="methods">Filter that allows events between a start time and end time<br><br>**Args**:     <ul class="args"><li class="args">`start (datetime)`: the start datetime     </li><li class="args">`end (datetime)`: the end datetime</li></ul> **Returns**:     <ul class="args"><li class="args">`Callable[[datetime], bool]`: a filter function</li></ul></p>|
 | <div class='method-sig' id='prefect-schedules-filters-between-dates'><p class="prefect-class">prefect.schedules.filters.between_dates</p>(start_month, start_day, end_month, end_day)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/schedules/filters.py#L67">[source]</a></span></div>
<p class="methods">Filter that allows events between specific dates in each year.<br><br>For example, `between_dates(10, 15, 3, 31)` would only allow dates between October 15 and March 31 in any year.<br><br>**Args**:     <ul class="args"><li class="args">`start_month (int)`: the starting month, as a number (1 = January)     </li><li class="args">`start_day (int)`: the starting day, as a number     </li><li class="args">`end_month (int)`: the ending month, as a number     </li><li class="args">`end_day (int)`: the ending day, as a number</li></ul> **Returns**:     <ul class="args"><li class="args">`Callable[[datetime], bool]`: a filter function</li></ul></p>|
 | <div class='method-sig' id='prefect-schedules-filters-between-times'><p class="prefect-class">prefect.schedules.filters.between_times</p>(start, end)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/schedules/filters.py#L119">[source]</a></span></div>
<p class="methods">Filter that allows events between a start time and end time<br><br>For example, `between_times(start=datetime.time(14), end=datetime.time(16))` would only allow runs between the hours of 2 PM and 4 PM in the given timezone.<br><br>**Args**:     <ul class="args"><li class="args">`start (time)`: the start time     </li><li class="args">`end (time)`: the end time</li></ul> **Returns**:     <ul class="args"><li class="args">`Callable[[datetime], bool]`: a filter function</li></ul></p>|
 | <div class='method-sig' id='prefect-schedules-filters-is-weekday'><p class="prefect-class">prefect.schedules.filters.is_weekday</p>(dt)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/schedules/filters.py#L146">[source]</a></span></div>
<p class="methods">Filter that only allows events on weekdays<br><br>**Args**:     <ul class="args"><li class="args">`dt (datetime)`: the candidate datetime</li></ul> **Returns**:     <ul class="args"><li class="args">`bool`: True if the date is a weekday; False otherwise</li></ul></p>|
 | <div class='method-sig' id='prefect-schedules-filters-is-weekend'><p class="prefect-class">prefect.schedules.filters.is_weekend</p>(dt)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/schedules/filters.py#L173">[source]</a></span></div>
<p class="methods">Filter that only allows events on weekends<br><br>**Args**:     <ul class="args"><li class="args">`dt (datetime)`: the candidate datetime</li></ul> **Returns**:     <ul class="args"><li class="args">`bool`: True if the date is a weekend; False otherwise</li></ul></p>|
 | <div class='method-sig' id='prefect-schedules-filters-is-day-of-week'><p class="prefect-class">prefect.schedules.filters.is_day_of_week</p>(day_of_week)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/schedules/filters.py#L186">[source]</a></span></div>
<p class="methods">Filter that only matches on a specific day of the week.<br><br>**Args**:     <ul class="args"><li class="args">`day_of_week (int)`: the integer day of the week to match on (0 - 6 == Sunday - Saturday)</li></ul> **Returns**:     <ul class="args"><li class="args">`Callable[[datetime], bool]`: a filter function</li></ul></p>|
 | <div class='method-sig' id='prefect-schedules-filters-is-month-end'><p class="prefect-class">prefect.schedules.filters.is_month_end</p>(dt)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/schedules/filters.py#L159">[source]</a></span></div>
<p class="methods">Filter that only allows events on the last day of the month<br><br>**Args**:     <ul class="args"><li class="args">`dt (datetime)`: the candidate datetime</li></ul> **Returns**:     <ul class="args"><li class="args">`bool`: True if the date is a month-end; False otherwise</li></ul></p>|
 | <div class='method-sig' id='prefect-schedules-filters-is-month-start'><p class="prefect-class">prefect.schedules.filters.is_month_start</p>(dt)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/schedules/filters.py#L205">[source]</a></span></div>
<p class="methods">Filter that only matches on the first day of the month<br><br>**Args**:     <ul class="args"><li class="args">`dt (datetime)`: the candidate datetime</li></ul> **Returns**:     <ul class="args"><li class="args">`bool`: True if date is the first day of the month, False otherwise</li></ul></p>|

<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on February 23, 2022 at 19:26 UTC</p>