---
sidebarDepth: 2
editLink: false
---
# ECS Agent
---
 ## ECSAgent
 <div class='class-sig' id='prefect-agent-ecs-agent-ecsagent'><p class="prefect-sig">class </p><p class="prefect-class">prefect.agent.ecs.agent.ECSAgent</p>(agent_config_id=None, name=None, labels=None, env_vars=None, max_polls=None, agent_address=None, no_cloud_logs=None, task_definition_path=None, run_task_kwargs_path=None, aws_access_key_id=None, aws_secret_access_key=None, aws_session_token=None, region_name=None, cluster=None, launch_type=None, task_role_arn=None, execution_role_arn=None, botocore_config=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/agent/ecs/agent.py#L68">[source]</a></span></div>

Agent which deploys flow runs as ECS tasks.

**Args**:     <ul class="args"><li class="args">`agent_config_id (str, optional)`: An optional agent configuration ID         that can be used to set configuration based on an agent from a         backend API. If set all configuration values will be pulled from         the backend agent configuration.     </li><li class="args">`name (str, optional)`: An optional name to give this agent. Can also         be set through the environment variable `PREFECT__CLOUD__AGENT__NAME`.         Defaults to "agent".     </li><li class="args">`labels (List[str], optional)`: A list of labels, which are arbitrary         string identifiers used by Prefect Agents when polling for work.     </li><li class="args">`env_vars (dict, optional)`: A dictionary of environment variables and         values that will be set on each flow run that this agent submits         for execution.     </li><li class="args">`max_polls (int, optional)`: Maximum number of times the agent will         poll Prefect Cloud for flow runs; defaults to infinite.     </li><li class="args">`agent_address (str, optional)`:  Address to serve internal api at.         Currently this is just health checks for use by an orchestration         layer. Leave blank for no api server (default).     </li><li class="args">`no_cloud_logs (bool, optional)`: Disable logging to a Prefect backend         for this agent and all deployed flow runs. Defaults to `False`.     </li><li class="args">`task_definition_path (str, optional)`: Path to a task definition         template to use when defining new tasks. If not provided, the         default template will be used.     </li><li class="args">`run_task_kwargs_path (str, optional)`: Path to a `yaml` file         containing default kwargs to pass to `ECS.client.run_task`. May be         a local path, or a remote path on e.g. `s3`.     </li><li class="args">`aws_access_key_id (str, optional)`: AWS access key id for connecting         the boto3 client. If not provided, will be loaded from your         environment (via either the `AWS_ACCESS_KEY_ID` environment         variable, or the `~/.aws/config` file). See         [the boto3 credentials docs][1] for more information.     </li><li class="args">`aws_secret_access_key (str, optional)`: AWS secret access key for         connecting the boto3 client. If not provided, will be loaded from         your environment (via either the `AWS_SECRET_ACCESS_KEY`         environment variable, or the `~/.aws/config` file).         See [the boto3 credentials docs][1] for more information.     </li><li class="args">`aws_session_token (str, optional)`: AWS session key for connecting the         boto3 client. If not provided, will be loaded from your environment         (via either the `AWS_SESSION_TOKEN` environment variable, or the         `~/.aws/config` file). See [the boto3 credentials docs][1] for more         information.     </li><li class="args">`region_name (str, optional)`: AWS region name to launch ECS tasks in.         If not provided, will be loaded from your environment (via either         the `AWS_DEFAULT_REGION` environment variable, or the         `~/.aws/config` file). See [the boto3 configuration docs][2] for         more information.     </li><li class="args">`cluster (str, optional)`: The AWS cluster to use, defaults to         `"default"` if not provided.     </li><li class="args">`launch_type (str, optional)`: The launch type to use, either         `"FARGATE"` (default) or `"EC2"`.     </li><li class="args">`task_role_arn (str, optional)`: The default task role ARN to use when         registering ECS tasks created by this agent.     </li><li class="args">`execution_role_arn (str, optional)`: The default execution role ARN         to use when registering ECS tasks created by this agent.     </li><li class="args">`botocore_config (dict, optional)`: Additional botocore configuration         options to be passed to the boto3 client. See [the boto3         configuration docs][2] for more information.</li></ul>

[1]: https://boto3.amazonaws.com/v1/documentation/api/latest/guide/credentials.html

[2]: https://boto3.amazonaws.com/v1/documentation/api/latest/guide/configuration.html

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-agent-agent-agent-start'><p class="prefect-class">prefect.agent.agent.Agent.start</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/agent/agent.py#L180">[source]</a></span></div>
<p class="methods">The main entrypoint to the agent process. Sets up the agent then continuously polls for work to submit.<br><br>This is the only method that should need to be called externally.</p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on February 23, 2022 at 19:26 UTC</p>