---
sidebarDepth: 2
editLink: false
---
# SQL Server Tasks
---
This module contains a collection of tasks for interacting with SQL Server databases via
the pyodbc library.
 ## SqlServerExecute
 <div class='class-sig' id='prefect-tasks-sql-server-sql-server-sqlserverexecute'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.sql_server.sql_server.SqlServerExecute</p>(db_name, user, host, port=1433, driver=&quot;ODBC Driver 17 for SQL Server&quot;, query=None, data=None, commit=False, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/sql_server/sql_server.py#L7">[source]</a></span></div>

Task for executing a query against a SQL Server database.

**Args**:     <ul class="args"><li class="args">`db_name (str)`: name of SQL Server database     </li><li class="args">`user (str)`: user name used to authenticate     </li><li class="args">`host (str)`: database host address     </li><li class="args">`port (int, optional)`: port used to connect to SQL Server database, defaults to 1433 if         not provided     </li><li class="args">`driver (str, optional)`: driver used to communicate with SQL Server database     </li><li class="args">`query (str, optional)`: query to execute against database     </li><li class="args">`data (tuple, optional)`: values to use in query, must be specified using placeholder         is query string     </li><li class="args">`commit (bool, optional)`: set to True to commit transaction, defaults to false     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-sql-server-sql-server-sqlserverexecute-run'><p class="prefect-class">prefect.tasks.sql_server.sql_server.SqlServerExecute.run</p>(query=None, data=None, commit=False, password=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/sql_server/sql_server.py#L48">[source]</a></span></div>
<p class="methods">Task run method. Executes a query against SQL Server database.<br><br>**Args**:     <ul class="args"><li class="args">`query (str, optional)`: query to execute against database     </li><li class="args">`data (tuple, optional)`: values to use in query, must be specified using         placeholder is query string     </li><li class="args">`commit (bool, optional)`: set to True to commit transaction, defaults to false     </li><li class="args">`password (str)`: password used to authenticate; should be provided from a `Secret` task</li></ul> **Returns**:     <ul class="args"><li class="args">None</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if query parameter is None or a blank string     </li><li class="args">`DatabaseError`: if exception occurs when executing the query</li></ul></p>|

---
<br>

 ## SqlServerExecuteMany
 <div class='class-sig' id='prefect-tasks-sql-server-sql-server-sqlserverexecutemany'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.sql_server.sql_server.SqlServerExecuteMany</p>(db_name, user, host, port=1433, driver=&quot;ODBC Driver 17 for SQL Server&quot;, query=None, data=None, commit=False, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/sql_server/sql_server.py#L103">[source]</a></span></div>

Task for executing many queries against a SQL Server database.

**Args**:     <ul class="args"><li class="args">`db_name (str)`: name of SQL Server database     </li><li class="args">`user (str)`: user name used to authenticate     </li><li class="args">`host (str)`: database host address     </li><li class="args">`port (int, optional)`: port used to connect to SQL Server database, defaults to 1433 if         not provided     </li><li class="args">`driver (str, optional)`: driver used to communicate with SQL Server database     </li><li class="args">`query (str, optional)`: query to execute against database     </li><li class="args">`data (tuple, optional)`: values to use in query, must be specified using placeholder         is query string     </li><li class="args">`commit (bool, optional)`: set to True to commit transaction, defaults to false     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-sql-server-sql-server-sqlserverexecutemany-run'><p class="prefect-class">prefect.tasks.sql_server.sql_server.SqlServerExecuteMany.run</p>(query=None, data=None, commit=False, password=None, fast_executemany=False)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/sql_server/sql_server.py#L144">[source]</a></span></div>
<p class="methods">Task run method. Executes many queries against SQL Server database.<br><br>**Args**:     <ul class="args"><li class="args">`query (str, optional)`: query to execute against database     </li><li class="args">`data (List[tuple], optional)`: list of values to use in query, must be specified using         placeholder     </li><li class="args">`commit (bool, optional)`: set to True to commit transaction, defaults to false     </li><li class="args">`password (str)`: password used to authenticate; should be provided from a `Secret` task     </li><li class="args">`fast_executemany (bool, optional)`: sends all params to the DB server in one bundle with         the SQL statement. DB executes the SQL against all the params as one DB transaction</li></ul> **Returns**:     <ul class="args"><li class="args">None</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if query parameter is None or a blank string     </li><li class="args">`DatabaseError`: if exception occurs when executing the query</li></ul></p>|

---
<br>

 ## SqlServerFetch
 <div class='class-sig' id='prefect-tasks-sql-server-sql-server-sqlserverfetch'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.sql_server.sql_server.SqlServerFetch</p>(db_name, user, host, port=1433, driver=&quot;ODBC Driver 17 for SQL Server&quot;, fetch=&quot;one&quot;, fetch_count=10, query=None, data=None, commit=False, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/sql_server/sql_server.py#L210">[source]</a></span></div>

Task for fetching results of query from SQL Server database.

**Args**:     <ul class="args"><li class="args">`db_name (str)`: name of SQL Server database     </li><li class="args">`user (str)`: user name used to authenticate     </li><li class="args">`host (str)`: database host address     </li><li class="args">`port (int, optional)`: port used to connect to SQL Server database, defaults to 5432 if         not provided     </li><li class="args">`driver (str, optional)`: driver used to communicate with SQL Server database     </li><li class="args">`fetch (str, optional)`: one of "one" "many" or "all", used to determine how many             results to fetch from executed query     </li><li class="args">`fetch_count (int, optional)`: if fetch = 'many', determines the number of results             to fetch, defaults to 10     </li><li class="args">`query (str, optional)`: query to execute against database     </li><li class="args">`data (tuple, optional)`: values to use in query, must be specified using placeholder         is query string     </li><li class="args">`commit (bool, optional)`: set to True to commit transaction, defaults to false     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-sql-server-sql-server-sqlserverfetch-run'><p class="prefect-class">prefect.tasks.sql_server.sql_server.SqlServerFetch.run</p>(fetch=&quot;one&quot;, fetch_count=10, query=None, data=None, commit=False, password=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/sql_server/sql_server.py#L259">[source]</a></span></div>
<p class="methods">Task run method. Executes a query against SQL Server database and fetches results.<br><br>**Args**:     <ul class="args"><li class="args">`fetch (str, optional)`: one of "one" "many" or "all", used to determine how many         results to fetch from executed query     </li><li class="args">`fetch_count (int, optional)`: if fetch = 'many', determines the number of results         to fetch, defaults to 10     </li><li class="args">`query (str, optional)`: query to execute against database     </li><li class="args">`data (tuple, optional)`: values to use in query, must be specified using         placeholder is query string     </li><li class="args">`commit (bool, optional)`: set to True to commit transaction, defaults to false     </li><li class="args">`password (str)`: password used to authenticate; should be provided from a `Secret` task</li></ul> **Returns**:     <ul class="args"><li class="args">`records (tuple or list of tuples)`: records from provided query</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if query parameter is None or a blank string     </li><li class="args">`DatabaseError`: if exception occurs when executing the query</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on July 1, 2021 at 18:35 UTC</p>