---
sidebarDepth: 2
editLink: false
---
# MySQL Tasks
---
This module contains a collection of tasks for interacting with MySQL databases via
the pymysql library.
 ## MySQLExecute
 <div class='class-sig' id='prefect-tasks-mysql-mysql-mysqlexecute'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.mysql.mysql.MySQLExecute</p>(db_name=None, user=None, password=None, host=None, port=3306, query=None, commit=False, charset=&quot;utf8mb4&quot;, ssl=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/mysql/mysql.py#L9">[source]</a></span></div>

Task for executing a query against a MySQL database.

**Args**:     <ul class="args"><li class="args">`db_name (str)`: name of MySQL database     </li><li class="args">`user (str)`: user name used to authenticate     </li><li class="args">`password (str)`: password used to authenticate     </li><li class="args">`host (str)`: database host address     </li><li class="args">`port (int, optional)`: port used to connect to MySQL database, defaults to 3307         if not provided     </li><li class="args">`query (str, optional)`: query to execute against database     </li><li class="args">`commit (bool, optional)`: set to True to commit transaction, defaults to false     </li><li class="args">`charset (str, optional)`: charset you want to use (defaults to utf8mb4)     </li><li class="args">`ssl (dict, optional)`: A dict of arguments similar to mysql_ssl_set()’s             parameters used for establishing encrypted connections using SSL     </li><li class="args">`**kwargs (Any, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-mysql-mysql-mysqlexecute-run'><p class="prefect-class">prefect.tasks.mysql.mysql.MySQLExecute.run</p>(db_name=None, user=None, password=None, host=None, port=None, query=None, commit=None, charset=None, ssl=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/mysql/mysql.py#L53">[source]</a></span></div>
<p class="methods">Task run method. Executes a query against MySQL database.<br><br>**Args**:     <ul class="args"><li class="args">`db_name (str)`: name of MySQL database     </li><li class="args">`user (str)`: user name used to authenticate     </li><li class="args">`password (str)`: password used to authenticate     </li><li class="args">`host (str)`: database host address     </li><li class="args">`port (int, optional)`: port used to connect to MySQL database, defaults to 3307         if not provided     </li><li class="args">`query (str, optional)`: query to execute against database     </li><li class="args">`commit (bool, optional)`: set to True to commit transaction, defaults to false     </li><li class="args">`charset (str, optional)`: charset you want to use (defaults to "utf8mb4")     </li><li class="args">`ssl (dict, optional)`: A dict of arguments similar to mysql_ssl_set()’s         parameters used for establishing encrypted connections using SSL. To connect         with SSL, at least `ssl_ca`, `ssl_cert`, and `ssl_key` must be specified.</li></ul> **Returns**:     <ul class="args"><li class="args">`executed (int)`: number of affected rows</li></ul> **Raises**:     <ul class="args"><li class="args">pymysql.MySQLError</li></ul></p>|

---
<br>

 ## MySQLFetch
 <div class='class-sig' id='prefect-tasks-mysql-mysql-mysqlfetch'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.mysql.mysql.MySQLFetch</p>(db_name=None, user=None, password=None, host=None, port=3306, fetch=&quot;one&quot;, fetch_count=10, query=None, commit=False, charset=&quot;utf8mb4&quot;, cursor_type=&quot;cursor&quot;, ssl=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/mysql/mysql.py#L128">[source]</a></span></div>

Task for fetching results of query from MySQL database.

**Args**:     <ul class="args"><li class="args">`db_name (str)`: name of MySQL database     </li><li class="args">`user (str)`: user name used to authenticate     </li><li class="args">`password (str)`: password used to authenticate     </li><li class="args">`host (str)`: database host address     </li><li class="args">`port (int, optional)`: port used to connect to MySQL database, defaults to 3307 if not         provided     </li><li class="args">`fetch (str, optional)`: one of "one" "many" or "all", used to determine how many         results to fetch from executed query     </li><li class="args">`fetch_count (int, optional)`: if fetch = 'many', determines the number of results to         fetch, defaults to 10     </li><li class="args">`query (str, optional)`: query to execute against database     </li><li class="args">`commit (bool, optional)`: set to True to commit transaction, defaults to false     </li><li class="args">`charset (str, optional)`: charset of the query, defaults to "utf8mb4"     </li><li class="args">`cursor_type (Union[str, Callable], optional)`: The cursor type to use.         Can be `'cursor'` (the default), `'dictcursor'`, `'sscursor'`, `'ssdictcursor'`,         or a full cursor class.     </li><li class="args">`ssl (dict, optional)`: A dict of arguments similar to mysql_ssl_set()’s             parameters used for establishing encrypted connections using SSL. To connect             with SSL, at least `ssl_ca`, `ssl_cert`, and `ssl_key` must be specified.     </li><li class="args">`**kwargs (Any, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-mysql-mysql-mysqlfetch-run'><p class="prefect-class">prefect.tasks.mysql.mysql.MySQLFetch.run</p>(db_name=None, user=None, password=None, host=None, port=None, fetch=None, fetch_count=None, query=None, commit=None, charset=None, cursor_type=None, ssl=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/mysql/mysql.py#L186">[source]</a></span></div>
<p class="methods">Task run method. Executes a query against MySQL database and fetches results.<br><br>**Args**:     <ul class="args"><li class="args">`db_name (str)`: name of MySQL database     </li><li class="args">`user (str)`: user name used to authenticate     </li><li class="args">`password (str)`: password used to authenticate     </li><li class="args">`host (str)`: database host address     </li><li class="args">`port (int, optional)`: port used to connect to MySQL database, defaults to 3307 if not         provided     </li><li class="args">`fetch (str, optional)`: one of "one" "many" or "all", used to determine how many         results to fetch from executed query     </li><li class="args">`fetch_count (int, optional)`: if fetch = 'many', determines the number of results to         fetch, defaults to 10     </li><li class="args">`query (str, optional)`: query to execute against database     </li><li class="args">`commit (bool, optional)`: set to True to commit transaction, defaults to false     </li><li class="args">`charset (str, optional)`: charset of the query, defaults to "utf8mb4"     </li><li class="args">`cursor_type (Union[str, Callable], optional)`: The cursor type to use.         Can be `'cursor'` (the default), `'dictcursor'`, `'sscursor'`, `'ssdictcursor'`,         or a full cursor class.     </li><li class="args">`ssl (dict, optional)`: A dict of arguments similar to mysql_ssl_set()’s             parameters used for establishing encrypted connections using SSL</li></ul> **Returns**:     <ul class="args"><li class="args">`results (tuple or list of tuples)`: records from provided query</li></ul> **Raises**:     <ul class="args"><li class="args">pymysql.MySQLError</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on July 1, 2021 at 18:35 UTC</p>