---
sidebarDepth: 2
editLink: false
---
# Kubernetes Tasks
---
Tasks for interacting with various Kubernetes API objects.

Note that depending on how you choose to authenticate, tasks in this collection might require
a Prefect Secret called `"KUBERNETES_API_KEY"` that stores your Kubernetes API Key;
this Secret must be a string and in BearerToken format.
 ## CreateNamespacedDeployment
 <div class='class-sig' id='prefect-tasks-kubernetes-deployment-createnamespaceddeployment'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.deployment.CreateNamespacedDeployment</p>(body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L10">[source]</a></span></div>

Task for creating a namespaced deployment on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes         ExtensionsV1beta1Deployment specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to create this deployment in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-deployment-createnamespaceddeployment-run'><p class="prefect-class">prefect.tasks.kubernetes.deployment.CreateNamespacedDeployment.run</p>(body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L61">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes         ExtensionsV1beta1Deployment specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to create this deployment in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`</li></ul></p>|

---
<br>

 ## DeleteNamespacedDeployment
 <div class='class-sig' id='prefect-tasks-kubernetes-deployment-deletenamespaceddeployment'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.deployment.DeleteNamespacedDeployment</p>(deployment_name=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L106">[source]</a></span></div>

Task for deleting a namespaced deployment on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`deployment_name (str, optional)`: The name of a deployment to delete     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to delete this deployment from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-deployment-deletenamespaceddeployment-run'><p class="prefect-class">prefect.tasks.kubernetes.deployment.DeleteNamespacedDeployment.run</p>(deployment_name=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, delete_option_kwargs=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L156">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`deployment_name (str, optional)`: The name of a deployment to delete     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to delete this deployment in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`delete_option_kwargs (dict, optional)`: Optional keyword arguments to pass to         the V1DeleteOptions object (e.g. {"propagation_policy": "...",         "grace_period_seconds": "..."}.</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `deployment_name` is `None`</li></ul></p>|

---
<br>

 ## ListNamespacedDeployment
 <div class='class-sig' id='prefect-tasks-kubernetes-deployment-listnamespaceddeployment'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.deployment.ListNamespacedDeployment</p>(namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L205">[source]</a></span></div>

Task for listing namespaced deployments on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`namespace (str, optional)`: The Kubernetes namespace to list deployments from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"field_selector": "...", "label_selector": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-deployment-listnamespaceddeployment-run'><p class="prefect-class">prefect.tasks.kubernetes.deployment.ListNamespacedDeployment.run</p>(namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L252">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`namespace (str, optional)`: The Kubernetes namespace to list deployments from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"field_selector": "...", "label_selector": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul> **Returns**:     <ul class="args"><li class="args">`ExtensionsV1beta1DeploymentList`: a Kubernetes ExtensionsV1beta1DeploymentList         of the deployments which are found</li></ul></p>|

---
<br>

 ## PatchNamespacedDeployment
 <div class='class-sig' id='prefect-tasks-kubernetes-deployment-patchnamespaceddeployment'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.deployment.PatchNamespacedDeployment</p>(deployment_name=None, body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L285">[source]</a></span></div>

Task for patching a namespaced deployment on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`deployment_name (str, optional)`: The name of a deployment to patch     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes         ExtensionsV1beta1Deployment patch specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this deployment in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-deployment-patchnamespaceddeployment-run'><p class="prefect-class">prefect.tasks.kubernetes.deployment.PatchNamespacedDeployment.run</p>(deployment_name=None, body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L339">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`deployment_name (str, optional)`: The name of a deployment to patch     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes         ExtensionsV1beta1Deployment patch specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this deployment in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`     </li><li class="args">`ValueError`: if `deployment_name` is `None`</li></ul></p>|

---
<br>

 ## ReadNamespacedDeployment
 <div class='class-sig' id='prefect-tasks-kubernetes-deployment-readnamespaceddeployment'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.deployment.ReadNamespacedDeployment</p>(deployment_name=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L394">[source]</a></span></div>

Task for reading a namespaced deployment on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`deployment_name (str, optional)`: The name of a deployment to read     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to read this deployment from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "exact": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-deployment-readnamespaceddeployment-run'><p class="prefect-class">prefect.tasks.kubernetes.deployment.ReadNamespacedDeployment.run</p>(deployment_name=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L444">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`deployment_name (str, optional)`: The name of a deployment to read     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to read this deployment in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "exact": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul> **Returns**:     <ul class="args"><li class="args">`ExtensionsV1beta1Deployment`: a Kubernetes ExtensionsV1beta1Deployment         matching the deployment that was found</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `deployment_name` is `None`</li></ul></p>|

---
<br>

 ## ReplaceNamespacedDeployment
 <div class='class-sig' id='prefect-tasks-kubernetes-deployment-replacenamespaceddeployment'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.deployment.ReplaceNamespacedDeployment</p>(deployment_name=None, body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L489">[source]</a></span></div>

Task for replacing a namespaced deployment on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`deployment_name (str, optional)`: The name of a deployment to replace     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes         ExtensionsV1beta1Deployment specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this deployment in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-deployment-replacenamespaceddeployment-run'><p class="prefect-class">prefect.tasks.kubernetes.deployment.ReplaceNamespacedDeployment.run</p>(deployment_name=None, body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L543">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`deployment_name (str, optional)`: The name of a deployment to replace     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes         ExtensionsV1beta1Deployment specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this deployment in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`     </li><li class="args">`ValueError`: if `deployment_name` is `None`</li></ul></p>|

---
<br>

 ## CreateNamespacedJob
 <div class='class-sig' id='prefect-tasks-kubernetes-job-createnamespacedjob'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.job.CreateNamespacedJob</p>(body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L14">[source]</a></span></div>

Task for creating a namespaced job on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Job         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to create this job in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-job-createnamespacedjob-run'><p class="prefect-class">prefect.tasks.kubernetes.job.CreateNamespacedJob.run</p>(body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L65">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Job         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to create this job in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`</li></ul></p>|

---
<br>

 ## DeleteNamespacedJob
 <div class='class-sig' id='prefect-tasks-kubernetes-job-deletenamespacedjob'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.job.DeleteNamespacedJob</p>(job_name=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L105">[source]</a></span></div>

Task for deleting a namespaced job on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`job_name (str, optional)`: The name of a job to delete     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to delete this job from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-job-deletenamespacedjob-run'><p class="prefect-class">prefect.tasks.kubernetes.job.DeleteNamespacedJob.run</p>(job_name=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, delete_option_kwargs=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L155">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`job_name (str, optional)`: The name of a job to delete     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to delete this job in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`delete_option_kwargs (dict, optional)`: Optional keyword arguments to pass to         the V1DeleteOptions object (e.g. {"propagation_policy": "...",         "grace_period_seconds": "..."}.</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `job_name` is `None`</li></ul></p>|

---
<br>

 ## ListNamespacedJob
 <div class='class-sig' id='prefect-tasks-kubernetes-job-listnamespacedjob'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.job.ListNamespacedJob</p>(namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L203">[source]</a></span></div>

Task for listing namespaced jobs on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`namespace (str, optional)`: The Kubernetes namespace to list jobs from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"field_selector": "...", "label_selector": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-job-listnamespacedjob-run'><p class="prefect-class">prefect.tasks.kubernetes.job.ListNamespacedJob.run</p>(namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L250">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`namespace (str, optional)`: The Kubernetes namespace to list jobs from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"field_selector": "...", "label_selector": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul> **Returns**:     <ul class="args"><li class="args">`V1JobList`: a Kubernetes V1JobList of the jobs which are found</li></ul></p>|

---
<br>

 ## PatchNamespacedJob
 <div class='class-sig' id='prefect-tasks-kubernetes-job-patchnamespacedjob'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.job.PatchNamespacedJob</p>(job_name=None, body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L281">[source]</a></span></div>

Task for patching a namespaced job on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`job_name (str, optional)`: The name of a job to patch     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Job         patch specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this job in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-job-patchnamespacedjob-run'><p class="prefect-class">prefect.tasks.kubernetes.job.PatchNamespacedJob.run</p>(job_name=None, body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L335">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`job_name (str, optional)`: The name of a job to patch     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Job         patch specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this job in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`     </li><li class="args">`ValueError`: if `job_name` is `None`</li></ul></p>|

---
<br>

 ## ReadNamespacedJob
 <div class='class-sig' id='prefect-tasks-kubernetes-job-readnamespacedjob'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.job.ReadNamespacedJob</p>(job_name=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L385">[source]</a></span></div>

Task for reading a namespaced job on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`job_name (str, optional)`: The name of a job to read     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to read this job from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "exact": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-job-readnamespacedjob-run'><p class="prefect-class">prefect.tasks.kubernetes.job.ReadNamespacedJob.run</p>(job_name=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L435">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`job_name (str, optional)`: The name of a job to read     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to read this job in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "exact": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul> **Returns**:     <ul class="args"><li class="args">`V1Job`: a Kubernetes V1Job matching the job that was found</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `job_name` is `None`</li></ul></p>|

---
<br>

 ## ReplaceNamespacedJob
 <div class='class-sig' id='prefect-tasks-kubernetes-job-replacenamespacedjob'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.job.ReplaceNamespacedJob</p>(job_name=None, body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L478">[source]</a></span></div>

Task for replacing a namespaced job on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`job_name (str, optional)`: The name of a job to replace     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Job         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this job in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-job-replacenamespacedjob-run'><p class="prefect-class">prefect.tasks.kubernetes.job.ReplaceNamespacedJob.run</p>(job_name=None, body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L532">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`job_name (str, optional)`: The name of a job to replace     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Job         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this job in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`     </li><li class="args">`ValueError`: if `job_name` is `None`</li></ul></p>|

---
<br>

 ## RunNamespacedJob
 <div class='class-sig' id='prefect-tasks-kubernetes-job-runnamespacedjob'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.job.RunNamespacedJob</p>(body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, job_status_poll_interval=5, log_level=None, delete_job_after_completion=True, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L580">[source]</a></span></div>

Task for running a namespaced job on Kubernetes. This task first creates a job on a Kubernetes cluster according to the specification given in the body, and then by default regularly checks its status at 5-second intervals. After the job is successfully completed, all resources by default are deleted: job and the corresponding pods. If job is in the failed status, resources will not be removed from the cluster so that user can check the logs on the cluster.

Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Job         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to create this job in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`job_status_poll_interval (int, optional)`: The interval given in seconds         indicating how often the Kubernetes API will be requested about the status         of the job being performed, defaults to the `5` seconds     </li><li class="args">`log_level (str, optional)`: Log level used when outputting logs from the job         should be one of `debug`, `info`, `warn`, `error`, 'critical' or `None` to         disable output completely. Defaults to `None`.     </li><li class="args">`delete_job_after_completion (bool, optional)`: boolean value determining whether         resources related to a given job will be removed from the Kubernetes cluster         after completion, defaults to the `True` value     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-job-runnamespacedjob-run'><p class="prefect-class">prefect.tasks.kubernetes.job.RunNamespacedJob.run</p>(body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, job_status_poll_interval=5, log_level=None, delete_job_after_completion=True)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L652">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Job         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to create this job in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`job_status_poll_interval (int, optional)`: The interval given in seconds         indicating how often the Kubernetes API will be requested about the status         of the job being performed, defaults to the `5` seconds.     </li><li class="args">`log_level (str, optional)`: Log level used when outputting logs from the job         should be one of `debug`, `info`, `warn`, `error`, 'critical' or `None` to         disable output completely. Defaults to `None`.     </li><li class="args">`delete_job_after_completion (bool, optional)`: boolean value determining whether         resources related to a given job will be removed from the Kubernetes cluster         after completion, defaults to the `True` value</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`     </li><li class="args">`ValueError`: if `body["metadata"]["name"] is `None`</li></ul></p>|

---
<br>

 ## ConnectGetNamespacedPodExec
 <div class='class-sig' id='prefect-tasks-kubernetes-pod-connectgetnamespacedpodexec'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.pod.ConnectGetNamespacedPodExec</p>(pod_name=None, container_name=None, exec_command=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L688">[source]</a></span></div>

Task for running a command in a namespaced pod on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime. This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`pod_name (str, optional)`: The name of a pod in which the command is to be run     </li><li class="args">`container_name (str, optional)`: The name of a container to use in the pod     </li><li class="args">`exec_command (list, optional)`: the command to run in pod_name     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace of the pod,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "exact": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-pod-connectgetnamespacedpodexec-run'><p class="prefect-class">prefect.tasks.kubernetes.pod.ConnectGetNamespacedPodExec.run</p>(pod_name=None, container_name=None, exec_command=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L742">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`pod_name (str, optional)`: The name of a pod in which the command is to be run     </li><li class="args">`container_name (str, optional)`: The name of a container to use in the pod     </li><li class="args">`exec_command (list, optional)`: the command to run in pod_name     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace of the pod,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "exact": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul> **Returns**:     <ul class="args"><li class="args">`api_response`: If the method is called asynchronously, returns the request thread</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `pod_name` is `None` or `container_name` is `None`     </li><li class="args">`TypeError`: `exec_command` is not a list</li></ul></p>|

---
<br>

 ## CreateNamespacedPod
 <div class='class-sig' id='prefect-tasks-kubernetes-pod-createnamespacedpod'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.pod.CreateNamespacedPod</p>(body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L13">[source]</a></span></div>

Task for creating a namespaced pod on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Pod         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to create this pod in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-pod-createnamespacedpod-run'><p class="prefect-class">prefect.tasks.kubernetes.pod.CreateNamespacedPod.run</p>(body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L64">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Pod         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to create this pod in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`</li></ul></p>|

---
<br>

 ## DeleteNamespacedPod
 <div class='class-sig' id='prefect-tasks-kubernetes-pod-deletenamespacedpod'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.pod.DeleteNamespacedPod</p>(pod_name=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L104">[source]</a></span></div>

Task for deleting a namespaced pod on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`pod_name (str, optional)`: The name of a pod to delete     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to delete this pod from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-pod-deletenamespacedpod-run'><p class="prefect-class">prefect.tasks.kubernetes.pod.DeleteNamespacedPod.run</p>(pod_name=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, delete_option_kwargs=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L154">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`pod_name (str, optional)`: The name of a pod to delete     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to delete this pod in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`delete_option_kwargs (dict, optional)`: Optional keyword arguments to pass to         the V1DeleteOptions object (e.g. {"propagation_policy": "...",         "grace_period_seconds": "..."}.</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `pod_name` is `None`</li></ul></p>|

---
<br>

 ## ListNamespacedPod
 <div class='class-sig' id='prefect-tasks-kubernetes-pod-listnamespacedpod'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.pod.ListNamespacedPod</p>(namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L202">[source]</a></span></div>

Task for listing namespaced pods on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`namespace (str, optional)`: The Kubernetes namespace to list pods from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"field_selector": "...", "label_selector": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-pod-listnamespacedpod-run'><p class="prefect-class">prefect.tasks.kubernetes.pod.ListNamespacedPod.run</p>(namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L249">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`namespace (str, optional)`: The Kubernetes namespace to list pods from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"field_selector": "...", "label_selector": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul> **Returns**:     <ul class="args"><li class="args">`V1PodList`: a Kubernetes V1PodList of the pods which are found</li></ul></p>|

---
<br>

 ## PatchNamespacedPod
 <div class='class-sig' id='prefect-tasks-kubernetes-pod-patchnamespacedpod'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.pod.PatchNamespacedPod</p>(pod_name=None, body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L280">[source]</a></span></div>

Task for patching a namespaced pod on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`pod_name (str, optional)`: The name of a pod to patch     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Pod         patch specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this pod in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-pod-patchnamespacedpod-run'><p class="prefect-class">prefect.tasks.kubernetes.pod.PatchNamespacedPod.run</p>(pod_name=None, body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L334">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`pod_name (str, optional)`: The name of a pod to patch     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Pod         patch specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this pod in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`     </li><li class="args">`ValueError`: if `pod_name` is `None`</li></ul></p>|

---
<br>

 ## ReadNamespacedPod
 <div class='class-sig' id='prefect-tasks-kubernetes-pod-readnamespacedpod'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.pod.ReadNamespacedPod</p>(pod_name=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L384">[source]</a></span></div>

Task for reading a namespaced pod on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`pod_name (str, optional)`: The name of a pod to read     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to read this pod from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "exact": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-pod-readnamespacedpod-run'><p class="prefect-class">prefect.tasks.kubernetes.pod.ReadNamespacedPod.run</p>(pod_name=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L434">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`pod_name (str, optional)`: The name of a pod to read     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to read this pod in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "exact": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul> **Returns**:     <ul class="args"><li class="args">`V1Pod`: a Kubernetes V1Pod matching the pod that was found</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `pod_name` is `None`</li></ul></p>|

---
<br>

 ## ReadNamespacedPodLogs
 <div class='class-sig' id='prefect-tasks-kubernetes-pod-readnamespacedpodlogs'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.pod.ReadNamespacedPodLogs</p>(pod_name=None, namespace=&quot;default&quot;, on_log_entry=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L579">[source]</a></span></div>

Task for reading logs from a namespaced pod on Kubernetes. Logs can be streamed by providing a `on_log_entry` function which then will be called for each log line. If `on_log_entry` = `None`, the task returns all logs for the pod until that point.

Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

**Args**:     <ul class="args"><li class="args">`pod_name (str, optional)`: The name of a pod to replace     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this pod in,         defaults to the `default` namespace     </li><li class="args">`on_log_entry (Callable, optional)`: If provided, will stream the pod logs         calling the callback for every line (and the task returns `None`). If not         provided, the current pod logs will be returned immediately from the task.     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-pod-readnamespacedpodlogs-run'><p class="prefect-class">prefect.tasks.kubernetes.pod.ReadNamespacedPodLogs.run</p>(pod_name=None, namespace=&quot;default&quot;, on_log_entry=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L627">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`pod_name (str, optional)`: The name of a pod to replace     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this pod in,         defaults to the `default` namespace     </li><li class="args">`on_log_entry (Callable, optional)`: If provided, will stream the pod logs         calling the callback for every line (and the task returns `None`). If not         provided, the current pod logs will be returned immediately from the task.     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `pod_name` is `None`</li></ul></p>|

---
<br>

 ## ReplaceNamespacedPod
 <div class='class-sig' id='prefect-tasks-kubernetes-pod-replacenamespacedpod'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.pod.ReplaceNamespacedPod</p>(pod_name=None, body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L477">[source]</a></span></div>

Task for replacing a namespaced pod on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`pod_name (str, optional)`: The name of a pod to replace     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Pod         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this pod in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-pod-replacenamespacedpod-run'><p class="prefect-class">prefect.tasks.kubernetes.pod.ReplaceNamespacedPod.run</p>(pod_name=None, body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L531">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`pod_name (str, optional)`: The name of a pod to replace     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Pod         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this pod in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`     </li><li class="args">`ValueError`: if `pod_name` is `None`</li></ul></p>|

---
<br>

 ## CreateNamespacedService
 <div class='class-sig' id='prefect-tasks-kubernetes-service-createnamespacedservice'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.service.CreateNamespacedService</p>(body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L10">[source]</a></span></div>

Task for creating a namespaced service on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Service in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Service         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to create this service in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-service-createnamespacedservice-run'><p class="prefect-class">prefect.tasks.kubernetes.service.CreateNamespacedService.run</p>(body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L61">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Service         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to create this service in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`</li></ul></p>|

---
<br>

 ## DeleteNamespacedService
 <div class='class-sig' id='prefect-tasks-kubernetes-service-deletenamespacedservice'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.service.DeleteNamespacedService</p>(service_name=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L104">[source]</a></span></div>

Task for deleting a namespaced service on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Service in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`service_name (str, optional)`: The name of a service to delete     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to delete this service from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-service-deletenamespacedservice-run'><p class="prefect-class">prefect.tasks.kubernetes.service.DeleteNamespacedService.run</p>(service_name=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, delete_option_kwargs=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L154">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`service_name (str, optional)`: The name of a service to delete     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to delete this service in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`delete_option_kwargs (dict, optional)`: Optional keyword arguments to pass to         the V1DeleteOptions object (e.g. {"propagation_policy": "...",         "grace_period_seconds": "..."}.</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `service_name` is `None`</li></ul></p>|

---
<br>

 ## ListNamespacedService
 <div class='class-sig' id='prefect-tasks-kubernetes-service-listnamespacedservice'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.service.ListNamespacedService</p>(namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L203">[source]</a></span></div>

Task for listing namespaced services on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Service in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`namespace (str, optional)`: The Kubernetes namespace to list services from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"field_selector": "...", "label_selector": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-service-listnamespacedservice-run'><p class="prefect-class">prefect.tasks.kubernetes.service.ListNamespacedService.run</p>(namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L250">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`namespace (str, optional)`: The Kubernetes namespace to list services from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"field_selector": "...", "label_selector": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul> **Returns**:     <ul class="args"><li class="args">`V1ServiceList`: a Kubernetes V1ServiceList of the services which are found</li></ul></p>|

---
<br>

 ## PatchNamespacedService
 <div class='class-sig' id='prefect-tasks-kubernetes-service-patchnamespacedservice'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.service.PatchNamespacedService</p>(service_name=None, body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L282">[source]</a></span></div>

Task for patching a namespaced service on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Service in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`service_name (str, optional)`: The name of a service to patch     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Service         patch specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this service in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-service-patchnamespacedservice-run'><p class="prefect-class">prefect.tasks.kubernetes.service.PatchNamespacedService.run</p>(service_name=None, body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L336">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`service_name (str, optional)`: The name of a service to patch     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Service         patch specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this service in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`     </li><li class="args">`ValueError`: if `service_name` is `None`</li></ul></p>|

---
<br>

 ## ReadNamespacedService
 <div class='class-sig' id='prefect-tasks-kubernetes-service-readnamespacedservice'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.service.ReadNamespacedService</p>(service_name=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L387">[source]</a></span></div>

Task for reading a namespaced service on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Service in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`service_name (str, optional)`: The name of a service to read     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to read this service from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "exact": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-service-readnamespacedservice-run'><p class="prefect-class">prefect.tasks.kubernetes.service.ReadNamespacedService.run</p>(service_name=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L437">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`service_name (str, optional)`: The name of a service to read     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to read this service in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "exact": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul> **Returns**:     <ul class="args"><li class="args">`V1Service`: a Kubernetes V1Service matching the service that was found</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `service_name` is `None`</li></ul></p>|

---
<br>

 ## ReplaceNamespacedService
 <div class='class-sig' id='prefect-tasks-kubernetes-service-replacenamespacedservice'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.service.ReplaceNamespacedService</p>(service_name=None, body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L481">[source]</a></span></div>

Task for replacing a namespaced service on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Service in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`service_name (str, optional)`: The name of a service to replace     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Service         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this service in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-service-replacenamespacedservice-run'><p class="prefect-class">prefect.tasks.kubernetes.service.ReplaceNamespacedService.run</p>(service_name=None, body=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L535">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`service_name (str, optional)`: The name of a service to replace     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Service         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this service in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`     </li><li class="args">`ValueError`: if `service_name` is `None`</li></ul></p>|

---
<br>

 ## KubernetesSecret
 <div class='class-sig' id='prefect-tasks-kubernetes-secrets-kubernetessecret'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.secrets.KubernetesSecret</p>(secret_name=None, secret_key=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;, cast=None, raise_if_missing=False, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/secrets.py#L12">[source]</a></span></div>

Task for loading a Prefect secret from a kubernetes secret.

This task will read a secret from kubernetes, returning the decoded value associated with `secret_key`. All initialization arguments can optionally be provided or overwritten at runtime.

Note that depending on cluster configuration, you may need to ensure you have the proper RBAC permissions to read the secret.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key. If `kubernetes_api_key_secret` = `None` then it will attempt the next two connection methods. By default the value is `KUBERNETES_API_KEY` so providing `None` acts as an override for the remote connection. 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file


**Args**:     <ul class="args"><li class="args">`secret_name (string, optional)`: The name of the kubernetes secret object     </li><li class="args">`secret_key (string, optional)`: The key to look for in the kubernetes data     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to read the secret from,         defaults to the `default` namespace.     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`cast (Callable[[Any], Any], optional)`: If provided, this will         be called on the secret to transform it before returning. An example         use might be passing in `json.loads` to load values from stored JSON.     </li><li class="args">`raise_if_missing (bool)`: if True, an error will be raised if the secret is not found.     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-secrets-kubernetessecret-run'><p class="prefect-class">prefect.tasks.kubernetes.secrets.KubernetesSecret.run</p>(secret_name=None, secret_key=None, namespace=&quot;default&quot;, kube_kwargs=None, kubernetes_api_key_secret=&quot;KUBERNETES_API_KEY&quot;)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/secrets.py#L69">[source]</a></span></div>
<p class="methods">Returns the value of an kubenetes secret after applying an optional `cast` function.<br><br>**Args**:     <ul class="args"><li class="args">`secret_name (string, optional)`: The name of the kubernetes secret object     </li><li class="args">`secret_key (string, optional)`: The key to look for in the kubernetes data     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to read the secret from,         defaults to the `default` namespace.     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if `raise_is_missing` is `True` and the kubernetes secret was not found.         The value of secret_name and secret_key are mandatory as well</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on July 1, 2021 at 18:35 UTC</p>