---
sidebarDepth: 2
editLink: false
---
# Exasol Tasks
---
This module contains a collection of tasks for interacting with Exasol databases via
the pyexasol library.
 ## ExasolFetch
 <div class='class-sig' id='prefect-tasks-exasol-exasol-exasolfetch'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.exasol.exasol.ExasolFetch</p>(dsn=&quot;&quot;, user=&quot;&quot;, password=&quot;&quot;, fetch=&quot;one&quot;, fetch_size=10, query=None, query_params=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/exasol/exasol.py#L119">[source]</a></span></div>

Task for fetching results of query from Exasol database.

**Args**:     <ul class="args"><li class="args">`dsn (str, optional)`: dsn string of the database (server:port)     </li><li class="args">`user (str, optional, DEPRECATED)`: user name used to authenticate. Deprecated,         should be passed at runtime instead.     </li><li class="args">`password (str, optional, DEPRECATED)`: password used to authenticate. Deprecated,         should be passed at runtime instead.     </li><li class="args">`fetch (str, optional)`: one of "one" "many" "val" or "all", used to determine how many         results to fetch from executed query     </li><li class="args">`fetch_size (int, optional)`: if fetch = 'many', determines the number of results to         fetch, defaults to 10     </li><li class="args">`query (str, optional)`: query to execute against database     </li><li class="args">`query_params (dict, optional)`: Values for SQL query placeholders     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-exasol-exasol-exasolfetch-run'><p class="prefect-class">prefect.tasks.exasol.exasol.ExasolFetch.run</p>(user, password, dsn=&quot;&quot;, fetch=&quot;one&quot;, fetch_size=10, query=None, query_params=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/exasol/exasol.py#L166">[source]</a></span></div>
<p class="methods">Task run method. Executes a query against Exasol database and fetches results.<br><br>**Args**:     <ul class="args"><li class="args">`user (str)`: user name used to authenticate     </li><li class="args">`password (str)`: password used to authenticate; should be provided from a `Secret` task     </li><li class="args">`dsn (str, optional)`: dsn string of the database (server:port)     </li><li class="args">`fetch (str, optional)`: one of "one" "many" "val" or "all", used to determine how many         results to fetch from executed query     </li><li class="args">`fetch_size (int, optional)`: if fetch = 'many', determines the number of results         to fetch, defaults to 10     </li><li class="args">`query (str, optional)`: query to execute against database     </li><li class="args">`query_params (dict, optional)`: Values for SQL query placeholders     </li><li class="args">`**kwargs (dict, optional)`: additional connection parameter         (autocommit, connection_timeout...)</li></ul> **Returns**:     <ul class="args"><li class="args">`records (None, str, tuple, list of tuples, dict, or list of dicts)`:         records from provided query</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if dsn string is not provided     </li><li class="args">`ValueError`: if query parameter is None or a blank string     </li><li class="args">`Exa*Error`: multiple exceptions raised from the underlying pyexasol package         (e.g. ExaQueryError, ExaAuthError..)</li></ul></p>|

---
<br>

 ## ExasolExecute
 <div class='class-sig' id='prefect-tasks-exasol-exasol-exasolexecute'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.exasol.exasol.ExasolExecute</p>(dsn=&quot;&quot;, user=&quot;&quot;, password=&quot;&quot;, query=None, query_params=None, autocommit=False, commit=True, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/exasol/exasol.py#L10">[source]</a></span></div>

Task for executing a query against a Exasol database.

**Args**:     <ul class="args"><li class="args">`dsn (str, optional)`: dsn string of the database (server:port)     </li><li class="args">`user (str, optional, DEPRECATED)`: user name used to authenticate. Deprecated,         should be passed at runtime instead.     </li><li class="args">`password (str, optional, DEPRECATED)`: password used to authenticate. Deprecated,         should be passed at runtime instead.     </li><li class="args">`query (str, optional)`: query to execute against database     </li><li class="args">`query_params (dict, optional)`: Values for SQL query placeholders     </li><li class="args">`autocommit (bool, optional)`: turn autocommit on or off (default: False)     </li><li class="args">`commit (bool, optional)`: set to True to commit transaction, defaults to True         (only necessary if autocommit = False)     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-exasol-exasol-exasolexecute-run'><p class="prefect-class">prefect.tasks.exasol.exasol.ExasolExecute.run</p>(user, password, dsn=&quot;&quot;, query=None, query_params=None, autocommit=False, commit=True, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/exasol/exasol.py#L56">[source]</a></span></div>
<p class="methods">Task run method. Executes a query against Exasol database.<br><br>**Args**:     <ul class="args"><li class="args">`user (str)`: user name used to authenticate     </li><li class="args">`password (str)`: password used to authenticate; should be provided from a `Secret` task     </li><li class="args">`dsn (str, optional)`: dsn string of the database (server:port)     </li><li class="args">`query (str, optional)`: query to execute against database     </li><li class="args">`query_params (dict, optional)`: Values for SQL query placeholders     </li><li class="args">`autocommit (bool, optional)`: turn autocommit on or off (default: False)     </li><li class="args">`commit (bool, optional)`: set to True to commit transaction, defaults to True         (only necessary if autocommit = False)     </li><li class="args">`**kwargs (dict, optional)`: additional connection parameter (connection_timeout...)</li></ul> **Returns**:     <ul class="args"><li class="args">ExaStatement object</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if dsn string is not provided     </li><li class="args">`ValueError`: if query parameter is None or a blank string     </li><li class="args">`Exa*Error`: multiple exceptions raised from the underlying pyexasol package         (e.g. ExaQueryError, ExaAuthError..)</li></ul></p>|

---
<br>

 ## ExasolImportFromIterable
 <div class='class-sig' id='prefect-tasks-exasol-exasol-exasolimportfromiterable'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.exasol.exasol.ExasolImportFromIterable</p>(dsn=&quot;&quot;, user=&quot;&quot;, password=&quot;&quot;, target_schema=None, target_table=None, data=None, import_params=None, autocommit=False, commit=True, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/exasol/exasol.py#L235">[source]</a></span></div>

Task for importing a iterable with data into the Exasol database.

**Args**:     <ul class="args"><li class="args">`dsn (str, optional)`: dsn string of the database (server:port)     </li><li class="args">`user (str, optional, DEPRECATED)`: user name used to authenticate. Deprecated,         should be passed at runtime instead.     </li><li class="args">`password (str, optional, DEPRECATED)`: password used to authenticate. Deprecated,         should be passed at runtime instead.     </li><li class="args">`target_schema (str, optional)`: target schema for importing data     </li><li class="args">`target_table (str, optional)`: target table for importing data     </li><li class="args">`data (Iterable, optional)`: an iterable which holds the import data     </li><li class="args">`import_params (dict, optional)`: custom parameters for IMPORT query     </li><li class="args">`autocommit (bool, optional)`: turn autocommit on or off (default: False)     </li><li class="args">`commit (bool, optional)`: set to True to commit transaction, defaults to false         (only necessary if autocommit = False)     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-exasol-exasol-exasolimportfromiterable-run'><p class="prefect-class">prefect.tasks.exasol.exasol.ExasolImportFromIterable.run</p>(user, password, dsn=&quot;&quot;, target_schema=None, target_table=None, data=None, import_params=None, autocommit=False, commit=True, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/exasol/exasol.py#L287">[source]</a></span></div>
<p class="methods">Task run method. Executes a query against Postgres database.<br><br>**Args**:     <ul class="args"><li class="args">`user (str)`: user name used to authenticate     </li><li class="args">`password (str)`: password used to authenticate; should be provided from a `Secret` task     </li><li class="args">`dsn (str, optional)`: dsn string of the database (server:port)     </li><li class="args">`target_schema (str, optional)`: target schema for importing data     </li><li class="args">`target_table (str, optional)`: target table for importing data     </li><li class="args">`data (Iterable, optional)`: an iterable which holds the import data     </li><li class="args">`import_params (dict, optional)`: custom parameters for IMPORT query     </li><li class="args">`autocommit (bool, optional)`: turn autocommit on or off (default: False)     </li><li class="args">`commit (bool, optional)`: set to True to commit transaction, defaults to false         (only necessary if autocommit = False)     </li><li class="args">`**kwargs (dict, optional)`: additional connection parameter (connection_timeout...)</li></ul> **Returns**:     <ul class="args"><li class="args">Nothing</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if dsn string is not provided     </li><li class="args">`ValueError`: if `data` is not provided or is empty     </li><li class="args">`ValueError`: if `target_table` is not provided     </li><li class="args">`Exa*Error`: multiple exceptions raised from the underlying pyexasol package         (e.g. ExaQueryError, ExaAuthError..)</li></ul></p>|

---
<br>

 ## ExasolExportToFile
 <div class='class-sig' id='prefect-tasks-exasol-exasol-exasolexporttofile'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.exasol.exasol.ExasolExportToFile</p>(dsn=&quot;&quot;, user=&quot;&quot;, password=&quot;&quot;, destination=None, query_or_table=None, query_params=None, export_params=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/exasol/exasol.py#L370">[source]</a></span></div>

Task for exporting data of an Exasol database into a single csv.

**Args**:     <ul class="args"><li class="args">`dsn (str, optional)`: dsn string of the database (server:port)     </li><li class="args">`user (str, optional, DEPRECATED)`: user name used to authenticate. Deprecated,         should be passed at runtime instead.     </li><li class="args">`password (str, optional, DEPRECATED)`: password used to authenticate. Deprecated,         should be passed at runtime instead.     </li><li class="args">`destination ([str, Path], optional)`: Path to file or file-like object     </li><li class="args">`query_or_table (str, optional)`: SQL query or table for export         could be:             1. SELECT * FROM S.T             2. tablename             3. (schemaname, tablename)     </li><li class="args">`query_params (dict, optional)`: Values for SQL query placeholders     </li><li class="args">`export_params (dict, optional)`: custom parameters for EXPORT query     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-exasol-exasol-exasolexporttofile-run'><p class="prefect-class">prefect.tasks.exasol.exasol.ExasolExportToFile.run</p>(user, password, dsn=&quot;&quot;, destination=None, query_or_table=None, query_params=None, export_params=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/exasol/exasol.py#L419">[source]</a></span></div>
<p class="methods">Task run method. Executes a query against Postgres database.<br><br>**Args**:     <ul class="args"><li class="args">`user (str)`: user name used to authenticate     </li><li class="args">`password (str)`: password used to authenticate; should be provided from a `Secret` task     </li><li class="args">`dsn (str, optional)`: dsn string of the database (server:port)     </li><li class="args">`destination ([str, Path], optional)`: Path to file or file-like object     </li><li class="args">`query_or_table (str, optional)`: SQL query or table for export         could be:             1. SELECT * FROM S.T             2. tablename             3. (schemaname, tablename)     </li><li class="args">`query_params (dict, optional)`: Values for SQL query placeholders     </li><li class="args">`export_params (dict, optional)`: custom parameters for EXPORT query     </li><li class="args">`**kwargs (dict, optional)`: additional connection parameter (connection_timeout...)</li></ul> **Returns**:     <ul class="args"><li class="args">Nothing</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if dsn string is not provided     </li><li class="args">`ValueError`: if destination is not provided     </li><li class="args">`ValueError`: if no query or table are provided     </li><li class="args">`Exa*Error`: multiple exceptions raised from the underlying pyexasol package         (e.g. ExaQueryError, ExaAuthError..)</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on July 1, 2021 at 18:35 UTC</p>