---
sidebarDepth: 2
editLink: false
---
# Azure Tasks
---
This module contains a collection of tasks for interacting with Azure resources.
 ## BlobStorageDownload
 <div class='class-sig' id='prefect-tasks-azure-blobstorage-blobstoragedownload'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.azure.blobstorage.BlobStorageDownload</p>(azure_credentials_secret=&quot;AZ_CONNECTION_STRING&quot;, container=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/azure/blobstorage.py#L10">[source]</a></span></div>

Task for downloading data from an Blob Storage container and returning it as a string. Note that all initialization arguments can optionally be provided or overwritten at runtime.

**Args**:     <ul class="args"><li class="args">`azure_credentials_secret (str, optional)`: the name of the Prefect Secret         that stores your Azure credentials; this Secret must be an Azure connection string     </li><li class="args">`container (str, optional)`: the name of the Azure Blob Storage to download from     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-azure-blobstorage-blobstoragedownload-run'><p class="prefect-class">prefect.tasks.azure.blobstorage.BlobStorageDownload.run</p>(blob_name, azure_credentials_secret=&quot;AZ_CONNECTION_STRING&quot;, container=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/azure/blobstorage.py#L33">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`blob_name (str)`: the name of the blob within this container to retrieve     </li><li class="args">`azure_credentials_secret (str, optional)`: the name of the Prefect Secret     that stores your Azure credentials; this Secret must be an Azure connection string     </li><li class="args">`container (str, optional)`: the name of the Blob Storage container to download from</li></ul> **Returns**:     <ul class="args"><li class="args">`str`: the contents of this blob_name / container, as a string</li></ul></p>|

---
<br>

 ## BlobStorageUpload
 <div class='class-sig' id='prefect-tasks-azure-blobstorage-blobstorageupload'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.azure.blobstorage.BlobStorageUpload</p>(azure_credentials_secret=&quot;AZ_CONNECTION_STRING&quot;, container=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/azure/blobstorage.py#L69">[source]</a></span></div>

Task for uploading string data (e.g., a JSON string) to an Azure Blob Storage container. Note that all initialization arguments can optionally be provided or overwritten at runtime.

**Args**:     <ul class="args"><li class="args">`azure_credentials_secret (str, optional)`: the name of the Prefect Secret         that stores your Azure credentials; this Secret must be an Azure connection string     </li><li class="args">`container (str, optional)`: the name of the Azure Blob Storage to upload to     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-azure-blobstorage-blobstorageupload-run'><p class="prefect-class">prefect.tasks.azure.blobstorage.BlobStorageUpload.run</p>(data, blob_name=None, azure_credentials_secret=&quot;AZ_CONNECTION_STRING&quot;, container=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/azure/blobstorage.py#L92">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`data (str)`: the data payload to upload     </li><li class="args">`blob_name (str, optional)`: the name to upload the data under; if not             provided, a random `uuid` will be created     </li><li class="args">`azure_credentials_secret (str, optional)`: the name of the Prefect Secret     that stores your Azure credentials; this Secret must be an Azure connection string     </li><li class="args">`container (str, optional)`: the name of the Blob Storage container to upload to</li></ul> **Returns**:     <ul class="args"><li class="args">`str`: the name of the blob the data payload was uploaded to</li></ul></p>|

---
<br>

 ## CosmosDBCreateItem
 <div class='class-sig' id='prefect-tasks-azure-cosmosdb-cosmosdbcreateitem'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.azure.cosmosdb.CosmosDBCreateItem</p>(url=None, database_or_container_link=None, item=None, azure_credentials_secret=&quot;AZ_CREDENTIALS&quot;, options=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/azure/cosmosdb.py#L10">[source]</a></span></div>

Task for creating an item in a Azure Cosmos database. Note that all initialization arguments can optionally be provided or overwritten at runtime.

**Args**:     <ul class="args"><li class="args">`url (str, optional)`: The url to the database.     </li><li class="args">`database_or_container_link (str, optional)`: link to the database or container.     </li><li class="args">`item (dict, optional)`: the item to create     </li><li class="args">`azure_credentials_secret (str, optional)`: the name of the Prefect Secret that stores         your Azure credentials; this Secret must be JSON string with the key         `AZ_COSMOS_AUTH`. The value should be dictionary containing `masterKey` or         `resourceTokens`, where the `masterKey` value is the default authorization key to         use to create the client, and `resourceTokens` value is the alternative         authorization key.     </li><li class="args">`options (dict, optional)`: options to be passed to the         `azure.cosmos.cosmos_client.CosmosClient.CreateItem` method.     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-azure-cosmosdb-cosmosdbcreateitem-run'><p class="prefect-class">prefect.tasks.azure.cosmosdb.CosmosDBCreateItem.run</p>(url=None, database_or_container_link=None, item=None, azure_credentials_secret=&quot;AZ_CREDENTIALS&quot;, options=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/azure/cosmosdb.py#L47">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`url (str, optional)`: The url to the database.     </li><li class="args">`database_or_container_link (str, optional)`: link to the database or container.     </li><li class="args">`item (dict, optional)`: the item to create     </li><li class="args">`azure_credentials_secret (str, optional)`: the name of the Prefect Secret         that stores your Azure credentials; this Secret must be JSON string with the         key `AZ_COSMOS_AUTH`. The value should be dictionary containing `masterKey` or         `resourceTokens`, where the `masterKey` value is the default authorization key         to use to create the client, and `resourceTokens` value is the alternative         authorization key.     </li><li class="args">`options (dict, optional)`: options to be passed to the         `azure.cosmos.cosmos_client.CosmosClient.CreateItem` method.</li></ul> **Returns**:     <ul class="args"><li class="args">`(dict)`: the created item.</li></ul></p>|

---
<br>

 ## CosmosDBReadItems
 <div class='class-sig' id='prefect-tasks-azure-cosmosdb-cosmosdbreaditems'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.azure.cosmosdb.CosmosDBReadItems</p>(url=None, document_or_container_link=None, azure_credentials_secret=&quot;AZ_CREDENTIALS&quot;, options=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/azure/cosmosdb.py#L105">[source]</a></span></div>

Task for reading items from a Azure Cosmos database. Note that all initialization arguments can optionally be provided or overwritten at runtime.

**Args**:     <ul class="args"><li class="args">`url (str, optional)`: The url to the database.     </li><li class="args">`document_or_container_link (str, optional)`: link to a document or container.         If a document link is provided, the document in question is returned, otherwise         all docuements are returned.     </li><li class="args">`azure_credentials_secret (str, optional)`: the name of the Prefect Secret         that stores your Azure credentials; this Secret must be JSON string with the key         `AZ_COSMOS_AUTH`. The value should be dictionary containing `masterKey` or         `resourceTokens`, where the `masterKey` value is the default authorization key to         use to create the client, and `resourceTokens` value is the alternative         authorization key.     </li><li class="args">`options (dict, optional)`: options to be passed to the         `azure.cosmos.cosmos_client.CosmosClient.ReadItem` or `ReadItems` method.     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-azure-cosmosdb-cosmosdbreaditems-run'><p class="prefect-class">prefect.tasks.azure.cosmosdb.CosmosDBReadItems.run</p>(url=None, document_or_container_link=None, azure_credentials_secret=&quot;AZ_CREDENTIALS&quot;, options=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/azure/cosmosdb.py#L142">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`url (str, optional)`: The url to the database.     </li><li class="args">`document_or_container_link (str, optional)`: link to a document or container.         If a document link is provided, the document in question is returned, otherwise         all docuements are returned.     </li><li class="args">`azure_credentials_secret (str, optional)`: the name of the Prefect Secret         that stores your Azure credentials; this Secret must be JSON string with the         key `AZ_COSMOS_AUTH`. The value should be dictionary containing `masterKey` or         `resourceTokens`, where the `masterKey` value is the default authorization key         to use to create the client, and `resourceTokens` value is the alternative         authorization key.     </li><li class="args">`options (dict, optional)`: options to be passed to the         `azure.cosmos.cosmos_client.CosmosClient.ReadItem` or `ReadItems` method.</li></ul> **Returns**:     <ul class="args"><li class="args">`(dict or list))`: a single document or all documents.</li></ul></p>|

---
<br>

 ## CosmosDBQueryItems
 <div class='class-sig' id='prefect-tasks-azure-cosmosdb-cosmosdbqueryitems'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.azure.cosmosdb.CosmosDBQueryItems</p>(url=None, database_or_container_link=None, query=None, azure_credentials_secret=&quot;AZ_CREDENTIALS&quot;, options=None, partition_key=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/azure/cosmosdb.py#L211">[source]</a></span></div>

Task for creating an item in a Azure Cosmos database. Note that all initialization arguments can optionally be provided or overwritten at runtime.

**Args**:     <ul class="args"><li class="args">`url (str, optional)`: The url to the database.     </li><li class="args">`database_or_container_link (str, optional)`: link to the database or container.     </li><li class="args">`query (dict, optional)`: the query to run     </li><li class="args">`azure_credentials_secret (str, optional)`: the name of the Prefect Secret         that stores your Azure credentials; this Secret must be JSON string with the key         `AZ_COSMOS_AUTH`. The value should be dictionary containing `masterKey` or         `resourceTokens`, where the `masterKey` value is the default authorization key to         use to create the client, and `resourceTokens` value is the alternative         authorization key.     </li><li class="args">`options (dict, optional)`: options to be passed to the         `azure.cosmos.cosmos_client.CosmosClient.QueryItems` method.     </li><li class="args">`partition_key (str, None)`: Partition key for the query.     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-azure-cosmosdb-cosmosdbqueryitems-run'><p class="prefect-class">prefect.tasks.azure.cosmosdb.CosmosDBQueryItems.run</p>(url=None, database_or_container_link=None, query=None, azure_credentials_secret=&quot;AZ_CREDENTIALS&quot;, options=None, partition_key=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/azure/cosmosdb.py#L251">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`url (str, optional)`: The url to the database.     </li><li class="args">`database_or_container_link (str, optional)`: link to the database or container.     </li><li class="args">`query (dict, optional)`: the query to run     </li><li class="args">`azure_credentials_secret (str, optional)`: the name of the Prefect Secret         that stores your Azure credentials; this Secret must be JSON string with the         key `AZ_COSMOS_AUTH`. The value should be dictionary containing `masterKey` or         `resourceTokens`, where the `masterKey` value is the default authorization key         to use to create the client, and `resourceTokens` value is the alternative         authorization key.     </li><li class="args">`options (dict, optional)`: options to be passed to the         `azure.cosmos.cosmos_client.CosmosClient.QueryItems` method.     </li><li class="args">`partition_key (str, None)`: Partition key for the query.</li></ul> **Returns**:     <ul class="args"><li class="args">`(list)`: a list containing the query results, one item per row.</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on July 1, 2021 at 18:35 UTC</p>