---
sidebarDepth: 2
editLink: false
---
# AWS Tasks
---
This module contains a collection of tasks for interacting with AWS resources.

All AWS related tasks can be authenticated using the `AWS_CREDENTIALS` Prefect Secret that should be a dictionary with two keys: `"ACCESS_KEY"` and `"SECRET_ACCESS_KEY"`.  See [Third Party Authentication](../../../orchestration/recipes/third_party_auth.html) for more information.
 ## S3Download
 <div class='class-sig' id='prefect-tasks-aws-s3-s3download'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.aws.s3.S3Download</p>(bucket=None, boto_kwargs=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/s3.py#L11">[source]</a></span></div>

Task for downloading data from an S3 bucket and returning it as a string. Note that all initialization arguments can optionally be provided or overwritten at runtime.

For authentication, there are two options: you can set the `AWS_CREDENTIALS` Prefect Secret containing your AWS access keys which will be passed directly to the `boto3` client, or you can [configure your flow's runtime environment](https://boto3.amazonaws.com/v1/documentation/api/latest/guide/configuration.html#guide-configuration) for `boto3`.

**Args**:     <ul class="args"><li class="args">`bucket (str, optional)`: the name of the S3 Bucket to download from     </li><li class="args">`boto_kwargs (dict, optional)`: additional keyword arguments to forward to the boto client.     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-aws-s3-s3download-run'><p class="prefect-class">prefect.tasks.aws.s3.S3Download.run</p>(key, credentials=None, bucket=None, compression=None, as_bytes=False)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/s3.py#L39">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`key (str)`: the name of the Key within this bucket to retrieve     </li><li class="args">`credentials (dict, optional)`: your AWS credentials passed from an upstream         Secret task; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY` which will be         passed directly to `boto3`.  If not provided here or in context, `boto3`         will fall back on standard AWS rules for authentication.     </li><li class="args">`bucket (str, optional)`: the name of the S3 Bucket to download from     </li><li class="args">`compression (str, optional)`: specifies a file format for decompression, decompressing         data upon download. Currently supports `'gzip'`.     </li><li class="args">`as_bytes (bool, optional)`: If true, result will be returned as         `bytes` instead of `str`. Defaults to False.</li></ul> **Returns**:     <ul class="args"><li class="args">`str`: the contents of this Key / Bucket, as a string or bytes</li></ul></p>|

---
<br>

 ## S3Upload
 <div class='class-sig' id='prefect-tasks-aws-s3-s3upload'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.aws.s3.S3Upload</p>(bucket=None, boto_kwargs=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/s3.py#L91">[source]</a></span></div>

Task for uploading string data (e.g., a JSON string) to an S3 bucket. Note that all initialization arguments can optionally be provided or overwritten at runtime.

For authentication, there are two options: you can set a Prefect Secret containing your AWS access keys which will be passed directly to the `boto3` client, or you can [configure your flow's runtime environment](https://boto3.amazonaws.com/v1/documentation/api/latest/guide/configuration.html#guide-configuration) for `boto3`.

**Args**:     <ul class="args"><li class="args">`bucket (str, optional)`: the name of the S3 Bucket to upload to     </li><li class="args">`boto_kwargs (dict, optional)`: additional keyword arguments to forward to the boto client.     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-aws-s3-s3upload-run'><p class="prefect-class">prefect.tasks.aws.s3.S3Upload.run</p>(data, key=None, credentials=None, bucket=None, compression=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/s3.py#L119">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`data (str)`: the data payload to upload     </li><li class="args">`key (str, optional)`: the Key to upload the data under; if not         provided, a random `uuid` will be created     </li><li class="args">`credentials (dict, optional)`: your AWS credentials passed from an upstream         Secret task; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY` which will be         passed directly to `boto3`.  If not provided here or in context, `boto3`         will fall back on standard AWS rules for authentication.     </li><li class="args">`bucket (str, optional)`: the name of the S3 Bucket to upload to     </li><li class="args">`compression (str, optional)`: specifies a file format for compression,         compressing data before upload. Currently supports `'gzip'`.</li></ul> **Returns**:     <ul class="args"><li class="args">`str`: the name of the Key the data payload was uploaded to</li></ul></p>|

---
<br>

 ## S3List
 <div class='class-sig' id='prefect-tasks-aws-s3-s3list'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.aws.s3.S3List</p>(bucket=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/s3.py#L174">[source]</a></span></div>

Task for listing files from an S3 bucket. Note that all initialization arguments can optionally be provided or overwritten at runtime.

For authentication, there are two options: you can set the `AWS_CREDENTIALS` Prefect Secret containing your AWS access keys which will be passed directly to the `boto3` client, or you can [configure your flow's runtime environment](https://boto3.amazonaws.com/v1/documentation/api/latest/guide/configuration.html#guide-configuration) for `boto3`.

**Args**:     <ul class="args"><li class="args">`bucket (str, optional)`: the name of the S3 Bucket to list the files of.     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-aws-s3-s3list-run'><p class="prefect-class">prefect.tasks.aws.s3.S3List.run</p>(prefix, delimiter=&quot;&quot;, page_size=None, max_items=None, credentials=None, bucket=None, last_modified_begin=None, last_modified_end=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/s3.py#L195">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`prefix (str)`: the name of the prefix within this bucket to retrieve objects from     </li><li class="args">`delimiter (str)`: indicates the key hierarchy     </li><li class="args">`page_size (int)`: controls the number of items returned per page of each result     </li><li class="args">`max_items (int)`: limits the maximum number of total items returned during pagination     </li><li class="args">`credentials (dict, optional)`: your AWS credentials passed from an upstream         Secret task; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY` which will be         passed directly to `boto3`.  If not provided here or in context, `boto3`         will fall back on standard AWS rules for authentication.     </li><li class="args">`bucket (str, optional)`: the name of the S3 Bucket to list the files of     </li><li class="args">`last_modified_begin (str, optional)`: keep items with `LastModified` greater than         or equal to given value. timestamp should be in `RFC 3339`, `ISO 8601` or any         pendulum supported [format](https://pendulum.eustace.io/docs/#parsing).     </li><li class="args">`last_modified_end (str, optional)`: keep items with `LastModified` less than         or equal to given value. timestamp should be in `RFC 3339`, `ISO 8601` or any         pendulum supported [format](https://pendulum.eustace.io/docs/#parsing).</li></ul> **Returns**:     <ul class="args"><li class="args">`list[str]`: A list of keys that match the given prefix.</li></ul></p>|

---
<br>

 ## LambdaCreate
 <div class='class-sig' id='prefect-tasks-aws-lambda-function-lambdacreate'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.aws.lambda_function.LambdaCreate</p>(function_name, runtime, role, handler, zip_file=None, bucket=&quot;&quot;, bucket_key=&quot;&quot;, object_version=None, description=&quot;&quot;, function_timeout=3, memorysize=128, publish=True, subnet_ids=None, security_group_ids=None, dead_letter_config=None, environment_variables=None, kms_key_arn=&quot;&quot;, function_tags=None, tracing_config=&quot;PassThrough&quot;, layers=None, boto_kwargs=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/lambda_function.py#L9">[source]</a></span></div>

Task for creating a Lambda function.

**Args**:     <ul class="args"><li class="args">`function_name (str)`: name of the Lambda function to create     </li><li class="args">`runtime (str)`: the identifier of the function's runtime     </li><li class="args">`role (str)`: the Amazon Resource Name of the function's execution role     </li><li class="args">`handler (str)`: the name of the method within your code that Lambda calls         to execute your function     </li><li class="args">`zip_file (str)`: path to zip file containing code for Lambda function,         either zip_file or (bucket and bucket_key) must be passed     </li><li class="args">`bucket (str)`: an S3 bucket in the same AWS region as your function     </li><li class="args">`bucket_key (str)`: the Amazon S3 key of the deployment package     </li><li class="args">`object_version (str, optional)`: for versioned S3 objects, the version of the         deployment package to use     </li><li class="args">`description (str, optional)`: description of Lambda function     </li><li class="args">`function_timeout (int, optional)`: Lambda function timeout in seconds, default is 3 seconds     </li><li class="args">`memorysize (int, optional)`: amount of memory that Lambda function has         access to in MB, must be a multiple of 64 MB, default is 128     </li><li class="args">`publish (bool, optional)`: set to True to publish the first version of the         function during creation, defaults to True     </li><li class="args">`subnet_ids (List[str], optional)`: list of subnet ids for vpc         configuration     </li><li class="args">`security_group_ids (List[str], optional)`: list of security         group ideas for vpc configuration     </li><li class="args">`dead_letter_config (dict, optional)`: a dead letter queue configuration that         specifies the queue or topic where Lambda sends asynchronous events         when they fail processing     </li><li class="args">`environment_variables (dict, optional)`: key-value pairs of environment         variables to pass to the Lambda function     </li><li class="args">`kms_key_arn (str, optional)`: the ARN of the AWS key management service used         to encrypt your function's environment variables, if not provided, AWS         Lambda uses a default service key     </li><li class="args">`function_tags (dict, optional)`: a list of tags to apply to the function, string         to string map     </li><li class="args">`tracing_config (str, optional)`: set to Active to samle and trace a         subset of incoming requests with Amazon X-Ray     </li><li class="args">`layers (List[str], optional)`: a list of function layers to add to         the function's execution environment, specify each layer by its ARN     </li><li class="args">`boto_kwargs (dict, optional)`: additional keyword arguments to forward to the boto client.     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-aws-lambda-function-lambdacreate-run'><p class="prefect-class">prefect.tasks.aws.lambda_function.LambdaCreate.run</p>(credentials=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/lambda_function.py#L117">[source]</a></span></div>
<p class="methods">Task run method. Creates Lambda function.<br><br>**Args**:     <ul class="args"><li class="args">`credentials (dict, optional)`: your AWS credentials passed from an upstream         Secret task; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY` which will be         passed directly to `boto3`.  If not provided here or in context, `boto3`         will fall back on standard AWS rules for authentication.</li></ul> **Returns**:     <ul class="args"><li class="args">`json`: response from AWS CreateFunction endpoint</li></ul></p>|

---
<br>

 ## LambdaDelete
 <div class='class-sig' id='prefect-tasks-aws-lambda-function-lambdadelete'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.aws.lambda_function.LambdaDelete</p>(function_name, qualifier=&quot;&quot;, boto_kwargs=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/lambda_function.py#L159">[source]</a></span></div>

Task for deleting a Lambda function.

**Args**:     <ul class="args"><li class="args">`function_name (str)`: name of the Lambda function to delete     </li><li class="args">`qualifier (str, optional)`: specify a version to delete, if not         provided, the function will be deleted entirely     </li><li class="args">`boto_kwargs (dict, optional)`: additional keyword arguments to forward to the boto client.     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-aws-lambda-function-lambdadelete-run'><p class="prefect-class">prefect.tasks.aws.lambda_function.LambdaDelete.run</p>(credentials=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/lambda_function.py#L189">[source]</a></span></div>
<p class="methods">Task run method. Deletes Lambda function.<br><br>**Args**:     <ul class="args"><li class="args">`credentials (dict, optional)`: your AWS credentials passed from an upstream         Secret task; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY` which will be         passed directly to `boto3`.  If not provided here or in context, `boto3`         will fall back on standard AWS rules for authentication.</li></ul> **Returns**:     <ul class="args"><li class="args">`dict`: response from AWS DeleteFunction endpoint</li></ul></p>|

---
<br>

 ## LambdaInvoke
 <div class='class-sig' id='prefect-tasks-aws-lambda-function-lambdainvoke'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.aws.lambda_function.LambdaInvoke</p>(function_name, invocation_type=&quot;RequestResponse&quot;, log_type=&quot;None&quot;, client_context=None, payload=&quot;null&quot;, qualifier=&quot;$LATEST&quot;, boto_kwargs=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/lambda_function.py#L219">[source]</a></span></div>

Task to invoke a Lambda function.

**Args**:     <ul class="args"><li class="args">`function_name (str)`: the name of the Lambda funciton to invoke     </li><li class="args">`invocation_type (str, optional)`: the invocation type of Lambda         function, default is RequestResponse other options include         Event and DryRun     </li><li class="args">`log_type (str, optional)`: set to 'Tail' to include the execution         log in the response     </li><li class="args">`client_context (dict, optional)`: data to pass to the function in the         context object, dict object will be transformed into base64 encoded         json automatically     </li><li class="args">`payload (bytes or seekable file-like object)`: the JSON provided to         Lambda function as input     </li><li class="args">`qualifier (str, optional)`: specify a version or alias to invoke a         published version of the function, defaults to $LATEST     </li><li class="args">`boto_kwargs (dict, optional)`: additional keyword arguments to forward to the boto client.     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-aws-lambda-function-lambdainvoke-run'><p class="prefect-class">prefect.tasks.aws.lambda_function.LambdaInvoke.run</p>(function_name=None, payload=None, credentials=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/lambda_function.py#L288">[source]</a></span></div>
<p class="methods">Task run method. Invokes Lambda function.<br><br>**Args**:     <ul class="args"><li class="args">`function_name (str)`: the name of the Lambda funciton to invoke     </li><li class="args">`payload (bytes or seekable file-like object)`: the JSON provided to         Lambda function as input     </li><li class="args">`credentials (dict, optional)`: your AWS credentials passed from an upstream         Secret task; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY` which will be         passed directly to `boto3`.  If not provided here or in context, `boto3`         will fall back on standard AWS rules for authentication.</li></ul> **Returns**:     <ul class="args"><li class="args">`dict `: response from AWS Invoke endpoint</li></ul></p>|

---
<br>

 ## LambdaList
 <div class='class-sig' id='prefect-tasks-aws-lambda-function-lambdalist'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.aws.lambda_function.LambdaList</p>(master_region=&quot;ALL&quot;, function_version=&quot;ALL&quot;, marker=None, max_items=50, boto_kwargs=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/lambda_function.py#L329">[source]</a></span></div>

Task to list Lambda functions.

**Args**:     <ul class="args"><li class="args">`master_region (str, optional)`: for Lambda@Edge functions, the AWS         region of the master function     </li><li class="args">`function_version (str, optional)`: the version of a function,         default is 'ALL'     </li><li class="args">`marker (str, optional)`: specify the pagination token that's returned         by a previous request to retreive the next page of results     </li><li class="args">`max_items (int, optional)`: specify a value between 1 and 50 to limit         the number of functions in the response     </li><li class="args">`boto_kwargs (dict, optional)`: additional keyword arguments to forward to the boto client.     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-aws-lambda-function-lambdalist-run'><p class="prefect-class">prefect.tasks.aws.lambda_function.LambdaList.run</p>(credentials=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/lambda_function.py#L368">[source]</a></span></div>
<p class="methods">Task fun method. Lists all Lambda functions.<br><br>**Args**:     <ul class="args"><li class="args">`credentials (dict, optional)`: your AWS credentials passed from an upstream         Secret task; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY` which will be         passed directly to `boto3`.  If not provided here or in context, `boto3`         will fall back on standard AWS rules for authentication.</li></ul> **Returns**:     <ul class="args"><li class="args">`dict `: a list of Lambda functions from AWS ListFunctions endpoint</li></ul></p>|

---
<br>

 ## StepActivate
 <div class='class-sig' id='prefect-tasks-aws-step-function-stepactivate'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.aws.step_function.StepActivate</p>(state_machine_arn, execution_name, execution_input=&quot;{}&quot;, boto_kwargs=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/step_function.py#L5">[source]</a></span></div>

Task for activating an AWS Step Function.

**Args**:     <ul class="args"><li class="args">`state_machine_arn (str)`: the Amazon Resource Name (ARN) of the state machine         to execute     </li><li class="args">`execution_name (str)`: the name of the execution, this name must be unique for         your AWS account, region, and state machine for 90 days     </li><li class="args">`execution_input (str, optional)`: string that contains the JSON input data for         the execution     </li><li class="args">`boto_kwargs (dict, optional)`: additional keyword arguments to forward to the boto client.     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-aws-step-function-stepactivate-run'><p class="prefect-class">prefect.tasks.aws.step_function.StepActivate.run</p>(credentials=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/step_function.py#L40">[source]</a></span></div>
<p class="methods">Task run method. Activates AWS Step function.<br><br>**Args**:     <ul class="args"><li class="args">`credentials (dict, optional)`: your AWS credentials passed from an upstream         Secret task; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY` which will be         passed directly to `boto3`.  If not provided here or in context, `boto3`         will fall back on standard AWS rules for authentication.</li></ul> **Returns**:     <ul class="args"><li class="args">`dict`: response from AWS StartExecution endpoint</li></ul></p>|

---
<br>

 ## AWSSecretsManager
 <div class='class-sig' id='prefect-tasks-aws-secrets-manager-awssecretsmanager'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.aws.secrets_manager.AWSSecretsManager</p>(secret=None, boto_kwargs=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/secrets_manager.py#L8">[source]</a></span></div>

Task for retrieving secrets from an AWS Secrets Manager and returning it as a dictionary. Note that all initialization arguments can optionally be provided or overwritten at runtime.

For authentication, there are two options: you can set the `AWS_CREDENTIALS` Prefect Secret containing your AWS access keys which will be passed directly to the `boto3` client, or you can [configure your flow's runtime environment](https://boto3.amazonaws.com/v1/documentation/api/latest/guide/configuration.html#guide-configuration) for `boto3`.

**Args**:     <ul class="args"><li class="args">`secret (str, optional)`: the name of the secret to retrieve     </li><li class="args">`boto_kwargs (dict, optional)`: additional keyword arguments to forward to the boto client.     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-aws-secrets-manager-awssecretsmanager-run'><p class="prefect-class">prefect.tasks.aws.secrets_manager.AWSSecretsManager.run</p>(secret=None, credentials=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/secrets_manager.py#L36">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`secret (str)`: the name of the secret to retrieve     </li><li class="args">`credentials (dict, optional)`: your AWS credentials passed from an upstream         Secret task; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY` which will be         passed directly to `boto3`.  If not provided here or in context, `boto3`         will fall back on standard AWS rules for authentication.</li></ul> **Returns**:     <ul class="args"><li class="args">`dict`: the contents of this secret, as a dictionary</li></ul></p>|

---
<br>

 ## BatchSubmit
 <div class='class-sig' id='prefect-tasks-aws-batch-batchsubmit'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.aws.batch.BatchSubmit</p>(job_name=None, job_definition=None, job_queue=None, boto_kwargs=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/batch.py#L7">[source]</a></span></div>

Task for submitting a job to AWS batch.

For authentication, there are two options: you can set the `AWS_CREDENTIALS` Prefect Secret containing your AWS access keys which will be passed directly to the `boto3` client, or you can [configure your flow's runtime environment](https://boto3.amazonaws.com/v1/documentation/api/latest/guide/configuration.html#guide-configuration) for `boto3`.

**Args**:     <ul class="args"><li class="args">`job_name (str, optional)`: The AWS batch job name.     </li><li class="args">`job_definition (str, optional)`: The AWS batch job definition.     </li><li class="args">`job_queue (str, optional)`: Name of the AWS batch job queue.     </li><li class="args">`boto_kwargs (dict, optional)`: additional kekyword arguments to forward to the boto client.     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-aws-batch-batchsubmit-run'><p class="prefect-class">prefect.tasks.aws.batch.BatchSubmit.run</p>(job_name=None, job_definition=None, job_queue=None, batch_kwargs=None, credentials=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/batch.py#L45">[source]</a></span></div>
<p class="methods">Submit a job to the AWS Batch job service.<br><br>**Args**:     <ul class="args"><li class="args">`job_name (str, optional)`: The AWS batch job name.     </li><li class="args">`job_definition (str, optional)`: The AWS batch job definition.     </li><li class="args">`job_queue (str, optional)`: Name of the AWS batch job queue.     </li><li class="args">`batch_kwargs (dict, optional)`: Additional keyword arguments to pass to the boto3         `submit_job` function. See the [submit_job](https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/batch.html#Batch.Client.submit_job)  # noqa         documentation for more details.     </li><li class="args">`credentials (dict, optional)`: your AWS credentials passed from an upstream         Secret task; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY` which will be         passed directly to `boto3`.  If not provided here or in context, `boto3`         will fall back on standard AWS rules for authentication.</li></ul></p>|

---
<br>

 ## AWSClientWait
 <div class='class-sig' id='prefect-tasks-aws-client-waiter-awsclientwait'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.aws.client_waiter.AWSClientWait</p>(client=None, waiter_name=None, waiter_definition=None, boto_kwargs=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/client_waiter.py#L19">[source]</a></span></div>

Task for waiting on a long-running AWS job. Uses the underlying boto3 waiter functionality.

For authentication, there are two options: you can set the `AWS_CREDENTIALS` Prefect Secret containing your AWS access keys which will be passed directly to the `boto3` client, or you can [configure your flow's runtime environment](https://boto3.amazonaws.com/v1/documentation/api/latest/guide/configuration.html#guide-configuration) for `boto3`.

**Args**:     <ul class="args"><li class="args">`client (str, optional)`: The AWS client on which to wait (e.g., 'batch', 'ec2', etc)     </li><li class="args">`waiter_name (str, optional)`: The name of the waiter to instantiate. Can be a boto-supported         waiter or one of prefect's custom waiters. Currently, prefect offers three additional         waiters for AWS Batch: `"JobExists"` waits for a job to be instantiated, `"JobRunning"`         waits for a job to start running, and `"JobComplete"` waits for a job to finish. You can         find the definitions for all prefect-defined waiters [here](https://github.com/PrefectHQ/prefect/tree/master/src/prefect/tasks/aws/waiters).  # noqa         You may also use a custom waiter name, if you supply an accompanying waiter definition         dict.     </li><li class="args">`waiter_definition (dict, optional)`: A valid custom waiter model, as a dict. Note that if         you supply a custom definition, it is assumed that the provided 'waiter_name' is         contained within the waiter definition dict.     </li><li class="args">`boto_kwargs (dict, optional)`: additional kekyword arguments to forward to the boto client.     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-aws-client-waiter-awsclientwait-run'><p class="prefect-class">prefect.tasks.aws.client_waiter.AWSClientWait.run</p>(client=None, waiter_name=None, waiter_definition=None, waiter_kwargs=None, credentials=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/client_waiter.py#L61">[source]</a></span></div>
<p class="methods">Task for waiting on a long-running AWS job. Uses the underlying boto3 waiter functionality.<br><br>**Args**:     <ul class="args"><li class="args">`client (str)`: The AWS client on which to wait (e.g., 'batch', 'ec2', etc)     </li><li class="args">`waiter_name (str, optional)`: The name of the waiter to instantiate. Can be a boto-supported         waiter or one of prefect's custom waiters. Currently, prefect offers three additional         waiters for AWS Batch: `"JobExists"` waits for a job to be instantiated, `"JobRunning"`         waits for a job to start running, and `"JobComplete"` waits for a job to finish. You can         find the definitions for all prefect-defined waiters [here](https://github.com/PrefectHQ/prefect/tree/master/src/prefect/tasks/aws/waiters).  # noqa         You may also use a custom waiter name, if you supply an accompanying waiter definition         dict.     </li><li class="args">`waiter_definition (dict, optional)`: A valid custom waiter model, as a dict. Note that if         you supply a custom definition, it is assumed that the provided 'waiter_name' is         contained within the waiter definition dict.     </li><li class="args">`waiter_kwargs (dict, optional)`: Arguments to pass to the `waiter.wait(...)` method. Will         depend upon the specific waiter being called.     </li><li class="args">`credentials (dict, optional)`: your AWS credentials passed from an upstream         Secret task; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY` which will be         passed directly to `boto3`.  If not provided here or in context, `boto3`         will fall back on standard AWS rules for authentication.</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on July 1, 2021 at 18:35 UTC</p>