---
sidebarDepth: 2
editLink: false
---
# Client
---
 ## Client
 <div class='class-sig' id='prefect-client-client-client'><p class="prefect-sig">class </p><p class="prefect-class">prefect.client.client.Client</p>(api_server=None, api_token=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L74">[source]</a></span></div>

Client for communication with Prefect Cloud

If the arguments aren't specified the client initialization first checks the prefect configuration and if the server is not set there it checks the current context. The token will only be present in the current context.

**Args**:     <ul class="args"><li class="args">`api_server (str, optional)`: the URL to send all GraphQL requests         to; if not provided, will be pulled from `cloud.graphql` config var     </li><li class="args">`api_token (str, optional)`: a Prefect Cloud API token, taken from         `config.cloud.auth_token` if not provided. If this token is USER-scoped, it may         be used to log in to any tenant that the user is a member of. In that case,         ephemeral JWTs will be loaded as necessary. Otherwise, the API token itself         will be used as authorization.</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-client-client-client-attach-headers'><p class="prefect-class">prefect.client.client.Client.attach_headers</p>(headers)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L495">[source]</a></span></div>
<p class="methods">Set headers to be attached to this Client<br><br>**Args**:     <ul class="args"><li class="args">`headers (dict)`: A dictionary of headers to attach to this client. These headers         get added on to the existing dictionary of headers.</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-cancel-flow-run'><p class="prefect-class">prefect.client.client.Client.cancel_flow_run</p>(flow_run_id)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L1440">[source]</a></span></div>
<p class="methods">Cancel the flow run by id<br><br>**Args**:     <ul class="args"><li class="args">`flow_run_id (str)`: the id of the flow run</li></ul> **Returns**:     <ul class="args"><li class="args">`bool`: whether or not the flow run was canceled</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-create-flow-run'><p class="prefect-class">prefect.client.client.Client.create_flow_run</p>(flow_id=None, context=None, parameters=None, run_config=None, labels=None, scheduled_start_time=None, idempotency_key=None, run_name=None, version_group_id=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L1037">[source]</a></span></div>
<p class="methods">Create a new flow run for the given flow id.  If `start_time` is not provided, the flow run will be scheduled to start immediately.  If both `flow_id` and `version_group_id` are provided, only the `flow_id` will be used.<br><br>**Args**:     <ul class="args"><li class="args">`flow_id (str, optional)`: the id of the Flow you wish to schedule     </li><li class="args">`context (dict, optional)`: the run context     </li><li class="args">`parameters (dict, optional)`: a dictionary of parameter values to pass to the flow run     </li><li class="args">`run_config (RunConfig, optional)`: a run-config to use for this         flow run, overriding any existing flow settings.     </li><li class="args">`labels (List[str], optional)`: a list of labels to apply to the flow run     </li><li class="args">`scheduled_start_time (datetime, optional)`: the time to schedule the execution         for; if not provided, defaults to now     </li><li class="args">`idempotency_key (str, optional)`: an idempotency key; if provided, this run will         be cached for 24 hours. Any subsequent attempts to create a run with the same         idempotency key will return the ID of the originally created run (no new run         will be created after the first).  An error will be raised if parameters or         context are provided and don't match the original.  Each subsequent request         will reset the TTL for 24 hours.     </li><li class="args">`run_name (str, optional)`: The name assigned to this flow run     </li><li class="args">`version_group_id (str, optional)`: if provided, the unique unarchived flow within         this version group will be scheduled to run.  This input can be used as a         stable API for running flows which are regularly updated.</li></ul> **Returns**:     <ul class="args"><li class="args">`str`: the ID of the newly-created flow run</li></ul> **Raises**:     <ul class="args"><li class="args">`ClientError`: if the GraphQL query is bad for any reason</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-create-project'><p class="prefect-class">prefect.client.client.Client.create_project</p>(project_name, project_description=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L950">[source]</a></span></div>
<p class="methods">Create a new project if a project with the name provided does not already exist<br><br>**Args**:     <ul class="args"><li class="args">`project_name (str)`: the project that should be created     </li><li class="args">`project_description (str, optional)`: the project description</li></ul> **Returns**:     <ul class="args"><li class="args">`str`: the ID of the newly-created or pre-existing project</li></ul> **Raises**:     <ul class="args"><li class="args">`ClientError`: if the project creation failed</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-create-task-run-artifact'><p class="prefect-class">prefect.client.client.Client.create_task_run_artifact</p>(task_run_id, kind, data, tenant_id=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L1734">[source]</a></span></div>
<p class="methods">Create an artifact that corresponds to a specific task run<br><br>**Args**:     <ul class="args"><li class="args">`task_run_id (str)`: the task run id     </li><li class="args">`kind (str)`: the artifact kind     </li><li class="args">`data (dict)`: the artifact data     </li><li class="args">`tenant_id (str, optional)`: the tenant id that this artifact belongs to. Defaults         to the tenant ID linked to the task run</li></ul> **Returns**:     <ul class="args"><li class="args">`str`: the task run artifact ID</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-create-tenant'><p class="prefect-class">prefect.client.client.Client.create_tenant</p>(name, slug=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L111">[source]</a></span></div>
<p class="methods">Creates a new tenant.<br><br>Note this route only works when run against Prefect Server.<br><br>**Args**:     <ul class="args"><li class="args">`name (str)`: the name of the tenant to create     </li><li class="args">`slug (str, optional)`: the slug of the tenant to create; defaults to name</li></ul> **Returns**:     <ul class="args"><li class="args">`str`: the ID of the newly created tenant, or the ID of the currently active tenant</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if run against Prefect Cloud</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-delete-project'><p class="prefect-class">prefect.client.client.Client.delete_project</p>(project_name)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L996">[source]</a></span></div>
<p class="methods">Delete a project<br><br>**Args**:     <ul class="args"><li class="args">`project_name (str)`: the project that should be created</li></ul> **Returns**:     <ul class="args"><li class="args">`bool`: True if project is deleted else False **Raises**:     </li><li class="args">`ValueError`: if the project is None or doesn't exist</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-delete-task-run-artifact'><p class="prefect-class">prefect.client.client.Client.delete_task_run_artifact</p>(task_run_artifact_id)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L1797">[source]</a></span></div>
<p class="methods">Delete an artifact that corresponds to a specific task run<br><br>**Args**:     <ul class="args"><li class="args">`task_run_artifact_id (str)`: the task run artifact id</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-delete-task-tag-limit'><p class="prefect-class">prefect.client.client.Client.delete_task_tag_limit</p>(limit_id)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L1622">[source]</a></span></div>
<p class="methods">Deletes a given task tag concurrency limit; requires tenant admin permissions.<br><br>**Args**:     <ul class="args"><li class="args">`limit_id (str)`: the ID of the tag to delete</li></ul> **Raises**:     <ul class="args"><li class="args">`ClientError`: if the GraphQL mutation is bad for any reason     </li><li class="args">`ValueError`: if the tag deletion was unsuccessful, or if a bad tag ID was provided</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-get'><p class="prefect-class">prefect.client.client.Client.get</p>(path, server=None, headers=None, params=None, token=None, retry_on_api_error=True)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L147">[source]</a></span></div>
<p class="methods">Convenience function for calling the Prefect API with token auth and GET request<br><br>**Args**:     <ul class="args"><li class="args">`path (str)`: the path of the API url. For example, to GET         http://prefect-server/v1/auth/login, path would be 'auth/login'.     </li><li class="args">`server (str, optional)`: the server to send the GET request to;         defaults to `self.api_server`     </li><li class="args">`headers (dict, optional)`: Headers to pass with the request     </li><li class="args">`params (dict)`: GET parameters     </li><li class="args">`token (str)`: an auth token. If not supplied, the `client.access_token` is used.     </li><li class="args">`retry_on_api_error (bool)`: whether the operation should be retried if the API returns         an API_ERROR code</li></ul> **Returns**:     <ul class="args"><li class="args">`dict`: Dictionary representation of the request made</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-get-agent-config'><p class="prefect-class">prefect.client.client.Client.get_agent_config</p>(agent_config_id)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L1713">[source]</a></span></div>
<p class="methods">Get agent config settings<br><br>**Args**:     <ul class="args"><li class="args">`agent_config_id (str)`: The ID of an agent configuration to retrieve</li></ul> **Returns**:     <ul class="args"><li class="args">`dict`: the agent configuration's `settings`</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-get-auth-token'><p class="prefect-class">prefect.client.client.Client.get_auth_token</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L545">[source]</a></span></div>
<p class="methods">Returns an auth token:     - if no explicit access token is stored, returns the api token     - if there is an access token:         - if there's a refresh token and the access token expires in the next 30 seconds,           then we refresh the access token and store the result         - return the access token<br><br>**Returns**:     <ul class="args"><li class="args">`str`: the access token</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-get-available-tenants'><p class="prefect-class">prefect.client.client.Client.get_available_tenants</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L566">[source]</a></span></div>
<p class="methods">Returns a list of available tenants.<br><br>NOTE: this should only be called by users who have provided a USER-scoped API token.<br><br>**Returns**:     <ul class="args"><li class="args">`List[Dict]`: a list of dictionaries containing the id, slug, and name of     available tenants</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-get-cloud-url'><p class="prefect-class">prefect.client.client.Client.get_cloud_url</p>(subdirectory, id, as_user=True)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L881">[source]</a></span></div>
<p class="methods">Convenience method for creating Prefect Cloud URLs for a given subdirectory.<br><br>**Args**:     <ul class="args"><li class="args">`subdirectory (str)`: the subdirectory to use (e.g., `"flow-run"`)     </li><li class="args">`id (str)`: the ID of the page     </li><li class="args">`as_user (bool, optional)`: whether this query is being made from a USER scoped token;         defaults to `True`. Only used internally for queries made from RUNNERs</li></ul> **Returns**:     <ul class="args"><li class="args">`str`: the URL corresponding to the appropriate base URL, tenant slug, subdirectory         and ID</li></ul> **Example**:<br><br><br><pre class="language-python"><code class="language-python"><span class="token keyword">from</span> prefect <span class="token keyword">import</span> Client<br><br>client <span class="token operator">=</span> Client<span class="token punctuation">(</span><span class="token punctuation">)</span><br>client<span class="token operator">.</span>get_cloud_url<span class="token punctuation">(</span><span class="token string">"</span><span class="token string">flow-run</span><span class="token string">"</span><span class="token punctuation">,</span> <span class="token string">"</span><span class="token string">424242-ca-94611-111-55</span><span class="token string">"</span><span class="token punctuation">)</span><br><span class="token comment"># returns "https://cloud.prefect.io/my-tenant-slug/flow-run/424242-ca-94611-111-55"</span><br></code></pre><br></p>|
 | <div class='method-sig' id='prefect-client-client-client-get-default-tenant-slug'><p class="prefect-class">prefect.client.client.Client.get_default_tenant_slug</p>(as_user=True)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L923">[source]</a></span></div>
<p class="methods">Get the default tenant slug for the currently authenticated user<br><br>**Args**:     <ul class="args"><li class="args">`as_user (bool, optional)`: whether this query is being made from a USER scoped token;         defaults to `True`. Only used internally for queries made from RUNNERs</li></ul> **Returns**:     <ul class="args"><li class="args">`str`: the slug of the current default tenant for this user</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-get-flow-run-info'><p class="prefect-class">prefect.client.client.Client.get_flow_run_info</p>(flow_run_id)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L1111">[source]</a></span></div>
<p class="methods">Retrieves version and current state information for the given flow run.<br><br>**Args**:     <ul class="args"><li class="args">`flow_run_id (str)`: the id of the flow run to get information for</li></ul> **Returns**:     <ul class="args"><li class="args">`GraphQLResult`: an object representing information about the flow run</li></ul> **Raises**:     <ul class="args"><li class="args">`ClientError`: if the GraphQL mutation is bad for any reason</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-get-flow-run-state'><p class="prefect-class">prefect.client.client.Client.get_flow_run_state</p>(flow_run_id)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L1242">[source]</a></span></div>
<p class="methods">Retrieves the current state for a flow run.<br><br>**Args**:     <ul class="args"><li class="args">`flow_run_id (str)`: the id for this flow run</li></ul> **Returns**:     <ul class="args"><li class="args">`State`: a Prefect State object</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-get-latest-cached-states'><p class="prefect-class">prefect.client.client.Client.get_latest_cached_states</p>(task_id, cache_key, created_after)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L1322">[source]</a></span></div>
<p class="methods">Pulls all Cached states for the given task that were created after the provided date.<br><br>**Args**:     <ul class="args"><li class="args">`task_id (str)`: the task id for this task run     </li><li class="args">`cache_key (Optional[str])`: the cache key for this Task's cache; if `None`, the         task id alone will be used     </li><li class="args">`created_after (datetime.datetime)`: the earliest date the state should have been         created at</li></ul> **Returns**:     <ul class="args"><li class="args">`List[State]`: a list of Cached states created after the given date</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-get-task-run-info'><p class="prefect-class">prefect.client.client.Client.get_task_run_info</p>(flow_run_id, task_id, map_index=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L1362">[source]</a></span></div>
<p class="methods">Retrieves version and current state information for the given task run.<br><br>**Args**:     <ul class="args"><li class="args">`flow_run_id (str)`: the id of the flow run that this task run lives in     </li><li class="args">`task_id (str)`: the task id for this task run     </li><li class="args">`map_index (int, optional)`: the mapping index for this task run; if         `None`, it is assumed this task is _not_ mapped</li></ul> **Returns**:     <ul class="args"><li class="args">`NamedTuple`: a tuple containing `id, task_id, version, state`</li></ul> **Raises**:     <ul class="args"><li class="args">`ClientError`: if the GraphQL mutation is bad for any reason</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-get-task-run-state'><p class="prefect-class">prefect.client.client.Client.get_task_run_state</p>(task_run_id)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L1462">[source]</a></span></div>
<p class="methods">Retrieves the current state for a task run.<br><br>**Args**:     <ul class="args"><li class="args">`task_run_id (str)`: the id for this task run</li></ul> **Returns**:     <ul class="args"><li class="args">`State`: a Prefect State object</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-get-task-tag-limit'><p class="prefect-class">prefect.client.client.Client.get_task_tag_limit</p>(tag)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L1570">[source]</a></span></div>
<p class="methods">Retrieve the current task tag concurrency limit for a given tag.<br><br>**Args**:     <ul class="args"><li class="args">`tag (str)`: the tag to update</li></ul> **Raises**:     <ul class="args"><li class="args">`ClientError`: if the GraphQL query fails</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-graphql'><p class="prefect-class">prefect.client.client.Client.graphql</p>(query, raise_on_error=True, headers=None, variables=None, token=None, retry_on_api_error=True)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L267">[source]</a></span></div>
<p class="methods">Convenience function for running queries against the Prefect GraphQL API<br><br>**Args**:     <ul class="args"><li class="args">`query (Any)`: A representation of a graphql query to be executed. It will be         parsed by prefect.utilities.graphql.parse_graphql().     </li><li class="args">`raise_on_error (bool)`: if True, a `ClientError` will be raised if the GraphQL         returns any `errors`.     </li><li class="args">`headers (dict)`: any additional headers that should be passed as part of the         request     </li><li class="args">`variables (dict)`: Variables to be filled into a query with the key being         equivalent to the variables that are accepted by the query     </li><li class="args">`token (str)`: an auth token. If not supplied, the `client.access_token` is used.     </li><li class="args">`retry_on_api_error (bool)`: whether the operation should be retried if the API returns         an API_ERROR code</li></ul> **Returns**:     <ul class="args"><li class="args">`dict`: Data returned from the GraphQL query</li></ul> **Raises**:     <ul class="args"><li class="args">ClientError if there are errors raised by the GraphQL mutation</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-login-to-tenant'><p class="prefect-class">prefect.client.client.Client.login_to_tenant</p>(tenant_slug=None, tenant_id=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L583">[source]</a></span></div>
<p class="methods">Log in to a specific tenant<br><br>NOTE: this should only be called by users who have provided a USER-scoped API token.<br><br>**Args**:     <ul class="args"><li class="args">`tenant_slug (str)`: the tenant's slug     </li><li class="args">`tenant_id (str)`: the tenant's id</li></ul> **Returns**:     <ul class="args"><li class="args">`bool`: True if the login was successful</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if at least one of `tenant_slug` or `tenant_id` isn't provided     </li><li class="args">`ValueError`: if the `tenant_id` is not a valid UUID     </li><li class="args">`ValueError`: if no matching tenants are found</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-logout-from-tenant'><p class="prefect-class">prefect.client.client.Client.logout_from_tenant</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L658">[source]</a></span></div>
<p class="methods"></p>|
 | <div class='method-sig' id='prefect-client-client-client-post'><p class="prefect-class">prefect.client.client.Client.post</p>(path, server=None, headers=None, params=None, token=None, retry_on_api_error=True)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L187">[source]</a></span></div>
<p class="methods">Convenience function for calling the Prefect API with token auth and POST request<br><br>**Args**:     <ul class="args"><li class="args">`path (str)`: the path of the API url. For example, to POST         http://prefect-server/v1/auth/login, path would be 'auth/login'.     </li><li class="args">`server (str, optional)`: the server to send the POST request to;         defaults to `self.api_server`     </li><li class="args">`headers(dict)`: headers to pass with the request     </li><li class="args">`params (dict)`: POST parameters     </li><li class="args">`token (str)`: an auth token. If not supplied, the `client.access_token` is used.     </li><li class="args">`retry_on_api_error (bool)`: whether the operation should be retried if the API returns         an API_ERROR code</li></ul> **Returns**:     <ul class="args"><li class="args">`dict`: Dictionary representation of the request made</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-register'><p class="prefect-class">prefect.client.client.Client.register</p>(flow, project_name=None, build=True, set_schedule_active=True, version_group_id=None, compressed=True, no_url=False, idempotency_key=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L703">[source]</a></span></div>
<p class="methods">Push a new flow to Prefect Cloud<br><br>**Args**:     <ul class="args"><li class="args">`flow (Flow)`: a flow to register     </li><li class="args">`project_name (str, optional)`: the project that should contain this flow.     </li><li class="args">`build (bool, optional)`: if `True`, the flow's environment is built         prior to serialization; defaults to `True`     </li><li class="args">`set_schedule_active (bool, optional)`: if `False`, will set the schedule to         inactive in the database to prevent auto-scheduling runs (if the Flow has a         schedule).  Defaults to `True`. This can be changed later.     </li><li class="args">`version_group_id (str, optional)`: the UUID version group ID to use for versioning         this Flow in Cloud; if not provided, the version group ID associated with this         Flow's project and name will be used.     </li><li class="args">`compressed (bool, optional)`: if `True`, the serialized flow will be; defaults to         `True` compressed     </li><li class="args">`no_url (bool, optional)`: if `True`, the stdout from this function will not         contain the URL link to the newly-registered flow in the Cloud UI     </li><li class="args">`idempotency_key (optional, str)`: a key that, if matching the most recent         registration call for this flow group, will prevent the creation of         another flow version and return the existing flow id instead.</li></ul> **Returns**:     <ul class="args"><li class="args">`str`: the ID of the newly-registered flow</li></ul> **Raises**:     <ul class="args"><li class="args">`ClientError`: if the register failed</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-register-agent'><p class="prefect-class">prefect.client.client.Client.register_agent</p>(agent_type, name=None, labels=None, agent_config_id=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L1669">[source]</a></span></div>
<p class="methods">Register an agent with a backend API<br><br>**Args**:     <ul class="args"><li class="args">`agent_type (str)`: The type of agent being registered     </li><li class="args">`name`: (str, optional): The name of the agent being registered     </li><li class="args">`labels (List[str], optional)`: A list of any present labels on the agent         being registered     </li><li class="args">`agent_config_id (str, optional)`: The ID of an agent configuration to register with</li></ul> **Returns**:     <ul class="args"><li class="args">The agent ID as a string</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-save-api-token'><p class="prefect-class">prefect.client.client.Client.save_api_token</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L537">[source]</a></span></div>
<p class="methods">Saves the API token in local storage.</p>|
 | <div class='method-sig' id='prefect-client-client-client-set-flow-run-name'><p class="prefect-class">prefect.client.client.Client.set_flow_run_name</p>(flow_run_id, name)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L1217">[source]</a></span></div>
<p class="methods">Set the name of a flow run.<br><br>**Args**:     <ul class="args"><li class="args">`flow_run_id (str)`: the id of a flow run     </li><li class="args">`name (str)`: a name for this flow run</li></ul> **Returns**:     <ul class="args"><li class="args">`bool`: whether or not the flow run name was updated</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-set-flow-run-state'><p class="prefect-class">prefect.client.client.Client.set_flow_run_state</p>(flow_run_id, state, version=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L1264">[source]</a></span></div>
<p class="methods">Sets new state for a flow run in the database.<br><br>**Args**:     <ul class="args"><li class="args">`flow_run_id (str)`: the id of the flow run to set state for     </li><li class="args">`state (State)`: the new state for this flow run     </li><li class="args">`version (int, optional)`: the current version of the flow run state. This is optional         but it can be supplied to enforce version-locking.</li></ul> **Returns**:     <ul class="args"><li class="args">`State`: the state the current flow run should be considered in</li></ul> **Raises**:     <ul class="args"><li class="args">`ClientError`: if the GraphQL mutation is bad for any reason</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-set-secret'><p class="prefect-class">prefect.client.client.Client.set_secret</p>(name, value)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L1544">[source]</a></span></div>
<p class="methods">Set a secret with the given name and value.<br><br>**Args**:     <ul class="args"><li class="args">`name (str)`: the name of the secret; used for retrieving the secret         during task runs     </li><li class="args">`value (Any)`: the value of the secret</li></ul> **Raises**:     <ul class="args"><li class="args">`ClientError`: if the GraphQL mutation is bad for any reason     </li><li class="args">`ValueError`: if the secret-setting was unsuccessful</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-set-task-run-name'><p class="prefect-class">prefect.client.client.Client.set_task_run_name</p>(task_run_id, name)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L1415">[source]</a></span></div>
<p class="methods">Set the name of a task run<br><br>**Args**:     <ul class="args"><li class="args">`task_run_id (str)`: the id of a task run     </li><li class="args">`name (str)`: a name for this task run</li></ul> **Returns**:     <ul class="args"><li class="args">`bool`: whether or not the task run name was updated</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-set-task-run-state'><p class="prefect-class">prefect.client.client.Client.set_task_run_state</p>(task_run_id, state, version=None, cache_for=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L1484">[source]</a></span></div>
<p class="methods">Sets new state for a task run.<br><br>**Args**:     <ul class="args"><li class="args">`task_run_id (str)`: the id of the task run to set state for     </li><li class="args">`state (State)`: the new state for this task run     </li><li class="args">`version (int, optional)`: the current version of the task run state. This is optional         but it can be supplied to enforce version-locking.     </li><li class="args">`cache_for (timedelta, optional)`: how long to store the result of this task for,         using the serializer set in config; if not provided, no caching occurs</li></ul> **Raises**:     <ul class="args"><li class="args">`ClientError`: if the GraphQL mutation is bad for any reason</li></ul> **Returns**:     <ul class="args"><li class="args">`State`: the state the current task run should be considered in</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-update-flow-run-heartbeat'><p class="prefect-class">prefect.client.client.Client.update_flow_run_heartbeat</p>(flow_run_id)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L1179">[source]</a></span></div>
<p class="methods">Convenience method for heartbeating a flow run.<br><br>Does NOT raise an error if the update fails.<br><br>**Args**:     <ul class="args"><li class="args">`flow_run_id (str)`: the flow run ID to heartbeat</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-update-task-run-artifact'><p class="prefect-class">prefect.client.client.Client.update_task_run_artifact</p>(task_run_artifact_id, data)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L1771">[source]</a></span></div>
<p class="methods">Update an artifact that corresponds to a specific task run<br><br>**Args**:     <ul class="args"><li class="args">`task_run_artifact_id (str)`: the task run artifact id     </li><li class="args">`data (dict)`: the artifact data</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-update-task-run-heartbeat'><p class="prefect-class">prefect.client.client.Client.update_task_run_heartbeat</p>(task_run_id)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L1198">[source]</a></span></div>
<p class="methods">Convenience method for heartbeating a task run.<br><br>Does NOT raise an error if the update fails.<br><br>**Args**:     <ul class="args"><li class="args">`task_run_id (str)`: the task run ID to heartbeat</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-update-task-tag-limit'><p class="prefect-class">prefect.client.client.Client.update_task_tag_limit</p>(tag, limit)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L1594">[source]</a></span></div>
<p class="methods">Update the task tag concurrency limit for a given tag; requires tenant admin permissions.<br><br>**Args**:     <ul class="args"><li class="args">`tag (str)`: the tag to update     </li><li class="args">`limit (int)`: the concurrency limit to enforce on the tag; should be a value >= 0</li></ul> **Raises**:     <ul class="args"><li class="args">`ClientError`: if the GraphQL mutation is bad for any reason     </li><li class="args">`ValueError`: if the tag limit-setting was unsuccessful, or if a bad limit was provided</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-write-run-logs'><p class="prefect-class">prefect.client.client.Client.write_run_logs</p>(logs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L1646">[source]</a></span></div>
<p class="methods">Uploads a collection of logs to Cloud.<br><br>**Args**:     <ul class="args"><li class="args">`logs (List[Dict])`: a list of log entries to add</li></ul> **Raises**:     <ul class="args"><li class="args">`ValueError`: if uploading the logs fail</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on July 1, 2021 at 18:35 UTC</p>