# Modules

Sails is a large project, with many modular components.  Each module is located in its own repository, and in most cases is tested individually.

Below, you'll find an overview of the modules maintained by the core team and community members.


### Core modules

> For more information on the available releases of the Sails framework as a whole, check out the [contribution guide](https://github.com/balderdashy/sails/blob/master/CONTRIBUTING.md).

| Repo          |  Build Status (edge)                 |  Latest Stable Version   |
|---------------|---------------------------------------|--------------------------|
| <a href="http://github.com/balderdashy/sails" target="_blank" title="Github repo for Sails core"><img src="http://sailsjs.org/images/logos/sails-logo_ltBg_dkBlue.png" width=60 alt="Sails.js logo (small)"/></a>     | [![Build Status](https://travis-ci.org/balderdashy/sails.png?branch=master)](https://travis-ci.org/balderdashy/sails)  | [![NPM version](https://badge.fury.io/js/sails.png)](http://badge.fury.io/js/sails) |
| [**waterline**](http://github.com/balderdashy/waterline) | [![Build Status](https://travis-ci.org/balderdashy/waterline.png?branch=master)](https://travis-ci.org/balderdashy/waterline) | [![NPM version](https://badge.fury.io/js/waterline.png)](http://badge.fury.io/js/waterline) |
| [**anchor**](http://github.com/sailsjs/anchor) | [![Build Status](https://travis-ci.org/sailsjs/anchor.png?branch=master)](https://travis-ci.org/sailsjs/anchor) | [![NPM version](https://badge.fury.io/js/anchor.png)](http://badge.fury.io/js/anchor) |
| [**waterline-criteria**](http://github.com/balderdashy/waterline-criteria) | [![Build Status](https://travis-ci.org/balderdashy/waterline-criteria.png?branch=master)](https://travis-ci.org/balderdashy/waterline-criteria) | [![NPM version](https://badge.fury.io/js/waterline-criteria.png)](http://badge.fury.io/js/waterline-criteria) |
| [**waterline-errors**](http://github.com/vanetix/waterline-errors) | [![Build Status](https://travis-ci.org/vanetix/waterline-errors.svg?branch=master)](https://travis-ci.org/vanetix/waterline-errors) | [![NPM version](https://badge.fury.io/js/waterline-errors.png)](http://badge.fury.io/js/waterline-errors) |
| [**waterline-schema**](http://github.com/balderdashy/waterline-schema) | [![Build Status](https://travis-ci.org/balderdashy/waterline-schema.svg?branch=master)](https://travis-ci.org/balderdashy/waterline-schema) | [![NPM version](https://badge.fury.io/js/waterline-schema.png)](http://badge.fury.io/js/waterline-schema) |
| [**sails-generate**](http://github.com/balderdashy/sails-generate) | [![Build Status](https://travis-ci.org/balderdashy/sails-generate.png?branch=master)](https://travis-ci.org/balderdashy/sails-generate) | [![NPM version](https://badge.fury.io/js/sails-generate.png)](http://badge.fury.io/js/sails-generate) |
| [**sails-build-dictionary**](http://github.com/balderdashy/sails-build-dictionary) | N/A | [![NPM version](https://badge.fury.io/js/sails-build-dictionary.png)](http://badge.fury.io/js/sails-build-dictionary) |
| [**captains-log**](http://github.com/balderdashy/captains-log) | [![Build Status](https://travis-ci.org/balderdashy/captains-log.png?branch=master)](https://travis-ci.org/balderdashy/captains-log) | [![NPM version](https://badge.fury.io/js/captains-log.png)](http://badge.fury.io/js/captains-log) |
| [**sails-stringfile**](http://github.com/balderdashy/sails-stringfile) | N/A | [![NPM version](https://badge.fury.io/js/sails-stringfile.png)](http://badge.fury.io/js/sails-stringfile) |


### Utilities

| Repo       |  Latest Stable Version   |
|------------|--------------------------|
| [**sails-util**](http://github.com/balderdashy/sails-util) (_will be deprecated_) | [![NPM version](https://badge.fury.io/js/sails-util.png)](http://badge.fury.io/js/sails-util) |
| [**include-all**](http://github.com/balderdashy/include-all) | [![NPM version](https://badge.fury.io/js/include-all.png)](http://badge.fury.io/js/include-all) |
| [**reportback**](http://github.com/balderdashy/reportback) | [![NPM version](https://badge.fury.io/js/reportback.png)](http://badge.fury.io/js/reportback) |
| [**node-switchback**](http://github.com/balderdashy/switchback) | [![NPM version](https://badge.fury.io/js/node-switchback.png)](http://badge.fury.io/js/node-switchback) |
| [**merge-defaults**](http://github.com/balderdashy/merge-defaults) | [![NPM version](https://badge.fury.io/js/merge-defaults.png)](http://badge.fury.io/js/merge-defaults) |
| [**enpeem**](http://github.com/balderdashy/enpeem) | [![NPM version](https://badge.fury.io/js/enpeem.png)](http://badge.fury.io/js/enpeem) |
| [**merge-context**](http://github.com/balderdashy/merge-context) | [![NPM version](https://badge.fury.io/js/merge-context.png)](http://badge.fury.io/js/merge-context) |
| [**fixture-stdout**](http://github.com/balderdashy/fixture-stdout) | [![NPM version](https://badge.fury.io/js/fixture-stdout.png)](http://badge.fury.io/js/fixture-stdout) |




### Officially-supported generators

| Repo       |  Latest Stable Version   |
|------------|--------------------------|
| [sails-generate-generator](https://github.com/balderdashy/sails-generate-generator)  | [![NPM version](https://badge.fury.io/js/sails-generate-generator.png)](http://badge.fury.io/js/sails-generate-generator) |
| [sails-generate-new](https://github.com/balderdashy/sails-generate-new) | [![NPM version](https://badge.fury.io/js/sails-generate-new.png)](http://badge.fury.io/js/sails-generate-new) |
| [sails-generate-controller](https://github.com/balderdashy/sails-generate-controller) | [![NPM version](https://badge.fury.io/js/sails-generate-controller.png)](http://badge.fury.io/js/sails-generate-controller) |
| [sails-generate-frontend](https://github.com/balderdashy/sails-generate-frontend) | [![NPM version](https://badge.fury.io/js/sails-generate-frontend.png)](http://badge.fury.io/js/sails-generate-frontend) |
| [sails-generate-backend](https://github.com/balderdashy/sails-generate-backend) | |
| [sails-generate-views](https://github.com/balderdashy/sails-generate-views)   | |
| [sails-generate-adapter](https://github.com/balderdashy/sails-generate-adapter)   | |
| [sails-generate-model](https://github.com/balderdashy/sails-generate-model)   | |
| [sails-generate-api](https://github.com/balderdashy/sails-generate-api)   | |
| [sails-generate-test](https://github.com/balderdashy/sails-generate-test) |          |
| [sails-generate-hook](https://github.com/balderdashy/sails-generate-hook) |          |


### Officially-supported adapters

| Repo            |  Build Status (edge)                    |  Latest Stable Version   | Platform       |
| --------------- | --------------------------------------- | ------------------------ | -------------- |
| [Local Disk](https://github.com/balderdashy/sails-disk)    | [![Build Status](https://travis-ci.org/balderdashy/sails-disk.png?branch=master)](https://travis-ci.org/balderdashy/sails-disk)   | [![NPM version](https://badge.fury.io/js/sails-disk.png)](http://badge.fury.io/js/sails-disk)    | Local disk (`.tmp`) |
| [MySQL](https://github.com/balderdashy/sails-mysql)         | [![Build Status](https://travis-ci.org/balderdashy/sails-mysql.png?branch=master)](https://travis-ci.org/balderdashy/sails-mysql)   | [![NPM version](https://badge.fury.io/js/sails-mysql.png)](http://badge.fury.io/js/sails-mysql)    | MySQL |
| [PostgreSQL](https://github.com/balderdashy/sails-postgresql)    | [![Build Status](https://travis-ci.org/balderdashy/sails-postgresql.png?branch=master)](https://travis-ci.org/balderdashy/sails-postgresql)   | [![NPM version](https://badge.fury.io/js/sails-postgresql.png)](http://badge.fury.io/js/sails-postgresql)    | PostgreSQL |
| [Mongo](https://github.com/balderdashy/sails-mongo)        | [![Build Status](https://travis-ci.org/balderdashy/sails-mongo.png?branch=master)](https://travis-ci.org/balderdashy/sails-mongo)   | [![NPM version](https://badge.fury.io/js/sails-mongo.png)](http://badge.fury.io/js/sails-mongo)    | MongoDB |
| [Redis](https://github.com/balderdashy/sails-redis)         | [![Build Status](https://travis-ci.org/balderdashy/sails-redis.png?branch=master)](https://travis-ci.org/balderdashy/sails-redis)   | [![NPM version](https://badge.fury.io/js/sails-redis.png)](http://badge.fury.io/js/sails-redis)    | Redis |


### Officially-supported hooks

| Hook           | Repo       |  Build Status (edge)             | Purpose                  | Depends on...   |
|----------------|------------|----------------------------------|--------------------------|-----------------|
| `sockets`      | [sails-hook-sockets](https://github.com/balderdashy/sails-hook-sockets)  | [![Build Status](https://travis-ci.org/balderdashy/sails-hook-sockets.png?branch=master)](https://travis-ci.org/balderdashy/sails-hook-sockets)  | Implemments Socket.io support in Sails.  | `http`  |
| `http`         | [`/lib/hooks/http`](https://github.com/balderdashy/sails/tree/master/lib/hooks/http)      | [![Build Status](https://travis-ci.org/balderdashy/sails.png?branch=master)](https://travis-ci.org/balderdashy/sails) | Implements basic HTTP server functionality. |  _n/a_ |
| TODO: list other hooks currently contained in Sails core | _n/a_ | TODO | TODO | TODO |

> The code for the hooks listed above without specific repos is currently contained in sub-folders within Sails core.  See [`lib/hooks/`](https://github.com/balderdashy/sails/tree/master/lib/hooks)

### Socket Client SDKs

| Platform     | Repo       |  Build Status (edge)             |
|--------------|------------|----------------------------------|
| Browser      | [sails.io.js](https://github.com/balderdashy/sails.io.js)  | [![Build Status](https://travis-ci.org/balderdashy/sails.io.js.png?branch=master)](https://travis-ci.org/balderdashy/sails.io.js)  |
| Node.js      | [sails.io.js](https://github.com/balderdashy/sails.io.js)  | [![Build Status](https://travis-ci.org/balderdashy/sails.io.js.png?branch=master)](https://travis-ci.org/balderdashy/sails.io.js)  |



### Documentation

| Repo       |
|------------|
| [sails-docs](https://github.com/balderdashy/sails-docs)  |
| [www.sailsjs.org](https://github.com/balderdashy/www.sailsjs.org) |






## Community

#### Adapters

| Repo          |  Build Status (edge)  |  Latest Stable Version   | Platform |
|---------------|---------------------------------------|--------------------------|------------|
| [sails-orientdb](https://github.com/appscot/sails-orientdb) | [![Build Status](https://travis-ci.org/appscot/sails-orientdb.svg?branch=master)](https://travis-ci.org/appscot/sails-orientdb) | [![npm version](https://badge.fury.io/js/sails-orientdb.svg)](http://badge.fury.io/js/sails-orientdb) | OrientDB |
| [sails-rest](https://github.com/zohararad/sails-rest) |  |  | REST |
| [sails-oracle](https://github.com/mayconheerdt/sails-oracle) | | | Oracle |
| [sails-mssql](https://github.com/swelham/sails-mssql) | | | MSSQL (for sails@<=0.9.x) |
| [sails-sqlserver](https://github.com/cnect/sails-sqlserver) | | | SQL Server |
| [sails-neo4j](https://github.com/natgeo/sails-neo4j) | | | Neo4j |
| [sails-sqlite3](https://github.com/AndrewJo/sails-sqlite3) | | | SQLite3 |
| [sails-dynamodb](https://github.com/dohzoh/sails-dynamodb) | | | DynamoDB |
| [sails-elasticsearch](https://github.com/DarthHater/sails-elasticsearch) | | | Elasticsearch |
| [sails-couchdb](https://github.com/shmakes/sails-couchdb) | | | CouchDB |
| [sails-couchbase](https://github.com/CaseyJones-/sails-couchbase) | | | Couchbase |
| [sails-odata](https://github.com/TheSharpieOne/sails-odata) | | | OData |
| [sails-db2](https://github.com/IbuildingsItaly/sails-db2) | | | DB2 |
| [sails-rethinkdb](https://github.com/dsincl12/sails-rethinkdb) | | | RethinkDB |
| [sails-azuretables](https://github.com/azuqua/sails-azuretables) | | | Windows Azure Tables |
| [sails-riak](https://github.com/balderdashy/sails-riak) | | | Riak |
| [sails-nedb](https://github.com/balderdashy/sails-riak) | | | NeDB |
| [sails-parse](https://github.com/tskaggs/sails-parse) | | | Parse |
| [sails-tingo](https://github.com/andyhu/sails-tingo) | | | TingoDB |


#### Generators

> Note that this section will be migrating to https://github.com/balderdashy/sails-docs/concepts/extending-sails/Generators/generatorList.md for consistency.

| Repo                   | Build Status (edge)  |
|------------------------|----------------------|
| [sails-generate-auth](https://github.com/kasperisager/sails-generate-auth) |           |
| [sails-generate-bower](https://github.com/smies/sails-generate-bower) |          |
| [sails-generate-new-gulp](https://github.com/Karnith/sails-generate-new-gulp) |          |
| [sails-generate-frontend-gulp](https://github.com/Karnith/sails-generate-frontend-gulp) |          |
| [sails-generate-backend-gulp](https://github.com/Karnith/sails-generate-backend-gulp) |          |
| [sails-generate-gulpfile](https://github.com/Karnith/sails-generate-gulpfile) |          |
| [sails-generate-bower-gulp](https://github.com/Karnith/sails-generate-bower-gulp) |          |
| [sails-generate-angular-gulp](https://github.com/Karnith/sails-generate-angular-gulp) |          |
| [sails-generate-ember-blueprints](https://github.com/mphasize/sails-generate-ember-blueprints) |          |


#### Socket Client SDKs

| Repo       |  Build Status (edge)   |
|------------|----------------------------------|
| [angularSails](https://github.com/balderdashy/angularSails)  | [![Build Status](https://travis-ci.org/balderdashy/angularSails.png?branch=master)](https://travis-ci.org/balderdashy/angularSails) |
| [sails.io.objective-c](https://github.com/fishrod-interactive/sails-io.objective-c) | NEEDS_TRAVIS_SETUP |
| [backbone-to-sails](https://github.com/balderdashy/backbone-to-sails)  | [![Build Status](https://travis-ci.org/balderdashy/backbone-to-sails.png?branch=master)](https://travis-ci.org/balderdashy/backbone-to-sails) |


#### Misc. Projects

| Repo                   | Build Status (edge)  |
|------------------------|----------------------|
| [sails-migrations](https://github.com/BlueHotDog/sails-migrations) |           |




## FAQ

> If you have an unanswered question that isn't covered here, and that you feel would add value for the community, please feel free to send a PR adding it to this section.
