# Code of Conduct

> This Code of Conduct is adapted from the version used by the [Node.js core team](http://www.rust-lang.org/conduct.html).  Their version was originally borrowed from [Rust lang's excellent CoC](http://www.rust-lang.org/conduct.html).

- We are committed to providing a friendly, safe and welcoming environment for all, regardless of gender, sexual orientation, disability, ethnicity, religion, or similar personal characteristic.
- Please avoid using overtly sexual, racial, or political nicknames, or any other nicknames that might detract from a friendly, safe and welcoming environment for all.
- Please be kind and courteous. There's no need to be mean or rude.
- Avoid the use of personal pronouns in any code comments or documentation where such use could be perceived in a negative light. There is no need to address persons when explaining code (e.g. "When the developer").
- Respect that some individuals and cultures consider the casual use of profanity offensive and off-putting.
- Respect that people have differences of opinion and that every design or implementation choice carries a trade-off and numerous costs. There is seldom a right answer.
- Please keep unstructured critique to a minimum. If you have ideas you want to experiment with, make a fork and see how it works.
- We will exclude you from interaction if you insult, demean or harass
  anyone. That is not welcome behavior. We interpret the term
  "harassment" as including the definition in the [Citizen Code of
  Conduct](http://citizencodeofconduct.org/); if you have any lack of
  clarity about what might be included in that concept, please read
  their definition, or ask one of the project maintainers first.
  In particular, we don't tolerate behavior that
  excludes people in socially marginalized groups, or for whom English
  is not a native language.
- Private harassment is also unacceptable. No matter who you are, if
  you feel you have been or are being harassed or made uncomfortable
  by a community member, please contact one of the core maintainers immediately
  via private message on Twitter or by emailing [inquiries@treeline.io](inquiries@treeline.io).
  In either case, include a capture (screenshot, log, photo, email) of
  the harassment if possible. Whether you're a regular contributor or
  a newcomer, we care about making this community a safe, comfortable
  place for you and we've got your back.
- Likewise any spamming, trolling, flaming, baiting or other attention-stealing behavior is not welcome,
  and will result in your exclusion. This includes abusing support channels such as GitHub issues or social
  media to link to off-topic discussions or promote a personal fork or rival project.  Sharing links to relevant
  tutorials, plugins, or issue workarounds is encouraged.
- Do not make untrue or misleading claims about the project, the core team, or any of its users.  No matter who
you are, if you feel that our support channels are being used as an echochamber for defamatory remarks, please contact
  one of the core maintainers immediately via private message on Twitter or by emailing [inquiries@treeline.io](inquiries@treeline.io). Please include a screen capture if possible.
