% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object_usage_linter.R
\name{object_usage_linter}
\alias{object_usage_linter}
\title{Object usage linter}
\usage{
object_usage_linter(interpret_glue = TRUE, skip_with = TRUE)
}
\arguments{
\item{interpret_glue}{If \code{TRUE}, interpret \code{\link[glue:glue]{glue::glue()}} calls to avoid false positives caused by local variables
which are only used in a glue expression.}

\item{skip_with}{A logical. If \code{TRUE} (default), code in \code{with()} expressions
will be skipped. This argument will be passed to \code{skipWith} argument of
\code{codetools::checkUsage()}.}
}
\description{
Check that closures have the proper usage using \code{\link[codetools:checkUsage]{codetools::checkUsage()}}.
Note that this runs \code{\link[base:eval]{base::eval()}} on the code, so \strong{do not use with untrusted code}.
}
\examples{
# will produce lints
lint(
  text = "foo <- function() { x <- 1 }",
  linters = object_usage_linter()
)

# okay
lint(
  text = "foo <- function(x) { x <- 1 }",
  linters = object_usage_linter()
)

lint(
  text = "foo <- function() { x <- 1; return(x) }",
  linters = object_usage_linter()
)
}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Linters}{
The following linters are tagged with 'package_development':
\itemize{
\item{\code{\link{backport_linter}}}
\item{\code{\link{conjunct_test_linter}}}
\item{\code{\link{expect_comparison_linter}}}
\item{\code{\link{expect_identical_linter}}}
\item{\code{\link{expect_length_linter}}}
\item{\code{\link{expect_named_linter}}}
\item{\code{\link{expect_not_linter}}}
\item{\code{\link{expect_null_linter}}}
\item{\code{\link{expect_s3_class_linter}}}
\item{\code{\link{expect_s4_class_linter}}}
\item{\code{\link{expect_true_false_linter}}}
\item{\code{\link{expect_type_linter}}}
\item{\code{\link{package_hooks_linter}}}
\item{\code{\link{yoda_test_linter}}}
}
}
