export default {
  "ar-EG": {
    code: "ar",
    tag: "ar-EG",
    name: "مَصرى",
    load: () => import('./data/ar-EG.i18n.json'),
  },
  "ar": {
    code: "ar",
    tag: "ar",
    name: "العربية",
    load: () => import('./data/ar.i18n.json'),
  },
  "ary": {
    code: "ary",
    tag: "ary",
    name: "عربي مغربي",
    load: () => import('./data/ary.i18n.json'),
  },
  "bg": {
    code: "bg",
    tag: "bg",
    name: "Български",
    load: () => import('./data/bg.i18n.json'),
  },
  "br": {
    code: "br",
    tag: "br",
    name: "Brezhoneg",
    load: () => import('./data/xxx.i18n.json'),
  },
  "ca": {
    code: "ca",
    tag: "ca",
    name: "Català",
    load: () => import('./data/ca.i18n.json'),
  },
  "cs": {
    code: "cs",
    tag: "cs",
    name: "čeština",
    load: () => import('./data/cs.i18n.json'),
  },
  "cs-CZ": {
    code: "cs",
    tag: "cs-CZ",
    name: "čeština (Česká republika)",
    load: () => import('./data/cs-CZ.i18n.json'),
  },
  "cy-GB": {
    code: "cy",
    tag: "cy-GB",
    name: "Welsh (UK)",
    load: () => import('./data/cy-GB.i18n.json'),
  },
  "cy": {
    code: "cy",
    tag: "cy",
    name: "Welsh",
    load: () => import('./data/cy.i18n.json'),
  },
  "da": {
    code: "da",
    tag: "da",
    name: "Dansk",
    load: () => import('./data/da.i18n.json'),
  },
  "de-AT": {
    code: "de",
    tag: "de-AT",
    name: "Deutsch (Österreich)",
    load: () => import('./data/de-AT.i18n.json'),
  },
  "de-CH": {
    code: "de",
    tag: "de-CH",
    name: "Deutsch (Schweiz)",
    load: () => import('./data/de-CH.i18n.json'),
  },
  "de": {
    code: "de",
    tag: "de",
    name: "Deutsch",
    load: () => import('./data/de.i18n.json'),
  },
  "el-GR": {
    code: "el",
    tag: "el-GR",
    name: "Ελληνικά (Ελλάδα)",
    load: () => import('./data/el-GR.i18n.json'),
  },
  "el": {
    code: "el",
    tag: "el",
    name: "Ελληνικά",
    load: () => import('./data/el.i18n.json'),
  },
  "en-BR": {
    code: "en",
    tag: "en-BR",
    name: "English (Brazil)",
    load: () => import('./data/en-BR.i18n.json'),
  },
  "en-DE": {
    code: "en",
    tag: "en-DE",
    name: "English (Germany)",
    load: () => import('./data/en-DE.i18n.json'),
  },
  "en-GB": {
    code: "en",
    tag: "en-GB",
    name: "English (UK)",
    load: () => import('./data/en-GB.i18n.json'),
  },
  "en-IT": {
    code: "en",
    tag: "en-IT",
    name: "English (Italy)",
    load: () => import('./data/en-IT.i18n.json'),
  },
  "en-YS": {
    code: "en",
    tag: "en-YS",
    name: "English (Yeshivish)",
    load: () => import('./data/en-YS.i18n.json'),
  },
  "en": {
    code: "en",
    tag: "en",
    name: "English",
    load: () => import('./data/en.i18n.json'),
  },
  "eo": {
    code: "eo",
    tag: "eo",
    name: "Esperanto",
    load: () => import('./data/eo.i18n.json'),
  },
  "es-AR": {
    code: "es",
    tag: "es-AR",
    name: "español de Argentina",
    load: () => import('./data/es-AR.i18n.json'),
  },
  "es-CL": {
    code: "es",
    tag: "es-CL",
    name: "español de Chile",
    load: () => import('./data/es-CL.i18n.json'),
  },
  "es-LA": {
    code: "es",
    tag: "es-LA",
    name: "español de América Latina",
    load: () => import('./data/es-LA.i18n.json'),
  },
  "es-MX": {
    code: "es",
    tag: "es-MX",
    name: "español de México",
    load: () => import('./data/es-MX.i18n.json'),
  },
  "es-PE": {
    code: "es",
    tag: "es-PE",
    name: "español de Perú",
    load: () => import('./data/es-PE.i18n.json'),
  },
  "es-PY": {
    code: "es",
    tag: "es-PY",
    name: "español de Paraguayo",
    load: () => import('./data/es-PY.i18n.json'),
  },
  "es": {
    code: "es",
    tag: "es",
    name: "español",
    load: () => import('./data/es.i18n.json'),
  },
  "et-EE": {
    code: "et",
    tag: "et-EE",
    name: "eesti keel (Eesti)",
    load: () => import('./data/et-EE.i18n.json'),
  },
  "eu": {
    code: "eu",
    tag: "eu",
    name: "Euskara",
    load: () => import('./data/eu.i18n.json'),
  },
  "fa-IR": {
    code: "fa",
    tag: "fa-IR",
    name: "فارسی/پارسی (ایران\u200e)",
    load: () => import('./data/fa-IR.i18n.json'),
  },
  "fa": {
    code: "fa",
    tag: "fa",
    name: "فارسی",
    load: () => import('./data/fa.i18n.json'),
  },
  "fi": {
    code: "fi",
    tag: "fi",
    name: "Suomi",
    load: () => import('./data/fi.i18n.json'),
  },
  "fr-BE": {
    code: "fr",
    tag: "fr-BE",
    name: "Français (Belgique)",
    load: () => import('./data/fr-BE.i18n.json'),
  },
  "fr-CA": {
    code: "fr",
    tag: "fr-CA",
    name: "Français (Canada)",
    load: () => import('./data/fr-CA.i18n.json'),
  },
  "fr-CH": {
    code: "fr",
    tag: "fr-CH",
    name: "Français (Schweiz)",
    load: () => import('./data/fr-CH.i18n.json'),
  },
  "fr": {
    code: "fr",
    tag: "fr",
    name: "Français",
    load: () => import('./data/fr.i18n.json'),
  },
  "fy-NL": {
    code: "fy",
    tag: "fy-NL",
    name: "Westerlauwersk Frysk (Nederlân)",
    load: () => import('./data/fy-NL.i18n.json'),
  },
  "fy": {
    code: "fy",
    tag: "fy",
    name: "Westerlauwersk Frysk",
    load: () => import('./data/fy.i18n.json'),
  },
  "gl-ES": {
    code: "gl",
    tag: "gl-ES",
    name: "Galego (España)",
    load: () => import('./data/gl-ES.i18n.json'),
  },
  "gl": {
    code: "gl",
    tag: "gl",
    name: "Galego",
    load: () => import('./data/gl.i18n.json'),
  },
  "gu-IN": {
    code: "gu",
    tag: "gu-IN",
    name: "ગુજરાતી",
    load: () => import('./data/gu-IN.i18n.json'),
  },
  "he-IL": {
    code: "he",
    tag: "he-IL",
    name: "עברית (ישראל)",
    load: () => import('./data/he-IL.i18n.json'),
  },
  "he": {
    code: "he",
    tag: "he",
    name: "עברית",
    load: () => import('./data/he.i18n.json'),
  },
  "hi-IN": {
    code: "hi",
    tag: "hi-IN",
    name: "हिंदी (भारत)",
    load: () => import('./data/hi-IN.i18n.json'),
  },
  "hi": {
    code: "hi",
    tag: "hi",
    name: "हिन्दी",
    load: () => import('./data/hi.i18n.json'),
  },
  "hr": {
    code: "hr",
    tag: "hr",
    name: "Hrvatski",
    load: () => import('./data/hr.i18n.json'),
  },
  "hu": {
    code: "hu",
    tag: "hu",
    name: "Magyar",
    load: () => import('./data/hu.i18n.json'),
  },
  "hy": {
    code: "hy",
    tag: "hy",
    name: "Հայերեն",
    load: () => import('./data/hy.i18n.json'),
  },
  "id": {
    code: "id",
    tag: "id",
    name: "Bahasa Indonesia",
    load: () => import('./data/id.i18n.json'),
  },
  "ig": {
    code: "ig",
    tag: "ig",
    name: "Igbo",
    load: () => import('./data/ig.i18n.json'),
  },
  "it": {
    code: "it",
    tag: "it",
    name: "Italiano",
    load: () => import('./data/it.i18n.json'),
  },
  "ja": {
    code: "ja",
    tag: "ja",
    name: "日本語",
    load: () => import('./data/ja.i18n.json'),
  },
  "ja-JP": {
    code: "ja",
    tag: "ja-JP",
    name: "日本語",
    load: () => import('./data/ja.i18n.json'),
  },
  "ka": {
    code: "ka",
    tag: "ka",
    name: "ქართული",
    load: () => import('./data/ka.i18n.json'),
  },
  "km": {
    code: "km",
    tag: "km",
    name: "ភាសាខ្មែរ",
    load: () => import('./data/km.i18n.json'),
  },
  "ko-KR": {
    code: "ko",
    tag: "ko-KR",
    name: "한국어(한국)",
    load: () => import('./data/ko-KR.i18n.json'),
  },
  "ko": {
    code: "ko",
    tag: "ko",
    name: "한국어",
    load: () => import('./data/ko.i18n.json'),
  },
  "lt": {
    code: "lt",
    tag: "lt",
    name: "Lietuvių kalba",
    load: () => import('./data/lt.i18n.json'),
  },
  "lv": {
    code: "lv",
    tag: "lv",
    name: "latviešu valoda",
    load: () => import('./data/lv.i18n.json'),
  },
  "mk": {
    code: "mk",
    tag: "mk",
    name: "македонски јазик",
    load: () => import('./data/mk.i18n.json'),
  },
  "mn": {
    code: "mn",
    tag: "mn",
    name: "Монгол",
    load: () => import('./data/mn.i18n.json'),
  },
  "ms-MY": {
    code: "ms",
    tag: "ms-MY",
    name: "بهاس ملايو",
    load: () => import('./data/ms-MY.i18n.json'),
  },
  "nb": {
    code: "nb",
    tag: "nb",
    name: "Norsk bokmål",
    load: () => import('./data/nb.i18n.json'),
  },
  "nl-NL": {
    code: "nl",
    tag: "nl-NL",
    name: "Nederlands (Nederland)",
    load: () => import('./data/nl-NL.i18n.json'),
  },
  "nl": {
    code: "nl",
    tag: "nl",
    name: "Nederlands",
    load: () => import('./data/nl.i18n.json'),
  },
  "oc": {
    code: "oc",
    tag: "oc",
    name: "Occitan",
    load: () => import('./data/oc.i18n.json'),
  },
  "pa": {
    code: "pa",
    tag: "pa",
    name: "ਪੰਜਾਬੀ",
    load: () => import('./data/pa.i18n.json'),
  },
  "pl-PL": {
    code: "pl",
    tag: "pl-PL",
    name: "Polski (Polska)",
    load: () => import('./data/pl-PL.i18n.json'),
  },
  "pl": {
    code: "pl",
    tag: "pl",
    name: "Polski",
    load: () => import('./data/pl.i18n.json'),
  },
  "pt-BR": {
    code: "pt",
    tag: "pt-BR",
    name: "Português do Brasil",
    load: () => import('./data/pt-BR.i18n.json'),
  },
  "pt": {
    code: "pt",
    tag: "pt",
    name: "Português",
    load: () => import('./data/pt.i18n.json'),
  },
  "ro": {
    code: "ro",
    tag: "ro",
    name: "Română",
    load: () => import('./data/ro.i18n.json'),
  },
  "ru-UA": {
    code: "ru",
    tag: "ru-UA",
    name: "Русский (Украина)",
    load: () => import('./data/ru-UA.i18n.json'),
  },
  "ru": {
    code: "ru",
    tag: "ru",
    name: "Русский",
    load: () => import('./data/ru.i18n.json'),
  },
  "sk": {
    code: "sk",
    tag: "sk",
    name: "Slovenčina",
    load: () => import('./data/sk.i18n.json'),
  },
  "sl": {
    code: "sl",
    tag: "sl",
    name: "slovenščina",
    load: () => import('./data/sl.i18n.json'),
  },
  "sr": {
    code: "sr",
    tag: "sr",
    name: "Српски језик",
    load: () => import('./data/sr.i18n.json'),
  },
  "st": {
    code: "st",
    tag: "st",
    name: "Sãotomense",
    load: () => import('./data/st.i18n.json'),
  },
  "sv": {
    code: "sv",
    tag: "sv",
    name: "Svenska",
    load: () => import('./data/sv.i18n.json'),
  },
  "sw": {
    code: "sw",
    tag: "sw",
    name: "Kiswahili",
    load: () => import('./data/sw.i18n.json'),
  },
  "ta": {
    code: "ta",
    tag: "ta",
    name: "தமிழ்",
    load: () => import('./data/ta.i18n.json'),
  },
  "th": {
    code: "th",
    tag: "th",
    name: "ไทย",
    load: () => import('./data/th.i18n.json'),
  },
  "tr": {
    code: "tr",
    tag: "tr",
    name: "Türkçe",
    load: () => import('./data/tr.i18n.json'),
  },
  "ua-UA": {
    code: "ua",
    tag: "ua-UA",
    name: "українська (Україна)",
    load: () => import('./data/ua-UA.i18n.json'),
  },
  "ua": {
    code: "ua",
    tag: "ua",
    name: "українська (Україна)",
    load: () => import('./data/ua.i18n.json'),
  },
  "uz-AR": {
    code: "uz",
    tag: "uz-AR",
    name: "o'zbek (arab)",
    load: () => import('./data/uz-AR.i18n.json'),
  },
  "uz-LA": {
    code: "uz",
    tag: "uz-LA",
    name: "o'zbek (lotin)",
    load: () => import('./data/uz-LA.i18n.json'),
  },
  "uz-UZ": {
    code: "uz",
    tag: "uz-UZ",
    name: "o'zbek (O'zbekiston)",
    load: () => import('./data/uz-UZ.i18n.json'),
  },
  "ve-CC": {
    code: "ve",
    tag: "ve-CC",
    name: "vèneto",
    load: () => import('./data/ve-CC.i18n.json'),
  },
  "ve-PP": {
    code: "ve",
    tag: "ve-PP",
    name: "vepsän kelʹ",
    load: () => import('./data/ve-PP.i18n.json'),
  },
  "ve": {
    code: "ve",
    tag: "ve",
    name: "Tshivenḓa",
    load: () => import('./data/ve.i18n.json'),
  },
  "vi-VN": {
    code: "vi",
    tag: "vi-VN",
    name: "Tiếng Việt (Việt Nam)",
    load: () => import('./data/vi-VN.i18n.json'),
  },
  "vi": {
    code: "vi",
    tag: "vi",
    name: "Tiếng Việt",
    load: () => import('./data/vi.i18n.json'),
  },
  "vl-SS": {
    code: "vl",
    tag: "vl-SS",
    name: "Vlaams",
    load: () => import('./data/vl-SS.i18n.json'),
  },
  "vo": {
    code: "vo",
    tag: "vo",
    name: "Volapük",
    load: () => import('./data/vo.i18n.json'),
  },
  "wa-RR": {
    code: "wa",
    tag: "wa-RR",
    name: "Wáray-Wáray",
    load: () => import('./data/wa-RR.i18n.json'),
  },
  "wa": {
    code: "wa",
    tag: "wa",
    name: "walon",
    load: () => import('./data/wa.i18n.json'),
  },
  "wo": {
    code: "wo",
    tag: "wo",
    name: "ولوفل",
    load: () => import('./data/wo.i18n.json'),
  },
  "xh": {
    code: "xh",
    tag: "xh",
    name: "isiXhosa",
    load: () => import('./data/xh.i18n.json'),
  },
  "yi": {
    code: "yi",
    tag: "yi",
    name: "ייִדיש, יידיש",
    load: () => import('./data/yi.i18n.json'),
  },
  "yo": {
    code: "yo",
    tag: "yo",
    name: "Èdè Yorùbá",
    load: () => import('./data/yo.i18n.json'),
  },
  "zgh": {
    code: "zgh",
    tag: "zgh",
    name: "ⵜⴰⵎⴰⵣⵉⵖⵜ ⵜⴰⵏⴰⵡⴰⵢⵜ",
    load: () => import('./data/zgh.i18n.json'),
  },
  "zh-CN": {
    code: "zh",
    tag: "zh-CN",
    name: "简体中文",
    load: () => import('./data/zh-CN.i18n.json'),
  },
  "zh-HK": {
    code: "zh",
    tag: "zh-HK",
    name: "繁体中文（香港）",
    load: () => import('./data/zh-HK.i18n.json'),
  },
  "zh-TW": {
    code: "zh",
    tag: "zh-TW",
    name: "繁體中文（台灣）",
    load: () => import('./data/zh-TW.i18n.json'),
  },
  "zu-ZA": {
    code: "zu",
    tag: "zu-ZA",
    name: "isiZulu (Ningizimu Afrika)",
    load: () => import('./data/zu-ZA.i18n.json'),
  },
  "zu": {
    code: "zu",
    tag: "zu",
    name: "isiZulu",
    load: () => import('./data/zu.i18n.json'),
  }
};
