## http-publish Public API ##

Adds HTTP.publish and HTTP.unpublish RESTful

_API documentation automatically generated by [docmeteor](https://github.com/raix/docmeteor)._

-

### <a name="_publishHTTP"></a>_publishHTTP {any}&nbsp;&nbsp;<sub><i>Server</i></sub> ###

```
GET /note
GET /note/:id
POST /note
PUT /note/:id
DELETE /note/:id
```

> ```_publishHTTP = { ...``` [http.publish.server.api.js:20](http.publish.server.api.js#L20)



-
Could be cool if we could serve some api doc or even an api script
user could do <script href="/note/api?token=1&user=2"></script> and be served
a client-side javascript api?
Eg.
HTTP.api.note.create();
HTTP.api.login(username, password);
HTTP.api.logout
-

### <a name="HTTP.publishFormats"></a>*http*.publishFormats(newHandlers)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __publishFormats__ is defined in `HTTP`*

__Arguments__

* __newHandlers__ *{Object}*  

__Returns__  *{undefined}*


Add publish formats. Example:
```js
HTTP.publishFormats({
json: function(inputObject) {
// Set the method scope content type to json
this.setContentType('application/json');
// Return EJSON string
return EJSON.stringify(inputObject);
}
});
```

> ```HTTP.publishFormats = function httpPublishFormats(newHandlers) { ...``` [http.publish.server.api.js:215](http.publish.server.api.js#L215)


-

### <a name="HTTP.publish"></a>*http*.publish(options, [name], [collection], [publishFunc])&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __publish__ is defined in `HTTP`*

__Arguments__

* __options__ *{Object}*  
    * __defaultFormat__ *{String}*  (Optional, Default = 'json')

     Format to use for responses when `format` is not found in the query string.

    * __collectionGet__ *{String}*  (Optional, Default = true)

     Add GET restpoint for collection? Requires a publish function.

    * __collectionPost__ *{String}*  (Optional, Default = true)

     Add POST restpoint for adding documents to the collection?

    * __documentGet__ *{String}*  (Optional, Default = true)

     Add GET restpoint for documents in collection? Requires a publish function.

    * __documentPut__ *{String}*  (Optional, Default = true)

     Add PUT restpoint for updating a document in the collection?

    * __documentDelete__ *{String}*  (Optional, Default = true)

     Add DELETE restpoint for deleting a document in the collection?

* __name__ *{String}*  (Optional)

 Restpoint name (url prefix). Optional if `collection` is passed. Will mount on `/api/collectionName` by default.

* __collection__ *{[Meteor.Collection](#Meteor.Collection)}*  (Optional)

 Meteor.Collection instance. Required for all restpoints except collectionGet

* __publishFunc__ *{Function}*  (Optional)

 A publish function. Required to mount GET restpoints.


__Returns__  *{undefined}*


Publishes one or more restpoints, mounted on "name" ("/api/collectionName/"
by default). The GET restpoints are subscribed to the document set (cursor)
returned by the publish function you supply. The other restpoints forward
requests to Meteor's built-in DDP methods (insert, update, remove), meaning
that full allow/deny security is automatic.

__Usage:__

Publish only:

HTTP.publish({name: 'mypublish'}, publishFunc);

Publish and mount crud rest point for collection /api/myCollection:

HTTP.publish({collection: myCollection}, publishFunc);

Mount CUD rest point for collection and documents without GET:

HTTP.publish({collection: myCollection});


> ```HTTP.publish = function httpPublish(options, publishFunc) { ...``` [http.publish.server.api.js:256](http.publish.server.api.js#L256)


-

### <a name="HTTP.unpublish"></a>*http*.unpublish([name])&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __unpublish__ is defined in `HTTP`*

__Arguments__

* __name__ *{String|[Meteor.Collection](#Meteor.Collection)}*  (Optional)

 The method name or collection


__Returns__  *{undefined}*


Unpublishes all HTTP methods that were published with the given name or 
for the given collection. Call with no arguments to unpublish all.

> ```HTTP.unpublish = _publishHTTP.unpublish;``` [http.publish.server.api.js:453](http.publish.server.api.js#L453)


