## Public and Private API ##

_API documentation automatically generated by [docmeteor](https://github.com/raix/docmeteor)._

***

__File: ["client/Blob.js"](client/Blob.js) Where: {client}__

***

### <a name="if "></a>if  {any}&nbsp;&nbsp;<sub><i>Client</i></sub> ###

```
Blob.js
A Blob implementation.
2013-06-20
By Eli Grey, http:
By Devin Samarin, https:
License: X11/MIT
See LICENSE.md
```


> ```if ((typeof Blob !== ``` [client/Blob.js:17](client/Blob.js#L17)


-

### <a name="if "></a>if  {any}&nbsp;&nbsp;<sub><i>Client</i></sub> ###

```
global unescape jslint bitwise: true, regexp: true, confusion: true, es5: true, vars: true, white: true,
plusplus: true 
```

> ```if ((typeof Blob !== ``` [client/Blob.js:17](client/Blob.js#L17)


***

__File: ["client/data-man-api.js"](client/data-man-api.js) Where: {client}__

***

### <a name="DataMan"></a>new DataMan(data, [type])&nbsp;&nbsp;<sub><i>Client</i></sub> ###


__Arguments__

* __data__ *{[File](#File)|[Blob](#Blob)|ArrayBuffer|Uint8Array|String}*  

 The data that you want to manipulate.

* __type__ *{String}*  (Optional)

 The data content (MIME) type, if known. Required if the first argument is an ArrayBuffer, Uint8Array, or URL



> ```DataMan = function DataMan(data, type) { ...``` [client/data-man-api.js:8](client/data-man-api.js#L8)


-

### <a name="DataMan.prototype.getBlob"></a>*dataman*.getBlob(callback)&nbsp;&nbsp;<sub><i>Client</i></sub> ###

*This method __getBlob__ is defined in `prototype` of `DataMan`*

__Arguments__

* __callback__ *{Function}*  

 callback(error, blob)


__Returns__  *{undefined}*


Passes a Blob representing this data to a callback.

> ```DataMan.prototype.getBlob = function dataManGetBlob(callback) { ...``` [client/data-man-api.js:52](client/data-man-api.js#L52)


-

### <a name="DataMan.prototype.getBinary"></a>*dataman*.getBinary([start], [end], callback)&nbsp;&nbsp;<sub><i>Client</i></sub> ###

*This method __getBinary__ is defined in `prototype` of `DataMan`*

__Arguments__

* __start__ *{Number}*  (Optional)

 First byte position to read.

* __end__ *{Number}*  (Optional)

 Last byte position to read.

* __callback__ *{Function}*  

 callback(error, binaryData)


__Returns__  *{undefined}*


Passes a Uint8Array representing this data to a callback.

> ```DataMan.prototype.getBinary = function dataManGetBinary(start, end, callback) { ...``` [client/data-man-api.js:84](client/data-man-api.js#L84)


-

### <a name="DataMan.prototype.saveAs"></a>*dataman*.saveAs([filename])&nbsp;&nbsp;<sub><i>Client</i></sub> ###

*This method __saveAs__ is defined in `prototype` of `DataMan`*

__Arguments__

* __filename__ *{String}*  (Optional)

__Returns__  *{undefined}*

Tells the browser to save the data like a normal downloaded file,
using the provided filename.


> ```DataMan.prototype.saveAs = function dataManSaveAs(filename) { ...``` [client/data-man-api.js:146](client/data-man-api.js#L146)


-

### <a name="DataMan.prototype.getDataUri"></a>*dataman*.getDataUri(callback)&nbsp;&nbsp;<sub><i>Client</i></sub> ###

*This method __getDataUri__ is defined in `prototype` of `DataMan`*

__Arguments__

* __callback__ *{function}*  

 callback(err, dataUri)



> ```DataMan.prototype.getDataUri = function dataManGetDataUri(callback) { ...``` [client/data-man-api.js:166](client/data-man-api.js#L166)


-

### <a name="DataMan.prototype.type"></a>*dataman*.type()&nbsp;&nbsp;<sub><i>Client</i></sub> ###

*This method __type__ is defined in `prototype` of `DataMan`*


Returns the type of the data.

> ```DataMan.prototype.type = function dataManType() { ...``` [client/data-man-api.js:227](client/data-man-api.js#L227)


-

### <a name="dataURItoBlob"></a>dataURItoBlob(dataURI, dataTYPE)&nbsp;&nbsp;<sub><i>undefined</i></sub> ###

*This method is private*

__Arguments__

* __dataURI__ *{String}*  

 The data URI

* __dataTYPE__ *{String}*  

 The content type


__Returns__  *{Blob}*
A new Blob instance


Converts a data URI to a Blob.

> ```function dataURItoBlob(dataURI, dataTYPE) { ...``` [client/data-man-api.js:240](client/data-man-api.js#L240)


-

### <a name="defaultCallback"></a>defaultCallback([err])&nbsp;&nbsp;<sub><i>undefined</i></sub> ###

*This method is private*

__Arguments__

* __err__ *{[Error](#Error)}*  (Optional)

__Returns__  *{undefined}*


Can be used as a default callback for client methods that need a callback.
Simply throws the provided error if there is one.

> ```function defaultCallback(err) { ...``` [client/data-man-api.js:255](client/data-man-api.js#L255)


***

__File: ["server/data-man-api.js"](server/data-man-api.js) Where: {server}__

***

### <a name="DataMan"></a>new DataMan(data, [type])&nbsp;&nbsp;<sub><i>Server</i></sub> ###


__Arguments__

* __data__ *{Buffer|ArrayBuffer|Uint8Array|String}*  

 The data that you want to manipulate.

* __type__ *{String}*  (Optional)

 The data content (MIME) type, if known. Required if the first argument is a Buffer, ArrayBuffer, Uint8Array, or URL



> ```DataMan = function DataMan(data, type) { ...``` [server/data-man-api.js:10](server/data-man-api.js#L10)


-

### <a name="DataMan.prototype.getBuffer"></a>*dataman*.getBuffer([callback])&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __getBuffer__ is defined in `prototype` of `DataMan`*

__Arguments__

* __callback__ *{function}*  (Optional)

 callback(err, buffer)


__Returns__  *{Buffer|undefined}*


Returns a Buffer representing this data, or passes the Buffer to a callback.

> ```DataMan.prototype.getBuffer = function dataManGetBuffer(callback) { ...``` [server/data-man-api.js:54](server/data-man-api.js#L54)


-

### <a name="DataMan.prototype.saveToFile"></a>*dataman*.saveToFile()&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __saveToFile__ is defined in `prototype` of `DataMan`*

__Returns__  *{undefined}*


Saves this data to a filepath on the local filesystem.

> ```DataMan.prototype.saveToFile = function dataManSaveToFile(filePath) { ...``` [server/data-man-api.js:66](server/data-man-api.js#L66)


-

### <a name="DataMan.prototype.getDataUri"></a>*dataman*.getDataUri([callback])&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __getDataUri__ is defined in `prototype` of `DataMan`*

__Arguments__

* __callback__ *{function}*  (Optional)

 callback(err, dataUri)



If no callback, returns the data URI.

> ```DataMan.prototype.getDataUri = function dataManGetDataUri(callback) { ...``` [server/data-man-api.js:84](server/data-man-api.js#L84)


-

### <a name="DataMan.prototype.createReadStream"></a>*dataman*.createReadStream()&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __createReadStream__ is defined in `prototype` of `DataMan`*


Returns a read stream for the data.

> ```DataMan.prototype.createReadStream = function dataManCreateReadStream() { ...``` [server/data-man-api.js:95](server/data-man-api.js#L95)


-

### <a name="DataMan.prototype.size"></a>*dataman*.size([callback])&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __size__ is defined in `prototype` of `DataMan`*

__Arguments__

* __callback__ *{function}*  (Optional)

 callback(err, size)



If no callback, returns the size in bytes of the data.

> ```DataMan.prototype.size = function dataManSize(callback) { ...``` [server/data-man-api.js:106](server/data-man-api.js#L106)


-

### <a name="DataMan.prototype.type"></a>*dataman*.type()&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __type__ is defined in `prototype` of `DataMan`*


Returns the type of the data.

> ```DataMan.prototype.type = function dataManType() { ...``` [server/data-man-api.js:117](server/data-man-api.js#L117)


***

__File: ["server/data-man-buffer.js"](server/data-man-buffer.js) Where: {server}__

***

### <a name="DataMan.Buffer"></a>new *dataman*.Buffer(buffer, type)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __Buffer__ is defined in `DataMan`*

__Arguments__

* __buffer__ *{Buffer}*  
* __type__ *{String}*  

 The data content (MIME) type.



> ```DataMan.Buffer = function DataManBuffer(buffer, type) { ...``` [server/data-man-buffer.js:10](server/data-man-buffer.js#L10)


-

### <a name="DataMan.Buffer.prototype.getBuffer"></a>*datamanBuffer*.getBuffer(callback)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method is private*
*This method __getBuffer__ is defined in `prototype` of `DataMan.Buffer`*

__Arguments__

* __callback__ *{function}*  

 callback(err, buffer)


__Returns__  *{Buffer|undefined}*


Passes a Buffer representing the data to a callback.

> ```DataMan.Buffer.prototype.getBuffer = function dataManBufferGetBuffer(callback) { ...``` [server/data-man-buffer.js:24](server/data-man-buffer.js#L24)


-

### <a name="DataMan.Buffer.prototype.getDataUri"></a>*datamanBuffer*.getDataUri(callback)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method is private*
*This method __getDataUri__ is defined in `prototype` of `DataMan.Buffer`*

__Arguments__

* __callback__ *{function}*  

 callback(err, dataUri)



Passes a data URI representing the data in the buffer to a callback.

> ```DataMan.Buffer.prototype.getDataUri = function dataManBufferGetDataUri(callback) { ...``` [server/data-man-buffer.js:35](server/data-man-buffer.js#L35)


-

### <a name="DataMan.Buffer.prototype.createReadStream"></a>*datamanBuffer*.createReadStream()&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method is private*
*This method __createReadStream__ is defined in `prototype` of `DataMan.Buffer`*


Returns a read stream for the data.

> ```DataMan.Buffer.prototype.createReadStream = function dataManBufferCreateReadStream() { ...``` [server/data-man-buffer.js:51](server/data-man-buffer.js#L51)


-

### <a name="DataMan.Buffer.prototype.size"></a>*datamanBuffer*.size(callback)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method is private*
*This method __size__ is defined in `prototype` of `DataMan.Buffer`*

__Arguments__

* __callback__ *{function}*  

 callback(err, size)



Passes the size in bytes of the data in the buffer to a callback.

> ```DataMan.Buffer.prototype.size = function dataManBufferSize(callback) { ...``` [server/data-man-buffer.js:62](server/data-man-buffer.js#L62)


-

### <a name="DataMan.Buffer.prototype.type"></a>*datamanBuffer*.type()&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method is private*
*This method __type__ is defined in `prototype` of `DataMan.Buffer`*


Returns the type of the data.

> ```DataMan.Buffer.prototype.type = function dataManBufferType() { ...``` [server/data-man-buffer.js:80](server/data-man-buffer.js#L80)


***

__File: ["server/data-man-datauri.js"](server/data-man-datauri.js) Where: {server}__

***

### <a name="DataMan.DataURI"></a>new *dataman*.DataURI(dataUri)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __DataURI__ is defined in `DataMan`*

__Arguments__

* __dataUri__ *{String}*  


> ```DataMan.DataURI = function DataManDataURI(dataUri) { ...``` [server/data-man-datauri.js:7](server/data-man-datauri.js#L7)


***

__File: ["server/data-man-filepath.js"](server/data-man-filepath.js) Where: {server}__

***

### <a name="DataMan.FilePath"></a>new *dataman*.FilePath(filepath, [type])&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __FilePath__ is defined in `DataMan`*

__Arguments__

* __filepath__ *{String}*  
* __type__ *{String}*  (Optional)

 The data content (MIME) type. Will lookup from file if not passed.



> ```DataMan.FilePath = function DataManFilePath(filepath, type) { ...``` [server/data-man-filepath.js:11](server/data-man-filepath.js#L11)


-

### <a name="DataMan.FilePath.prototype.getBuffer"></a>*datamanFilepath*.getBuffer(callback)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method is private*
*This method __getBuffer__ is defined in `prototype` of `DataMan.FilePath`*

__Arguments__

* __callback__ *{function}*  

 callback(err, buffer)


__Returns__  *{Buffer|undefined}*


Passes a Buffer representing the data to a callback.

> ```DataMan.FilePath.prototype.getBuffer = function dataManFilePathGetBuffer(callback) { ...``` [server/data-man-filepath.js:25](server/data-man-filepath.js#L25)


-

### <a name="DataMan.FilePath.prototype.getDataUri"></a>*datamanFilepath*.getDataUri(callback)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method is private*
*This method __getDataUri__ is defined in `prototype` of `DataMan.FilePath`*

__Arguments__

* __callback__ *{function}*  

 callback(err, dataUri)



Passes a data URI representing the data to a callback.

> ```DataMan.FilePath.prototype.getDataUri = function dataManFilePathGetDataUri(callback) { ...``` [server/data-man-filepath.js:43](server/data-man-filepath.js#L43)


-

### <a name="DataMan.FilePath.prototype.createReadStream"></a>*datamanFilepath*.createReadStream()&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method is private*
*This method __createReadStream__ is defined in `prototype` of `DataMan.FilePath`*


Returns a read stream for the data.

> ```DataMan.FilePath.prototype.createReadStream = function dataManFilePathCreateReadStream() { ...``` [server/data-man-filepath.js:67](server/data-man-filepath.js#L67)


-

### <a name="DataMan.FilePath.prototype.size"></a>*datamanFilepath*.size(callback)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method is private*
*This method __size__ is defined in `prototype` of `DataMan.FilePath`*

__Arguments__

* __callback__ *{function}*  

 callback(err, size)



Passes the size in bytes of the data to a callback.

> ```DataMan.FilePath.prototype.size = function dataManFilePathSize(callback) { ...``` [server/data-man-filepath.js:79](server/data-man-filepath.js#L79)


-

### <a name="DataMan.FilePath.prototype.type"></a>*datamanFilepath*.type()&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method is private*
*This method __type__ is defined in `prototype` of `DataMan.FilePath`*


Returns the type of the data.

> ```DataMan.FilePath.prototype.type = function dataManFilePathType() { ...``` [server/data-man-filepath.js:104](server/data-man-filepath.js#L104)


***

__File: ["server/data-man-url.js"](server/data-man-url.js) Where: {server}__

***

### <a name="DataMan.URL"></a>new *dataman*.URL(url, type)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __URL__ is defined in `DataMan`*

__Arguments__

* __url__ *{String}*  
* __type__ *{String}*  

 The data content (MIME) type.



> ```DataMan.URL = function DataManURL(url, type) { ...``` [server/data-man-url.js:10](server/data-man-url.js#L10)


-

### <a name="DataMan.URL.prototype.getBuffer"></a>*datamanUrl*.getBuffer(callback)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method is private*
*This method __getBuffer__ is defined in `prototype` of `DataMan.URL`*

__Arguments__

* __callback__ *{function}*  

 callback(err, buffer)


__Returns__  *{Buffer|undefined}*


Passes a Buffer representing the data at the URL to a callback.

> ```DataMan.URL.prototype.getBuffer = function dataManUrlGetBuffer(callback) { ...``` [server/data-man-url.js:24](server/data-man-url.js#L24)


-

### <a name="DataMan.URL.prototype.getDataUri"></a>*datamanUrl*.getDataUri(callback)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method is private*
*This method __getDataUri__ is defined in `prototype` of `DataMan.URL`*

__Arguments__

* __callback__ *{function}*  

 callback(err, dataUri)



Passes a data URI representing the data at the URL to a callback.

> ```DataMan.URL.prototype.getDataUri = function dataManUrlGetDataUri(callback) { ...``` [server/data-man-url.js:57](server/data-man-url.js#L57)


-

### <a name="DataMan.URL.prototype.createReadStream"></a>*datamanUrl*.createReadStream()&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method is private*
*This method __createReadStream__ is defined in `prototype` of `DataMan.URL`*


Returns a read stream for the data.

> ```DataMan.URL.prototype.createReadStream = function dataManUrlCreateReadStream() { ...``` [server/data-man-url.js:85](server/data-man-url.js#L85)


-

### <a name="DataMan.URL.prototype.size"></a>*datamanUrl*.size(callback)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method is private*
*This method __size__ is defined in `prototype` of `DataMan.URL`*

__Arguments__

* __callback__ *{function}*  

 callback(err, size)



Returns the size in bytes of the data at the URL.

> ```DataMan.URL.prototype.size = function dataManUrlSize(callback) { ...``` [server/data-man-url.js:97](server/data-man-url.js#L97)


-

### <a name="DataMan.URL.prototype.type"></a>*datamanUrl*.type()&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method is private*
*This method __type__ is defined in `prototype` of `DataMan.URL`*


Returns the type of the data.

> ```DataMan.URL.prototype.type = function dataManUrlType() { ...``` [server/data-man-url.js:121](server/data-man-url.js#L121)


