/*
 * Decompiled with CFR 0.152.
 */
package br.com.quintoandar.urlencoder;

import br.com.quintoandar.urlencoder.YourlsApiService;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import lombok.NonNull;
import org.apache.commons.lang3.RandomStringUtils;

public class UrlEncoder {
    private static final int SIZE_SHORT_HASH = 6;
    private YourlsApiService service;
    private int keywordLength;
    private String signature;
    private boolean withEnvironment;
    private String environment;

    public UrlEncoder(@NonNull String uri, @NonNull int keywordLength, @NonNull String signature) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (signature == null) {
            throw new NullPointerException("signature");
        }
        this.service = new YourlsApiService(uri);
        this.keywordLength = keywordLength;
        this.signature = signature;
        this.withEnvironment = false;
    }

    public UrlEncoder(String uri, int keywordLength, String signature, @NonNull String environment) {
        this(uri, keywordLength, signature);
        if (environment == null) {
            throw new NullPointerException("environment");
        }
        this.withEnvironment = true;
        this.environment = environment;
    }

    public String encodeURL(String url) {
        String generatedKeyword = this.generateRandomAlphanumeric();
        String finalKeyword = this.isWithEnvironment() ? this.generateKeywordWithEnvironment(generatedKeyword) : generatedKeyword;
        ShortUrlResponse shortUrlResponse = this.shortUrlWithKeyword(url, finalKeyword);
        if (shortUrlResponse.isFail() && shortUrlResponse.getFailReason().equals((Object)FailReason.KEYWORD_ALREADY_EXIST)) {
            return this.encodeURL(url);
        }
        if (!shortUrlResponse.isFail()) {
            return shortUrlResponse.getShortUrl();
        }
        return null;
    }

    public String encodeUrlWithKeyword(String url, String keyword) {
        String finalKeyword = this.isWithEnvironment() ? this.generateKeywordWithEnvironment(keyword) : keyword;
        ShortUrlResponse shortUrlResponse = this.shortUrlWithKeyword(url, finalKeyword);
        if (shortUrlResponse.isFail() && shortUrlResponse.getFailReason().equals((Object)FailReason.KEYWORD_ALREADY_EXIST)) {
            this.deleteKeyword(finalKeyword);
            return this.encodeUrlWithKeyword(url, keyword);
        }
        if (!shortUrlResponse.isFail()) {
            return shortUrlResponse.getShortUrl();
        }
        return null;
    }

    public String encodeURLWithHash(String url, @NonNull String hash, String prefix) {
        if (hash == null) {
            throw new NullPointerException("hash");
        }
        String finalKeyword = hash.length() >= 6 ? this.generateShortHash(hash, prefix) : prefix;
        return this.encodeUrlWithKeyword(url, finalKeyword);
    }

    public String encodeWithHashMultipleTries(String url, String hash, String prefix, int maxTries) {
        for (int nTries = maxTries; nTries > 0; --nTries) {
            try {
                return this.encodeURLWithHash(url, hash, prefix);
            }
            catch (Exception e) {
                continue;
            }
        }
        throw new RuntimeException(String.format("Url shortning unavailable: tried %d times.", maxTries));
    }

    private String generateShortHash(String hash, String prefix) {
        int ini = new Random().nextInt(hash.length() - 6);
        return String.format("%s-%s", prefix, hash.substring(ini, ini + 6));
    }

    private String generateKeywordWithEnvironment(String generatedKeyword) {
        return String.format("%s-%s", this.getEnvironment(), generatedKeyword);
    }

    private void deleteKeyword(String keyword) {
        this.service.getInstance().delete(this.signature, "delete", "json", keyword);
    }

    private ShortUrlResponse shortUrlWithKeyword(String urlToEncode, String keyword) {
        Map<String, Object> result = this.service.getInstance().shorturl(this.signature, "shorturl", "json", urlToEncode, keyword.toLowerCase(), "URL Shortned via UrlEncoder.java");
        boolean fail = result.get("status").equals("fail");
        String shorturl = Optional.ofNullable(result.get("shorturl")).map(o -> o.toString()).orElse(null);
        FailReason failReason = Optional.ofNullable(result.get("message")).map(m -> {
            if (fail) {
                if (m.toString().equalsIgnoreCase(String.format("Short URL %s already exists in database or is reserved", keyword))) {
                    return FailReason.KEYWORD_ALREADY_EXIST;
                }
                return FailReason.UNKNOWN;
            }
            return null;
        }).orElse(null);
        return new ShortUrlResponse(shorturl, fail, failReason);
    }

    private String generateRandomAlphanumeric() {
        return RandomStringUtils.randomAlphanumeric((int)this.keywordLength).toLowerCase();
    }

    public YourlsApiService getService() {
        return this.service;
    }

    public int getKeywordLength() {
        return this.keywordLength;
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean isWithEnvironment() {
        return this.withEnvironment;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setService(YourlsApiService service) {
        this.service = service;
    }

    public void setKeywordLength(int keywordLength) {
        this.keywordLength = keywordLength;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public void setWithEnvironment(boolean withEnvironment) {
        this.withEnvironment = withEnvironment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UrlEncoder)) {
            return false;
        }
        UrlEncoder other = (UrlEncoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        YourlsApiService this$service = this.getService();
        YourlsApiService other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        if (this.getKeywordLength() != other.getKeywordLength()) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
            return false;
        }
        if (this.isWithEnvironment() != other.isWithEnvironment()) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        return !(this$environment == null ? other$environment != null : !this$environment.equals(other$environment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UrlEncoder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        YourlsApiService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        result = result * 59 + this.getKeywordLength();
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        result = result * 59 + (this.isWithEnvironment() ? 79 : 97);
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        return result;
    }

    public String toString() {
        return "UrlEncoder(service=" + this.getService() + ", keywordLength=" + this.getKeywordLength() + ", signature=" + this.getSignature() + ", withEnvironment=" + this.isWithEnvironment() + ", environment=" + this.getEnvironment() + ")";
    }

    protected class ShortUrlResponse {
        private String shortUrl;
        private boolean fail;
        private FailReason failReason;

        public ShortUrlResponse(String shortUrl, boolean fail, FailReason failReason) {
            this.shortUrl = shortUrl;
            this.fail = fail;
            this.failReason = failReason;
        }

        public String getShortUrl() {
            return this.shortUrl;
        }

        public boolean isFail() {
            return this.fail;
        }

        public FailReason getFailReason() {
            return this.failReason;
        }

        public void setShortUrl(String shortUrl) {
            this.shortUrl = shortUrl;
        }

        public void setFail(boolean fail) {
            this.fail = fail;
        }

        public void setFailReason(FailReason failReason) {
            this.failReason = failReason;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShortUrlResponse)) {
                return false;
            }
            ShortUrlResponse other = (ShortUrlResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$shortUrl = this.getShortUrl();
            String other$shortUrl = other.getShortUrl();
            if (this$shortUrl == null ? other$shortUrl != null : !this$shortUrl.equals(other$shortUrl)) {
                return false;
            }
            if (this.isFail() != other.isFail()) {
                return false;
            }
            FailReason this$failReason = this.getFailReason();
            FailReason other$failReason = other.getFailReason();
            return !(this$failReason == null ? other$failReason != null : !((Object)((Object)this$failReason)).equals((Object)other$failReason));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ShortUrlResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $shortUrl = this.getShortUrl();
            result = result * 59 + ($shortUrl == null ? 43 : $shortUrl.hashCode());
            result = result * 59 + (this.isFail() ? 79 : 97);
            FailReason $failReason = this.getFailReason();
            result = result * 59 + ($failReason == null ? 43 : ((Object)((Object)$failReason)).hashCode());
            return result;
        }

        public String toString() {
            return "UrlEncoder.ShortUrlResponse(shortUrl=" + this.getShortUrl() + ", fail=" + this.isFail() + ", failReason=" + (Object)((Object)this.getFailReason()) + ")";
        }
    }

    protected static enum FailReason {
        KEYWORD_ALREADY_EXIST,
        UNKNOWN;

    }
}

