module.exports = withDefaults

const graphql = require('./graphql')

function withDefaults (request, newDefaults) {
  const newRequest = request.defaults(newDefaults)
  const newApi = function (query, options) {
    return graphql(newRequest, query, options)
  }

  newApi.defaults = withDefaults.bind(null, newRequest)
  return newApi
}
