// Code generated by protoc-gen-grain. DO NOT EDIT.
// versions:
//  protoc-gen-grain v0.7.0
//  protoc           (unknown)
// source: room_actor.proto

package v1

import (
	fmt "fmt"
	slog "log/slog"
	time "time"

	actor "github.com/asynkron/protoactor-go/actor"
	cluster "github.com/asynkron/protoactor-go/cluster"
	proto "google.golang.org/protobuf/proto"
)

var xSequentialProcessorFactory func() SequentialProcessor

// SequentialProcessorFactory produces a SequentialProcessor
func SequentialProcessorFactory(factory func() SequentialProcessor) {
	xSequentialProcessorFactory = factory
}

// GetSequentialProcessorGrainClient instantiates a new SequentialProcessorGrainClient with given Identity
func GetSequentialProcessorGrainClient(c *cluster.Cluster, id string) *SequentialProcessorGrainClient {
	if c == nil {
		panic(fmt.Errorf("nil cluster instance"))
	}
	if id == "" {
		panic(fmt.Errorf("empty id"))
	}
	return &SequentialProcessorGrainClient{Identity: id, cluster: c}
}

// GetSequentialProcessorKind instantiates a new cluster.Kind for SequentialProcessor
func GetSequentialProcessorKind(opts ...actor.PropsOption) *cluster.Kind {
	props := actor.PropsFromProducer(func() actor.Actor {
		return &SequentialProcessorActor{
			Timeout: 60 * time.Second,
		}
	}, opts...)
	kind := cluster.NewKind("SequentialProcessor", props)
	return kind
}

// GetSequentialProcessorKind instantiates a new cluster.Kind for SequentialProcessor
func NewSequentialProcessorKind(factory func() SequentialProcessor, timeout time.Duration, opts ...actor.PropsOption) *cluster.Kind {
	xSequentialProcessorFactory = factory
	props := actor.PropsFromProducer(func() actor.Actor {
		return &SequentialProcessorActor{
			Timeout: timeout,
		}
	}, opts...)
	kind := cluster.NewKind("SequentialProcessor", props)
	return kind
}

// SequentialProcessor interfaces the services available to the SequentialProcessor
type SequentialProcessor interface {
	Init(ctx cluster.GrainContext)
	Terminate(ctx cluster.GrainContext)
	ReceiveDefault(ctx cluster.GrainContext)
	Progress(req *ProgressRequest, ctx cluster.GrainContext) (*ProgressResponse, error)
}

// SequentialProcessorGrainClient holds the base data for the SequentialProcessorGrain
type SequentialProcessorGrainClient struct {
	Identity string
	cluster  *cluster.Cluster
}

// Progress requests the execution on to the cluster with CallOptions
func (g *SequentialProcessorGrainClient) Progress(r *ProgressRequest, opts ...cluster.GrainCallOption) (*ProgressResponse, error) {
	if g.cluster.Config.RequestLog {
		g.cluster.Logger().Info("Requesting", slog.String("identity", g.Identity), slog.String("kind", "SequentialProcessor"), slog.String("method", "Progress"), slog.Any("request", r))
	}
	bytes, err := proto.Marshal(r)
	if err != nil {
		return nil, err
	}
	reqMsg := &cluster.GrainRequest{MethodIndex: 0, MessageData: bytes}
	resp, err := g.cluster.Request(g.Identity, "SequentialProcessor", reqMsg, opts...)
	if err != nil {
		return nil, fmt.Errorf("error request: %w", err)
	}
	switch msg := resp.(type) {
	case *ProgressResponse:
		return msg, nil
	case *cluster.GrainErrorResponse:
		if msg == nil {
			return nil, nil
		}
		return nil, msg
	default:
		return nil, fmt.Errorf("unknown response type %T", resp)
	}
}

// SequentialProcessorActor represents the actor structure
type SequentialProcessorActor struct {
	ctx     cluster.GrainContext
	inner   SequentialProcessor
	Timeout time.Duration
}

// Receive ensures the lifecycle of the actor for the received message
func (a *SequentialProcessorActor) Receive(ctx actor.Context) {
	switch msg := ctx.Message().(type) {
	case *actor.Started: //pass
	case *cluster.ClusterInit:
		a.ctx = cluster.NewGrainContext(ctx, msg.Identity, msg.Cluster)
		a.inner = xSequentialProcessorFactory()
		a.inner.Init(a.ctx)

		if a.Timeout > 0 {
			ctx.SetReceiveTimeout(a.Timeout)
		}
	case *actor.ReceiveTimeout:
		ctx.Poison(ctx.Self())
	case *actor.Stopped:
		a.inner.Terminate(a.ctx)
	case actor.AutoReceiveMessage: // pass
	case actor.SystemMessage: // pass

	case *cluster.GrainRequest:
		switch msg.MethodIndex {
		case 0:
			req := &ProgressRequest{}
			err := proto.Unmarshal(msg.MessageData, req)
			if err != nil {
				ctx.Logger().Error("[Grain] Progress(ProgressRequest) proto.Unmarshal failed.", slog.Any("error", err))
				resp := cluster.NewGrainErrorResponse(cluster.ErrorReason_INVALID_ARGUMENT, err.Error()).
					WithMetadata(map[string]string{
						"argument": req.String(),
					})
				ctx.Respond(resp)
				return
			}

			r0, err := a.inner.Progress(req, a.ctx)
			if err != nil {
				resp := cluster.FromError(err)
				ctx.Respond(resp)
				return
			}
			ctx.Respond(r0)
		}
	default:
		a.inner.ReceiveDefault(a.ctx)
	}
}

// onError should be used in ctx.ReenterAfter
// you can just return error in reenterable method for other errors
func (a *SequentialProcessorActor) onError(err error) {
	resp := cluster.FromError(err)
	a.ctx.Respond(resp)
}

func respond[T proto.Message](ctx cluster.GrainContext) func(T) {
	return func(resp T) {
		ctx.Respond(resp)
	}
}
