/*
  +----------------------------------------------------------------------+
  | PHP Version 5                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 1997-2005 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.0 of the PHP license,       |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | http://www.php.net/license/3_0.txt.                                  |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Author:                                                              |
  +----------------------------------------------------------------------+
*/

/* $Id: php_docblock.h,v 1.2 2005/11/18 05:17:40 cellog Exp $ */

#ifndef PHP_DOCBLOCK_H
#define PHP_DOCBLOCK_H

extern zend_module_entry docblock_module_entry;
#define phpext_docblock_ptr &docblock_module_entry

#ifdef PHP_WIN32
# if defined(DOCBLOCK_EXPORTS) || (!defined(COMPILE_DL_DOCBLOCK))
#  define PHP_DOCBLOCK_API __declspec(dllexport)
# elif defined(COMPILE_DL_DOCBLOCK)
#  define PHP_DOCBLOCK_API __declspec(dllimport)
# else
#  define PHP_DOCBLOCK_API /* nothing special */
# endif
#else
# define PHP_DOCBLOCK_API
#endif

#ifdef ZTS
#include "TSRM.h"
#endif

PHP_MINIT_FUNCTION(docblock);
PHP_MSHUTDOWN_FUNCTION(docblock);
PHP_RINIT_FUNCTION(docblock);
PHP_RSHUTDOWN_FUNCTION(docblock);
PHP_MINFO_FUNCTION(docblock);

PHP_FUNCTION(docblock_tokenize);
PHP_FUNCTION(docblock_token_name);

/* 
  	Declare any global variables you may need between the BEGIN
	and END macros here:     

ZEND_BEGIN_MODULE_GLOBALS(docblock)
	long  global_value;
	char *global_string;
ZEND_END_MODULE_GLOBALS(docblock)
*/

/* In every utility function you add that needs to use variables 
   in php_docblock_globals, call TSRMLS_FETCH(); after declaring other 
   variables used by that function, or better yet, pass in TSRMLS_CC
   after the last function argument and declare your utility function
   with TSRMLS_DC after the last declared argument.  Always refer to
   the globals in your function as DOCBLOCK_G(variable).  You are 
   encouraged to rename these macros something shorter, see
   examples in any other php module directory.
*/

#ifdef ZTS
#define DOCBLOCK_G(v) TSRMG(docblock_globals_id, zend_docblock_globals *, v)
#else
#define DOCBLOCK_G(v) (docblock_globals.v)
#endif

#endif	/* PHP_DOCBLOCK_H */


/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */
