#ifndef DOCBLOCK_SCAN_H
#define DOCBLOCK_SCAN_H

#include "zend.h"

#ifdef PHP_WIN32
# if defined(DOCBLOCK_EXPORTS) || (!defined(COMPILE_DL_DOCBLOCK))
#  define PHP_DOCBLOCK_API __declspec(dllexport)
# elif defined(COMPILE_DL_DOCBLOCK)
#  define PHP_DOCBLOCK_API __declspec(dllimport)
# else
#  define PHP_DOCBLOCK_API /* nothing special */
# endif
#else
# define PHP_DOCBLOCK_API
#endif
typedef struct _docblock_Scanner {
	char		*buffer;
	char		*token, *ptr;
	char		*cursor, *current_token;
	char		*length;
	int		line;
	/**
	 * Scanner state
	 */
	int		state;
	/**
	 * Determines whether we are in tags or description
	 */
	int		in_internal, in_inlinetag, in_code, in_pre;
	int		return_simplelist_end;
	zend_llist	*simplelist;
	char		*normalcursor;
	int		normaltoken;
} docblock_Scanner;

BEGIN_EXTERN_C()
extern PHP_DOCBLOCK_API int docblock_scan(docblock_Scanner *scan TSRMLS_DC);
extern PHP_DOCBLOCK_API void docblock_finish_scan(docblock_Scanner *scan TSRMLS_DC);
extern PHP_DOCBLOCK_API docblock_Scanner *docblock_prepare_string(char *str, int len TSRMLS_DC);
END_EXTERN_C()

#define DOCB_NEWLINE 1
#define DOCB_WHITESPACE 2
#define DOCB_ASTERISK 3
#define DOCB_IGNOREDLINE 4
#define DOCB_TAG 5
#define DOCB_INTERNAL 6
#define DOCB_INLINETAG 7
#define DOCB_COMMENTSTART 8
#define DOCB_ESCAPEDINLINETAG 9
#define DOCB_INLINETAGCONTENTS 10
#define DOCB_ESCAPEDHTML 11
#define DOCB_CODEOPEN 12
#define DOCB_PREOPEN 13
#define DOCB_SAMPOPEN 14
#define DOCB_VAROPEN 15
#define DOCB_KBDOPEN 16
#define DOCB_POPEN 17
#define DOCB_BOPEN 18
#define DOCB_IOPEN 19
#define DOCB_OLOPEN 20
#define DOCB_ULOPEN 21
#define DOCB_LIOPEN 22
#define DOCB_CODECLOSE 23
#define DOCB_PRECLOSE 24
#define DOCB_SAMPCLOSE 25
#define DOCB_VARCLOSE 26
#define DOCB_KBDCLOSE 27
#define DOCB_PCLOSE 28
#define DOCB_BCLOSE 29
#define DOCB_ICLOSE 30
#define DOCB_OLCLOSE 31
#define DOCB_ULCLOSE 32
#define DOCB_LICLOSE 33
#define DOCB_BR 34
#define DOCB_COMMENTEND 35
#define DOCB_TEXT 36
#define DOCB_ENDINLINETAG 37
#define DOCB_ENDINTERNAL 38
#define DOCB_ESCAPEDINLINEEND 39
#define DOCB_COMMENTTEMPLATE 40
#define DOCB_COMMENTTEMPLATEEND 41
#define DOCB_SIMPLELISTSTART 42
#define DOCB_SIMPLELISTEND 43
#define DOCB_SIMPLELISTBULLET 44
// if you add a value here, you must add it to the
// DOCBLOCK_DOREGISTER macro definition on line
// 93 of docblock.c

// add as format:
// 	macro("DOCBLOCK_XXXX",DOCB_XXXX)
// where XXXX is the name of a new token

#endif

