<?php
/**
 * \PEAR2\Pyrus\Registry\Sqlite3\Package
 *
 * PHP version 5
 *
 * @category  PEAR2
 * @package   PEAR2_Pyrus
 * @author    Greg Beaver <cellog@php.net>
 * @copyright 2010 The PEAR Group
 * @license   http://www.opensource.org/licenses/bsd-license.php New BSD License
 * @version   SVN: $Id$
 * @link      http://svn.php.net/viewvc/pear2/Pyrus/
 */

/**
 * Package within the sqlite3 registry
 *
 * @category  PEAR2
 * @package   PEAR2_Pyrus
 * @author    Greg Beaver <cellog@php.net>
 * @copyright 2010 The PEAR Group
 * @license   http://www.opensource.org/licenses/bsd-license.php New BSD License
 * @link      http://svn.php.net/viewvc/pear2/Pyrus/
 */
namespace PEAR2\Pyrus\Registry\Sqlite3;
class Package extends \PEAR2\Pyrus\Registry\Package\Base
{
    public $dirty = false;

    function __set($var, $value)
    {
        if (!isset($this->packagename)) {
            throw new \PEAR2\Pyrus\Registry\Exception('Attempt to retrieve ' . $var .
                ' from unknown package');
        }
        \PEAR2\Pyrus\PackageFile\v2::__set($var, $value);
        // occasionally, this next line will result in failure to install when incomplete data is there,
        // so we silently skip the save, and mark the packagefile as dirty
        try {
            $this->reg->replace($this);
            $this->dirty = false;
        } catch (\PEAR2\Pyrus\Registry\Exception $e) {
            $this->dirty = true;
        }
    }
}