/*
   +----------------------------------------------------------------------+
   | DocBlock Scanner                                                     |
   +----------------------------------------------------------------------+
   | Copyright (c) 2005 Gregory Beaver                                    |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.00 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_00.txt.                                 |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Gregory Beaver <cellog@php.net>                             |
   +----------------------------------------------------------------------+
*/

/* $Id: docblock_scan.re,v 1.18 2006/06/27 23:30:56 cellog Exp $ */

#include "zend_API.h"
#include "zend.h"
#include "docblock_scan.h"

/* #define DOCBLOCK_DEBUG */

/* re2c defines */
/* refill buffer - unused */
#define YYFILL(n)
/* character type */
#define YYCTYPE char
#define	YYCURSOR cursor
#define YYLIMIT s->length
#define YYMARKER s->ptr

#define DOCB_STATE(z) DOCBLOCK_SCAN_##z

#define DOCB_RET(t,z)\
	if (s->return_simplelist_end) {\
		cursor = s->token;\
		s->current_token = (char *)emalloc(cursor - s->token + 1);\
		s->current_token[0] = '\0';\
		s->return_simplelist_end = 0;\
		return DOCB_SIMPLELISTEND;\
	}\
	if (s->normalcursor) {\
		if (t == DOCB_SIMPLELISTEND) {\
			s->return_simplelist_end = 1;\
		} else {\
			s->return_simplelist_end = 0;\
		}\
		cursor = s->token;\
		s->token = s->normalcursor;\
		s->cursor = cursor;\
		s->current_token = (char *)emalloc(cursor - s->token + 1);\
		memcpy(s->current_token,s->token,cursor - s->token);\
		*(s->current_token + (cursor - s->token)) = '\0';\
		s->token = cursor;\
		s->normalcursor = 0;\
		return s->normaltoken;\
	}\
	s->cursor = cursor;\
	s->current_token = (char *)emalloc(cursor - s->token + 1);\
	memcpy(s->current_token,s->token,cursor - s->token);\
	*(s->current_token + (cursor - s->token)) = '\0';\
	s->token = cursor;\
	s->state = DOCB_STATE(z);\
	return t;

#define DOCB_BEGIN(z) s->cursor = cursor;s->token = cursor;s->state = DOCB_STATE(z);goto z;
#define DOCB_BEGINT(tok,state)\
	if (!s->normalcursor) {\
		s->normalcursor = s->token;\
		s->normaltoken = tok;\
	}\
	DOCB_BEGIN(state)


/* switch to proper error handling when the time is right*/
#define DOCB_ERROR(m) zend_printf(m);return -1;
#ifdef DOCBLOCK_DEBUG
#define DOCB_DB(message) tmp = (char *)emalloc(cursor - s->token + 1);\
	memcpy(tmp,s->token,cursor - s->token);\
	*(tmp + (cursor - s->token)) = '\0';\
	zend_printf(#message" (%.*s)\n", cursor - s->token, tmp);\
	efree(tmp);
#else
#define DOCB_DB(message)
#endif

#define DOCBLOCK_SCAN_START 1
#define DOCBLOCK_SCAN_LINESTART 2
#define DOCBLOCK_SCAN_PREASTERISK 3
#define DOCBLOCK_SCAN_POSTASTERISK 4
#define DOCBLOCK_SCAN_IGNOREDLINE 5
#define DOCBLOCK_SCAN_NORMAL 6
#define DOCBLOCK_SCAN_INTERNAL 7
#define DOCBLOCK_SCAN_INLINETAG 8
#define DOCBLOCK_SCAN_CODE 9
#define DOCBLOCK_SCAN_PRE 10
#define DOCBLOCK_SCAN_SIMPLELIST 11

typedef struct _docblock_simplelist {
	char	token[3];
	char	*whitespace;
} docblock_simplelist;

static docblock_simplelist *_docblock_new_item(docblock_Scanner *s,
					   const char *token,
					   const char *cursor, char *ptr)
{
	docblock_simplelist *listitem;
	listitem = (docblock_simplelist *) emalloc(sizeof (docblock_simplelist));
	/* note the whitespace*/
	listitem->whitespace = (char *) emalloc(ptr - token + 1);
	memcpy(listitem->whitespace, token, ptr - token);
	*(listitem->whitespace + (ptr - token)) = '\0';
	if (*ptr >= '1' && *ptr <= '9') {
		if (*(ptr + 1) == '.') {
			listitem->token[1] = '.';
		} else {
			listitem->token[1] = '\0';
		}
		listitem->token[0] = *ptr;
	} else {
		listitem->token[0] = *ptr;
		listitem->token[1] = '\0';
	}
	return listitem;
}

static void _docblock_simplelist_dtor(void *el)
{
/*	*((docblock_simplelist *) el)->whitespace = '\0';*/
/*	efree(((docblock_simplelist *) el)->whitespace);*/
}

static int _docblock_detect_new_simplelist(docblock_Scanner *s,
					   const char *token,
					   const char *cursor)
{
	int test, expt, need_dot, i;
	char *tmp, *ptr, expected_token[3];
	docblock_simplelist *testitem, *newitem;
	/* 1 = start new list, -1 = end list, 0 = error, 2 = carry on*/
	/* 3 = next list item*/
	need_dot = 0;
	expt = 0;
	test = 0;
	i = 0;
	tmp = (char *)emalloc(cursor - token + 1);
	memcpy(tmp, token, cursor - token);
	*(tmp + (cursor - token)) = '\0';
	ptr = tmp;
	expected_token[0] = '\0';
	expected_token[1] = '\0';
	expected_token[2] = '\0';
	while ((*ptr == ' ' || *ptr == '\t') && *ptr != '\0') ++ptr;

	if (*ptr == '\0') {
		/* error*/
		efree(tmp);
		return 0;
	}
	if (s->simplelist->count) {
		/* construct the next token we need to see*/
		testitem = (docblock_simplelist *) s->simplelist->tail->data;
		/* first, make sure the whitespace is identical.  If not, we*/
		/* need to be looking for other lists*/
		if ((ptr - tmp) > strlen(testitem->whitespace)) {
			if ((ptr - tmp) >= strlen(testitem->whitespace) + 1) {
				goto LOOK_FOR_OTHER_LISTS;
			} else {
				efree(tmp);
				/* a simple list has ended*/
				zend_llist_remove_tail(s->simplelist);
				return -1;
			}
		}
		if ((ptr - tmp) < strlen(testitem->whitespace)) {
			/* no need to continue, this list is over*/
			efree(tmp);
			/* a simple list has ended*/
			zend_llist_remove_tail(s->simplelist);
			return -1;
		}
		expected_token[0] = testitem->token[0];
		expected_token[1] = testitem->token[1];
		expected_token[2] = testitem->token[2];
		if (expected_token[0] >= '1' && expected_token[0] <= '9') {
			expt = (expected_token[0] - '1' + 1);
			if (expected_token[1] >= '1' && expected_token[1] <= '0') {
				if (expected_token[2] == '.') {
					need_dot = 1;
				}
				expt *= 10;
				expt += expected_token[1] - '1' + 1;
			} else {
				if (expected_token[1] == '.') {
					need_dot = 1;
				}
			}
			expt++;
			if (expt > 99) {
				/* this is a ridiculous list - who needs 99+*/
				/* simple list entries in a docblock??!*/
				zend_llist_remove_tail(s->simplelist);
				efree(tmp);
				/* end this list*/
				return -1;
			}
			expected_token[1] = '\0';
			expected_token[2] = '\0';
			if (sprintf(expected_token, "%d", expt)) {
				if (need_dot) {
					if (expected_token[1] == '\0') {
						expected_token[1] = '.';
					} else {
						expected_token[2] = '.';
					}
				}
			}
		}
		/* assume match*/
		test = 0;
		for (i = 0; i < 3; i++) {
			if (expected_token[i] == '\0') {
				break;
			}
			if (*(ptr + i) != expected_token[i]) {
				test = 1;
				break;
			}
		}
		if (!test) {
			/* bullet must always be followed by whitespace to*/
			/* be a simple list item*/
			if (*(ptr + i) != ' ' && *(ptr + i) != '\t') {
				test = 1;
			} else {
				/* save the expected token for the next list item*/
				testitem->token[0] = expected_token[0];
				testitem->token[1] = expected_token[1];
				testitem->token[2] = expected_token[2];
			}
		}
	} else {
LOOK_FOR_OTHER_LISTS:
		testitem = 0;
		/* test for tokens*/
		test = (*ptr != '*' && *ptr != '-' && *ptr != 'o' && *ptr != '+');
		i = 1;
		/* test is set if no unordered bullets were found*/
		if (test) {
			test = (*ptr != '1');
			if (!test) {
				if (*(ptr + 1) == '.') i++;
			}
		}
		/* a simplelist bullet was found*/
		if (!test) {
			/* bullet must always be followed by whitespace to*/
			/* be a simple list item*/
			if (*(ptr + i) != ' ' && *(ptr + i) != '\t') {
				test = 1;
			}
		}
	}
	/* no simple list tokens were matched*/
	if (test) {
		/* no new simplelist item*/
		if (testitem) {
			/* we need whitespace like so:*/
			/* - simplelist*/
			/*   continued line*/
			/* meaning we need 2 extra whitespace tokens*/
			if ((ptr - tmp) >= strlen(testitem->whitespace) + 2) {
				efree(tmp);
				/* continue existing list item*/
				return 2;
			} else {
				/* a simple list has ended*/
				zend_llist_remove_tail(s->simplelist);
				efree(tmp);
				return -1;
			}
		} else {
			/* no simple list*/
			efree(tmp);
			/* continue non-simple list text*/
			return 2;
		}
	} else {
		/* simple list tokens matched*/
		if (testitem) {
			/* we need identical whitespace like so:*/
			/* - simplelist item 1*/
			/* - simplelist item 2*/
			/* otherwise we have a new list*/
			if ((ptr - tmp) > strlen(testitem->whitespace)) {
				newitem = _docblock_new_item(s, token, cursor,
					(char *) ((ptr - tmp) + token));
				zend_llist_add_element(s->simplelist, newitem);
				efree(tmp);
				_docblock_simplelist_dtor(newitem);
				/* start nested list*/
				return 1;
			}
			if ((ptr - tmp) < strlen(testitem->whitespace)) {
				efree(tmp);
				zend_llist_remove_tail(s->simplelist);
				/* finish this list*/
				return -1;
			}
			/* continue with next list item*/
			efree(tmp);
			return 3;
		} else {
			/* brand new list*/
			newitem = _docblock_new_item(s, token, cursor,
				(char *) ((ptr - tmp) + token));
			zend_llist_add_element(s->simplelist, newitem);
			efree(newitem);
			efree(tmp);
			return 1;
		}
	}
}

PHP_DOCBLOCK_API docblock_Scanner *docblock_prepare_string(char *input_str, int length TSRMLS_DC)
{
	docblock_Scanner *scan;
	scan = (docblock_Scanner *)emalloc(sizeof (docblock_Scanner));
	scan->buffer = (char *)emalloc(length + 1);
	memcpy(scan->buffer, input_str, length + 1);
	scan->token = scan->buffer;
	scan->cursor = scan->token;
	scan->ptr = scan->cursor;
	scan->length = scan->buffer + length;
	scan->line = 0;
	scan->state = DOCBLOCK_SCAN_START;
	scan->in_internal = 0;
	scan->in_inlinetag = 0;
	scan->return_simplelist_end = 0;
	scan->in_code = 0;
	scan->in_pre = 0;
	scan->current_token = 0;
	scan->normalcursor = 0;
	scan->normaltoken = 0;
	scan->simplelist = (zend_llist *)emalloc(sizeof (zend_llist));
	zend_llist_init(scan->simplelist, sizeof (docblock_simplelist), _docblock_simplelist_dtor, 0);
	return scan;
}

PHP_DOCBLOCK_API void docblock_finish_scan(docblock_Scanner *s TSRMLS_DC)
{
	if (s) {
		if (s->simplelist->count) {
			zend_llist_destroy(s->simplelist);
		}
		efree(s->simplelist);
		if (s->buffer) {
			efree(s->buffer);
		}
		efree(s);
	}
}

PHP_DOCBLOCK_API int docblock_scan(docblock_Scanner *s TSRMLS_DC)
{
	char *cursor,*tmp;

	s->current_token = 0;
	if (s->cursor >= s->length) {
		if (s->normalcursor) {
			cursor = 0; /* nuke warning on windows*/
			/* unreturned output*/
			/* values are ignored, and the normalcursor will instead be returned*/
			DOCB_RET(0,IGNOREDLINE);
		}
		return 0;
	}
	cursor = s->cursor;
/*!re2c
tabsandspaces =			[ \t]+;
optionaltabsspaces =		[ \t]*;
newline =			"\r"|"\n"|"\r\n";
label =				[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*;
nonlabel =			.\[a-zA-Z_\x7f-\xff];
labelstart =			[a-zA-Z_\x7f-\xff];
tag =				"@" label ("." (label))*;

*/
#define DOCB_CASES(z) case DOCB_STATE(z):goto z;
	switch (s->state) {
		DOCB_CASES(START)
		DOCB_CASES(LINESTART)
		DOCB_CASES(PREASTERISK)
		DOCB_CASES(POSTASTERISK)
		DOCB_CASES(IGNOREDLINE)
		DOCB_CASES(NORMAL)
		DOCB_CASES(CODE)
		DOCB_CASES(PRE)
		DOCB_CASES(INLINETAG)
		DOCB_CASES(SIMPLELIST)
	}
#undef DOCB_CASES
START:
/*!re2c
"/**#@-*""/"
	{ DOCB_DB("start comment template")
	  DOCB_RET(DOCB_COMMENTTEMPLATEEND,POSTASTERISK);
	}
"/**#@+"
	{ DOCB_DB("start comment template")
	  DOCB_RET(DOCB_COMMENTTEMPLATE,POSTASTERISK);
	}
"/**"	{ DOCB_DB("start comment")
	  DOCB_RET(DOCB_COMMENTSTART,POSTASTERISK);
	}
.	{ DOCB_DB("SKIP");
	  --cursor;
	  DOCB_BEGIN(LINESTART);
	}

*/
LINESTART:
/*!re2c
"*""/"	{ if (s->simplelist->count) {
		if (!s->return_simplelist_end) {
			/* don't cut out multiple list end tokens*/
			/* when we need to*/
			zend_llist_remove_tail(s->simplelist);
		}
		cursor = s->token; /* empty token*/
		DOCB_DB("simplelist end 1")
		DOCB_RET(DOCB_SIMPLELISTEND,POSTASTERISK);
	  }
	  DOCB_DB("end comment")
	  DOCB_RET(DOCB_COMMENTEND,LINESTART);
	}
newline
	{ DOCB_DB("newline (LINESTART)")
	  DOCB_RET(DOCB_NEWLINE,LINESTART);
	}
tabsandspaces
	{ DOCB_DB("pre-asterisk whitespace")
	  DOCB_RET(DOCB_WHITESPACE,PREASTERISK);
	}
"*"	{ DOCB_DB("asterisk")
	  DOCB_RET(DOCB_ASTERISK,POSTASTERISK);
	}
[^* \t\r\n]
	{ DOCB_DB("SKIP")
	  --cursor;
	  DOCB_BEGIN(IGNOREDLINE);
	}
*/
IGNOREDLINE:
/*!re2c
"*""/"	{ if (s->simplelist->count) {
		if (!s->return_simplelist_end) {
			zend_llist_remove_tail(s->simplelist);
		}
		cursor = s->token; /* empty token*/
		DOCB_DB("simplelist end 2")
		DOCB_RET(DOCB_SIMPLELISTEND,POSTASTERISK);
	  }
	  DOCB_DB("end comment")
	  DOCB_RET(DOCB_COMMENTEND,LINESTART);
	}
newline
	{ DOCB_DB("newline (IGNOREDLINE)")
	  DOCB_RET(DOCB_NEWLINE,LINESTART);
	}
[^*\r\n]+
	{ DOCB_DB("ignored line")
	  DOCB_BEGINT(DOCB_IGNOREDLINE,IGNOREDLINE);
	}
"*"
	{ DOCB_DB("ignored line")
	  DOCB_BEGINT(DOCB_IGNOREDLINE,IGNOREDLINE);
	}
*/
PREASTERISK:
/*!re2c
"*""/"	{ if (s->simplelist->count) {
		if (!s->return_simplelist_end) {
			zend_llist_remove_tail(s->simplelist);
		}
		cursor = s->token; /* empty token*/
		DOCB_DB("simplelist end")
		DOCB_RET(DOCB_SIMPLELISTEND,POSTASTERISK);
	  }
	  DOCB_DB("end comment")
	  DOCB_RET(DOCB_COMMENTEND,LINESTART);
	}
newline
	{ DOCB_DB("newline (PREASTERISK)")
	  DOCB_RET(DOCB_NEWLINE,LINESTART);
	}
"*"	{ DOCB_DB("asterisk")
	  DOCB_RET(DOCB_ASTERISK,POSTASTERISK);
	}
[^*\r\n]
	{ DOCB_DB("SKIP")
	  --cursor;
	  DOCB_BEGIN(IGNOREDLINE);
	}
*/
POSTASTERISK:
	if (s->in_inlinetag) {
		goto INLINETAG;
	}
	if (s->in_code) {
		goto CODE;
	}
	if (s->in_pre) {
		goto PRE;
	}
	goto NOTSIMPLELIST;
SIMPLELIST:
/*!re2c
[^ \t]+	{ DOCB_DB("simple list bullet");
	  DOCB_RET(DOCB_SIMPLELISTBULLET,NORMAL);
	}
*/
NOTSIMPLELIST:
	if (!s->in_internal) {
/*!re2c
"*""/"	{ if (s->simplelist->count) {
		if (!s->return_simplelist_end) {
			zend_llist_remove_tail(s->simplelist);
		}
		cursor = s->token; /* empty token*/
		DOCB_DB("simplelist end 3")
		DOCB_RET(DOCB_SIMPLELISTEND,POSTASTERISK);
	  }
	  DOCB_DB("end comment")
	  DOCB_RET(DOCB_COMMENTEND,LINESTART);
	}
tabsandspaces+ ("-"|"+"|"o"|"*"|[1-9]|[1-9][0-9]|[1-9]"."|[1-9][0-9]".") tabsandspaces+
	{ switch (_docblock_detect_new_simplelist(s, s->token, cursor)) {
		case -1 : /* end list*/
			cursor = s->token;
			DOCB_DB("simple list end")
	  		DOCB_RET(DOCB_SIMPLELISTEND,NORMAL);
		case 3 : /* next list item*/
			cursor = s->token + strlen(
			  ((docblock_simplelist *)s->simplelist->tail->data)->whitespace);
			DOCB_DB("simple list item whitespace")
			DOCB_RET(DOCB_WHITESPACE,SIMPLELIST);
		case 1 : /* start new list*/
			cursor = s->token + strlen(
			  ((docblock_simplelist *)s->simplelist->tail->data)->whitespace);
			DOCB_DB("simple list start whitespace")
			DOCB_RET(DOCB_SIMPLELISTSTART,SIMPLELIST);
		case 0 : /* error*/
		case 2 : /* carry on as you were*/
			cursor = s->token;
			while (*cursor == ' ' || *cursor == '\t') cursor++;
			DOCB_DB("pre-content whitespace (spaces .)")
			DOCB_RET(DOCB_WHITESPACE,NORMAL)
	  }
	}
tabsandspaces+ tag
	{ if (s->simplelist->count) {
		if (!s->return_simplelist_end) {
			zend_llist_remove_tail(s->simplelist);
		}
		cursor = s->token; /* empty token*/
		DOCB_DB("simplelist end (pre-tag)")
		DOCB_RET(DOCB_SIMPLELISTEND,POSTASTERISK);
	  }
	  cursor = s->token;
	  while (*cursor == ' ' || *cursor == '\t') cursor++;
	  DOCB_DB("pre-content whitespace (pre-tag)")
	  DOCB_RET(DOCB_WHITESPACE,POSTASTERISK);
	}
tag	{ if (s->simplelist->count) {
		if (!s->return_simplelist_end) {
			zend_llist_remove_tail(s->simplelist);
		}
		cursor = s->token; /* empty token*/
		DOCB_DB("simplelist end (tag)")
		DOCB_RET(DOCB_SIMPLELISTEND,POSTASTERISK);
	  }
	  DOCB_DB("tag")
	  DOCB_RET(DOCB_TAG,NORMAL);
	}
tabsandspaces+ .
	{ switch (_docblock_detect_new_simplelist(s, s->token, cursor)) {
		case -1 : /* end list*/
			cursor = s->token;
			DOCB_DB("simple list end")
	  		DOCB_RET(DOCB_SIMPLELISTEND,POSTASTERISK);
		case 3 : /* next list item*/
			cursor = s->token + strlen(
			  ((docblock_simplelist *)s->simplelist->tail->data)->whitespace);
			DOCB_DB("simple list item whitespace")
			DOCB_RET(DOCB_WHITESPACE,SIMPLELIST);
		case 1 : /* start new list*/
			cursor = s->token + strlen(
			  ((docblock_simplelist *)s->simplelist->tail->data)->whitespace);
			DOCB_DB("simple list start whitespace")
			DOCB_RET(DOCB_SIMPLELISTSTART,SIMPLELIST);
		case 0 : /* error*/
		case 2 : /* carry on as you were*/
			cursor = s->token;
			while (*cursor == ' ' || *cursor == '\t') cursor++;
			DOCB_DB("pre-content whitespace (spaces .)")
			DOCB_RET(DOCB_WHITESPACE,NORMAL)
	  }
	}
newline
	{ if (s->simplelist->count) {
		if (!s->return_simplelist_end) {
			zend_llist_remove_tail(s->simplelist);
		}
		cursor = s->token; /* empty token*/
		DOCB_DB("simplelist end (\\n)")
		DOCB_RET(DOCB_SIMPLELISTEND,POSTASTERISK);
	  }
	  DOCB_DB("newline (POSTASTERISK)")
	  DOCB_RET(DOCB_NEWLINE,LINESTART);
	}
.	{ if (s->simplelist->count) {
		if (!s->return_simplelist_end) {
			zend_llist_remove_tail(s->simplelist);
		}
		cursor = s->token; /* empty token*/
		DOCB_DB("simplelist end (.)")
		DOCB_RET(DOCB_SIMPLELISTEND,POSTASTERISK);
	  }
	  DOCB_DB("SKIP")
	  --cursor;
	  DOCB_BEGIN(NORMAL);
	}
*/
	}
NORMAL:
	if (s->in_internal) {
/*!re2c
	"*""/"	{ if (s->simplelist->count) {
			if (!s->return_simplelist_end) {
				zend_llist_remove_tail(s->simplelist);
			}
			cursor = s->token; /* empty token*/
			DOCB_DB("simplelist end n1")
			DOCB_RET(DOCB_SIMPLELISTEND,POSTASTERISK);
		}
		DOCB_DB("end comment")
		DOCB_RET(DOCB_COMMENTEND,LINESTART);
		}
	"}}"
		{ DOCB_DB("end internal")
		/* if normalcursor is set, this will be re-scanned*/
		if (!s->normalcursor) {
			s->in_internal = 0;
		}
		DOCB_RET(DOCB_ENDINTERNAL,NORMAL);
		}
	"{@}"|"{@*}"
		{ DOCB_DB("escaped inline tag")
		DOCB_RET(DOCB_ESCAPEDINLINETAG,NORMAL);
		}
	"{"tag
		{ DOCB_DB("inline tag start")
		s->in_inlinetag = 1;
		DOCB_RET(DOCB_INLINETAG,INLINETAG);
		}
	"<<""/"?[A-Za-z]+">>"
		{ DOCB_DB("escaped html tag")
		DOCB_RET(DOCB_ESCAPEDHTML,NORMAL);
		}
	'<code>'
		{ DOCB_DB("code section begin")
		s->in_code = 1;
		DOCB_RET(DOCB_CODEOPEN,CODE);
		}
	'<pre>'
		{ DOCB_DB("pre section begin")
		s->in_pre = 1;
		DOCB_RET(DOCB_PREOPEN,PRE);
		}
	'<samp>'
		{ DOCB_DB("samp open")
		DOCB_RET(DOCB_SAMPOPEN,NORMAL);
		}
	'<kbd>'
		{ DOCB_DB("kbd open")
		DOCB_RET(DOCB_KBDOPEN,NORMAL);
		}
	'<var>'
		{ DOCB_DB("var open")
		DOCB_RET(DOCB_VAROPEN,NORMAL);
		}
	'<p>'
		{ DOCB_DB("p open")
		DOCB_RET(DOCB_POPEN,NORMAL);
		}
	'<b>'
		{ DOCB_DB("b open")
		DOCB_RET(DOCB_BOPEN,NORMAL);
		}
	'<i>'
		{ DOCB_DB("i open")
		DOCB_RET(DOCB_IOPEN,NORMAL);
		}
	'<ol>'
		{ DOCB_DB("ol open")
		DOCB_RET(DOCB_OLOPEN,NORMAL);
		}
	'<ul>'
		{ DOCB_DB("ul open")
		DOCB_RET(DOCB_ULOPEN,NORMAL);
		}
	'<li>'
		{ DOCB_DB("li open")
		DOCB_RET(DOCB_LIOPEN,NORMAL);
		}
	'</samp>'
		{ DOCB_DB("samp close")
		DOCB_RET(DOCB_SAMPCLOSE,NORMAL);
		}
	'</kbd>'
		{ DOCB_DB("kbd close")
		DOCB_RET(DOCB_KBDCLOSE,NORMAL);
		}
	'</var>'
		{ DOCB_DB("var close")
		DOCB_RET(DOCB_VARCLOSE,NORMAL);
		}
	'</p>'
		{ DOCB_DB("p close")
		DOCB_RET(DOCB_PCLOSE,NORMAL);
		}
	'</b>'
		{ DOCB_DB("b close")
		DOCB_RET(DOCB_BCLOSE,NORMAL);
		}
	'</i>'
		{ DOCB_DB("i close")
		DOCB_RET(DOCB_ICLOSE,NORMAL);
		}
	'</ol>'
		{ DOCB_DB("ol close")
		DOCB_RET(DOCB_OLCLOSE,NORMAL);
		}
	'</ul>'
		{ DOCB_DB("ul close")
		DOCB_RET(DOCB_ULCLOSE,NORMAL);
		}
	'</li>'
		{ DOCB_DB("li close")
		DOCB_RET(DOCB_LICLOSE,NORMAL);
		}
	'<br>'|'<br/>'|'<br />'
		{ DOCB_DB("br tag")
		DOCB_RET(DOCB_BR,NORMAL);
		}
	newline
		{ DOCB_DB("newline (INTERNAL)")
		DOCB_RET(DOCB_NEWLINE,LINESTART);
		}
	[^*{}<\r\n]+|.
		{ DOCB_DB("normal text")
		DOCB_BEGINT(DOCB_TEXT,NORMAL);
		}
*/
	} /* if (s->in_internal)*/
/*NORMAL_TEXT:*/
/*!re2c
"*""/"	{ if (s->simplelist->count) {
		if (!s->return_simplelist_end) {
			zend_llist_remove_tail(s->simplelist);
		}
		cursor = s->token; /* empty token*/
		DOCB_DB("simplelist end n2")
		DOCB_RET(DOCB_SIMPLELISTEND,POSTASTERISK);
	  }
	  DOCB_DB("end comment")
	  DOCB_RET(DOCB_COMMENTEND,LINESTART);
	}
"{@internal"
	{ DOCB_DB("internal start")
	  if (!s->normalcursor) {
	  	s->in_internal = 1;
	  }
	  DOCB_RET(DOCB_INTERNAL,NORMAL);
	}
"{@}"|"{@*}"
	{ DOCB_DB("escaped inline tag")
	  DOCB_RET(DOCB_ESCAPEDINLINETAG,NORMAL);
	}
"{"tag
	{ DOCB_DB("inline tag start")
	  s->in_inlinetag = 1;
	  DOCB_RET(DOCB_INLINETAG,INLINETAG);
	}
"<<""/"?[A-Za-z]+">>"
	{ DOCB_DB("escaped html tag")
	  DOCB_RET(DOCB_ESCAPEDHTML,NORMAL);
	}
'<code>'
	{ DOCB_DB("code section begin")
	  if (!s->normalcursor) {
	  	s->in_code = 1;
	  }
	  DOCB_RET(DOCB_CODEOPEN,CODE);
	}
'<pre>'
	{ DOCB_DB("pre section begin")
	  if (!s->normalcursor) {
	  	s->in_pre = 1;
	  }
	  DOCB_RET(DOCB_PREOPEN,PRE);
	}
'<samp>'
	{ DOCB_DB("samp open")
	  DOCB_RET(DOCB_SAMPOPEN,NORMAL);
	}
'<kbd>'
	{ DOCB_DB("kbd open")
	  DOCB_RET(DOCB_KBDOPEN,NORMAL);
	}
'<var>'
	{ DOCB_DB("var open")
	  DOCB_RET(DOCB_VAROPEN,NORMAL);
	}
'<p>'
	{ DOCB_DB("p open")
	  DOCB_RET(DOCB_POPEN,NORMAL);
	}
'<b>'
	{ DOCB_DB("b open")
	  DOCB_RET(DOCB_BOPEN,NORMAL);
	}
'<i>'
	{ DOCB_DB("i open")
	  DOCB_RET(DOCB_IOPEN,NORMAL);
	}
'<ol>'
	{ DOCB_DB("ol open")
	  DOCB_RET(DOCB_OLOPEN,NORMAL);
	}
'<ul>'
	{ DOCB_DB("ul open")
	  DOCB_RET(DOCB_ULOPEN,NORMAL);
	}
'<li>'
	{ DOCB_DB("li open")
	  DOCB_RET(DOCB_LIOPEN,NORMAL);
	}
'</samp>'
	{ DOCB_DB("samp close")
	  DOCB_RET(DOCB_SAMPCLOSE,NORMAL);
	}
'</kbd>'
	{ DOCB_DB("kbd close")
	  DOCB_RET(DOCB_KBDCLOSE,NORMAL);
	}
'</var>'
	{ DOCB_DB("var close")
	  DOCB_RET(DOCB_VARCLOSE,NORMAL);
	}
'</p>'
	{ DOCB_DB("p close")
	  DOCB_RET(DOCB_PCLOSE,NORMAL);
	}
'</b>'
	{ DOCB_DB("b close")
	  DOCB_RET(DOCB_BCLOSE,NORMAL);
	}
'</i>'
	{ DOCB_DB("i close")
	  DOCB_RET(DOCB_ICLOSE,NORMAL);
	}
'</ol>'
	{ DOCB_DB("ol close")
	  DOCB_RET(DOCB_OLCLOSE,NORMAL);
	}
'</ul>'
	{ DOCB_DB("ul close")
	  DOCB_RET(DOCB_ULCLOSE,NORMAL);
	}
'</li>'
	{ DOCB_DB("li close")
	  DOCB_RET(DOCB_LICLOSE,NORMAL);
	}
'<br>'|'<br/>'|'<br />'
	{ DOCB_DB("br tag")
	  DOCB_RET(DOCB_BR,NORMAL);
	}
newline
	{ DOCB_DB("newline (NORMAL)")
	  DOCB_RET(DOCB_NEWLINE,LINESTART);
	}
[^*{<\r\n]+|"{"|"<"|"*"
	{ DOCB_DB("normal text")
	  DOCB_BEGINT(DOCB_TEXT,NORMAL);
	}
*/
INLINETAG:
/*!re2c
"*""/"	{ DOCB_DB("end comment")
	  DOCB_RET(DOCB_COMMENTEND,LINESTART);
	}
"\\}"	{ DOCB_DB("escaped end inline tag")
	  DOCB_RET(DOCB_ESCAPEDINLINEEND,INLINETAG);
	}
"}"	{ DOCB_DB("end inline tag")
	  /* if normalcursor is set, this will be re-scanned*/
	  if (!s->normalcursor) {
		s->in_inlinetag = 0;
	  }
	  DOCB_RET(DOCB_ENDINLINETAG,NORMAL);
	}
[^}\\\r\n]+|.
	{ DOCB_DB("inline tag contents")
	  DOCB_BEGINT(DOCB_INLINETAGCONTENTS,INLINETAG);
	}
newline
	{ DOCB_DB("newline (INLINETAG)")
	  DOCB_RET(DOCB_NEWLINE,LINESTART);
	}
*/
CODE:
if (s->in_internal) {
	/*!re2c
	"*""/"	{ DOCB_DB("end comment")
		DOCB_RET(DOCB_COMMENTEND,LINESTART);
		}
	"</code>"
		{ DOCB_DB("close code")
		/* if normalcursor is set, this will be re-scanned*/
		if (!s->normalcursor) {
			s->in_code = 0;
		}
		DOCB_RET(DOCB_CODECLOSE,NORMAL);
		}
	newline
		{ DOCB_DB("newline (CODE)")
		DOCB_RET(DOCB_NEWLINE,LINESTART);
		}
	"}}"
		{ DOCB_DB("end internal")
		/* if normalcursor is set, this will be re-scanned*/
		if (!s->normalcursor) {
			s->in_internal = 0;
		}
		DOCB_RET(DOCB_ENDINTERNAL,CODE);
		}
	"{@}"|"{@*}"
		{ DOCB_DB("escaped inline tag")
		DOCB_RET(DOCB_ESCAPEDINLINETAG,CODE);
		}
	"{"tag
		{ DOCB_DB("inline tag start")
		if (!s->normalcursor) {
			s->in_inlinetag = 1;
		}
		DOCB_RET(DOCB_INLINETAG,INLINETAG);
		}
	'<</code>>'
		{ DOCB_DB("escaped html tag")
		DOCB_RET(DOCB_ESCAPEDHTML,CODE);
		}
	[^*\r\n{}<]+|.
		{ DOCB_DB("normal text")
		DOCB_BEGINT(DOCB_TEXT,CODE);
		}
	*/
} /* if (s->in_internal) */
/* CODE: */
/*!re2c
"*""/"	{ DOCB_DB("end comment")
	  DOCB_RET(DOCB_COMMENTEND,LINESTART);
	}
"</code>"
	{ DOCB_DB("close code")
	  /* if normalcursor is set, this will be re-scanned*/
	  if (!s->normalcursor) {
	  	s->in_code = 0;
	  }
	  DOCB_RET(DOCB_CODECLOSE,NORMAL);
	}
newline
	{ DOCB_DB("newline (CODE)")
	  DOCB_RET(DOCB_NEWLINE,LINESTART);
	}
"{@internal"
	{ DOCB_DB("internal start")
	  if (!s->normalcursor) {
	  	s->in_internal = 1;
	  }
	  DOCB_RET(DOCB_INTERNAL,CODE);
	}
"{@}"|"{@*}"
	{ DOCB_DB("escaped inline tag")
	  DOCB_RET(DOCB_ESCAPEDINLINETAG,CODE);
	}
"{"tag
	{ DOCB_DB("inline tag start")
	  if (!s->normalcursor) {
	  	s->in_inlinetag = 1;
	  }
	  DOCB_RET(DOCB_INLINETAG,INLINETAG);
	}
'<</code>>'
	{ DOCB_DB("escaped html tag")
	  DOCB_RET(DOCB_ESCAPEDHTML,CODE);
	}
[^*\r\n{<]+|.
	{ DOCB_DB("normal text")
	  DOCB_BEGINT(DOCB_TEXT,CODE);
	}
*/

PRE:

if (s->in_internal) {
/*!re2c
	"*""/"	{ DOCB_DB("end comment")
		DOCB_RET(DOCB_COMMENTEND,LINESTART);
		}
	"</pre>"
		{ DOCB_DB("close pre")
		/* if normalcursor is set, this will be re-scanned*/
		if (!s->normalcursor) {
			s->in_pre = 0;
		}
		DOCB_RET(DOCB_PRECLOSE,NORMAL);
		}
	newline
		{ DOCB_DB("newline (PRE)")
		DOCB_RET(DOCB_NEWLINE,LINESTART);
		}
	"}}"
		{ DOCB_DB("end internal")
		/* if normalcursor is set, this will be re-scanned*/
		if (!s->normalcursor) {
			s->in_internal = 0;
		}
		DOCB_RET(DOCB_ENDINTERNAL,PRE);
		}
	"{@}"|"{@*}"
		{ DOCB_DB("escaped inline tag")
		DOCB_RET(DOCB_ESCAPEDINLINETAG,PRE);
		}
	"{"tag
		{ DOCB_DB("inline tag start")
		if (!s->normalcursor) {
			s->in_inlinetag = 1;
		}
		DOCB_RET(DOCB_INLINETAG,INLINETAG);
		}
	'<</pre>>'
		{ DOCB_DB("escaped html tag")
		DOCB_RET(DOCB_ESCAPEDHTML,PRE);
		}
	[^*\r\n{}<]+|.
		{ DOCB_DB("normal text")
		DOCB_BEGINT(DOCB_TEXT,PRE);
		}
*/
} /* if (s->in_internal) */
/* PRE */
/*!re2c
"*""/"	{ DOCB_DB("end comment")
	  DOCB_RET(DOCB_COMMENTEND,LINESTART);
	}
"</pre>"
	{ DOCB_DB("close pre")
	  /* if normalcursor is set, this will be re-scanned*/
	  if (!s->normalcursor) {
		s->in_pre = 0;
	  }
	  DOCB_RET(DOCB_PRECLOSE,NORMAL);
	}
newline
	{ DOCB_DB("newline (PRE)")
	  DOCB_RET(DOCB_NEWLINE,LINESTART);
	}
"{@internal"
	{ DOCB_DB("internal start")
	  if (!s->normalcursor) {
	  	s->in_internal = 1;
	  }
	  DOCB_RET(DOCB_INTERNAL,PRE);
	}
"{@}"|"{@*}"
	{ DOCB_DB("escaped inline tag")
	  DOCB_RET(DOCB_ESCAPEDINLINETAG,PRE);
	}
"{"tag
	{ DOCB_DB("inline tag start")
	  if (!s->normalcursor) {
	  	s->in_inlinetag = 1;
	  }
	  DOCB_RET(DOCB_INLINETAG,INLINETAG);
	}
'<</pre>>'
	{ DOCB_DB("escaped html tag")
	  DOCB_RET(DOCB_ESCAPEDHTML,PRE);
	}
[^*\r\n{<]+|.
	{ DOCB_DB("normal text")
	  DOCB_BEGINT(DOCB_TEXT,PRE);
	}
*/

	return 0;
}
