/*
  +----------------------------------------------------------------------+
  | PHP Version 5                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 1997-2005 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.0 of the PHP license,       |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | http://www.php.net/license/3_0.txt.                                  |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Author: Gregory Beaver <cellog@php.net>                              |
  +----------------------------------------------------------------------+
*/

/* $Id: docblock.c,v 1.7 2006/06/27 22:52:10 cellog Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "php.h"
#include "php_ini.h"
#include "ext/standard/info.h"
#include "php_docblock.h"
#include "docblock_scan.h"

/* If you declare any globals in php_test.h uncomment this:
ZEND_DECLARE_MODULE_GLOBALS(test)
*/

/* True global resources - no need for thread safety here */
static int le_docblock;

/* {{{ docblock_functions[]
 *
 * Every user visible function must have an entry in docblock_functions[].
 */
function_entry docblock_functions[] = {
	PHP_FE(docblock_tokenize,	NULL)
	PHP_FE(docblock_token_name,	NULL)
	{NULL, NULL, NULL}
};
/* }}} */

/* {{{ docblock_module_entry
 */
zend_module_entry docblock_module_entry = {
#if ZEND_MODULE_API_NO >= 20010901
	STANDARD_MODULE_HEADER,
#endif
	"docblock",
	docblock_functions,
	PHP_MINIT(docblock),
	PHP_MSHUTDOWN(docblock),
	NULL,		/* request start */
	NULL,	/* request end */
	PHP_MINFO(docblock),
#if ZEND_MODULE_API_NO >= 20010901
	"0.1.0",
#endif
	STANDARD_MODULE_PROPERTIES
};
/* }}} */

#ifdef COMPILE_DL_DOCBLOCK
ZEND_GET_MODULE(docblock)
#endif

/* {{{ PHP_INI
 */
/* Remove comments and fill if you need to have entries in php.ini
PHP_INI_BEGIN()
    STD_PHP_INI_ENTRY("test.global_value",      "42", PHP_INI_ALL, OnUpdateLong, global_value, zend_test_globals, test_globals)
    STD_PHP_INI_ENTRY("test.global_string", "foobar", PHP_INI_ALL, OnUpdateString, global_string, zend_test_globals, test_globals)
PHP_INI_END()
*/
/* }}} */

/* {{{ php_docblock_init_globals
 */
/* Uncomment this function if you have INI entries
static void php_docblock_init_globals(zend_docblock_globals *docblock_globals)
{
	docblock_globals->global_value = 0;
	docblock_globals->global_string = NULL;
}
*/
/* }}} */
#define DOCBLOCK_DOREGISTER(macro)\
	macro("DOCBLOCK_NEWLINE",DOCB_NEWLINE)\
	macro("DOCBLOCK_WHITESPACE",DOCB_WHITESPACE)\
	macro("DOCBLOCK_ASTERISK",DOCB_ASTERISK)\
	macro("DOCBLOCK_IGNOREDLINE",DOCB_IGNOREDLINE)\
	macro("DOCBLOCK_TAG",DOCB_TAG)\
	macro("DOCBLOCK_INTERNAL",DOCB_INTERNAL)\
	macro("DOCBLOCK_INLINETAG",DOCB_INLINETAG)\
	macro("DOCBLOCK_COMMENTSTART",DOCB_COMMENTSTART)\
	macro("DOCBLOCK_ESCAPEDINLINETAG",DOCB_ESCAPEDINLINETAG)\
	macro("DOCBLOCK_INLINETAGCONTENTS",DOCB_INLINETAGCONTENTS)\
	macro("DOCBLOCK_ESCAPEDHTML",DOCB_ESCAPEDHTML)\
	macro("DOCBLOCK_CODEOPEN",DOCB_CODEOPEN)\
	macro("DOCBLOCK_PREOPEN",DOCB_PREOPEN)\
	macro("DOCBLOCK_SAMPOPEN",DOCB_SAMPOPEN)\
	macro("DOCBLOCK_VAROPEN",DOCB_VAROPEN)\
	macro("DOCBLOCK_KBDOPEN",DOCB_KBDOPEN)\
	macro("DOCBLOCK_POPEN",DOCB_POPEN)\
	macro("DOCBLOCK_BOPEN",DOCB_BOPEN)\
	macro("DOCBLOCK_IOPEN",DOCB_IOPEN)\
	macro("DOCBLOCK_OLOPEN",DOCB_OLOPEN)\
	macro("DOCBLOCK_ULOPEN",DOCB_ULOPEN)\
	macro("DOCBLOCK_LIOPEN",DOCB_LIOPEN)\
	macro("DOCBLOCK_CODECLOSE",DOCB_CODECLOSE)\
	macro("DOCBLOCK_PRECLOSE",DOCB_PRECLOSE)\
	macro("DOCBLOCK_SAMPCLOSE",DOCB_SAMPCLOSE)\
	macro("DOCBLOCK_VARCLOSE",DOCB_VARCLOSE)\
	macro("DOCBLOCK_KBDCLOSE",DOCB_KBDCLOSE)\
	macro("DOCBLOCK_PCLOSE",DOCB_PCLOSE)\
	macro("DOCBLOCK_BCLOSE",DOCB_BCLOSE)\
	macro("DOCBLOCK_ICLOSE",DOCB_ICLOSE)\
	macro("DOCBLOCK_OLCLOSE",DOCB_OLCLOSE)\
	macro("DOCBLOCK_ULCLOSE",DOCB_ULCLOSE)\
	macro("DOCBLOCK_LICLOSE",DOCB_LICLOSE)\
	macro("DOCBLOCK_BR",DOCB_BR)\
	macro("DOCBLOCK_COMMENTEND",DOCB_COMMENTEND)\
	macro("DOCBLOCK_TEXT",DOCB_TEXT)\
	macro("DOCBLOCK_ENDINLINETAG",DOCB_ENDINLINETAG)\
	macro("DOCBLOCK_ENDINTERNAL",DOCB_ENDINTERNAL)\
	macro("DOCBLOCK_ESCAPEDINLINEEND",DOCB_ESCAPEDINLINEEND)\
	macro("DOCBLOCK_COMMENTTEMPLATE",DOCB_COMMENTTEMPLATE)\
	macro("DOCBLOCK_COMMENTTEMPLATEEND",DOCB_COMMENTTEMPLATEEND)\
	macro("DOCBLOCK_SIMPLELISTSTART",DOCB_SIMPLELISTSTART)\
	macro("DOCBLOCK_SIMPLELISTEND",DOCB_SIMPLELISTEND)\
	macro("DOCBLOCK_SIMPLELISTBULLET",DOCB_SIMPLELISTBULLET)

/* {{{ PHP_MINIT_FUNCTION
 */
PHP_MINIT_FUNCTION(docblock)
{
#define RCONS(name,constname) REGISTER_LONG_CONSTANT(name,\
	 constname, CONST_CS | CONST_PERSISTENT);
	DOCBLOCK_DOREGISTER(RCONS)
	return SUCCESS;
#undef RCONS
}
/* }}} */

/* {{{ PHP_MSHUTDOWN_FUNCTION
 */
PHP_MSHUTDOWN_FUNCTION(docblock)
{
	/* uncomment this line if you have INI entries
	UNREGISTER_INI_ENTRIES();
	*/
	return SUCCESS;
}
/* }}} */

/* Remove if there's nothing to do at request start */
/* {{{ PHP_RINIT_FUNCTION
 */
PHP_RINIT_FUNCTION(docblock)
{
	return SUCCESS;
}
/* }}} */

/* Remove if there's nothing to do at request end */
/* {{{ PHP_RSHUTDOWN_FUNCTION
 */
PHP_RSHUTDOWN_FUNCTION(docblock)
{
	return SUCCESS;
}
/* }}} */

/* {{{ PHP_MINFO_FUNCTION
 */
PHP_MINFO_FUNCTION(docblock)
{
	php_info_print_table_start();
	php_info_print_table_header(2, "DocBlock Tokenizer support", "enabled");
	php_info_print_table_end();

	/* Remove comments if you have entries in php.ini
	DISPLAY_INI_ENTRIES();
	*/
}
/* }}} */


static char *
get_docblock_token_name(int token)
{
#define CASES(x,y) case y: return x;
	switch (token) {
		DOCBLOCK_DOREGISTER(CASES)
	}
#undef CASES
	return "UNKNOWN";
}
/* {{{ proto string docblock_token_name(int arg)
   Return the token name of an integer token */
PHP_FUNCTION(docblock_token_name)
{
	long token;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "l", &token)
			== FAILURE) {
		return;
	}
	RETURN_STRING(get_docblock_token_name(token), 1);
}
/* }}} */
/* {{{ proto array docblock_tokenize(string arg)
   Parse a T_DOC_COMMENT token for phpDocumentor tokens */
PHP_FUNCTION(docblock_tokenize)
{
	char *arg;
	zend_bool opt = 0, postasterisk = 0;
	int e;
	int len;
	zval *entry;
	docblock_Scanner *scan;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "s|b", &arg, &len, &opt)
			== FAILURE) {
		return;
	}

	scan = docblock_prepare_string(arg, len TSRMLS_CC);
	array_init(return_value);
	do {
SCAN_LOOP:
		e = docblock_scan(scan TSRMLS_CC);
		if (e) {
			if (opt) {
				/* in terse mode, ignore non-semantic tokens like **/
				switch (e) {
					case DOCB_COMMENTTEMPLATE :
					case DOCB_COMMENTTEMPLATEEND :
					break;
					case DOCB_COMMENTSTART :
					case DOCB_ASTERISK :
						postasterisk = 1;
						goto SCAN_LOOP;
					case DOCB_NEWLINE :
						if (postasterisk) {
							postasterisk = 0;
							break;
						} else {
							goto SCAN_LOOP;
						}
					case DOCB_COMMENTEND :
						docblock_finish_scan(scan TSRMLS_CC);
						return;
					case DOCB_SIMPLELISTEND :
						postasterisk = 1;
					default :
						if (!postasterisk) {
							goto SCAN_LOOP;
						}
				}
			}
			MAKE_STD_ZVAL(entry);
			array_init(entry);
			add_next_index_long(entry, e);
			add_next_index_string(entry, scan->current_token, 0);
			add_next_index_zval(return_value, entry);
		} else {
			break;
		}
	} while (1);
	docblock_finish_scan(scan TSRMLS_CC);
}
/* }}} */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */
