/* Generated by re2c 0.10.1 on Tue Jun 27 18:34:07 2006 */
#line 1 "ext/docblock/docblock_scan.re"
/*
   +----------------------------------------------------------------------+
   | DocBlock Scanner                                                     |
   +----------------------------------------------------------------------+
   | Copyright (c) 2005 Gregory Beaver                                    |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.00 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_00.txt.                                 |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Gregory Beaver <cellog@php.net>                             |
   +----------------------------------------------------------------------+
*/

/* $Id: docblock_scan.c,v 1.17 2006/06/27 23:30:56 cellog Exp $ */

#include "zend_API.h"
#include "zend.h"
#include "docblock_scan.h"

/* #define DOCBLOCK_DEBUG */

/* re2c defines */
/* refill buffer - unused */
#define YYFILL(n)
/* character type */
#define YYCTYPE char
#define	YYCURSOR cursor
#define YYLIMIT s->length
#define YYMARKER s->ptr

#define DOCB_STATE(z) DOCBLOCK_SCAN_##z

#define DOCB_RET(t,z)\
	if (s->return_simplelist_end) {\
		cursor = s->token;\
		s->current_token = (char *)emalloc(cursor - s->token + 1);\
		s->current_token[0] = '\0';\
		s->return_simplelist_end = 0;\
		return DOCB_SIMPLELISTEND;\
	}\
	if (s->normalcursor) {\
		if (t == DOCB_SIMPLELISTEND) {\
			s->return_simplelist_end = 1;\
		} else {\
			s->return_simplelist_end = 0;\
		}\
		cursor = s->token;\
		s->token = s->normalcursor;\
		s->cursor = cursor;\
		s->current_token = (char *)emalloc(cursor - s->token + 1);\
		memcpy(s->current_token,s->token,cursor - s->token);\
		*(s->current_token + (cursor - s->token)) = '\0';\
		s->token = cursor;\
		s->normalcursor = 0;\
		return s->normaltoken;\
	}\
	s->cursor = cursor;\
	s->current_token = (char *)emalloc(cursor - s->token + 1);\
	memcpy(s->current_token,s->token,cursor - s->token);\
	*(s->current_token + (cursor - s->token)) = '\0';\
	s->token = cursor;\
	s->state = DOCB_STATE(z);\
	return t;

#define DOCB_BEGIN(z) s->cursor = cursor;s->token = cursor;s->state = DOCB_STATE(z);goto z;
#define DOCB_BEGINT(tok,state)\
	if (!s->normalcursor) {\
		s->normalcursor = s->token;\
		s->normaltoken = tok;\
	}\
	DOCB_BEGIN(state)


/* switch to proper error handling when the time is right*/
#define DOCB_ERROR(m) zend_printf(m);return -1;
#ifdef DOCBLOCK_DEBUG
#define DOCB_DB(message) tmp = (char *)emalloc(cursor - s->token + 1);\
	memcpy(tmp,s->token,cursor - s->token);\
	*(tmp + (cursor - s->token)) = '\0';\
	zend_printf(#message" (%.*s)\n", cursor - s->token, tmp);\
	efree(tmp);
#else
#define DOCB_DB(message)
#endif

#define DOCBLOCK_SCAN_START 1
#define DOCBLOCK_SCAN_LINESTART 2
#define DOCBLOCK_SCAN_PREASTERISK 3
#define DOCBLOCK_SCAN_POSTASTERISK 4
#define DOCBLOCK_SCAN_IGNOREDLINE 5
#define DOCBLOCK_SCAN_NORMAL 6
#define DOCBLOCK_SCAN_INTERNAL 7
#define DOCBLOCK_SCAN_INLINETAG 8
#define DOCBLOCK_SCAN_CODE 9
#define DOCBLOCK_SCAN_PRE 10
#define DOCBLOCK_SCAN_SIMPLELIST 11

typedef struct _docblock_simplelist {
	char	token[3];
	char	*whitespace;
} docblock_simplelist;

static docblock_simplelist *_docblock_new_item(docblock_Scanner *s,
					   const char *token,
					   const char *cursor, char *ptr)
{
	docblock_simplelist *listitem;
	listitem = (docblock_simplelist *) emalloc(sizeof (docblock_simplelist));
	/* note the whitespace*/
	listitem->whitespace = (char *) emalloc(ptr - token + 1);
	memcpy(listitem->whitespace, token, ptr - token);
	*(listitem->whitespace + (ptr - token)) = '\0';
	if (*ptr >= '1' && *ptr <= '9') {
		if (*(ptr + 1) == '.') {
			listitem->token[1] = '.';
		} else {
			listitem->token[1] = '\0';
		}
		listitem->token[0] = *ptr;
	} else {
		listitem->token[0] = *ptr;
		listitem->token[1] = '\0';
	}
	return listitem;
}

static void _docblock_simplelist_dtor(void *el)
{
/*	*((docblock_simplelist *) el)->whitespace = '\0';*/
/*	efree(((docblock_simplelist *) el)->whitespace);*/
}

static int _docblock_detect_new_simplelist(docblock_Scanner *s,
					   const char *token,
					   const char *cursor)
{
	int test, expt, need_dot, i;
	char *tmp, *ptr, expected_token[3];
	docblock_simplelist *testitem, *newitem;
	/* 1 = start new list, -1 = end list, 0 = error, 2 = carry on*/
	/* 3 = next list item*/
	need_dot = 0;
	expt = 0;
	test = 0;
	i = 0;
	tmp = (char *)emalloc(cursor - token + 1);
	memcpy(tmp, token, cursor - token);
	*(tmp + (cursor - token)) = '\0';
	ptr = tmp;
	expected_token[0] = '\0';
	expected_token[1] = '\0';
	expected_token[2] = '\0';
	while ((*ptr == ' ' || *ptr == '\t') && *ptr != '\0') ++ptr;

	if (*ptr == '\0') {
		/* error*/
		efree(tmp);
		return 0;
	}
	if (s->simplelist->count) {
		/* construct the next token we need to see*/
		testitem = (docblock_simplelist *) s->simplelist->tail->data;
		/* first, make sure the whitespace is identical.  If not, we*/
		/* need to be looking for other lists*/
		if ((ptr - tmp) > strlen(testitem->whitespace)) {
			if ((ptr - tmp) >= strlen(testitem->whitespace) + 1) {
				goto LOOK_FOR_OTHER_LISTS;
			} else {
				efree(tmp);
				/* a simple list has ended*/
				zend_llist_remove_tail(s->simplelist);
				return -1;
			}
		}
		if ((ptr - tmp) < strlen(testitem->whitespace)) {
			/* no need to continue, this list is over*/
			efree(tmp);
			/* a simple list has ended*/
			zend_llist_remove_tail(s->simplelist);
			return -1;
		}
		expected_token[0] = testitem->token[0];
		expected_token[1] = testitem->token[1];
		expected_token[2] = testitem->token[2];
		if (expected_token[0] >= '1' && expected_token[0] <= '9') {
			expt = (expected_token[0] - '1' + 1);
			if (expected_token[1] >= '1' && expected_token[1] <= '0') {
				if (expected_token[2] == '.') {
					need_dot = 1;
				}
				expt *= 10;
				expt += expected_token[1] - '1' + 1;
			} else {
				if (expected_token[1] == '.') {
					need_dot = 1;
				}
			}
			expt++;
			if (expt > 99) {
				/* this is a ridiculous list - who needs 99+*/
				/* simple list entries in a docblock??!*/
				zend_llist_remove_tail(s->simplelist);
				efree(tmp);
				/* end this list*/
				return -1;
			}
			expected_token[1] = '\0';
			expected_token[2] = '\0';
			if (sprintf(expected_token, "%d", expt)) {
				if (need_dot) {
					if (expected_token[1] == '\0') {
						expected_token[1] = '.';
					} else {
						expected_token[2] = '.';
					}
				}
			}
		}
		/* assume match*/
		test = 0;
		for (i = 0; i < 3; i++) {
			if (expected_token[i] == '\0') {
				break;
			}
			if (*(ptr + i) != expected_token[i]) {
				test = 1;
				break;
			}
		}
		if (!test) {
			/* bullet must always be followed by whitespace to*/
			/* be a simple list item*/
			if (*(ptr + i) != ' ' && *(ptr + i) != '\t') {
				test = 1;
			} else {
				/* save the expected token for the next list item*/
				testitem->token[0] = expected_token[0];
				testitem->token[1] = expected_token[1];
				testitem->token[2] = expected_token[2];
			}
		}
	} else {
LOOK_FOR_OTHER_LISTS:
		testitem = 0;
		/* test for tokens*/
		test = (*ptr != '*' && *ptr != '-' && *ptr != 'o' && *ptr != '+');
		i = 1;
		/* test is set if no unordered bullets were found*/
		if (test) {
			test = (*ptr != '1');
			if (!test) {
				if (*(ptr + 1) == '.') i++;
			}
		}
		/* a simplelist bullet was found*/
		if (!test) {
			/* bullet must always be followed by whitespace to*/
			/* be a simple list item*/
			if (*(ptr + i) != ' ' && *(ptr + i) != '\t') {
				test = 1;
			}
		}
	}
	/* no simple list tokens were matched*/
	if (test) {
		/* no new simplelist item*/
		if (testitem) {
			/* we need whitespace like so:*/
			/* - simplelist*/
			/*   continued line*/
			/* meaning we need 2 extra whitespace tokens*/
			if ((ptr - tmp) >= strlen(testitem->whitespace) + 2) {
				efree(tmp);
				/* continue existing list item*/
				return 2;
			} else {
				/* a simple list has ended*/
				zend_llist_remove_tail(s->simplelist);
				efree(tmp);
				return -1;
			}
		} else {
			/* no simple list*/
			efree(tmp);
			/* continue non-simple list text*/
			return 2;
		}
	} else {
		/* simple list tokens matched*/
		if (testitem) {
			/* we need identical whitespace like so:*/
			/* - simplelist item 1*/
			/* - simplelist item 2*/
			/* otherwise we have a new list*/
			if ((ptr - tmp) > strlen(testitem->whitespace)) {
				newitem = _docblock_new_item(s, token, cursor,
					(char *) ((ptr - tmp) + token));
				zend_llist_add_element(s->simplelist, newitem);
				efree(tmp);
				_docblock_simplelist_dtor(newitem);
				/* start nested list*/
				return 1;
			}
			if ((ptr - tmp) < strlen(testitem->whitespace)) {
				efree(tmp);
				zend_llist_remove_tail(s->simplelist);
				/* finish this list*/
				return -1;
			}
			/* continue with next list item*/
			efree(tmp);
			return 3;
		} else {
			/* brand new list*/
			newitem = _docblock_new_item(s, token, cursor,
				(char *) ((ptr - tmp) + token));
			zend_llist_add_element(s->simplelist, newitem);
			efree(newitem);
			efree(tmp);
			return 1;
		}
	}
}

PHP_DOCBLOCK_API docblock_Scanner *docblock_prepare_string(char *input_str, int length TSRMLS_DC)
{
	docblock_Scanner *scan;
	scan = (docblock_Scanner *)emalloc(sizeof (docblock_Scanner));
	scan->buffer = (char *)emalloc(length + 1);
	memcpy(scan->buffer, input_str, length + 1);
	scan->token = scan->buffer;
	scan->cursor = scan->token;
	scan->ptr = scan->cursor;
	scan->length = scan->buffer + length;
	scan->line = 0;
	scan->state = DOCBLOCK_SCAN_START;
	scan->in_internal = 0;
	scan->in_inlinetag = 0;
	scan->return_simplelist_end = 0;
	scan->in_code = 0;
	scan->in_pre = 0;
	scan->current_token = 0;
	scan->normalcursor = 0;
	scan->normaltoken = 0;
	scan->simplelist = (zend_llist *)emalloc(sizeof (zend_llist));
	zend_llist_init(scan->simplelist, sizeof (docblock_simplelist), _docblock_simplelist_dtor, 0);
	return scan;
}

PHP_DOCBLOCK_API void docblock_finish_scan(docblock_Scanner *s TSRMLS_DC)
{
	if (s) {
		if (s->simplelist->count) {
			zend_llist_destroy(s->simplelist);
		}
		efree(s->simplelist);
		if (s->buffer) {
			efree(s->buffer);
		}
		efree(s);
	}
}

PHP_DOCBLOCK_API int docblock_scan(docblock_Scanner *s TSRMLS_DC)
{
	char *cursor,*tmp;

	s->current_token = 0;
	if (s->cursor >= s->length) {
		if (s->normalcursor) {
			cursor = 0; /* nuke warning on windows*/
			/* unreturned output*/
			/* values are ignored, and the normalcursor will instead be returned*/
			DOCB_RET(0,IGNOREDLINE);
		}
		return 0;
	}
	cursor = s->cursor;
#line 393 "ext/docblock/docblock_scan.re"

#define DOCB_CASES(z) case DOCB_STATE(z):goto z;
	switch (s->state) {
		DOCB_CASES(START)
		DOCB_CASES(LINESTART)
		DOCB_CASES(PREASTERISK)
		DOCB_CASES(POSTASTERISK)
		DOCB_CASES(IGNOREDLINE)
		DOCB_CASES(NORMAL)
		DOCB_CASES(CODE)
		DOCB_CASES(PRE)
		DOCB_CASES(INLINETAG)
		DOCB_CASES(SIMPLELIST)
	}
#undef DOCB_CASES
START:
{

#line 406 "ext/docblock/docblock_scan.c"
	{
		YYCTYPE yych;
		unsigned int yyaccept = 0;

		if((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
		yych = *YYCURSOR;
		if(yych == 0x0A) goto yy2;
		if(yych == '/') goto yy3;
		goto yy5;
yy2:
		YYCURSOR = YYMARKER;
		switch(yyaccept){
		case 1:	goto yy8;
		case 0:	goto yy4;
		}
yy3:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '*') goto yy6;
yy4:
#line 421 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("SKIP");
	  --cursor;
	  DOCB_BEGIN(LINESTART);
	}
#line 432 "ext/docblock/docblock_scan.c"
yy5:
		yych = *++YYCURSOR;
		goto yy4;
yy6:
		yych = *++YYCURSOR;
		if(yych != '*') goto yy2;
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '#') goto yy9;
yy8:
#line 418 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("start comment")
	  DOCB_RET(DOCB_COMMENTSTART,POSTASTERISK);
	}
#line 447 "ext/docblock/docblock_scan.c"
yy9:
		yych = *++YYCURSOR;
		if(yych != '@') goto yy2;
		yych = *++YYCURSOR;
		if(yych == '+') goto yy11;
		if(yych == '-') goto yy13;
		goto yy2;
yy11:
		++YYCURSOR;
#line 415 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("start comment template")
	  DOCB_RET(DOCB_COMMENTTEMPLATE,POSTASTERISK);
	}
#line 461 "ext/docblock/docblock_scan.c"
yy13:
		yych = *++YYCURSOR;
		if(yych != '*') goto yy2;
		yych = *++YYCURSOR;
		if(yych != '/') goto yy2;
		++YYCURSOR;
#line 411 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("start comment template")
	  DOCB_RET(DOCB_COMMENTTEMPLATEEND,POSTASTERISK);
	}
#line 472 "ext/docblock/docblock_scan.c"
	}
}
#line 426 "ext/docblock/docblock_scan.re"

LINESTART:
{
	static unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 128,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		128,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};

#line 514 "ext/docblock/docblock_scan.c"
	{
		YYCTYPE yych;
		if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 128) {
			goto yy24;
		}
		if(yych <= 0x0C) {
			if(yych == 0x0A) goto yy21;
			goto yy27;
		} else {
			if(yych <= 0x0D) goto yy23;
			if(yych != '*') goto yy27;
		}
		++YYCURSOR;
		if((yych = *YYCURSOR) == '/') goto yy29;
#line 450 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("asterisk")
	  DOCB_RET(DOCB_ASTERISK,POSTASTERISK);
	}
#line 535 "ext/docblock/docblock_scan.c"
yy21:
		++YYCURSOR;
yy22:
#line 443 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("newline (LINESTART)")
	  DOCB_RET(DOCB_NEWLINE,LINESTART);
	}
#line 543 "ext/docblock/docblock_scan.c"
yy23:
		yych = *++YYCURSOR;
		if(yych == 0x0A) goto yy21;
		goto yy22;
yy24:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 128) {
			goto yy24;
		}
#line 447 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("pre-asterisk whitespace")
	  DOCB_RET(DOCB_WHITESPACE,PREASTERISK);
	}
#line 559 "ext/docblock/docblock_scan.c"
yy27:
		++YYCURSOR;
#line 454 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("SKIP")
	  --cursor;
	  DOCB_BEGIN(IGNOREDLINE);
	}
#line 567 "ext/docblock/docblock_scan.c"
yy29:
		++YYCURSOR;
#line 429 "ext/docblock/docblock_scan.re"
		{ if (s->simplelist->count) {
		if (!s->return_simplelist_end) {
			/* don't cut out multiple list end tokens*/
			/* when we need to*/
			zend_llist_remove_tail(s->simplelist);
		}
		cursor = s->token; /* empty token*/
		DOCB_DB("simplelist end 1")
		DOCB_RET(DOCB_SIMPLELISTEND,POSTASTERISK);
	  }
	  DOCB_DB("end comment")
	  DOCB_RET(DOCB_COMMENTEND,LINESTART);
	}
#line 584 "ext/docblock/docblock_scan.c"
	}
}
#line 458 "ext/docblock/docblock_scan.re"

IGNOREDLINE:
{
	static unsigned char yybm[] = {
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128,   0, 128, 128,   0, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128,   0, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
	};

#line 626 "ext/docblock/docblock_scan.c"
	{
		YYCTYPE yych;
		if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 128) {
			goto yy38;
		}
		if(yych <= 0x0C) goto yy35;
		if(yych <= 0x0D) goto yy37;
		++YYCURSOR;
		if((yych = *YYCURSOR) == '/') goto yy41;
#line 481 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("ignored line")
	  DOCB_BEGINT(DOCB_IGNOREDLINE,IGNOREDLINE);
	}
#line 642 "ext/docblock/docblock_scan.c"
yy35:
		++YYCURSOR;
yy36:
#line 473 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("newline (IGNOREDLINE)")
	  DOCB_RET(DOCB_NEWLINE,LINESTART);
	}
#line 650 "ext/docblock/docblock_scan.c"
yy37:
		yych = *++YYCURSOR;
		if(yych == 0x0A) goto yy35;
		goto yy36;
yy38:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 128) {
			goto yy38;
		}
#line 477 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("ignored line")
	  DOCB_BEGINT(DOCB_IGNOREDLINE,IGNOREDLINE);
	}
#line 666 "ext/docblock/docblock_scan.c"
yy41:
		++YYCURSOR;
#line 461 "ext/docblock/docblock_scan.re"
		{ if (s->simplelist->count) {
		if (!s->return_simplelist_end) {
			zend_llist_remove_tail(s->simplelist);
		}
		cursor = s->token; /* empty token*/
		DOCB_DB("simplelist end 2")
		DOCB_RET(DOCB_SIMPLELISTEND,POSTASTERISK);
	  }
	  DOCB_DB("end comment")
	  DOCB_RET(DOCB_COMMENTEND,LINESTART);
	}
#line 681 "ext/docblock/docblock_scan.c"
	}
}
#line 484 "ext/docblock/docblock_scan.re"

PREASTERISK:
{

#line 689 "ext/docblock/docblock_scan.c"
	{
		YYCTYPE yych;
		if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
		yych = *YYCURSOR;
		if(yych <= 0x0C) {
			if(yych == 0x0A) goto yy47;
			goto yy50;
		} else {
			if(yych <= 0x0D) goto yy49;
			if(yych != '*') goto yy50;
		}
		++YYCURSOR;
		if((yych = *YYCURSOR) == '/') goto yy52;
#line 502 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("asterisk")
	  DOCB_RET(DOCB_ASTERISK,POSTASTERISK);
	}
#line 707 "ext/docblock/docblock_scan.c"
yy47:
		++YYCURSOR;
yy48:
#line 499 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("newline (PREASTERISK)")
	  DOCB_RET(DOCB_NEWLINE,LINESTART);
	}
#line 715 "ext/docblock/docblock_scan.c"
yy49:
		yych = *++YYCURSOR;
		if(yych == 0x0A) goto yy47;
		goto yy48;
yy50:
		++YYCURSOR;
#line 506 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("SKIP")
	  --cursor;
	  DOCB_BEGIN(IGNOREDLINE);
	}
#line 727 "ext/docblock/docblock_scan.c"
yy52:
		++YYCURSOR;
#line 487 "ext/docblock/docblock_scan.re"
		{ if (s->simplelist->count) {
		if (!s->return_simplelist_end) {
			zend_llist_remove_tail(s->simplelist);
		}
		cursor = s->token; /* empty token*/
		DOCB_DB("simplelist end")
		DOCB_RET(DOCB_SIMPLELISTEND,POSTASTERISK);
	  }
	  DOCB_DB("end comment")
	  DOCB_RET(DOCB_COMMENTEND,LINESTART);
	}
#line 742 "ext/docblock/docblock_scan.c"
	}
}
#line 510 "ext/docblock/docblock_scan.re"

POSTASTERISK:
	if (s->in_inlinetag) {
		goto INLINETAG;
	}
	if (s->in_code) {
		goto CODE;
	}
	if (s->in_pre) {
		goto PRE;
	}
	goto NOTSIMPLELIST;
SIMPLELIST:
{
	static unsigned char yybm[] = {
		128, 128, 128, 128, 128, 128, 128, 128, 
		128,   0, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		  0, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
	};

#line 795 "ext/docblock/docblock_scan.c"
	{
		YYCTYPE yych;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 128) {
			goto yy57;
		}
yy57:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 128) {
			goto yy57;
		}
#line 524 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("simple list bullet");
	  DOCB_RET(DOCB_SIMPLELISTBULLET,NORMAL);
	}
#line 814 "ext/docblock/docblock_scan.c"
	}
}
#line 527 "ext/docblock/docblock_scan.re"

NOTSIMPLELIST:
	if (!s->in_internal) {
{
	static unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 128,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		128,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,   0,   0,   0,   0,   0,   0, 
		  0,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,   0,   0,   0,   0,  64, 
		  0,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,   0,   0,   0,   0,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
	};

#line 857 "ext/docblock/docblock_scan.c"
	{
		YYCTYPE yych;
		unsigned int yyaccept = 0;
		if((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
		yych = *YYCURSOR;
		if(yych <= 0x1F) {
			if(yych <= 0x0A) {
				if(yych <= 0x08) goto yy69;
				if(yych <= 0x09) goto yy64;
				goto yy66;
			} else {
				if(yych == 0x0D) goto yy68;
				goto yy69;
			}
		} else {
			if(yych <= '*') {
				if(yych <= ' ') goto yy64;
				if(yych <= ')') goto yy69;
			} else {
				if(yych == '@') goto yy65;
				goto yy69;
			}
		}
		++YYCURSOR;
		if((yych = *YYCURSOR) == '/') goto yy95;
yy63:
#line 627 "ext/docblock/docblock_scan.re"
		{ if (s->simplelist->count) {
		if (!s->return_simplelist_end) {
			zend_llist_remove_tail(s->simplelist);
		}
		cursor = s->token; /* empty token*/
		DOCB_DB("simplelist end (.)")
		DOCB_RET(DOCB_SIMPLELISTEND,POSTASTERISK);
	  }
	  DOCB_DB("SKIP")
	  --cursor;
	  DOCB_BEGIN(NORMAL);
	}
#line 897 "ext/docblock/docblock_scan.c"
yy64:
		yych = *++YYCURSOR;
		if(yych == 0x0A) goto yy63;
		goto yy80;
yy65:
		yych = *++YYCURSOR;
		if(yych <= '_') {
			if(yych <= '@') goto yy63;
			if(yych <= 'Z') goto yy70;
			if(yych <= '^') goto yy63;
			goto yy70;
		} else {
			if(yych <= '`') goto yy63;
			if(yych <= 'z') goto yy70;
			if(yych <= '~') goto yy63;
			goto yy70;
		}
yy66:
		++YYCURSOR;
yy67:
#line 616 "ext/docblock/docblock_scan.re"
		{ if (s->simplelist->count) {
		if (!s->return_simplelist_end) {
			zend_llist_remove_tail(s->simplelist);
		}
		cursor = s->token; /* empty token*/
		DOCB_DB("simplelist end (\\n)")
		DOCB_RET(DOCB_SIMPLELISTEND,POSTASTERISK);
	  }
	  DOCB_DB("newline (POSTASTERISK)")
	  DOCB_RET(DOCB_NEWLINE,LINESTART);
	}
#line 930 "ext/docblock/docblock_scan.c"
yy68:
		yych = *++YYCURSOR;
		if(yych == 0x0A) goto yy66;
		goto yy67;
yy69:
		yych = *++YYCURSOR;
		goto yy63;
yy70:
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 64) {
			goto yy70;
		}
		if(yych == '.') goto yy73;
yy72:
#line 580 "ext/docblock/docblock_scan.re"
		{ if (s->simplelist->count) {
		if (!s->return_simplelist_end) {
			zend_llist_remove_tail(s->simplelist);
		}
		cursor = s->token; /* empty token*/
		DOCB_DB("simplelist end (tag)")
		DOCB_RET(DOCB_SIMPLELISTEND,POSTASTERISK);
	  }
	  DOCB_DB("tag")
	  DOCB_RET(DOCB_TAG,NORMAL);
	}
#line 960 "ext/docblock/docblock_scan.c"
yy73:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= '_') {
			if(yych <= '@') goto yy74;
			if(yych <= 'Z') goto yy75;
			if(yych >= '_') goto yy75;
		} else {
			if(yych <= '`') goto yy74;
			if(yych <= 'z') goto yy75;
			if(yych >= 0x7F) goto yy75;
		}
yy74:
		YYCURSOR = YYMARKER;
		switch(yyaccept){
		case 2:	goto yy86;
		case 0:	goto yy72;
		case 1:	goto yy78;
		}
yy75:
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= 'Z') {
			if(yych <= '/') {
				if(yych == '.') goto yy73;
				goto yy72;
			} else {
				if(yych <= '9') goto yy75;
				if(yych <= '@') goto yy72;
				goto yy75;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy75;
				goto yy72;
			} else {
				if(yych <= 'z') goto yy75;
				if(yych <= '~') goto yy72;
				goto yy75;
			}
		}
yy77:
		++YYCURSOR;
yy78:
#line 592 "ext/docblock/docblock_scan.re"
		{ switch (_docblock_detect_new_simplelist(s, s->token, cursor)) {
		case -1 : /* end list*/
			cursor = s->token;
			DOCB_DB("simple list end")
	  		DOCB_RET(DOCB_SIMPLELISTEND,POSTASTERISK);
		case 3 : /* next list item*/
			cursor = s->token + strlen(
			  ((docblock_simplelist *)s->simplelist->tail->data)->whitespace);
			DOCB_DB("simple list item whitespace")
			DOCB_RET(DOCB_WHITESPACE,SIMPLELIST);
		case 1 : /* start new list*/
			cursor = s->token + strlen(
			  ((docblock_simplelist *)s->simplelist->tail->data)->whitespace);
			DOCB_DB("simple list start whitespace")
			DOCB_RET(DOCB_SIMPLELISTSTART,SIMPLELIST);
		case 0 : /* error*/
		case 2 : /* carry on as you were*/
			cursor = s->token;
			while (*cursor == ' ' || *cursor == '\t') cursor++;
			DOCB_DB("pre-content whitespace (spaces .)")
			DOCB_RET(DOCB_WHITESPACE,NORMAL)
	  }
	}
#line 1032 "ext/docblock/docblock_scan.c"
yy79:
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
		yych = *YYCURSOR;
yy80:
		if(yybm[0+yych] & 128) {
			goto yy79;
		}
		if(yych <= '-') {
			if(yych <= ')') {
				if(yych == 0x0A) goto yy78;
				goto yy77;
			} else {
				if(yych == ',') goto yy77;
			}
		} else {
			if(yych <= '?') {
				if(yych <= '0') goto yy77;
				if(yych <= '9') goto yy82;
				goto yy77;
			} else {
				if(yych <= '@') goto yy83;
				if(yych != 'o') goto yy77;
			}
		}
		yych = *++YYCURSOR;
		if(yych == 0x09) goto yy92;
		if(yych == ' ') goto yy92;
		goto yy78;
yy82:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ' ') {
			if(yych == 0x09) goto yy92;
			if(yych <= 0x1F) goto yy78;
			goto yy92;
		} else {
			if(yych <= '.') {
				if(yych <= '-') goto yy78;
				goto yy91;
			} else {
				if(yych <= '/') goto yy78;
				if(yych <= '9') goto yy90;
				goto yy78;
			}
		}
yy83:
		yych = *++YYCURSOR;
		if(yych <= '_') {
			if(yych <= '@') goto yy78;
			if(yych <= 'Z') goto yy84;
			if(yych <= '^') goto yy78;
		} else {
			if(yych <= '`') goto yy78;
			if(yych <= 'z') goto yy84;
			if(yych <= '~') goto yy78;
		}
yy84:
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= 'Z') {
			if(yych <= '/') {
				if(yych == '.') goto yy87;
			} else {
				if(yych <= '9') goto yy84;
				if(yych >= 'A') goto yy84;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy84;
			} else {
				if(yych <= 'z') goto yy84;
				if(yych >= 0x7F) goto yy84;
			}
		}
yy86:
#line 567 "ext/docblock/docblock_scan.re"
		{ if (s->simplelist->count) {
		if (!s->return_simplelist_end) {
			zend_llist_remove_tail(s->simplelist);
		}
		cursor = s->token; /* empty token*/
		DOCB_DB("simplelist end (pre-tag)")
		DOCB_RET(DOCB_SIMPLELISTEND,POSTASTERISK);
	  }
	  cursor = s->token;
	  while (*cursor == ' ' || *cursor == '\t') cursor++;
	  DOCB_DB("pre-content whitespace (pre-tag)")
	  DOCB_RET(DOCB_WHITESPACE,POSTASTERISK);
	}
#line 1125 "ext/docblock/docblock_scan.c"
yy87:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= '_') {
			if(yych <= '@') goto yy74;
			if(yych <= 'Z') goto yy88;
			if(yych <= '^') goto yy74;
		} else {
			if(yych <= '`') goto yy74;
			if(yych <= 'z') goto yy88;
			if(yych <= '~') goto yy74;
		}
yy88:
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= 'Z') {
			if(yych <= '/') {
				if(yych == '.') goto yy87;
				goto yy86;
			} else {
				if(yych <= '9') goto yy88;
				if(yych <= '@') goto yy86;
				goto yy88;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy88;
				goto yy86;
			} else {
				if(yych <= 'z') goto yy88;
				if(yych <= '~') goto yy86;
				goto yy88;
			}
		}
yy90:
		yych = *++YYCURSOR;
		if(yych <= 0x1F) {
			if(yych == 0x09) goto yy92;
			goto yy74;
		} else {
			if(yych <= ' ') goto yy92;
			if(yych != '.') goto yy74;
		}
yy91:
		yych = *++YYCURSOR;
		if(yych == 0x09) goto yy92;
		if(yych != ' ') goto yy74;
yy92:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych == 0x09) goto yy92;
		if(yych == ' ') goto yy92;
#line 543 "ext/docblock/docblock_scan.re"
		{ switch (_docblock_detect_new_simplelist(s, s->token, cursor)) {
		case -1 : /* end list*/
			cursor = s->token;
			DOCB_DB("simple list end")
	  		DOCB_RET(DOCB_SIMPLELISTEND,NORMAL);
		case 3 : /* next list item*/
			cursor = s->token + strlen(
			  ((docblock_simplelist *)s->simplelist->tail->data)->whitespace);
			DOCB_DB("simple list item whitespace")
			DOCB_RET(DOCB_WHITESPACE,SIMPLELIST);
		case 1 : /* start new list*/
			cursor = s->token + strlen(
			  ((docblock_simplelist *)s->simplelist->tail->data)->whitespace);
			DOCB_DB("simple list start whitespace")
			DOCB_RET(DOCB_SIMPLELISTSTART,SIMPLELIST);
		case 0 : /* error*/
		case 2 : /* carry on as you were*/
			cursor = s->token;
			while (*cursor == ' ' || *cursor == '\t') cursor++;
			DOCB_DB("pre-content whitespace (spaces .)")
			DOCB_RET(DOCB_WHITESPACE,NORMAL)
	  }
	}
#line 1206 "ext/docblock/docblock_scan.c"
yy95:
		++YYCURSOR;
#line 531 "ext/docblock/docblock_scan.re"
		{ if (s->simplelist->count) {
		if (!s->return_simplelist_end) {
			zend_llist_remove_tail(s->simplelist);
		}
		cursor = s->token; /* empty token*/
		DOCB_DB("simplelist end 3")
		DOCB_RET(DOCB_SIMPLELISTEND,POSTASTERISK);
	  }
	  DOCB_DB("end comment")
	  DOCB_RET(DOCB_COMMENTEND,LINESTART);
	}
#line 1221 "ext/docblock/docblock_scan.c"
	}
}
#line 639 "ext/docblock/docblock_scan.re"

	}
NORMAL:
	if (s->in_internal) {
{
	static unsigned char yybm[] = {
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,   0,  32,  32,   0,  32,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,   0,  32,  32,  32,  32,  32, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160,  32,  32,   0,  32,  32,  32, 
		 32, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224,  32,  32,  32,  32, 160, 
		 32, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224,   0,  32,   0,  32, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
	};

#line 1265 "ext/docblock/docblock_scan.c"
	{
		YYCTYPE yych;
		unsigned int yyaccept = 0;
		if((YYLIMIT - YYCURSOR) < 7) YYFILL(7);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 32) {
			goto yy107;
		}
		if(yych <= ';') {
			if(yych <= 0x0C) goto yy104;
			if(yych <= 0x0D) goto yy106;
		} else {
			if(yych <= '<') goto yy103;
			if(yych <= '|') goto yy102;
			goto yy101;
		}
		++YYCURSOR;
		if((yych = *YYCURSOR) == '/') goto yy220;
yy100:
#line 767 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("normal text")
		DOCB_BEGINT(DOCB_TEXT,NORMAL);
		}
#line 1289 "ext/docblock/docblock_scan.c"
yy101:
		yych = *++YYCURSOR;
		if(yych == '}') goto yy218;
		goto yy100;
yy102:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '@') goto yy208;
		goto yy100;
yy103:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		switch(yych){
		case '/':	goto yy111;
		case '<':	goto yy121;
		case 'B':
		case 'b':	goto yy109;
		case 'C':
		case 'c':	goto yy120;
		case 'I':
		case 'i':	goto yy115;
		case 'K':
		case 'k':	goto yy118;
		case 'L':
		case 'l':	goto yy112;
		case 'O':
		case 'o':	goto yy114;
		case 'P':
		case 'p':	goto yy116;
		case 'S':
		case 's':	goto yy119;
		case 'U':
		case 'u':	goto yy113;
		case 'V':
		case 'v':	goto yy117;
		default:	goto yy100;
		}
yy104:
		++YYCURSOR;
yy105:
#line 763 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("newline (INTERNAL)")
		DOCB_RET(DOCB_NEWLINE,LINESTART);
		}
#line 1334 "ext/docblock/docblock_scan.c"
yy106:
		yych = *++YYCURSOR;
		if(yych == 0x0A) goto yy104;
		goto yy105;
yy107:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 32) {
			goto yy107;
		}
		goto yy100;
yy109:
		yych = *++YYCURSOR;
		if(yych <= 'Q') {
			if(yych == '>') goto yy200;
		} else {
			if(yych <= 'R') goto yy202;
			if(yych == 'r') goto yy202;
		}
yy110:
		YYCURSOR = YYMARKER;
		switch(yyaccept){
		case 1:	goto yy214;
		case 0:	goto yy100;
		}
yy111:
		yych = *++YYCURSOR;
		switch(yych){
		case 'B':
		case 'b':	goto yy167;
		case 'I':
		case 'i':	goto yy168;
		case 'K':
		case 'k':	goto yy164;
		case 'L':
		case 'l':	goto yy171;
		case 'O':
		case 'o':	goto yy169;
		case 'P':
		case 'p':	goto yy166;
		case 'S':
		case 's':	goto yy163;
		case 'U':
		case 'u':	goto yy170;
		case 'V':
		case 'v':	goto yy165;
		default:	goto yy110;
		}
yy112:
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy160;
		if(yych == 'i') goto yy160;
		goto yy110;
yy113:
		yych = *++YYCURSOR;
		if(yych == 'L') goto yy157;
		if(yych == 'l') goto yy157;
		goto yy110;
yy114:
		yych = *++YYCURSOR;
		if(yych == 'L') goto yy154;
		if(yych == 'l') goto yy154;
		goto yy110;
yy115:
		yych = *++YYCURSOR;
		if(yych == '>') goto yy152;
		goto yy110;
yy116:
		yych = *++YYCURSOR;
		if(yych <= 'Q') {
			if(yych == '>') goto yy147;
			goto yy110;
		} else {
			if(yych <= 'R') goto yy146;
			if(yych == 'r') goto yy146;
			goto yy110;
		}
yy117:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy142;
		if(yych == 'a') goto yy142;
		goto yy110;
yy118:
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy138;
		if(yych == 'b') goto yy138;
		goto yy110;
yy119:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy133;
		if(yych == 'a') goto yy133;
		goto yy110;
yy120:
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy128;
		if(yych == 'o') goto yy128;
		goto yy110;
yy121:
		yych = *++YYCURSOR;
		if(yych == '/') goto yy122;
		if(yych == '>') goto yy110;
		goto yy124;
yy122:
		yych = *++YYCURSOR;
		if(yych == '>') goto yy110;
		goto yy124;
yy123:
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
		yych = *YYCURSOR;
yy124:
		if(yybm[0+yych] & 64) {
			goto yy123;
		}
		if(yych != '>') goto yy110;
		yych = *++YYCURSOR;
		if(yych != '>') goto yy110;
		++YYCURSOR;
#line 673 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("escaped html tag")
		DOCB_RET(DOCB_ESCAPEDHTML,NORMAL);
		}
#line 1458 "ext/docblock/docblock_scan.c"
yy128:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy129;
		if(yych != 'd') goto yy110;
yy129:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy130;
		if(yych != 'e') goto yy110;
yy130:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy110;
		++YYCURSOR;
#line 677 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("code section begin")
		s->in_code = 1;
		DOCB_RET(DOCB_CODEOPEN,CODE);
		}
#line 1476 "ext/docblock/docblock_scan.c"
yy133:
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy134;
		if(yych != 'm') goto yy110;
yy134:
		yych = *++YYCURSOR;
		if(yych == 'P') goto yy135;
		if(yych != 'p') goto yy110;
yy135:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy110;
		++YYCURSOR;
#line 687 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("samp open")
		DOCB_RET(DOCB_SAMPOPEN,NORMAL);
		}
#line 1493 "ext/docblock/docblock_scan.c"
yy138:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy139;
		if(yych != 'd') goto yy110;
yy139:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy110;
		++YYCURSOR;
#line 691 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("kbd open")
		DOCB_RET(DOCB_KBDOPEN,NORMAL);
		}
#line 1506 "ext/docblock/docblock_scan.c"
yy142:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy143;
		if(yych != 'r') goto yy110;
yy143:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy110;
		++YYCURSOR;
#line 695 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("var open")
		DOCB_RET(DOCB_VAROPEN,NORMAL);
		}
#line 1519 "ext/docblock/docblock_scan.c"
yy146:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy149;
		if(yych == 'e') goto yy149;
		goto yy110;
yy147:
		++YYCURSOR;
#line 699 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("p open")
		DOCB_RET(DOCB_POPEN,NORMAL);
		}
#line 1531 "ext/docblock/docblock_scan.c"
yy149:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy110;
		++YYCURSOR;
#line 682 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("pre section begin")
		s->in_pre = 1;
		DOCB_RET(DOCB_PREOPEN,PRE);
		}
#line 1541 "ext/docblock/docblock_scan.c"
yy152:
		++YYCURSOR;
#line 707 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("i open")
		DOCB_RET(DOCB_IOPEN,NORMAL);
		}
#line 1548 "ext/docblock/docblock_scan.c"
yy154:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy110;
		++YYCURSOR;
#line 711 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("ol open")
		DOCB_RET(DOCB_OLOPEN,NORMAL);
		}
#line 1557 "ext/docblock/docblock_scan.c"
yy157:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy110;
		++YYCURSOR;
#line 715 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("ul open")
		DOCB_RET(DOCB_ULOPEN,NORMAL);
		}
#line 1566 "ext/docblock/docblock_scan.c"
yy160:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy110;
		++YYCURSOR;
#line 719 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("li open")
		DOCB_RET(DOCB_LIOPEN,NORMAL);
		}
#line 1575 "ext/docblock/docblock_scan.c"
yy163:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy195;
		if(yych == 'a') goto yy195;
		goto yy110;
yy164:
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy191;
		if(yych == 'b') goto yy191;
		goto yy110;
yy165:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy187;
		if(yych == 'a') goto yy187;
		goto yy110;
yy166:
		yych = *++YYCURSOR;
		if(yych == '>') goto yy185;
		goto yy110;
yy167:
		yych = *++YYCURSOR;
		if(yych == '>') goto yy183;
		goto yy110;
yy168:
		yych = *++YYCURSOR;
		if(yych == '>') goto yy181;
		goto yy110;
yy169:
		yych = *++YYCURSOR;
		if(yych == 'L') goto yy178;
		if(yych == 'l') goto yy178;
		goto yy110;
yy170:
		yych = *++YYCURSOR;
		if(yych == 'L') goto yy175;
		if(yych == 'l') goto yy175;
		goto yy110;
yy171:
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy172;
		if(yych != 'i') goto yy110;
yy172:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy110;
		++YYCURSOR;
#line 755 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("li close")
		DOCB_RET(DOCB_LICLOSE,NORMAL);
		}
#line 1625 "ext/docblock/docblock_scan.c"
yy175:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy110;
		++YYCURSOR;
#line 751 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("ul close")
		DOCB_RET(DOCB_ULCLOSE,NORMAL);
		}
#line 1634 "ext/docblock/docblock_scan.c"
yy178:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy110;
		++YYCURSOR;
#line 747 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("ol close")
		DOCB_RET(DOCB_OLCLOSE,NORMAL);
		}
#line 1643 "ext/docblock/docblock_scan.c"
yy181:
		++YYCURSOR;
#line 743 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("i close")
		DOCB_RET(DOCB_ICLOSE,NORMAL);
		}
#line 1650 "ext/docblock/docblock_scan.c"
yy183:
		++YYCURSOR;
#line 739 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("b close")
		DOCB_RET(DOCB_BCLOSE,NORMAL);
		}
#line 1657 "ext/docblock/docblock_scan.c"
yy185:
		++YYCURSOR;
#line 735 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("p close")
		DOCB_RET(DOCB_PCLOSE,NORMAL);
		}
#line 1664 "ext/docblock/docblock_scan.c"
yy187:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy188;
		if(yych != 'r') goto yy110;
yy188:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy110;
		++YYCURSOR;
#line 731 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("var close")
		DOCB_RET(DOCB_VARCLOSE,NORMAL);
		}
#line 1677 "ext/docblock/docblock_scan.c"
yy191:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy192;
		if(yych != 'd') goto yy110;
yy192:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy110;
		++YYCURSOR;
#line 727 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("kbd close")
		DOCB_RET(DOCB_KBDCLOSE,NORMAL);
		}
#line 1690 "ext/docblock/docblock_scan.c"
yy195:
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy196;
		if(yych != 'm') goto yy110;
yy196:
		yych = *++YYCURSOR;
		if(yych == 'P') goto yy197;
		if(yych != 'p') goto yy110;
yy197:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy110;
		++YYCURSOR;
#line 723 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("samp close")
		DOCB_RET(DOCB_SAMPCLOSE,NORMAL);
		}
#line 1707 "ext/docblock/docblock_scan.c"
yy200:
		++YYCURSOR;
#line 703 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("b open")
		DOCB_RET(DOCB_BOPEN,NORMAL);
		}
#line 1714 "ext/docblock/docblock_scan.c"
yy202:
		yych = *++YYCURSOR;
		if(yych <= '.') {
			if(yych != ' ') goto yy110;
		} else {
			if(yych <= '/') goto yy204;
			if(yych == '>') goto yy205;
			goto yy110;
		}
		yych = *++YYCURSOR;
		if(yych == '/') goto yy207;
		goto yy110;
yy204:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy110;
yy205:
		++YYCURSOR;
#line 759 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("br tag")
		DOCB_RET(DOCB_BR,NORMAL);
		}
#line 1736 "ext/docblock/docblock_scan.c"
yy207:
		yych = *++YYCURSOR;
		if(yych == '>') goto yy205;
		goto yy110;
yy208:
		yych = *++YYCURSOR;
		if(yych <= '_') {
			if(yych <= '@') {
				if(yych == '*') goto yy211;
				goto yy110;
			} else {
				if(yych <= 'Z') goto yy212;
				if(yych <= '^') goto yy110;
				goto yy212;
			}
		} else {
			if(yych <= '|') {
				if(yych <= '`') goto yy110;
				if(yych <= 'z') goto yy212;
				goto yy110;
			} else {
				if(yych <= '}') goto yy209;
				if(yych <= '~') goto yy110;
				goto yy212;
			}
		}
yy209:
		++YYCURSOR;
#line 664 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("escaped inline tag")
		DOCB_RET(DOCB_ESCAPEDINLINETAG,NORMAL);
		}
#line 1769 "ext/docblock/docblock_scan.c"
yy211:
		yych = *++YYCURSOR;
		if(yych == '}') goto yy209;
		goto yy110;
yy212:
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 128) {
			goto yy212;
		}
		if(yych == '.') goto yy215;
yy214:
#line 668 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("inline tag start")
		s->in_inlinetag = 1;
		DOCB_RET(DOCB_INLINETAG,INLINETAG);
		}
#line 1789 "ext/docblock/docblock_scan.c"
yy215:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= '_') {
			if(yych <= '@') goto yy110;
			if(yych <= 'Z') goto yy216;
			if(yych <= '^') goto yy110;
		} else {
			if(yych <= '`') goto yy110;
			if(yych <= 'z') goto yy216;
			if(yych <= '~') goto yy110;
		}
yy216:
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= 'Z') {
			if(yych <= '/') {
				if(yych == '.') goto yy215;
				goto yy214;
			} else {
				if(yych <= '9') goto yy216;
				if(yych <= '@') goto yy214;
				goto yy216;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy216;
				goto yy214;
			} else {
				if(yych <= 'z') goto yy216;
				if(yych <= '~') goto yy214;
				goto yy216;
			}
		}
yy218:
		++YYCURSOR;
#line 656 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("end internal")
		/* if normalcursor is set, this will be re-scanned*/
		if (!s->normalcursor) {
			s->in_internal = 0;
		}
		DOCB_RET(DOCB_ENDINTERNAL,NORMAL);
		}
#line 1837 "ext/docblock/docblock_scan.c"
yy220:
		++YYCURSOR;
#line 644 "ext/docblock/docblock_scan.re"
		{ if (s->simplelist->count) {
			if (!s->return_simplelist_end) {
				zend_llist_remove_tail(s->simplelist);
			}
			cursor = s->token; /* empty token*/
			DOCB_DB("simplelist end n1")
			DOCB_RET(DOCB_SIMPLELISTEND,POSTASTERISK);
		}
		DOCB_DB("end comment")
		DOCB_RET(DOCB_COMMENTEND,LINESTART);
		}
#line 1852 "ext/docblock/docblock_scan.c"
	}
}
#line 770 "ext/docblock/docblock_scan.re"

	} /* if (s->in_internal)*/
/*NORMAL_TEXT:*/
{
	static unsigned char yybm[] = {
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,   0,  32,  32,   0,  32,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,   0,  32,  32,  32,  32,  32, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160,  32,  32,   0,  32,  32,  32, 
		 32, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224,  32,  32,  32,  32, 160, 
		 32, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224,   0,  32,  32,  32, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
		160, 160, 160, 160, 160, 160, 160, 160, 
	};

#line 1895 "ext/docblock/docblock_scan.c"
	{
		YYCTYPE yych;
		unsigned int yyaccept = 0;
		if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 32) {
			goto yy231;
		}
		if(yych <= 0x0C) goto yy228;
		if(yych <= 0x0D) goto yy230;
		if(yych <= ';') goto yy224;
		if(yych <= '<') goto yy227;
		goto yy226;
yy224:
		++YYCURSOR;
		if((yych = *YYCURSOR) == '/') goto yy351;
yy225:
#line 900 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("normal text")
	  DOCB_BEGINT(DOCB_TEXT,NORMAL);
	}
#line 1917 "ext/docblock/docblock_scan.c"
yy226:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '@') goto yy332;
		goto yy225;
yy227:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		switch(yych){
		case '/':	goto yy235;
		case '<':	goto yy245;
		case 'B':
		case 'b':	goto yy233;
		case 'C':
		case 'c':	goto yy244;
		case 'I':
		case 'i':	goto yy239;
		case 'K':
		case 'k':	goto yy242;
		case 'L':
		case 'l':	goto yy236;
		case 'O':
		case 'o':	goto yy238;
		case 'P':
		case 'p':	goto yy240;
		case 'S':
		case 's':	goto yy243;
		case 'U':
		case 'u':	goto yy237;
		case 'V':
		case 'v':	goto yy241;
		default:	goto yy225;
		}
yy228:
		++YYCURSOR;
yy229:
#line 896 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("newline (NORMAL)")
	  DOCB_RET(DOCB_NEWLINE,LINESTART);
	}
#line 1958 "ext/docblock/docblock_scan.c"
yy230:
		yych = *++YYCURSOR;
		if(yych == 0x0A) goto yy228;
		goto yy229;
yy231:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 32) {
			goto yy231;
		}
		goto yy225;
yy233:
		yych = *++YYCURSOR;
		if(yych <= 'Q') {
			if(yych == '>') goto yy324;
		} else {
			if(yych <= 'R') goto yy326;
			if(yych == 'r') goto yy326;
		}
yy234:
		YYCURSOR = YYMARKER;
		switch(yyaccept){
		case 2:	goto yy350;
		case 1:	goto yy334;
		case 0:	goto yy225;
		}
yy235:
		yych = *++YYCURSOR;
		switch(yych){
		case 'B':
		case 'b':	goto yy291;
		case 'I':
		case 'i':	goto yy292;
		case 'K':
		case 'k':	goto yy288;
		case 'L':
		case 'l':	goto yy295;
		case 'O':
		case 'o':	goto yy293;
		case 'P':
		case 'p':	goto yy290;
		case 'S':
		case 's':	goto yy287;
		case 'U':
		case 'u':	goto yy294;
		case 'V':
		case 'v':	goto yy289;
		default:	goto yy234;
		}
yy236:
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy284;
		if(yych == 'i') goto yy284;
		goto yy234;
yy237:
		yych = *++YYCURSOR;
		if(yych == 'L') goto yy281;
		if(yych == 'l') goto yy281;
		goto yy234;
yy238:
		yych = *++YYCURSOR;
		if(yych == 'L') goto yy278;
		if(yych == 'l') goto yy278;
		goto yy234;
yy239:
		yych = *++YYCURSOR;
		if(yych == '>') goto yy276;
		goto yy234;
yy240:
		yych = *++YYCURSOR;
		if(yych <= 'Q') {
			if(yych == '>') goto yy271;
			goto yy234;
		} else {
			if(yych <= 'R') goto yy270;
			if(yych == 'r') goto yy270;
			goto yy234;
		}
yy241:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy266;
		if(yych == 'a') goto yy266;
		goto yy234;
yy242:
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy262;
		if(yych == 'b') goto yy262;
		goto yy234;
yy243:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy257;
		if(yych == 'a') goto yy257;
		goto yy234;
yy244:
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy252;
		if(yych == 'o') goto yy252;
		goto yy234;
yy245:
		yych = *++YYCURSOR;
		if(yych == '/') goto yy246;
		if(yych == '>') goto yy234;
		goto yy248;
yy246:
		yych = *++YYCURSOR;
		if(yych == '>') goto yy234;
		goto yy248;
yy247:
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
		yych = *YYCURSOR;
yy248:
		if(yybm[0+yych] & 64) {
			goto yy247;
		}
		if(yych != '>') goto yy234;
		yych = *++YYCURSOR;
		if(yych != '>') goto yy234;
		++YYCURSOR;
#line 802 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("escaped html tag")
	  DOCB_RET(DOCB_ESCAPEDHTML,NORMAL);
	}
#line 2083 "ext/docblock/docblock_scan.c"
yy252:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy253;
		if(yych != 'd') goto yy234;
yy253:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy254;
		if(yych != 'e') goto yy234;
yy254:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy234;
		++YYCURSOR;
#line 806 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("code section begin")
	  if (!s->normalcursor) {
	  	s->in_code = 1;
	  }
	  DOCB_RET(DOCB_CODEOPEN,CODE);
	}
#line 2103 "ext/docblock/docblock_scan.c"
yy257:
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy258;
		if(yych != 'm') goto yy234;
yy258:
		yych = *++YYCURSOR;
		if(yych == 'P') goto yy259;
		if(yych != 'p') goto yy234;
yy259:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy234;
		++YYCURSOR;
#line 820 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("samp open")
	  DOCB_RET(DOCB_SAMPOPEN,NORMAL);
	}
#line 2120 "ext/docblock/docblock_scan.c"
yy262:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy263;
		if(yych != 'd') goto yy234;
yy263:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy234;
		++YYCURSOR;
#line 824 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("kbd open")
	  DOCB_RET(DOCB_KBDOPEN,NORMAL);
	}
#line 2133 "ext/docblock/docblock_scan.c"
yy266:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy267;
		if(yych != 'r') goto yy234;
yy267:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy234;
		++YYCURSOR;
#line 828 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("var open")
	  DOCB_RET(DOCB_VAROPEN,NORMAL);
	}
#line 2146 "ext/docblock/docblock_scan.c"
yy270:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy273;
		if(yych == 'e') goto yy273;
		goto yy234;
yy271:
		++YYCURSOR;
#line 832 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("p open")
	  DOCB_RET(DOCB_POPEN,NORMAL);
	}
#line 2158 "ext/docblock/docblock_scan.c"
yy273:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy234;
		++YYCURSOR;
#line 813 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("pre section begin")
	  if (!s->normalcursor) {
	  	s->in_pre = 1;
	  }
	  DOCB_RET(DOCB_PREOPEN,PRE);
	}
#line 2170 "ext/docblock/docblock_scan.c"
yy276:
		++YYCURSOR;
#line 840 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("i open")
	  DOCB_RET(DOCB_IOPEN,NORMAL);
	}
#line 2177 "ext/docblock/docblock_scan.c"
yy278:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy234;
		++YYCURSOR;
#line 844 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("ol open")
	  DOCB_RET(DOCB_OLOPEN,NORMAL);
	}
#line 2186 "ext/docblock/docblock_scan.c"
yy281:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy234;
		++YYCURSOR;
#line 848 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("ul open")
	  DOCB_RET(DOCB_ULOPEN,NORMAL);
	}
#line 2195 "ext/docblock/docblock_scan.c"
yy284:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy234;
		++YYCURSOR;
#line 852 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("li open")
	  DOCB_RET(DOCB_LIOPEN,NORMAL);
	}
#line 2204 "ext/docblock/docblock_scan.c"
yy287:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy319;
		if(yych == 'a') goto yy319;
		goto yy234;
yy288:
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy315;
		if(yych == 'b') goto yy315;
		goto yy234;
yy289:
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy311;
		if(yych == 'a') goto yy311;
		goto yy234;
yy290:
		yych = *++YYCURSOR;
		if(yych == '>') goto yy309;
		goto yy234;
yy291:
		yych = *++YYCURSOR;
		if(yych == '>') goto yy307;
		goto yy234;
yy292:
		yych = *++YYCURSOR;
		if(yych == '>') goto yy305;
		goto yy234;
yy293:
		yych = *++YYCURSOR;
		if(yych == 'L') goto yy302;
		if(yych == 'l') goto yy302;
		goto yy234;
yy294:
		yych = *++YYCURSOR;
		if(yych == 'L') goto yy299;
		if(yych == 'l') goto yy299;
		goto yy234;
yy295:
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy296;
		if(yych != 'i') goto yy234;
yy296:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy234;
		++YYCURSOR;
#line 888 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("li close")
	  DOCB_RET(DOCB_LICLOSE,NORMAL);
	}
#line 2254 "ext/docblock/docblock_scan.c"
yy299:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy234;
		++YYCURSOR;
#line 884 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("ul close")
	  DOCB_RET(DOCB_ULCLOSE,NORMAL);
	}
#line 2263 "ext/docblock/docblock_scan.c"
yy302:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy234;
		++YYCURSOR;
#line 880 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("ol close")
	  DOCB_RET(DOCB_OLCLOSE,NORMAL);
	}
#line 2272 "ext/docblock/docblock_scan.c"
yy305:
		++YYCURSOR;
#line 876 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("i close")
	  DOCB_RET(DOCB_ICLOSE,NORMAL);
	}
#line 2279 "ext/docblock/docblock_scan.c"
yy307:
		++YYCURSOR;
#line 872 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("b close")
	  DOCB_RET(DOCB_BCLOSE,NORMAL);
	}
#line 2286 "ext/docblock/docblock_scan.c"
yy309:
		++YYCURSOR;
#line 868 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("p close")
	  DOCB_RET(DOCB_PCLOSE,NORMAL);
	}
#line 2293 "ext/docblock/docblock_scan.c"
yy311:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy312;
		if(yych != 'r') goto yy234;
yy312:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy234;
		++YYCURSOR;
#line 864 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("var close")
	  DOCB_RET(DOCB_VARCLOSE,NORMAL);
	}
#line 2306 "ext/docblock/docblock_scan.c"
yy315:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy316;
		if(yych != 'd') goto yy234;
yy316:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy234;
		++YYCURSOR;
#line 860 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("kbd close")
	  DOCB_RET(DOCB_KBDCLOSE,NORMAL);
	}
#line 2319 "ext/docblock/docblock_scan.c"
yy319:
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy320;
		if(yych != 'm') goto yy234;
yy320:
		yych = *++YYCURSOR;
		if(yych == 'P') goto yy321;
		if(yych != 'p') goto yy234;
yy321:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy234;
		++YYCURSOR;
#line 856 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("samp close")
	  DOCB_RET(DOCB_SAMPCLOSE,NORMAL);
	}
#line 2336 "ext/docblock/docblock_scan.c"
yy324:
		++YYCURSOR;
#line 836 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("b open")
	  DOCB_RET(DOCB_BOPEN,NORMAL);
	}
#line 2343 "ext/docblock/docblock_scan.c"
yy326:
		yych = *++YYCURSOR;
		if(yych <= '.') {
			if(yych != ' ') goto yy234;
		} else {
			if(yych <= '/') goto yy328;
			if(yych == '>') goto yy329;
			goto yy234;
		}
		yych = *++YYCURSOR;
		if(yych == '/') goto yy331;
		goto yy234;
yy328:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy234;
yy329:
		++YYCURSOR;
#line 892 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("br tag")
	  DOCB_RET(DOCB_BR,NORMAL);
	}
#line 2365 "ext/docblock/docblock_scan.c"
yy331:
		yych = *++YYCURSOR;
		if(yych == '>') goto yy329;
		goto yy234;
yy332:
		yych = *++YYCURSOR;
		if(yych <= '`') {
			if(yych <= '@') {
				if(yych == '*') goto yy337;
				goto yy234;
			} else {
				if(yych <= 'Z') goto yy338;
				if(yych == '_') goto yy338;
				goto yy234;
			}
		} else {
			if(yych <= 'z') {
				if(yych != 'i') goto yy338;
			} else {
				if(yych == '}') goto yy335;
				if(yych <= '~') goto yy234;
				goto yy338;
			}
		}
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'n') goto yy343;
		goto yy339;
yy334:
#line 797 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("inline tag start")
	  s->in_inlinetag = 1;
	  DOCB_RET(DOCB_INLINETAG,INLINETAG);
	}
#line 2400 "ext/docblock/docblock_scan.c"
yy335:
		++YYCURSOR;
#line 793 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("escaped inline tag")
	  DOCB_RET(DOCB_ESCAPEDINLINETAG,NORMAL);
	}
#line 2407 "ext/docblock/docblock_scan.c"
yy337:
		yych = *++YYCURSOR;
		if(yych == '}') goto yy335;
		goto yy234;
yy338:
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
yy339:
		if(yybm[0+yych] & 128) {
			goto yy338;
		}
		if(yych != '.') goto yy334;
yy340:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= '_') {
			if(yych <= '@') goto yy234;
			if(yych <= 'Z') goto yy341;
			if(yych <= '^') goto yy234;
		} else {
			if(yych <= '`') goto yy234;
			if(yych <= 'z') goto yy341;
			if(yych <= '~') goto yy234;
		}
yy341:
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= 'Z') {
			if(yych <= '/') {
				if(yych == '.') goto yy340;
				goto yy334;
			} else {
				if(yych <= '9') goto yy341;
				if(yych <= '@') goto yy334;
				goto yy341;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy341;
				goto yy334;
			} else {
				if(yych <= 'z') goto yy341;
				if(yych <= '~') goto yy334;
				goto yy341;
			}
		}
yy343:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != 't') goto yy339;
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != 'e') goto yy339;
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != 'r') goto yy339;
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != 'n') goto yy339;
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != 'a') goto yy339;
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != 'l') goto yy339;
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yybm[0+yych] & 128) {
			goto yy338;
		}
		if(yych == '.') goto yy340;
yy350:
#line 786 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("internal start")
	  if (!s->normalcursor) {
	  	s->in_internal = 1;
	  }
	  DOCB_RET(DOCB_INTERNAL,NORMAL);
	}
#line 2492 "ext/docblock/docblock_scan.c"
yy351:
		++YYCURSOR;
#line 774 "ext/docblock/docblock_scan.re"
		{ if (s->simplelist->count) {
		if (!s->return_simplelist_end) {
			zend_llist_remove_tail(s->simplelist);
		}
		cursor = s->token; /* empty token*/
		DOCB_DB("simplelist end n2")
		DOCB_RET(DOCB_SIMPLELISTEND,POSTASTERISK);
	  }
	  DOCB_DB("end comment")
	  DOCB_RET(DOCB_COMMENTEND,LINESTART);
	}
#line 2507 "ext/docblock/docblock_scan.c"
	}
}
#line 903 "ext/docblock/docblock_scan.re"

INLINETAG:
{
	static unsigned char yybm[] = {
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128,   0, 128, 128,   0, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128,   0, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128,   0, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
	};

#line 2549 "ext/docblock/docblock_scan.c"
	{
		YYCTYPE yych;
		if((YYLIMIT - YYCURSOR) < 3) YYFILL(3);
		yych = *YYCURSOR;
		if(yych <= ')') {
			if(yych <= 0x0A) {
				if(yych <= 0x09) goto yy360;
				goto yy363;
			} else {
				if(yych == 0x0D) goto yy362;
				goto yy360;
			}
		} else {
			if(yych <= '\\') {
				if(yych <= '*') goto yy355;
				if(yych <= '[') goto yy360;
				goto yy357;
			} else {
				if(yych == '}') goto yy358;
				goto yy360;
			}
		}
yy355:
		++YYCURSOR;
		if((yych = *YYCURSOR) == '/') goto yy367;
		goto yy361;
yy356:
#line 920 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("inline tag contents")
	  DOCB_BEGINT(DOCB_INLINETAGCONTENTS,INLINETAG);
	}
#line 2581 "ext/docblock/docblock_scan.c"
yy357:
		yych = *++YYCURSOR;
		if(yych == '}') goto yy365;
		goto yy356;
yy358:
		++YYCURSOR;
#line 912 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("end inline tag")
	  /* if normalcursor is set, this will be re-scanned*/
	  if (!s->normalcursor) {
		s->in_inlinetag = 0;
	  }
	  DOCB_RET(DOCB_ENDINLINETAG,NORMAL);
	}
#line 2596 "ext/docblock/docblock_scan.c"
yy360:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
yy361:
		if(yybm[0+yych] & 128) {
			goto yy360;
		}
		goto yy356;
yy362:
		yych = *++YYCURSOR;
		if(yych != 0x0A) goto yy356;
yy363:
		++YYCURSOR;
#line 924 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("newline (INLINETAG)")
	  DOCB_RET(DOCB_NEWLINE,LINESTART);
	}
#line 2615 "ext/docblock/docblock_scan.c"
yy365:
		++YYCURSOR;
#line 909 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("escaped end inline tag")
	  DOCB_RET(DOCB_ESCAPEDINLINEEND,INLINETAG);
	}
#line 2622 "ext/docblock/docblock_scan.c"
yy367:
		++YYCURSOR;
		if(yybm[0+(yych = *YYCURSOR)] & 128) {
			goto yy360;
		}
#line 906 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("end comment")
	  DOCB_RET(DOCB_COMMENTEND,LINESTART);
	}
#line 2632 "ext/docblock/docblock_scan.c"
	}
}
#line 927 "ext/docblock/docblock_scan.re"

CODE:
if (s->in_internal) {
	{
	static unsigned char yybm[] = {
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,   0,  64,  64,   0,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,   0,  64,  64,  64,  64,  64, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192,  64,  64,   0,  64,  64,  64, 
		 64, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192,  64,  64,  64,  64, 192, 
		 64, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192,   0,  64,   0,  64, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
	};

#line 2675 "ext/docblock/docblock_scan.c"
	{
		YYCTYPE yych;
		unsigned int yyaccept = 0;
		if((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 64) {
			goto yy379;
		}
		if(yych <= ';') {
			if(yych <= 0x0C) goto yy374;
			if(yych <= 0x0D) goto yy376;
		} else {
			if(yych <= '<') goto yy373;
			if(yych <= '|') goto yy378;
			goto yy377;
		}
		++YYCURSOR;
		if((yych = *YYCURSOR) == '/') goto yy410;
yy372:
#line 970 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("normal text")
		DOCB_BEGINT(DOCB_TEXT,CODE);
		}
#line 2699 "ext/docblock/docblock_scan.c"
yy373:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '/') goto yy395;
		if(yych == '<') goto yy394;
		goto yy372;
yy374:
		++YYCURSOR;
yy375:
#line 943 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("newline (CODE)")
		DOCB_RET(DOCB_NEWLINE,LINESTART);
		}
#line 2713 "ext/docblock/docblock_scan.c"
yy376:
		yych = *++YYCURSOR;
		if(yych == 0x0A) goto yy374;
		goto yy375;
yy377:
		yych = *++YYCURSOR;
		if(yych == '}') goto yy392;
		goto yy372;
yy378:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '@') goto yy381;
		goto yy372;
yy379:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 64) {
			goto yy379;
		}
		goto yy372;
yy381:
		yych = *++YYCURSOR;
		if(yych <= '_') {
			if(yych <= '@') {
				if(yych == '*') goto yy385;
			} else {
				if(yych <= 'Z') goto yy386;
				if(yych >= '_') goto yy386;
			}
		} else {
			if(yych <= '|') {
				if(yych <= '`') goto yy382;
				if(yych <= 'z') goto yy386;
			} else {
				if(yych <= '}') goto yy383;
				if(yych >= 0x7F) goto yy386;
			}
		}
yy382:
		YYCURSOR = YYMARKER;
		switch(yyaccept){
		case 1:	goto yy388;
		case 0:	goto yy372;
		}
yy383:
		++YYCURSOR;
#line 955 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("escaped inline tag")
		DOCB_RET(DOCB_ESCAPEDINLINETAG,CODE);
		}
#line 2765 "ext/docblock/docblock_scan.c"
yy385:
		yych = *++YYCURSOR;
		if(yych == '}') goto yy383;
		goto yy382;
yy386:
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 128) {
			goto yy386;
		}
		if(yych == '.') goto yy389;
yy388:
#line 959 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("inline tag start")
		if (!s->normalcursor) {
			s->in_inlinetag = 1;
		}
		DOCB_RET(DOCB_INLINETAG,INLINETAG);
		}
#line 2787 "ext/docblock/docblock_scan.c"
yy389:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= '_') {
			if(yych <= '@') goto yy382;
			if(yych <= 'Z') goto yy390;
			if(yych <= '^') goto yy382;
		} else {
			if(yych <= '`') goto yy382;
			if(yych <= 'z') goto yy390;
			if(yych <= '~') goto yy382;
		}
yy390:
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= 'Z') {
			if(yych <= '/') {
				if(yych == '.') goto yy389;
				goto yy388;
			} else {
				if(yych <= '9') goto yy390;
				if(yych <= '@') goto yy388;
				goto yy390;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy390;
				goto yy388;
			} else {
				if(yych <= 'z') goto yy390;
				if(yych <= '~') goto yy388;
				goto yy390;
			}
		}
yy392:
		++YYCURSOR;
#line 947 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("end internal")
		/* if normalcursor is set, this will be re-scanned*/
		if (!s->normalcursor) {
			s->in_internal = 0;
		}
		DOCB_RET(DOCB_ENDINTERNAL,CODE);
		}
#line 2835 "ext/docblock/docblock_scan.c"
yy394:
		yych = *++YYCURSOR;
		if(yych == '/') goto yy402;
		goto yy382;
yy395:
		yych = *++YYCURSOR;
		if(yych != 'c') goto yy382;
		yych = *++YYCURSOR;
		if(yych != 'o') goto yy382;
		yych = *++YYCURSOR;
		if(yych != 'd') goto yy382;
		yych = *++YYCURSOR;
		if(yych != 'e') goto yy382;
		yych = *++YYCURSOR;
		if(yych != '>') goto yy382;
		++YYCURSOR;
#line 935 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("close code")
		/* if normalcursor is set, this will be re-scanned*/
		if (!s->normalcursor) {
			s->in_code = 0;
		}
		DOCB_RET(DOCB_CODECLOSE,NORMAL);
		}
#line 2860 "ext/docblock/docblock_scan.c"
yy402:
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy403;
		if(yych != 'c') goto yy382;
yy403:
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy404;
		if(yych != 'o') goto yy382;
yy404:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy405;
		if(yych != 'd') goto yy382;
yy405:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy406;
		if(yych != 'e') goto yy382;
yy406:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy382;
		yych = *++YYCURSOR;
		if(yych != '>') goto yy382;
		++YYCURSOR;
#line 966 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("escaped html tag")
		DOCB_RET(DOCB_ESCAPEDHTML,CODE);
		}
#line 2887 "ext/docblock/docblock_scan.c"
yy410:
		++YYCURSOR;
#line 931 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("end comment")
		DOCB_RET(DOCB_COMMENTEND,LINESTART);
		}
#line 2894 "ext/docblock/docblock_scan.c"
	}
}
#line 973 "ext/docblock/docblock_scan.re"

} /* if (s->in_internal) */
/* CODE: */
{
	static unsigned char yybm[] = {
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,   0,  64,  64,   0,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,   0,  64,  64,  64,  64,  64, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192,  64,  64,   0,  64,  64,  64, 
		 64, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192,  64,  64,  64,  64, 192, 
		 64, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192,   0,  64,  64,  64, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
	};

#line 2937 "ext/docblock/docblock_scan.c"
	{
		YYCTYPE yych;
		unsigned int yyaccept = 0;
		if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 64) {
			goto yy421;
		}
		if(yych <= 0x0C) goto yy417;
		if(yych <= 0x0D) goto yy419;
		if(yych <= ';') goto yy414;
		if(yych <= '<') goto yy416;
		goto yy420;
yy414:
		++YYCURSOR;
		if((yych = *YYCURSOR) == '/') goto yy459;
yy415:
#line 1015 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("normal text")
	  DOCB_BEGINT(DOCB_TEXT,CODE);
	}
#line 2959 "ext/docblock/docblock_scan.c"
yy416:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '/') goto yy444;
		if(yych == '<') goto yy443;
		goto yy415;
yy417:
		++YYCURSOR;
yy418:
#line 989 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("newline (CODE)")
	  DOCB_RET(DOCB_NEWLINE,LINESTART);
	}
#line 2973 "ext/docblock/docblock_scan.c"
yy419:
		yych = *++YYCURSOR;
		if(yych == 0x0A) goto yy417;
		goto yy418;
yy420:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '@') goto yy423;
		goto yy415;
yy421:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 64) {
			goto yy421;
		}
		goto yy415;
yy423:
		yych = *++YYCURSOR;
		if(yych <= '`') {
			if(yych <= '@') {
				if(yych == '*') goto yy429;
			} else {
				if(yych <= 'Z') goto yy430;
				if(yych == '_') goto yy430;
			}
		} else {
			if(yych <= 'z') {
				if(yych == 'i') goto yy425;
				goto yy430;
			} else {
				if(yych == '}') goto yy427;
				if(yych >= 0x7F) goto yy430;
			}
		}
yy424:
		YYCURSOR = YYMARKER;
		switch(yyaccept){
		case 2:	goto yy442;
		case 1:	goto yy426;
		case 0:	goto yy415;
		}
yy425:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'n') goto yy435;
		goto yy431;
yy426:
#line 1004 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("inline tag start")
	  if (!s->normalcursor) {
	  	s->in_inlinetag = 1;
	  }
	  DOCB_RET(DOCB_INLINETAG,INLINETAG);
	}
#line 3029 "ext/docblock/docblock_scan.c"
yy427:
		++YYCURSOR;
#line 1000 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("escaped inline tag")
	  DOCB_RET(DOCB_ESCAPEDINLINETAG,CODE);
	}
#line 3036 "ext/docblock/docblock_scan.c"
yy429:
		yych = *++YYCURSOR;
		if(yych == '}') goto yy427;
		goto yy424;
yy430:
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
yy431:
		if(yybm[0+yych] & 128) {
			goto yy430;
		}
		if(yych != '.') goto yy426;
yy432:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= '_') {
			if(yych <= '@') goto yy424;
			if(yych <= 'Z') goto yy433;
			if(yych <= '^') goto yy424;
		} else {
			if(yych <= '`') goto yy424;
			if(yych <= 'z') goto yy433;
			if(yych <= '~') goto yy424;
		}
yy433:
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= 'Z') {
			if(yych <= '/') {
				if(yych == '.') goto yy432;
				goto yy426;
			} else {
				if(yych <= '9') goto yy433;
				if(yych <= '@') goto yy426;
				goto yy433;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy433;
				goto yy426;
			} else {
				if(yych <= 'z') goto yy433;
				if(yych <= '~') goto yy426;
				goto yy433;
			}
		}
yy435:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != 't') goto yy431;
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != 'e') goto yy431;
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != 'r') goto yy431;
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != 'n') goto yy431;
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != 'a') goto yy431;
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != 'l') goto yy431;
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yybm[0+yych] & 128) {
			goto yy430;
		}
		if(yych == '.') goto yy432;
yy442:
#line 993 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("internal start")
	  if (!s->normalcursor) {
	  	s->in_internal = 1;
	  }
	  DOCB_RET(DOCB_INTERNAL,CODE);
	}
#line 3121 "ext/docblock/docblock_scan.c"
yy443:
		yych = *++YYCURSOR;
		if(yych == '/') goto yy451;
		goto yy424;
yy444:
		yych = *++YYCURSOR;
		if(yych != 'c') goto yy424;
		yych = *++YYCURSOR;
		if(yych != 'o') goto yy424;
		yych = *++YYCURSOR;
		if(yych != 'd') goto yy424;
		yych = *++YYCURSOR;
		if(yych != 'e') goto yy424;
		yych = *++YYCURSOR;
		if(yych != '>') goto yy424;
		++YYCURSOR;
#line 981 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("close code")
	  /* if normalcursor is set, this will be re-scanned*/
	  if (!s->normalcursor) {
	  	s->in_code = 0;
	  }
	  DOCB_RET(DOCB_CODECLOSE,NORMAL);
	}
#line 3146 "ext/docblock/docblock_scan.c"
yy451:
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy452;
		if(yych != 'c') goto yy424;
yy452:
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy453;
		if(yych != 'o') goto yy424;
yy453:
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy454;
		if(yych != 'd') goto yy424;
yy454:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy455;
		if(yych != 'e') goto yy424;
yy455:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy424;
		yych = *++YYCURSOR;
		if(yych != '>') goto yy424;
		++YYCURSOR;
#line 1011 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("escaped html tag")
	  DOCB_RET(DOCB_ESCAPEDHTML,CODE);
	}
#line 3173 "ext/docblock/docblock_scan.c"
yy459:
		++YYCURSOR;
#line 977 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("end comment")
	  DOCB_RET(DOCB_COMMENTEND,LINESTART);
	}
#line 3180 "ext/docblock/docblock_scan.c"
	}
}
#line 1018 "ext/docblock/docblock_scan.re"


PRE:

if (s->in_internal) {
{
	static unsigned char yybm[] = {
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,   0,  64,  64,   0,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,   0,  64,  64,  64,  64,  64, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192,  64,  64,   0,  64,  64,  64, 
		 64, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192,  64,  64,  64,  64, 192, 
		 64, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192,   0,  64,   0,  64, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
	};

#line 3225 "ext/docblock/docblock_scan.c"
	{
		YYCTYPE yych;
		unsigned int yyaccept = 0;
		if((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 64) {
			goto yy471;
		}
		if(yych <= ';') {
			if(yych <= 0x0C) goto yy466;
			if(yych <= 0x0D) goto yy468;
		} else {
			if(yych <= '<') goto yy465;
			if(yych <= '|') goto yy470;
			goto yy469;
		}
		++YYCURSOR;
		if((yych = *YYCURSOR) == '/') goto yy500;
yy464:
#line 1063 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("normal text")
		DOCB_BEGINT(DOCB_TEXT,PRE);
		}
#line 3249 "ext/docblock/docblock_scan.c"
yy465:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '/') goto yy487;
		if(yych == '<') goto yy486;
		goto yy464;
yy466:
		++YYCURSOR;
yy467:
#line 1036 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("newline (PRE)")
		DOCB_RET(DOCB_NEWLINE,LINESTART);
		}
#line 3263 "ext/docblock/docblock_scan.c"
yy468:
		yych = *++YYCURSOR;
		if(yych == 0x0A) goto yy466;
		goto yy467;
yy469:
		yych = *++YYCURSOR;
		if(yych == '}') goto yy484;
		goto yy464;
yy470:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '@') goto yy473;
		goto yy464;
yy471:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 64) {
			goto yy471;
		}
		goto yy464;
yy473:
		yych = *++YYCURSOR;
		if(yych <= '_') {
			if(yych <= '@') {
				if(yych == '*') goto yy477;
			} else {
				if(yych <= 'Z') goto yy478;
				if(yych >= '_') goto yy478;
			}
		} else {
			if(yych <= '|') {
				if(yych <= '`') goto yy474;
				if(yych <= 'z') goto yy478;
			} else {
				if(yych <= '}') goto yy475;
				if(yych >= 0x7F) goto yy478;
			}
		}
yy474:
		YYCURSOR = YYMARKER;
		switch(yyaccept){
		case 1:	goto yy480;
		case 0:	goto yy464;
		}
yy475:
		++YYCURSOR;
#line 1048 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("escaped inline tag")
		DOCB_RET(DOCB_ESCAPEDINLINETAG,PRE);
		}
#line 3315 "ext/docblock/docblock_scan.c"
yy477:
		yych = *++YYCURSOR;
		if(yych == '}') goto yy475;
		goto yy474;
yy478:
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 128) {
			goto yy478;
		}
		if(yych == '.') goto yy481;
yy480:
#line 1052 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("inline tag start")
		if (!s->normalcursor) {
			s->in_inlinetag = 1;
		}
		DOCB_RET(DOCB_INLINETAG,INLINETAG);
		}
#line 3337 "ext/docblock/docblock_scan.c"
yy481:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= '_') {
			if(yych <= '@') goto yy474;
			if(yych <= 'Z') goto yy482;
			if(yych <= '^') goto yy474;
		} else {
			if(yych <= '`') goto yy474;
			if(yych <= 'z') goto yy482;
			if(yych <= '~') goto yy474;
		}
yy482:
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= 'Z') {
			if(yych <= '/') {
				if(yych == '.') goto yy481;
				goto yy480;
			} else {
				if(yych <= '9') goto yy482;
				if(yych <= '@') goto yy480;
				goto yy482;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy482;
				goto yy480;
			} else {
				if(yych <= 'z') goto yy482;
				if(yych <= '~') goto yy480;
				goto yy482;
			}
		}
yy484:
		++YYCURSOR;
#line 1040 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("end internal")
		/* if normalcursor is set, this will be re-scanned*/
		if (!s->normalcursor) {
			s->in_internal = 0;
		}
		DOCB_RET(DOCB_ENDINTERNAL,PRE);
		}
#line 3385 "ext/docblock/docblock_scan.c"
yy486:
		yych = *++YYCURSOR;
		if(yych == '/') goto yy493;
		goto yy474;
yy487:
		yych = *++YYCURSOR;
		if(yych != 'p') goto yy474;
		yych = *++YYCURSOR;
		if(yych != 'r') goto yy474;
		yych = *++YYCURSOR;
		if(yych != 'e') goto yy474;
		yych = *++YYCURSOR;
		if(yych != '>') goto yy474;
		++YYCURSOR;
#line 1028 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("close pre")
		/* if normalcursor is set, this will be re-scanned*/
		if (!s->normalcursor) {
			s->in_pre = 0;
		}
		DOCB_RET(DOCB_PRECLOSE,NORMAL);
		}
#line 3408 "ext/docblock/docblock_scan.c"
yy493:
		yych = *++YYCURSOR;
		if(yych == 'P') goto yy494;
		if(yych != 'p') goto yy474;
yy494:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy495;
		if(yych != 'r') goto yy474;
yy495:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy496;
		if(yych != 'e') goto yy474;
yy496:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy474;
		yych = *++YYCURSOR;
		if(yych != '>') goto yy474;
		++YYCURSOR;
#line 1059 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("escaped html tag")
		DOCB_RET(DOCB_ESCAPEDHTML,PRE);
		}
#line 3431 "ext/docblock/docblock_scan.c"
yy500:
		++YYCURSOR;
#line 1024 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("end comment")
		DOCB_RET(DOCB_COMMENTEND,LINESTART);
		}
#line 3438 "ext/docblock/docblock_scan.c"
	}
}
#line 1066 "ext/docblock/docblock_scan.re"

} /* if (s->in_internal) */
/* PRE */
{
	static unsigned char yybm[] = {
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,   0,  64,  64,   0,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,   0,  64,  64,  64,  64,  64, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192,  64,  64,   0,  64,  64,  64, 
		 64, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192,  64,  64,  64,  64, 192, 
		 64, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192,   0,  64,  64,  64, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
	};

#line 3481 "ext/docblock/docblock_scan.c"
	{
		YYCTYPE yych;
		unsigned int yyaccept = 0;
		if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 64) {
			goto yy511;
		}
		if(yych <= 0x0C) goto yy507;
		if(yych <= 0x0D) goto yy509;
		if(yych <= ';') goto yy504;
		if(yych <= '<') goto yy506;
		goto yy510;
yy504:
		++YYCURSOR;
		if((yych = *YYCURSOR) == '/') goto yy547;
yy505:
#line 1108 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("normal text")
	  DOCB_BEGINT(DOCB_TEXT,PRE);
	}
#line 3503 "ext/docblock/docblock_scan.c"
yy506:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '/') goto yy534;
		if(yych == '<') goto yy533;
		goto yy505;
yy507:
		++YYCURSOR;
yy508:
#line 1082 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("newline (PRE)")
	  DOCB_RET(DOCB_NEWLINE,LINESTART);
	}
#line 3517 "ext/docblock/docblock_scan.c"
yy509:
		yych = *++YYCURSOR;
		if(yych == 0x0A) goto yy507;
		goto yy508;
yy510:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '@') goto yy513;
		goto yy505;
yy511:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 64) {
			goto yy511;
		}
		goto yy505;
yy513:
		yych = *++YYCURSOR;
		if(yych <= '`') {
			if(yych <= '@') {
				if(yych == '*') goto yy519;
			} else {
				if(yych <= 'Z') goto yy520;
				if(yych == '_') goto yy520;
			}
		} else {
			if(yych <= 'z') {
				if(yych == 'i') goto yy515;
				goto yy520;
			} else {
				if(yych == '}') goto yy517;
				if(yych >= 0x7F) goto yy520;
			}
		}
yy514:
		YYCURSOR = YYMARKER;
		switch(yyaccept){
		case 2:	goto yy532;
		case 1:	goto yy516;
		case 0:	goto yy505;
		}
yy515:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'n') goto yy525;
		goto yy521;
yy516:
#line 1097 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("inline tag start")
	  if (!s->normalcursor) {
	  	s->in_inlinetag = 1;
	  }
	  DOCB_RET(DOCB_INLINETAG,INLINETAG);
	}
#line 3573 "ext/docblock/docblock_scan.c"
yy517:
		++YYCURSOR;
#line 1093 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("escaped inline tag")
	  DOCB_RET(DOCB_ESCAPEDINLINETAG,PRE);
	}
#line 3580 "ext/docblock/docblock_scan.c"
yy519:
		yych = *++YYCURSOR;
		if(yych == '}') goto yy517;
		goto yy514;
yy520:
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
yy521:
		if(yybm[0+yych] & 128) {
			goto yy520;
		}
		if(yych != '.') goto yy516;
yy522:
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= '_') {
			if(yych <= '@') goto yy514;
			if(yych <= 'Z') goto yy523;
			if(yych <= '^') goto yy514;
		} else {
			if(yych <= '`') goto yy514;
			if(yych <= 'z') goto yy523;
			if(yych <= '~') goto yy514;
		}
yy523:
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= 'Z') {
			if(yych <= '/') {
				if(yych == '.') goto yy522;
				goto yy516;
			} else {
				if(yych <= '9') goto yy523;
				if(yych <= '@') goto yy516;
				goto yy523;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy523;
				goto yy516;
			} else {
				if(yych <= 'z') goto yy523;
				if(yych <= '~') goto yy516;
				goto yy523;
			}
		}
yy525:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != 't') goto yy521;
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != 'e') goto yy521;
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != 'r') goto yy521;
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != 'n') goto yy521;
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != 'a') goto yy521;
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != 'l') goto yy521;
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yybm[0+yych] & 128) {
			goto yy520;
		}
		if(yych == '.') goto yy522;
yy532:
#line 1086 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("internal start")
	  if (!s->normalcursor) {
	  	s->in_internal = 1;
	  }
	  DOCB_RET(DOCB_INTERNAL,PRE);
	}
#line 3665 "ext/docblock/docblock_scan.c"
yy533:
		yych = *++YYCURSOR;
		if(yych == '/') goto yy540;
		goto yy514;
yy534:
		yych = *++YYCURSOR;
		if(yych != 'p') goto yy514;
		yych = *++YYCURSOR;
		if(yych != 'r') goto yy514;
		yych = *++YYCURSOR;
		if(yych != 'e') goto yy514;
		yych = *++YYCURSOR;
		if(yych != '>') goto yy514;
		++YYCURSOR;
#line 1074 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("close pre")
	  /* if normalcursor is set, this will be re-scanned*/
	  if (!s->normalcursor) {
		s->in_pre = 0;
	  }
	  DOCB_RET(DOCB_PRECLOSE,NORMAL);
	}
#line 3688 "ext/docblock/docblock_scan.c"
yy540:
		yych = *++YYCURSOR;
		if(yych == 'P') goto yy541;
		if(yych != 'p') goto yy514;
yy541:
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy542;
		if(yych != 'r') goto yy514;
yy542:
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy543;
		if(yych != 'e') goto yy514;
yy543:
		yych = *++YYCURSOR;
		if(yych != '>') goto yy514;
		yych = *++YYCURSOR;
		if(yych != '>') goto yy514;
		++YYCURSOR;
#line 1104 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("escaped html tag")
	  DOCB_RET(DOCB_ESCAPEDHTML,PRE);
	}
#line 3711 "ext/docblock/docblock_scan.c"
yy547:
		++YYCURSOR;
#line 1070 "ext/docblock/docblock_scan.re"
		{ DOCB_DB("end comment")
	  DOCB_RET(DOCB_COMMENTEND,LINESTART);
	}
#line 3718 "ext/docblock/docblock_scan.c"
	}
}
#line 1111 "ext/docblock/docblock_scan.re"


	return 0;
}
