# PySAL 23.07 2023-07-31
Overall, there were 179 commits that closed 107 issues, together with 16 pull requests since our last release on 2023-02-01.


## Changes by Package

### giddy
* [#187:](https://github.com/pysal/giddy/pull/187) small edits to long description 
* [#186:](https://github.com/pysal/giddy/pull/186) update github action for release 
* [#185:](https://github.com/pysal/giddy/issues/185) Update bleeding edge `libpysal` in dev envs 
* [#182:](https://github.com/pysal/giddy/pull/182) Prepare for v2.3.4 release 


### pointpats
* [#62:](https://github.com/pysal/pointpats/issues/62) Update docs for 2.2.0 
* [#86:](https://github.com/pysal/pointpats/issues/86) Infrastructure 
* [#97:](https://github.com/pysal/pointpats/pull/97) Fix github action for docs building 
* [#96:](https://github.com/pysal/pointpats/pull/96) add packages for building docs in env file 
* [#95:](https://github.com/pysal/pointpats/pull/95) Docs 
* [#94:](https://github.com/pysal/pointpats/pull/94) bump to v2.3.0 
* [#92:](https://github.com/pysal/pointpats/pull/92) migrate docs from RTD to github page 
* [#91:](https://github.com/pysal/pointpats/pull/91) handle scipy deprecation 
* [#90:](https://github.com/pysal/pointpats/pull/90) add github action for release and doc building 
* [#64:](https://github.com/pysal/pointpats/pull/64) [WIP] Migrate to GitHub Actions for testing 
* [#80:](https://github.com/pysal/pointpats/issues/80) pointpats on conda-forge fails pip check 
* [#76:](https://github.com/pysal/pointpats/issues/76) Documentation for `pointpats` version 2.2.0 in Google Colab 
* [#63:](https://github.com/pysal/pointpats/issues/63) Move testing to github actions 
* [#79:](https://github.com/pysal/pointpats/issues/79) Deprecated statistics included in the manual 
* [#69:](https://github.com/pysal/pointpats/pull/69) update centrography test for dep induced precision breakage 
* [#88:](https://github.com/pysal/pointpats/pull/88) GHA: fix target 
* [#87:](https://github.com/pysal/pointpats/pull/87) Set up and update infrastructure 
* [#82:](https://github.com/pysal/pointpats/pull/82) Make opencv package optional 
* [#85:](https://github.com/pysal/pointpats/pull/85) DOC: fix API docs 
* [#84:](https://github.com/pysal/pointpats/issues/84) pointpats.random not in the API docs 


### segregation
* [#217:](https://github.com/pysal/segregation/pull/217) dont run changelog on upload release 
* [#216:](https://github.com/pysal/segregation/pull/216) GHA: update release action for pyproject 
* [#215:](https://github.com/pysal/segregation/issues/215) publish workflow needs updating 
* [#213:](https://github.com/pysal/segregation/issues/213) Use of Total Population in Dissimilarity Index 
* [#200:](https://github.com/pysal/segregation/issues/200) simulate_evenness is forcing a geodataframe 
* [#212:](https://github.com/pysal/segregation/pull/212) infra 
* [#211:](https://github.com/pysal/segregation/pull/211) update infrastructure 
* [#210:](https://github.com/pysal/segregation/pull/210) remove pygeos 


### spaghetti
* [#717:](https://github.com/pysal/spaghetti/issues/717) COMPAT: `geopandas==0.13.0` comp with `utils._points_as_gdf()` 
* [#726:](https://github.com/pysal/spaghetti/issues/726) `build_docs.yml` workflow failure with `v1.7.3` release 
* [#734:](https://github.com/pysal/spaghetti/pull/734) force reinstall package for version fetching in `build_docs.yaml` 
* [#731:](https://github.com/pysal/spaghetti/issues/731) local docs build "failure" 
* [#733:](https://github.com/pysal/spaghetti/pull/733) Doc patch 
* [#727:](https://github.com/pysal/spaghetti/issues/727) Swap`setup-micromamba` for `provision-with-micromamba` in CI 
* [#732:](https://github.com/pysal/spaghetti/pull/732) update micromamba in CI 
* [#730:](https://github.com/pysal/spaghetti/pull/730) [pre-commit.ci] pre-commit autoupdate 
* [#729:](https://github.com/pysal/spaghetti/issues/729) update pre-commit for new `ruff` GitHub 
* [#728:](https://github.com/pysal/spaghetti/pull/728) [pre-commit.ci] pre-commit autoupdate 
* [#724:](https://github.com/pysal/spaghetti/pull/724) refactor element_as_gdf internals 
* [#723:](https://github.com/pysal/spaghetti/issues/723) refactor `element_as_gdf()` internal constructors 
* [#721:](https://github.com/pysal/spaghetti/pull/721) Overhaul repo infrastructure 
* [#716:](https://github.com/pysal/spaghetti/issues/716) Update release action 
* [#704:](https://github.com/pysal/spaghetti/issues/704) Modernize infrastructure 
* [#715:](https://github.com/pysal/spaghetti/issues/715) Memory leak in `full_distance_matrix` when `n_processes > 1` 
* [#720:](https://github.com/pysal/spaghetti/pull/720) revisit `_points_as_gdf()` 
* [#718:](https://github.com/pysal/spaghetti/pull/718) compat with GeoPandas 0.13.0 
* [#719:](https://github.com/pysal/spaghetti/pull/719) Fix memory leak in `full_distance_matrix()` 
* [#713:](https://github.com/pysal/spaghetti/pull/713) Bump peter-evans/create-pull-request from 4 to 5 
* [#712:](https://github.com/pysal/spaghetti/pull/712) [pre-commit.ci] pre-commit autoupdate 
* [#711:](https://github.com/pysal/spaghetti/issues/711) Can we run network kernel density estimation using spaghetti? 
* [#709:](https://github.com/pysal/spaghetti/issues/709) Update bleeding edge `libpysal` in dev envs 
* [#710:](https://github.com/pysal/spaghetti/pull/710) swap master for main (libpysal) 
* [#708:](https://github.com/pysal/spaghetti/pull/708) update black pin in pre-commit 
* [#707:](https://github.com/pysal/spaghetti/pull/707) Update Versioneer 


### momepy
* [#472:](https://github.com/pysal/momepy/issues/472) TypeError when using momepy.remove_false_nodes with shapely.geometry.linestring.LineString 
* [#486:](https://github.com/pysal/momepy/pull/486) RLS: fix PyPI long description 
* [#485:](https://github.com/pysal/momepy/pull/485) RLS: add 0.6.0 changelog 
* [#484:](https://github.com/pysal/momepy/pull/484) DOC: add note to COINS re undirected graphs 
* [#448:](https://github.com/pysal/momepy/issues/448) DOC: Unexpected results from momepy.COINS 
* [#483:](https://github.com/pysal/momepy/pull/483) [pre-commit.ci] pre-commit autoupdate 
* [#481:](https://github.com/pysal/momepy/issues/481) CI: `TestElements.test_get_node_id_ratio` failing in `311-dev.yaml` 
* [#480:](https://github.com/pysal/momepy/pull/480) [pre-commit.ci] pre-commit autoupdate 
* [#479:](https://github.com/pysal/momepy/pull/479) REF: update for shapely 2.0 
* [#443:](https://github.com/pysal/momepy/issues/443) Refactor code for shapely 2.0 
* [#464:](https://github.com/pysal/momepy/issues/464) Shapely no longer has 'lgeos' in version 2.0.0 
* [#477:](https://github.com/pysal/momepy/pull/477) [pre-commit.ci] pre-commit autoupdate 
* [#475:](https://github.com/pysal/momepy/pull/475) [pre-commit.ci] pre-commit autoupdate 
* [#476:](https://github.com/pysal/momepy/pull/476) update warnings for ruff 
* [#474:](https://github.com/pysal/momepy/pull/474) [pre-commit.ci] pre-commit autoupdate 
* [#473:](https://github.com/pysal/momepy/pull/473) TypeError when using momepy.remove_false_nodes with shapely.geometry.linestring.LineString 
* [#471:](https://github.com/pysal/momepy/pull/471) [pre-commit.ci] pre-commit autoupdate 
* [#470:](https://github.com/pysal/momepy/issues/470) remove `libpysal` pin in dev? 
* [#469:](https://github.com/pysal/momepy/pull/469) [pre-commit.ci] pre-commit autoupdate 
* [#468:](https://github.com/pysal/momepy/pull/468) remove redundant `requirements.txt` 
* [#467:](https://github.com/pysal/momepy/pull/467) MAINT: switch to pyproject and ruff 
* [#466:](https://github.com/pysal/momepy/issues/466) read_file: IllegalArgumentException: point array must contain 0 or >1 elements 


### spreg
* [#113:](https://github.com/pysal/spreg/pull/113) Fixing minor bugs in the way results were bring printed in regimes models 
* [#112:](https://github.com/pysal/spreg/pull/112) Fixing a bug in the printing of results of Chow Test in ML_Lag_Regimes 
* [#111:](https://github.com/pysal/spreg/pull/111) Revision of Skater_reg's example notebook and its inclusion in the docs. 


### tobler
* [#177:](https://github.com/pysal/tobler/pull/177) fix typo in pycno when nanhandle is false 
* [#176:](https://github.com/pysal/tobler/issues/176) Problems using pycno (handling of nulls) 
* [#175:](https://github.com/pysal/tobler/issues/175) Very Inaccurate results with area interpolation 
* [#173:](https://github.com/pysal/tobler/issues/173) 0.9 was not actually released 
* [#168:](https://github.com/pysal/tobler/issues/168) rename default branch from `master` to `main` 
* [#170:](https://github.com/pysal/tobler/issues/170) update testing & supported Python versions 
* [#140:](https://github.com/pysal/tobler/pull/140) [WIP] start kriging module 
* [#138:](https://github.com/pysal/tobler/pull/138) Categorization of notebooks 
* [#169:](https://github.com/pysal/tobler/issues/169) update infrastructure 
* [#174:](https://github.com/pysal/tobler/pull/174) update infrastructure 
* [#171:](https://github.com/pysal/tobler/issues/171) refactor to use shapely2 instead of pygeos 
* [#139:](https://github.com/pysal/tobler/pull/139) integrate smaup into tobler 
* [#172:](https://github.com/pysal/tobler/pull/172) REF: move from pygeos to shapely 2 


### mapclassify
* [#182:](https://github.com/pysal/mapclassify/pull/182) [pre-commit.ci] pre-commit autoupdate 
* [#181:](https://github.com/pysal/mapclassify/pull/181) ENH: Pretty Breaks classifier 
* [#176:](https://github.com/pysal/mapclassify/pull/176) Add anchor option to StdMean 
* [#177:](https://github.com/pysal/mapclassify/pull/177) BUG: pass through lowest in User_Defined 
* [#178:](https://github.com/pysal/mapclassify/pull/178) DOC: surface find_bin 
* [#180:](https://github.com/pysal/mapclassify/pull/180) Bump peter-evans/create-pull-request from 4 to 5 
* [#179:](https://github.com/pysal/mapclassify/pull/179) [pre-commit.ci] pre-commit autoupdate 
* [#174:](https://github.com/pysal/mapclassify/pull/174) Update requirements_docs.txt 
* [#171:](https://github.com/pysal/mapclassify/pull/171) Update precommit and ignore formatting commits 
* [#172:](https://github.com/pysal/mapclassify/pull/172) [pre-commit.ci] pre-commit autoupdate 
* [#170:](https://github.com/pysal/mapclassify/pull/170) Update Versioneer 



## Contributors

Many thanks to all of the following individuals who contributed to this release:


 - Eli Knaap
 - James Gaboardi
 - Levi John Wolf
 - Martin Fleischmann
 - Pedro Amaral
 - Qiusheng Wu
 - Serge Rey
 - Wei Kang

# PySAL 23.01 2023-01-31
 
Overall, there were 479 commits that closed 205 issues, together with 19 pull requests since our last release on 2022-07-31.

## Highlights

- Version numbering has switched to YR.MO for the pysal meta-package release.
- The `spopt` package added a LSCP-B formulation and the P-Dispersion model through the excellent GSoC project by [Erin Olson](https://erinrolson.github.io/2022/09/08/GSOC-fifth-blog.html)



## Changes by Package

### libpysal
* [#488:](https://github.com/pysal/libpysal/pull/488) type vs. geom_type with shapely 
* [#487:](https://github.com/pysal/libpysal/issues/487) address ShapelyDeprecationWarning The 'type' attribute is... 
* [#485:](https://github.com/pysal/libpysal/issues/485) allow for individual downloads and access to  remote urls in examples 
* [#486:](https://github.com/pysal/libpysal/pull/486) ENH: more granularity in example handling 
* [#482:](https://github.com/pysal/libpysal/pull/482) test against shapely prerelease 
* [#479:](https://github.com/pysal/libpysal/issues/479) Creating Weights  from dataframe: IndexError: index 0 is out of bounds for axis 0 with size 0 
* [#483:](https://github.com/pysal/libpysal/pull/483) Networkx3.0 
* [#481:](https://github.com/pysal/libpysal/pull/481) Platformdirs 
* [#478:](https://github.com/pysal/libpysal/pull/478) Updates warnings, etc. 
* [#391:](https://github.com/pysal/libpysal/issues/391) Test failures with GEOS 3.9.0 


### spaghetti
* [#701:](https://github.com/pysal/spaghetti/issues/701) another `release_and_publish.yml` failures (due to `pyproject.toml`) 
* [#703:](https://github.com/pysal/spaghetti/pull/703) Update Versioneer 
* [#700:](https://github.com/pysal/spaghetti/pull/700) Update Versioneer 
* [#702:](https://github.com/pysal/spaghetti/pull/702) add formatting exclusions properly in toml 
* [#699:](https://github.com/pysal/spaghetti/pull/699) Update Versioneer 
* [#698:](https://github.com/pysal/spaghetti/pull/698) Update Versioneer 
* [#697:](https://github.com/pysal/spaghetti/pull/697) try versioneer action 
* [#696:](https://github.com/pysal/spaghetti/pull/696) remove pygeos from environments 
* [#680:](https://github.com/pysal/spaghetti/issues/680) remove `pygeos` 
* [#695:](https://github.com/pysal/spaghetti/pull/695) supplement `setup.py` with a `name` kwarg for dep graph 
* [#694:](https://github.com/pysal/spaghetti/issues/694) add `name` keyword in `setup.py` 
* [#693:](https://github.com/pysal/spaghetti/pull/693) [pre-commit.ci] pre-commit autoupdate 
* [#692:](https://github.com/pysal/spaghetti/pull/692) [pre-commit.ci] pre-commit autoupdate 
* [#690:](https://github.com/pysal/spaghetti/pull/690) try pyproject.toml; remove setup.cfg 
* [#691:](https://github.com/pysal/spaghetti/pull/691) [pre-commit.ci] pre-commit autoupdate 
* [#689:](https://github.com/pysal/spaghetti/pull/689) [pre-commit.ci] pre-commit autoupdate 
* [#688:](https://github.com/pysal/spaghetti/pull/688) adjust css for doc references 
* [#687:](https://github.com/pysal/spaghetti/pull/687) esda master -> main 
* [#686:](https://github.com/pysal/spaghetti/pull/686) update sphinx tooling, etc. 
* [#685:](https://github.com/pysal/spaghetti/pull/685) 1st attempt for Python 3.11 testing 
* [#684:](https://github.com/pysal/spaghetti/pull/684) [pre-commit.ci] pre-commit autoupdate 
* [#683:](https://github.com/pysal/spaghetti/pull/683) Bump actions/setup-python from 3 to 4 
* [#682:](https://github.com/pysal/spaghetti/pull/682) add linting in CI 
* [#681:](https://github.com/pysal/spaghetti/issues/681) Try out pre-commit.ci 
* [#679:](https://github.com/pysal/spaghetti/pull/679) Test against shapely pre-release 
* [#678:](https://github.com/pysal/spaghetti/issues/678) test against `shapely==2.0b1` 
* [#677:](https://github.com/pysal/spaghetti/pull/677) rerun notebooks 
* [#676:](https://github.com/pysal/spaghetti/pull/676) Update warnings, etc. 



### momepy
* [#422:](https://github.com/pysal/momepy/pull/422) RLS: add 0.5.4 changelog 
* [#420:](https://github.com/pysal/momepy/pull/420) Add pyproject.toml fi### spvcm



### mapclassify
* [#165:](https://github.com/pysal/mapclassify/pull/165) Update Versioneer 
* [#167:](https://github.com/pysal/mapclassify/pull/167) Try skipping certain files with `isort` 
* [#166:](https://github.com/pysal/mapclassify/pull/166) update master/main link issue 
* [#164:](https://github.com/pysal/mapclassify/pull/164) Update Versioneer 
* [#163:](https://github.com/pysal/mapclassify/pull/163) Update infrastructure (actions) 
* [#162:](https://github.com/pysal/mapclassify/issues/162) GHA for updating `versioneer`  
* [#161:](https://github.com/pysal/mapclassify/issues/161) update branch of gh-action-pypi-publish 
* [#37:](https://github.com/pysal/mapclassify/issues/37) Add VBA functionality 
* [#159:](https://github.com/pysal/mapclassify/pull/159) [pre-commit.ci] pre-commit autoupdate 
* [#158:](https://github.com/pysal/mapclassify/pull/158) [pre-commit.ci] pre-commit autoupdate 
* [#157:](https://github.com/pysal/mapclassify/pull/157) [pre-commit.ci] pre-commit autoupdate 
* [#156:](https://github.com/pysal/mapclassify/pull/156) [pre-commit.ci] pre-commit autoupdate 
* [#142:](https://github.com/pysal/mapclassify/issues/142) `MaxP.update()` – bins used by not defined 
* [#155:](https://github.com/pysal/mapclassify/pull/155) Remove `update` method from `MaxP` 
* [#154:](https://github.com/pysal/mapclassify/pull/154) Use `libpysal.fuzzy_contiguity()` in `greedy` 
* [#148:](https://github.com/pysal/mapclassify/issues/148) swap greedy. _geos_sw() for libpysal.fuzzy_contiguity 
* [#135:](https://github.com/pysal/mapclassify/pull/135) Thorough scouring of docs + doc build infrastructure 
* [#141:](https://github.com/pysal/mapclassify/issues/141) love and care for docstrings, etc. 
* [#152:](https://github.com/pysal/mapclassify/pull/152) ENH: addressing #145 
* [#153:](https://github.com/pysal/mapclassify/pull/153) remove spaces after table string title 
* [#145:](https://github.com/pysal/mapclassify/issues/145) remove spaces from title of classifier table string 
* [#150:](https://github.com/pysal/mapclassify/pull/150) Switch to pytest 
* [#146:](https://github.com/pysal/mapclassify/issues/146) convert from `unittest` to `pytest` 
* [#147:](https://github.com/pysal/mapclassify/pull/147) improve warnings and exceptions 
* [#140:](https://github.com/pysal/mapclassify/issues/140) warn or raise vs. print statements for unexpected behavior 
* [#151:](https://github.com/pysal/mapclassify/pull/151) [pre-commit.ci] pre-commit autoupdate 
* [#149:](https://github.com/pysal/mapclassify/issues/149) silence warnings option when `k` classes not possible? 
* [#144:](https://github.com/pysal/mapclassify/pull/144) update GHA for CI 
* [#143:](https://github.com/pysal/mapclassify/pull/143) remove _table_string() method 
* [#139:](https://github.com/pysal/mapclassify/issues/139) remove old/redundant MapClassifier._table_string() method 
* [#138:](https://github.com/pysal/mapclassify/pull/138) Bump actions/checkout from 2 to 3 
* [#137:](https://github.com/pysal/mapclassify/pull/137) Bump codecov/codecov-action from 2 to 3 
* [#136:](https://github.com/pysal/mapclassify/pull/136) update release action, etc. 
* [#105:](https://github.com/pysal/mapclassify/issues/105) Fix changelog builder to give proper attribution 
* [#134:](https://github.com/pysal/mapclassify/pull/134) updating branch in badges on README 
* [#133:](https://github.com/pysal/mapclassify/pull/133) resolves #132 
* [#132:](https://github.com/pysal/mapclassify/issues/132) update binder environment 
* [#129:](https://github.com/pysal/mapclassify/issues/129) ``RuntimeWarning: invalid value encountered in double_scalars`` 
* [#131:](https://github.com/pysal/mapclassify/pull/131) ENH: handle invariant arrays 
* [#112:](https://github.com/pysal/mapclassify/issues/112) `plot` doesn't work for pooled classifications 
* [#130:](https://github.com/pysal/mapclassify/issues/130) change default branch from master to main 
* [#128:](https://github.com/pysal/mapclassify/pull/128) [MAINT] lint & format repo; update CI; handle DeprWarns, etc. 



### spopt
* [#276:](https://github.com/pysal/spopt/issues/276) P-Median Problem Tutorial Binder example 
* [#344:](https://github.com/pysal/spopt/pull/344) Add `requirements_notebooks.txt` to MANIFEST 
* [#343:](https://github.com/pysal/spopt/issues/343) The requirementes notebook is missing from the MANIFEST.in 
* [#342:](https://github.com/pysal/spopt/pull/342) Update Versioneer 
* [#340:](https://github.com/pysal/spopt/pull/340) add versioneer action 
* [#339:](https://github.com/pysal/spopt/issues/339) add a GHA for updating `versioneer`  
* [#338:](https://github.com/pysal/spopt/pull/338) Update `release_and_publish.yml` 
* [#337:](https://github.com/pysal/spopt/issues/337) update branch of `gh-action-pypi-publish` 
* [#336:](https://github.com/pysal/spopt/pull/336) [BUG] bounds for client assignment variables 
* [#328:](https://github.com/pysal/spopt/issues/328) [BUG] client assignment variable bounds for CLSCP-SO 
* [#329:](https://github.com/pysal/spopt/pull/329) Clean up the implementation of the capacitated LSCP 
* [#320:](https://github.com/pysal/spopt/issues/320) clean up CLSCP-SO implementation 
* [#335:](https://github.com/pysal/spopt/pull/335) polish up docstrings, etc. in skater.py 
* [#333:](https://github.com/pysal/spopt/pull/333) [BUG] `affinity` in Skater spanning forest 
* [#332:](https://github.com/pysal/spopt/issues/332) customize tqdm progress bar in Skater 
* [#321:](https://github.com/pysal/spopt/issues/321) [BUG] using `affinity` in `skater.SpanningForest` 
* [#334:](https://github.com/pysal/spopt/pull/334) doc build env correction 
* [#330:](https://github.com/pysal/spopt/pull/330) Update sphinx requirement from <=4.5.0 to <6.2.0 
* [#309:](https://github.com/pysal/spopt/pull/309) workaround for cascading references in docs 
* [#327:](https://github.com/pysal/spopt/pull/327) Update sphinx requirement from <=4.5.0 to <6.1.0 
* [#324:](https://github.com/pysal/spopt/pull/324) individual `locate` test, tqdm, & bare minimal testing env 
* [#323:](https://github.com/pysal/spopt/issues/323) test against a minimal / bare bones environment  
* [#322:](https://github.com/pysal/spopt/issues/322) add `tqdm` as on optional req 
* [#318:](https://github.com/pysal/spopt/issues/318) break out `test_locate.py` 
* [#234:](https://github.com/pysal/spopt/issues/234) Factoring in Facility Capacities 
* [#319:](https://github.com/pysal/spopt/pull/319) Streamline redundant parameter passing in constraint constructors 
* [#317:](https://github.com/pysal/spopt/issues/317) streamline variable and constraint creation 
* [#7:](https://github.com/pysal/spopt/issues/7) input is not sanitised before it is used 
* [#316:](https://github.com/pysal/spopt/pull/316) Fix CLSCP-SO bugs and add tests 
* [#315:](https://github.com/pysal/spopt/issues/315) raise if demand > capacity in CLSCP-SO 
* [#314:](https://github.com/pysal/spopt/issues/314) [BUG] service radius threshold not respected in CLSCP-SO 
* [#273:](https://github.com/pysal/spopt/pull/273) Facility capacity for LSCP 
* [#313:](https://github.com/pysal/spopt/pull/313) [pre-commit.ci] pre-commit autoupdate 
* [#307:](https://github.com/pysal/spopt/pull/307) doc work and formatting continued (random_region, util, ward) 
* [#312:](https://github.com/pysal/spopt/pull/312) expose SPENC kwargs 
* [#310:](https://github.com/pysal/spopt/issues/310) remove external `spenc` from CI envs 
* [#172:](https://github.com/pysal/spopt/issues/172) Allow passing all keywords into Spenc 
* [#305:](https://github.com/pysal/spopt/pull/305) utilize `BaseSpOptExactSolver` 
* [#306:](https://github.com/pysal/spopt/pull/306) Update sphinx requirement from <=4.5.0 to <5.4.0 
* [#302:](https://github.com/pysal/spopt/pull/302) start of doc work – focusing on `locate` docs 
* [#304:](https://github.com/pysal/spopt/issues/304) update locate images & add tutorial links 
* [#300:](https://github.com/pysal/spopt/issues/300) doc work and cleanup -- add locate formulations to docstrings 
* [#296:](https://github.com/pysal/spopt/pull/296) New attributes & functionality for `locate` models 
* [#287:](https://github.com/pysal/spopt/issues/287) calculate `get_percentage()` within ``MCLP.solve(results=True)`` 
* [#286:](https://github.com/pysal/spopt/issues/286) calculate `get_mean_distance()` within ``PMedian.solve(results=True)`` 
* [#285:](https://github.com/pysal/spopt/issues/285) remove BaseOutputMixin from PDispersion 
* [#283:](https://github.com/pysal/spopt/issues/283) get_backup_percentage method for LSCP-B 
* [#282:](https://github.com/pysal/spopt/issues/282) maybe set solver as attribute in LSCPB? 
* [#267:](https://github.com/pysal/spopt/issues/267) pre-defined facilities for all location models? 
* [#301:](https://github.com/pysal/spopt/pull/301) [pre-commit.ci] pre-commit autoupdate 
* [#294:](https://github.com/pysal/spopt/pull/294) Region-k-means seed 
* [#213:](https://github.com/pysal/spopt/issues/213) K means heuristic test failure 
* [#297:](https://github.com/pysal/spopt/issues/297) keep or remove RegionMixin 
* [#215:](https://github.com/pysal/spopt/issues/215) maximum-coverage-location package 
* [#293:](https://github.com/pysal/spopt/pull/293) remove pip install in notebooks 
* [#290:](https://github.com/pysal/spopt/issues/290) more issues with binder for locate notebooks 
* [#292:](https://github.com/pysal/spopt/pull/292) Drop Py37, update binders, & test future shapely dev 
* [#291:](https://github.com/pysal/spopt/issues/291) update shapely_dev testing 
* [#284:](https://github.com/pysal/spopt/issues/284) drop testing/support for Python 3.7 
* [#288:](https://github.com/pysal/spopt/pull/288) Update/cleanup/standardize notebooks 
* [#289:](https://github.com/pysal/spopt/issues/289) test `spopt` against the `shapely==2.0b1` 
* [#269:](https://github.com/pysal/spopt/issues/269) update docs for new location models 
* [#57:](https://github.com/pysal/spopt/issues/57) Throws an error when silhoutte coefficients for two clusters are the same 
* [#187:](https://github.com/pysal/spopt/issues/187) The dissimilarity parameter should be able to accept a distance/dissimilarity matrix as an alternative to a callable distance function 
* [#188:](https://github.com/pysal/spopt/pull/188) [WIP] allow for precomputed distance matrices 
* [#263:](https://github.com/pysal/spopt/issues/263) LSCP  Notebook Plots  
* [#21:](https://github.com/pysal/spopt/issues/21) differentiating spatial clusterers 
* [#281:](https://github.com/pysal/spopt/issues/281) comparing the LSCP and LSCP-B results 
* [#278:](https://github.com/pysal/spopt/issues/278) AttributeError: type object 'FacilityModelBuilder' has no attribute 'add_maximized_min_variable' 
* [#279:](https://github.com/pysal/spopt/pull/279) testing overhaul, etc 
* [#260:](https://github.com/pysal/spopt/issues/260) GSoC 2022 Interfaces for Consistent API Design 
* [#277:](https://github.com/pysal/spopt/pull/277) .coverage in .gitignore 
* [#265:](https://github.com/pysal/spopt/issues/265) Add .coverage to .gitignore 
* [#268:](https://github.com/pysal/spopt/pull/268) P dispersion 
* [#275:](https://github.com/pysal/spopt/pull/275) Update typo in p-median example 
* [#259:](https://github.com/pysal/spopt/pull/259) LSCP-B 
* [#271:](https://github.com/pysal/spopt/pull/271) Lscpb formulation 
* [#270:](https://github.com/pysal/spopt/issues/270) LSCP-B formulation? 
* [#272:](https://github.com/pysal/spopt/pull/272) Rewrite LSCPB formulation

## Contributors

Many thanks to all of the following individuals who contributed to this release:


 - Andres Morfin Veytia
 - Erin Olson
 - Germano Barcelos
 - Greg Maya
 - James Gaboardi
 - Levi John Wolf
 - Martin Fleischmann
 - Nick Bearman
 - Pedro Amaral
 - Serge Reyi

 
# PySAL 23.01.0rc1 2023-01-23

Overall, there were 479 commits that closed 205 issues, together with 19 pull requests since our last release on 2022-07-31.

## Highlights

- Version numbering has switched to YR.MO for the pysal meta-package release.
- The `spopt` package added a LSCP-B formulation and the P-Dispersion model through the excellent GSoC project by [Erin Olson](https://erinrolson.github.io/2022/09/08/GSOC-fifth-blog.html)


## Changes by Package

### libpysal
* [#488:](https://github.com/pysal/libpysal/pull/488) type vs. geom_type with shapely 
* [#487:](https://github.com/pysal/libpysal/issues/487) address ShapelyDeprecationWarning The 'type' attribute is... 
* [#485:](https://github.com/pysal/libpysal/issues/485) allow for individual downloads and access to  remote urls in examples 
* [#486:](https://github.com/pysal/libpysal/pull/486) ENH: more granularity in example handling 
* [#482:](https://github.com/pysal/libpysal/pull/482) test against shapely prerelease 
* [#479:](https://github.com/pysal/libpysal/issues/479) Creating Weights  from dataframe: IndexError: index 0 is out of bounds for axis 0 with size 0 
* [#483:](https://github.com/pysal/libpysal/pull/483) Networkx3.0 
* [#481:](https://github.com/pysal/libpysal/pull/481) Platformdirs 
* [#478:](https://github.com/pysal/libpysal/pull/478) Updates warnings, etc. 
* [#391:](https://github.com/pysal/libpysal/issues/391) Test failures with GEOS 3.9.0 


### access


### esda


### giddy


### inequality


### pointpats


### segregation


### spaghetti
* [#701:](https://github.com/pysal/spaghetti/issues/701) another `release_and_publish.yml` failures (due to `pyproject.toml`) 
* [#703:](https://github.com/pysal/spaghetti/pull/703) Update Versioneer 
* [#700:](https://github.com/pysal/spaghetti/pull/700) Update Versioneer 
* [#702:](https://github.com/pysal/spaghetti/pull/702) add formatting exclusions properly in toml 
* [#699:](https://github.com/pysal/spaghetti/pull/699) Update Versioneer 
* [#698:](https://github.com/pysal/spaghetti/pull/698) Update Versioneer 
* [#697:](https://github.com/pysal/spaghetti/pull/697) try versioneer action 
* [#696:](https://github.com/pysal/spaghetti/pull/696) remove pygeos from environments 
* [#680:](https://github.com/pysal/spaghetti/issues/680) remove `pygeos` 
* [#695:](https://github.com/pysal/spaghetti/pull/695) supplement `setup.py` with a `name` kwarg for dep graph 
* [#694:](https://github.com/pysal/spaghetti/issues/694) add `name` keyword in `setup.py` 
* [#693:](https://github.com/pysal/spaghetti/pull/693) [pre-commit.ci] pre-commit autoupdate 
* [#692:](https://github.com/pysal/spaghetti/pull/692) [pre-commit.ci] pre-commit autoupdate 
* [#690:](https://github.com/pysal/spaghetti/pull/690) try pyproject.toml; remove setup.cfg 
* [#691:](https://github.com/pysal/spaghetti/pull/691) [pre-commit.ci] pre-commit autoupdate 
* [#689:](https://github.com/pysal/spaghetti/pull/689) [pre-commit.ci] pre-commit autoupdate 
* [#688:](https://github.com/pysal/spaghetti/pull/688) adjust css for doc references 
* [#687:](https://github.com/pysal/spaghetti/pull/687) esda master -> main 
* [#686:](https://github.com/pysal/spaghetti/pull/686) update sphinx tooling, etc. 
* [#685:](https://github.com/pysal/spaghetti/pull/685) 1st attempt for Python 3.11 testing 
* [#684:](https://github.com/pysal/spaghetti/pull/684) [pre-commit.ci] pre-commit autoupdate 
* [#683:](https://github.com/pysal/spaghetti/pull/683) Bump actions/setup-python from 3 to 4 
* [#682:](https://github.com/pysal/spaghetti/pull/682) add linting in CI 
* [#681:](https://github.com/pysal/spaghetti/issues/681) Try out pre-commit.ci 
* [#679:](https://github.com/pysal/spaghetti/pull/679) Test against shapely pre-release 
* [#678:](https://github.com/pysal/spaghetti/issues/678) test against `shapely==2.0b1` 
* [#677:](https://github.com/pysal/spaghetti/pull/677) rerun notebooks 
* [#676:](https://github.com/pysal/spaghetti/pull/676) Update warnings, etc. 


### mgwr


### momepy
* [#422:](https://github.com/pysal/momepy/pull/422) RLS: add 0.5.4 changelog 
* [#420:](https://github.com/pysal/momepy/pull/420) Add pyproject.toml file 
* [#415:](https://github.com/pysal/momepy/issues/415) add a project.toml? 
* [#419:](https://github.com/pysal/momepy/pull/419) proof README.md 
* [#416:](https://github.com/pysal/momepy/pull/416) Scour docs for consistency, grammar, etc. 
* [#414:](https://github.com/pysal/momepy/issues/414) scour docstrings (grammar, punctuation, etc.) 
* [#418:](https://github.com/pysal/momepy/pull/418) GHA: update PyPI release action 
* [#413:](https://github.com/pysal/momepy/pull/413) add flake8 and isort to CI 
* [#412:](https://github.com/pysal/momepy/issues/412) enhance CI with flake8 & isort 
* [#409:](https://github.com/pysal/momepy/pull/409) BUG: get_network_ratio non-interescting joins fix 
* [#408:](https://github.com/pysal/momepy/issues/408) BUG: get_network_ratio returns wrong ID for non-intersecting join 
* [#410:](https://github.com/pysal/momepy/pull/410) minor spelling and punctuation update 
* [#392:](https://github.com/pysal/momepy/pull/392) ENH: roundabout_simplification() notebook example 
* [#407:](https://github.com/pysal/momepy/pull/407) CI: test preprocessing part of user guide 
* [#405:](https://github.com/pysal/momepy/pull/405) Run user guide tests with Python 3.10 
* [#403:](https://github.com/pysal/momepy/pull/403) remove pygeos duplicate 
* [#400:](https://github.com/pysal/momepy/pull/400) standardize pytest.approx() in testing files 
* [#404:](https://github.com/pysal/momepy/pull/404) bump copyright year 
* [#402:](https://github.com/pysal/momepy/issues/402) pygeos occurs twice in asv.conf.json - matrix 
* [#401:](https://github.com/pysal/momepy/issues/401) test user guide against Python 3.10? 
* [#399:](https://github.com/pysal/momepy/issues/399) both pytest.approx() and approx() used in testing 
* [#398:](https://github.com/pysal/momepy/pull/398) Fix various warnings 
* [#397:](https://github.com/pysal/momepy/issues/397) Fix thrown warnings in dimension, elements, diversity 
* [#395:](https://github.com/pysal/momepy/pull/395) handle `All NaN slice` warning 
* [#394:](https://github.com/pysal/momepy/issues/394) Handle `All-NaN slice encountered` warning in diversity.Percentiles() 
* [#390:](https://github.com/pysal/momepy/issues/390) limit numpy version evaluations in diversity.Percentiles 
* [#393:](https://github.com/pysal/momepy/pull/393) DOC: create preprocessing section 
* [#388:](https://github.com/pysal/momepy/issues/388) suppress warnings in dimensions.StreetProfile() 
* [#389:](https://github.com/pysal/momepy/pull/389) handle scenarios leading to dimensions.StreetProfile() warnings 
* [#391:](https://github.com/pysal/momepy/pull/391) Rabs geom 
* [#386:](https://github.com/pysal/momepy/issues/386) numpy. nanpercentile() has a renamed keyword 
* [#383:](https://github.com/pysal/momepy/issues/383) update .append method for dataframes 
* [#382:](https://github.com/pysal/momepy/pull/382) REF: remove deprecated pandas append 
* [#384:](https://github.com/pysal/momepy/pull/384) REF: replace append with concat 
* [#387:](https://github.com/pysal/momepy/pull/387) address numpy.nanpercentile warning 
* [#385:](https://github.com/pysal/momepy/pull/385) DOC: temporarily pin theme 
* [#371:](https://github.com/pysal/momepy/pull/371) ENH: geometry-based simplification of roundabouts 
* [#379:](https://github.com/pysal/momepy/pull/379) Added warning for gdp_to_nx if geometries are not LineStrings 
* [#378:](https://github.com/pysal/momepy/pull/378) BUG: make coins independent of gdf index 
* [#373:](https://github.com/pysal/momepy/pull/373) DOC: compat with latest sphinx pydata theme 
* [#362:](https://github.com/pysal/momepy/issues/362) DOC: broken colours with new pydata_sphinx_theme 


### spglm


### spint


### spreg
* [#108:](https://github.com/pysal/spreg/pull/108) update gitcount and conf.py 
* [#107:](https://github.com/pysal/spreg/pull/107) update workflows/ci 
* [#100:](https://github.com/pysal/spreg/pull/100) update tools/gitcount notebook 
* [#105:](https://github.com/pysal/spreg/pull/105) Fixing failed tests for new release 
* [#104:](https://github.com/pysal/spreg/pull/104) Version update 


### spvcm


### tobler


### mapclassify
* [#165:](https://github.com/pysal/mapclassify/pull/165) Update Versioneer 
* [#167:](https://github.com/pysal/mapclassify/pull/167) Try skipping certain files with `isort` 
* [#166:](https://github.com/pysal/mapclassify/pull/166) update master/main link issue 
* [#164:](https://github.com/pysal/mapclassify/pull/164) Update Versioneer 
* [#163:](https://github.com/pysal/mapclassify/pull/163) Update infrastructure (actions) 
* [#162:](https://github.com/pysal/mapclassify/issues/162) GHA for updating `versioneer`  
* [#161:](https://github.com/pysal/mapclassify/issues/161) update branch of gh-action-pypi-publish 
* [#37:](https://github.com/pysal/mapclassify/issues/37) Add VBA functionality 
* [#159:](https://github.com/pysal/mapclassify/pull/159) [pre-commit.ci] pre-commit autoupdate 
* [#158:](https://github.com/pysal/mapclassify/pull/158) [pre-commit.ci] pre-commit autoupdate 
* [#157:](https://github.com/pysal/mapclassify/pull/157) [pre-commit.ci] pre-commit autoupdate 
* [#156:](https://github.com/pysal/mapclassify/pull/156) [pre-commit.ci] pre-commit autoupdate 
* [#142:](https://github.com/pysal/mapclassify/issues/142) `MaxP.update()` – bins used by not defined 
* [#155:](https://github.com/pysal/mapclassify/pull/155) Remove `update` method from `MaxP` 
* [#154:](https://github.com/pysal/mapclassify/pull/154) Use `libpysal.fuzzy_contiguity()` in `greedy` 
* [#148:](https://github.com/pysal/mapclassify/issues/148) swap greedy. _geos_sw() for libpysal.fuzzy_contiguity 
* [#135:](https://github.com/pysal/mapclassify/pull/135) Thorough scouring of docs + doc build infrastructure 
* [#141:](https://github.com/pysal/mapclassify/issues/141) love and care for docstrings, etc. 
* [#152:](https://github.com/pysal/mapclassify/pull/152) ENH: addressing #145 
* [#153:](https://github.com/pysal/mapclassify/pull/153) remove spaces after table string title 
* [#145:](https://github.com/pysal/mapclassify/issues/145) remove spaces from title of classifier table string 
* [#150:](https://github.com/pysal/mapclassify/pull/150) Switch to pytest 
* [#146:](https://github.com/pysal/mapclassify/issues/146) convert from `unittest` to `pytest` 
* [#147:](https://github.com/pysal/mapclassify/pull/147) improve warnings and exceptions 
* [#140:](https://github.com/pysal/mapclassify/issues/140) warn or raise vs. print statements for unexpected behavior 
* [#151:](https://github.com/pysal/mapclassify/pull/151) [pre-commit.ci] pre-commit autoupdate 
* [#149:](https://github.com/pysal/mapclassify/issues/149) silence warnings option when `k` classes not possible? 
* [#144:](https://github.com/pysal/mapclassify/pull/144) update GHA for CI 
* [#143:](https://github.com/pysal/mapclassify/pull/143) remove _table_string() method 
* [#139:](https://github.com/pysal/mapclassify/issues/139) remove old/redundant MapClassifier._table_string() method 
* [#138:](https://github.com/pysal/mapclassify/pull/138) Bump actions/checkout from 2 to 3 
* [#137:](https://github.com/pysal/mapclassify/pull/137) Bump codecov/codecov-action from 2 to 3 
* [#136:](https://github.com/pysal/mapclassify/pull/136) update release action, etc. 
* [#105:](https://github.com/pysal/mapclassify/issues/105) Fix changelog builder to give proper attribution 
* [#134:](https://github.com/pysal/mapclassify/pull/134) updating branch in badges on README 
* [#133:](https://github.com/pysal/mapclassify/pull/133) resolves #132 
* [#132:](https://github.com/pysal/mapclassify/issues/132) update binder environment 
* [#129:](https://github.com/pysal/mapclassify/issues/129) ``RuntimeWarning: invalid value encountered in double_scalars`` 
* [#131:](https://github.com/pysal/mapclassify/pull/131) ENH: handle invariant arrays 
* [#112:](https://github.com/pysal/mapclassify/issues/112) `plot` doesn't work for pooled classifications 
* [#130:](https://github.com/pysal/mapclassify/issues/130) change default branch from master to main 
* [#128:](https://github.com/pysal/mapclassify/pull/128) [MAINT] lint & format repo; update CI; handle DeprWarns, etc. 


### splot


### spopt
* [#344:](https://github.com/pysal/spopt/pull/344) Add `requirements_notebooks.txt` to MANIFEST 
* [#343:](https://github.com/pysal/spopt/issues/343) The requirementes notebook is missing from the MANIFEST.in 
* [#342:](https://github.com/pysal/spopt/pull/342) Update Versioneer 
* [#340:](https://github.com/pysal/spopt/pull/340) add versioneer action 
* [#339:](https://github.com/pysal/spopt/issues/339) add a GHA for updating `versioneer`  
* [#338:](https://github.com/pysal/spopt/pull/338) Update `release_and_publish.yml` 
* [#337:](https://github.com/pysal/spopt/issues/337) update branch of `gh-action-pypi-publish` 
* [#336:](https://github.com/pysal/spopt/pull/336) [BUG] bounds for client assignment variables 
* [#328:](https://github.com/pysal/spopt/issues/328) [BUG] client assignment variable bounds for CLSCP-SO 
* [#329:](https://github.com/pysal/spopt/pull/329) Clean up the implementation of the capacitated LSCP 
* [#320:](https://github.com/pysal/spopt/issues/320) clean up CLSCP-SO implementation 
* [#335:](https://github.com/pysal/spopt/pull/335) polish up docstrings, etc. in skater.py 
* [#333:](https://github.com/pysal/spopt/pull/333) [BUG] `affinity` in Skater spanning forest 
* [#332:](https://github.com/pysal/spopt/issues/332) customize tqdm progress bar in Skater 
* [#321:](https://github.com/pysal/spopt/issues/321) [BUG] using `affinity` in `skater.SpanningForest` 
* [#334:](https://github.com/pysal/spopt/pull/334) doc build env correction 
* [#330:](https://github.com/pysal/spopt/pull/330) Update sphinx requirement from <=4.5.0 to <6.2.0 
* [#309:](https://github.com/pysal/spopt/pull/309) workaround for cascading references in docs 
* [#327:](https://github.com/pysal/spopt/pull/327) Update sphinx requirement from <=4.5.0 to <6.1.0 
* [#324:](https://github.com/pysal/spopt/pull/324) individual `locate` test, tqdm, & bare minimal testing env 
* [#323:](https://github.com/pysal/spopt/issues/323) test against a minimal / bare bones environment  
* [#322:](https://github.com/pysal/spopt/issues/322) add `tqdm` as on optional req 
* [#318:](https://github.com/pysal/spopt/issues/318) break out `test_locate.py` 
* [#234:](https://github.com/pysal/spopt/issues/234) Factoring in Facility Capacities 
* [#319:](https://github.com/pysal/spopt/pull/319) Streamline redundant parameter passing in constraint constructors 
* [#317:](https://github.com/pysal/spopt/issues/317) streamline variable and constraint creation 
* [#7:](https://github.com/pysal/spopt/issues/7) input is not sanitised before it is used 
* [#316:](https://github.com/pysal/spopt/pull/316) Fix CLSCP-SO bugs and add tests 
* [#315:](https://github.com/pysal/spopt/issues/315) raise if demand > capacity in CLSCP-SO 
* [#314:](https://github.com/pysal/spopt/issues/314) [BUG] service radius threshold not respected in CLSCP-SO 
* [#273:](https://github.com/pysal/spopt/pull/273) Facility capacity for LSCP 
* [#313:](https://github.com/pysal/spopt/pull/313) [pre-commit.ci] pre-commit autoupdate 
* [#307:](https://github.com/pysal/spopt/pull/307) doc work and formatting continued (random_region, util, ward) 
* [#312:](https://github.com/pysal/spopt/pull/312) expose SPENC kwargs 
* [#310:](https://github.com/pysal/spopt/issues/310) remove external `spenc` from CI envs 
* [#172:](https://github.com/pysal/spopt/issues/172) Allow passing all keywords into Spenc 
* [#305:](https://github.com/pysal/spopt/pull/305) utilize `BaseSpOptExactSolver` 
* [#306:](https://github.com/pysal/spopt/pull/306) Update sphinx requirement from <=4.5.0 to <5.4.0 
* [#302:](https://github.com/pysal/spopt/pull/302) start of doc work – focusing on `locate` docs 
* [#304:](https://github.com/pysal/spopt/issues/304) update locate images & add tutorial links 
* [#300:](https://github.com/pysal/spopt/issues/300) doc work and cleanup -- add locate formulations to docstrings 
* [#296:](https://github.com/pysal/spopt/pull/296) New attributes & functionality for `locate` models 
* [#287:](https://github.com/pysal/spopt/issues/287) calculate `get_percentage()` within ``MCLP.solve(results=True)`` 
* [#286:](https://github.com/pysal/spopt/issues/286) calculate `get_mean_distance()` within ``PMedian.solve(results=True)`` 
* [#285:](https://github.com/pysal/spopt/issues/285) remove BaseOutputMixin from PDispersion 
* [#283:](https://github.com/pysal/spopt/issues/283) get_backup_percentage method for LSCP-B 
* [#282:](https://github.com/pysal/spopt/issues/282) maybe set solver as attribute in LSCPB? 
* [#267:](https://github.com/pysal/spopt/issues/267) pre-defined facilities for all location models? 
* [#301:](https://github.com/pysal/spopt/pull/301) [pre-commit.ci] pre-commit autoupdate 
* [#294:](https://github.com/pysal/spopt/pull/294) Region-k-means seed 
* [#213:](https://github.com/pysal/spopt/issues/213) K means heuristic test failure 
* [#297:](https://github.com/pysal/spopt/issues/297) keep or remove RegionMixin 
* [#215:](https://github.com/pysal/spopt/issues/215) maximum-coverage-location package 
* [#293:](https://github.com/pysal/spopt/pull/293) remove pip install in notebooks 
* [#290:](https://github.com/pysal/spopt/issues/290) more issues with binder for locate notebooks 
* [#292:](https://github.com/pysal/spopt/pull/292) Drop Py37, update binders, & test future shapely dev 
* [#291:](https://github.com/pysal/spopt/issues/291) update shapely_dev testing 
* [#284:](https://github.com/pysal/spopt/issues/284) drop testing/support for Python 3.7 
* [#288:](https://github.com/pysal/spopt/pull/288) Update/cleanup/standardize notebooks 
* [#289:](https://github.com/pysal/spopt/issues/289) test `spopt` against the `shapely==2.0b1` 
* [#276:](https://github.com/pysal/spopt/issues/276) P-Median Problem Tutorial Binder example 
* [#269:](https://github.com/pysal/spopt/issues/269) update docs for new location models 
* [#57:](https://github.com/pysal/spopt/issues/57) Throws an error when silhoutte coefficients for two clusters are the same 
* [#187:](https://github.com/pysal/spopt/issues/187) The dissimilarity parameter should be able to accept a distance/dissimilarity matrix as an alternative to a callable distance function 
* [#188:](https://github.com/pysal/spopt/pull/188) [WIP] allow for precomputed distance matrices 
* [#263:](https://github.com/pysal/spopt/issues/263) LSCP  Notebook Plots  
* [#21:](https://github.com/pysal/spopt/issues/21) differentiating spatial clusterers 
* [#281:](https://github.com/pysal/spopt/issues/281) comparing the LSCP and LSCP-B results 
* [#278:](https://github.com/pysal/spopt/issues/278) AttributeError: type object 'FacilityModelBuilder' has no attribute 'add_maximized_min_variable' 
* [#279:](https://github.com/pysal/spopt/pull/279) testing overhaul, etc 
* [#260:](https://github.com/pysal/spopt/issues/260) GSoC 2022 Interfaces for Consistent API Design 
* [#277:](https://github.com/pysal/spopt/pull/277) .coverage in .gitignore 
* [#265:](https://github.com/pysal/spopt/issues/265) Add .coverage to .gitignore 
* [#268:](https://github.com/pysal/spopt/pull/268) P dispersion 
* [#275:](https://github.com/pysal/spopt/pull/275) Update typo in p-median example 
* [#259:](https://github.com/pysal/spopt/pull/259) LSCP-B 
* [#271:](https://github.com/pysal/spopt/pull/271) Lscpb formulation 
* [#270:](https://github.com/pysal/spopt/issues/270) LSCP-B formulation? 
* [#272:](https://github.com/pysal/spopt/pull/272) Rewrite LSCPB formulation 

## Contributors

Many thanks to all of the following individuals who contributed to this release:


 - Andres Morfin Veytia
 - Erin Olson
 - Germano Barcelos
 - Greg Maya
 - James Gaboardi
 - Levi John Wolf
 - Martin Fleischmann
 - Nick Bearman
 - Pedro Amaral
 - Serge Rey


# PySAL 2.7.0, 2022-07-31 

Overall, there were 212 commits that closed 81 issues, together with 14 pull requests since our last release on 2022-02-01.


## Highlights

- The `segregation` package added a new set of measures, the global and local Distortion indices, based on [Bezenac et al](https://onlinelibrary.wiley.com/doi/10.1111/gean.12271) thanks to an excellent GSoC project by [Noah Bouchier](https://github.com/noahbouchier)
- The `spreg` package added functionalities to estimate endogenous spatial regimes models based on [Anselin & Amaral (2021)](http://dx.doi.org/10.13140/RG.2.2.20310.78401)
- A [paper](https://joss.theoj.org/papers/10.21105/joss.03330) highlighting the `spopt` package was published in the Journal of Open Source Software.


<a name="changes-by-package"></a>
## Changes by Package


<a name="libpysal"></a>
### libpysal
* [#454:](https://github.com/pysal/libpysal/pull/454) revert shapely hard dependecy 
* [#453:](https://github.com/pysal/libpysal/issues/453) Shapely Dependancy Added 
* [#457:](https://github.com/pysal/libpysal/pull/457) [WIP] Filter holes from alpha shape returns 
* [#461:](https://github.com/pysal/libpysal/pull/461) Bump actions/checkout from 2 to 3 
* [#460:](https://github.com/pysal/libpysal/pull/460) Update release_and_publish.yml 
* [#458:](https://github.com/pysal/libpysal/issues/458) Is 10.yaml missing in ci? 
* [#459:](https://github.com/pysal/libpysal/pull/459) Update build_docs.yml 


<a name="access"></a>
### access
* [#36:](https://github.com/pysal/access/pull/36) key error from #34 
* [#28:](https://github.com/pysal/access/issues/28) Raam outputs 
* [#31:](https://github.com/pysal/access/issues/31) release + upload workflow failure 
* [#33:](https://github.com/pysal/access/pull/33) bump to v1.1.7 
* [#32:](https://github.com/pysal/access/pull/32) update gitcount tool for access 
* [#30:](https://github.com/pysal/access/pull/30) Update setup.py 
* [#29:](https://github.com/pysal/access/issues/29) generate pypi token for Secret in GH 
* [#26:](https://github.com/pysal/access/pull/26) Partial solution to #18 
* [#18:](https://github.com/pysal/access/issues/18) [BUG]: demand estimation is incorrect with asymmetric travel matrices 



<a name="segregation"></a>
### segregation
* [#199:](https://github.com/pysal/segregation/pull/199) move pandana into function-level import inside reproject_network 
* [#198:](https://github.com/pysal/segregation/pull/198) pyproj pin 
* [#197:](https://github.com/pysal/segregation/pull/197) add pin for minimum pyproj 
* [#196:](https://github.com/pysal/segregation/pull/196) Sjr/docs 
* [#192:](https://github.com/pysal/segregation/pull/192) add KLDivergence class 
* [#195:](https://github.com/pysal/segregation/pull/195) feat: memory efficient and performant gini 
* [#170:](https://github.com/pysal/segregation/pull/170) Memory efficient Gini 
* [#194:](https://github.com/pysal/segregation/pull/194) add black to docs reqs 
* [#193:](https://github.com/pysal/segregation/pull/193) remove deprecated modules 
* [#185:](https://github.com/pysal/segregation/pull/185) Commit of `kl_divergence_profile` function and walkthrough notebook - following Google Summer of Code 2021 



<a name="momepy"></a>
### momepy
* [#352:](https://github.com/pysal/momepy/pull/352) CI updates 
* [#353:](https://github.com/pysal/momepy/pull/353) RLS: 0.5.3 changelog 
* [#351:](https://github.com/pysal/momepy/pull/351) BUG: fix issue with blocks within another blocks 
* [#350:](https://github.com/pysal/momepy/pull/350) TST: skip to avoid geopandas regression 
* [#349:](https://github.com/pysal/momepy/pull/349) REF: simplify orientation calculation 
* [#347:](https://github.com/pysal/momepy/pull/347) BUG: Fix angle computation in graph creation with dual approach 
* [#346:](https://github.com/pysal/momepy/issues/346) BUG?: angular betweenness is returning strange results 
* [#345:](https://github.com/pysal/momepy/pull/345) Update actions versions in tests.yaml 
* [#344:](https://github.com/pysal/momepy/pull/344) Update release_to_pypi.yml 





<a name="splot"></a>
### splot
* [#156:](https://github.com/pysal/splot/pull/156) [RLS] changelog for 1.1.5 
* [#155:](https://github.com/pysal/splot/pull/155) add GHA for release 
* [#154:](https://github.com/pysal/splot/issues/154) release GHA workflow 
* [#153:](https://github.com/pysal/splot/pull/153) Streamlining Unittest CI workflow 
* [#127:](https://github.com/pysal/splot/pull/127) [DOC] Add Codecov coverage testing 
* [#152:](https://github.com/pysal/splot/pull/152) DOC: update docs for bibtex>1 
* [#142:](https://github.com/pysal/splot/issues/142) Usage of tags in splot 
* [#143:](https://github.com/pysal/splot/pull/143) Use versioneer 
* [#151:](https://github.com/pysal/splot/pull/151) Drop Python 3.7 support 
* [#150:](https://github.com/pysal/splot/pull/150) Import ABC from collections.abc for Python 3.10 compatibility. 
* [#148:](https://github.com/pysal/splot/pull/148) DOC: change links from master to main 


<a name="spopt"></a>
### spopt
* [#252:](https://github.com/pysal/spopt/pull/252) a 'final' proofing for JOSS manuscript 
* [#248:](https://github.com/pysal/spopt/issues/248) JOSS manuscript clean up [2] 
* [#250:](https://github.com/pysal/spopt/pull/250) clean out code block and add preexisting facility text 
* [#213:](https://github.com/pysal/spopt/issues/213) K means heuristic test failure (3.10) 
* [#249:](https://github.com/pysal/spopt/pull/249) address reference concerns, etc. [2] 
* [#246:](https://github.com/pysal/spopt/issues/246) JOSS manuscript clean up [1] 
* [#247:](https://github.com/pysal/spopt/pull/247) cleaning up JOSS manuscript -- references & links 
* [#245:](https://github.com/pysal/spopt/pull/245) add spopt ref to JOSS paper 
* [#242:](https://github.com/pysal/spopt/issues/242) General usability issues when working with coverage models 
* [#240:](https://github.com/pysal/spopt/issues/240) Consider documenting class properties 
* [#243:](https://github.com/pysal/spopt/pull/243) Document locate class properties 
* [#244:](https://github.com/pysal/spopt/pull/244) build(deps): bump actions/setup-python from 3 to 4 
* [#233:](https://github.com/pysal/spopt/issues/233) PuLP: cannot execute glpsol.exe when 
* [#241:](https://github.com/pysal/spopt/issues/241) Consider documenting units for the `max_coverage` parameter of MCLP/LSCP.from_geodataframe 
* [#237:](https://github.com/pysal/spopt/issues/237) issue with predefined facilities results? 
* [#239:](https://github.com/pysal/spopt/pull/239) Check feasibility following solution attempt 
* [#238:](https://github.com/pysal/spopt/issues/238) checking for model feasibility following solve 
* [#235:](https://github.com/pysal/spopt/pull/235) UBDC acknowledgement 
* [#232:](https://github.com/pysal/spopt/issues/232) ERROR: Package 'spopt' requires a different Python: 3.6.9 not in '>=3.7' 
* [#231:](https://github.com/pysal/spopt/pull/231) Add predefined locations to coverage models 
* [#229:](https://github.com/pysal/spopt/pull/229) build(deps): bump codecov/codecov-action from 2 to 3 
* [#228:](https://github.com/pysal/spopt/pull/228) Components 
* [#227:](https://github.com/pysal/spopt/pull/227) Components fix 
* [#226:](https://github.com/pysal/spopt/pull/226) doc: update policy options for maxp 
* [#224:](https://github.com/pysal/spopt/issues/224) islands argument ignored in skater 
* [#223:](https://github.com/pysal/spopt/pull/223) policy for multiple components in maxp 
* [#225:](https://github.com/pysal/spopt/pull/225) Fix skater islands kwarg being ignored 
* [#221:](https://github.com/pysal/spopt/pull/221) mclp and lscp jupyter notebooks using osrm routing 
* [#222:](https://github.com/pysal/spopt/issues/222) MCLP with optional Capacity of Facilities Constraint 
* [#220:](https://github.com/pysal/spopt/pull/220) Bump actions/checkout from 2 to 3 
* [#219:](https://github.com/pysal/spopt/pull/219) bump actions/setup-python from 2 to 3 
* [#209:](https://github.com/pysal/spopt/issues/209) Cut release for meta 
* [#217:](https://github.com/pysal/spopt/issues/217) Factoring in existing facilities 
* [#216:](https://github.com/pysal/spopt/pull/216) build(deps): bump actions/github-script from 5 to 6 
* [#214:](https://github.com/pysal/spopt/pull/214) Region docs 

<a name="contributors"></a>
## Contributors

Many thanks to all of the following individuals who contributed to this release:


 - Eli Knaap
 - Germano Barcelos
 - James Gaboardi
 - Jamie Saxon
 - Karthikeyan Singaravelan
 - Levi John Wolf
 - Martin Fleischmann
 - Serge Rey
 - Stefanie Lumnitz
 - Timothy Ellersiek


# PySAL v2.6.0, 2022-01-31
PySAL 2.6.0 represents 6 months of enhancements, bug-fixes, widening
of test coverage, and improved documentation.  All users are
encouraged to upgrade to this version as there are numerous
optimizations as well as new features (see below) that have been
implemented.

## Highlights

### New Package: [pysal/momempy](https://github.com/pysal/momepy)

>Momepy is a library for quantitative analysis of urban form - urban morphometrics

<a name="changes-by-package"></a>
## Changes by Package

Overall, there were 181 commits that closed 99 issues since our last release on 2021-07-31.

<a name="libpysal"></a>
### libpysal
* [#450:](https://github.com/pysal/libpysal/pull/450) DOCS: Gabriel and related enhancements 
* [#449:](https://github.com/pysal/libpysal/pull/449) DOC: Update docs for Gabriel and related enhancements 
* [#448:](https://github.com/pysal/libpysal/pull/448) Gabriel docs 
* [#438:](https://github.com/pysal/libpysal/pull/438) add gabriel weights and more performant voronoi generation 
* [#442:](https://github.com/pysal/libpysal/pull/442) ENH: Moving to appdirs for example storage 
* [#443:](https://github.com/pysal/libpysal/pull/443) MAINT: replace LooseVersion with packaging 
* [#349:](https://github.com/pysal/libpysal/pull/349) Format UserWarning string in W.to_adjlist 
* [#285:](https://github.com/pysal/libpysal/pull/285) remove non-coincident points correctly from knn weights 
* [#439:](https://github.com/pysal/libpysal/pull/439) Bug fix for parallel execution environments 
* [#429:](https://github.com/pysal/libpysal/pull/429) Use versioneer to manage __version__ 
* [#437:](https://github.com/pysal/libpysal/pull/437) REF: update for shapely 2.0 
* [#434:](https://github.com/pysal/libpysal/issues/434) tools/gitcount with versioneer 
* [#435:](https://github.com/pysal/libpysal/pull/435) update version import in gitcount 
* [#321:](https://github.com/pysal/libpysal/pull/321) represent islands as self-joins with zero weight in adjacency lists 
* [#431:](https://github.com/pysal/libpysal/pull/431) DOC: Fix several warnings during the build 
* [#430:](https://github.com/pysal/libpysal/pull/430) Fix test_voronoi on other architectures. 
* [#420:](https://github.com/pysal/libpysal/issues/420) Testraster failures without numba: 'dia_matrix' object is not subscriptable 
* [#232:](https://github.com/pysal/libpysal/pull/232) add neighbor_equality and write_gal to the imports from util 
* [#428:](https://github.com/pysal/libpysal/pull/428) Fix failure of "dia_matrix object is not subscriptable" 
* [#402:](https://github.com/pysal/libpysal/pull/402) Edgelist-based contiguity constructor 
* [#419:](https://github.com/pysal/libpysal/issues/419) scipy 1.7.0 breaking test_lat2SW 
* [#423:](https://github.com/pysal/libpysal/pull/423) use toarray in `W.full()` 
* [#426:](https://github.com/pysal/libpysal/pull/426) cast sw to csc and eliminate zeros 
* [#425:](https://github.com/pysal/libpysal/pull/425) skip scipy 1.7.1 for in test_lat2SW 
* [#422:](https://github.com/pysal/libpysal/pull/422) dense 


<a name="access"></a>
### access


<a name="esda"></a>
### esda


<a name="giddy"></a>
### giddy


<a name="inequality"></a>
### inequality


<a name="pointpats"></a>
### pointpats


<a name="segregation"></a>
### segregation
* [#184:](https://github.com/pysal/segregation/pull/184) prepare v2.1.0 
* [#35:](https://github.com/pysal/segregation/issues/35) parallelization simulation based indexes and inference wrappers 
* [#180:](https://github.com/pysal/segregation/issues/180) use rvlib for densitycorrecteddissim 
* [#183:](https://github.com/pysal/segregation/pull/183) performance enhancements 


<a name="spaghetti"></a>
### spaghetti
* [#657:](https://github.com/pysal/spaghetti/pull/657) attempt Python 3.10 in CI 
* [#638:](https://github.com/pysal/spaghetti/issues/638) Update changelog tooling to report contributors 
* [#655:](https://github.com/pysal/spaghetti/pull/655) Try automated release notes action 
* [#653:](https://github.com/pysal/spaghetti/issues/653) update gitcount notebook for versioneer? 
* [#654:](https://github.com/pysal/spaghetti/pull/654) access version from pacakge in gitcount 
* [#652:](https://github.com/pysal/spaghetti/pull/652) add manual triggers for workflows 
* [#650:](https://github.com/pysal/spaghetti/issues/650) omit new versioner files from code coverage 
* [#651:](https://github.com/pysal/spaghetti/pull/651) ignore versioneer files for code coverage reporting 
* [#649:](https://github.com/pysal/spaghetti/pull/649) add deprecation warning for libpysal geometries 
* [#647:](https://github.com/pysal/spaghetti/issues/647) versioneer for version management 
* [#648:](https://github.com/pysal/spaghetti/pull/648) Versioneer  
* [#373:](https://github.com/pysal/spaghetti/issues/373) [ENH] Explore a "two workflows" style format 


<a name="mgwr"></a>
### mgwr


<a name="momepy"></a>
### momepy
* [#331:](https://github.com/pysal/momepy/pull/331) RLS: add 0.5.2 changelog 
* [#330:](https://github.com/pysal/momepy/pull/330) BUG: fix FormFactor 
* [#329:](https://github.com/pysal/momepy/issues/329) BUG: FormFactor uses incorrect formula 
* [#320:](https://github.com/pysal/momepy/pull/320) REF: simplify calculation of Simpson diversity 
* [#319:](https://github.com/pysal/momepy/pull/319) TST: redo CI matrix 
* [#327:](https://github.com/pysal/momepy/issues/327) Summary at the custom-zone level 
* [#325:](https://github.com/pysal/momepy/issues/325) QST: input data type for momepy  
* [#321:](https://github.com/pysal/momepy/issues/321) QST: mm.Blocks emits CRS mismatch warnings 
* [#323:](https://github.com/pysal/momepy/issues/323) QST: how to save graph to Shapefile? 
* [#318:](https://github.com/pysal/momepy/pull/318) TST: use mambaforge in CI 
* [#315:](https://github.com/pysal/momepy/pull/315) BUG: non-default index dropped in Blocks id series 
* [#316:](https://github.com/pysal/momepy/issues/316) 0.5.1 release 
* [#311:](https://github.com/pysal/momepy/issues/311) BUG: incorrect index in `Blocks.*_id` Series for non-default index 
* [#314:](https://github.com/pysal/momepy/issues/314) TST: CI failure due to geopandas regression 
* [#313:](https://github.com/pysal/momepy/pull/313) relicense under BSD 
* [#305:](https://github.com/pysal/momepy/issues/305) copyright and license 
* [#312:](https://github.com/pysal/momepy/pull/312) REF/TST: minimise warnings 
* [#309:](https://github.com/pysal/momepy/issues/309) Silence warnings from geopandas 0.10 
* [#306:](https://github.com/pysal/momepy/pull/306) update README.md 
* [#303:](https://github.com/pysal/momepy/pull/303) Fix links after the transfer under pysal org 
* [#301:](https://github.com/pysal/momepy/issues/301) Finish transfer under PySAL org 
* [#299:](https://github.com/pysal/momepy/pull/299) ENH: support shapely polygon as enclosures limit 
* [#254:](https://github.com/pysal/momepy/issues/254) ENH: allow limit of enclosures to be shapely polygon 
* [#293:](https://github.com/pysal/momepy/issues/293) Import causes ImportError 
* [#298:](https://github.com/pysal/momepy/pull/298) ENH: catch geographic CRS in Tessellation 
* [#297:](https://github.com/pysal/momepy/issues/297) Tesselation fails at Generating input point array... with ValueError: need at least one array to concatenate 
* [#286:](https://github.com/pysal/momepy/issues/286) momepy.Tessellation returns empty rows when buildings are outside of enclosures 
* [#296:](https://github.com/pysal/momepy/pull/296) PERF: use dask.bag in Tessellation 
* [#295:](https://github.com/pysal/momepy/issues/295) `momepy.Tessellation` doesn't appear to run faster on a machine with many more cores 
* [#292:](https://github.com/pysal/momepy/pull/292) DOC: edit/proof street network analysis notebooks 
* [#288:](https://github.com/pysal/momepy/pull/288) BUG: properly clip enclosures by limit 
* [#287:](https://github.com/pysal/momepy/issues/287) momepy.enclosures doesn't appear to observe limit parameter 
* [#270:](https://github.com/pysal/momepy/issues/270) Enclosure has problems with rivers 
* [#291:](https://github.com/pysal/momepy/pull/291) BUG: Tessellation error on non-standard enclosures 
* [#289:](https://github.com/pysal/momepy/issues/289) BUG: momepy.Tessellation fails with IndexError 
* [#290:](https://github.com/pysal/momepy/pull/290) small typo in gdf_to_nx 


<a name="spglm"></a>
### spglm


<a name="spint"></a>
### spint


<a name="spreg"></a>
### spreg


<a name="spvcm"></a>
### spvcm


<a name="tobler"></a>
### tobler


<a name="mapclassify"></a>
### mapclassify


<a name="splot"></a>
### splot


<a name="spopt"></a>
### spopt
* [#205:](https://github.com/pysal/spopt/pull/205) install pulp for docs build 
* [#196:](https://github.com/pysal/spopt/issues/196) rework JOSS manuscript 
* [#200:](https://github.com/pysal/spopt/pull/200) [WIP] JOSS paper revisions work 
* [#203:](https://github.com/pysal/spopt/issues/203) update the real-world facility location notebook. 
* [#204:](https://github.com/pysal/spopt/pull/204) Update fac-loc real world notebook 
* [#201:](https://github.com/pysal/spopt/issues/201) region_k_means not handling candidate move updates 
* [#202:](https://github.com/pysal/spopt/pull/202) Update candidates list after making a move 
* [#179:](https://github.com/pysal/spopt/issues/179) Update changelog tooling to report contributors 
* [#199:](https://github.com/pysal/spopt/pull/199) Generate Changelog notes automatically on release 
* [#197:](https://github.com/pysal/spopt/pull/197) access package version in tools/gitcount 
* [#198:](https://github.com/pysal/spopt/pull/198) Add examples section to locate module 
* [#190:](https://github.com/pysal/spopt/issues/190) update locate docs 
* [#194:](https://github.com/pysal/spopt/pull/194) switch to versioneer 
* [#193:](https://github.com/pysal/spopt/pull/193) Update locate docs 
* [#192:](https://github.com/pysal/spopt/issues/192) Reference error for Church and Murray book 
* [#2:](https://github.com/pysal/spopt/issues/2) facility location models in a class 
* [#189:](https://github.com/pysal/spopt/issues/189) Facility Location modeling solutions & CI 
* [#186:](https://github.com/pysal/spopt/pull/186) Add Locate Module 
* [#3:](https://github.com/pysal/spopt/issues/3) bug: maxp implementation is not using contiguity 
* [#49:](https://github.com/pysal/spopt/issues/49) spopt as solver agnostic? 
* [#61:](https://github.com/pysal/spopt/issues/61) solvers and solver APIs 
* [#18:](https://github.com/pysal/spopt/issues/18) new alternative to pulp 

<a name="contributors"></a>
## Contributors

Many thanks to all of the following individuals who contributed to this release:


 - Charles Schmidt
 - Eli Knaap
 - Elliott Sales De Andrade
 - Germano Barcelos
 - James Gaboardi
 - Levi John Wolf
 - Martin Fleischmann
 - Serge Rey


# PySAL v2.5.0, 2021-07-31

PySAL 2.5.0 represents 6 months of enhancements, bug-fixes, widening of test coverage, and improved documentation. All users are encouraged to upgrade to this version as there are numerous optimizations as well as new features (see below) that have been implemented.

Overall, there were 543 commits that closed 190 issues, together with 33 pull requests since our last release on 2021-01-31.


## Package Highlights

### esda
This version merges two large new sets of functionalities:

- map correspondence measures in [`esda.map_comparison`](https://github.com/pysal/esda/blob/master/esda/map_comparison.py)
- shape statistics in [`esda.shape`](https://github.com/pysal/esda/blob/master/esda/shape.py)

### segregation
Version 2.0 of the `segregation` package brings a new API, a massive code restructuring, and dozens of new features, enhancements, and bug fixes. For a complete overview of the new API, please see the documentation page at <https://pysal.org/segregation/api>. The new version does away with the distinction between spatial and aspatial segregation indices and instead partitions the functions based on single-group and multi-group measures. The spatial/aspatial distinction is echewed in version 2.0 because *all* aspatial indices can be generalized into spatial versions, following the logic of Reardon and O'Sullivan (see a description in [this example notebook](https://nbviewer.jupyter.org/github/knaaptime/segregation/blob/2.0/notebooks/01_singlegroup_indices.ipynb)). Furthermore, "space" can be incorporated into the index calculation using either Euclidean distance or the shortest path along a travel network. With this logic, the package now offers multiscalar segregation profiles for 23 different segregation indices (a first in any software package).

### tobler
Added [pychnophylactic interpolation](https://www.tandfonline.com/doi/abs/10.1080/01621459.1979.10481647).


### spaghetti
 The highlights of this release include functionality to [split network arcs by count](https://pysal.org/spaghetti/generated/spaghetti.Network.html#spaghetti.Network.split_arcs), which compliments the previously available distance splitting, and a [paper](https://doi.org/10.21105/joss.02826) in the Journal of Open Source Software. Also, Python 3.6 is no longer supported.


### spopt
This release includes another model to add to the suite: RandomRegions. RandomRegions, originally written by David C. Folch (@dfolch) and Serge Rey, builds regions based on an initial random seed while considering user-defined specifications such as: region count, cardinality, contiguity, and compactness (citation?). Also, we have improved the testing coverage for the models inlcuded in the initial release: AZP, Max-*p*-regions, Region-*k*-means, Skater, Spenc, and WardSpatial.


<a name="changes-by-package"></a>
## Detailed Changes by Package

<a name="libpysal"></a>
### libpysal
* [#412:](https://github.com/pysal/libpysal/pull/412) Add missing endianness in WK1 reader. 
* [#413:](https://github.com/pysal/libpysal/pull/413) Update unittests, etc 
* [#415:](https://github.com/pysal/libpysal/pull/415) classify repo as Python 
* [#389:](https://github.com/pysal/libpysal/pull/389) add docs action workflow 
* [#411:](https://github.com/pysal/libpysal/pull/411) Return a dataframe with info on available datasets 
* [#409:](https://github.com/pysal/libpysal/issues/409) Do not fetch examples on import 
* [#410:](https://github.com/pysal/libpysal/pull/410) Do not poll remotes on init. 
* [#400:](https://github.com/pysal/libpysal/pull/400) Fixed `index2da` causing inverted output 
* [#399:](https://github.com/pysal/libpysal/issues/399) Raster weights `w2da` failing on 3.6 
* [#408:](https://github.com/pysal/libpysal/issues/408) Correct way to compute spatial weights in libpysal 
* [#407:](https://github.com/pysal/libpysal/pull/407) Bump actions/upload-release-asset from 1 to 1.0.2 
* [#405:](https://github.com/pysal/libpysal/pull/405) Bump conda-incubator/setup-miniconda from 2 to 2.1.1 
* [#404:](https://github.com/pysal/libpysal/pull/404) Bump actions/setup-python from 2 to 2.2.2 
* [#406:](https://github.com/pysal/libpysal/pull/406) Bump actions/cache from 2 to 2.1.5 
* [#403:](https://github.com/pysal/libpysal/pull/403) Bump actions/checkout from 2 to 2.3.4 
* [#401:](https://github.com/pysal/libpysal/issues/401) Dimension issues in DistanceBand weights 
* [#341:](https://github.com/pysal/libpysal/issues/341) Use a labelled sparse xarray.DataArray as the core representation for weights 
* [#397:](https://github.com/pysal/libpysal/pull/397) Draft of adjacency table as df 
* [#398:](https://github.com/pysal/libpysal/pull/398) Expand weights benchmark 
* [#396:](https://github.com/pysal/libpysal/pull/396) Draft of adjacency table as df 
* [#395:](https://github.com/pysal/libpysal/pull/395) xarray geograph implementation 
* [#392:](https://github.com/pysal/libpysal/pull/392) Add start of workbench notebook 
* [#390:](https://github.com/pysal/libpysal/pull/390) Bump actions/cache from v2 to v2.1.4 
* [#388:](https://github.com/pysal/libpysal/pull/388) update dev docs link 
* [#387:](https://github.com/pysal/libpysal/pull/387) make build + make sync @docsrc 
* [#386:](https://github.com/pysal/libpysal/pull/386) bump version 
* [#385:](https://github.com/pysal/libpysal/pull/385) Adding raster interface to docs API + notebooks 
* [#384:](https://github.com/pysal/libpysal/pull/384) [Doc]: Update raster example notebook and docstrings 


<a name="access"></a>
### access


<a name="esda"></a>
### esda
* [#188:](https://github.com/pysal/esda/pull/188) add pygeos-tolerant fails for the module 
* [#133:](https://github.com/pysal/esda/pull/133) add the start on new calculation method for getisord statistics 
* [#121:](https://github.com/pysal/esda/issues/121) Gi rewrite 
* [#86:](https://github.com/pysal/esda/issues/86) Incorrect behavior for Moran_Local and self-neighbors 
* [#186:](https://github.com/pysal/esda/pull/186) update codecov action to v2 
* [#180:](https://github.com/pysal/esda/pull/180) Add map correspondence measure from Nowosad and Stepinski 
* [#185:](https://github.com/pysal/esda/pull/185) [PERF] List comprehension to array operation in local multivariate Geary 
* [#184:](https://github.com/pysal/esda/pull/184) Update Spatial Autocorrelation for Areal Unit Data 
* [#172:](https://github.com/pysal/esda/pull/172) Merge ljwolf/shapestats into esda 
* [#182:](https://github.com/pysal/esda/pull/182) adjust setup in conf.py 
* [#170:](https://github.com/pysal/esda/pull/170) [DOC] Updating read the docs api for local join counts, local geary 
* [#179:](https://github.com/pysal/esda/pull/179) Bump sphinxcontrib-bibtex from 1.0.0 to 2.3.0 
* [#178:](https://github.com/pysal/esda/pull/178) Bump sphinxcontrib-bibtex from 1.0.0 to 2.2.1 
* [#176:](https://github.com/pysal/esda/pull/176) Bump actions/checkout from 2 to 2.3.4 
* [#175:](https://github.com/pysal/esda/pull/175) Bump codecov/codecov-action from 1 to 1.5.0 
* [#177:](https://github.com/pysal/esda/pull/177) Bump actions/setup-python from 2 to 2.2.2 
* [#173:](https://github.com/pysal/esda/pull/173) Bump actions/create-release from 1 to 1.1.4 
* [#174:](https://github.com/pysal/esda/pull/174) Bump actions/upload-release-asset from 1 to 1.0.2 
* [#169:](https://github.com/pysal/esda/pull/169) Bump sphinxcontrib-bibtex from 1.0.0 to 2.2.0 
* [#168:](https://github.com/pysal/esda/pull/168) add tests for parallel crand 


<a name="giddy"></a>
### giddy


<a name="inequality"></a>
### inequality


<a name="pointpats"></a>
### pointpats


<a name="segregation"></a>
### segregation
* [#166:](https://github.com/pysal/segregation/pull/166) remove mamba reference 
* [#169:](https://github.com/pysal/segregation/issues/169) error in AbsoluteClustering with geographic coordinate system 
* [#171:](https://github.com/pysal/segregation/issues/171) add deprecation layer for 2.0 
* [#104:](https://github.com/pysal/segregation/issues/104) [ENH] extend segregation profile function to accept more spatial indices 
* [#167:](https://github.com/pysal/segregation/issues/167) Dissimilarity Index API typo 
* [#165:](https://github.com/pysal/segregation/issues/165) remove travis-ci badge 
* [#4:](https://github.com/pysal/segregation/issues/4) consider refactor to scikit-style mixins 
* [#161:](https://github.com/pysal/segregation/pull/161) 2.0 refactor 
* [#168:](https://github.com/pysal/segregation/issues/168) Segregation measure (aspatial/spatial) with groupby? 
* [#163:](https://github.com/pysal/segregation/issues/163) Example notebooks missing scaramento2.shp 


<a name="spaghetti"></a>
### spaghetti
* [#639:](https://github.com/pysal/spaghetti/pull/639) prepare for v1.6.2 release 
* [#637:](https://github.com/pysal/spaghetti/issues/637) update conf.py link in tutorials 
* [#617:](https://github.com/pysal/spaghetti/issues/617) update action for GH releases 
* [#636:](https://github.com/pysal/spaghetti/pull/636) Version bump & rerun notebooks 
* [#635:](https://github.com/pysal/spaghetti/pull/635) bump to v1.6.0.post5 - another try 
* [#634:](https://github.com/pysal/spaghetti/pull/634) Try new release action (softprops/action-gh-release) 
* [#633:](https://github.com/pysal/spaghetti/pull/633) removing descartes requirement 
* [#632:](https://github.com/pysal/spaghetti/issues/632) remove descartes dependency 
* [#573:](https://github.com/pysal/spaghetti/issues/573) Blacken code in docs 
* [#631:](https://github.com/pysal/spaghetti/pull/631) doc updates for v1.6.0 release 
* [#597:](https://github.com/pysal/spaghetti/issues/597) Update copyright year 
* [#630:](https://github.com/pysal/spaghetti/pull/630) split arc by count functionality 
* [#494:](https://github.com/pysal/spaghetti/issues/494) network segmentation by count 
* [#522:](https://github.com/pysal/spaghetti/issues/522) rtree dependency and value of SMALL 
* [#629:](https://github.com/pysal/spaghetti/pull/629) Drop support for Python 3.6 
* [#628:](https://github.com/pysal/spaghetti/issues/628) Drop support for Python 3.6 
* [#627:](https://github.com/pysal/spaghetti/pull/627) Rebuild docs for version bump 
* [#440:](https://github.com/pysal/spaghetti/issues/440) release v1.6.0 
* [#491:](https://github.com/pysal/spaghetti/issues/491) Add type annotations? 
* [#626:](https://github.com/pysal/spaghetti/pull/626) Minor formatting fixes 
* [#625:](https://github.com/pysal/spaghetti/pull/625) version bump & rerun notebooks for JOSS paper 
* [#575:](https://github.com/pysal/spaghetti/issues/575) [JOSS review] Manuscript statement of need 
* [#624:](https://github.com/pysal/spaghetti/pull/624) trim down Statement of Need section 
* [#623:](https://github.com/pysal/spaghetti/pull/623) Bump actions/checkout from 2 to 2.3.4 
* [#622:](https://github.com/pysal/spaghetti/pull/622) Bump actions/setup-python from 2 to 2.2.2 
* [#621:](https://github.com/pysal/spaghetti/pull/621) Bump actions/upload-release-asset from 1 to 1.0.2 
* [#620:](https://github.com/pysal/spaghetti/pull/620) Bump actions/create-release from 1 to 1.1.4 
* [#619:](https://github.com/pysal/spaghetti/pull/619) Bump codecov/codecov-action from 1 to 1.5.0 
* [#618:](https://github.com/pysal/spaghetti/pull/618) minor cosmetic updates to workflows 
* [#616:](https://github.com/pysal/spaghetti/pull/616) Prune CI testing matrix 
* [#615:](https://github.com/pysal/spaghetti/issues/615) reduce testing matrix 
* [#609:](https://github.com/pysal/spaghetti/pull/609) pin rtree version 
* [#614:](https://github.com/pysal/spaghetti/pull/614) GitHub Actions CI with micromamba 
* [#613:](https://github.com/pysal/spaghetti/issues/613) try provision-with-micromamba 
* [#612:](https://github.com/pysal/spaghetti/pull/612) try mamba + strict again 
* [#611:](https://github.com/pysal/spaghetti/pull/611) CI work, etc. 
* [#610:](https://github.com/pysal/spaghetti/pull/610) remove mamba & conda mixture 
* [#583:](https://github.com/pysal/spaghetti/issues/583) [JOSS review] Manuscript "Current functionality" 
* [#582:](https://github.com/pysal/spaghetti/issues/582) [JOSS review] Support reading/writing networks from different formats, integration with NetworkX/OSMnx 
* [#581:](https://github.com/pysal/spaghetti/issues/581) [JOSS review] Methods to assist common tasks (especially plotting) 
* [#580:](https://github.com/pysal/spaghetti/issues/580) [JOSS review] Network class, key (unique) functionalities of spaghetti, relationship to NetworkX (or the like). 
* [#578:](https://github.com/pysal/spaghetti/issues/578) [JOSS review] Improve the quickstart notebook 
* [#577:](https://github.com/pysal/spaghetti/issues/577) [JOSS review] Add more information in the tutorial notebooks 
* [#576:](https://github.com/pysal/spaghetti/issues/576) [JOSS review] Manuscript Figure 1 (PySAL logo) 
* [#574:](https://github.com/pysal/spaghetti/issues/574) [JOSS review] Manuscript summary 
* [#608:](https://github.com/pysal/spaghetti/pull/608) update JOSS paper cite and figure size 
* [#607:](https://github.com/pysal/spaghetti/pull/607) update JOSS paper text 
* [#605:](https://github.com/pysal/spaghetti/pull/605) [WIP] Add paper references, etc. 
* [#586:](https://github.com/pysal/spaghetti/issues/586) additional functions & methods from tutorials 
* [#606:](https://github.com/pysal/spaghetti/pull/606) improve point snap / Moran figure for JOSS 
* [#588:](https://github.com/pysal/spaghetti/pull/588) addressing issue #576 
* [#603:](https://github.com/pysal/spaghetti/pull/603) add to quick start notebook 
* [#592:](https://github.com/pysal/spaghetti/pull/592) addressing #582: update spaghetti.Network docstring 
* [#602:](https://github.com/pysal/spaghetti/pull/602) Bump actions/cache from v2 to v2.1.4 
* [#601:](https://github.com/pysal/spaghetti/pull/601) update docs only on release 


<a name="mgwr"></a>
### mgwr


<a name="spglm"></a>
### spglm


<a name="spint"></a>
### spint


<a name="spreg"></a>
### spreg
* [#76:](https://github.com/pysal/spreg/pull/76) Update conf and rerelease 
* [#75:](https://github.com/pysal/spreg/pull/75) Update GHA & CI 
* [#59:](https://github.com/pysal/spreg/issues/59) Add Python 3.9 testing 
* [#74:](https://github.com/pysal/spreg/pull/74) Fixing bug with order of variables' names changing randomly in regimes. 
* [#66:](https://github.com/pysal/spreg/pull/66) Bump actions/setup-python from 2 to 2.2.2 
* [#67:](https://github.com/pysal/spreg/pull/67) Bump actions/cache from 2 to 2.1.5 
* [#68:](https://github.com/pysal/spreg/pull/68) Bump codecov/codecov-action from 1 to 1.5.0 
* [#69:](https://github.com/pysal/spreg/pull/69) Bump actions/upload-release-asset from 1 to 1.0.2 
* [#70:](https://github.com/pysal/spreg/pull/70) Bump actions/create-release from 1 to 1.1.4 
* [#65:](https://github.com/pysal/spreg/pull/65) Bump actions/cache from v2 to v2.1.4 


<a name="spvcm"></a>
### spvcm


<a name="tobler"></a>
### tobler
* [#144:](https://github.com/pysal/tobler/pull/144) add pycno to docs 
* [#143:](https://github.com/pysal/tobler/pull/143) remove css from docs conf 
* [#142:](https://github.com/pysal/tobler/pull/142) bump version 0.8 
* [#141:](https://github.com/pysal/tobler/pull/141) add pycnophylactic interpolation 
* [#95:](https://github.com/pysal/tobler/issues/95) Add Pycnophylactic Interpolation 
* [#79:](https://github.com/pysal/tobler/issues/79) sentinel data 
* [#135:](https://github.com/pysal/tobler/pull/135) ENH: support categorical variables in area_interpolate 
* [#96:](https://github.com/pysal/tobler/issues/96) vector data as a dasymetric mask 
* [#132:](https://github.com/pysal/tobler/pull/132) bump version 


<a name="mapclassify"></a>
### mapclassify
* [#114:](https://github.com/pysal/mapclassify/pull/114) Add min arg to UserDefined 
* [#110:](https://github.com/pysal/mapclassify/pull/110) Enable python 2 install 
* [#109:](https://github.com/pysal/mapclassify/issues/109) Inconsistent UserDefined Scale With Multiple Axes 
* [#107:](https://github.com/pysal/mapclassify/pull/107) Turn off 3.6 testing on ubuntu 
* [#108:](https://github.com/pysal/mapclassify/pull/108) 3.9 
* [#106:](https://github.com/pysal/mapclassify/issues/106) about the classification method's output interval's precision 


<a name="splot"></a>
### splot
* [#136:](https://github.com/pysal/splot/pull/136) [REL] add new version number and release notes for 1.1.4 
* [#135:](https://github.com/pysal/splot/pull/135) Streamline & upgrade CI 
* [#134:](https://github.com/pysal/splot/issues/134) update conf.py 
* [#124:](https://github.com/pysal/splot/issues/124) Migrating testing & coverage services 
* [#121:](https://github.com/pysal/splot/issues/121) [MAINT] rename 'master' to 'main' 
* [#130:](https://github.com/pysal/splot/issues/130) ipywidgets dependency 
* [#132:](https://github.com/pysal/splot/pull/132) REF: make ipywidgets optional dependency 
* [#133:](https://github.com/pysal/splot/pull/133) [WIP] update testing procedure with new datasets 
* [#115:](https://github.com/pysal/splot/issues/115) MatplotlibDeprecationWarning from ax.spines[label].set_smart_bounds() 


<a name="spopt"></a>
### spopt
* [#180:](https://github.com/pysal/spopt/pull/180) prep for release of version 0.1.2 
* [#177:](https://github.com/pysal/spopt/pull/177) update notebook links in conf 
* [#176:](https://github.com/pysal/spopt/pull/176) add trigger to doc_build action 
* [#175:](https://github.com/pysal/spopt/pull/175) update reg-k-means.ipynb 
* [#174:](https://github.com/pysal/spopt/pull/174) update release_and_publish.yml 
* [#169:](https://github.com/pysal/spopt/pull/169) Increase test cases & coverage 
* [#112:](https://github.com/pysal/spopt/issues/112) Improve testing suite 
* [#171:](https://github.com/pysal/spopt/pull/171) Classify repo as Python 
* [#168:](https://github.com/pysal/spopt/pull/168) maintenance for CI 
* [#167:](https://github.com/pysal/spopt/issues/167) Streamline CI with micromamba 
* [#166:](https://github.com/pysal/spopt/pull/166) Update reference DOIs and add PySAL GA reference 
* [#165:](https://github.com/pysal/spopt/pull/165) remove draft PDF action 
* [#164:](https://github.com/pysal/spopt/issues/164) remove draft_pdf action 
* [#163:](https://github.com/pysal/spopt/pull/163) Fixes documentation 
* [#162:](https://github.com/pysal/spopt/issues/162) Import clauses in documentation are wrong throughout the examples 
* [#161:](https://github.com/pysal/spopt/pull/161) correct paper indent & add JOSS badge 
* [#160:](https://github.com/pysal/spopt/pull/160) Bump actions/upload-artifact from 1 to 2.2.3 
* [#159:](https://github.com/pysal/spopt/pull/159) Add paper 
* [#158:](https://github.com/pysal/spopt/pull/158) include the paper in the git-based repository together with the software 
* [#153:](https://github.com/pysal/spopt/pull/153) Bump actions/create-release from 1 to 1.1.4 
* [#156:](https://github.com/pysal/spopt/pull/156) Bump actions/upload-release-asset from 1 to 1.0.2 
* [#157:](https://github.com/pysal/spopt/pull/157) Bump conda-incubator/setup-miniconda from 2 to 2.1.1 
* [#155:](https://github.com/pysal/spopt/pull/155) Bump codecov/codecov-action from 1 to 1.5.0 
* [#154:](https://github.com/pysal/spopt/pull/154) Bump actions/cache from 2 to 2.1.5 
* [#152:](https://github.com/pysal/spopt/pull/152) Update docs for random region 
* [#147:](https://github.com/pysal/spopt/issues/147) Support for RandomRegions? 
* [#150:](https://github.com/pysal/spopt/issues/150) Add support for randomregions 
* [#151:](https://github.com/pysal/spopt/pull/151) Adding random regions 
* [#149:](https://github.com/pysal/spopt/pull/149) test 
* [#148:](https://github.com/pysal/spopt/pull/148) update region-k-means notebook 
* [#146:](https://github.com/pysal/spopt/pull/146) revise ward in notebooks 
* [#145:](https://github.com/pysal/spopt/pull/145) revised notebook for azp 
* [#144:](https://github.com/pysal/spopt/pull/144) Bump actions/cache from v2 to v2.1.4 
* [#143:](https://github.com/pysal/spopt/pull/143) update dev docs link 
* [#142:](https://github.com/pysal/spopt/pull/142) revise skater in notebooks 
* [#140:](https://github.com/pysal/spopt/issues/140) Tutorials link in readme leads to a 404 error 
* [#141:](https://github.com/pysal/spopt/pull/141) update tutorials link in README 
* [#138:](https://github.com/pysal/spopt/issues/138) fresh cut release? 
* [#139:](https://github.com/pysal/spopt/pull/139) bump version 0.1.0 -> 0.1.1 


<a name="pysal"></a>
### pysal
* [#1199:](https://github.com/pysal/pysal/issues/1199) Bump access version in meta release 
* [#1223:](https://github.com/pysal/pysal/issues/1223) Spatial Weights issue, Points geometry not allowed 
* [#1220:](https://github.com/pysal/pysal/issues/1220) Could not load shared object file: llvmlite.dll 
* [#1218:](https://github.com/pysal/pysal/pull/1218) 2.4.0 

<a name="contributors"></a>
## Contributors

Many thanks to all of the following individuals who contributed to this release:


 - Arfon Smith
 - Dani Arribas-Bel
 - Eli Knaap
 - Elliott Sales De Andrade
 - James Gaboardi
 - Jeffcsauer
 - Jkoschinsky
 - Justin Pihony
 - Leo Morales
 - Levi John Wolf
 - Martin Fleischmann
 - Mgeeeek
 - Pedro Amaral
 - Pedro Camargo
 - Serge Rey
 - Stefanie Lumnitz
 - Tlouf
 - Xin Feng


# PySAL v2.4.0, 2021-01-31
PySAL 2.4.0 represents 6 months of enhancements, bug-fixes, widening of test
coverage, and improved documentation. Three Google Summer of Code projects made
substantial contributions to this release (see below). All users are encouraged
to upgrade to this version as there are numerous optimizations as well as new
features (see below) that have been implemented.

Overall, there were 1155 commits that closed 352 issues, together with 121 pull requests since our last release on 2020-07-29.

## Highlights

### New Package:  [pysal/spopt](https://pysal.org/spopt/)

Provides methods for solving optimization problems with spatial data. Currently, regionalization methods are supported with planned support for facility location and transportation-oriented modeling.

The regionalization models implemented include:
* Max-p-regions: It involves the aggregation or clustering of a set of small areas into the maximum number of homogeneous and spatially contiguous regions such that the value of a regional attribute is higher than a predefined threshold. The number of regions will be endogenized in order to satisfy the threshold. ([Duque, Anselin, and Rey, 2012](https://onlinelibrary.wiley.com/doi/abs/10.1111/j.1467-9787.2011.00743.x) and [Wei, Rey, and Knaap, 2020](https://www.tandfonline.com/doi/abs/10.1080/13658816.2020.1759806?journalCode=tgis20))
* Automatic Zoning Procedure (AZP) algorithm: It can work with any type of objective function that is sensitive to the aggregation of data for a larger number of zones into a pre-specified smaller number of regions ([Openshaw, 1977](https://www.jstor.org/stable/622300?casa_token=QITLwNVUPj4AAAAA%3AKXYVQHrdeAtefxZKkvxxUrWA_QCedSJrZwQD36F16Jfqx7Vq47uu1G_vp9I085Iozy_roZ_Dh6qQopZ6yXjfPsy4Y2aBqso-l0wZS2YqNv9pkh1JNXc&seq=1#metadata_info_tab_contents) 
and [Openshaw and Rao, 1995](https://journals.sagepub.com/doi/abs/10.1068/a270425))
* Region-K-means: It is K-means clustering for regions with the constraint that each cluster forms a spatially connected component.
* Skater: It is a constrained spatial regionalization algorithm based on spanning tree pruning. Specifically, the number of edges is prespecified to be cut in a continuous tree to group spatial units into contiguous regions. ([AssunCao et al., 2006](https://www.tandfonline.com/doi/full/10.1080/13658810600665111?casa_token=ovYjEkDDjbAAAAAA%3AjX8FMJWkrJDbSy8nmGiCOUFV6Fl-5KAhDibrQ89qqEpM4HvJ5wyNsrn7_x5qOwLmauKIh-RUdfZm))
* Spenc: spatially-encouraged spectral clustering is an approach to balance spatial and feature coherence using kernel combination in spectral clustering.([Wolf, 2020] (https://osf.io/yzt2p/))
* WardSpatial: It is an Agglomerative Clustering using Ward linkage with a spatial connectivity constraint. Basically, it is a "bottom-up" approach: each observation starts in its own cluster, and pairs of clusters are chosen to merge at each step in order to minimize the variance of the clusters. ([sklearn.cluster.AgglomerativeClustering](https://scikit-learn.org/stable/modules/generated/sklearn.cluster.AgglomerativeClustering.html))


### Enhancements to existing packages

#### libpysal

Thanks to the Google Summer of Code 2020 led by Mragank Shekhar (@MgeeeeK), we
have built an interface with xarray that allows you to create spatial weights
matrices from xarray.DataArray objects. This means it is possible to build a
weights matrix from raster data. We are using numba and multi-core where
possible so the implementation is performant and scalable within memory limits.
Current weights supported include:

- libpysal.weights.Rook.from_xarray
- libpysal.weights.Queen.from_xarray

In addition, the following methods have been added and are exposed to end users:

- [RECOMMENDED] da2WSP, to build a thin weights matrix (WSP) from a xarray.DataArray da2W, to build a weights matrix from a xarray.DataArray
- [RECOMMENDED] wsp2da, to reconstruct a xarray.DataArray object from a thin weights matrix and a pandas.Series (e.g. with mapclassify or esda.Moran_Local outcomes
- w2da, to reconstruct a xarray.DataArray object from a weights matrix and a pandas.Series (e.g. with mapclassify or esda.Moran_Local outcomes testDataArray, to generate a toy xarray.DataArray object for testing purposes.


#### esda

- Integration of the work of @jeffcsauer's 2020 GSOC project. This adds tons of new statistical estimators, such as:
  - the local heteroskedasticity estimator, `esda.LOSH`
  - local geary and multivariate geary estimators, `esda.Geary_Local` and `esda.Geary_Local_MV`
  - local join counts in univariate, bivariate, and multivariate flavors, `esda.Join_Counts_Local`, `esda.Join_Counts_Local_BV`, and `esda.Join_Counts_Local_MV`. 
- "analytical" moments for Moran's I for replication/comparison to R. Forms are provided in [Sokal 1998](https://onlinelibrary.wiley.com/doi/pdf/10.1111/j.1538-4632.1998.tb00406.x). 

#### spreg

Thanks to the Google Summer of Code 2020 led by [paboloestrada](https://github.com/pabloestradac), we have added the following functionality:

- Panel_RE_Lag: random effects panel estimation with spatial lagged dependent variable.
- Panel_RE_Error: random effects panel estimation with spatial error interaction.
- Lagrange Multiplier test: classic and robust version.
- Hausman test.

#### spaghetti
The highlights of this release include a [bug fix](https://github.com/pysal/spaghetti/pull/535) for how network segments were being split (raised in [#526](https://github.com/pysal/spaghetti/issues/526)) and additions to several notebooks ([spatial network segmentation](https://pysal.org/spaghetti/notebooks/network-segmentation.html#Large-synthetic-clusters), [caveats](https://pysal.org/spaghetti/tutorials.html), and [network-constrained spatial autocorrelation](https://pysal.org/spaghetti/notebooks/network-spatial-autocorrelation.html#A-highly-clustered-synthetic-example)). Also, `spaghetti` is now tested against Python 3.9.

#### tobler

- interpolation to hexagons using h3f
- more efficient unary_union in h3f

#### segregation

- segregation measures on network distances

#### mapclassify
- streamlined api

## Detailed Changes by Package

<a name="libpysal"></a>
### libpysal
* [#385:](https://github.com/pysal/libpysal/pull/385) Adding raster interface to docs API + notebooks 
* [#384:](https://github.com/pysal/libpysal/pull/384) [Doc]: Update raster example notebook and docstrings 
* [#383:](https://github.com/pysal/libpysal/pull/383) [WIP]: id_order as a property of WSP class 
* [#343:](https://github.com/pysal/libpysal/pull/343) [WIP]: Optimized raster-based weights builder 
* [#382:](https://github.com/pysal/libpysal/pull/382) remove dup matplotlib in environment.yml 
* [#366:](https://github.com/pysal/libpysal/pull/366) fix typo 
* [#376:](https://github.com/pysal/libpysal/issues/376) Bump PYPI version to 4.3.1 
* [#381:](https://github.com/pysal/libpysal/pull/381) adjust duplicated rst link in README 
* [#380:](https://github.com/pysal/libpysal/issues/380) rst link & syntax issue in README 
* [#379:](https://github.com/pysal/libpysal/pull/379) Correct readme.rst 
* [#378:](https://github.com/pysal/libpysal/pull/378) Troubleshoot release GHA 
* [#377:](https://github.com/pysal/libpysal/pull/377) bump to v4.3.2 for release action 
* [#374:](https://github.com/pysal/libpysal/pull/374) Adding deps for examples. 
* [#373:](https://github.com/pysal/libpysal/pull/373) update unittests.yml 
* [#372:](https://github.com/pysal/libpysal/issues/372) release action is broken due to gh deprecation of env var 
* [#371:](https://github.com/pysal/libpysal/pull/371) Fix release action 
* [#370:](https://github.com/pysal/libpysal/pull/370) Bump actions/setup-python from v2.1.4 to v2.2.0 
* [#364:](https://github.com/pysal/libpysal/issues/364) `examples.explain` returning 404 
* [#368:](https://github.com/pysal/libpysal/pull/368) This address a move in remote datasets  
* [#335:](https://github.com/pysal/libpysal/pull/335) ENH: use query_bulk in fuzzy_contiguity 
* [#334:](https://github.com/pysal/libpysal/issues/334) BUG: fuzzy_contiguity picks more neighbours than it should 
* [#367:](https://github.com/pysal/libpysal/pull/367) ENH: use active geometry in from_dataframe 
* [#342:](https://github.com/pysal/libpysal/pull/342) standardizing libpysal/io docs & ibpysal/cg docs 
* [#363:](https://github.com/pysal/libpysal/pull/363) Testing matrix 
* [#359:](https://github.com/pysal/libpysal/pull/359) Bump codecov/codecov-action from v1.0.14 to v1.0.15 
* [#358:](https://github.com/pysal/libpysal/pull/358) Bump actions/checkout from v2.3.3 to v2.3.4 
* [#355:](https://github.com/pysal/libpysal/issues/355) Add codecov.yml for customized reports/testing 
* [#357:](https://github.com/pysal/libpysal/pull/357) Add codecov.yml 
* [#286:](https://github.com/pysal/libpysal/issues/286) Blacken codebase 
* [#291:](https://github.com/pysal/libpysal/pull/291) [WIP] DEV: blacken codebase 
* [#354:](https://github.com/pysal/libpysal/pull/354) Bump codecov/codecov-action from v1.0.13 to v1.0.14 
* [#257:](https://github.com/pysal/libpysal/issues/257) street network-based weights 
* [#351:](https://github.com/pysal/libpysal/pull/351) Bump actions/setup-python from v2.1.3 to v2.1.4 
* [#279:](https://github.com/pysal/libpysal/issues/279) GHA for PyPI release 
* [#324:](https://github.com/pysal/libpysal/issues/324) Update PR template  
* [#347:](https://github.com/pysal/libpysal/pull/347) ENH: include lower order contiguities in higher_order_sp 
* [#313:](https://github.com/pysal/libpysal/issues/313) higher_order weights of <= k 
* [#348:](https://github.com/pysal/libpysal/pull/348) Bump actions/setup-python from v2.1.2 to v2.1.3 
* [#345:](https://github.com/pysal/libpysal/pull/345) Add xarray to requirements_plus_conda.txt 
* [#346:](https://github.com/pysal/libpysal/pull/346) Bump actions/checkout from v2.3.2 to v2.3.3 
* [#344:](https://github.com/pysal/libpysal/pull/344) Bump actions/create-release from v1.1.3 to v1.1.4 
* [#318:](https://github.com/pysal/libpysal/pull/318) [WIP] : Base Raster Interface 
* [#339:](https://github.com/pysal/libpysal/pull/339) Bump codecov/codecov-action from v1.0.12 to v1.0.13 
* [#338:](https://github.com/pysal/libpysal/pull/338) Update actions/checkout requirement to v2.3.2 
* [#336:](https://github.com/pysal/libpysal/pull/336) Bump actions/create-release from v1.1.2 to v1.1.3 
* [#337:](https://github.com/pysal/libpysal/pull/337) Bump actions/setup-python from v2.0.1 to v2.1.2 
* [#326:](https://github.com/pysal/libpysal/pull/326) Updating PULL_REQUEST_TEMPLATE.md 
* [#298:](https://github.com/pysal/libpysal/issues/298) Add github action for releasing 
* [#316:](https://github.com/pysal/libpysal/pull/316) adding release_and_publish.yml 
* [#333:](https://github.com/pysal/libpysal/issues/333) Rook contiguity weights fails when polygons border at two points 


<a name="access"></a>
### access
* [#10:](https://github.com/pysal/access/issues/10) capitalize `Access` class 
* [#15:](https://github.com/pysal/access/pull/15) Changes case on Access and Datasets classess 
* [#2:](https://github.com/pysal/access/issues/2) Ensure that the meta import for access exposes intended classes and functions 
* [#3:](https://github.com/pysal/access/issues/3) Confirm access version to freeze in meta 
* [#11:](https://github.com/pysal/access/issues/11) `sphinx` enforced to install w/ packages 
* [#12:](https://github.com/pysal/access/issues/12) The package does not depend on scipy 
* [#13:](https://github.com/pysal/access/pull/13) Adjust dependenies 
* [#1:](https://github.com/pysal/access/issues/1) Release on conda-forge 


<a name="esda"></a>
### esda
* [#160:](https://github.com/pysal/esda/pull/160) bump version for release 
* [#157:](https://github.com/pysal/esda/pull/157) Use tags now in gitcount 
* [#139:](https://github.com/pysal/esda/pull/139) [ENH][DOC] local join count and LOSH statistics 
* [#143:](https://github.com/pysal/esda/pull/143) document minimum numba version 
* [#159:](https://github.com/pysal/esda/pull/159) Moments for Moran's I_i following Sokal 1998 
* [#145:](https://github.com/pysal/esda/pull/145) [ENH][DOC] local Geary statistics 
* [#158:](https://github.com/pysal/esda/pull/158) Bump actions/setup-python from v1 to v2.2.1 
* [#156:](https://github.com/pysal/esda/pull/156) Bump to 2.3.5 
* [#155:](https://github.com/pysal/esda/pull/155) Bump version 
* [#154:](https://github.com/pysal/esda/pull/154) Prepping for 2.3.2 release. 
* [#142:](https://github.com/pysal/esda/issues/142) Issue with Numba < 0.47 
* [#146:](https://github.com/pysal/esda/issues/146) parallel_crand_ ValueError 
* [#147:](https://github.com/pysal/esda/pull/147) fix concatenation for random statistics 
* [#153:](https://github.com/pysal/esda/issues/153) Unexpected LISA results for polygons contained by another polygon 
* [#152:](https://github.com/pysal/esda/pull/152) Dropping 3.6 from testing. 
* [#151:](https://github.com/pysal/esda/pull/151) CI: update conda setup 
* [#150:](https://github.com/pysal/esda/pull/150) Bump codecov/codecov-action from v1.0.14 to v1.0.15 
* [#149:](https://github.com/pysal/esda/pull/149) Bump codecov/codecov-action from v1.0.13 to v1.0.14 
* [#144:](https://github.com/pysal/esda/pull/144) Bump codecov/codecov-action from v1.0.12 to v1.0.13 
* [#141:](https://github.com/pysal/esda/issues/141) Spatial cross-correlations? 


<a name="giddy"></a>
### giddy


<a name="inequality"></a>
### inequality


<a name="pointpats"></a>
### pointpats


<a name="segregation"></a>
### segregation
* [#159:](https://github.com/pysal/segregation/pull/159) bump ver 
* [#79:](https://github.com/pysal/segregation/issues/79) add network, util, and profile functions to readthedocs 
* [#158:](https://github.com/pysal/segregation/pull/158) update docs 
* [#153:](https://github.com/pysal/segregation/issues/153) update docstring for decomposition plotting 
* [#157:](https://github.com/pysal/segregation/pull/157) Update release action for deprecation of set env 
* [#156:](https://github.com/pysal/segregation/pull/156) update github actions 
* [#155:](https://github.com/pysal/segregation/pull/155) bump to Version 1.4 
* [#154:](https://github.com/pysal/segregation/pull/154) add docstring to decomp plotting 
* [#152:](https://github.com/pysal/segregation/pull/152) more flexible decomp plotting 
* [#151:](https://github.com/pysal/segregation/issues/151) move testing to gha 
* [#148:](https://github.com/pysal/segregation/issues/148) col names hardcoded in _generate_counterfactual 
* [#150:](https://github.com/pysal/segregation/pull/150) updates docs link 
* [#149:](https://github.com/pysal/segregation/issues/149) Website is not rendering correctly 


<a name="spaghetti"></a>
### spaghetti
* [#572:](https://github.com/pysal/spaghetti/pull/572) bump 1.5.5 --> v1.5.6 after syntax error 
* [#571:](https://github.com/pysal/spaghetti/pull/571) Prep 1.5.4 rel 
* [#569:](https://github.com/pysal/spaghetti/pull/569) new documentation build GHA schema 
* [#568:](https://github.com/pysal/spaghetti/pull/568) keep docs/notebooks directory 
* [#556:](https://github.com/pysal/spaghetti/pull/556) Revert "Python 3.9 testing for CI" 
* [#567:](https://github.com/pysal/spaghetti/pull/567) documentation maintenance and notebook generation 
* [#566:](https://github.com/pysal/spaghetti/pull/566) update docs build process 
* [#558:](https://github.com/pysal/spaghetti/issues/558) Is sphinx_gallery needed for docs? 
* [#565:](https://github.com/pysal/spaghetti/pull/565) remove sphinx_gallery from reqs 
* [#564:](https://github.com/pysal/spaghetti/pull/564) Update unittests.yml (GitHub Action) 
* [#557:](https://github.com/pysal/spaghetti/pull/557) revisit #555 (adding Python 3.9 testing) 
* [#555:](https://github.com/pysal/spaghetti/pull/555) Python 3.9 testing for CI 
* [#552:](https://github.com/pysal/spaghetti/pull/552) update GHA workflows and drop Py3.6 Windows testing 
* [#551:](https://github.com/pysal/spaghetti/pull/551) Bump codecov/codecov-action from v1.0.14 to v1.0.15 
* [#548:](https://github.com/pysal/spaghetti/issues/548) Request inclusion for GitHub Discussions. 
* [#546:](https://github.com/pysal/spaghetti/pull/546) Bump actions/checkout from v2.3.3 to v2.3.4 
* [#101:](https://github.com/pysal/spaghetti/issues/101) Network K Functionality 
* [#543:](https://github.com/pysal/spaghetti/pull/543) changed binder's link to reflect the new name of master branches from… 
* [#544:](https://github.com/pysal/spaghetti/pull/544) Update environment.yml 
* [#437:](https://github.com/pysal/spaghetti/issues/437) [JOSS] time to start thinking about a JOSS paper 
* [#542:](https://github.com/pysal/spaghetti/pull/542) minor edits and updated figure references 
* [#541:](https://github.com/pysal/spaghetti/pull/541) preparing JOSS paper for submission 
* [#540:](https://github.com/pysal/spaghetti/pull/540) Libpysal req 
* [#539:](https://github.com/pysal/spaghetti/pull/539) forgot to sync docs for v1.5.1 release 
* [#538:](https://github.com/pysal/spaghetti/pull/538) Version bump for bug fix (#535) 
* [#535:](https://github.com/pysal/spaghetti/pull/535) Vertex/Arc ID sorting bug in Network.split_arcs() 
* [#537:](https://github.com/pysal/spaghetti/pull/537) Bump codecov/codecov-action from v1.0.13 to v1.0.14 
* [#526:](https://github.com/pysal/spaghetti/issues/526) Strange count_per_link() results for networks generated using ntw.split_arcs()  
* [#536:](https://github.com/pysal/spaghetti/pull/536) Bump actions/setup-python from v2.1.3 to v2.1.4 
* [#533:](https://github.com/pysal/spaghetti/issues/533) Clarify the Network._extractnetwork() creation procedure 
* [#534:](https://github.com/pysal/spaghetti/pull/534) Add more documentation for  Network._extractnetwork() 
* [#532:](https://github.com/pysal/spaghetti/issues/532) Network creation splits arcs at each node 
* [#531:](https://github.com/pysal/spaghetti/issues/531) Network parameter extractgraph has no effect 
* [#528:](https://github.com/pysal/spaghetti/pull/528) Correcting unit typos and errors in notebooks 
* [#529:](https://github.com/pysal/spaghetti/pull/529) updating landing page images 
* [#525:](https://github.com/pysal/spaghetti/issues/525) Wrong distance units in split_arcs description 
* [#524:](https://github.com/pysal/spaghetti/pull/524) Bump actions/setup-python from v2.1.2 to v2.1.3 
* [#523:](https://github.com/pysal/spaghetti/pull/523) update docstrings and rebuild docs 
* [#521:](https://github.com/pysal/spaghetti/pull/521) bump Python version for notebooks 
* [#520:](https://github.com/pysal/spaghetti/pull/520) Bump actions/checkout from v2.3.2 to v2.3.3 
* [#519:](https://github.com/pysal/spaghetti/pull/519) Bump actions/create-release from v1.1.3 to v1.1.4 
* [#518:](https://github.com/pysal/spaghetti/pull/518) updating test_nearest_neighbor_distances() 
* [#517:](https://github.com/pysal/spaghetti/pull/517) remove black check in unittest 
* [#516:](https://github.com/pysal/spaghetti/pull/516) updating Python version in pre-commit-config.yaml 
* [#515:](https://github.com/pysal/spaghetti/pull/515) Bump codecov/codecov-action from v1.0.12 to v1.0.13 
* [#514:](https://github.com/pysal/spaghetti/pull/514) Bump actions/create-release from v1.1.2 to v1.1.3 
* [#513:](https://github.com/pysal/spaghetti/pull/513) Bump actions/setup-python from v2.1.1 to v2.1.2 
* [#512:](https://github.com/pysal/spaghetti/pull/512) Bump actions/checkout from v2.3.1 to v2.3.2 


<a name="mgwr"></a>
### mgwr
* [#86:](https://github.com/pysal/mgwr/pull/86) version bump 
* [#83:](https://github.com/pysal/mgwr/pull/83) check_constant change 
* [#85:](https://github.com/pysal/mgwr/issues/85) model.predict  =>  AttributeError: 'list' object has no attribute 'shape' 


<a name="spglm"></a>
### spglm
* [#30:](https://github.com/pysal/spglm/pull/30) update log 
* [#29:](https://github.com/pysal/spglm/pull/29) version bump 
* [#28:](https://github.com/pysal/spglm/pull/28) fix check_constant returns 


<a name="spint"></a>
### spint
* [#26:](https://github.com/pysal/spint/pull/26) version/log bump 
* [#25:](https://github.com/pysal/spint/pull/25) update travis 


<a name="spreg"></a>
### spreg
* [#54:](https://github.com/pysal/spreg/issues/54) Docs To Do 
* [#63:](https://github.com/pysal/spreg/issues/63) Missing classes in API docs 
* [#64:](https://github.com/pysal/spreg/pull/64) notebook and API docs cleanup 
* [#60:](https://github.com/pysal/spreg/pull/60) Add tutorials to docs 
* [#56:](https://github.com/pysal/spreg/issues/56) Travis --> GHA 
* [#55:](https://github.com/pysal/spreg/pull/55) CI with GitHub Actions 
* [#53:](https://github.com/pysal/spreg/pull/53) Migrate from RTD to GH-pages for automated doc builds and hosting 
* [#52:](https://github.com/pysal/spreg/pull/52) update env variable syntax 
* [#47:](https://github.com/pysal/spreg/issues/47) Spatial dependence diagnostics returns nan 
* [#46:](https://github.com/pysal/spreg/issues/46) Random Effects for Spatial Panels 
* [#50:](https://github.com/pysal/spreg/pull/50) Random Effects Panel 
* [#38:](https://github.com/pysal/spreg/pull/38) Add GM_Lag_example notebook 
* [#44:](https://github.com/pysal/spreg/issues/44) Fixed Effects Panel - Spatial Error model 
* [#45:](https://github.com/pysal/spreg/pull/45) Fixed Effects Panel - Spatial Error 
* [#49:](https://github.com/pysal/spreg/issues/49) Not being able to release to PyPI using release_and_publish.yml 
* [#48:](https://github.com/pysal/spreg/pull/48) fix doctest of check_constant 


<a name="spvcm"></a>
### spvcm


<a name="tobler"></a>
### tobler
* [#129:](https://github.com/pysal/tobler/pull/129) bump version 
* [#128:](https://github.com/pysal/tobler/issues/128) badges out of date 
* [#127:](https://github.com/pysal/tobler/pull/127) update docs 
* [#94:](https://github.com/pysal/tobler/issues/94) remove accidental notebook commit 
* [#121:](https://github.com/pysal/tobler/issues/121) h3fy example/dep 
* [#126:](https://github.com/pysal/tobler/pull/126) more efficient unary_union in h3fy 
* [#124:](https://github.com/pysal/tobler/pull/124) hexify multipolygons 
* [#125:](https://github.com/pysal/tobler/issues/125) h3fy function fails if input contains multipolygons 
* [#123:](https://github.com/pysal/tobler/pull/123) BUG: fix parallel binning 
* [#122:](https://github.com/pysal/tobler/issues/122) Untitled notebook 
* [#104:](https://github.com/pysal/tobler/issues/104) `numba`/parallel implementation of `_area_tables_binning` 
* [#112:](https://github.com/pysal/tobler/pull/112) [WIP] `STRTree` parallel implementation 
* [#119:](https://github.com/pysal/tobler/pull/119) ENH: add area_join for join based on the largest intersection 
* [#101:](https://github.com/pysal/tobler/issues/101) Pick attribute based on largest intersection 
* [#120:](https://github.com/pysal/tobler/pull/120) add missing deps for example notebooks. 
* [#117:](https://github.com/pysal/tobler/pull/117) maintenance/admin for setup/README/etc. 
* [#111:](https://github.com/pysal/tobler/pull/111) add hexify function 
* [#116:](https://github.com/pysal/tobler/pull/116) Update & enhance syntax/options in GitHub Actions 
* [#115:](https://github.com/pysal/tobler/pull/115) move dasymetric test back into test folder 
* [#114:](https://github.com/pysal/tobler/pull/114) GHA for docs 
* [#113:](https://github.com/pysal/tobler/pull/113) add h3fy to docs 
* [#110:](https://github.com/pysal/tobler/pull/110) REF: use STRtree.query_bulk in _area_tables_binning 
* [#109:](https://github.com/pysal/tobler/pull/109) fix path in release workflow 
* [#108:](https://github.com/pysal/tobler/pull/108) increment version 
* [#107:](https://github.com/pysal/tobler/pull/107) increment version number 
* [#106:](https://github.com/pysal/tobler/pull/106) update gitcount notebook 
* [#105:](https://github.com/pysal/tobler/pull/105) prepare 0.5.0 release 
* [#103:](https://github.com/pysal/tobler/pull/103) dont hardcode geometry name 
* [#102:](https://github.com/pysal/tobler/issues/102) BUG: area_interpolate fails in geometry column not named "geometry" 
* [#98:](https://github.com/pysal/tobler/pull/98) update setup-miniconda 
* [#99:](https://github.com/pysal/tobler/pull/99) Refactor test suite to be more modular for quicker development 
* [#11:](https://github.com/pysal/tobler/issues/11) enhance readme 
* [#27:](https://github.com/pysal/tobler/issues/27) Assume Poisson in the XGBoost approach 
* [#82:](https://github.com/pysal/tobler/issues/82) Reorganize repository 
* [#83:](https://github.com/pysal/tobler/issues/83) Add a tutorial to the documentation site 
* [#92:](https://github.com/pysal/tobler/issues/92) area interpolation question 
* [#91:](https://github.com/pysal/tobler/pull/91) don try to init a df if columns are missing 
* [#89:](https://github.com/pysal/tobler/pull/89) bumping release version and disambiguation of names 
* [#90:](https://github.com/pysal/tobler/pull/90) deps to run notebooks added to requirements_docs.txt 
* [#88:](https://github.com/pysal/tobler/pull/88) fix docs 
* [#87:](https://github.com/pysal/tobler/pull/87) Tutorial 
* [#86:](https://github.com/pysal/tobler/pull/86) reorg notebooks 
* [#85:](https://github.com/pysal/tobler/pull/85) BUG: have to reset_index on geometry after interpolation 
* [#70:](https://github.com/pysal/tobler/pull/70) Faster raster 
* [#81:](https://github.com/pysal/tobler/pull/81) DOC: Update notebooks for api change 
* [#72:](https://github.com/pysal/tobler/issues/72) jupyter example 
* [#69:](https://github.com/pysal/tobler/issues/69) add tests for intensive, extensive, and both 
* [#68:](https://github.com/pysal/tobler/issues/68) Problem running area_interpolate with both intensive and extensive vars 
* [#6:](https://github.com/pysal/tobler/issues/6) Consider usage of data.store_rasters() for examples 
* [#80:](https://github.com/pysal/tobler/pull/80) fix concatenation issue and copy inputs 


<a name="mapclassify"></a>
### mapclassify
* [#103:](https://github.com/pysal/mapclassify/pull/103) 2.4.2 prep 
* [#102:](https://github.com/pysal/mapclassify/pull/102) Update change log and version 
* [#104:](https://github.com/pysal/mapclassify/pull/104) REGR: invariant array fix 
* [#99:](https://github.com/pysal/mapclassify/pull/99) BUG: support series in sampled classifiers 
* [#98:](https://github.com/pysal/mapclassify/issues/98) BUG: FisherJenksSampled returns ValueError if Series is passed as y 
* [#101:](https://github.com/pysal/mapclassify/pull/101) REGR: fix invariant array regression 
* [#100:](https://github.com/pysal/mapclassify/issues/100) REGR: UserDefined classifier returns ValueError("Minimum and maximum of input data are equal, cannot create bins.") 
* [#91:](https://github.com/pysal/mapclassify/issues/91) [DOC] add example nb for new classify API 
* [#97:](https://github.com/pysal/mapclassify/pull/97) 2.4.0 Release 
* [#96:](https://github.com/pysal/mapclassify/pull/96) Remove timeout on tests. 
* [#92:](https://github.com/pysal/mapclassify/issues/92) BUG: HeadTailBreaks RecursionError due to floating point issue 
* [#95:](https://github.com/pysal/mapclassify/pull/95) Handle recursion error for head tails. 
* [#72:](https://github.com/pysal/mapclassify/issues/72) Add streamlined API 
* [#90:](https://github.com/pysal/mapclassify/pull/90) [API] add high-level API `mapclassify.classify()` 
* [#89:](https://github.com/pysal/mapclassify/pull/89) BUG: Fix mapclassify #88 
* [#94:](https://github.com/pysal/mapclassify/pull/94) exclude Python 3.6 for Windows 
* [#93:](https://github.com/pysal/mapclassify/pull/93) CI: update conda action 
* [#88:](https://github.com/pysal/mapclassify/issues/88) EqualInterval unclear error when `max_y - min_y = 0` 
* [#87:](https://github.com/pysal/mapclassify/pull/87) BUG: fix unordered series in greedy 
* [#86:](https://github.com/pysal/mapclassify/issues/86) BUG: greedy(strategy='balanced') does not return correct labels 


<a name="splot"></a>
### splot


<a name="spopt"></a>
### spopt
* [#138:](https://github.com/pysal/spopt/issues/138) fresh cut release? 
* [#139:](https://github.com/pysal/spopt/pull/139) bump version 0.1.0 -> 0.1.1 
* [#135:](https://github.com/pysal/spopt/issues/135) High level description of spopt needed for meta release change log 
* [#137:](https://github.com/pysal/spopt/pull/137) Fixing import structure 
* [#118:](https://github.com/pysal/spopt/issues/118) availability on conda-forge 
* [#134:](https://github.com/pysal/spopt/issues/134) spopt is now on conda-forge 
* [#136:](https://github.com/pysal/spopt/pull/136) bump v0.1.0 
* [#69:](https://github.com/pysal/spopt/issues/69) Installing for Google Collab  
* [#119:](https://github.com/pysal/spopt/issues/119) manual release on PYPI 
* [#132:](https://github.com/pysal/spopt/issues/132) pulp omitted from requirements 
* [#133:](https://github.com/pysal/spopt/pull/133) pulp to reqs 
* [#128:](https://github.com/pysal/spopt/issues/128) spopt sub-sub modules not included on PyPI? 
* [#131:](https://github.com/pysal/spopt/pull/131) Include all packages. 
* [#129:](https://github.com/pysal/spopt/pull/129) add __token__ user to pypi step 
* [#126:](https://github.com/pysal/spopt/issues/126) revert to old pysal-styles.ccs 
* [#127:](https://github.com/pysal/spopt/pull/127) Revert pysal-styles.ccs, etc. 
* [#125:](https://github.com/pysal/spopt/pull/125) Narrative for notebook and handling a single attribute. 
* [#124:](https://github.com/pysal/spopt/pull/124) update docs & README 
* [#115:](https://github.com/pysal/spopt/issues/115) Add Zenodo DOI 
* [#116:](https://github.com/pysal/spopt/issues/116) pre-releases for workflow testing, etc. 
* [#123:](https://github.com/pysal/spopt/pull/123) Add Zenodo DOI and citation 
* [#122:](https://github.com/pysal/spopt/pull/122) update changelog notebook 
* [#121:](https://github.com/pysal/spopt/issues/121) fix changelog notebook 
* [#120:](https://github.com/pysal/spopt/pull/120) bump version to v0.0.2 
* [#117:](https://github.com/pysal/spopt/pull/117) bump initial version down to 0.0.1 
* [#113:](https://github.com/pysal/spopt/issues/113) extra reqs for binder environment + binder badge 
* [#114:](https://github.com/pysal/spopt/pull/114) Update notebook env 
* [#111:](https://github.com/pysal/spopt/pull/111) Polish up and minor docs/reqs fixes 
* [#110:](https://github.com/pysal/spopt/issues/110) various tasks for package admin/cleanup 
* [#109:](https://github.com/pysal/spopt/pull/109) Update sphinxcontrib-bibtex requirement from <2.0.0 to <3.0.0 
* [#107:](https://github.com/pysal/spopt/issues/107) update formatting on Installation 
* [#108:](https://github.com/pysal/spopt/pull/108) Update installation.rst 
* [#106:](https://github.com/pysal/spopt/issues/106) corrections for README 
* [#102:](https://github.com/pysal/spopt/issues/102) README is incomplete 
* [#105:](https://github.com/pysal/spopt/pull/105) change python version in  installation.rst 
* [#104:](https://github.com/pysal/spopt/pull/104) add docs badge to README.md 
* [#103:](https://github.com/pysal/spopt/pull/103) yml-->yaml 
* [#99:](https://github.com/pysal/spopt/pull/99) updated docs handling 
* [#51:](https://github.com/pysal/spopt/issues/51) Funding information in README.md 
* [#56:](https://github.com/pysal/spopt/issues/56) adding Support info. 
* [#98:](https://github.com/pysal/spopt/pull/98) Adding support information. 
* [#100:](https://github.com/pysal/spopt/pull/100) add images for funding 
* [#97:](https://github.com/pysal/spopt/pull/97) remove ortools 
* [#39:](https://github.com/pysal/spopt/issues/39) Implementation 
* [#33:](https://github.com/pysal/spopt/issues/33) inventory models for consideration 
* [#37:](https://github.com/pysal/spopt/issues/37) identify models for implementation in region 
* [#40:](https://github.com/pysal/spopt/issues/40) Release Polishing 
* [#54:](https://github.com/pysal/spopt/issues/54) consider moving spenc to spopt 
* [#73:](https://github.com/pysal/spopt/pull/73) attempt 3.9 testing 
* [#95:](https://github.com/pysal/spopt/pull/95) update for 39 
* [#96:](https://github.com/pysal/spopt/issues/96) Why was `ci/` changed to `.ci/`? 
* [#89:](https://github.com/pysal/spopt/issues/89) replace deleted logos 
* [#90:](https://github.com/pysal/spopt/pull/90) Add back images that were deleted 
* [#92:](https://github.com/pysal/spopt/pull/92) revise pictures 
* [#94:](https://github.com/pysal/spopt/pull/94) handle deprecation of discretize in skl. 
* [#93:](https://github.com/pysal/spopt/pull/93) Add spenc as a lib rather than using via an import 
* [#91:](https://github.com/pysal/spopt/pull/91) Environment for development. 
* [#64:](https://github.com/pysal/spopt/pull/64) change < to == 
* [#66:](https://github.com/pysal/spopt/pull/66) add ward and test_ward 
* [#83:](https://github.com/pysal/spopt/pull/83) update .rst files 
* [#88:](https://github.com/pysal/spopt/pull/88) add description of models 
* [#86:](https://github.com/pysal/spopt/pull/86) update docs and docscr 
* [#87:](https://github.com/pysal/spopt/pull/87) Update GitHub Actions 
* [#76:](https://github.com/pysal/spopt/issues/76) Python error (Ubuntu): Segmentation fault (core dumped) 
* [#85:](https://github.com/pysal/spopt/pull/85) update methods and notebooks 
* [#75:](https://github.com/pysal/spopt/pull/75) add azp into spopt 
* [#84:](https://github.com/pysal/spopt/pull/84) Exclude failing 3.8 on ubuntu due to seg falt. 
* [#79:](https://github.com/pysal/spopt/issues/79) An issue about "module 'spopt' has no attribute 'version'" 
* [#81:](https://github.com/pysal/spopt/issues/81) migrate spenc code 
* [#80:](https://github.com/pysal/spopt/issues/80) add spenc to requirements.txt 
* [#68:](https://github.com/pysal/spopt/issues/68) rename master branch to main branch 
* [#74:](https://github.com/pysal/spopt/pull/74) Updating links from `master` branch to `main` branch 
* [#60:](https://github.com/pysal/spopt/issues/60) Issue with PuLP for Python 3.8 on conda-forge 
* [#72:](https://github.com/pysal/spopt/issues/72) Request inclusion for GitHub Discussions. 
* [#71:](https://github.com/pysal/spopt/pull/71) attempt 3.9 testing 
* [#70:](https://github.com/pysal/spopt/issues/70) Issues caused by GitHub Actions: Deprecating set-env and add-path commands 
* [#67:](https://github.com/pysal/spopt/pull/67) add spenc and test_spenc 
* [#65:](https://github.com/pysal/spopt/pull/65) skater 
* [#62:](https://github.com/pysal/spopt/pull/62) removing python-mip language from REAMDE 
* [#63:](https://github.com/pysal/spopt/issues/63) an error with the maxp code 
* [#59:](https://github.com/pysal/spopt/pull/59) adding .github/dependabot.yml 
* [#58:](https://github.com/pysal/spopt/pull/58) Setup correction 
* [#55:](https://github.com/pysal/spopt/pull/55) Updating README.md & adding CONTRIBUTING.md 


<a name="pysal"></a>
### pysal
* [#1217:](https://github.com/pysal/pysal/pull/1217) add spopt description in changelog 
* [#1215:](https://github.com/pysal/pysal/pull/1215) 2.4.0rc2 
* [#1214:](https://github.com/pysal/pysal/pull/1214) 2.4.0rc2 
* [#1211:](https://github.com/pysal/pysal/issues/1211) AttributeError: module 'pysal' has no attribute 'common' 
* [#1213:](https://github.com/pysal/pysal/pull/1213) Update changelog instructions 
* [#1212:](https://github.com/pysal/pysal/pull/1212) 2.4.0rc1 
* [#1169:](https://github.com/pysal/pysal/issues/1169) Import problem in Google Colab 
* [#1137:](https://github.com/pysal/pysal/issues/1137) conda install does not install plus requirements 
* [#1139:](https://github.com/pysal/pysal/issues/1139) Raise warnings on use, not import 
* [#1133:](https://github.com/pysal/pysal/issues/1133) AttributeError: module 'pysal' has no attribute 'open' -- Python3 on Fedora 
* [#1092:](https://github.com/pysal/pysal/issues/1092) integrate/incorporate geodacenter/spatial_access 
* [#1179:](https://github.com/pysal/pysal/issues/1179) Migrate CI to GHA and pytest 
* [#1186:](https://github.com/pysal/pysal/issues/1186) draft rc1 release notes 
* [#1154:](https://github.com/pysal/pysal/issues/1154) multiplatform testing 
* [#1208:](https://github.com/pysal/pysal/issues/1208) spopt now on conda-forge 
* [#1209:](https://github.com/pysal/pysal/pull/1209) Update changelog building and grab spopt from conda-forge not pip 
* [#1210:](https://github.com/pysal/pysal/issues/1210) wrong link to access in v2.3.0 Release Notes 
* [#1207:](https://github.com/pysal/pysal/pull/1207) removing codecov action & streamlining CI 
* [#1205:](https://github.com/pysal/pysal/issues/1205) remove codecov 
* [#1206:](https://github.com/pysal/pysal/pull/1206) Update README for spopt and new project homepage 
* [#1202:](https://github.com/pysal/pysal/issues/1202) Update tooling to handle `master` or `main` branches in ecosystem 
* [#1204:](https://github.com/pysal/pysal/pull/1204) 2.4.0 
* [#1203:](https://github.com/pysal/pysal/pull/1203) updating urllib3 to 1.26 minimum 
* [#1201:](https://github.com/pysal/pysal/issues/1201) Python 3.7 pip install has an error 
* [#1200:](https://github.com/pysal/pysal/issues/1200) ModuleNotFoundError: No module named 'pysal.model.mgwr.gwr' 
* [#1185:](https://github.com/pysal/pysal/issues/1185) dependency conflicts on 3.8 
* [#1060:](https://github.com/pysal/pysal/pull/1060) Handling coincident points 
* [#678:](https://github.com/pysal/pysal/pull/678) W stitch 
* [#1146:](https://github.com/pysal/pysal/pull/1146) Improved documentation... 
* [#1196:](https://github.com/pysal/pysal/issues/1196) GM_Lag 
* [#1195:](https://github.com/pysal/pysal/issues/1195) splot [seaborn failure](https://gitter.im/pysal/pysal?at=5efee884d65a3b0292c5e72b) 
* [#1193:](https://github.com/pysal/pysal/issues/1193) Image missing from readme on pypi 
* [#1194:](https://github.com/pysal/pysal/pull/1194) updating image link in README.md 
* [#1192:](https://github.com/pysal/pysal/pull/1192) DOCS: 2.3.0 
* [#1191:](https://github.com/pysal/pysal/pull/1191) 2.3.0 
* [#1189:](https://github.com/pysal/pysal/pull/1189) Subpackages 

<a name="contributors"></a>
## Contributors

Many thanks to all of the following individuals who contributed to this release:


 - Andrew Annex
 - Dani Arribas-Bel
 - Eli Knaap
 - James Gaboardi
 - Jamie Saxon
 - Jeffcsauer
 - Jkoschinsky
 - Knaaptime
 - Levi John Wolf
 - Martin Fleischmann
 - Mragank Shekhar
 - Omar
 - Pabloestradac
 - Pedro Amaral
 - Rwei5
 - Serge Rey
 - Stefanie Lumnitz
 - Taylor Oshan
 - Vidal Anguiano Jr
 - Wei Kang
 - Xin Feng
 - Ziqi Li

# PySAL 2.3.0, 2020-07-30

PySAL 2.3.0 represents 6 months of enhancements, bug-fixes, widening of test coverage, and improved documentation. All users are encouraged to upgrade to this version as there are numerous optimizations as well as new features (see below) that have been implemented.

Overall, there were 1343 commits that closed 273 issues, together with 166 pull requests since our last release on 2020-02-09.



## Major Highlights of PySAL 2.3.0



### Entirely New Packages

In this release, the PySAL family has expanded to include:
#### [`pysal/access`](https://pysal.org/esda)
Providing  **classical and novel measures of spatial accessibility to services**.

- We implement classic [spatial access models](https://access.readthedocs.io/en/latest/generated/access.access.html#access.access), allowing easy comparison of methodologies and assumptions.
- We support spatial access research by providing pre-computed [travel time matrices](https://access.readthedocs.io/en/latest/resources.html) and share code for computing new matrices at scale.
- We also developed a simple [web app](https://access.readthedocs.io/en/latest/app.html) that runs the package on Amazon Web Services, allowing users to explore results without installing the package.  We think this is a fun new strategy for trying new analysis methods, and hope that it will make the package more accessible to professionals.


This access models implemented  include:

- Floating Catchment Areas (FCA): For each provider, this is the ratio of providers to clients within a given travel time to the provider ([Huff 1963](https://doi.org/10.2307/3144521), [Joseph and Bantock 1982](https://doi.org/10.1016/0277-9536(82)90428-), and [Luo 2004](https://doi.org/10.1016/S1353-8292(02)00067-9)).
- Two-Stage FCAs (2SFCA): Calculated in two steps for a given travel time to the provider: 1) for each provider, the provider-to-client ratio is generated, 2) for each point of origin, these ratios are then summed ([Luo and Wang 2002](https://doi.org/10.1068/b29120), and [Wang and Luo 2005](https://doi.org/10.1016/j.healthplace.2004.02.003)).
-  Enhanced 2SFCA (E2SFCA): 2SFCA but with less weight to providers that are still within the travel threshold but at larger distances from the point of origin ([Luo and Qi 2009](https://doi.org/10.1016/j.healthplace.2009.06.002)).
- Three-Stage FCA (3SFCA): adds distance-based allocation function to E2SFCA ([Wan, Zou, and Sternberg, 2012](https://doi.org/10.1080/13658816.2011.624987)).
- Rational Agent Access Model (RAAM) ([Saxon and Snow 2019](https://doi.org/10.1080/24694452.2019.1629870)).
- Access Score: This is a weighted sum of access components like distance to provider and relative importance of provider type (Isard 1960).

The package is implemented as a single class with a number of helper functions.  According to PySAL tradition, we have also developed a broad set of [tutorials and examples](https://access.readthedocs.io/en/latest/tutorials.html).


### Enhancements to Existing Packages

#### [`pysal/esda`](https://pysal.org/esda)

 - Highly performant multi-core, numba-based conditional permutation inference for local autocorrelation statistics  (#116)
  - Adbscan:  an extension of the original DBSCAN algorithm that creates an ensemble of solutions generated by running DBSCAN on a random subset and "extending" the solution to the rest of the sample through nearest-neighbor regression (see [Arribas-Bel, Garcia-Lopez & Viladecans-Marsal, 2020 for more details)](https://github.com/darribas/adbscan_buildings). (#120)

#### [`pysal/spaghetti`](https://pysal.org/spaghetti)

- Improved support for [native PySAL geometry objects](https://pysal.org/libpysal/generated/libpysal.cg.Chain.html#libpysal.cg.Chain)
- Longest and largest network component [identification](https://pysal.org/spaghetti/generated/spaghetti.Network.html#spaghetti.Network.identify_components)
- Minimum/maximum [spanning trees](https://pysal.org/spaghetti/generated/spaghetti.spanning_tree.html#spaghetti.spanning_tree)
- Network component [extraction](https://pysal.org/spaghetti/generated/spaghetti.extract_component.html#spaghetti.extract_component)
- Refactored [*K* function](https://pysal.org/spaghetti/generated/spaghetti.Network.html#spaghetti.Network.GlobalAutoK)
- [Regular lattice](https://pysal.org/spaghetti/generated/spaghetti.regular_lattice.html#spaghetti.regular_lattice) generator
- [Shortest path creation](https://pysal.org/spaghetti/generated/spaghetti.Network.html#spaghetti.Network.shortest_paths) and [extraction](https://pysal.org/spaghetti/generated/spaghetti.element_as_gdf.html#spaghetti-element-as-gdf)
- [Testing](https://github.com/pysal/spaghetti/blob/master/.github/workflows/unittests.yml) improvements — Python 3.6, 3.7, 3.8 on Linux, macOS, and Windows
- [Tutorial](https://pysal.org/spaghetti/tutorials.html) improvements and additions

#### [`pysal/mapclassify`](https://pysal.org/mapclassify)
- [Toplogical coloring](https://pysal.org/mapclassify/notebooks/05_Greedy_coloring.html) to ensure no two adjacent polygons share the same color.
- [Pooled classification](https://pysal.org/mapclassify/notebooks/04_pooled.html) allows for the use of the same class intervals across maps.

#### [`pysal/spreg`](https://pysal.org/spreg)

- New documentation [website](https://spreg.readthedocs.io/en/latest/).

#### [`pysal/libpysal`](https://pysal.org/libpysal)

#### [`pysal/giddy`](https://pysal.org/giddy)

- Testing improvements: [GitHub Actions for Continuous Integration](https://github.com/pysal/giddy/actions?query=workflow%3A%22Continuous+Integration%22) — Python 3.6, 3.7, 3.8 on Linux, macOS, and Windows

#### [`pysal/splot`](https://splot.readthedocs.io/en/latest/?badge=latest)

- [`splot 1.1.3`](https://github.com/pysal/splot/pull/103) was published as [`Lumnitz et al., (2020). splot - visual analytics for spatial statistics. Journal of Open Source Software, 5(47), 1882, https://doi.org/10.21105/joss.01882`](https://joss.theoj.org/papers/10.21105/joss.01882) featuring functionality, implementation and it's roadmap forward.



<a name="changes-by-package"></a>
## Detailed Changes by Package

Overall, there were 1403 commits that closed 273 issues, together with 166 pull requests since our last release on 2020-02-09.


<a name="libpysal"></a>
### libpysal
* [#296:](https://github.com/pysal/libpysal/pull/296) 4.3 Release 
* [#294:](https://github.com/pysal/libpysal/pull/294) Standardize libpysal/examples/*.py docstrings 
* [#295:](https://github.com/pysal/libpysal/pull/295) Fetch 
* [#273:](https://github.com/pysal/libpysal/pull/273) Mac builds seem to take longer — bump up timeout 
* [#281:](https://github.com/pysal/libpysal/issues/281) Voronoi_frames function causes jupyter notebook kernel to die 
* [#280:](https://github.com/pysal/libpysal/pull/280) ENH: allow specific buffer in fuzzy_contiguity 
* [#278:](https://github.com/pysal/libpysal/pull/278) Return alpha option & use pygeos for alphashaping if available 
* [#276:](https://github.com/pysal/libpysal/pull/276) add weights writing as a method on weights.  
* [#277:](https://github.com/pysal/libpysal/pull/277) Docs ci badge 
* [#259:](https://github.com/pysal/libpysal/issues/259) [rough edge] libpysal.examples w/o internet? 
* [#275:](https://github.com/pysal/libpysal/pull/275) removing six from ci 
* [#274:](https://github.com/pysal/libpysal/pull/274) Handle connection errors for remote datasets 
* [#264:](https://github.com/pysal/libpysal/pull/264) GH-263: Don't implicitly import examples when importing base library 
* [#263:](https://github.com/pysal/libpysal/issues/263) examples directory prevents installing with pyInstaller 
* [#254:](https://github.com/pysal/libpysal/issues/254) Error in the internal hack for the Arc_KDTree class inheritance and the KDTree function 
* [#271:](https://github.com/pysal/libpysal/issues/271) GitHub Actions failures 
* [#255:](https://github.com/pysal/libpysal/pull/255) Bugfix 
* [#270:](https://github.com/pysal/libpysal/pull/270) dropping nose in ci/36.yml 
* [#268:](https://github.com/pysal/libpysal/issues/268) Follow-up To Do for GH Actions 
* [#269:](https://github.com/pysal/libpysal/pull/269) Polish up GitHub Action residuals 
* [#267:](https://github.com/pysal/libpysal/pull/267) Initializing complete Github Actions CI 
* [#266:](https://github.com/pysal/libpysal/pull/266) TEST: turning off 3.6 on github actions 
* [#256:](https://github.com/pysal/libpysal/pull/256) fix for issue #153 
* [#262:](https://github.com/pysal/libpysal/pull/262) Cleaning up weights/weights.py docs 
* [#265:](https://github.com/pysal/libpysal/pull/265) DOC: Udpdating citations, minor description editing 
* [#261:](https://github.com/pysal/libpysal/issues/261) Unused code in weights.from_networkx()? 
* [#9:](https://github.com/pysal/libpysal/issues/9) redirect pysal/#934 to libpysal 
* [#35:](https://github.com/pysal/libpysal/issues/35) defaulting to using the dataframe index as the id set 
* [#23:](https://github.com/pysal/libpysal/issues/23) Handling coincident points in KNN 
* [#67:](https://github.com/pysal/libpysal/issues/67) MGWR_Georgia_example.ipynb fails due to different sample data shapes 
* [#47:](https://github.com/pysal/libpysal/issues/47) Kernel docstring does not mention unique Gaussian kernel behavior 
* [#69:](https://github.com/pysal/libpysal/issues/69) MGWR_Georgia_example.ipynb missing pickle import statement 
* [#99:](https://github.com/pysal/libpysal/issues/99) weights.Voronoi is a function, not a class.  
* [#121:](https://github.com/pysal/libpysal/issues/121) some weights util functions are lost in __ini__.py 
* [#150:](https://github.com/pysal/libpysal/pull/150) [ENH][WIP] Adding a `rasterW` to extract `W` from raster and align values 
* [#123:](https://github.com/pysal/libpysal/issues/123) Current weight plot method is time consuming for a large data set 
* [#151:](https://github.com/pysal/libpysal/issues/151) network kernel weights 
* [#208:](https://github.com/pysal/libpysal/issues/208) Weight Object Question 
* [#173:](https://github.com/pysal/libpysal/issues/173) Add `from_sparse` and `from_numpy` methods, to match the other `from_` methods 
* [#258:](https://github.com/pysal/libpysal/pull/258) ENH: setting up github actions 
* [#114:](https://github.com/pysal/libpysal/issues/114) deprecate or test shapely_ext 
* [#250:](https://github.com/pysal/libpysal/pull/250) Update reqs for tests 
* [#177:](https://github.com/pysal/libpysal/issues/177) Tests failures under Python 3.8 
* [#253:](https://github.com/pysal/libpysal/pull/253) Nbdocs 
* [#244:](https://github.com/pysal/libpysal/pull/244) Fix and simplify filter_adjlist. 
* [#240:](https://github.com/pysal/libpysal/pull/240) Remove calls to deprecated/removed time.clock. 
* [#242:](https://github.com/pysal/libpysal/pull/242) Fix syntax errors 
* [#243:](https://github.com/pysal/libpysal/pull/243) DOC: Fix invalid section headings. 
* [#249:](https://github.com/pysal/libpysal/issues/249) test_fiiter fails on 3.8 but passes on < 3.8 
* [#251:](https://github.com/pysal/libpysal/pull/251) 3.8 
* [#235:](https://github.com/pysal/libpysal/pull/235) rebuild docs; 
* [#219:](https://github.com/pysal/libpysal/issues/219) set up appveyor or circle ci for multiplatform testing 
* [#241:](https://github.com/pysal/libpysal/issues/241) Nose is unmaintained 
* [#248:](https://github.com/pysal/libpysal/issues/248) Add appveyor badge 
* [#247:](https://github.com/pysal/libpysal/pull/247) Appveyor 


<a name="access"></a>
### access
* [#9:](https://github.com/pysal/access/pull/9) dataset updates from Vidal 
* [#8:](https://github.com/pysal/access/pull/8) Update installation.rst 
* [#7:](https://github.com/pysal/access/pull/7) Conda install to docs -- all set. 
* [#6:](https://github.com/pysal/access/pull/6) Move to pysal 
* [#5:](https://github.com/pysal/access/issues/5) Tutorial links broken on docs site 
* [#4:](https://github.com/pysal/access/pull/4) ENH: syncing pysal/access  


<a name="esda"></a>
### esda
* [#137:](https://github.com/pysal/esda/pull/137) [BUG] remove README.rst 
* [#135:](https://github.com/pysal/esda/pull/135) [DOC] Update for 2.30 
* [#127:](https://github.com/pysal/esda/issues/127) Release notes for 2.3.0 
* [#134:](https://github.com/pysal/esda/pull/134) (BUG) missing comma in setup.py 
* [#124:](https://github.com/pysal/esda/pull/124) BUG: fix join_count contingency table 
* [#132:](https://github.com/pysal/esda/pull/132) Bump codecov/codecov-action from v1 to v1.0.10 
* [#131:](https://github.com/pysal/esda/pull/131) moving dependabot directory 
* [#130:](https://github.com/pysal/esda/pull/130) [ENH] Update README for coverage and testing badges 
* [#129:](https://github.com/pysal/esda/pull/129) adding dependabot 
* [#128:](https://github.com/pysal/esda/pull/128) [WIP, ENH] Moving to github actions for CI 
* [#116:](https://github.com/pysal/esda/pull/116) permutation inference performance using numba 
* [#120:](https://github.com/pysal/esda/pull/120) Adbscan fix 
* [#118:](https://github.com/pysal/esda/issues/118) Preferred style format of new ESDA estimators  
* [#112:](https://github.com/pysal/esda/issues/112) G_Local returns unexpectedly low z_sim for what should be a hotspot 
* [#115:](https://github.com/pysal/esda/pull/115) [WIP]: initial commit of ripley in numpy-oriented style 
* [#117:](https://github.com/pysal/esda/pull/117) Tweak README.md 
* [#113:](https://github.com/pysal/esda/pull/113) Memory efficient conditional permutation for LISA 
* [#114:](https://github.com/pysal/esda/pull/114) ENH: More efficient Geary implementation with new test data 
* [#84:](https://github.com/pysal/esda/issues/84) Develop separate notebooks for functionalilty 
* [#100:](https://github.com/pysal/esda/issues/100) by_col is failing in  test_by_col due to deprecation of from_item 
* [#48:](https://github.com/pysal/esda/issues/48) Join count tail-ness 
* [#99:](https://github.com/pysal/esda/issues/99) Noisy imports on 3.8 
* [#111:](https://github.com/pysal/esda/issues/111) DeprecationWarning when running spatial smoothing 
* [#94:](https://github.com/pysal/esda/pull/94) ADBSCAN 
* [#110:](https://github.com/pysal/esda/pull/110) DOC: fixing link in geosilhouettes notebook 
* [#108:](https://github.com/pysal/esda/pull/108) Allow failures on 3.8 when pulling from git for testing. 
* [#107:](https://github.com/pysal/esda/issues/107) Docs for esda not reachable  


<a name="giddy"></a>
### giddy
* [#157:](https://github.com/pysal/giddy/pull/157) (bug) pytest-runner is deprecated 
* [#158:](https://github.com/pysal/giddy/pull/158) version bump to v2.3.3 
* [#156:](https://github.com/pysal/giddy/pull/156) Prepare for releasing v2.3.2 as v2.3.1 is broken 
* [#155:](https://github.com/pysal/giddy/pull/155) Follow-up fixes for the automatic release of v2.3.1 with github actions 
* [#154:](https://github.com/pysal/giddy/pull/154) Prepare for a formal release of giddy v2.3.1 with GitHub actions 
* [#153:](https://github.com/pysal/giddy/pull/153) fix for github actions release (name of changelog) 
* [#152:](https://github.com/pysal/giddy/pull/152) GitHub actions (packing and releasing) - pack the updated changelog to the built distribution 
* [#151:](https://github.com/pysal/giddy/pull/151) Fixes for building and releasing with github actions 
* [#150:](https://github.com/pysal/giddy/pull/150) (bug) fix workflow of building and releasing  
* [#149:](https://github.com/pysal/giddy/pull/149) Name of the passwords are capitalized 
* [#148:](https://github.com/pysal/giddy/pull/148) Version bump for building and releasing with GitHub actions (testing) 
* [#147:](https://github.com/pysal/giddy/pull/147) Give a name to the continuous testing workflow 
* [#146:](https://github.com/pysal/giddy/pull/146) (bug) fix workflow of GitHub actions for building and releasing a package 
* [#145:](https://github.com/pysal/giddy/pull/145) release and publish with github actions 
* [#143:](https://github.com/pysal/giddy/pull/143) CI only testing against master branch 
* [#144:](https://github.com/pysal/giddy/pull/144) Update README 
* [#141:](https://github.com/pysal/giddy/pull/141) badges for CI with github actions and codecov 
* [#142:](https://github.com/pysal/giddy/pull/142) migrate from readthedocs to github page for docs hosting 
* [#140:](https://github.com/pysal/giddy/pull/140) fix docs (with nbsphinx) 
* [#139:](https://github.com/pysal/giddy/pull/139) Continuous integration using GitHub Actions 
* [#138:](https://github.com/pysal/giddy/pull/138) add requirements on quantecon (>=0.4.7) 
* [#137:](https://github.com/pysal/giddy/pull/137) code formatting with black 
* [#124:](https://github.com/pysal/giddy/issues/124) spatial_dynamics.interaction migration? 
* [#136:](https://github.com/pysal/giddy/pull/136) remove accidentally added testing notebook 
* [#132:](https://github.com/pysal/giddy/issues/132) Binder for examples is missing dependencies 
* [#135:](https://github.com/pysal/giddy/pull/135) (bug) adding missing dependencies for Binder  
* [#133:](https://github.com/pysal/giddy/issues/133) output for classic Markov needs slight rewording 
* [#134:](https://github.com/pysal/giddy/pull/134) rewording summary output for Markov chains 


<a name="inequality"></a>
### inequality


<a name="pointpats"></a>
### pointpats
* [#59:](https://github.com/pysal/pointpats/pull/59) [ENH] Version bump for 2.2 and pointer to changelog 
* [#58:](https://github.com/pysal/pointpats/pull/58) make quadrat statistics accept a numpy array as argument 
* [#56:](https://github.com/pysal/pointpats/pull/56) add numba-fied version of skyum code 
* [#54:](https://github.com/pysal/pointpats/pull/54) Ripley numpy 
* [#48:](https://github.com/pysal/pointpats/pull/48) #47 : Added enhancements to mbr in pointpats 
* [#55:](https://github.com/pysal/pointpats/issues/55) intensity estimates for new ripley functions are very incorrect sometimes 
* [#53:](https://github.com/pysal/pointpats/pull/53) (doc) add inline docstring for the equation of L function 
* [#44:](https://github.com/pysal/pointpats/issues/44) (BUG) L function and its Simulation Envelope under the null (CSR) not close to 0 
* [#46:](https://github.com/pysal/pointpats/pull/46) (bug) fix for calculating rule of thumb (rot) for a point pattern 


<a name="segregation"></a>
### segregation
* [#147:](https://github.com/pysal/segregation/pull/147) update crs checking for newer pyproj 
* [#96:](https://github.com/pysal/segregation/issues/96) warn for indices that expect certain projections 
* [#145:](https://github.com/pysal/segregation/issues/145) update tests to use new libpysal examples 
* [#134:](https://github.com/pysal/segregation/issues/134) Add  Bibtex citation in readme 
* [#143:](https://github.com/pysal/segregation/issues/143) segregation raising warning in pysal meta package 


<a name="spaghetti"></a>
### spaghetti
* [#487:](https://github.com/pysal/spaghetti/issues/487) GHA for release and publish 
* [#489:](https://github.com/pysal/spaghetti/pull/489) Attempting GHA release workflow #2 
* [#488:](https://github.com/pysal/spaghetti/pull/488) Attempting GHA release workflow 
* [#486:](https://github.com/pysal/spaghetti/pull/486) Version bump for release v1.5.0.rc0 
* [#469:](https://github.com/pysal/spaghetti/issues/469) [WIP] Update Network K Function 
* [#478:](https://github.com/pysal/spaghetti/issues/478) Break spatial analysis tutorial into several notebooks 
* [#477:](https://github.com/pysal/spaghetti/pull/477) Update, review, and rename K statistic 
* [#485:](https://github.com/pysal/spaghetti/pull/485)  toy PR to test codecov.yml 
* [#484:](https://github.com/pysal/spaghetti/pull/484) toy PR to test tcodecov.yml 
* [#481:](https://github.com/pysal/spaghetti/issues/481) treebeard CI 
* [#483:](https://github.com/pysal/spaghetti/pull/483) Docs funding 
* [#479:](https://github.com/pysal/spaghetti/pull/479) [WIP] Dropping "change" param in codecov.yml 
* [#480:](https://github.com/pysal/spaghetti/issues/480) Add funding source? 
* [#482:](https://github.com/pysal/spaghetti/pull/482) add funding sources to README 
* [#471:](https://github.com/pysal/spaghetti/pull/471) [Bug] Addressing bug in K-Function formation 
* [#476:](https://github.com/pysal/spaghetti/pull/476) Revert "[Bug] Addressing bug in K-Function formation" 
* [#470:](https://github.com/pysal/spaghetti/issues/470) [BUG] Correction to NetworkK formulation 
* [#472:](https://github.com/pysal/spaghetti/issues/472) [TST] add codecov.yml 
* [#475:](https://github.com/pysal/spaghetti/pull/475) no post until 24 codecov reports 
* [#474:](https://github.com/pysal/spaghetti/pull/474) attempting custom codecov reports 
* [#473:](https://github.com/pysal/spaghetti/pull/473) update install docs 
* [#467:](https://github.com/pysal/spaghetti/issues/467) Network L Function 
* [#466:](https://github.com/pysal/spaghetti/issues/466) Remove G and F functions 
* [#468:](https://github.com/pysal/spaghetti/pull/468) Removing G and F functions 
* [#442:](https://github.com/pysal/spaghetti/issues/442) [TEST] regular 3x3 lattice for network analysis testing 
* [#465:](https://github.com/pysal/spaghetti/pull/465) DOC: correct comments for K-function related code 
* [#464:](https://github.com/pysal/spaghetti/pull/464) Updating docs with new sphinx release 
* [#463:](https://github.com/pysal/spaghetti/pull/463) Remedy for non-transparent favicon 
* [#462:](https://github.com/pysal/spaghetti/pull/462) stylize the minimum spanning tree plot in README.md 
* [#461:](https://github.com/pysal/spaghetti/pull/461) Updating pinned requirements versions 
* [#460:](https://github.com/pysal/spaghetti/pull/460) Streamling GHA 
* [#449:](https://github.com/pysal/spaghetti/issues/449) [ENH] Functionality for spanning trees 
* [#459:](https://github.com/pysal/spaghetti/pull/459) [ENH][WIP] Min/Max Spanning Trees functionality 
* [#458:](https://github.com/pysal/spaghetti/pull/458) Update Python version support in CONTRIBUTING.md 
* [#457:](https://github.com/pysal/spaghetti/pull/457) Adding network arc spatial weights notebook 
* [#454:](https://github.com/pysal/spaghetti/issues/454) Appveyor still being triggered 
* [#456:](https://github.com/pysal/spaghetti/pull/456) Corrections for Caveat notebook 
* [#455:](https://github.com/pysal/spaghetti/pull/455) CHANGELOG.txt --> CHANGELOG.md 
* [#453:](https://github.com/pysal/spaghetti/pull/453) [TST] GitHub Actions only; Migrate away from Travis/Appveyor 
* [#452:](https://github.com/pysal/spaghetti/pull/452) Customizing/improving GitHub Actions 
* [#451:](https://github.com/pysal/spaghetti/pull/451) Trying out GitHub Actions for additional testing 
* [#426:](https://github.com/pysal/spaghetti/issues/426) [ENH] caveats notebook 
* [#445:](https://github.com/pysal/spaghetti/pull/445) [WIP][ENH] New notebook for caveats 
* [#404:](https://github.com/pysal/spaghetti/issues/404) release v1.4.3 
* [#448:](https://github.com/pysal/spaghetti/pull/448) logo update, rearrange 
* [#447:](https://github.com/pysal/spaghetti/pull/447) updating README logo 
* [#427:](https://github.com/pysal/spaghetti/issues/427) package import warning? 
* [#444:](https://github.com/pysal/spaghetti/pull/444) Improved docstrings for NetworkF and NetworkG 
* [#225:](https://github.com/pysal/spaghetti/issues/225) analysis.ffunction() may not be correct 
* [#438:](https://github.com/pysal/spaghetti/issues/438) [MAINT] re-evaluate testing structure 
* [#443:](https://github.com/pysal/spaghetti/pull/443) [TST] Updating tests and testing structure 
* [#441:](https://github.com/pysal/spaghetti/pull/441) moving watermark to notebook reqs 
* [#436:](https://github.com/pysal/spaghetti/issues/436) appveyor — rebuild the master 3.8 PYPI 
* [#439:](https://github.com/pysal/spaghetti/pull/439) [MAINT] DRYing off unittests 
* [#434:](https://github.com/pysal/spaghetti/issues/434) Docs for v1.4.2.post1 were not rebuilt 
* [#435:](https://github.com/pysal/spaghetti/pull/435) rebuilding docs for post release 
* [#392:](https://github.com/pysal/spaghetti/issues/392) release v1.4.2 
* [#433:](https://github.com/pysal/spaghetti/pull/433) pushing changelog for 1.4.2post1 
* [#432:](https://github.com/pysal/spaghetti/pull/432) version bump v1.4.2 --> 1.4.2post1 
* [#431:](https://github.com/pysal/spaghetti/pull/431) fixing conda-forge failure 
* [#430:](https://github.com/pysal/spaghetti/pull/430) final PR before v1.4.2 release — updating CHANGELOG.md 
* [#429:](https://github.com/pysal/spaghetti/pull/429) updating README 
* [#424:](https://github.com/pysal/spaghetti/pull/424) [WIP][ENH] longest and largest network components 
* [#425:](https://github.com/pysal/spaghetti/issues/425) Add a fully connected attribute 
* [#414:](https://github.com/pysal/spaghetti/issues/414) [ENH] longest/largest connected component 
* [#345:](https://github.com/pysal/spaghetti/issues/345) add logos to website 
* [#428:](https://github.com/pysal/spaghetti/pull/428) attempting fast finish again 
* [#423:](https://github.com/pysal/spaghetti/pull/423) pushing fix for environment.yml 
* [#422:](https://github.com/pysal/spaghetti/pull/422) Add 3.8 as a supported Python version in docs 
* [#416:](https://github.com/pysal/spaghetti/issues/416) [ENH] matplotlib-scalebar for notebooks/binders 
* [#421:](https://github.com/pysal/spaghetti/pull/421) using a true scalebar in notebook plots 
* [#413:](https://github.com/pysal/spaghetti/issues/413) [REQ] requirements for notebooks/binders? 
* [#420:](https://github.com/pysal/spaghetti/pull/420) adding notebook reqs files 
* [#407:](https://github.com/pysal/spaghetti/issues/407) support multiplatform testing 
* [#419:](https://github.com/pysal/spaghetti/pull/419) make sure data set is downloaded for appveyor.yml 
* [#418:](https://github.com/pysal/spaghetti/pull/418) [ENH] moving towards multi-platform testing 
* [#417:](https://github.com/pysal/spaghetti/issues/417) Migrate testing functionality from nose to pytest 
* [#322:](https://github.com/pysal/spaghetti/issues/322) [On Hold] too many emails from Travis CI 


<a name="mgwr"></a>
### mgwr


<a name="spglm"></a>
### spglm


<a name="spint"></a>
### spint


<a name="spreg"></a>
### spreg
* [#36:](https://github.com/pysal/spreg/pull/36) release prep 
* [#35:](https://github.com/pysal/spreg/pull/35) Allowing single dimensions array as y and fixing BaseGM_Lag 
* [#34:](https://github.com/pysal/spreg/pull/34) use flatten instead of setting shape directly 


<a name="spvcm"></a>
### spvcm


<a name="tobler"></a>
### tobler
* [#77:](https://github.com/pysal/tobler/pull/77) bump version 
* [#75:](https://github.com/pysal/tobler/issues/75) Correct testing in unittests.yml? 
* [#76:](https://github.com/pysal/tobler/pull/76) Fix tests 
* [#74:](https://github.com/pysal/tobler/pull/74) add ci dir 
* [#73:](https://github.com/pysal/tobler/pull/73) update testing/publishing infrastructure 
* [#71:](https://github.com/pysal/tobler/pull/71) Closes #68. 
* [#68:](https://github.com/pysal/tobler/issues/68) Problem running area_interpolate with both intensive and extensive vars 
* [#67:](https://github.com/pysal/tobler/issues/67) ImportError: cannot import name 'CRS' from 'pyproj'  
* [#50:](https://github.com/pysal/tobler/issues/50) crs checking 
* [#66:](https://github.com/pysal/tobler/issues/66) Breakage upstream possibly due to refactor on data? 
* [#63:](https://github.com/pysal/tobler/issues/63) dateutil pinning causing problems upstream 
* [#65:](https://github.com/pysal/tobler/pull/65) prep v0.3 release 
* [#64:](https://github.com/pysal/tobler/pull/64) Simplify deps 
* [#10:](https://github.com/pysal/tobler/issues/10) add more tests 
* [#49:](https://github.com/pysal/tobler/issues/49) handle remote rasters 
* [#62:](https://github.com/pysal/tobler/pull/62) update changelog 
* [#61:](https://github.com/pysal/tobler/pull/61) version bump 
* [#60:](https://github.com/pysal/tobler/pull/60) update quilt pin 
* [#59:](https://github.com/pysal/tobler/pull/59) allow specifying path for quilt storage 
* [#58:](https://github.com/pysal/tobler/pull/58) TEST: 3.8 testing 
* [#57:](https://github.com/pysal/tobler/pull/57) update docs 
* [#56:](https://github.com/pysal/tobler/pull/56) update changelog 
* [#54:](https://github.com/pysal/tobler/issues/54) small reorg 
* [#55:](https://github.com/pysal/tobler/pull/55) reorg: adding model submodule 
* [#53:](https://github.com/pysal/tobler/pull/53) bump version for bugfix release 
* [#52:](https://github.com/pysal/tobler/pull/52) quilt handling 


<a name="mapclassify"></a>
### mapclassify
* [#77:](https://github.com/pysal/mapclassify/pull/77) Make networkx optional, remove xfail from greedy 
* [#56:](https://github.com/pysal/mapclassify/issues/56) Extra files in PyPI sdist 
* [#85:](https://github.com/pysal/mapclassify/pull/85) MAINT: fix repos name 
* [#84:](https://github.com/pysal/mapclassify/pull/84) DOC: content type for long description 
* [#83:](https://github.com/pysal/mapclassify/pull/83) MAINT: update gitcount notebook 
* [#63:](https://github.com/pysal/mapclassify/issues/63) Update documentations to include tutorial 
* [#71:](https://github.com/pysal/mapclassify/issues/71) build binder for notebooks 
* [#70:](https://github.com/pysal/mapclassify/issues/70)  current version of mapclassify in docs?  
* [#79:](https://github.com/pysal/mapclassify/issues/79) 404 for notebook/tutorials links in docs 
* [#82:](https://github.com/pysal/mapclassify/pull/82) DOC: figs 
* [#81:](https://github.com/pysal/mapclassify/pull/81) DOCS: new images for tutorial 
* [#80:](https://github.com/pysal/mapclassify/pull/80) DOC: missing figs 
* [#78:](https://github.com/pysal/mapclassify/pull/78) DOCS: update documentation pages 
* [#76:](https://github.com/pysal/mapclassify/pull/76) BINDER: point to upstream 
* [#75:](https://github.com/pysal/mapclassify/pull/75) add binder badge 
* [#74:](https://github.com/pysal/mapclassify/pull/74) Binder 
* [#73:](https://github.com/pysal/mapclassify/issues/73) `sys` import missing from setup.py 
* [#66:](https://github.com/pysal/mapclassify/pull/66) [WIP] DOC: Updating tutorial 
* [#27:](https://github.com/pysal/mapclassify/issues/27) chorobrewer branch has begun 
* [#68:](https://github.com/pysal/mapclassify/issues/68) Is mapclassify code black? 
* [#69:](https://github.com/pysal/mapclassify/pull/69) Code format and README 
* [#65:](https://github.com/pysal/mapclassify/pull/65) Migrate to GHA 
* [#64:](https://github.com/pysal/mapclassify/issues/64) Move testing over to github actions 
* [#67:](https://github.com/pysal/mapclassify/issues/67) Add [pinning](https://github.com/pysal/mapclassify/pull/59#issuecomment-602255474) in pooled example documentation 
* [#51:](https://github.com/pysal/mapclassify/issues/51) Add a Pooled classifier 
* [#48:](https://github.com/pysal/mapclassify/issues/48) Backwards compatability 
* [#62:](https://github.com/pysal/mapclassify/issues/62) Difference between Natural Breaks and Fisher Jenks schemes 
* [#61:](https://github.com/pysal/mapclassify/pull/61) ENH: add greedy (topological) coloring 
* [#60:](https://github.com/pysal/mapclassify/issues/60) Error while running mapclassify 
* [#59:](https://github.com/pysal/mapclassify/pull/59) Pooled 
* [#57:](https://github.com/pysal/mapclassify/issues/57) Invalid escape sequences in strings 
* [#58:](https://github.com/pysal/mapclassify/pull/58) 3.8, appveyor, deprecation fixes 


<a name="splot"></a>
### splot
* [#103:](https://github.com/pysal/splot/pull/103) Release1.1.3 
* [#102:](https://github.com/pysal/splot/pull/102) add permanent links to current version of no's to joss paper 
* [#101:](https://github.com/pysal/splot/pull/101) [BUG] set colors as list in _plot_choropleth_fig() 
* [#99:](https://github.com/pysal/splot/pull/99) Remove the links around figures in the JOSS paper 


## Contributors

Thanks to all the individuals who have contributed to this release:

- Arfon Smith
- Bryan Bennett
- Dani Arribas-Bel
- Eli Knaap
- Elliott Sales De Andrade
- James Gaboardi
- Jamie Saxon
- Jeffery Sauer
- Jkoschinsky
- Levi John Wolf
- Martin Fleischmann
- Pattyf
- Pedro Amaral
- Serge Rey
- Stefanie Lumnitz
- Sugam Srivastava
- Vidal-Anguiano
- Wagner
- Wei Kang


# PySAL 2.2.0, 2020-01-31

PySAL 2.2.0 represents 6 months of enhancements, bug-fixes, widening of test coverage, and improved documentation. All users are encouraged to upgrade to this version as there are numerous optimizations as well as new features (see below) that have been implemented.

## Major Highlights of PySAL 2.2.0

### Meta-package looses some serious weight
PySAL is no longer a source release meta-package, but instead specifies the packages in the PySAL ecosystem as dependencies. This means that installing the `pysal` meta-package will ensure that all the subpackages are installed.

### Entirely New Packages

In this release, the PySAL family has expanded to include:

- `tobler`  **Areal interpolation and dasymetric mapping**.

### Enhancements to Existing Packages

* Refactoring of [pysal/libpysal](https://github.com/pysal/libpysal) to use remote example data sets which reduces the footprint of the source install from 25mb to under 3mb. Remote examples can now be examined with interactive maps if being run in Jupyter Notebookss.
* [pysal/mapclassify](https://github.com/pysal/mapclassify): Choropleth legend formatting has been enhanced to permit more granular control of legends.
* others here
* and here
* and here


## Changes by Package

Overall, there were 646 commits that closed 163 issues, together with 105 pull requests since our last release on 2019-07-29.


<a name="libpysal"></a>
### libpysal
* [#216:](https://github.com/pysal/libpysal/issues/216) alpha_shapes docs not rendering 
* [#217:](https://github.com/pysal/libpysal/pull/217) corrected docstrings in cg.alpha_shapes.py 
* [#211:](https://github.com/pysal/libpysal/pull/211) Updating requirements 
* [#174:](https://github.com/pysal/libpysal/issues/174) Big tarball 
* [#176:](https://github.com/pysal/libpysal/pull/176) Fetch 
* [#125:](https://github.com/pysal/libpysal/pull/125) metadata for examples  
* [#209:](https://github.com/pysal/libpysal/pull/209) DOC: math rendering in sphinx, and members included for W 
* [#210:](https://github.com/pysal/libpysal/pull/210) (docs) automatically generate docstrings for class members 
* [#207:](https://github.com/pysal/libpysal/pull/207) (docs) keep file .nojekyll in docs when syncing between docs/ and docsrc/_build/html/ 
* [#206:](https://github.com/pysal/libpysal/pull/206) (bug) replace silent_island_warning with silence_warnings for weights 
* [#205:](https://github.com/pysal/libpysal/issues/205) Documentation does not work 
* [#203:](https://github.com/pysal/libpysal/pull/203) updating cg.standalone.distance_matrix docs 
* [#195:](https://github.com/pysal/libpysal/issues/195) error message in cg.standalone.distance_matrix() 
* [#202:](https://github.com/pysal/libpysal/pull/202) improved docs in io.util.shapefile 
* [#201:](https://github.com/pysal/libpysal/pull/201) [ENH] moving jit import to common.py / improve documentation 
* [#199:](https://github.com/pysal/libpysal/issues/199) rearrange shapely import in cg.alpha_shapes 
* [#200:](https://github.com/pysal/libpysal/pull/200) fix quasi-redundant import of shapely 
* [#196:](https://github.com/pysal/libpysal/pull/196) Remove more relics (from pre-reorg PySAL) 
* [#197:](https://github.com/pysal/libpysal/issues/197) [BUG] alpha_shapes/shapely import error 
* [#198:](https://github.com/pysal/libpysal/pull/198) [BUG] correcting shapely import bug 
* [#194:](https://github.com/pysal/libpysal/issues/194) README.txt refers to pre-reorg PySAL 
* [#147:](https://github.com/pysal/libpysal/issues/147) remove `distribute_setup.py`? 
* [#128:](https://github.com/pysal/libpysal/issues/128) requires() decorator for libpysal.cg.alpha_shapes 
* [#129:](https://github.com/pysal/libpysal/pull/129) decorating functions with requires() 
* [#193:](https://github.com/pysal/libpysal/pull/193) [WIP] removing unused relics 
* [#191:](https://github.com/pysal/libpysal/issues/191) necessity of libpysal.common.iteritems()? 
* [#192:](https://github.com/pysal/libpysal/pull/192) removing iteritems decorator 
* [#189:](https://github.com/pysal/libpysal/issues/189) Voronoi results in weights of different shape than input points 
* [#190:](https://github.com/pysal/libpysal/pull/190) BUG: alpha_shape_auto can fail to contain all points in the set. 
* [#185:](https://github.com/pysal/libpysal/issues/185) WSP(sparse).to_W() has `array`s in weights,neighbors dictionaries, rather than lists.  
* [#186:](https://github.com/pysal/libpysal/pull/186) Cast arrays as lists (Issue 185)  
* [#188:](https://github.com/pysal/libpysal/pull/188) BUG: Update for geopandas use of GeometryArray 
* [#187:](https://github.com/pysal/libpysal/pull/187) Updated documentation error (link incorrectly specified) in README.rst  
* [#182:](https://github.com/pysal/libpysal/pull/182) Docs: badges for pypi 
* [#178:](https://github.com/pysal/libpysal/issues/178) development guidelines link failure 
* [#181:](https://github.com/pysal/libpysal/pull/181) DOCS: moving off rtd 
* [#180:](https://github.com/pysal/libpysal/pull/180) REL 4.1.1 bf release 
* [#179:](https://github.com/pysal/libpysal/pull/179) BUG: Updating manifest for additional requirements files 
* [#169:](https://github.com/pysal/libpysal/issues/169) libpysal 4.1.0 is not released on pypi or conda-forge 
* [#131:](https://github.com/pysal/libpysal/issues/131) addressing DeprecationWarning: fromstring() 
* [#175:](https://github.com/pysal/libpysal/pull/175) ENH: fromstring has been deprecated 
* [#132:](https://github.com/pysal/libpysal/pull/132) addressing DeprecationWarning: fromstring() 
* [#172:](https://github.com/pysal/libpysal/pull/172) Ci 


<a name="esda"></a>
### esda
* [#87:](https://github.com/pysal/esda/issues/87) development guidelines link in README.md and README.rst 
* [#92:](https://github.com/pysal/esda/issues/92) `PYSAL_PYPI` is not defined in `.travis.yml` 
* [#93:](https://github.com/pysal/esda/pull/93) addressing #92 -- .travis.yml issue 
* [#88:](https://github.com/pysal/esda/pull/88) resolving dev guidelines link 
* [#80:](https://github.com/pysal/esda/issues/80) Update officially supported Python versions 
* [#74:](https://github.com/pysal/esda/pull/74) ENH - Join count tails 
* [#83:](https://github.com/pysal/esda/pull/83) DOC: Have notebooks show output in the src 
* [#82:](https://github.com/pysal/esda/issues/82) no output in documentation notebooks 


<a name="giddy"></a>
### giddy
* [#126:](https://github.com/pysal/giddy/pull/126) travis CI: pip install from git clone 
* [#125:](https://github.com/pysal/giddy/pull/125) rewrite utility function "get_lower" using numpy's more efficient functionality 
* [#121:](https://github.com/pysal/giddy/issues/121) Release version 2.2.2 for bug fix  
* [#123:](https://github.com/pysal/giddy/pull/123) prepare for new release: version 2.2.2  
* [#122:](https://github.com/pysal/giddy/pull/122) remove the parameter in plt.show() due to the API change in Matplotlib (deprecation) 
* [#119:](https://github.com/pysal/giddy/issues/119) development guidelines link in README.md 
* [#118:](https://github.com/pysal/giddy/pull/118) BUG: Fix for correct handling of ties in Tau 
* [#120:](https://github.com/pysal/giddy/pull/120) resolving broken dev link 
* [#117:](https://github.com/pysal/giddy/issues/117) initialization of ECount parameter in Kendall's Tau 
* [#116:](https://github.com/pysal/giddy/pull/116) (bug) debug travis-ci  


<a name="inequality"></a>
### inequality


<a name="pointpats"></a>
### pointpats


<a name="segregation"></a>
### segregation


<a name="spaghetti"></a>
### spaghetti
* [#350:](https://github.com/pysal/spaghetti/pull/350) Revert "order analysis.py classes/functions alphabetically" 
* [#349:](https://github.com/pysal/spaghetti/pull/349) order analysis.py classes/functions alphabetically 
* [#347:](https://github.com/pysal/spaghetti/pull/347) updating requirement_dev.txt 
* [#348:](https://github.com/pysal/spaghetti/pull/348) update README.md 
* [#343:](https://github.com/pysal/spaghetti/issues/343) tarball jobs failing on Travis 
* [#344:](https://github.com/pysal/spaghetti/pull/344) updating README.md 
* [#339:](https://github.com/pysal/spaghetti/pull/339) links in the docs,reviewed  
* [#336:](https://github.com/pysal/spaghetti/issues/336) automatically generate docstrings for class members 
* [#337:](https://github.com/pysal/spaghetti/pull/337) Update docs 
* [#335:](https://github.com/pysal/spaghetti/pull/335) Updating .travis.yml 
* [#334:](https://github.com/pysal/spaghetti/pull/334) fix indentation in `.travis.yml` 
* [#331:](https://github.com/pysal/spaghetti/pull/331) update README.md badges 
* [#327:](https://github.com/pysal/spaghetti/issues/327) Citation stipulation for notebooks 
* [#329:](https://github.com/pysal/spaghetti/pull/329) Notebooks update part 2 
* [#328:](https://github.com/pysal/spaghetti/pull/328) Notebooks update 
* [#324:](https://github.com/pysal/spaghetti/issues/324) update email address in notebooks 
* [#325:](https://github.com/pysal/spaghetti/issues/325) Plotting error in Facility_Location.ipynb 
* [#326:](https://github.com/pysal/spaghetti/pull/326) Updating Notebooks 
* [#323:](https://github.com/pysal/spaghetti/issues/323) module 'pysal.explore.spaghetti' has no attribute 'element_as_gdf' 
* [#318:](https://github.com/pysal/spaghetti/issues/318) [ENH] util.compute_length() — DRY 
* [#319:](https://github.com/pysal/spaghetti/pull/319) swapping out distance calculation function 
* [#317:](https://github.com/pysal/spaghetti/pull/317) adjusting snapping image in README.md 
* [#315:](https://github.com/pysal/spaghetti/issues/315) inaccurate documentation — Network.split_arcs() 
* [#316:](https://github.com/pysal/spaghetti/pull/316) Split arcs update 
* [#313:](https://github.com/pysal/spaghetti/issues/313) streamline badges in README.md 
* [#314:](https://github.com/pysal/spaghetti/pull/314) streaming badges on README.md 
* [#312:](https://github.com/pysal/spaghetti/pull/312) adding +travis to notification recipients 
* [#309:](https://github.com/pysal/spaghetti/issues/309) broken "development guidelines" link 
* [#311:](https://github.com/pysal/spaghetti/pull/311) updating broken dev link 
* [#299:](https://github.com/pysal/spaghetti/issues/299) Update Travis CI schema 
* [#308:](https://github.com/pysal/spaghetti/pull/308) Update travis CI for new testing schema 
* [#310:](https://github.com/pysal/spaghetti/pull/310) adding static docs badge 
* [#288:](https://github.com/pysal/spaghetti/issues/288) mock c modules for doc dependencies 
* [#306:](https://github.com/pysal/spaghetti/issues/306) doi missing from citation 
* [#307:](https://github.com/pysal/spaghetti/pull/307) adding Zenodo DOI to README.md and website 
* [#305:](https://github.com/pysal/spaghetti/pull/305) blackify setup.py 
* [#301:](https://github.com/pysal/spaghetti/issues/301) Change Read the Docs to GitHub? 
* [#304:](https://github.com/pysal/spaghetti/pull/304) updating README to reflect GitHub docs 
* [#303:](https://github.com/pysal/spaghetti/pull/303) switching to github docs as per #301 
* [#302:](https://github.com/pysal/spaghetti/issues/302) get_versions() function 
* [#293:](https://github.com/pysal/spaghetti/issues/293) code formatting with black 
* [#300:](https://github.com/pysal/spaghetti/pull/300) blackifying code (#293) 


<a name="mgwr"></a>
### mgwr


<a name="spglm"></a>
### spglm


<a name="spint"></a>
### spint


<a name="spreg"></a>
### spreg


<a name="spvcm"></a>
### spvcm


<a name="tobler"></a>
### tobler
* [#43:](https://github.com/pysal/tobler/pull/43) update docs 
* [#40:](https://github.com/pysal/tobler/pull/40) return dfs 
* [#42:](https://github.com/pysal/tobler/pull/42) Move example data to remotes 
* [#41:](https://github.com/pysal/tobler/issues/41) revisit regression approach 
* [#36:](https://github.com/pysal/tobler/issues/36) generalize regression approach 
* [#38:](https://github.com/pysal/tobler/issues/38) License? 
* [#34:](https://github.com/pysal/tobler/issues/34) wrapper for regression approach 
* [#39:](https://github.com/pysal/tobler/pull/39) update docs 
* [#9:](https://github.com/pysal/tobler/issues/9) sphinx docs 
* [#37:](https://github.com/pysal/tobler/pull/37) remove shap and xgboost as hard deps 
* [#35:](https://github.com/pysal/tobler/pull/35) cosmetic upgrades 
* [#33:](https://github.com/pysal/tobler/pull/33) reorg and add masked_area_interpolate func 
* [#31:](https://github.com/pysal/tobler/pull/31) Move data into data direcotry for examples 
* [#32:](https://github.com/pysal/tobler/pull/32) Environment 
* [#8:](https://github.com/pysal/tobler/issues/8) decide on working notebooks 
* [#30:](https://github.com/pysal/tobler/pull/30) Reorg 
* [#29:](https://github.com/pysal/tobler/pull/29) fix for quilt dep clash 
* [#28:](https://github.com/pysal/tobler/issues/28) quilt3 breakage 
* [#26:](https://github.com/pysal/tobler/pull/26) raise ioerror 
* [#24:](https://github.com/pysal/tobler/pull/24) raise IOError if rasters are missing 
* [#25:](https://github.com/pysal/tobler/pull/25) Rel01 
* [#23:](https://github.com/pysal/tobler/pull/23) add xgboost approach in tests 
* [#22:](https://github.com/pysal/tobler/pull/22) update readme image from harmonize notebook 
* [#21:](https://github.com/pysal/tobler/pull/21) Add raster regression tests (also small tweak in a notebook) 
* [#20:](https://github.com/pysal/tobler/pull/20) handle "file://" in raster path 
* [#19:](https://github.com/pysal/tobler/pull/19) add quilt dependency 
* [#18:](https://github.com/pysal/tobler/pull/18) extra reqs files 
* [#17:](https://github.com/pysal/tobler/pull/17) update travis 
* [#16:](https://github.com/pysal/tobler/issues/16) turn on travis 
* [#15:](https://github.com/pysal/tobler/pull/15) swap to pytest tests 
* [#14:](https://github.com/pysal/tobler/pull/14) fix url and keywords from setup.py 
* [#13:](https://github.com/pysal/tobler/pull/13) tweak badge link 
* [#12:](https://github.com/pysal/tobler/pull/12) add build and coverage badges in readme 
* [#7:](https://github.com/pysal/tobler/pull/7) remove local paths 
* [#5:](https://github.com/pysal/tobler/pull/5) Drop scanlines (and harmonize) and improve notebooks and include tobler examples notebook (also adds tests and create travis file) 
* [#1:](https://github.com/pysal/tobler/issues/1) put NLCD as default for raster data 
* [#4:](https://github.com/pysal/tobler/pull/4) default to nlcd data from quilt 
* [#3:](https://github.com/pysal/tobler/pull/3) keep input crs 


<a name="mapclassify"></a>
### mapclassify
* [#54:](https://github.com/pysal/mapclassify/pull/54) 2.2 
* [#53:](https://github.com/pysal/mapclassify/pull/53) 2.2 
* [#52:](https://github.com/pysal/mapclassify/issues/52) conda-forge UnsatisfiableError on windows and python 3.7 
* [#49:](https://github.com/pysal/mapclassify/pull/49) [MAINT] updating supported Python versions in setup.py 
* [#46:](https://github.com/pysal/mapclassify/pull/46) BUG: RecursiveError in HeadTailBreaks 
* [#45:](https://github.com/pysal/mapclassify/issues/45) BUG: HeadTailBreaks raise RecursionError 
* [#47:](https://github.com/pysal/mapclassify/pull/47) BUG: UserDefined accepts only list if max not in bins 
* [#44:](https://github.com/pysal/mapclassify/pull/44) BUG: avoid deprecation warning in HeadTailBreaks 
* [#42:](https://github.com/pysal/mapclassify/issues/42) remove docs badge 
* [#43:](https://github.com/pysal/mapclassify/pull/43) Remove doc badge 
* [#41:](https://github.com/pysal/mapclassify/pull/41) Docs: moving to project pages on github and off rtd 


<a name="splot"></a>
### splot
* [#83:](https://github.com/pysal/splot/issues/83) [BUG] vba_choropleth failure 
* [#95:](https://github.com/pysal/splot/pull/95) BUG: Fix breakage due to mapclassify deprecation 
* [#93:](https://github.com/pysal/splot/pull/93) addressing pysal/pysal#1145 & adapting testing examples 
* [#89:](https://github.com/pysal/splot/pull/89) Fix docstring for plot_spatial_weights 
* [#59:](https://github.com/pysal/splot/issues/59) JOSS paper submission 
* [#87:](https://github.com/pysal/splot/pull/87) Fix format for multiple citations in JOSS paper 
* [#86:](https://github.com/pysal/splot/pull/86) Joss paper, finalise title 
* [#62:](https://github.com/pysal/splot/pull/62) [JOSS] work on `paper.md` 
* [#85:](https://github.com/pysal/splot/pull/85) [ENH] change doc badge to latest doc 
* [#84:](https://github.com/pysal/splot/pull/84) [BUG] require geopandas>=0.4.0,<=0.6.0rc1 for vba_choropleth testing 
* [#82:](https://github.com/pysal/splot/issues/82) `plot_moran_simulation` weird dimensions 

<a name="summary-statistics"></a>
## Summary Statistics

<a name="package-activity"></a>
### Package Activity
<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th>package</th>
      <th>commits</th>
      <th>total issues</th>
      <th>pulls</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>tobler</td>
      <td>178</td>
      <td>38</td>
      <td>29</td>
    </tr>
    <tr>
      <td>spaghetti</td>
      <td>172</td>
      <td>42</td>
      <td>25</td>
    </tr>
    <tr>
      <td>libpysal</td>
      <td>170</td>
      <td>43</td>
      <td>24</td>
    </tr>
    <tr>
      <td>splot</td>
      <td>42</td>
      <td>11</td>
      <td>8</td>
    </tr>
    <tr>
      <td>mapclassify</td>
      <td>32</td>
      <td>11</td>
      <td>8</td>
    </tr>
    <tr>
      <td>giddy</td>
      <td>31</td>
      <td>10</td>
      <td>7</td>
    </tr>
    <tr>
      <td>esda</td>
      <td>21</td>
      <td>8</td>
      <td>4</td>
    </tr>
    <tr>
      <td>inequality</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <td>pointpats</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <td>segregation</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <td>mgwr</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <td>spglm</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <td>spint</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <td>spreg</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <td>spvcm</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
  </tbody>
</table>

<a name="contributor-activity"></a>
### Contributor Activity
<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>commits</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>Eli Knaap</th>
      <td>98</td>
    </tr>
    <tr>
      <th>James Gaboardi</th>
      <td>217</td>
    </tr>
    <tr>
      <th>Leonardo Uieda</th>
      <td>1</td>
    </tr>
    <tr>
      <th>Levi John Wolf</th>
      <td>7</td>
    </tr>
    <tr>
      <th>Martin Fleischmann</th>
      <td>4</td>
    </tr>
    <tr>
      <th>Rahul799</th>
      <td>2</td>
    </tr>
    <tr>
      <th>Renan Xavier Cortes</th>
      <td>41</td>
    </tr>
    <tr>
      <th>Serge Rey</th>
      <td>176</td>
    </tr>
    <tr>
      <th>Siddharths8212376</th>
      <td>2</td>
    </tr>
    <tr>
      <th>Stefanie Lumnitz</th>
      <td>24</td>
    </tr>
    <tr>
      <th>Wei Kang</th>
      <td>35</td>
    </tr>
  </tbody>
</table>

<a name="contributor-by-package-activity"></a>
### Contributor by Package Activity
<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>Serge Rey</th>
      <th>James Gaboardi</th>
      <th>Levi John Wolf</th>
      <th>Wei Kang</th>
      <th>Siddharths8212376</th>
      <th>Rahul799</th>
      <th>Eli Knaap</th>
      <th>Renan Xavier Cortes</th>
      <th>Martin Fleischmann</th>
      <th>Stefanie Lumnitz</th>
      <th>Leonardo Uieda</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>libpysal.libpysal</th>
      <td>116</td>
      <td>43</td>
      <td>3</td>
      <td>6</td>
      <td>2</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <th>libpysal.esda</th>
      <td>5</td>
      <td>9</td>
      <td>3</td>
      <td>1</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <th>libpysal.giddy</th>
      <td>2</td>
      <td>3</td>
      <td>0</td>
      <td>23</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <th>libpysal.inequality</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <th>libpysal.pointpats</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <th>libpysal.segregation</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <th>libpysal.spaghetti</th>
      <td>0</td>
      <td>152</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>2</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <th>libpysal.mgwr</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <th>libpysal.spglm</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <th>libpysal.spint</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <th>libpysal.spreg</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <th>libpysal.spvcm</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <th>libpysal.tobler</th>
      <td>31</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>98</td>
      <td>41</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <th>libpysal.mapclassify</th>
      <td>21</td>
      <td>3</td>
      <td>0</td>
      <td>4</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>3</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <th>libpysal.splot</th>
      <td>1</td>
      <td>7</td>
      <td>1</td>
      <td>1</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>1</td>
      <td>24</td>
      <td>1</td>
    </tr>
  </tbody>
</table>


# PySAL 2.1.0, 2019-07-29

PySAL 2.1.0 represents 6 months of enhancements, bug-fixes, widening of test coverage, and improved documentation. All users are encouraged to upgrade to this version as there are numerous optimizations as well as new features (see below) that have been implemented.

From this version forward, PySAL supports Python 3 only and is tested on Python 3.6 and 3.7. Please make sure that you are operating in a Python 3 environment.

## Major Highlights of PySAL 2.1.0

### Entirely New Packages
This release we have added the following new package(s) to the PySAL stack:

- `segregation`. **Segregation Analytics with PySAL**.

This is an extensive package that deals with segregation measurements with several frameworks ranging from inference, decomposition, street network based measures, and a multiscalar segregation profiles on urban street networks. With a consistent and well defined api following the pep8 standards, users of `segregation` (v1.1.1) can:

Calculate over 40 segregation measures from simple to state-of-the art, including:

- [aspatial segregation indices](https://github.com/pysal/segregation/blob/master/notebooks/aspatial_examples.ipynb)
- spatial segregation indices
  - [using spatial weights matrices, euclidian distances, or topological relationships](https://github.com/pysal/segregation/blob/master/notebooks/spatial_examples.ipynb)
  - [using street network distances](https://github.com/pysal/segregation/blob/master/notebooks/network_measures.ipynb)
  - [using multiscalar definitions](https://github.com/pysal/segregation/blob/master/notebooks/multiscalar_segregation_profiles.ipynb)
- [local segregation indices](https://github.com/pysal/segregation/blob/master/notebooks/local_measures_example.ipynb)

Test whether segregation estimates are statistically significant:

- [single value inference](https://github.com/pysal/segregation/blob/master/notebooks/inference_wrappers_example.ipynb)
- [comparative inference](https://github.com/pysal/segregation/blob/master/notebooks/inference_wrappers_example.ipynb)

[Decompose](https://github.com/pysal/segregation/blob/master/notebooks/decomposition_wrapper_example.ipynb)
segregation comparisons into

- differences arising from spatial structure 
- differences arising from demographic structure  


### Significant Enhancements to Existing Packages

* Addition of two rank-based Markov methods to [pysal/giddy](https://github.com/pysal/giddy): Full Rank Markov and Geographic Rank Markov, both of which avoid the potentially arbitrary selection of the discretization scheme when a discrete Markov chain is applied to continuous variables (e.g. incomes). An example notebook applying these two methods to reveal interesting spatiotemporal patterns of income distribution dynamics in the United States 1929-2009 is given [here](https://github.com/pysal/giddy/blob/master/notebooks/Rank_Markov.ipynb).
* A new function [fdr](https://github.com/pysal/esda/blob/master/esda/util.py#L4) in [pysal/esda](https://github.com/pysal/esda) which account for multiple testing in local statistics by controlling the False Discovery Rate (FDR). The function takes the p-values for all of n local statistics and the significance level as the inputs, and returns the p-value cutoff which would be used for deciding whether to reject the null for each local test.
* The S-MAUP test was added to `esda`. This test statistic measures the sensitivity of statistical results to re-aggregation. Contributed by Juan Carlos Duque (@JuancaDuque), the statistic is defined in this [PLOS paper](https://journals.plos.org/plosone/article/comments?id=10.1371/journal.pone.0207377).
* The Lee & Local Lee statistics were added to `esda`. These statistics characterize the structure of local autocorrelation using Pearson's *r*. The statistic is defined in [Lee (2001)](https://link.springer.com/article/10.1007/s101090100064).
* The [`notebooks`](http://pysal.org/notebooks/intro) project, which provides a centralised online site with example notebooks from all the federated packages has undergone several back-end improvements and (partially) supports now interactive notebooks through Binder. The project is available at [http://pysal.org/notebooks](http://pysal.org/notebooks/)
* Computational improvements to `mgwr` package includes memory optimization and parallelization. The update allows GWR and Multi-scale GWR model to be calibrated faster and on much larger datasets. Additionally, there are API changes to the kernel functions in `mgwr`. [(#55)](https://github.com/pysal/mgwr/pull/55)



<a name="changes-by-package"></a>
## Changes by Package

Overall, there were 992 commits that closed 261 issues, together with 173 pull requests since our last release on 2019-01-30.


<a name="libpysal"></a>
### libpysal
* [#158:](https://github.com/pysal/libpysal/pull/158) Allow for **kwargs any time there's a weights construction 
* [#134:](https://github.com/pysal/libpysal/issues/134) Some functions do not support silence_warnings=True 
* [#159:](https://github.com/pysal/libpysal/pull/159) REL: update changelog 
* [#157:](https://github.com/pysal/libpysal/pull/157) MAINT: bumping version for a release 
* [#122:](https://github.com/pysal/libpysal/pull/122) update interactive examples in inline docstrings 
* [#156:](https://github.com/pysal/libpysal/pull/156) BUG: fix for scipy bump #154 
* [#155:](https://github.com/pysal/libpysal/pull/155) Revert "bump supported Python versions and correct lat2SW doctest" 
* [#154:](https://github.com/pysal/libpysal/pull/154) bump supported Python versions and correct lat2SW doctest 
* [#141:](https://github.com/pysal/libpysal/pull/141) WIP debugging travis failure 
* [#152:](https://github.com/pysal/libpysal/pull/152) replace deprecated "fromstring" with "frombytes" 
* [#48:](https://github.com/pysal/libpysal/issues/48) doctests on weights are failing across the board 
* [#149:](https://github.com/pysal/libpysal/pull/149) Use Unix line-endings for all files. 
* [#148:](https://github.com/pysal/libpysal/pull/148) Remove unnecessary executable bits. 
* [#144:](https://github.com/pysal/libpysal/issues/144) `import pysal` in libpysal/io/iohandlers/dat.py 
* [#143:](https://github.com/pysal/libpysal/issues/143) enforce strict channel in .travis.yml 
* [#145:](https://github.com/pysal/libpysal/issues/145) continued failing doctests in libpysal.io 
* [#146:](https://github.com/pysal/libpysal/issues/146) sphinxcontrib-napoleon is no longer necessary 
* [#142:](https://github.com/pysal/libpysal/pull/142) pysal --> libpysal docs conv & modernizing .travis.yml 
* [#7:](https://github.com/pysal/libpysal/issues/7) fix README for pypi 
* [#138:](https://github.com/pysal/libpysal/issues/138) build_lattice_shapefile swapped arguments 
* [#124:](https://github.com/pysal/libpysal/issues/124) Accidental create of branch 
* [#127:](https://github.com/pysal/libpysal/issues/127) Travis errors on Python3.6 PYTHON_PLUS=True 
* [#140:](https://github.com/pysal/libpysal/pull/140) [WIP] solution for Travis CI failures 
* [#139:](https://github.com/pysal/libpysal/pull/139) Conda travis 
* [#111:](https://github.com/pysal/libpysal/issues/111) alphashapes & n<4 
* [#115:](https://github.com/pysal/libpysal/pull/115) [WIP] ensure safe returns for small n alphashapes 


<a name="esda"></a>
### esda
* [#64:](https://github.com/pysal/esda/pull/64) DOC: style sheet update and adding Smaup to __init__ 
* [#63:](https://github.com/pysal/esda/pull/63) DOC: correcting Geary documentation 
* [#62:](https://github.com/pysal/esda/pull/62) 2.1.0 
* [#52:](https://github.com/pysal/esda/pull/52) (ENH) FDR-based adjustment to account for multiple testing in local statistics 
* [#58:](https://github.com/pysal/esda/pull/58) [WIP] Contributing Smaup test to `esda` 
* [#53:](https://github.com/pysal/esda/issues/53) G_Local: EG_sim and seG_sim are scalar 
* [#55:](https://github.com/pysal/esda/issues/55) docs building failed 
* [#57:](https://github.com/pysal/esda/pull/57) (bug) fix docs build 
* [#54:](https://github.com/pysal/esda/pull/54) BUG: EG_Sim and seG_sim were incorrectly given as scalars. #53 


<a name="giddy"></a>
### giddy
* [#97:](https://github.com/pysal/giddy/pull/97) (docs) change the css to accommodate new versions of sphinx and sphinx bootstrap theme  
* [#96:](https://github.com/pysal/giddy/pull/96) PyPi page configuration 
* [#95:](https://github.com/pysal/giddy/pull/95) pip install github master.zip of pysal dependencies 
* [#93:](https://github.com/pysal/giddy/issues/93) update README.md 
* [#94:](https://github.com/pysal/giddy/pull/94) Update readme 
* [#92:](https://github.com/pysal/giddy/pull/92) migrate from readthedocs configuration file v1 to v2 
* [#91:](https://github.com/pysal/giddy/pull/91) updating supported python versions (3.6 and 3.7) in setup.py 
* [#90:](https://github.com/pysal/giddy/pull/90) Move testing off of 3.5 and add 3.7 
* [#89:](https://github.com/pysal/giddy/issues/89) release on conda-forge 
* [#53:](https://github.com/pysal/giddy/pull/53) allow user specified lag and check shape 
* [#87:](https://github.com/pysal/giddy/pull/87) Update zenodo doi and pypi badge for version 2.1.0 (new release) 
* [#86:](https://github.com/pysal/giddy/pull/86) (bug) format readme.rst as long_description for pypi display 
* [#85:](https://github.com/pysal/giddy/pull/85) Prepare for release 2.1.0 


<a name="inequality"></a>
### inequality


<a name="pointpats"></a>
### pointpats
* [#31:](https://github.com/pysal/pointpats/pull/31) prepare for release of v2.1.0 
* [#33:](https://github.com/pysal/pointpats/pull/33) (docs) reference label style 
* [#32:](https://github.com/pysal/pointpats/pull/32) (docs) change the css to accommodate new versions of sphinx and sphinx bootstrap theme 
* [#30:](https://github.com/pysal/pointpats/pull/30) (docs) migrate from readthedocs configuration file v1 to v2  
* [#29:](https://github.com/pysal/pointpats/pull/29) (docs) updating supported python versions (3.6 and 3.7) in setup.py 
* [#28:](https://github.com/pysal/pointpats/pull/28) doc: edits to notebook 
* [#27:](https://github.com/pysal/pointpats/pull/27) require libpysal>=4.0.0 


<a name="spaghetti"></a>
### spaghetti
* [#277:](https://github.com/pysal/spaghetti/issues/277) add `requirements_dev.txt` to `MANIFEST.in` 
* [#279:](https://github.com/pysal/spaghetti/pull/279) Update changelog 
* [#278:](https://github.com/pysal/spaghetti/pull/278) version bump to include req_dev in MANIFEST.in 
* [#276:](https://github.com/pysal/spaghetti/pull/276) v1.2 --> 1.3rc1 (for release candidate) 
* [#275:](https://github.com/pysal/spaghetti/pull/275) Updating notebooks prior to v1.3 release 
* [#274:](https://github.com/pysal/spaghetti/pull/274) updating README 
* [#158:](https://github.com/pysal/spaghetti/issues/158) update notebooks following prior to v1.3 release 
* [#196:](https://github.com/pysal/spaghetti/issues/196) TypeError: '>' not supported between instances of '_NodeCursor' and '_NodeCursor' 
* [#273:](https://github.com/pysal/spaghetti/pull/273) Update docsite 
* [#268:](https://github.com/pysal/spaghetti/issues/268) docs failing with rtree 
* [#272:](https://github.com/pysal/spaghetti/pull/272) fix docs building 
* [#269:](https://github.com/pysal/spaghetti/pull/269) 3.5 --> 3.7 readthedocs 
* [#271:](https://github.com/pysal/spaghetti/pull/271) updating README.md 
* [#265:](https://github.com/pysal/spaghetti/issues/265) conda-forge recipe 
* [#270:](https://github.com/pysal/spaghetti/issues/270) Solo owner/maintainer 
* [#266:](https://github.com/pysal/spaghetti/issues/266) update requirements in README 
* [#267:](https://github.com/pysal/spaghetti/pull/267) updating requirements in README 
* [#259:](https://github.com/pysal/spaghetti/pull/259) Switch snapping to Rtree package? 
* [#262:](https://github.com/pysal/spaghetti/issues/262) update python versions in setup.py 
* [#263:](https://github.com/pysal/spaghetti/pull/263) updating supported python versions in setup.py 
* [#260:](https://github.com/pysal/spaghetti/issues/260) Drop 3.5, Add 3.7 testing 
* [#261:](https://github.com/pysal/spaghetti/pull/261) adding support for python3.7 
* [#257:](https://github.com/pysal/spaghetti/pull/257) Update Facility_Location.ipynb 
* [#256:](https://github.com/pysal/spaghetti/issues/256) Further failures in TravisCI builds. (`rake`) 
* [#255:](https://github.com/pysal/spaghetti/pull/255) bumping down geopandas requirement to 0.3.0 
* [#254:](https://github.com/pysal/spaghetti/pull/254) bumping geopandas req version to 0.4.1 
* [#253:](https://github.com/pysal/spaghetti/issues/253) TravisCI build failing with `geopandas` 
* [#252:](https://github.com/pysal/spaghetti/pull/252) Streamline setup travis 
* [#250:](https://github.com/pysal/spaghetti/issues/250) Remove redundancies in `requirements_xxx.txt` files 
* [#251:](https://github.com/pysal/spaghetti/pull/251) Removing redundant requirements 
* [#240:](https://github.com/pysal/spaghetti/issues/240) pandas.core error leading to Travis CI failure 
* [#248:](https://github.com/pysal/spaghetti/issues/248) uniform .travis.yml 
* [#249:](https://github.com/pysal/spaghetti/pull/249) switching from pip to conda for reqs install resolves .travis error 
* [#246:](https://github.com/pysal/spaghetti/issues/246) v1.2.rc1? 
* [#247:](https://github.com/pysal/spaghetti/pull/247) updating GitHub version badge 
* [#245:](https://github.com/pysal/spaghetti/issues/245) update version badges 
* [#242:](https://github.com/pysal/spaghetti/issues/242) AttributeError: module 'spaghetti' has no attribute 'element_as_gdf' 
* [#244:](https://github.com/pysal/spaghetti/pull/244) bump from rc to stable 
* [#243:](https://github.com/pysal/spaghetti/pull/243) v1.2rc1 bump 
* [#241:](https://github.com/pysal/spaghetti/pull/241) adding pandas as a requirement 


<a name="segregation"></a>
### segregation
* [#43:](https://github.com/pysal/segregation/issues/43) absolute concentration values not matching with other open-source options? 
* [#118:](https://github.com/pysal/segregation/pull/118) Concentration indexes rank fix 
* [#117:](https://github.com/pysal/segregation/pull/117) remove W from importings in spatial_indexes 
* [#102:](https://github.com/pysal/segregation/issues/102) consider surface based S 
* [#116:](https://github.com/pysal/segregation/pull/116) Adds SpatialMinMax index based on Sullivan and Wong (2007) 
* [#113:](https://github.com/pysal/segregation/pull/113) add robust and informative condition for large magnitude projections (tests only off-diagonal) 
* [#115:](https://github.com/pysal/segregation/pull/115) MinMaxS 
* [#114:](https://github.com/pysal/segregation/pull/114) spelling 
* [#99:](https://github.com/pysal/segregation/issues/99) consider tqdm instead of print statements for simulations 
* [#32:](https://github.com/pysal/segregation/issues/32) add DOI 
* [#110:](https://github.com/pysal/segregation/issues/110) Building Error (after tqdm inclusion?) 
* [#112:](https://github.com/pysal/segregation/pull/112) [WIP] add libcfitsio-dev in travis.yml 
* [#111:](https://github.com/pysal/segregation/pull/111) enh: add libcfitsio.so.5 in travis.yml following https://github.com/cypress-io/cypress/issues/4069#issuecomment-488816887 
* [#109:](https://github.com/pysal/segregation/pull/109) inference wrapper tweaks 
* [#107:](https://github.com/pysal/segregation/pull/107) bug: add descartes in requirements_tests for plotting tests 
* [#106:](https://github.com/pysal/segregation/pull/106) enh: add plotting tests in the decomposition framework 
* [#103:](https://github.com/pysal/segregation/pull/103) add spatial divergence index 
* [#100:](https://github.com/pysal/segregation/pull/100) Generalize also for haversine distance 
* [#72:](https://github.com/pysal/segregation/issues/72) release checklist 
* [#101:](https://github.com/pysal/segregation/pull/101) Update README.md 
* [#98:](https://github.com/pysal/segregation/pull/98) fix the broken link to compute all in readthe docs 
* [#97:](https://github.com/pysal/segregation/pull/97) coveralls badge fix 
* [#95:](https://github.com/pysal/segregation/pull/95) remove erroneous reference to geodetaframe in multigroup section 
* [#93:](https://github.com/pysal/segregation/pull/93) add github tag to coveralls badge 
* [#94:](https://github.com/pysal/segregation/pull/94) update badge link for update following https://github.com/lemurheavy/coveralls-public/issues/971#issuecomment-338942441 
* [#92:](https://github.com/pysal/segregation/pull/92) this adds tests for improving coverage 
* [#91:](https://github.com/pysal/segregation/pull/91) add DOI badge 
* [#90:](https://github.com/pysal/segregation/pull/90) changelog 
* [#89:](https://github.com/pysal/segregation/pull/89) update version in init 
* [#88:](https://github.com/pysal/segregation/pull/88) Renan final tweak release 
* [#87:](https://github.com/pysal/segregation/pull/87) include coverage option 
* [#85:](https://github.com/pysal/segregation/pull/85) mention center argument in centralization index in spatial notebook 
* [#84:](https://github.com/pysal/segregation/pull/84) release prep 
* [#56:](https://github.com/pysal/segregation/issues/56) improve readme with network examples 
* [#83:](https://github.com/pysal/segregation/pull/83) small tweak MultiDissim on readme 
* [#82:](https://github.com/pysal/segregation/pull/82) small tweak on SpatialDissim on readme 
* [#81:](https://github.com/pysal/segregation/pull/81) Change API (Deprecated classes) in favor of CamelLikeNames 
* [#80:](https://github.com/pysal/segregation/pull/80) BUG: add compute_seg_profile to spatial __all__ 
* [#77:](https://github.com/pysal/segregation/pull/77) Add local segregation measures 
* [#78:](https://github.com/pysal/segregation/pull/78) drop heavy deps 
* [#19:](https://github.com/pysal/segregation/issues/19) function to calculate segregation profiles 
* [#75:](https://github.com/pysal/segregation/pull/75) reimplement more flexible  SpatialInformationTheory index 
* [#76:](https://github.com/pysal/segregation/pull/76) add xtol to Ddc in readmme table 
* [#52:](https://github.com/pysal/segregation/issues/52) generate counterfactual distributions on comparative segregation using util `_generate_counterfactual` function 
* [#39:](https://github.com/pysal/segregation/issues/39) improve nomenclature of distance-decay isolation/exposure 
* [#73:](https://github.com/pysal/segregation/pull/73) release Renan's checklist 
* [#71:](https://github.com/pysal/segregation/pull/71) installation .rst tweaks 
* [#70:](https://github.com/pysal/segregation/pull/70) remove sphinx of requirements and point rtd to _docs requirements for organization 
* [#58:](https://github.com/pysal/segregation/issues/58) api docs not rendering fully 
* [#69:](https://github.com/pysal/segregation/pull/69) move numpy doc from mock to requirements 
* [#68:](https://github.com/pysal/segregation/pull/68) moving sphinxcontrib.bibtex from mock to requirements 
* [#67:](https://github.com/pysal/segregation/pull/67) create mocks for c dependency libraries 
* [#57:](https://github.com/pysal/segregation/issues/57) change the current API of network notebook 
* [#66:](https://github.com/pysal/segregation/pull/66) getting back with old conf, putting all depencies back to requirement… 
* [#65:](https://github.com/pysal/segregation/pull/65) remove recent dependencies included to see if rtd will be build 
* [#64:](https://github.com/pysal/segregation/pull/64) commenting sphinx_bootstrap_theme (trying to follow https://github.co… 
* [#63:](https://github.com/pysal/segregation/pull/63) add tests and docs in setup_package 
* [#62:](https://github.com/pysal/segregation/pull/62) add napoleon and gallery for rtd 
* [#61:](https://github.com/pysal/segregation/pull/61) fix typo value -> values 
* [#59:](https://github.com/pysal/segregation/pull/59) July release readthedocs tweaks 
* [#60:](https://github.com/pysal/segregation/pull/60) Notebooks updates (decomposition and networks) 
* [#2:](https://github.com/pysal/segregation/issues/2) add spatial information theory index 
* [#17:](https://github.com/pysal/segregation/issues/17) consider multi-group segregation indexes 
* [#55:](https://github.com/pysal/segregation/pull/55) adds Multigroup Divergence Index of Roberto (2018) 
* [#54:](https://github.com/pysal/segregation/pull/54) (bug) dual testing aganist pypi and github versions of libpysal 
* [#50:](https://github.com/pysal/segregation/pull/50) Tweaks for july release 
* [#51:](https://github.com/pysal/segregation/pull/51) update nbsit notebook 
* [#38:](https://github.com/pysal/segregation/issues/38) include bootstrap approach for single-value inference (and also for comparative) 
* [#49:](https://github.com/pysal/segregation/pull/49) Adds many Multigroup segregation measures 
* [#48:](https://github.com/pysal/segregation/pull/48) update network notebook 
* [#46:](https://github.com/pysal/segregation/pull/46) Remove sit and tweaks refactoring 
* [#47:](https://github.com/pysal/segregation/pull/47) [WIP] add network-based spatial information theory index 
* [#45:](https://github.com/pysal/segregation/pull/45) reorganize library into modules 
* [#37:](https://github.com/pysal/segregation/pull/37) fixed docstrings and decomposition notebook (LTDB links) 
* [#42:](https://github.com/pysal/segregation/pull/42) change denominator of spatial interaction term of Perimeter_Area_Ratio_Spatial_Dissim (and also add some tweak for concentration indexes) 
* [#40:](https://github.com/pysal/segregation/pull/40) add bootstrap (for unit levels) for single value segregation 
* [#44:](https://github.com/pysal/segregation/pull/44) add Absolute Clustering (ACL) segregation measure 
* [#9:](https://github.com/pysal/segregation/issues/9) add multigroup counterfactual approach 
* [#8:](https://github.com/pysal/segregation/issues/8) add "city share" counterfactual approach 
* [#41:](https://github.com/pysal/segregation/pull/41) add conda-forge option in intalling readme 
* [#25:](https://github.com/pysal/segregation/pull/25) OK: Create additional argument for the center in Centralization indexes 
* [#34:](https://github.com/pysal/segregation/pull/34) fix missing the year in the image title of Readme 
* [#33:](https://github.com/pysal/segregation/pull/33) updating README.md 
* [#31:](https://github.com/pysal/segregation/pull/31) add license file 
* [#30:](https://github.com/pysal/segregation/pull/30) Release 106 
* [#29:](https://github.com/pysal/segregation/pull/29) plan for Release 106 
* [#28:](https://github.com/pysal/segregation/pull/28) update changelog and run gitcount 
* [#27:](https://github.com/pysal/segregation/pull/27) tweaks for 1.0.5 release in setup.py 
* [#26:](https://github.com/pysal/segregation/pull/26) update readme with decompose framework for 1.0.5 release 
* [#23:](https://github.com/pysal/segregation/pull/23) create additional argument for the center in Centralization indexes 
* [#24:](https://github.com/pysal/segregation/pull/24) ENH: bump version number for bf release 
* [#16:](https://github.com/pysal/segregation/pull/16)  second step in building a Shapley's decomposition framework (also address many tweaks, typos, etc.) 
* [#22:](https://github.com/pysal/segregation/pull/22) BUG: adding MANIFEST.in so requirements.txt gets included in sdist 
* [#21:](https://github.com/pysal/segregation/pull/21) create changelog and gitcount 
* [#20:](https://github.com/pysal/segregation/pull/20) Create Tools for Github release 
* [#15:](https://github.com/pysal/segregation/issues/15) error when installing using pip 
* [#14:](https://github.com/pysal/segregation/pull/14) add RTD yaml 
* [#13:](https://github.com/pysal/segregation/pull/13) add docs reqs 
* [#12:](https://github.com/pysal/segregation/pull/12) begin docs 
* [#5:](https://github.com/pysal/segregation/issues/5) Order of connectivity may be incorrect in Spatial_Prox_Prof 
* [#10:](https://github.com/pysal/segregation/pull/10) add lorenz 
* [#7:](https://github.com/pysal/segregation/pull/7) add working decomposition func and CDF plotting func 
* [#6:](https://github.com/pysal/segregation/pull/6) start counterfactual 
* [#3:](https://github.com/pysal/segregation/pull/3) directly specifiy Miniconda3 
* [#1:](https://github.com/pysal/segregation/pull/1) add second install option to README.md 


<a name="mapclassify"></a>
### mapclassify
* [#39:](https://github.com/pysal/mapclassify/pull/39) Release 2.1.0 
* [#38:](https://github.com/pysal/mapclassify/pull/38) ENH: dropping 3.5 support and adding 3.7 
* [#36:](https://github.com/pysal/mapclassify/pull/36) ENH: plot method added to Mapclassify 
* [#35:](https://github.com/pysal/mapclassify/pull/35) ENH: keeping init keyword argument to avoid API breakage. 
* [#16:](https://github.com/pysal/mapclassify/issues/16) mapclassify.Natural_Break() does not return the specified k classes 
* [#32:](https://github.com/pysal/mapclassify/pull/32) Fix for #16 
* [#33:](https://github.com/pysal/mapclassify/issues/33) Mixed usage of brewer2mpl and palettable.colorbrewer in color.py 
* [#34:](https://github.com/pysal/mapclassify/pull/34) Chorobrewer 
* [#14:](https://github.com/pysal/mapclassify/issues/14) conda-forge recipe needs some love 
* [#31:](https://github.com/pysal/mapclassify/pull/31) generating images for color selector 
* [#30:](https://github.com/pysal/mapclassify/pull/30) doc: bump version and dev setup docs 
* [#29:](https://github.com/pysal/mapclassify/pull/29) environment.yml 
* [#28:](https://github.com/pysal/mapclassify/pull/28) add color import and chorobrewer notebook 
* [#26:](https://github.com/pysal/mapclassify/pull/26) Chorobrewer 
* [#25:](https://github.com/pysal/mapclassify/pull/25) chorobrewer init 


<a name="splot"></a>
### splot
* [#76:](https://github.com/pysal/splot/pull/76) [ENH] read long_description from README.md 
* [#74:](https://github.com/pysal/splot/pull/74) Rel1.1.0 
* [#72:](https://github.com/pysal/splot/issues/72) LISA cluster map colours mixed when cluster value not present 
* [#73:](https://github.com/pysal/splot/pull/73) [ENH] select colour by presence of value in list in `mask_local_auto` 
* [#51:](https://github.com/pysal/splot/issues/51) Moran Scatterplots with equal bounds on X and Y axes? 
* [#70:](https://github.com/pysal/splot/pull/70) Add aspect_equal argument to Moran functionality 
* [#69:](https://github.com/pysal/splot/pull/69) set up dual travis tests for pysal dependencies (pip and github)  
* [#65:](https://github.com/pysal/splot/issues/65) API changes of mapclassify propagate to splot 
* [#68:](https://github.com/pysal/splot/pull/68) [DOC] include rtree and descartes in `requirements_dev.txt` 
* [#67:](https://github.com/pysal/splot/pull/67) Readme update 
* [#64:](https://github.com/pysal/splot/pull/64) docs building using readthedocs.yml version 2 
* [#57:](https://github.com/pysal/splot/issues/57) [DOC] add test for missing code cove % 
* [#61:](https://github.com/pysal/splot/pull/61) Add tests for warnings and ValueErrors 
* [#1:](https://github.com/pysal/splot/issues/1) Update travis for testing 
* [#63:](https://github.com/pysal/splot/pull/63) travis ci testing: migrate from 3.5 and 3.6 to 3.6 and 3.7 
* [#58:](https://github.com/pysal/splot/pull/58) create paper directory 
* [#56:](https://github.com/pysal/splot/pull/56) clean and rerun notebooks 
* [#45:](https://github.com/pysal/splot/issues/45) `vba_choropleth` API 
* [#52:](https://github.com/pysal/splot/pull/52) allow string (default) in vba_choropleth function of tests 
* [#54:](https://github.com/pysal/splot/pull/54) migrating to readthedocs II 
* [#53:](https://github.com/pysal/splot/pull/53) migration to readthedocs 
* [#46:](https://github.com/pysal/splot/pull/46) Make docs 
* [#47:](https://github.com/pysal/splot/issues/47) Segmentation fault in running tests on TravisCI 
* [#48:](https://github.com/pysal/splot/pull/48) code 139 memory segmentation fault: RESOLVED 
* [#41:](https://github.com/pysal/splot/issues/41) pip install on linux fails on pyproj 


<a name="spreg"></a>
### spreg
* [#23:](https://github.com/pysal/spreg/issues/23) GM_Lag throws Singular Matrix error with high-dimension design matrix 
* [#21:](https://github.com/pysal/spreg/pull/21) MAINT: Fix for upcoming bump in scipy 
* [#22:](https://github.com/pysal/spreg/pull/22) xxxx 


<a name="spglm"></a>
### spglm
* [#22:](https://github.com/pysal/spglm/pull/22)  (docs) change to readthedocs v2 
* [#23:](https://github.com/pysal/spglm/pull/23) debug travis testing 
* [#21:](https://github.com/pysal/spglm/pull/21) transition to python 3.6 and 3.7 


<a name="spint"></a>
### spint


<a name="mgwr"></a>
### mgwr
* [#66:](https://github.com/pysal/mgwr/issues/66) Large-scale data cause the server down 
* [#67:](https://github.com/pysal/mgwr/pull/67) update req to add spreg 
* [#64:](https://github.com/pysal/mgwr/pull/64) transition to readthedocs v2 
* [#63:](https://github.com/pysal/mgwr/pull/63) transition to python3.6 and 3.7 
* [#58:](https://github.com/pysal/mgwr/issues/58) GWR poisson: local variable 'aicc' referenced before assignment 
* [#59:](https://github.com/pysal/mgwr/issues/59) (bug, doc) `family` parameter for Poisson GWR/MGWR 
* [#62:](https://github.com/pysal/mgwr/pull/62) inline docs: proper citation 
* [#61:](https://github.com/pysal/mgwr/pull/61) correct docstrings for family parameter in Sel_BW 
* [#56:](https://github.com/pysal/mgwr/pull/56) Adding a univariate example for Poisson MGWR 
* [#57:](https://github.com/pysal/mgwr/pull/57) Multi bw changes 
* [#55:](https://github.com/pysal/mgwr/pull/55) (docs) reflect api (kernels) change in the docs 
* [#54:](https://github.com/pysal/mgwr/issues/54) can set of independent variables contain zero's (bool)? 
* [#49:](https://github.com/pysal/mgwr/issues/49) Distance matrix calculation is not vectorized for lat, lon (spherical) coordinates 
* [#52:](https://github.com/pysal/mgwr/pull/52) Memory optimization and optional parallelization for GWR/MGWR 
* [#41:](https://github.com/pysal/mgwr/pull/41) Memory optimization 


<a name="spvcm"></a>
### spvcm

<a name="summary-statistics"></a>
## Summary Statistics

<a name="package-activity"></a>
### Package Activity
<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th>package</th>
      <th>commits</th>
      <th>total issues</th>
      <th>pulls</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>segregation</td>
      <td>456</td>
      <td>105</td>
      <td>78</td>
    </tr>
    <tr>
      <td>spaghetti</td>
      <td>120</td>
      <td>40</td>
      <td>21</td>
    </tr>
    <tr>
      <td>splot</td>
      <td>95</td>
      <td>25</td>
      <td>16</td>
    </tr>
    <tr>
      <td>libpysal</td>
      <td>80</td>
      <td>26</td>
      <td>11</td>
    </tr>
    <tr>
      <td>esda</td>
      <td>67</td>
      <td>9</td>
      <td>7</td>
    </tr>
    <tr>
      <td>mgwr</td>
      <td>44</td>
      <td>15</td>
      <td>7</td>
    </tr>
    <tr>
      <td>mapclassify</td>
      <td>43</td>
      <td>15</td>
      <td>12</td>
    </tr>
    <tr>
      <td>giddy</td>
      <td>32</td>
      <td>13</td>
      <td>10</td>
    </tr>
    <tr>
      <td>pointpats</td>
      <td>25</td>
      <td>7</td>
      <td>7</td>
    </tr>
    <tr>
      <td>spreg</td>
      <td>16</td>
      <td>3</td>
      <td>1</td>
    </tr>
    <tr>
      <td>spglm</td>
      <td>14</td>
      <td>3</td>
      <td>3</td>
    </tr>
    <tr>
      <td>inequality</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <td>spint</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <td>spvcm</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
  </tbody>
</table>

<a name="contributor-activity"></a>
### Contributor Activity
<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>commits</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>Antti Härkönen</th>
      <td>4</td>
    </tr>
    <tr>
      <th>Dani Arribas-Bel</th>
      <td>5</td>
    </tr>
    <tr>
      <th>Eli Knaap</th>
      <td>94</td>
    </tr>
    <tr>
      <th>Elliott Sales De Andrade</th>
      <td>2</td>
    </tr>
    <tr>
      <th>Filipe Fernandes</th>
      <td>3</td>
    </tr>
    <tr>
      <th>James Gaboardi</th>
      <td>175</td>
    </tr>
    <tr>
      <th>Juan C Duque</th>
      <td>8</td>
    </tr>
    <tr>
      <th>Levi John Wolf</th>
      <td>18</td>
    </tr>
    <tr>
      <th>Martin Fleischmann</th>
      <td>3</td>
    </tr>
    <tr>
      <th>Renan Xavier Cortes</th>
      <td>357</td>
    </tr>
    <tr>
      <th>Serge Rey</th>
      <td>86</td>
    </tr>
    <tr>
      <th>Stefanie Lumnitz</th>
      <td>63</td>
    </tr>
    <tr>
      <th>Taylor Oshan</th>
      <td>9</td>
    </tr>
    <tr>
      <th>Tom Gertin</th>
      <td>1</td>
    </tr>
    <tr>
      <th>Wei Kang</th>
      <td>135</td>
    </tr>
    <tr>
      <th>Ziqi Li</th>
      <td>24</td>
    </tr>
  </tbody>
</table>

<a name="contributor-by-package-activity"></a>
### Contributor by Package Activity
<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>Antti Härkönen</th>
      <th>Dani Arribas-Bel</th>
      <th>Eli Knaap</th>
      <th>Elliott Sales De Andrade</th>
      <th>Filipe Fernandes</th>
      <th>James Gaboardi</th>
      <th>Juan C Duque</th>
      <th>Levi John Wolf</th>
      <th>Martin Fleischmann</th>
      <th>Renan Xavier Cortes</th>
      <th>Serge Rey</th>
      <th>Stefanie Lumnitz</th>
      <th>Taylor Oshan</th>
      <th>Tom Gertin</th>
      <th>Wei Kang</th>
      <th>Ziqi Li</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>lib.libpysal</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>2</td>
      <td>0</td>
      <td>54</td>
      <td>0</td>
      <td>1</td>
      <td>3</td>
      <td>0</td>
      <td>14</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>6</td>
      <td>0</td>
    </tr>
    <tr>
      <th>explore.esda</th>
      <td>0</td>
      <td>5</td>
      <td>0</td>
      <td>0</td>
      <td>3</td>
      <td>3</td>
      <td>8</td>
      <td>14</td>
      <td>0</td>
      <td>0</td>
      <td>18</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>16</td>
      <td>0</td>
    </tr>
    <tr>
      <th>explore.giddy</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>5</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>27</td>
      <td>0</td>
    </tr>
    <tr>
      <th>explore.inequality</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <th>explore.pointpats</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>1</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>1</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>18</td>
      <td>0</td>
    </tr>
    <tr>
      <th>explore.spaghetti</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>97</td>
      <td>0</td>
      <td>1</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>1</td>
      <td>21</td>
      <td>0</td>
    </tr>
    <tr>
      <th>explore.segregation</th>
      <td>4</td>
      <td>0</td>
      <td>94</td>
      <td>0</td>
      <td>0</td>
      <td>4</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>349</td>
      <td>2</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>3</td>
      <td>0</td>
    </tr>
    <tr>
      <th>viz.mapclassify</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>41</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>2</td>
      <td>0</td>
    </tr>
    <tr>
      <th>viz.splot</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>9</td>
      <td>0</td>
      <td>1</td>
      <td>0</td>
      <td>8</td>
      <td>1</td>
      <td>63</td>
      <td>0</td>
      <td>0</td>
      <td>13</td>
      <td>0</td>
    </tr>
    <tr>
      <th>model.spreg</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>2</td>
      <td>0</td>
      <td>1</td>
      <td>0</td>
      <td>0</td>
      <td>9</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>4</td>
      <td>0</td>
    </tr>
    <tr>
      <th>model.spglm</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>5</td>
      <td>0</td>
      <td>9</td>
      <td>0</td>
    </tr>
    <tr>
      <th>model.spint</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <th>model.mgwr</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>4</td>
      <td>0</td>
      <td>16</td>
      <td>24</td>
    </tr>
    <tr>
      <th>model.spvcm</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
  </tbody>
</table>



# PySAL 2.0.0, 2019-01-30


This release represents over 15 months of hard work on PySAL. It brings major transitions in the project together with many new enhancements, improved documentation, and many bug fixes and optimizations.

<!-- markdown-toc start - Don't edit this section. Run M-x markdown-toc-generate-toc again -->
**Table of Contents**

- [Release Notes for PySAL 2.0](#release-notes-for-pysal-20)
    - [Major Changes](#major-changes)
        - [Entirely New Packages](#entirely-new-packages)
        - [Significant Enhancements to Existing Packages](#significant-enhancements-to-existing-packages)
    - [Changes by Package](#changes-by-package)
        - [libpysal](#libpysal)
        - [esda](#esda)
        - [giddy](#giddy)
        - [inequality](#inequality)
        - [pointpats](#pointpats)
        - [spaghetti](#spaghetti)
        - [mapclassify](#mapclassify)
        - [splot](#splot)
        - [spreg](#spreg)
        - [spglm](#spglm)
        - [spint](#spint)
        - [mgwr](#mgwr)
        - [spvcm](#spvcm)
    - [Summary Statistics](#summary-statistics)
        - [Package Activity](#package-activity)
        - [Contributor Activity](#contributor-activity)
        - [Contributor by Package Activity](#contributor-by-package-activity)

<!-- markdown-toc end -->


<a name="major-changes"></a>
## Major Changes
This release, we've had a ton of activity in PySAL, much of which has been conducted in our *subpackages*, the independently-released components of our library. Because it is too onerous to list all the changes to the API here, please consult the [Migrating to PySAL 2.0](http://pysal.org/about.html#migrating-to-pysal-2-0) page for a detailed discussion of all reorganization-related changes. This document will focus *only* on improvements to functionality, enhancements, and additional modules added to `2.0`, over and above the last stable release of the `1.0` series, PySAL `1.14.4`. 


<a name="entirely-new-packages"></a>
### Entirely New Packages
For starters, we've added some entirely-new subpackages to this release candidate:

- `mgwr`, **the multi-scale Geographically-weighted regression package for Python.** 
    
    Don't worry, `mgwr` fits single-scale geographically-weighted regressions, too. Geographically-weighted regression is a kind of generalized additive model that uses kernel functions in the geographic area around each observation to predict outcomes at that area more accuratly, kind of like Gaussian Process regression for geographic data. 
- `spvcm`, for spatially-correlated multilevel models. 

    Spatially-correlated multilevel models are models that allow for random effects of nearby areas, regions, or groups to be correlated with one another. This is a Gibbs sampling framework plus diagnostics & plotting tools for general Bayesian analysis of Gibbs samplers. The package also contains simple tools to implement new samplers on top of the infrastructure provided, which is fast, parallel, serializable, iterative-write, and interruptible. 
- `spint`, for estimating spatial interaction models, such as the production-constrained or consumption-constrained gravity models. 
- `spglm`, a package for fitting sparse GLMs, focused on performance over sparse categorical data. 
- `splot`, for spatial vizualization in Python, built on top of the excellent [`geopandas`](https://github.com/geopandas/geopandas). This is headed by our Google Summer of Code (2018) student, [Stefanie Lumnitz](https://github.com/slumnitz), and will be ongoing throughout the release candidate maturation cycle. 
- `pointpats`, a package for the statistical analysis of point patterns, geographical colocation, and dispersion.

<a name="significant-enhancements-to-existing-packages"></a>
### Significant Enhancements to Existing Packages

We've also had a ton of activity adding new features in our *submodules*:
- [alpha shapes](https://github.com/pysal/libpysal/blob/master/libpysal/cg/alpha_shapes.py), a fast implementation (numba-enabled) of the [original algorithm](https://ieeexplore.ieee.org/document/1056714) generalizing convex hulls to allow for non-convex hulls
- [Contiguity weights from voronoi tesselations/delaunay triangulation graphs](https://github.com/pysal/libpysal/blob/master/libpysal/weights/contiguity.py#L318) for point patterns
- [Fuzzy contiguity weights](https://github.com/pysal/libpysal/blob/master/libpysal/weights/util.py#L1328), for polygonal data where planarity is not strictly enforced (provided in part by [`geopandas`](https://github.com/geopandas/geopandas))
- A family of spatially explicit indicators of mobility association including the [inter- and intra-regional indicators](https://github.com/pysal/giddy/blob/master/giddy/rank.py#L798) as well as the [local indicators](https://github.com/pysal/giddy/blob/master/giddy/rank.py#L493). The inter- and intra-regional indicators provide a meso-level view on the exchange mobility pattern, shedding light on specific regions hosting frequent rank exchanges while the local indicators examine the concordance relationship between a focal spatial unit and its neighbors for revealing the role of space in shaping the exchange mobility pattern over time.
- [Categorical Spatial Markov](https://github.com/pysal/giddy/blob/master/giddy/markov.py#L200), a generalization of the Spatial_Markov class previously implemented to interrogate the role of space in shaping regional income distribution dynamics to incorporate direct variables. Here, the [categorical spatial lag](https://github.com/pysal/libpysal/blob/master/libpysal/weights/spatial_lag.py#L90) is adopted for formalizing the neighborhood.
- [Connected Components checks](https://github.com/pysal/libpysal/blob/2843eeaaff4efa0b1816077d9e76d15ccbd81929/libpysal/weights/weights.py#L340) for our spatial graph matrices
- [Pandas Adjacency list constructors](https://github.com/pysal/libpysal/blob/2843eeaaff4efa0b1816077d9e76d15ccbd81929/libpysal/weights/weights.py#L200) and [NetworkX adapters](https://github.com/pysal/libpysal/blob/2843eeaaff4efa0b1816077d9e76d15ccbd81929/libpysal/weights/weights.py#L265) for PySAL graph objects
- [Attach islands](https://github.com/pysal/libpysal/blob/master/libpysal/weights/util.py#L1280), tooling to merge isolated observations into existing spatial graphs
- [Construct Contiguity graphs from linestrings](https://github.com/pysal/libpysal/blob/ea2d44da797659904000e20ddbb0f3d52efd1ad2/libpysal/weights/tests/test_contiguity.py#L110), allowing for easy and fast access to road network data in PySAL



<a name="changes-by-package"></a>
## Changes by Package

Overall, there were 1636 commits that closed 368 issues, together with 236 pull requests since our last release on 2017-11-03.

<a name="libpysal"></a>
### libpysal
* weights.distance.KNN.from_dataframe ignoring radius  [(#116)](https://github.com/pysal/libpysal/issues/116)
* Always make spherical KDTrees if radius is passed [(#117)](https://github.com/pysal/libpysal/pull/117)
* [ENH] should `weights.util.get_ids()` also accept a geodataframe? [(#97)](https://github.com/pysal/libpysal/issues/97)
* enh: add doctests to travis (#2) [(#112)](https://github.com/pysal/libpysal/pull/112)
* sphinx docs need updating [(#49)](https://github.com/pysal/libpysal/issues/49)
* Add notebooks for subpackage contract [(#108)](https://github.com/pysal/libpysal/issues/108)
* Api docs complete [(#110)](https://github.com/pysal/libpysal/pull/110)
* Doctests and start of documentation for libpysal [(#109)](https://github.com/pysal/libpysal/pull/109)
* Add dependencies to requirements_plus.txt for test_db [(#107)](https://github.com/pysal/libpysal/pull/107)
* Weights/util/get ids gdf [(#101)](https://github.com/pysal/libpysal/pull/101)
* missing adjustments to lower case module names [(#106)](https://github.com/pysal/libpysal/pull/106)
* Rel.4.0.0 [(#105)](https://github.com/pysal/libpysal/pull/105)
* REL: 3.0.8 [(#104)](https://github.com/pysal/libpysal/pull/104)
* error importing v3.0.7 [(#100)](https://github.com/pysal/libpysal/issues/100)
* Lower case module names [(#98)](https://github.com/pysal/libpysal/pull/98)
* remove function regime_weights [(#96)](https://github.com/pysal/libpysal/pull/96)
* depreciating regime_weights in the new release? [(#94)](https://github.com/pysal/libpysal/issues/94)
* inconsistency in api? [(#93)](https://github.com/pysal/libpysal/issues/93)
* Ensure consistency in `from .module import *` in components of libpysal [(#95)](https://github.com/pysal/libpysal/pull/95)
* [WIP] cleanup [(#88)](https://github.com/pysal/libpysal/pull/88)
* docstrings for attributes are defined in properties [(#87)](https://github.com/pysal/libpysal/pull/87)
* docstrings in W class need editing [(#64)](https://github.com/pysal/libpysal/issues/64)
* version name as __version__ [(#92)](https://github.com/pysal/libpysal/pull/92)
* remove `del` statements and modify alphashape __all__ [(#89)](https://github.com/pysal/libpysal/pull/89)
* libpysal/libpysal/cg/__init__.py not importing `rtree` [(#90)](https://github.com/pysal/libpysal/issues/90)
* including rtree in imports [(#91)](https://github.com/pysal/libpysal/pull/91)
* BUG:  test_weights_IO.py is using pysal and hard-coded paths [(#85)](https://github.com/pysal/libpysal/issues/85)
* fix hardcoded swm test [(#86)](https://github.com/pysal/libpysal/pull/86)
* check for spatial index if nonplanar neighbors [(#84)](https://github.com/pysal/libpysal/pull/84)
* nonplanar_neighbors fails when sindex is not constructed.  [(#63)](https://github.com/pysal/libpysal/issues/63)
* increment version number and add bugfixes, api changes [(#79)](https://github.com/pysal/libpysal/pull/79)
* Spherebug [(#82)](https://github.com/pysal/libpysal/pull/82)
* only warn once for islands/disconnected components [(#83)](https://github.com/pysal/libpysal/pull/83)
* only warn on disconnected components if there are no islands [(#81)](https://github.com/pysal/libpysal/issues/81)
* LEP: Stuff/use pysal/network stuff to provide queen weights on linestring dataframes [(#59)](https://github.com/pysal/libpysal/issues/59)
* swm fix not ported forward from pysal.  [(#66)](https://github.com/pysal/libpysal/issues/66)
* import scipy syntax typo in the new issue template [(#68)](https://github.com/pysal/libpysal/issues/68)
* deletion of extra spaces in warning message [(#78)](https://github.com/pysal/libpysal/pull/78)
* Nightli.es build permissions [(#77)](https://github.com/pysal/libpysal/issues/77)
* name of geometry column is hardcoded in nonplanar_neighbors [(#75)](https://github.com/pysal/libpysal/issues/75)
* changed geometry column name from a str to an attribute [(#76)](https://github.com/pysal/libpysal/pull/76)
* Missing example file  [(#71)](https://github.com/pysal/libpysal/issues/71)
* if numba isn't present, libpysal warns every time imported [(#73)](https://github.com/pysal/libpysal/issues/73)
* add check for disconnected components [(#65)](https://github.com/pysal/libpysal/pull/65)
* clean up for release [(#74)](https://github.com/pysal/libpysal/pull/74)
* update for new examples [(#72)](https://github.com/pysal/libpysal/pull/72)
* Swm [(#70)](https://github.com/pysal/libpysal/pull/70)
* Remaining concerns left unfixed in #61 [(#62)](https://github.com/pysal/libpysal/pull/62)
* [WIP] Alpha shapes (2D) code [(#58)](https://github.com/pysal/libpysal/pull/58)
* [WIP]: add linestring/multilinestring functionality [(#61)](https://github.com/pysal/libpysal/pull/61)
* Fuzzy contiguity [(#57)](https://github.com/pysal/libpysal/pull/57)
* add berlin example [(#56)](https://github.com/pysal/libpysal/pull/56)
* force UTF8 encoding for the long description read [(#55)](https://github.com/pysal/libpysal/pull/55)
* add guerry example dataset [(#45)](https://github.com/pysal/libpysal/pull/45)
* update georgia shapefile [(#53)](https://github.com/pysal/libpysal/pull/53)
* fix typo add `non_planar_joins` instead of `non_planar_neighbor` attr… [(#54)](https://github.com/pysal/libpysal/pull/54)
* add voronoi to the API [(#46)](https://github.com/pysal/libpysal/pull/46)
* ENH: Neighbor detection for nonplanar enforced polygon collections. [(#51)](https://github.com/pysal/libpysal/pull/51)
* Missing example used by gwr tests [(#43)](https://github.com/pysal/libpysal/pull/43)
* Wplot [(#50)](https://github.com/pysal/libpysal/pull/50)
* close the door on 2 for libpysal [(#44)](https://github.com/pysal/libpysal/pull/44)
* To networkx argument name changed [(#40)](https://github.com/pysal/libpysal/issues/40)
* bump micro version [(#42)](https://github.com/pysal/libpysal/pull/42)
* fix networkx adapters [(#41)](https://github.com/pysal/libpysal/pull/41)
* minor version bump for release [(#39)](https://github.com/pysal/libpysal/pull/39)
* Plot weights [(#38)](https://github.com/pysal/libpysal/pull/38)
* forward port of legacy fix #1028 [(#37)](https://github.com/pysal/libpysal/pull/37)
* Adding Voronoi generator for cg as well as Voronoi weights from 2-d points [(#36)](https://github.com/pysal/libpysal/pull/36)
* bump version for release [(#34)](https://github.com/pysal/libpysal/pull/34)
* attach_islands correction: incorporate pr #32 [(#33)](https://github.com/pysal/libpysal/pull/33)
* change data type of contiguity W.neighbors value from set to list (consistent with other weights) [(#32)](https://github.com/pysal/libpysal/pull/32)
* add a function to attach the nearest neighbor to island [(#30)](https://github.com/pysal/libpysal/pull/30)
* fix id2i lookup for string names and make better names [(#31)](https://github.com/pysal/libpysal/pull/31)
* two modules “Wsets.py” and "util.py" depend on each other [(#26)](https://github.com/pysal/libpysal/issues/26)
* add unittest for Wset.w_clip [(#29)](https://github.com/pysal/libpysal/pull/29)
* resolve circular import in Wsets and util [(#28)](https://github.com/pysal/libpysal/pull/28)
* update doctests in weights module to use libpysal instead of pysal [(#27)](https://github.com/pysal/libpysal/pull/27)
* bump stable date [(#25)](https://github.com/pysal/libpysal/pull/25)
* bump version for point release of lag cat fix [(#24)](https://github.com/pysal/libpysal/pull/24)


<a name="esda"></a>
### esda
* enh: updating travis build and rtd [(#40)](https://github.com/pysal/esda/pull/40)
* BUG: missing rtd file [(#39)](https://github.com/pysal/esda/pull/39)
* REL: 2.0.1 [(#38)](https://github.com/pysal/esda/pull/38)
* Prepping for a doc release [(#37)](https://github.com/pysal/esda/pull/37)
* docstrings are using pysal legacy [(#4)](https://github.com/pysal/esda/issues/4)
* add zenodo doi badge [(#36)](https://github.com/pysal/esda/pull/36)
* REL: 2.0.0 [(#34)](https://github.com/pysal/esda/pull/34)
* Changing esda setup to handle version programatically [(#33)](https://github.com/pysal/esda/pull/33)
* port legacy esda fix for 1013  [(#12)](https://github.com/pysal/esda/issues/12)
* notebook links broken [(#29)](https://github.com/pysal/esda/issues/29)
* include /tests in release [(#32)](https://github.com/pysal/esda/pull/32)
* Add tests to release [(#27)](https://github.com/pysal/esda/issues/27)
* Accounting for incoming API changes to `libpysal` and adding testing against `libpysal`'s master branch [(#26)](https://github.com/pysal/esda/pull/26)
* no `varnames` in `Moran_BV_matrix` [(#22)](https://github.com/pysal/esda/issues/22)
* add `.varnames` attribute to `Moran_BV` objects in `Moran_BV_Matrix` results [(#23)](https://github.com/pysal/esda/pull/23)
* Inconsistent metadata in setup.py [(#28)](https://github.com/pysal/esda/issues/28)
* Update license [(#30)](https://github.com/pysal/esda/pull/30)
* esda has no readme [(#14)](https://github.com/pysal/esda/issues/14)
* Readme added [(#25)](https://github.com/pysal/esda/pull/25)
* move api into __init__ and remove api [(#24)](https://github.com/pysal/esda/pull/24)
* `.z` attribute divided by standard deviation [(#21)](https://github.com/pysal/esda/pull/21)
* offer standardised and non-standardised `.z`, `.x` and `.y` attributes [(#20)](https://github.com/pysal/esda/issues/20)
* get sjsrey's changes into a release [(#16)](https://github.com/pysal/esda/pull/16)
* esda's namespace is broken [(#17)](https://github.com/pysal/esda/issues/17)
* update api.py [(#18)](https://github.com/pysal/esda/pull/18)
* Update docstrings to use libpysal not pysal [(#13)](https://github.com/pysal/esda/pull/13)
* esda needs an api.py module [(#9)](https://github.com/pysal/esda/issues/9)
* chore: Update setup for 3+ [(#15)](https://github.com/pysal/esda/pull/15)
* Master [(#10)](https://github.com/pysal/esda/pull/10)


<a name="giddy"></a>
### giddy
* remove giddy.api in README.rst [(#66)](https://github.com/pysal/giddy/pull/66)
*  chore: update for libpysal lower case module name changes [(#65)](https://github.com/pysal/giddy/pull/65)
* remove api.py [(#62)](https://github.com/pysal/giddy/issues/62)
* set up travis dual testing against mapclassify and  esda [(#63)](https://github.com/pysal/giddy/issues/63)
* replace `libpysal.api` imports with new imports in `markov.py` and `d… [(#61)](https://github.com/pysal/giddy/pull/61)
* Remove api.py and account for changes in (incoming) API of mapclassify, esda, and libpysal [(#64)](https://github.com/pysal/giddy/pull/64)
* version giddy only in giddy/__ini__.py [(#60)](https://github.com/pysal/giddy/pull/60)
* remove duplicate makefile for sphinx build [(#59)](https://github.com/pysal/giddy/pull/59)
* add zenodo doi badge to README [(#58)](https://github.com/pysal/giddy/pull/58)
* add changelog for the release 1.2.0 [(#57)](https://github.com/pysal/giddy/pull/57)
* prepare for release 1.2.0 [(#56)](https://github.com/pysal/giddy/pull/56)
* set up dual travis tests for libpysal (pip and github) [(#55)](https://github.com/pysal/giddy/pull/55)
* ENH: Allow for more flexible specification of Spatial Markov [(#54)](https://github.com/pysal/giddy/pull/54)
* Update notebooks to rely on geopandas for mapping [(#52)](https://github.com/pysal/giddy/pull/52)
* ENH to docs [(#51)](https://github.com/pysal/giddy/pull/51)
* include /tests in the release and correct for the directional doctests [(#50)](https://github.com/pysal/giddy/pull/50)
* add doc building badge to README [(#49)](https://github.com/pysal/giddy/pull/49)
* Tests and documentation for `rose.plot()` and `rose.plot_vectors()` [(#47)](https://github.com/pysal/giddy/pull/47)
* A tentative version of giddy documentation website with sphinx  [(#48)](https://github.com/pysal/giddy/pull/48)
* encoding issue in  README.rst [(#45)](https://github.com/pysal/giddy/issues/45)
* force utf8 for the install description read [(#46)](https://github.com/pysal/giddy/pull/46)
* implement `rose.plot()` and `rose.plot_vectors()` method using `splot` [(#43)](https://github.com/pysal/giddy/pull/43)
* More on building doc webpages using sphinx [(#44)](https://github.com/pysal/giddy/pull/44)
* Gallery [(#42)](https://github.com/pysal/giddy/pull/42)
* new features for sphinx documentation website [(#41)](https://github.com/pysal/giddy/pull/41)
* typo - email notifications [(#40)](https://github.com/pysal/giddy/pull/40)
* fix for python 3 [(#38)](https://github.com/pysal/giddy/pull/38)
* first draft of sphinx gallery [(#39)](https://github.com/pysal/giddy/pull/39)
* add docstring for categorical spatial Markov [(#37)](https://github.com/pysal/giddy/pull/37)
* add changelog for the release 1.1.0 [(#36)](https://github.com/pysal/giddy/pull/36)
* prepare for release [(#35)](https://github.com/pysal/giddy/pull/35)
* code 2to3 [(#34)](https://github.com/pysal/giddy/pull/34)
* chore: update for python 3+ only [(#33)](https://github.com/pysal/giddy/pull/33)
* How to use the 'development' version [(#31)](https://github.com/pysal/giddy/issues/31)
* KeyError: 1 in spatial_lag.py [(#30)](https://github.com/pysal/giddy/issues/30)
* giddy needs an api.py module [(#26)](https://github.com/pysal/giddy/issues/26)
* add inequality to api [(#28)](https://github.com/pysal/giddy/pull/28)
* adding discretized Spatial_Markov [(#29)](https://github.com/pysal/giddy/pull/29)


<a name="inequality"></a>
### inequality
* Change setup to handle version pragmatically [(#6)](https://github.com/pysal/inequality/pull/6)
* accounting for libpysal api changes in unittests [(#5)](https://github.com/pysal/inequality/pull/5)
* missing parenthesis in call to print [(#2)](https://github.com/pysal/inequality/issues/2)
* setting up dual testing [(#4)](https://github.com/pysal/inequality/pull/4)
* 2to3 for _indices.py [(#3)](https://github.com/pysal/inequality/pull/3)
* Initial setup [(#1)](https://github.com/pysal/inequality/pull/1)


<a name="pointpats"></a>
### pointpats
* add changelog for release 2.0.0 [(#21)](https://github.com/pysal/pointpats/pull/21)
* remove api.py & adjust notebooks and doctests for changes in libpysal [(#19)](https://github.com/pysal/pointpats/pull/19)
* version pointpats only in pointpats/__ini__.py [(#18)](https://github.com/pysal/pointpats/pull/18)
* include /tests  in the release [(#17)](https://github.com/pysal/pointpats/pull/17)
* configure dual testing [(#16)](https://github.com/pysal/pointpats/pull/16)
* install stable released libpysal for travis testing [(#15)](https://github.com/pysal/pointpats/pull/15)
* force UTF8 encoding for the long description read [(#14)](https://github.com/pysal/pointpats/pull/14)
* Prepare for the release  [(#13)](https://github.com/pysal/pointpats/pull/13)
* chore: libpysal is 3 only now so removing travis tests on python 2 [(#12)](https://github.com/pysal/pointpats/pull/12)
* try removing conversion and see if this passes [(#11)](https://github.com/pysal/pointpats/pull/11)


<a name="spaghetti"></a>
### spaghetti
* refreshing documentation [(#124)](https://github.com/pysal/spaghetti/pull/124)
* option to add distance from point to snapped location [(#75)](https://github.com/pysal/spaghetti/issues/75)
* attempting pyproj_fix [(#122)](https://github.com/pysal/spaghetti/pull/122)
* [WIP] Add snap dist [(#123)](https://github.com/pysal/spaghetti/pull/123)
* travis CI build failing with `KeyError: 'PROJ_LIB'` [(#121)](https://github.com/pysal/spaghetti/issues/121)
* resolving obs_to_node question [(#120)](https://github.com/pysal/spaghetti/pull/120)
* why convert obs_to_node from defaultdict to list? [(#93)](https://github.com/pysal/spaghetti/issues/93)
* network.PointPatterns condense code chunk [(#74)](https://github.com/pysal/spaghetti/issues/74)
* condensing idvariable code chunk [(#119)](https://github.com/pysal/spaghetti/pull/119)
* Network Cross Nearest Neighbor [(#102)](https://github.com/pysal/spaghetti/issues/102)
* refreshing docs [(#117)](https://github.com/pysal/spaghetti/pull/117)
* shortest path look up from allneighborsdistances? [(#115)](https://github.com/pysal/spaghetti/issues/115)
* adding shortest path traceback for point patterns [(#116)](https://github.com/pysal/spaghetti/pull/116)
* ImportError: No module named 'boto3' [(#113)](https://github.com/pysal/spaghetti/issues/113)
* adding boto3 test req for current fiona bug [(#114)](https://github.com/pysal/spaghetti/pull/114)
* [WIP] cleanup_nearest_neighbor [(#112)](https://github.com/pysal/spaghetti/pull/112)
* duplicate neighbor distance functions? [(#91)](https://github.com/pysal/spaghetti/issues/91)
* network.allneighbordistances documentation not accurate [(#111)](https://github.com/pysal/spaghetti/issues/111)
* [WIP] General package maintenance [(#109)](https://github.com/pysal/spaghetti/pull/109)
* new badges [(#96)](https://github.com/pysal/spaghetti/issues/96)
* tools/ [(#99)](https://github.com/pysal/spaghetti/issues/99)
* updating thumbnails in docs [(#108)](https://github.com/pysal/spaghetti/pull/108)
* [WIP] updating docs, badges, tools, etc. [(#107)](https://github.com/pysal/spaghetti/pull/107)
* initializing new sphinx docs based on submodule_template [(#98)](https://github.com/pysal/spaghetti/pull/98)
* new labels for issues [(#105)](https://github.com/pysal/spaghetti/issues/105)
* populating sphinx docs [(#37)](https://github.com/pysal/spaghetti/issues/37)
* tests for analysis and util [(#44)](https://github.com/pysal/spaghetti/issues/44)
* NetworkF [(#94)](https://github.com/pysal/spaghetti/issues/94)
* rename functions to be more pythonic [(#104)](https://github.com/pysal/spaghetti/issues/104)
* add poisson distribution to tests [(#106)](https://github.com/pysal/spaghetti/issues/106)
* initial sphix docs attempt [(#67)](https://github.com/pysal/spaghetti/pull/67)
* bumping version to 1.1.0 [(#97)](https://github.com/pysal/spaghetti/pull/97)
* adding in new tests for utils.py [(#95)](https://github.com/pysal/spaghetti/pull/95)
* add flag for util.generatetree() [(#92)](https://github.com/pysal/spaghetti/issues/92)
* [completed atm] - docstrings cleanup [(#89)](https://github.com/pysal/spaghetti/pull/89)
* clean docstrings [(#77)](https://github.com/pysal/spaghetti/issues/77)
* adding MANIFEST.in [(#88)](https://github.com/pysal/spaghetti/pull/88)
* clearing Facility_Location.ipynb [(#87)](https://github.com/pysal/spaghetti/pull/87)
* removing typo in Facility_Location [(#86)](https://github.com/pysal/spaghetti/pull/86)
* clearing Facility_Location.ipynb [(#85)](https://github.com/pysal/spaghetti/pull/85)
* updating Facility_Location.ipynb for typos [(#84)](https://github.com/pysal/spaghetti/pull/84)
* adding Facility_Location.ipynb [(#83)](https://github.com/pysal/spaghetti/pull/83)
* new notebook ideas [(#48)](https://github.com/pysal/spaghetti/issues/48)
* adding windows functionality for 'last updated' [(#82)](https://github.com/pysal/spaghetti/pull/82)
* ensure nearest nodes are returned as np.array() [(#73)](https://github.com/pysal/spaghetti/pull/73)
* snapping trouble when the initial node in KDtree is the nearest [(#72)](https://github.com/pysal/spaghetti/issues/72)
* add Github version badge [(#80)](https://github.com/pysal/spaghetti/issues/80)
* add open issues badge [(#79)](https://github.com/pysal/spaghetti/issues/79)
* update notebooks as per pysal/pysal#1057 [(#81)](https://github.com/pysal/spaghetti/issues/81)
* [Complete/Needs Review] updating `in_shp` parameter in spaghetti.Network [(#69)](https://github.com/pysal/spaghetti/pull/69)
* [ENH] geopandas.GeoDataFrame for PointPattern [(#28)](https://github.com/pysal/spaghetti/issues/28)
* update in_shp kwarg in spaghetti.Network [(#68)](https://github.com/pysal/spaghetti/issues/68)
* removing undeclared edge_time attribute [(#65)](https://github.com/pysal/spaghetti/pull/65)
* update README.txt [(#33)](https://github.com/pysal/spaghetti/issues/33)
* [ENH] Add badges [(#31)](https://github.com/pysal/spaghetti/issues/31)
* Publish on Zenodo [(#36)](https://github.com/pysal/spaghetti/issues/36)
* Some errors in node_distance_matrix() [(#64)](https://github.com/pysal/spaghetti/issues/64)
* declare SMALL as np.finfo(float).eps [(#63)](https://github.com/pysal/spaghetti/pull/63)
* smallest numpy epsilon float? [(#61)](https://github.com/pysal/spaghetti/issues/61)
* [WIP] Prep for next pypi [(#60)](https://github.com/pysal/spaghetti/pull/60)
* mimic other pysal submodules for api removal [(#50)](https://github.com/pysal/spaghetti/issues/50)
* PEP8 compliant [(#38)](https://github.com/pysal/spaghetti/issues/38)
* update notebooks [(#43)](https://github.com/pysal/spaghetti/issues/43)
* api testing [(#59)](https://github.com/pysal/spaghetti/issues/59)
* DRY version documentation [(#53)](https://github.com/pysal/spaghetti/issues/53)
* configure travis dual testing for "Allowed Failures" to work [(#58)](https://github.com/pysal/spaghetti/pull/58)
* adding geopandas for dual travis testing [(#56)](https://github.com/pysal/spaghetti/pull/56)
* New tests required for new in_shp parameter option [(#30)](https://github.com/pysal/spaghetti/issues/30)
* fix or remove code_health badge [(#54)](https://github.com/pysal/spaghetti/issues/54)
* add .landscape.yml for code health [(#51)](https://github.com/pysal/spaghetti/issues/51)
* removing code health badge from README [(#55)](https://github.com/pysal/spaghetti/pull/55)
* adding .landscape.yml for code health [(#52)](https://github.com/pysal/spaghetti/pull/52)
* adding additional pip install instructions/options [(#35)](https://github.com/pysal/spaghetti/pull/35)
* dual testing [(#45)](https://github.com/pysal/spaghetti/issues/45)
* change libpysal imports in tests [(#46)](https://github.com/pysal/spaghetti/issues/46)
* change weights variable name [(#47)](https://github.com/pysal/spaghetti/issues/47)
* update notebooks for reorg [(#1)](https://github.com/pysal/spaghetti/issues/1)
* spaghetti/analysis.py:182: RuntimeWarning [(#42)](https://github.com/pysal/spaghetti/issues/42)
* change xrange to range [(#40)](https://github.com/pysal/spaghetti/issues/40)
* summation error in computeobserved() of spaghetti.analysis.py [(#41)](https://github.com/pysal/spaghetti/issues/41)
* TypeError: can't pickle dict_keys objects [(#39)](https://github.com/pysal/spaghetti/issues/39)
* add CHANGELOG [(#34)](https://github.com/pysal/spaghetti/issues/34)
* update import scheme for new package name [(#5)](https://github.com/pysal/spaghetti/issues/5)
* Prepare a release of spaghetti for pypi [(#26)](https://github.com/pysal/spaghetti/issues/26)
* pip [(#32)](https://github.com/pysal/spaghetti/issues/32)
* preparing for pypi release [(#25)](https://github.com/pysal/spaghetti/pull/25)
* api.py tests [(#19)](https://github.com/pysal/spaghetti/issues/19)
* trailing comma not allowed with surrounding parenthesis [(#29)](https://github.com/pysal/spaghetti/issues/29)
* Necessity of __future__? [(#27)](https://github.com/pysal/spaghetti/issues/27)
* `spaghetti` currently only python 2.7.x compatible [(#21)](https://github.com/pysal/spaghetti/issues/21)
* Geopandas read [(#22)](https://github.com/pysal/spaghetti/pull/22)
* Py2topy3 [(#23)](https://github.com/pysal/spaghetti/pull/23)
* Spaghetti/update travis [(#24)](https://github.com/pysal/spaghetti/pull/24)
* Generalize the Network input API for libpysal/#59 [(#20)](https://github.com/pysal/spaghetti/issues/20)


<a name="mapclassify"></a>
### mapclassify
* fix doctests (interactive examples in inline docstrings) [(#19)](https://github.com/pysal/mapclassify/pull/19)
* complete readthedocs configuration & add Slocum 2009 reference [(#17)](https://github.com/pysal/mapclassify/pull/17)
* prepping for a doc based release [(#15)](https://github.com/pysal/mapclassify/pull/15)
* new release on pypi [(#10)](https://github.com/pysal/mapclassify/issues/10)
* prepare for release 2.0.0 [(#13)](https://github.com/pysal/mapclassify/pull/13)
* Clean up for next pypi release [(#12)](https://github.com/pysal/mapclassify/pull/12)
* move notebooks outside of the package [(#11)](https://github.com/pysal/mapclassify/pull/11)
* ENH: move classifiers up into init [(#9)](https://github.com/pysal/mapclassify/pull/9)
* Moving to python 3+ [(#8)](https://github.com/pysal/mapclassify/pull/8)


<a name="splot"></a>
### splot
* merge Sprint with master branch [(#39)](https://github.com/pysal/splot/pull/39)
* Change documentation style [(#38)](https://github.com/pysal/splot/pull/38)
* add travis build badge to README.md [(#37)](https://github.com/pysal/splot/pull/37)
* fix current documentation for sprint [(#36)](https://github.com/pysal/splot/pull/36)
* `value_by_alpha` prototype [(#28)](https://github.com/pysal/splot/pull/28)
* Clean up of current code base [(#30)](https://github.com/pysal/splot/pull/30)
* Value By Alpha specification [(#24)](https://github.com/pysal/splot/issues/24)
* nonplanar example update [(#33)](https://github.com/pysal/splot/issues/33)
* add README.md [(#29)](https://github.com/pysal/splot/pull/29)
* issues in some docstrings for giddy [(#26)](https://github.com/pysal/splot/issues/26)
* debug `splot` documentation [(#25)](https://github.com/pysal/splot/pull/25)
* collection of cleanups for`splot.giddy`  [(#23)](https://github.com/pysal/splot/pull/23)
* created `esda.moran.Moran_Local_BV` visualisations [(#20)](https://github.com/pysal/splot/pull/20)
* add `esda.moran.Moran_BV` visualizations to `splot.esda` [(#18)](https://github.com/pysal/splot/pull/18)
* add `seaborn` and `matplotlib` to `install_requirements` in `setup.py` [(#19)](https://github.com/pysal/splot/pull/19)
* prototype `moran_scatterplot()`, `plot_moran_simulation()` and `plot_moran()` for `esda` [(#17)](https://github.com/pysal/splot/pull/17)
* include utility functions `shift_colormap` and `truncate_colormap` [(#15)](https://github.com/pysal/splot/pull/15)
* fix setup.py so files are installed with "pip install ." [(#16)](https://github.com/pysal/splot/pull/16)
* `plot_spatial_weights` including network joins for `non_planar_joins` [(#14)](https://github.com/pysal/splot/pull/14)
* adapting existing `esda` functionality to `splot.esda` namespace and allow `.plot()` method [(#13)](https://github.com/pysal/splot/pull/13)
* adding license [(#4)](https://github.com/pysal/splot/pull/4)
* add `giddy` dynamic LISA functionality under `splot.giddy` [(#11)](https://github.com/pysal/splot/pull/11)
* start sphinx html documentation [(#12)](https://github.com/pysal/splot/pull/12)
* add visualization option with significance to mplot [(#7)](https://github.com/pysal/splot/pull/7)
* Visualising Local Autocorrelation [(#8)](https://github.com/pysal/splot/pull/8)
* Copy new changes made to viz module into split [(#5)](https://github.com/pysal/splot/pull/5)
* run 2to3 for splot [(#6)](https://github.com/pysal/splot/pull/6)


<a name="spreg"></a>
### spreg
* update docstrings for libpysal API changes [(#9)](https://github.com/pysal/spreg/pull/9)
* Merging in spanel & spreg2 code necessary for new spatial panel & GeoDaSpace [(#10)](https://github.com/pysal/spreg/pull/10)
* move to silence_warnings from current libpysal [(#7)](https://github.com/pysal/spreg/pull/7)
* add init to ensure tests are shipped [(#6)](https://github.com/pysal/spreg/pull/6)
* weights typechecking will only accept things from `pysal`.  [(#3)](https://github.com/pysal/spreg/issues/3)
* relax error checking in check_weights [(#4)](https://github.com/pysal/spreg/pull/4)
* simplify testing [(#5)](https://github.com/pysal/spreg/pull/5)
* Convert spreg to common subset 2,3 code [(#2)](https://github.com/pysal/spreg/pull/2)


<a name="spglm"></a>
### spglm
* fix docstrings (as well as some within interactive examples) [(#14)](https://github.com/pysal/spglm/pull/14)
* Fix docs [(#17)](https://github.com/pysal/spglm/pull/17)
* Submodule [(#16)](https://github.com/pysal/spglm/pull/16)
* submodule_contract [(#13)](https://github.com/pysal/spglm/pull/13)
* Inconsistent metadata in setup.py [(#10)](https://github.com/pysal/spglm/issues/10)
* adapting spglm to new libpysal [(#12)](https://github.com/pysal/spglm/pull/12)
* move to using libpysal.io.open rather than just libpysal.open [(#11)](https://github.com/pysal/spglm/pull/11)
* Freeze [(#8)](https://github.com/pysal/spglm/pull/8)
* add tr_S attribute for use in GWR [(#7)](https://github.com/pysal/spglm/pull/7)
* remove pysal requirements [(#6)](https://github.com/pysal/spglm/pull/6)
* remove v 2.x tests from CI [(#5)](https://github.com/pysal/spglm/pull/5)
* houskeeping of new basefiles needed as a submodule [(#4)](https://github.com/pysal/spglm/pull/4)


<a name="spint"></a>
### spint
* add changelog [(#15)](https://github.com/pysal/spint/pull/15)
* pypi files do not include tests [(#9)](https://github.com/pysal/spint/issues/9)
* Submodule [(#14)](https://github.com/pysal/spint/pull/14)
* adapting spint to newest version of libpysal [(#13)](https://github.com/pysal/spint/pull/13)
* Reorg [(#12)](https://github.com/pysal/spint/pull/12)
* spint has pysal as a dependency, should be libpysal [(#2)](https://github.com/pysal/spint/issues/2)
* api.py syntax error [(#10)](https://github.com/pysal/spint/issues/10)
* removed trailing api comma [(#11)](https://github.com/pysal/spint/pull/11)
* Freeze [(#8)](https://github.com/pysal/spint/pull/8)
* update dependencies [(#7)](https://github.com/pysal/spint/pull/7)
* remove v 2.x test from CI [(#6)](https://github.com/pysal/spint/pull/6)
* version bump [(#5)](https://github.com/pysal/spint/pull/5)
* Common subset [(#4)](https://github.com/pysal/spint/pull/4)
* houskeeping of basefiles needed for submodule  [(#3)](https://github.com/pysal/spint/pull/3)


<a name="mgwr"></a>
### mgwr
* add solve from scipy instead of inv [(#45)](https://github.com/pysal/mgwr/pull/45)
* bool variables and singular matrix error [(#42)](https://github.com/pysal/mgwr/issues/42)
* update travis.yml for matrix testing [(#44)](https://github.com/pysal/mgwr/pull/44)
* add changelog [(#43)](https://github.com/pysal/mgwr/pull/43)
*  fix compare_surfaces docstrings  [(#40)](https://github.com/pysal/mgwr/pull/40)
* add docs for viz function compare_surfaces [(#39)](https://github.com/pysal/mgwr/pull/39)
* add compare_surfaces docstring and bump version [(#38)](https://github.com/pysal/mgwr/pull/38)
* add viz functions to docs [(#37)](https://github.com/pysal/mgwr/pull/37)
* add_map_func [(#36)](https://github.com/pysal/mgwr/pull/36)
* add badges to README [(#35)](https://github.com/pysal/mgwr/pull/35)
* (ENH) prepare online docs [(#33)](https://github.com/pysal/mgwr/pull/33)
* Revert "move notebooks outside of the package folder and fix notebooks" [(#34)](https://github.com/pysal/mgwr/pull/34)
* move notebooks outside of the package folder and fix notebooks [(#32)](https://github.com/pysal/mgwr/pull/32)
* Georgia main example patch [(#31)](https://github.com/pysal/mgwr/pull/31)
* format gwr.py following PEP 8 style and fix docstrings [(#30)](https://github.com/pysal/mgwr/pull/30)
* use libpysal in docstrings and adapt to python 3 syntax [(#29)](https://github.com/pysal/mgwr/pull/29)
* Inconsistent metadata info on setup.py [(#25)](https://github.com/pysal/mgwr/issues/25)
* rebuild rights access? [(#28)](https://github.com/pysal/mgwr/issues/28)
* swap to libpysal.io.open [(#26)](https://github.com/pysal/mgwr/pull/26)
* adapting mgwr to newest libpysal [(#27)](https://github.com/pysal/mgwr/pull/27)
* change spreg import pattern [(#24)](https://github.com/pysal/mgwr/pull/24)
* change imports from spreg [(#22)](https://github.com/pysal/mgwr/issues/22)
* rework pickles in the tests [(#21)](https://github.com/pysal/mgwr/issues/21)
* Swap to use more portable types than pickles [(#23)](https://github.com/pysal/mgwr/pull/23)
* Output summary [(#17)](https://github.com/pysal/mgwr/issues/17)
* Adding summary output [(#18)](https://github.com/pysal/mgwr/pull/18)
* Freeze [(#20)](https://github.com/pysal/mgwr/pull/20)
* Allow user-set BW's for MGWR [(#7)](https://github.com/pysal/mgwr/issues/7)
* Set mgwr bw [(#15)](https://github.com/pysal/mgwr/pull/15)
* adds py27 to ci [(#16)](https://github.com/pysal/mgwr/pull/16)
* Gwr to mgwr [(#14)](https://github.com/pysal/mgwr/pull/14)
* Standard errors and t-vals [(#8)](https://github.com/pysal/mgwr/issues/8)
* Redundant calculation of Aj [(#10)](https://github.com/pysal/mgwr/issues/10)
* question about final fit in MGWR class?  [(#1)](https://github.com/pysal/mgwr/issues/1)
* change main directory from gwr to mgwr [(#13)](https://github.com/pysal/mgwr/pull/13)
* Update mgwr [(#12)](https://github.com/pysal/mgwr/pull/12)
* clean up MGWR [(#11)](https://github.com/pysal/mgwr/pull/11)
* Consolidate MGWR [(#5)](https://github.com/pysal/mgwr/pull/5)
* hat matrices [(#2)](https://github.com/pysal/mgwr/issues/2)


<a name="spvcm"></a>
### spvcm
* change the API to reflect up-to-date libpysal api [(#7)](https://github.com/pysal/spvcm/pull/7)
* Test failures in effective size & geweke diagnostics [(#2)](https://github.com/pysal/spvcm/issues/2)
* update plotting and diagnostics for pandas deprecation [(#3)](https://github.com/pysal/spvcm/pull/3)

<a name="summary-statistics"></a>
## Summary Statistics

<a name="package-activity"></a>
### Package Activity
<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th>package</th>
      <th>commits</th>
      <th>total issues</th>
      <th>pulls</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>spaghetti</td>
      <td>282</td>
      <td>94</td>
      <td>34</td>
    </tr>
    <tr>
      <td>libpysal</td>
      <td>276</td>
      <td>79</td>
      <td>57</td>
    </tr>
    <tr>
      <td>splot</td>
      <td>247</td>
      <td>27</td>
      <td>21</td>
    </tr>
    <tr>
      <td>mgwr</td>
      <td>245</td>
      <td>39</td>
      <td>24</td>
    </tr>
    <tr>
      <td>giddy</td>
      <td>137</td>
      <td>38</td>
      <td>31</td>
    </tr>
    <tr>
      <td>esda</td>
      <td>80</td>
      <td>29</td>
      <td>19</td>
    </tr>
    <tr>
      <td>spglm</td>
      <td>70</td>
      <td>12</td>
      <td>9</td>
    </tr>
    <tr>
      <td>spint</td>
      <td>63</td>
      <td>14</td>
      <td>11</td>
    </tr>
    <tr>
      <td>spreg</td>
      <td>57</td>
      <td>8</td>
      <td>6</td>
    </tr>
    <tr>
      <td>spvcm</td>
      <td>55</td>
      <td>3</td>
      <td>1</td>
    </tr>
    <tr>
      <td>mapclassify</td>
      <td>48</td>
      <td>9</td>
      <td>8</td>
    </tr>
    <tr>
      <td>pointpats</td>
      <td>40</td>
      <td>10</td>
      <td>10</td>
    </tr>
    <tr>
      <td>inequality</td>
      <td>36</td>
      <td>6</td>
      <td>5</td>
    </tr>
  </tbody>
</table>

<a name="contributor-activity"></a>
### Contributor Activity
<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>commits</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>Dani Arribas-Bel</th>
      <td>25</td>
    </tr>
    <tr>
      <th>Eli Knaap</th>
      <td>14</td>
    </tr>
    <tr>
      <th>Hu Shao</th>
      <td>5</td>
    </tr>
    <tr>
      <th>James Gaboardi</th>
      <td>314</td>
    </tr>
    <tr>
      <th>Jsignell</th>
      <td>1</td>
    </tr>
    <tr>
      <th>Levi John Wolf</th>
      <td>262</td>
    </tr>
    <tr>
      <th>Philip Kahn</th>
      <td>2</td>
    </tr>
    <tr>
      <th>Serge Rey</th>
      <td>239</td>
    </tr>
    <tr>
      <th>Stefanie Lumnitz</th>
      <td>240</td>
    </tr>
    <tr>
      <th>Taylor Oshan</th>
      <td>243</td>
    </tr>
    <tr>
      <th>Thequackdaddy</th>
      <td>1</td>
    </tr>
    <tr>
      <th>Wei Kang</th>
      <td>225</td>
    </tr>
    <tr>
      <th>Ziqi Li</th>
      <td>51</td>
    </tr>
  </tbody>
</table>

<a name="contributor-by-package-activity"></a>
### Contributor by Package Activity
<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>Dani Arribas-Bel</th>
      <th>Eli Knaap</th>
      <th>Hu Shao</th>
      <th>James Gaboardi</th>
      <th>Jsignell</th>
      <th>Levi John Wolf</th>
      <th>Philip Kahn</th>
      <th>Serge Rey</th>
      <th>Stefanie Lumnitz</th>
      <th>Taylor Oshan</th>
      <th>Thequackdaddy</th>
      <th>Wei Kang</th>
      <th>Ziqi Li</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>lib.libpysal</th>
      <td>19</td>
      <td>12</td>
      <td>0</td>
      <td>8</td>
      <td>0</td>
      <td>112</td>
      <td>0</td>
      <td>101</td>
      <td>2</td>
      <td>4</td>
      <td>0</td>
      <td>18</td>
      <td>0</td>
    </tr>
    <tr>
      <th>explore.esda</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>1</td>
      <td>0</td>
      <td>11</td>
      <td>0</td>
      <td>50</td>
      <td>10</td>
      <td>0</td>
      <td>0</td>
      <td>8</td>
      <td>0</td>
    </tr>
    <tr>
      <th>explore.giddy</th>
      <td>0</td>
      <td>2</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>1</td>
      <td>0</td>
      <td>18</td>
      <td>10</td>
      <td>0</td>
      <td>0</td>
      <td>103</td>
      <td>0</td>
    </tr>
    <tr>
      <th>explore.inequality</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>1</td>
      <td>0</td>
      <td>20</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>11</td>
      <td>0</td>
    </tr>
    <tr>
      <th>explore.pointpats</th>
      <td>0</td>
      <td>0</td>
      <td>5</td>
      <td>0</td>
      <td>0</td>
      <td>7</td>
      <td>0</td>
      <td>2</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>26</td>
      <td>0</td>
    </tr>
    <tr>
      <th>explore.spaghetti</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>278</td>
      <td>0</td>
      <td>3</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>1</td>
      <td>0</td>
    </tr>
    <tr>
      <th>viz.mapclassify</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>3</td>
      <td>0</td>
      <td>22</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>23</td>
      <td>0</td>
    </tr>
    <tr>
      <th>viz.splot</th>
      <td>6</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>1</td>
      <td>9</td>
      <td>0</td>
      <td>7</td>
      <td>218</td>
      <td>0</td>
      <td>1</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <th>model.spreg</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>40</td>
      <td>0</td>
      <td>17</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
    <tr>
      <th>model.spglm</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>7</td>
      <td>0</td>
      <td>1</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>60</td>
      <td>0</td>
      <td>1</td>
      <td>0</td>
    </tr>
    <tr>
      <th>model.spint</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>7</td>
      <td>0</td>
      <td>9</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>42</td>
      <td>0</td>
      <td>4</td>
      <td>0</td>
    </tr>
    <tr>
      <th>model.mgwr</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>12</td>
      <td>0</td>
      <td>13</td>
      <td>2</td>
      <td>0</td>
      <td>0</td>
      <td>137</td>
      <td>0</td>
      <td>30</td>
      <td>51</td>
    </tr>
    <tr>
      <th>model.spvcm</th>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>1</td>
      <td>0</td>
      <td>52</td>
      <td>0</td>
      <td>2</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
      <td>0</td>
    </tr>
  </tbody>
</table>



# PySAL 1.14.3, 2017-11-2


GitHub stats for 2017/09/23 - 2017/11/02 

These lists are automatically generated, and may be incomplete or contain duplicates.


We closed a total of 31 issues, 8 pull requests and 23 regular issues;
this is the full list (generated with the script 
:file:`tools/github_stats.py`):

Pull Requests (8):

* :ghpull:`997`: b'edit README.md for example datasets'
* :ghpull:`999`: b'Raise ImportError on missing palettable and PEP8'
* :ghpull:`983`: b'Fix inconsistent use of tabs and spaces in indentation.'
* :ghpull:`995`: b'Foliumfix'
* :ghpull:`993`: b'B991'
* :ghpull:`988`: b'Resolve issue of "False" "id_order_set" when building contiguity weights from shapefile even if `idVariable` is given in initialization'
* :ghpull:`982`: b'update release instructions for new test.pypi'
* :ghpull:`979`: b'Rel 1.14.2'

Issues (23):

* :ghissue:`997`: b'edit README.md for example datasets'
* :ghissue:`970`: b'Odd pysal.Moran() randomisation VI'
* :ghissue:`999`: b'Raise ImportError on missing palettable and PEP8'
* :ghissue:`998`: b'Should missing palettable be a warning or error? '
* :ghissue:`981`: b'mixed indentation in `iwls`'
* :ghissue:`987`: b"discrepancy in EB Local Moran's I with PySAL vs. GeoDa results"
* :ghissue:`992`: b'Scipy 1.0.0 Compat issues'
* :ghissue:`991`: b'Chisqprob is deprecated'
* :ghissue:`983`: b'Fix inconsistent use of tabs and spaces in indentation.'
* :ghissue:`996`: b'edit README for example datasets'
* :ghissue:`989`: b"resolve discrepancy of estimating Moran's I corrected for rates between GeoDa and pysal"
* :ghissue:`995`: b'Foliumfix'
* :ghissue:`994`: b'folium breakage'
* :ghissue:`971`: b'base_lisa_cluster function call does not pass p_thresh'
* :ghissue:`993`: b'B991'
* :ghissue:`984`: b'Level dev & master, incorporate 983'
* :ghissue:`990`: b'problem with open shp file'
* :ghissue:`988`: b'Resolve issue of "False" "id_order_set" when building contiguity weights from shapefile even if `idVariable` is given in initialization'
* :ghissue:`980`: b'release documentation test pypi is out of date'
* :ghissue:`982`: b'update release instructions for new test.pypi'
* :ghissue:`978`: b'Coordinate releases on pypi and github'
* :ghissue:`976`: b'bump  pysal/pysal/version.py please'
* :ghissue:`979`: b'Rel 1.14.2'

v<1.14.2>, 2017-09-23
This is a bug fix release for the 1.14 Python 2.x. series of PySAL.

We closed a total of 8 issues, 3 pull requests and 5 regular issues;
this is the full list (generated with the script 
:file:`tools/github_stats.py`):

Pull Requests (3):

* :ghpull:`975`: Correction of Geary's C under randomization
* :ghpull:`972`: Bug Fix for #970
* :ghpull:`973`: Passing p_thres in plot_lisa_cluster. This fixes #971

Issues (5):

* :ghissue:`974`: Re: #979
* :ghissue:`975`: Correction of Geary's C under randomization
* :ghissue:`972`: Bug Fix for #970
* :ghissue:`973`: Passing p_thres in plot_lisa_cluster. This fixes #971
* :ghissue:`968`: find_bin does not include top value


v<1.14.0>, 2017-07-13

This is the last version of PySAL that will officially support Python 2.x. 
This version will also receive only bug fixes going forward. All new PySAL
functionality will be added using the new structure documented at pysal.org.


We closed a total of 114 issues, 36 pull requests and 78 regular issues;
this is the full list (generated with the script 
:file:`tools/github_stats.py`):

Pull Requests (36):

* :ghpull:`915`: Network  dev
* :ghpull:`911`: coverage change
* :ghpull:`931`: Fix for negative values of ebi_v in assancao_rate smoother function
* :ghpull:`955`: Minor corrections to issue template
* :ghpull:`888`: Fix unusual interpreter path.
* :ghpull:`926`: DOC: fix a broken link (HTTP 404) in documentation
* :ghpull:`951`: Order enforce
* :ghpull:`953`: deprecating headbanging
* :ghpull:`952`: fix for #932 coordinates need to be (lon, lat) not (lat, lon)
* :ghpull:`946`: [WIP] add Distance bugfix
* :ghpull:`942`: fixed the bug in reading the new ArcGIS .swm file
* :ghpull:`947`: [WIP] fix bug #944
* :ghpull:`950`: Lag cat fix
* :ghpull:`928`: Fixed incorrect file path in fileio.rst
* :ghpull:`927`: DOC: fix formatting of a code block in the documentation
* :ghpull:`934`: Added String_Type values to unsupported file types
* :ghpull:`929`: DOC: make code snippet in documentation compatible to Python 3
* :ghpull:`924`: add pseudocode makefile
* :ghpull:`916`: Util.compute length
* :ghpull:`919`: Dijkstra mp
* :ghpull:`921`: Mapping: allow tips parameter even if col not passed
* :ghpull:`912`: adjust the formula for calculating local Moran's I in the docs
* :ghpull:`913`: 0. Fixed docstring that was causing latex error
* :ghpull:`910`: add new weights classes & methods to docs & tutorials
* :ghpull:`908`: Geographically weighted regresson
* :ghpull:`907`: Spint
* :ghpull:`905`: Spint - fix local param indexing
* :ghpull:`904`: Rc1.13.1
* :ghpull:`903`: Fix for numpy bump induced breakage
* :ghpull:`902`: Spreg fix
* :ghpull:`901`: Badge for docs
* :ghpull:`899`: fix inplace overwrite issue
* :ghpull:`897`: fix minor typo
* :ghpull:`887`: Dev version bump
* :ghpull:`885`: Fixing doc builds
* :ghpull:`883`: release 1.13.0

Issues (78):

* :ghissue:`892`: allow non-binary weights to propagate in w_subset
* :ghissue:`915`: Network  dev
* :ghissue:`925`: Reorg
* :ghissue:`911`: coverage change
* :ghissue:`848`: Points contrib module
* :ghissue:`931`: Fix for negative values of ebi_v in assancao_rate smoother function
* :ghissue:`956`: Nose tests fail for python 3 in Windows
* :ghissue:`917`: Code not updated in docs
* :ghissue:`943`: mapclassify docs contain a long WARNING
* :ghissue:`948`: test_Headbanging_Median_Rate fails with Python 3.6
* :ghissue:`955`: Minor corrections to issue template
* :ghissue:`958`: Estimate panel models in spreg
* :ghissue:`949`: spreg request: Conley standard errors
* :ghissue:`888`: Fix unusual interpreter path.
* :ghissue:`926`: DOC: fix a broken link (HTTP 404) in documentation
* :ghissue:`951`: Order enforce
* :ghissue:`953`: deprecating headbanging
* :ghissue:`313`: Add handler for topojson
* :ghissue:`316`: Add support for geojson 
* :ghissue:`721`: Ability to specify categories / ranges in spatial markov method
* :ghissue:`474`: Add contrib module to explore interface with geopandas
* :ghissue:`651`: Design Point Pattern API
* :ghissue:`648`: FileIO deprecation warning
* :ghissue:`891`: Strange weights when I apply w_subset
* :ghissue:`201`: Distance matrix builder
* :ghissue:`872`: `weights.util.higher_order` warns when using a subclassed `W`
* :ghissue:`923`: Arc_KDTree returned distances incorrect
* :ghissue:`952`: fix for #932 coordinates need to be (lon, lat) not (lat, lon)
* :ghissue:`945`: `DistanceBand` failing when `ids` passed
* :ghissue:`946`: [WIP] add Distance bugfix
* :ghissue:`939`: Compute spatial weight matrix from geopandas dataframe
* :ghissue:`937`: Can't read ESRI spatial weights matrix
* :ghissue:`942`: fixed the bug in reading the new ArcGIS .swm file
* :ghissue:`729`: Update contrib docs
* :ghissue:`947`: [WIP] fix bug #944
* :ghissue:`950`: Lag cat fix
* :ghissue:`944`: Higher Order Weights from Queen Contiguity Weights - Unsupported sparse argument
* :ghissue:`922`: Weights, ordering, and from_dataframe
* :ghissue:`940`: Add a Gitter chat badge to README.md
* :ghissue:`928`: Fixed incorrect file path in fileio.rst
* :ghissue:`906`: GSOC 2017
* :ghissue:`938`: I use  “Markov(class_ids, classes=None)” ,classes (array) – (k, 1), define k=4, but the result display error.
* :ghissue:`927`: DOC: fix formatting of a code block in the documentation
* :ghissue:`935`: Creating Network instance from road shapefile fails; ValueError: list.remove(x): x not in list
* :ghissue:`932`: Opening PolyLineM Shapefile fails to return file type unsupported error
* :ghissue:`934`: Added String_Type values to unsupported file types
* :ghissue:`929`: DOC: make code snippet in documentation compatible to Python 3
* :ghissue:`924`: add pseudocode makefile
* :ghissue:`916`: Util.compute length
* :ghissue:`919`: Dijkstra mp
* :ghissue:`866`: Use install_requires to automatically install required packages if they are not present
* :ghissue:`921`: Mapping: allow tips parameter even if col not passed
* :ghissue:`914`: added wkt representation for chain/polygon
* :ghissue:`918`: Python 3.5, pysal FileIO import error
* :ghissue:`912`: adjust the formula for calculating local Moran's I in the docs
* :ghissue:`913`: 0. Fixed docstring that was causing latex error
* :ghissue:`910`: add new weights classes & methods to docs & tutorials
* :ghissue:`908`: Geographically weighted regresson
* :ghissue:`907`: Spint
* :ghissue:`905`: Spint - fix local param indexing
* :ghissue:`904`: Rc1.13.1
* :ghissue:`896`: test_Headbanging_Median_Rate fails
* :ghissue:`903`: Fix for numpy bump induced breakage
* :ghissue:`902`: Spreg fix
* :ghissue:`901`: Badge for docs
* :ghissue:`899`: fix inplace overwrite issue
* :ghissue:`610`: SpReg Deprecation Warning
* :ghissue:`895`: Weights for rasters or arrays with missing data
* :ghissue:`897`: fix minor typo
* :ghissue:`881`: Readthedocs failing to build due to missing ingmath module
* :ghissue:`893`: DistanceBand error (AttributeError: power not found)
* :ghissue:`890`: no neighbors on threshold_continuousW, after w_subset
* :ghissue:`887`: Dev version bump
* :ghissue:`886`: Dev
* :ghissue:`885`: Fixing doc builds
* :ghissue:`884`: Rel/1.13.1
* :ghissue:`883`: release 1.13.0
* :ghissue:`876`: changing shp.next() to next(shp)

v<1.13.0>, 2016-11-24

We closed a total of 38 issues, 7 pull requests and 31 regular issues;
this is the full list (generated with the script 
:file:`tools/github_stats.py`):

Pull Requests (7):

* :ghpull:`844`: Geotable plot
* :ghpull:`875`: Spint constant
* :ghpull:`874`: Use standard python facilites for warning
* :ghpull:`873`: updating release schedule
* :ghpull:`871`: Put requirements into setup.py so they are installed if missing
* :ghpull:`870`: Doc/release
* :ghpull:`869`: Dev

Issues (31):

* :ghissue:`844`: Geotable plot
* :ghissue:`877`: documentation links to numpy and scipy are broken
* :ghissue:`875`: Spint constant
* :ghissue:`874`: Use standard python facilites for warning
* :ghissue:`873`: updating release schedule
* :ghissue:`871`: Put requirements into setup.py so they are installed if missing
* :ghissue:`591`: check pysal version and report if a more recent stable version is available
* :ghissue:`410`: prototype LISA cluster map
* :ghissue:`333`: Add k functions
* :ghissue:`274`: Implement LISA in network module
* :ghissue:`746`: Network data structures
* :ghissue:`751`: A method to get a list of example-files by type
* :ghissue:`219`: inconsistent treatment of centroids in arc distance calculations in weights/user.py
* :ghissue:`173`: implement cross sectional and space-time scan statistics
* :ghissue:`170`: centralize all kernel based calculations
* :ghissue:`134`: Complete cg.locators
* :ghissue:`94`: Smoothing: add another module based on model-based smoothing
* :ghissue:`91`: Smoothing: Develop simulations for comparing different smoothers 
* :ghissue:`90`: Overhaul Polygon class
* :ghissue:`89`: Optimize shapefile reader 
* :ghissue:`88`: Optimize Clockwise test
* :ghissue:`86`: Spatial_Dynamics: LISA Time paths
* :ghissue:`85`: Spatial_Dynamics: modified knox statistic
* :ghissue:`84`: Spatial_Dynamics: Optimize Theta
* :ghissue:`652`: Use cKDtree for Arc_KDTree
* :ghissue:`697`: Update Release Management to Support Rolling Releases
* :ghissue:`761`: Object-oriented design for viz module
* :ghissue:`767`: ZeroDivisonError when calculating certain centroids
* :ghissue:`849`: dbf2df can not read dbf files within which there are Chinese characters
* :ghissue:`870`: Doc/release
* :ghissue:`869`: Dev

v<1.12.0>, 2016-09-21

We closed a total of 100 issues, 33 pull requests and 67 regular issues;
this is the full list (generated with the script 
:file:`tools/github_stats.py`):

Pull Requests (33):

* :ghpull:`864`: addressing issue #845 and adding tests
* :ghpull:`862`: Memory efficient Gini and tests
* :ghpull:`865`: fix space/tab inconsistency
* :ghpull:`861`: GSOC -SpInt
* :ghpull:`847`: spatial interaction weights 
* :ghpull:`863`: B859
* :ghpull:`860`: Incoprate updates to db driver and unittests
* :ghpull:`858`: Dev mltest
* :ghpull:`857`: Fix TabErrors, replace tabs with spaces
* :ghpull:`856`: Make the output and build reproducible
* :ghpull:`851`: fixed typo in test_network.py
* :ghpull:`850`: [REBASE] Distance band speed ups
* :ghpull:`843`: update and clean aesthetic of Network_Usage.ipynb
* :ghpull:`842`: typo correction in network.py
* :ghpull:`841`: [REBASE & REDIRECT] Conditional Database Imports & Docos, #692
* :ghpull:`840`: minor bugfix to #816
* :ghpull:`839`: documentation cleanup on network.analysis.py
* :ghpull:`838`: network.util.py documentation cleanup 
* :ghpull:`836`: re: network.py documentation cleanup
* :ghpull:`768`: Modified the way area of a ring is calculated to allow for more precision
* :ghpull:`829`: numba autojit _fisher_jenks_means if numba is available
* :ghpull:`832`: Handling a deprecation warning, and latex errors corrected.
* :ghpull:`834`: Travis testing matrix
* :ghpull:`831`: Refactoring Markov classes for efficiency
* :ghpull:`827`: ESDA Tabular Functions
* :ghpull:`823`: typo and format of docstring of user.py in weights module
* :ghpull:`821`: Pdio
* :ghpull:`817`: D/sur
* :ghpull:`818`: Documentation fix + some PEP8 standardization
* :ghpull:`811`: DistanceBand should correctly handle named weights
* :ghpull:`808`: Dev
* :ghpull:`807`: Updating contrib docs and bumping version for dev
* :ghpull:`797`: working moran plot func

Issues (67):

* :ghissue:`855`: Inefficient Gini Coefficient calculation?
* :ghissue:`864`: addressing issue #845 and adding tests
* :ghissue:`862`: Memory efficient Gini and tests
* :ghissue:`865`: fix space/tab inconsistency
* :ghissue:`861`: GSOC -SpInt
* :ghissue:`847`: spatial interaction weights 
* :ghissue:`859`: Wrong there is one disconnected observation (no neighbors)
* :ghissue:`863`: B859
* :ghissue:`860`: Incoprate updates to db driver and unittests
* :ghissue:`858`: Dev mltest
* :ghissue:`857`: Fix TabErrors, replace tabs with spaces
* :ghissue:`854`: handle verication context for githubstats
* :ghissue:`856`: Make the output and build reproducible
* :ghissue:`851`: fixed typo in test_network.py
* :ghissue:`850`: [REBASE] Distance band speed ups
* :ghissue:`846`: DistanceBand speed ups
* :ghissue:`843`: update and clean aesthetic of Network_Usage.ipynb
* :ghissue:`842`: typo correction in network.py
* :ghissue:`692`: Conditional Database Import / Docos
* :ghissue:`841`: [REBASE & REDIRECT] Conditional Database Imports & Docos, #692
* :ghissue:`769`: Windows 7, 64 bit installation issue with visual C++ for python
* :ghissue:`816`: Exception TypeError in geoda_txt.py
* :ghissue:`840`: minor bugfix to #816
* :ghissue:`839`: documentation cleanup on network.analysis.py
* :ghissue:`397`: integrate optimized contiguity builder
* :ghissue:`531`: add user space function to generate numpy arrays
* :ghissue:`654`: meta update for 2-3 conversion
* :ghissue:`676`: Meta not importable from pysal
* :ghissue:`838`: network.util.py documentation cleanup 
* :ghissue:`753`: Fix the network ring bug
* :ghissue:`836`: re: network.py documentation cleanup
* :ghissue:`768`: Modified the way area of a ring is calculated to allow for more precision
* :ghissue:`837`: re: network.allneighbordistances() diagonal fill
* :ghissue:`822`: two issues about function choropleth_map in viz module
* :ghissue:`835`: fix deprecation warnings noted in #822
* :ghissue:`829`: numba autojit _fisher_jenks_means if numba is available
* :ghissue:`832`: Handling a deprecation warning, and latex errors corrected.
* :ghissue:`834`: Travis testing matrix
* :ghissue:`825`: Headbanging Median Rate ignores edge correction
* :ghissue:`826`: Spatial Filtering grid definition
* :ghissue:`824`: Direct Age Standardization fails for empty regions
* :ghissue:`833`: PySAL+ optional testing matrix
* :ghissue:`830`: [REBASED] PySAL+ optional testing matrix
* :ghissue:`831`: Refactoring Markov classes for efficiency
* :ghissue:`827`: ESDA Tabular Functions
* :ghissue:`815`: rook case not working in ContiguityWeightsPolygons
* :ghissue:`828`: Fisher_Jenks pure python implementation is too slow
* :ghissue:`814`: Explore Classmethods for alternative constructors
* :ghissue:`795`: switch to scipy.linalg instead of numpy.linalg
* :ghissue:`799`: w_subset(weights:W, ids:np.ndarray) constructs faulty weights object
* :ghissue:`823`: typo and format of docstring of user.py in weights module
* :ghissue:`821`: Pdio
* :ghissue:`794`: spreg ML_lag doesn't always set W in __init__
* :ghissue:`754`: Update README
* :ghissue:`819`: add LIMAs
* :ghissue:`817`: D/sur
* :ghissue:`818`: Documentation fix + some PEP8 standardization
* :ghissue:`809`: Fixed documentation
* :ghissue:`813`: w.remap_ids(ids) never sets w.id_order_set
* :ghissue:`775`: Added a prototype for constructing weights from a list of shapely Polygons
* :ghissue:`810`: DistanceBand fails to accept custom ids
* :ghissue:`811`: DistanceBand should correctly handle named weights
* :ghissue:`780`: Doctests failing on travis
* :ghissue:`801`: ImportError: No module named scipy.spatial
* :ghissue:`808`: Dev
* :ghissue:`807`: Updating contrib docs and bumping version for dev
* :ghissue:`797`: working moran plot func

v<1.11.2>, 2016-05-18

We closed a total of 20 issues, 6 pull requests and 14 regular issues;
this is the full list (generated with the script 
:file:`tools/github_stats.py`):

Pull Requests (6):

* :ghpull:`805`: pre Rel1.11.2 and #840
* :ghpull:`802`: fixed issues with model handler failing to correctly discover models
* :ghpull:`798`: fix for css problem on rtd #790
* :ghpull:`793`: Getting weights doctests to pass
* :ghpull:`791`: Doc/rolling
* :ghpull:`792`: Local Moran was using the incorrect moments in z_sim and p_z_sim

Issues (14):

* :ghissue:`805`: pre Rel1.11.2 and #840
* :ghissue:`803`: check_contiguity error.. 
* :ghissue:`802`: fixed issues with model handler failing to correctly discover models
* :ghissue:`800`: `ps.threshold_continuousW_from_shapefile` returning inf along diagonal
* :ghissue:`771`: KDtree type mismatch in knnW
* :ghissue:`798`: fix for css problem on rtd #790
* :ghissue:`796`: working moran plot func
* :ghissue:`787`: Update docs to reflect Python-3 compatibility
* :ghissue:`587`: ML Lag indexing error on optimization result
* :ghissue:`793`: Getting weights doctests to pass
* :ghissue:`791`: Doc/rolling
* :ghissue:`792`: Local Moran was using the incorrect moments in z_sim and p_z_sim
* :ghissue:`674`: Have PySAL included on OSGeo Live 9 
* :ghissue:`779`: DistanceBand include the point itself as neighbor


# PySAL 1.11.1, 2016-04-01

We closed a total of 62 issues, 20 pull requests and 42 regular issues;
this is the full list (generated with the script 
:file:`tools/github_stats.py`):

Pull Requests (20):

* :ghpull:`777`: fix minor issues with using stdlib warnings in mapclassify.py
* :ghpull:`766`: Constant check
* :ghpull:`781`: Dev
* :ghpull:`778`: Wkb
* :ghpull:`776`: Updating & find-bin-as-call for Map_Classifiers
* :ghpull:`770`: adding github chrome to make project contributions easier to handle
* :ghpull:`764`: add folium changes needed for notebook to run
* :ghpull:`760`: Update docs for #697
* :ghpull:`763`: docs fix: incorrect array dimensions listed for spatial interaction SpaceTimeEvents
* :ghpull:`756`: B726
* :ghpull:`749`: remove cruft in git root and add gitter badge to the readme
* :ghpull:`748`: Replace deprecated np.rank with np.ndim
* :ghpull:`745`: Lag Categorical & Find Bins
* :ghpull:`741`: fix for #740
* :ghpull:`739`: Dev
* :ghpull:`738`: fixing master version
* :ghpull:`737`: Bumping dev
* :ghpull:`736`: Merge pull request #734 from sjsrey/master
* :ghpull:`735`: Dev in sync with master for 1.11
* :ghpull:`734`: Release 1.11

Issues (42):

* :ghissue:`773`: add isKDTree typecomparison to handle divergent cKDTree and KDTree types
* :ghissue:`777`: fix minor issues with using stdlib warnings in mapclassify.py
* :ghissue:`766`: Constant check
* :ghissue:`782`: Contrib docs
* :ghissue:`781`: Dev
* :ghissue:`762`: viz: folium_mapping.ipynb AttributeError: 'Map' object has no attribute '_build_map'
* :ghissue:`778`: Wkb
* :ghissue:`776`: Updating & find-bin-as-call for Map_Classifiers
* :ghissue:`770`: adding github chrome to make project contributions easier to handle
* :ghissue:`774`: Added a prototype for constructing weights from a list of shapely Polygons
* :ghissue:`772`: knnW user guide doc error
* :ghissue:`765`: potential constant_check bug
* :ghissue:`759`: Fixed code in ipython notebooks
* :ghissue:`752`: [WIP] Add J function to network submodule
* :ghissue:`764`: add folium changes needed for notebook to run
* :ghissue:`760`: Update docs for #697
* :ghissue:`763`: docs fix: incorrect array dimensions listed for spatial interaction SpaceTimeEvents
* :ghissue:`750`: Add gitter badge to README on master branch
* :ghissue:`758`: Fixed code in ipython notebooks
* :ghissue:`755`: add speedup of conditional randomization
* :ghissue:`726`: Compatibility for Scipy 16.1
* :ghissue:`756`: B726
* :ghissue:`749`: remove cruft in git root and add gitter badge to the readme
* :ghissue:`587`: ML Lag
* :ghissue:`748`: Replace deprecated np.rank with np.ndim
* :ghissue:`747`: Replace deprecated np.rank with np.ndim
* :ghissue:`653`: network is returning NAN's on diagonal of distance matrix
* :ghissue:`660`: insert zeros on symmetric matrix diagonal
* :ghissue:`745`: Lag Categorical & Find Bins
* :ghissue:`744`: [REBASED] Update moran.py with much faster iterations
* :ghissue:`732`: Update moran.py with much faster iterations
* :ghissue:`743`: [REBASED]: Update moran.py with much faster iterations
* :ghissue:`742`: Links not working
* :ghissue:`740`: Moran_Local's EI is returned as an array instead of a float
* :ghissue:`741`: fix for #740
* :ghissue:`739`: Dev
* :ghissue:`738`: fixing master version
* :ghissue:`737`: Bumping dev
* :ghissue:`151`: Port pysal to python3
* :ghissue:`736`: Merge pull request #734 from sjsrey/master
* :ghissue:`735`: Dev in sync with master for 1.11
* :ghissue:`734`: Release 1.11

# PySAL 1.11.0, 2016-01-27

GitHub stats for 2015/07/29 - 2016/01/27

These lists are automatically generated, and may be incomplete or contain duplicates.

The following 13 authors contributed 216 commits.

* Dani Arribas-Bel
* David Folch
* Levi John Wolf
* Levi Wolf
* Philip Stephens
* Serge Rey
* Sergio Rey
* Wei Kang
* jlaura
* levi.john.wolf@gmail.com
* ljw
* ljwolf
* pedrovma


We closed a total of 86 issues, 33 pull requests and 53 regular issues;
this is the full list (generated with the script 
:file:`tools/github_stats.py`):

Pull Requests (33):

* :ghpull:`724`: add synchronization tool
* :ghpull:`733`: Fb/bump
* :ghpull:`731`: Small docfixes
* :ghpull:`730`: Contrib docs
* :ghpull:`728`: B179
* :ghpull:`727`: Geodf io
* :ghpull:`725`: try pinning scipy,numpy
* :ghpull:`723`: make sure to test all moran classes
* :ghpull:`720`: Moving natural breaks to a cleaner kmeans implementation
* :ghpull:`718`: force counts to be same length as bins
* :ghpull:`714`: Dev
* :ghpull:`715`: Heads
* :ghpull:`713`: Enh712
* :ghpull:`710`: Patsy/Pandas wrapper
* :ghpull:`711`: Travis fixes
* :ghpull:`706`: precommit hook
* :ghpull:`707`: Keep dev updated with any bugfixes into master
* :ghpull:`702`: fix for chi2 test 0 denominator and invocation of chi2 test in LISA_Markov
* :ghpull:`704`: Allcloser
* :ghpull:`703`: Swapping to Allclose and RTOL=.00005 in spreg
* :ghpull:`701`: By col array
* :ghpull:`700`: small optimization of bivariate moran motivated by #695
* :ghpull:`696`: Pypi
* :ghpull:`691`: Update doctest for one-off bug that was fixed with #690
* :ghpull:`690`: fix for lisa markov one off for significance indicator
* :ghpull:`689`: Clpy flex w
* :ghpull:`688`: pep 8 edits
* :ghpull:`687`: Change array assertions into allclose
* :ghpull:`686`: Moran local bivariate
* :ghpull:`684`: 591
* :ghpull:`682`: release instructions updated
* :ghpull:`681`: version bump for next dev cycle
* :ghpull:`680`: Rel1.10

Issues (53):

* :ghissue:`705`: spreg check valve
* :ghissue:`344`: Explore new dependency on ogr
* :ghissue:`459`: Problem with bandwidth
* :ghissue:`552`: Viz organization
* :ghissue:`491`: Test np.allclose() for unit tests
* :ghissue:`529`: Clarity needed on proper reference formatting in sphinx docs
* :ghissue:`699`: Trouble importing pysal - ImportError: DLL load failed
* :ghissue:`716`: `min_threshold_dist_from_shapefile` creating an island in some cases
* :ghissue:`724`: add synchronization tool
* :ghissue:`733`: Fb/bump
* :ghissue:`731`: Small docfixes
* :ghissue:`730`: Contrib docs
* :ghissue:`719`: pysal not working with matplotlib v1.5 for plot_lisa_cluster, plot_choropleth, etc.
* :ghissue:`728`: B179
* :ghissue:`727`: Geodf io
* :ghissue:`725`: try pinning scipy,numpy
* :ghissue:`723`: make sure to test all moran classes
* :ghissue:`720`: Moving natural breaks to a cleaner kmeans implementation
* :ghissue:`717`: esda.mapclassify return problematic counts when there is 0 occurrence in the last class
* :ghissue:`718`: force counts to be same length as bins
* :ghissue:`714`: Dev
* :ghissue:`712`: `block_weights` does not take argument `idVariable`
* :ghissue:`715`: Heads
* :ghissue:`713`: Enh712
* :ghissue:`710`: Patsy/Pandas wrapper
* :ghissue:`711`: Travis fixes
* :ghissue:`706`: precommit hook
* :ghissue:`708`: 2-3: is six a dependency or do we ship it?
* :ghissue:`707`: Keep dev updated with any bugfixes into master
* :ghissue:`702`: fix for chi2 test 0 denominator and invocation of chi2 test in LISA_Markov
* :ghissue:`704`: Allcloser
* :ghissue:`703`: Swapping to Allclose and RTOL=.00005 in spreg
* :ghissue:`698`: Py3merge
* :ghissue:`701`: By col array
* :ghissue:`700`: small optimization of bivariate moran motivated by #695
* :ghissue:`695`: Bivariate global moran's I formula
* :ghissue:`683`: Py3 Conversion Project
* :ghissue:`694`: Allclose in SPREG
* :ghissue:`696`: Pypi
* :ghissue:`691`: Update doctest for one-off bug that was fixed with #690
* :ghissue:`693`: Trouble installation: No module named 'shapes'
* :ghissue:`690`: fix for lisa markov one off for significance indicator
* :ghissue:`689`: Clpy flex w
* :ghissue:`688`: pep 8 edits
* :ghissue:`685`: BV Lisa 
* :ghissue:`687`: Change array assertions into allclose
* :ghissue:`686`: Moran local bivariate
* :ghissue:`677`: Make meta importable from base
* :ghissue:`684`: 591
* :ghissue:`682`: release instructions updated
* :ghissue:`679`: pysal.cg.sphere.fast_knn bug
* :ghissue:`681`: version bump for next dev cycle
* :ghissue:`680`: Rel1.10


# PySAL 1.10.0, 2015-07-29

GitHub stats for 2015/01/31 - 2015/07/29

These lists are automatically generated, and may be incomplete or contain duplicates.

The following 20 authors contributed 334 commits.

* Charlie Schmidt
* Dani Arribas-Bel
* Daniel Arribas-Bel
* David C. Folch
* David Folch
* Jay
* Levi John Wolf
* Marynia
* Philip Stephens
* Serge Rey
* Sergio Rey
* Taylor Oshan
* The Gitter Badger
* Wei Kang
* jay
* jlaura
* ljw
* ljwolf
* luc
* pedrovma


We closed a total of 156 issues, 58 pull requests and 98 regular issues;
this is the full list (generated with the script 
:file:`tools/github_stats.py`):

Pull Requests (58):

* :ghpull:`675`: Update README.md
* :ghpull:`673`: Adding init at pdutilities so they are importable
* :ghpull:`672`: ENH: option to locate legend
* :ghpull:`669`: add nonsudo travis
* :ghpull:`666`: Cleaned up conflicts in ref branch
* :ghpull:`664`: Lisa map
* :ghpull:`663`: Examples
* :ghpull:`661`: Reorganization of examples 
* :ghpull:`657`: Assuncao test division errors
* :ghpull:`649`: Add a Gitter chat badge to README.md
* :ghpull:`647`: Addresses 646
* :ghpull:`645`: Update to weights module documentation for PySAL-REST
* :ghpull:`644`: removed test print statements from df2dbf
* :ghpull:`643`: using dtypes.name in df2dbf to avoid gotcha in type
* :ghpull:`642`: Updating copyright year
* :ghpull:`634`: allows non-symmetric distance matrices
* :ghpull:`641`: turning off generatetree
* :ghpull:`592`: adding check for version #591
* :ghpull:`636`: vertical line point simulation
* :ghpull:`639`: Snapping
* :ghpull:`640`: Add users to travis
* :ghpull:`627`: Networkrb
* :ghpull:`631`: Fixing typoes in analysis.py
* :ghpull:`626`: cast arrays over inconsistent kdtree return types
* :ghpull:`620`: adding explicit check for random region contiguity
* :ghpull:`619`: Fixing spreg's warnings
* :ghpull:`618`: initial folder with dbf utilities using pandas
* :ghpull:`616`: Adding isolation and theil indices to inequality._indices.py
* :ghpull:`615`: Network docs
* :ghpull:`614`: cleaning up pr testing
* :ghpull:`613`: test coverage to 98% on network
* :ghpull:`612`: small change for testing PR
* :ghpull:`611`: stubbed in minimal tests
* :ghpull:`607`: B603
* :ghpull:`602`: Documentation Extraction Notebook
* :ghpull:`606`: pct_nonzero was reporting a ratio not a percentage
* :ghpull:`604`: Contribpush
* :ghpull:`601`: Documentation Cleanup
* :ghpull:`599`: Casting bugfix from #598
* :ghpull:`600`: Updates for coveralls
* :ghpull:`598`: IO in Python 3
* :ghpull:`597`: Decoupling bbox from map_XXX_poly
* :ghpull:`595`: Removed testing line in travis.yml and added a .coveragerc file to manag...
* :ghpull:`590`: using numpy sum method
* :ghpull:`589`: Wconstructor
* :ghpull:`588`: Coveralls
* :ghpull:`585`: Fisher Jenks bug in `plot_choropleth`
* :ghpull:`584`: Alpha in plot chor
* :ghpull:`583`: Fixed 576
* :ghpull:`580`: working on #576
* :ghpull:`578`: Fixes #577
* :ghpull:`574`: Handle case where a region has a 0 share.
* :ghpull:`571`: Dict to unique value mapper
* :ghpull:`570`: numpy doc cleanup for weights module
* :ghpull:`569`: folium viz scripts
* :ghpull:`568`: inline with numpy doc spec (spatial_dynamics module)
* :ghpull:`567`: New/masterbump
* :ghpull:`566`: Fix for 1.9.0 missing file in setup.py

Issues (98):

* :ghissue:`675`: Update README.md
* :ghissue:`658`: Travis.CI """Legacy""" architecture
* :ghissue:`667`: Examples Not Found
* :ghissue:`673`: Adding init at pdutilities so they are importable
* :ghissue:`672`: ENH: option to locate legend
* :ghissue:`669`: add nonsudo travis
* :ghissue:`671`: Shapefile Read - PolygonM Attribute Error
* :ghissue:`670`: examples README markdown files reformatting
* :ghissue:`668`: Wconstructor
* :ghissue:`666`: Cleaned up conflicts in ref branch
* :ghissue:`664`: Lisa map
* :ghissue:`662`: Pep8
* :ghissue:`665`: Refs
* :ghissue:`663`: Examples
* :ghissue:`573`: Examples
* :ghissue:`661`: Reorganization of examples 
* :ghissue:`656`: Assuncao rate improper division
* :ghissue:`657`: Assuncao test division errors
* :ghissue:`280`: handle multi-segment links in net_shp_io.py
* :ghissue:`649`: Add a Gitter chat badge to README.md
* :ghissue:`647`: Addresses 646
* :ghissue:`646`: arc distance in knnW
* :ghissue:`645`: Update to weights module documentation for PySAL-REST
* :ghissue:`644`: removed test print statements from df2dbf
* :ghissue:`643`: using dtypes.name in df2dbf to avoid gotcha in type
* :ghissue:`603`: Polygon.contains_point does not correctly process multipart polygons.
* :ghissue:`642`: Updating copyright year
* :ghissue:`623`: reading road shapfiles into network
* :ghissue:`608`: Scipy Sparse Graph
* :ghissue:`621`: network distance speedup
* :ghissue:`632`: network point snapping
* :ghissue:`633`: point to point distances on network
* :ghissue:`635`: simulating points on vertical lines
* :ghissue:`634`: allows non-symmetric distance matrices
* :ghissue:`641`: turning off generatetree
* :ghissue:`637`: speedup distance computations
* :ghissue:`592`: adding check for version #591
* :ghissue:`628`: Re-enable doctests
* :ghissue:`636`: vertical line point simulation
* :ghissue:`639`: Snapping
* :ghissue:`640`: Add users to travis
* :ghissue:`638`: Add users to Travis
* :ghissue:`627`: Networkrb
* :ghissue:`622`: New network branch from clean master
* :ghissue:`630`: NetworkG api is broken
* :ghissue:`631`: Fixing typoes in analysis.py
* :ghissue:`625`: Installation - Binstar and Anaconda
* :ghissue:`624`: Network topology
* :ghissue:`629`: changes to spreg tests for travis
* :ghissue:`166`: pysal.esda.mapclassify.Fisher_Jenks  -   local variable 'best' referenced before assignment
* :ghissue:`626`: cast arrays over inconsistent kdtree return types
* :ghissue:`596`: [question] unsupervised classification
* :ghissue:`620`: adding explicit check for random region contiguity
* :ghissue:`617`: Random_Region not respecting contiguity constraint
* :ghissue:`619`: Fixing spreg's warnings
* :ghissue:`618`: initial folder with dbf utilities using pandas
* :ghissue:`616`: Adding isolation and theil indices to inequality._indices.py
* :ghissue:`615`: Network docs
* :ghissue:`614`: cleaning up pr testing
* :ghissue:`613`: test coverage to 98% on network
* :ghissue:`612`: small change for testing PR
* :ghissue:`611`: stubbed in minimal tests
* :ghissue:`607`: B603
* :ghissue:`602`: Documentation Extraction Notebook
* :ghissue:`606`: pct_nonzero was reporting a ratio not a percentage
* :ghissue:`605`: RTree Weights
* :ghissue:`604`: Contribpush
* :ghissue:`601`: Documentation Cleanup
* :ghissue:`554`: Beginning documentation cleanup
* :ghissue:`599`: Casting bugfix from #598
* :ghissue:`600`: Updates for coveralls
* :ghissue:`598`: IO in Python 3
* :ghissue:`597`: Decoupling bbox from map_XXX_poly
* :ghissue:`595`: Removed testing line in travis.yml and added a .coveragerc file to manag...
* :ghissue:`586`: Look at using Coveralls
* :ghissue:`590`: using numpy sum method
* :ghissue:`589`: Wconstructor
* :ghissue:`588`: Coveralls
* :ghissue:`576`: Predecessor lists inconsistencies
* :ghissue:`585`: Fisher Jenks bug in `plot_choropleth`
* :ghissue:`584`: Alpha in plot chor
* :ghissue:`583`: Fixed 576
* :ghissue:`582`: Fixes #576
* :ghissue:`581`: Network
* :ghissue:`580`: working on #576
* :ghissue:`575`: Network from Lattice
* :ghissue:`578`: Fixes #577
* :ghissue:`577`: bug in FileIO.cast
* :ghissue:`574`: Handle case where a region has a 0 share.
* :ghissue:`343`: Edge Segmentation
* :ghissue:`571`: Dict to unique value mapper
* :ghissue:`570`: numpy doc cleanup for weights module
* :ghissue:`569`: folium viz scripts
* :ghissue:`568`: inline with numpy doc spec (spatial_dynamics module)
* :ghissue:`567`: New/masterbump
* :ghissue:`564`: Bug in setup.py
* :ghissue:`566`: Fix for 1.9.0 missing file in setup.py
* :ghissue:`565`: Bsetup


# PySAL 1.9.1, 2015-01-31

GitHub stats for 2015/01/30 - 2015/01/31 

These lists are automatically generated, and may be incomplete or contain duplicates.

The following 4 authors contributed 14 commits.

* Dani Arribas-Bel
* Serge Rey
* Sergio Rey
* jlaura


We closed a total of 8 issues, 3 pull requests and 5 regular issues;
this is the full list (generated with the script 
:file:`tools/github_stats.py`):

Pull Requests (3):

* :ghpull:`566`: Fix for 1.9.0 missing file in setup.py
* :ghpull:`563`: Updating release instructions
* :ghpull:`561`: Rolling over to 1.10

Issues (5):

* :ghissue:`566`: Fix for 1.9.0 missing file in setup.py
* :ghissue:`565`: Bsetup
* :ghissue:`563`: Updating release instructions
* :ghissue:`562`: adjustments to release management
* :ghissue:`561`: Rolling over to 1.10


# PySAL 1.9.0, 2015-01-30

## GitHub stats for 2014/07/25 - 2015/01/30 

These lists are automatically generated, and may be incomplete or contain duplicates.

The following 12 authors contributed 131 commits.

* Andy Reagan
* Dani Arribas-Bel
* Jay
* Levi John Wolf
* Philip Stephens
* Qunshan
* Serge Rey
* jlaura
* ljwolf
* luc


We closed a total of 113 issues, 44 pull requests and 69 regular issues;
this is the full list (generated with the script 
:file:`tools/github_stats.py`):

Pull Requests (44):

* :ghpull:`560`: modifying import scheme for network module
* :ghpull:`559`: Network2
* :ghpull:`558`: Network2
* :ghpull:`557`: Network2
* :ghpull:`556`: Added analytical functions and edge segmentation
* :ghpull:`550`: Network2
* :ghpull:`553`: correction in denominator of spatial tau. 
* :ghpull:`547`: Updates to get network integrated
* :ghpull:`544`: update .gitignore
* :ghpull:`543`: k nearest neighbor gwt example file for baltimore points (with k=4) added to examples directory
* :ghpull:`542`: new format nat_queen.gal file added to examples directory
* :ghpull:`541`: Update tutorial docs for new book
* :ghpull:`540`: doc: updating instructions for anaconda and enthought
* :ghpull:`539`: doc: pysal is now on sagemathcloud
* :ghpull:`538`: Clean up of cg and fixes of other doctests/formats
* :ghpull:`536`: adding entry for getis ord module
* :ghpull:`537`: new opendata module for contrib
* :ghpull:`535`: Add method for extracting data columns as Numpy array rather than list
* :ghpull:`534`: added geogrid to __all__ in sphere.py
* :ghpull:`533`: added geogrid function to create a grid of points on a sphere
* :ghpull:`532`: new functions to deal with spherical geometry: lat-lon conversion, degre...
* :ghpull:`530`: I390
* :ghpull:`528`: Replacing 0 by min value in choropleths
* :ghpull:`526`: B166
* :ghpull:`525`: copyright update
* :ghpull:`524`: New homogeneity tests for general case and spatial markov as a special case
* :ghpull:`523`: pointing to github.io pages
* :ghpull:`520`: Same typo. Toolkit.
* :ghpull:`518`: Update util.py
* :ghpull:`519`: Typo
* :ghpull:`517`: Documentation correction for Prais Conditional Mobility Index
* :ghpull:`516`: ENH for https://github.com/PySAL/PySAL.github.io/issues/17
* :ghpull:`515`: BUG: conditional check for extension of lower bound of colorbar to conta...
* :ghpull:`514`: ENH: adding the user_defined classification
* :ghpull:`513`: rewriting to not use ipython notebook --pylab=line
* :ghpull:`512`: Viz
* :ghpull:`508`: Adding barebones pysal2matplotlib options in viz
* :ghpull:`511`: DOC updating news
* :ghpull:`507`: Sched
* :ghpull:`510`: BUG: fix for #509
* :ghpull:`506`: 1.9dev
* :ghpull:`505`: REL bumping master to 1.9.0dev
* :ghpull:`504`: Release prep 1.8
* :ghpull:`503`: Grid for landing page

Issues (69):

* :ghissue:`560`: modifying import scheme for network module
* :ghissue:`559`: Network2
* :ghissue:`558`: Network2
* :ghissue:`557`: Network2
* :ghissue:`556`: Added analytical functions and edge segmentation
* :ghissue:`555`: Added edge segmentation by distance
* :ghissue:`550`: Network2
* :ghissue:`553`: correction in denominator of spatial tau. 
* :ghissue:`549`: Network2
* :ghissue:`547`: Updates to get network integrated
* :ghissue:`548`: Installation Issues
* :ghissue:`546`: Network2
* :ghissue:`545`: Network
* :ghissue:`544`: update .gitignore
* :ghissue:`543`: k nearest neighbor gwt example file for baltimore points (with k=4) added to examples directory
* :ghissue:`542`: new format nat_queen.gal file added to examples directory
* :ghissue:`541`: Update tutorial docs for new book
* :ghissue:`540`: doc: updating instructions for anaconda and enthought
* :ghissue:`539`: doc: pysal is now on sagemathcloud
* :ghissue:`538`: Clean up of cg and fixes of other doctests/formats
* :ghissue:`536`: adding entry for getis ord module
* :ghissue:`537`: new opendata module for contrib
* :ghissue:`535`: Add method for extracting data columns as Numpy array rather than list
* :ghissue:`534`: added geogrid to __all__ in sphere.py
* :ghissue:`533`: added geogrid function to create a grid of points on a sphere
* :ghissue:`532`: new functions to deal with spherical geometry: lat-lon conversion, degre...
* :ghissue:`390`: add option to have local moran quadrant codes align with geoda
* :ghissue:`530`: I390
* :ghissue:`528`: Replacing 0 by min value in choropleths
* :ghissue:`526`: B166
* :ghissue:`176`: contrib module for proj 4
* :ghissue:`178`: contrib module for gdal/org
* :ghissue:`203`: implement network class in spatialnet
* :ghissue:`204`: pysal-networkx util functions
* :ghissue:`209`: csv reader enhancement
* :ghissue:`215`: Add a tutorial for the spreg module
* :ghissue:`244`: ps.knnW_from_shapefile returns wrong W ids when idVariable specified
* :ghissue:`246`: Only use idVariable in W when writing out to file
* :ghissue:`283`: Create new nodes at intersections of edges
* :ghissue:`291`: Enum links around regions hangs
* :ghissue:`292`: Handle multiple filaments within a region in the Wed construction
* :ghissue:`302`: Handle hole polygons when constructing wed
* :ghissue:`309`: Develop consistent solution for precision induced errors in doctests across platforms
* :ghissue:`350`: reading/writing weights file with spaces in the ids
* :ghissue:`450`: x_name and summary method not consistent in ols
* :ghissue:`521`: Nosetests don't accept setup.cfg
* :ghissue:`509`: ESDA bin type inconsistency
* :ghissue:`525`: copyright update
* :ghissue:`524`: New homogeneity tests for general case and spatial markov as a special case
* :ghissue:`523`: pointing to github.io pages
* :ghissue:`520`: Same typo. Toolkit.
* :ghissue:`522`: Nosetests for python3 porting
* :ghissue:`518`: Update util.py
* :ghissue:`519`: Typo
* :ghissue:`517`: Documentation correction for Prais Conditional Mobility Index
* :ghissue:`516`: ENH for https://github.com/PySAL/PySAL.github.io/issues/17
* :ghissue:`515`: BUG: conditional check for extension of lower bound of colorbar to conta...
* :ghissue:`514`: ENH: adding the user_defined classification
* :ghissue:`513`: rewriting to not use ipython notebook --pylab=line
* :ghissue:`512`: Viz
* :ghissue:`508`: Adding barebones pysal2matplotlib options in viz
* :ghissue:`511`: DOC updating news
* :ghissue:`507`: Sched
* :ghissue:`510`: BUG: fix for #509
* :ghissue:`502`: spreg.ml_lag.ML_Lag is very very very time-consuming?
* :ghissue:`506`: 1.9dev
* :ghissue:`505`: REL bumping master to 1.9.0dev
* :ghissue:`504`: Release prep 1.8
* :ghissue:`503`: Grid for landing page


# PySAL 1.8.0, 2014-07-25

GitHub stats for 2014/01/29 - 2014/07/25 

These lists are automatically generated, and may be incomplete or contain duplicates.

The following 8 authors contributed 281 commits.

* Dani Arribas-Bel
* Jay
* Philip Stephens
* Serge Rey
* Sergio Rey
* jlaura
* pedrovma
* sjsrey


We closed a total of 160 issues, 60 pull requests and 100 regular issues;
this is the full list (generated with the script 
:file:`tools/github_stats.py`):

Pull Requests (60):

* :ghpull:`503`: Grid for landing page
* :ghpull:`501`: Two figs rather than three
* :ghpull:`500`: More efficient higher order operations
* :ghpull:`499`: renamed nat_queen.gal for #452
* :ghpull:`497`: ENH Deprecation warning for regime_weights #486
* :ghpull:`494`: Enables testing against two versions of SciPy shipped with the last two Ubuntu LTS versions.
* :ghpull:`490`: Fix for #487
* :ghpull:`492`: BUG cleaning up temporary files for #398
* :ghpull:`493`: Phil: Skipping several tests that fail due to precision under older scipy
* :ghpull:`489`: test suite fixes
* :ghpull:`488`: More tests to skip if scipy less than 11
* :ghpull:`484`: ENH: cleaning up more test generated files
* :ghpull:`483`: Forwarding Phil's commit: skipping doctests, conditional skip of unit tests
* :ghpull:`482`: DOC cleaning up files after running doctests #398
* :ghpull:`481`: DOC contrib updates and links
* :ghpull:`480`: DOC cleaning up doctests
* :ghpull:`479`: ENH Changing regime_weights to block_weights for #455
* :ghpull:`478`: DOC: link fixes
* :ghpull:`477`: cKDTree for #460
* :ghpull:`476`: redefining w.remap_ids to take only a single arg
* :ghpull:`475`: Adding docstrings and error check to fix #471
* :ghpull:`470`: fixing order of args for api consistency. 
* :ghpull:`469`: Idfix for #449
* :ghpull:`463`: updating gitignore
* :ghpull:`462`: ENH: handle the case of an ergodic distribution where one state has 0 probability
* :ghpull:`458`: ENH: Vagrantfile for PySAL devs and workshops
* :ghpull:`447`: Clusterpy
* :ghpull:`456`: BUG: fix for #451 handling W or WSP in higher_order_sp
* :ghpull:`454`: Foobar
* :ghpull:`443`: Updating spreg: several minor bug and documentation fixes.
* :ghpull:`453`: Resolving conflicts
* :ghpull:`448`: Wsp
* :ghpull:`445`: ENH: unique qualitative color ramp. Also refactoring for future ipython deprecation of --pylab=inline
* :ghpull:`446`: Wmd
* :ghpull:`444`: Scipy dependency
* :ghpull:`442`: Wmd
* :ghpull:`441`: fixed kernel wmd for updated wmd structure
* :ghpull:`440`: ENH: sidebar for Releases and installation doc update
* :ghpull:`439`: - events
* :ghpull:`438`: ENH: pruning to respect flake8
* :ghpull:`437`: BUG: fix for removal of scipy.stat._support #436
* :ghpull:`433`: Rank markov
* :ghpull:`424`: testing
* :ghpull:`431`: FOSS4G
* :ghpull:`430`: Network
* :ghpull:`429`: moving analytics out of wed class and into their own module
* :ghpull:`428`: Network
* :ghpull:`427`: devel docs
* :ghpull:`425`: Viz2contrib
* :ghpull:`423`: Update news.rst
* :ghpull:`422`: ENH: Update doc instructions for napoleon dependency
* :ghpull:`421`: Adding files used in some examples as per Luc's request.
* :ghpull:`419`: Doc fixes 1.7
* :ghpull:`393`: Doc fixes 1.7
* :ghpull:`417`: ENH hex lattice W for #416
* :ghpull:`415`: Temporarily commenting out tests that are blocking Travis.
* :ghpull:`407`: Viz: Moving into contrib/viz in master
* :ghpull:`404`: version change
* :ghpull:`401`: fixes #388
* :ghpull:`402`: release changes

Issues (100):

* :ghissue:`503`: Grid for landing page
* :ghissue:`501`: Two figs rather than three
* :ghissue:`500`: More efficient higher order operations
* :ghissue:`452`: nat_queen.gal example file
* :ghissue:`499`: renamed nat_queen.gal for #452
* :ghissue:`486`: add a deprecation warning on regime_weights
* :ghissue:`497`: ENH Deprecation warning for regime_weights #486
* :ghissue:`449`: Lower order neighbor included in higher order
* :ghissue:`487`: Issue with w.weights when row-standardizing
* :ghissue:`398`: running test suite generates files
* :ghissue:`358`: Graph weights
* :ghissue:`338`: ENH: Move Geary's C calculations to Cython.
* :ghissue:`494`: Enables testing against two versions of SciPy shipped with the last two Ubuntu LTS versions.
* :ghissue:`490`: Fix for #487
* :ghissue:`492`: BUG cleaning up temporary files for #398
* :ghissue:`493`: Phil: Skipping several tests that fail due to precision under older scipy
* :ghissue:`489`: test suite fixes
* :ghissue:`485`: Revert "ENH: cleaning up more test generated files"
* :ghissue:`488`: More tests to skip if scipy less than 11
* :ghissue:`484`: ENH: cleaning up more test generated files
* :ghissue:`483`: Forwarding Phil's commit: skipping doctests, conditional skip of unit tests
* :ghissue:`482`: DOC cleaning up files after running doctests #398
* :ghissue:`481`: DOC contrib updates and links
* :ghissue:`480`: DOC cleaning up doctests
* :ghissue:`455`: regime weights vs block weights
* :ghissue:`479`: ENH Changing regime_weights to block_weights for #455
* :ghissue:`478`: DOC: link fixes
* :ghissue:`460`: Optimize KDTree
* :ghissue:`477`: cKDTree for #460
* :ghissue:`472`: Check for any side effects from new id remapping in w.sparse
* :ghissue:`473`: update all user space functions for new w.remap_ids
* :ghissue:`476`: redefining w.remap_ids to take only a single arg
* :ghissue:`263`: Transition to scipy.spatial.cKDTree from scipy.spatial.KDTree
* :ghissue:`414`: Travis build is killing nosetests
* :ghissue:`335`: Weights transformation docs
* :ghissue:`471`: add docstring example for w.remap_ids
* :ghissue:`475`: Adding docstrings and error check to fix #471
* :ghissue:`405`: ENH: Handling ids in W (Leave open for discussion)
* :ghissue:`470`: fixing order of args for api consistency. 
* :ghissue:`469`: Idfix for #449
* :ghissue:`467`: redirect pysal.org to new dynamic landing page
* :ghissue:`466`: design the grid for the notebooks
* :ghissue:`464`: design new dynamic landing page for github.io
* :ghissue:`465`: move news out of docs and into dynamic landing page
* :ghissue:`468`: Move dynamic items out of sphinx docs and into dynamic landing page
* :ghissue:`463`: updating gitignore
* :ghissue:`451`: docs for higher_order_sp have wrong argument types
* :ghissue:`462`: ENH: handle the case of an ergodic distribution where one state has 0 probability
* :ghissue:`458`: ENH: Vagrantfile for PySAL devs and workshops
* :ghissue:`447`: Clusterpy
* :ghissue:`456`: BUG: fix for #451 handling W or WSP in higher_order_sp
* :ghissue:`457`: This is a test to see if pull request notifications get sent out to the list
* :ghissue:`454`: Foobar
* :ghissue:`443`: Updating spreg: several minor bug and documentation fixes.
* :ghissue:`453`: Resolving conflicts
* :ghissue:`412`: On travis and darwin test_ml_error_regimes.py hangs 
* :ghissue:`448`: Wsp
* :ghissue:`435`: Will spatial durbin model be added in the near future?
* :ghissue:`445`: ENH: unique qualitative color ramp. Also refactoring for future ipython deprecation of --pylab=inline
* :ghissue:`446`: Wmd
* :ghissue:`444`: Scipy dependency
* :ghissue:`442`: Wmd
* :ghissue:`441`: fixed kernel wmd for updated wmd structure
* :ghissue:`440`: ENH: sidebar for Releases and installation doc update
* :ghissue:`439`: - events
* :ghissue:`438`: ENH: pruning to respect flake8
* :ghissue:`436`: Scipy 0.14 induced breakage
* :ghissue:`437`: BUG: fix for removal of scipy.stat._support #436
* :ghissue:`408`: Use of `platform.system()` to determine platform
* :ghissue:`403`: Scipy dependency
* :ghissue:`434`: W Object Metadata Attribute
* :ghissue:`433`: Rank markov
* :ghissue:`424`: testing
* :ghissue:`432`: Implementation of rank Markov classes
* :ghissue:`431`: FOSS4G
* :ghissue:`430`: Network
* :ghissue:`429`: moving analytics out of wed class and into their own module
* :ghissue:`420`: Local Moran's I,  I Attribute Undefined
* :ghissue:`418`: Extended pysal.weights.user.build_lattice_shapefile 
* :ghissue:`428`: Network
* :ghissue:`427`: devel docs
* :ghissue:`426`: dev docs
* :ghissue:`425`: Viz2contrib
* :ghissue:`423`: Update news.rst
* :ghissue:`422`: ENH: Update doc instructions for napoleon dependency
* :ghissue:`421`: Adding files used in some examples as per Luc's request.
* :ghissue:`419`: Doc fixes 1.7
* :ghissue:`393`: Doc fixes 1.7
* :ghissue:`416`: Add hexagonal lattice option for lat2W
* :ghissue:`417`: ENH hex lattice W for #416
* :ghissue:`409`: add wiki page on viz module design
* :ghissue:`413`: Temporary fix for https://github.com/pysal/pysal/issues/412
* :ghissue:`415`: Temporarily commenting out tests that are blocking Travis.
* :ghissue:`407`: Viz: Moving into contrib/viz in master
* :ghissue:`406`: Viz: pruning old code and adding more examples for TAZ paper
* :ghissue:`380`: Pep 8 and Line Length
* :ghissue:`404`: version change
* :ghissue:`401`: fixes #388
* :ghissue:`388`: update testing procedures docs
* :ghissue:`402`: release changes

# PySAL 1.7.0, 2014-01-29

36d268f Philip Stephens -Merge pull request #400 from sjsrey/mldoc
c2c4741 Serge Rey -Formatting ml docs
685f5e3 Sergio Rey -Merge pull request #399 from sjsrey/master
481ccb4 Serge Rey -correct thanks
4a5cce3 Sergio Rey -Update index.txt
1fe7aeb Philip Stephens -Merge pull request #396 from sjsrey/mldoc
e731278 Serge Rey -EHN: fixing link to bleeding edge docs.
e4e9930 Serge Rey -ENH: adding ml docs to api
9b3c77e Serge Rey -Merge branch 'master' of github.com:pysal/pysal
dda3c01 Philip Stephens -Merge pull request #389 from dfolch/master
74b26d5 Philip Stephens -Merge pull request #392 from pedrovma/spreg17
b47ba84 pedrovma -Bump.
3d8504c Sergio Rey -Merge pull request #386 from pastephens/master
f9b59ea Philip Stephens -Merge branch 'master' of https://github.com/pysal/pysal
429e19e pedrovma -Upgrading to spreg 1.7.
c698747 David Folch -removing legacy speedup hack that is no longer relevant
88177d0 Sergio Rey -Merge pull request #387 from sjsrey/scipy13
64a4089 Serge Rey -BUG: sorting ijs for asymmetries
5539ef5 Sergio Rey -Merge pull request #1 from sjsrey/scipy13
8a86951 Serge Rey -BUG: fixes for scipy .0.9.0 to 0.13.0 induced errors
fe02796 Philip Stephens -tweaking travis to only run master commits
8c1fbe8 jlaura -Merge pull request #385 from sjsrey/docupdate
b71aedc Serge Rey -ENH: update date
4f237e4 Sergio Rey -Merge pull request #384 from sjsrey/moran
01da3be Serge Rey -ENH: Analytical p-values for Moran are two-tailed by default #337
918fe60 Philip Stephens -further travis tweaks
3920d73 Sergio Rey -Merge pull request #382 from sjsrey/st_docs
d90bc70 Serge Rey -DOC: updating refs for concordance algorithm
0db2790 Philip Stephens -tweaks to travis
063e057 Philip Stephens -upgrading scipy on travis
f90e742 Philip Stephens -Merge branch 'master' of https://github.com/pysal/pysal
edc9c07 Dani Arribas-Bel -Merge pull request #379 from sjsrey/b244
82479bb Serge Rey -BUG: fix for the comment https://github.com/pysal/pysal/issues/244#issuecomment-30055558
57ba485 jlaura -Update README.md
981ed31 Sergio Rey -Merge pull request #377 from darribas/master
3320c39 darribas -Changing cmap default in plot_choropleth so every type defaults to its own adecuate colormap
e063bee darribas -Fixing ignorance of argument cmap in base_choropleth_unique
1f10906 Dani Arribas-Bel -Merge pull request #375 from sjsrey/viz
94aa3e7 Dani Arribas-Bel -Merge pull request #376 from pedrovma/baltim_data
7568b0b pedrovma -Adding Baltimore example dataset for use with LM models.
5b23f89 Serge Rey -greys for classless map
d4eae1e Dani Arribas-Bel -Merge pull request #374 from sjsrey/viz
652440d Serge Rey -shrinking colorbar
c17bf67 Sergio Rey -Merge pull request #373 from darribas/master
a71c3cb darribas -Fixing minor conflict to merge darribas viz branch into darribas master
ec27e30 Dani Arribas-Bel -Merge pull request #372 from sjsrey/viz
8c03170 Serge Rey -option for resolution of output figs
3fc5bd4 Philip Stephens -Merge branch 'master' of https://github.com/pysal/pysal
2b5cb23 jlaura -Merge pull request #371 from sjsrey/geopandas
469afa7 Serge Rey -fix for #370
59cdafc jlaura -Merge pull request #369 from pedrovma/south_data
6b88e13 jlaura -Merge pull request #368 from schmidtc/issue367
40fe928 pedrovma -Adding south data to be used in ML doctests.
bcc257e schmidtc -fixes #367
87e057f jlaura -Merge pull request #366 from sjsrey/ml_lag
a64eb27 Serge Rey -queen contiguity for nat.shp
77add5c Sergio Rey -Merge pull request #365 from sjsrey/news
82464ef Serge Rey -narsc workshop
fd79424 Sergio Rey -Merge pull request #364 from sjsrey/news
bc7f25a Serge Rey -Merge branch 'master' of https://github.com/sjsrey/pysal
d669913 David Folch -Merge pull request #363 from sjsrey/maxp
22f9e36 Serge Rey -update example for bug fix #362
fac3b8a Serge Rey -- update tests for bug fix #362
44b4b06 Sergio Rey -Merge pull request #1 from sjsrey/maxp
1e6f1e5 Serge Rey -- fix for #362
68ab3e9 Sergio Rey -Merge pull request #361 from sjsrey/components
aa27c7e Serge Rey -doc test fix
7c08208 Serge Rey -putting Graph class back in for component checking
003b519 Serge Rey -alternative efficient component checker
2080e62 Serge Rey -- fixing doc
4fda442 Serge Rey -Merge branch 'components' of github.com:sjsrey/pysal into components
e9e613b Serge Rey -reverting back to old component check
83d855e Serge Rey -updating example
9defd86 jlaura -Merge pull request #360 from sjsrey/components
6f92335 Serge Rey -more efficient connectivity test
ebde3d1 Dani Arribas-Bel -Adding try/except for ogr since it's only used to reprojection methods but not on the plotting toolkit
5b170eb Sergio Rey -Merge pull request #356 from sjsrey/classification
c9dac41 Serge Rey -- update unit tests for reshaping jenks caspal
d9b06e2 Sergio Rey -Merge pull request #355 from sjsrey/cleanup/moran
dc589e8 darribas -Adding caution note when plotting points to the notebook. Ideally, we wanna be able to build a PathCollection out of the XYs, but for now we rely on plt.scatter, which gets the job done but has some problems.
2224b95 darribas -Including support for points in  base_choropleth_unique and base_choropleth_classless
ac2d08a darribas -Modifying example to show how to do choropleth mapping on points
270786e darribas -Adding support for choropleth plotting on point map objects (this may come from map_point_shp or from a simple matplotlib scatter
e56697c Sergio Rey -Merge pull request #357 from jlaura/newstyle_wed
4c67c2f Jay -errors in segmentation fixed
512cc76 Serge Rey -have Jenks-Caspal bins be a one dimensional array - to be consistent with all other classifiers
5254859 Philip Stephens -Merge branch 'master' of https://github.com/pysal/pysal
788ecab Serge -pruning
5b6b7b6 Serge -pruning
eb7e9a1 Jay -bug fix and all pointers filled for external edges
e47aa7a Jay -Node insertion, precursor to segmentation.
18a44d1 darribas -*Replacing shp by map_obj in medium layer functionality. *Bringing everything else in line with it *Adding example for line colorig and mixing overlaying of points.
bd041b1 darribas -Replacing shp_link by shp as input for medium and low-level layers. This brings much more flexibility and opens the door to plot formats other than shapefiles (e.g. geojson)
c74a361 darribas -Adding IP notebook to exemplify and keep track of development of mapping module
d23c882 darribas -Minor fixes
4b82a76 darribas -New commit message* Replacing map_poly_shp_lonlat for map_poly_shp in base_choropleth_classif/unique/classless * removed 'projection' from base_choropleth_classif/unique/classless * Allow base_choropleth_classif/unique/classless to plot multi-part polygons properly * changes streamlined to generic plot_choropleth * Added dependency on pandas for rapid reindexing (this is done externally on the method _expand_values to it is easy to drop the dependency when neccesary/time available)
7a0eaec darribas -Merge branch 'viz' of github.com:darribas/pysal into viz
5536424 darribas -Merge branch 'master' of github.com:darribas/pysal
e54ce16 Sergio Rey -Merge pull request #353 from darribas/master
819ee60 darribas -Adding immediate todo on head of the file
946772d darribas -Passing k to base_choropleth_classif from plot_choropleth. This should fix Issue #352
f299b45 darribas -Merge branch 'master' of https://github.com/pysal/pysal
f044f43 Jay -Added W generation
5f48446 jlaura -Merge pull request #348 from sjsrey/master
938a1ae Serge Rey -- adding nn stats to point based methods
a86a051 Philip Stephens -removing dependency tracking service, it was ruby only
1e24fde Philip Stephens -testing dependency tracking service
3aa410c Philip Stephens -Merge pull request #347 from pedrovma/w_silence_island
03990f6 pedrovma -Extending PR #310 (silence island warnings) to include w.transform.
160001a Sergio Rey -Merge pull request #346 from jlaura/newstyle_wed
44989f9 Sergio Rey -Merge pull request #345 from sjsrey/master
2fd99b8 Sergio Rey -Update README.md
bdcc6a8 Jay -NCSR with uniform distribution
769aa03 Jay -Fixed snapping
2561071 Jay -saved notebook and updated readme
3784783 Jay -ReadMe for Changes
019e16b Sergio Rey -Merge pull request #334 from jseabold/fix-build-example-dirs
1889885 Skipper Seabold -BLD: Correctly install package_data dirs.
ff4e355 Serge Rey -- assignments
c5b0cc0 Serge Rey -- reorg
a4f5642 Serge Rey -Merge branch 'network' of github.com:pysal/pysal into network
a95fec8 jlaura -Update README.md
1713145 Serge Rey -Merge branch 'master' of github.com:pysal/pysal into network
ede75c0 Sergio Rey -Merge pull request #329 from jlaura/wed_polar
7399cf2 Jay -Single-source shortest path notebook
9eb3fc1 Philip Stephens -Merge pull request #331 from sjsrey/docfix
ef9c82a Serge Rey -- sphinx doctest markup fix
1e2b6b3 jlaura -Update README.md
e19bffa jlaura -Merge pull request #330 from pysal/b328
6afc30b Serge Rey -- tutorial doc fixes for #328
c7239f1 Serge Rey -- b328 fix
d5fec13 Serge Rey -- fix for #328  making all p-values one-tailed
16b5e6e Jay -enumeration working with filaments
9507bbc jlaura -Update README.md
eef8eec Serge Rey -- stub for design of module
2707d60 Jay -Filaments in polar coordinates
b64f9e2 Serge Rey -Documentation for the development of network module
b90876e Serge Rey -Merge branch 'network' of github.com:pysal/pysal into network
ddad2a5 Philip Stephens -Merge pull request #326 from sjsrey/doc
6b0cd08 Serge Rey -- update release schedule
4cc7bca Jay -bisecting for single point working
79c77d9 jlaura -Merge pull request #324 from pysal/bf_id
9f4c7c9 Serge Rey -id is a keyword
72b1f85 Sergio Rey -Merge pull request #323 from jlaura/network
b5cdae0 Jay -fix to shp2graph
846dce2 Jay -Brute force for point outside network
d6c2ef4 Jay -Added length computation, alter global morans
b7e1465 Jay -Added new pointer to reader/writer
616d62d Jay -LISA and Global Morans on the network
16f84d6 Jay -Added explicit point external to network warning
34f4d8e Jay -update to the ipython notebook
e359e59 Jay -JSON and cPickle Bianry WED Reader/Writer
5373c82 Sergio Rey -Merge pull request #322 from jlaura/network
059d99c Jay -wed into class, tests added
aa5969d Sergio Rey -Merge pull request #320 from pastephens/master
a18000b Philip Stephens -version added info
5b8d490 Philip Stephens -typo
d31a22a Philip Stephens -stubs for cg docs
4dbdfe3 schmidtc -fixes #318
35a0317 Jay -Merge branch 'master' of https://github.com/pysal/pysal into network
77e8387 Jay -Merge branch 'geojson' of https://github.com/pysal/pysal into network
ad670c5 Sergio Rey -Merge pull request #317 from pastephens/master
628f27e Philip Stephens -merging local changes
f9dcb3e Philip Stephens -simplified install instructions
f2fab4c Serge Rey -- notebook on w construction for geojson
830826b Serge Rey -prototyping W from geojson
b10240d Serge Rey -created with "ogr2ogr -lco WRITE_BBOX=YES -f "GeoJSON" columbus.json columbus.shp"
d546926 Philip Stephens -merging with pull
d711011 darribas -Merge branch 'rod'
8bef782 darribas -Merge branch 'rod' of https://github.com/pysal/pysal into rod
03c1003 pedrovma -Merge pull request #315 from sjsrey/rod
950fe8b Serge Rey -Replacing ROD with regular dictionary
b1f009f Philip Stephens -Changes to release docs.
028364a Sergio Rey -Update THANKS.txt
94f5916 Sergio Rey -Update INSTALL.txt

# PySAL 1.6.0, 2013-07-31

5fa9d09 darribas -silent_island_warning implemented for w_union
6526c62 Sergio Rey -Update README.md
ea826c1 darribas -silent_island_warning implemented for w_intersection
335540a darribas -silent_island_warning implemented for w_difference
0a156cb darribas -silent_island_warning implemented for w_symmetric_difference. Previous commit included support of silent_island_warning for WSP2W as well
34d20d7 darribas -silent_island_warning implemented for w_clip
499815d pedrovma -Test fixing...
8778f75 pedrovma -Test fixing...
a799a13 pedrovma -Test fixing...
6482d81 pedrovma -Test fixing...
2752b1b pedrovma -Test fixing...
0c0a5bf pedrovma -Test fixing...
bbf9dcb pedrovma -Test fixing...
05c34ff pedrovma -Test fixing...
8a3986a Serge Rey -- preparing for release, version updates
9106cfe pedrovma -Matching travis results reg. precision issues.
3cd0ce1 Serge Rey -- updating changelog
74dadd6 pedrovma -Bump.
c7774fb Serge Rey -- update THANKS.txt - testing travis for timing out
cd98057 Serge Rey -- travis fix for multiprocessing permission error
86702f8 Serge Rey -- start of changelog for 1.6
3ee686d pedrovma -Reloading to check new results from Travis.
2de1d21 Serge Rey -- docs
ef72edc Serge Rey -- update docs
0716581 Serge Rey -- deal with multiprocessing on travis
b508c88 Serge Rey -- excluding network from 1.6 release
ff13e31 pedrovma -Matching Travis results. Multiprocessing errors still an issue.
5b916ba pedrovma -Adding Chow test on lambda and updating dynamics of regime_err_sep and regime_lag_sep in combom models.
b6e687f darribas -Patch to include switch for island warning as proposed in #295. The method  is modified as well to include the switch
7ea5f35 pedrovma -Fixing defaults
62ca76b pedrovma -Updating documentation and checking if there are more than 2 regimes when regimes methods are used.
3212249 pedrovma -Fixing documentation on 'name_regimes'
a782d50 pedrovma -Updating tests for integration with pysal 1.6
14f9181 pedrovma -Merging spreg_1.6 with my pysal fork.
817f2c2 Serge Rey -- having build_lattice_shapefile also create the associated dbf file - useful for testing our contiguity builders against geoda since dbf is   required by the latter
41d59a4 Serge Rey -- adding diagonal option to kernel weights in user.py
506d808 Serge Rey -update when added
b2ec3d4 Serge Rey -- updating api docs
9d45496 Serge Rey -- example and doctests for spatial gini
95635bb Serge Rey -updating release docs
bd2f924 darribas -Fixing doctest of towsp method by including isinstance(wsp, ps.weights.weights.WSP)
76183d7 darribas -Fixing doctest of towsp method by including type(wsp)
0c54181 darribas -Adding  method in W that calls WSP class for convenience and elegance. Related to issue #226
f3b23e8 Philip Stephens -adding source build to travis-ci
60930e7 Philip Stephens -adding new url for downloads
9bf7f5b Philip Stephens -modified release docs.
f98d4a9 Philip Stephens -interim ci
aa19028 Philip Stephens -Adding docs about installing in develop mode.
674112f Philip Stephens -starting rewrite of install docs
af0d9b3 Philip Stephens -working on doc tickets
200e77e Serge Rey -handle ties in knnW in doctest
d0d2dd2 Serge Rey -resetting README for pysal/pysal
6afb6ac Serge Rey -- updating docs for new api in interation.py
4c5572f Serge Rey -- updating tests for new api
fabd16a Serge Rey -- refactored signatures to use numpy arrays rather than event class
6367947 Serge Rey -- refactor knox for large samples
5fad3b2 Serge Rey -- updating travis test
06894d8 Serge Rey -- updated README
8b06e63 Serge Rey -- so only i get email when i commit locally
efbb7ff Serge Rey -- removing google pysal-dev circle
9859bda Serge Rey -- turning off gmail circle
51f6d3e Serge Rey -- fixing
46b1084 Serge Rey --docos
4e2c27a Philip Stephens -missing if statement added
d1a83fd Serge Rey -- fixing docs
8275d76 Serge Rey -- fix precision
87ea5cc Philip Stephens -adding to authors and quick test fix for linux
1cfb67f Serge Rey -cant easily remove idVariable, reverting
5933d1e Serge Rey -removing idvariable from Distance - causes too many issues
05f2573 Philip Stephens -removing coverage tests
fcb8c6f Philip Stephens -Knox using KDTree.
2237173 Serge Rey -with tests against previous implementation removed
233e59a Serge Rey -speed comparison for change to query_pairs in kdtree
fb78ea9 Serge Rey -removing test file
4d04575 Philip Stephens -testing
357a184 Serge Rey -second great idea
1fafc2b Serge Rey -on a plane commit 1
fef6eae Philip Stephens -fix
86c17ac Serge Rey -- test file
a619f62 Philip Stephens -interim ci
1a9d881 Serge Rey -- knox test using kdtrees
7459c44 Serge Rey -Fixing reference to missing shapefile Fixing one rounding error induced test
5616b12 Serge Rey -refactored to avoid second loop in explicit queen or rook check
d3d2f71 Philip Stephens -Revert "Changed doctest path calls to account for modified shapefile."
da1d8a1 Philip Stephens -Changed doctest path calls to account for modified shapefile.
f591c99 Philip Stephens -progress on permutations of knox for larger datasets
8d31cde Serge Rey -Testing integration of spatialnet creation and reading into wed
11de6f3 Jay -Fixed wed_modular.py
077658a Serge Rey -adding new test case for wed extraction from a spatialnet shapefile
bbb10b4 Philip Stephens -saving state of development
44076b7 Serge Rey -- update doc test
6fdd94d Serge Rey -- moved regions_from_graph into wed_modular - documented all functions and cleaned up
5bd27c3 Serge Rey -- wrapping in functions
3ad162f Serge Rey -- working version of wed_modular module - starting point for clean up
2380f15 Philip Stephens -Copy of sphinx install docs. Closes #251
5687700 Philip Stephens -tweaks to install instructions
9ffd432 Serge Rey -- updating for switch from svn to git
fdaf521 Philip Stephens -Fixing 250
5ba4fdf Serge Rey -Fixes #249 Closes #249
d89944d Pedro -Adding docs for each regimes estimator
f03bb63 Serge Rey -- updating docs for spatial regimes in spreg
a49d0f7 Philip Stephens -Adding info to setup script.
1f27605 Philip Stephens -mainly docs
04f8a31 Philip Stephens -Adding test coverage with nose, data collected and presented on coveralls.io
6db978b Philip Stephens -last changes
137e088 Philip Stephens -added bigdata parameter
7ca81c2 Philip Stephens -got Knox stat working in alt form
24c1fcc Philip Stephens -workign on refactoring the space-time matrices for the Knox test [ci-skip]
28013f0 Serge Rey -- enumeration of cw edges for faces
baa8f60 Serge Rey -- hole is now included and enumeration of links (cw) around nodes works for all nodes. - isolated nodes also handled in enumeration of links around nodes.
33741c8 Serge Rey -- filaments inserted and pointers updated - have to add hole polygon and isolated nodes, but almost there!!!!!!!!!
416d3db Serge Rey -- pointers updated for edges of connected components
c34e274 Serge Rey -- convex/between edge test as start of testing for insertion of multiple   internal filaments in one region.
78d96b1 Serge Rey -- filament insertion and pointer updates
ced2c5b Serge Rey -- filament insertion (inc)
ba4263f Jay -Logic roughed in for filaments [ci skip]
cf3b0bc Jay -updated wed ipynb [ci skip]
33ce81e Serge Rey -- refactoring of wed construction (incomplete)
0fc16fc Jay -modular WED Pulled Apart 2 funcs in 1 cell
bf73b90 Jay -modular WED
3163377 Serge Rey -- new modular wed construction
e50b31d Jay -added test_wed additions to test_wed2
1cbc941 Serge Rey -- isolated nodes handled
d28b97f Serge Rey -- isolated filament handled
6188fd5 Serge Rey -- hole component handled
a96040b Serge Rey -- getting connected components (current 14,15,16  and 25,26,27 are not   included)
3aa31a5 Jay -Added boolean arg to include or exclude holes [ci skip]
d07876d Jay -Filament identification [ci skip]
0139ea5 Philip Stephens -Slight speed improvement getting rid of append calls in reading shapefile and building x,y lists.
43010b5 Serge Rey -- fixed logic problem with enum for v1, starting on components
8737918 Pedro -Adding more meaningful error message to inverse distance weights
01f52f6 Serge Rey -- replacing code that got deleted previously
7c4c6e1 Philip Stephens -Replacing deleted files.
a8da725 Philip Stephens -added date support to spacetimeevents class, a date column to example dbf.
90c4730 Philip Stephens -logic works, numeric test still failing
b8e43e1 Philip Stephens -saving progress on interaction
81f2408 Serge Rey -- handling external end-node-filament
7de6253 Serge Rey -- adding end node filament handling - edge enumeration around node working
f542b9a Serge -- adding end node filament handling - edge enumeration around node working
d7e3a57 Philip Stephens -[ci skip] disabling nose-progressive so travis output looks best
fe03013 Dani Arribas-Bel -Adding set of diversity indices to inequality module under _indices.py for now. Still lacks doctests, unittests, and a few others will be added
951b6f5 Dani Arribas-Bel -Adding try/except to the import of Basemap to allow the use of the module when there is no Basemap installation
89003eb Serge Rey -- adding wed for eberly example
665ef22 Serge Rey -- fixed 7,2 failure
71fc9ad Serge Rey -start of adding gini and other inequality measures
f7b7bcc Phil Stephens -Adding nose-progressive plugin to test suite. Devs can run test suite with 'make test'.
f5db7bf Serge Rey -- updating copyright
07574b5 Serge Rey -- docs
478d2cb Philip Stephens -Adding requirement. Removing redundancy.
916a6ca Serge Rey -- more island check updates
edd9960 Serge Rey -- more island check doctest changes
ad1a91c Serge Rey -- updating doctests for island check
ce77772 Serge Rey -- fixing doctests to incorporate new island warning
554a30b Serge Rey -- silencing floating point warning
4f76862 Serge Rey -- moving default contiguity builder back to binning from rtree
b99665b Jay -Eberly
d911344 Jay -mp removed, passing nosetests on my machine serial
f005675 Serge Rey -improved binning algorithm for contiguity builder
4a69557 Serge Rey -- double checking threshold in Distance Band - new example to show functionality
7256f13 Serge Rey -- fix handling of idVariable for knnW
31bb36e Jay -bug fixes [ci skip]
a2d2dd4 Jay -WEberly - WED Building [ci skip]
3abc55e Serge Rey -- fixing doctests for new check/reporting for islands
756ac05 Serge Rey -- adding warning if islands exist upon W instantiation
db097a6 Jay -Weberly, bug fix, c and cc link remaining
d5cc6f9 Jay -All but start / end working
033963d Jay -Integration to WEberly error fixed [ci skip]
22b931a Serge Rey -- removing main for doc tests which can be run from nosetests. - updating testing docs
bf753e9 Jay -Integration to WEberly started [ci skip]
6506e07 Serge Rey -- typo
aede375 Serge Rey -- replacing double quotes around multi word ids with strings joined with   underscores
cf029e8 Serge Rey -- changes to wrap string ids in gwt writer - see https://github.com/pysal/pysal/issues/244#issuecomment-16707353
626ac08 Serge Rey -- adding shapefile and variable name to gwt objects created in user space
3c84bb0 Jay -Working version 4.19 [ci skip]
7d77da9 darribas -Include warning in sp_att when rho is outside (-1, 1), ammends #243 although the true problem (pearsonr in diagnostics_tsls) will still raise an error
3719d21 Jay -working WED [ci skip]
b4ce294 Serge Rey -checking edges
f4bb412 Jay -excessive print statements removed. ci skip
9f7dee6 Jay -SUCCESS! ci skip
9077615 Phil Stephens -Note, [ci skip] anywhere in your commit message causes Travis to NOT build a test run.
cb072c4 Jay -getting there
d3b36bc Serge Rey -correcting typo user told me about
19ea051 Jay -trivial working
b9ea577 Jay -eberly cycles - edge issue still
d5153e3 Serge Rey -more refinement of wed from plannar graph
edff44b Philip Stephens -adding git ignore file
8093f21 Serge Rey -wed from minimum cycle basis
b5bcead Serge Rey -handle filaments
9a8927a Serge Rey -face extraction using horton algorithm
10d66c1 Serge Rey -updating readme formatting
59f3750 schmidtc -adding Universal newline support to csvReader, fixes #235
09e813f Serge Rey -- updating notifications
f8b0a26 Serge Rey -- fixing Distance.py and testing travis message
d1ec0f2 Phil Stephens -quieting pip output and fix one doctest
927e799 Phil Stephens -adding networkx, tweaks to travis config
5971bb1 Serge Rey -neighbors from wed
28f0e55 Serge Rey -adding robust segment intersection tests
3bcac73 Serge Rey -adding doubly connected edge list to network module
86f0fea darribas -Adding methods to read line and point shapefiles and improving the method to append different collections to one axes. Still in progress
b61cb55 Serge Rey -- fixing introduced bug in knnW_arc
801e78d Serge Rey -Handle point sets with large percentage of duplicate points
dbafbc4 serge -update pointer to github
427a620 Serge Rey -dealing with filaments
23216ef Serge Rey -Fixed cw enumeration of links incident to a node
0a51a53 Serge Rey -- readme
5f4cab4 sjsrey -cw enumeration not working for all nodes
f2e65d3 Serge Rey -- cw traversal of edges incident with a node
90d150c sjsrey -- version debug for travis
24598a8 sjsrey -- noting move to org
9fb8a17 sjsrey -- fixing tutorial tests
5a14f9e serge -- cleaning up weights tests
6265b3b Serge Rey -- fixing doc tests
7e8c4fe Serge Rey -- testing after move to org
37fc8d4 Serge Rey -- testing post commit emails
bed7f6e Phil Stephens -removed files
eab2895 Phil Stephens -removed virginia_queen files
bcef010 Serge Rey -- adding diagonal argument to Kernel weights - adding doctest evaluation to Distance.py
02d27e9 Phil Stephens -adding libgeos-dev
1126d71 Phil Stephens -pipe build output to null
37dbb35 Phil Stephens -adding -y flag to pip uninstall
06d56e9 Phil Stephens -adding libgeos_c install, pysal from pip
4c53277 Phil Stephens -trying to quiet output, using Makefile
74448e8 Phil Stephens -find setup.py
4634fb1 Phil Stephens -test install in venv and build
5d58723 Phil Stephens -working out travis-ci doctest configuration
5e905d3 Phil Stephens -adding numpydoc
33a5298 Phil Stephens -tweaks travis config
5c85f50 Phil Stephens -tweaking service configs
4ed1201 Josh Kalderimis -use the correct syntax for sysytem_site_packages
954b6d2 Phil Stephens -stop!
311eca8 Phil Stephens -ssp=true
c601bca Phil Stephens -numpy first
54b0afe Phil Stephens -ok, so travis is serious about not using system site packages.
2b912cc Phil Stephens -doh
28994df Phil Stephens -better yaml
ce1d89e Phil Stephens -testing
b535d3e Phil Stephens -testing
440a772 Phil Stephens -tweaking pip requirements file
34a74e2 Phil Stephens -tweaking travis file
33b13aa Serge Rey -- new links
8e09d7b Serge Rey -- setting up travis
d33001e Sergio Rey -Update CHANGELOG.txt
9d4de66 Serge Rey -- added authors
ab672c9 Serge Rey -- modified knnW to speed up dict construction
4edd2ab Serge Rey -- update cr
39e6564 Phil Stephens -syncing install instructions with docs
9e98db9 Phil Stephens -adding website favicon; chrome does not empty cache properly!!

 * migration to github from svn
   svn2git http://pysal.googlecode.com/svn --authors ~/Dropbox/pysal/src/pysal/authors.txt --verbose

# PySAL 1.5.0, 2013-01-31

2013-01-29 20:36  phil.stphns

	* doc/source/users/installation.txt: updating and simplifying user
	  install instructions.

2013-01-18 16:17  sjsrey

	* Adding regime classes for all GM methods and OLS available in
	  pysal.spreg, i.e. OLS, TSLS, spatial lag models, spatial error models
	  and SARAR models. All tests and heteroskedasticity
	  corrections/estimators currently available in pysal.spreg apply to
	  regime models (e.g. White, HAC and KP-HET). With the regimes, it is
	  possible to estimate models that have:
	  -- Common or regime-specific error variance;
	  -- Common or regime-specific coefficients for all variables or for a
	  selection of variables;
	  -- Common or regime-specific constant term;
	  - Various refactoring to streamline code base and improve long term
	    maintainability
	    - Contributions from Luc Anselin, Pedro Amaral, Daniel Arribas-Bel
	      and David Folch

2013-01-18 14:08  schmidtc

	* pysal/common.py: implemented deepcopy for ROD, see #237

2013-01-08 12:28  dreamessence

	* pysal/contrib/spatialnet/__init__.py: Adding __init__.py to make it importable

2012-12-31 22:53  schmidtc

	* pysal/core/IOHandlers/gwt.py: adding kwt support, see #232

2012-12-21 20:53  sjsrey@gmail.com

	* pysal/__init__.py, pysal/cg/rtree.py,
	  pysal/contrib/weights_viewer/weights_viewer.py,
	  pysal/weights/weights.py: - turning off randomization in rtree

2012-12-06 16:34  dfolch

	* pysal/contrib/shapely_ext.py: adding unary_union() to shapely
	  contrib; note this only works with shapely version 1.2.16 or higher


2012-11-29 13:39  dreamessence 

	* pysal/contrib/viz/mapping.py: Added option in setup_ax to pass
	  pre-existing axes object to append.  It is optional and it enables,
	  for instance, to embed several different maps in one single figure

2012-11-20 00:23  dfolch

	* pysal/contrib/shapely_ext.py: adding shapely's cascaded_union
	  function to contrib

2012-11-12 18:08  dreamessence

	* pysal/contrib/viz/mapping.py: -Adding transCRS method to convert
	  points from one prj to another arbitrary one -Adding map_poly_shp to
	  be able to plot shapefiles in arbitrary projections, not needing to
	  be in lonlat and not depending on Basemap

2012-11-09 15:40  sjsrey@gmail.com

	* pysal/weights/weights.py:
	  - distinguish between intrinsic symmetry and general symmetry
	
2012-11-02 17:48  schmidtc

	* pysal/weights/user.py, pysal/weights/util.py: Adding Minkowski
	  p-norm to min_threshold_dist_from_shapefile, see issue #221

2012-10-19 22:35  sjsrey@gmail.com

	* pysal/weights/weights.py:
	  explicitly prohibit chaining of transformations - all
	  transformations are only applied to the original weights at
	  instantiation

2012-10-19 17:38  sjsrey@gmail.com

	* pysal/spatial_dynamics/markov.py:
	  - fixing bug in permutation matrix to reorder kronecker product in
	    the join test

2012-10-17 17:55  sjsrey@gmail.com

	* pysal/weights/util.py:
	  -
	  higher order contiguity for WSP objects

2012-10-17 15:43  sjsrey@gmail.com

	* pysal/weights/user.py:
	  -
	  id_order attribute was always NONE for wsp created from
	  
	  queen/rook_from_shapefile with sparse=True

2012-10-16 19:25  schmidtc

	* pysal/weights/util.py: improving memory usage of
	  get_points_array_from_shapefile, no need to read entire shapefile
	  into memory.

2012-10-15 00:44  dreamessence

	* pysal/contrib/viz/mapping.py: First attempt to refactor Serge's code
	  for choropleth mapping.  It now offers a more general and flexible
	  architecture.  Still lots of work and extensions left.  The module
	  is explained in a notebook available as a gist at
	  https://gist.github.com/3890284 and viewable at
	  http://nbviewer.ipython.org/3890284/

2012-10-12 18:34  schmidtc

	* pysal/contrib/spatialnet/spatialnet.py: modified SpatialNetwork.snap
	  to calculate and return the snapped point

2012-10-12 17:05  dfolch

	* pysal/contrib/viz/mapping.py: made edits to unique_values_map to
	  allow for unlimited number of categories; I commented out the
	  previous code so these changes can easily be rolled back if it
	  breaks something somewhere else

2012-10-12 15:03  schmidtc

	* pysal/cg/segmentLocator.py: Fixing issue with segmentLocator, when
	  query point is extreamly far from the grid boundary, overflow errors
	  were causing the KDTree to not return any results.  Changed both
	  KDtree's to use Float64 and share the same data.  Previously,
	  cKDTree was using float64 and KDtree was using int32.

2012-10-11 08:12  dreamessence

	* pysal/contrib/viz/__init__.py: Adding __init__.py to viz module to
	  make it importable

2012-08-31 02:57  phil.stphns

	* pysal/spreg/tests/test_diagnostics.py,
	  pysal/spreg/tests/test_diagnostics_sp.py,
	  pysal/spreg/tests/test_diagnostics_tsls.py,
	  pysal/spreg/tests/test_error_sp.py,
	  pysal/spreg/tests/test_error_sp_het.py,
	  pysal/spreg/tests/test_error_sp_het_sparse.py,
	  pysal/spreg/tests/test_error_sp_hom.py,
	  pysal/spreg/tests/test_error_sp_hom_sparse.py,
	  pysal/spreg/tests/test_error_sp_sparse.py,
	  pysal/spreg/tests/test_ols.py,
	  pysal/spreg/tests/test_ols_sparse.py,
	  pysal/spreg/tests/test_probit.py,
	  pysal/spreg/tests/test_twosls.py,
	  pysal/spreg/tests/test_twosls_sp.py,
	  pysal/spreg/tests/test_twosls_sp_sparse.py,
	  pysal/spreg/tests/test_twosls_sparse.py:
	  - autopep8 -iv spreg/tests/*.py - nosetests pysal - no fixes needed

2012-08-31 01:16  phil.stphns

	* pysal/spreg/diagnostics.py,
	  pysal/spreg/diagnostics_sp.py,
	  pysal/spreg/diagnostics_tsls.py,
	  pysal/spreg/error_sp.py,
	  pysal/spreg/error_sp_het.py,
	  pysal/spreg/error_sp_hom.py,
	  pysal/spreg/ols.py,
	  pysal/spreg/probit.py,
	  pysal/spreg/robust.py,
	  pysal/spreg/summary_output.py,
	  pysal/spreg/twosls.py,
	  pysal/spreg/twosls_sp.py,
	  pysal/spreg/user_output.py,
	  pysal/spreg/utils.py:
	  -
	  autopep8 -iv spreg/*.py - fixed autopep8-introduced doctest failures
	  - fixed lingering scientific notation test failures

2012-08-31 00:26  phil.stphns

	* pysal/esda/gamma.py,
	  pysal/esda/join_counts.py,
	  pysal/esda/mapclassify.py,
	  pysal/esda/mixture_smoothing.py,
	  pysal/esda/moran.py,
	  pysal/esda/smoothing.py:
	  -
	  autopep8 fixes - make sure to run unit and doc tests before
	  committing - one autofix breaks long lines, and thus breaks some
	  doctests; must be
	  
	  fixed manually

2012-08-31 00:10  phil.stphns

	* pysal/esda/getisord.py:
	  -
	  using autopep8 module - call: autopep8 -vi getisord.py

2012-08-30 23:18  phil.stphns

	* pysal/esda/geary.py:
	  -
	  pep8 clear - removed wildcard import

2012-08-26 22:53  phil.stphns

	* pysal/spatial_dynamics/directional.py,
	  pysal/spatial_dynamics/ergodic.py,
	  pysal/spatial_dynamics/interaction.py,
	  pysal/spatial_dynamics/markov.py,
	  pysal/spatial_dynamics/rank.py,
	  pysal/spatial_dynamics/util.py:
	  -pep8 and pylint fixes -clean wildcard imports

2012-08-26 21:03  phil.stphns

	* pysal/region/maxp.py,
	  pysal/region/randomregion.py:
	  -
	  cleaning up imports

2012-08-26 18:16  phil.stphns

	* pysal/region/maxp.py:
	  -
	  style fixes with pep8 - cmd line call: pep8 --show-source
	  --ignore=E128,E302,E501,E502,W293,W291
	  
	  region/maxp.py

2012-08-26 17:47  phil.stphns

	* pysal/common.py,
	  pysal/examples/README.txt,
	  pysal/region/components.py,
	  pysal/region/randomregion.py:
	  -
	  using pep8 module

2012-08-24 20:47  schmidtc

	* pysal/network,
	  pysal/network/__init__.py: adding network module

2012-08-21 22:53  phil.stphns

	* doc/source/_templates/ganalytics_layout.html:
	  -
	  updating analytics tracker

2012-08-17 17:11  sjsrey@gmail.com

	* pysal/contrib/spatialnet/util.py:
	  -
	  more utility functions for pysal
	  -
	  networkx interop

2012-08-16 23:44  phil.stphns

	* setup.py:
	  -
	  tweak for build names

2012-08-12 13:15  dreamessence

	* doc/source/index.txt:
	  Adding announcement links to landing page

2012-08-11 17:38  sjsrey

	* LICENSE.txt:
	  -
	  update

2012-08-09 17:19  phil.stphns

	* doc/source/developers/pep/pep-0008.txt:
	  updating
	  spatial
	  db
	  pep

2012-08-08 17:22  schmidtc

	* pysal/weights/Distance.py:
	  Fixing bug in Kernel weights that causes erroneous results when
	  using ArcDistances.  See issue #218.

2012-08-04 21:14  sjsrey

	* doc/source/developers/docs/index.txt:
	  -
	  fixed
	  links

2012-08-04 21:03  sjsrey

	* doc/source/developers/docs/index.txt:
	  -
	  hints
	  on
	  editing
	  docs
	  

2012-08-04 20:14  phil.stphns

	* doc/source/developers/pep/pep-0011.txt:
	  note
	  about
	  travis-ci
	  and
	  github

2012-08-04 16:24  sjsrey

	* doc/source/developers/pep/pep-0011.txt:
	  PEP-0011
	  

2012-08-04 16:22  sjsrey

	* doc/source/developers/pep/index.txt:
	  -
	  PEP 0011 Move from Google Code to Github

2012-08-04 04:42  sjsrey

	* doc/source/index.txt:
	  - broken link

2012-08-04 04:35  sjsrey

	* doc/source/index.txt:
	  - news updates

2012-08-04 04:24  sjsrey

	* doc/source/index.txt:
	  - reorg

2012-08-02 02:32  sjsrey

	* pysal/examples/__init__.py:
	  -
	  moving back to r1049 but leaving r1310 in history for ideas on
	  moving forward - we need to distinguish between using examples in
	  the doctests (which the users see) and for the developers since we
	  are no longer distributing examples with the source

2012-08-02 01:49  sjsrey

	* pysal/examples/__init__.py:
	  -
	  correct conditional this time (i hope)

2012-08-02 01:36  sjsrey

	* pysal/examples/__init__.py:
	  -
	  compromise
	  -
	  returns pth rather than None if file does not exist

2012-08-02 00:58  sjsrey

	* pysal/examples/__init__.py:
	  -
	  link to examples download

2012-08-02 00:42  sjsrey

	* pysal/examples/__init__.py:
	  -
	  explicit check if examples are actually present




# PySAL 1.4.0, 2012-07-31

2013-01-31 


2012-07-31 21:30  sjsrey@gmail.com

	* pysal/spatial_dynamics/ergodic.py,
	  pysal/spatial_dynamics/rank.py:
	  - docs/example

2012-07-31 20:47  sjsrey@gmail.com

	* pysal/spreg/tests/test_error_sp_hom.py:
	  - rounding/precision issue

2012-07-31 20:27  sjsrey@gmail.com

	* pysal/spatial_dynamics/directional.py,
	  pysal/spatial_dynamics/tests/test_directional.py:
	  - fixing pvalue bug

2012-07-31 20:24  sjsrey@gmail.com

	* doc/source/users/tutorials/dynamics.txt:
	  - fixed rounding problem

2012-07-31 19:58  sjsrey@gmail.com

	* doc/source/index.txt,
	  doc/source/users/tutorials/autocorrelation.txt,
	  doc/source/users/tutorials/dynamics.txt,
	  doc/source/users/tutorials/econometrics.txt,
	  doc/source/users/tutorials/fileio.txt,
	  doc/source/users/tutorials/index.txt,
	  doc/source/users/tutorials/intro.txt,
	  doc/source/users/tutorials/region.txt,
	  doc/source/users/tutorials/smoothing.txt,
	  doc/source/users/tutorials/weights.txt:
	  - adding links to API for more details

2012-07-31 19:05  sjsrey@gmail.com

	* pysal/spatial_dynamics/directional.py:
	  - consistency on pvalues for randomization

2012-07-31 19:02  sjsrey@gmail.com

	* pysal/weights/Distance.py:
	  - docs

2012-07-31 18:58  sjsrey@gmail.com

	* doc/source/users/tutorials/dynamics.txt:
	  - seed issue 

2012-07-31 18:36  sjsrey@gmail.com

	* doc/source/users/tutorials/autocorrelation.txt:
	  - closing issue 214

2012-07-31 18:19  sjsrey@gmail.com

	* doc/source/users/tutorials/autocorrelation.txt:
	  - fixing random.seed issues in doctests

2012-07-31 17:31  schmidtc

	* pysal/cg/shapes.py,
	  pysal/cg/tests/test_shapes.py:
	  Fixing small bugs with VerticleLines and testing

2012-07-31 16:26  sjsrey@gmail.com

	* doc/source/developers/guidelines.txt,
	  doc/source/users/installation.txt:
	  - updating docs 



2012-07-26 15:24  schmidtc

	* pysal/core/FileIO.py,
	  pysal/core/Tables.py:
	 Fixing issue #190

2012-07-24 16:32  schmidtc

	* pysal/cg/sphere.py:
	Allowing linear2arcdist function to maintin 'inf', this allows compatability with Scipy's KDTree and addresses issue 208.  

2012-07-24 16:07  schmidtc

	* pysal/cg/locators.py,
	  pysal/core/FileIO.py,
	  pysal/core/Tables.py:
	  Addressing issue 212, renaming nested and private classes to begin with an underscore.  By default sphinx does not try to document private object, which avoids what appears to be a a bug in Sphinx.

2012-07-17 22:06  sjsrey@gmail.com

	* pysal/spreg/probit.py: pedro doc fixes

2012-07-17 15:07  schmidtc

	* pysal/cg/segmentLocator.py,
	  pysal/cg/tests/test_segmentLocator.py: Cleaned up fix for Issue 211

2012-07-13 22:50  sjsrey@gmail.com

	* doc/source/users/tutorials/autocorrelation.txt: fixing sphinx weirdness in footnotes 

2012-07-13 22:37  sjsrey@gmail.com

	* doc/source/users/tutorials/autocorrelation.txt: update for new default parameter values

2012-07-13 22:13  sjsrey@gmail.com

	* pysal/esda/geary.py,
	  pysal/esda/tests/test_geary.py: consistency on transformation and permutation args

2012-07-13 19:59  sjsrey@gmail.com

	* doc/source/users/tutorials/dynamics.txt,
	  pysal/__init__.py,
	  pysal/spatial_dynamics/rank.py: - update user tutorial and __init__

2012-07-13 19:33  sjsrey@gmail.com

	* pysal/spatial_dynamics/rank.py,
	  pysal/spatial_dynamics/tests/test_rank.py: - O(n log n) algorithm for spatial tau (old one was O(n^2)) - closing ticket http://code.google.com/p/pysal/issues/detail?id=83

2012-07-13 17:57  schmidtc

	* pysal/core/IOHandlers/pyDbfIO.py,
	  pysal/core/IOHandlers/tests/test_pyDbfIO.py: Adding better support for writing Null values to DBF.  See issue #193

2012-07-13 15:55  schmidtc

	* pysal/core/util/shapefile.py,
	  pysal/core/util/tests/test_shapefile.py: Cleaning up support for ZM points, polylines and polygons in the shapefile reader. Added unit tests for same.

2012-07-13 15:42  sjsrey@gmail.com

	* doc/source/library/esda/gamma.txt: - update version info 

2012-07-13 15:37  sjsrey@gmail.com

	* doc/source/library/esda/gamma.txt,
	  doc/source/library/esda/index.txt: - adding gamma to api docs

2012-07-13 00:21  sjsrey@gmail.com

	* pysal/esda/gamma.py: optimizations 

2012-07-12 21:28  schmidtc

	* pysal/core/IOHandlers/pyDbfIO.py: Disabling mising value warning for DBF files.  See issue #185

2012-07-12 21:07  schmidtc

	* pysal/cg/segmentLocator.py,
	  pysal/cg/shapes.py,
	  pysal/cg/tests/test_segmentLocator.py,
	  pysal/contrib/spatialnet/spatialnet.py: Adding unittests for segmentLocator (including one that fails see #211). Added VerticalLine class to represent verticle LineSegments. Updated __all__ in segmentLocator. Minor comment formatting in spatialnet.

2012-07-12 19:41  lanselin@gmail.com

	* doc/source/users/tutorials/autocorrelation.txt: tutorial for gamma index

2012-07-12 19:40  lanselin@gmail.com

	* pysal/esda/gamma.py,
	  pysal/esda/tests/test_gamma.py: gamma with generic function

2012-07-12 14:17  sjsrey@gmail.com

	* pysal/__init__.py: - gamma index added

2012-07-12 03:14  lanselin@gmail.com

	* pysal/esda/tests/test_gamma.py: tests for gamma

2012-07-12 03:13  lanselin@gmail.com

	* pysal/esda/gamma.py: gamma index of spatial autocorrelation

2012-07-12 03:11  lanselin@gmail.com

	* pysal/esda/__init__.py: gamma index 

2012-07-11 21:32  lanselin@gmail.com

	* pysal/esda/join_counts.py,
	  pysal/esda/tests/test_join_counts.py: join counts without analytical results, new permutation 

2012-07-11 21:32  lanselin@gmail.com

	* doc/source/users/tutorials/autocorrelation.txt: updated docs for join counts

2012-07-10 21:13  lanselin@gmail.com

	* doc/source/users/tutorials/autocorrelation.txt: docs for join count in autocorrelation

2012-07-10 21:12  lanselin@gmail.com

	* pysal/esda/join_counts.py,
	  pysal/esda/tests/test_join_counts.py: additional test in join counts, docs added

2012-07-10 19:24  lanselin@gmail.com

	* pysal/esda/join_counts.py,
	  pysal/esda/tests/test_join_counts.py: join counts with permutations for BB, updated tests to include permutations

2012-07-09 04:22  sjsrey

	* pysal/weights/weights.py:
	  - fixing bug luc identified with regard to mean_neighbor property.  wrong key name was used in cache dictionary.  

2012-07-07 17:00  sjsrey

	* pysal/__init__.py: update for spreg and contrib inclusion


2012-07-07 16:51  sjsrey

	* pysal/spatial_dynamics/markov.py: - updating doc strings

2012-07-07 16:17  sjsrey

	* pysal/spreg/probit.py:
	  - fixing doc string and refs 

2012-07-06 21:58  dfolch

	* doc/source/library/spreg/probit.txt: txt file to include probit in the HTML docs

2012-07-06 21:11  dfolch

	* pysal/spreg/tests/test_ols_sparse.py: fixing unittest error; still no solution to scientific notation formatting in doctests

2012-07-06 20:24  dfolch

	* pysal/spreg/__init__.py,
	  pysal/spreg/diagnostics.py,
	  pysal/spreg/diagnostics_sp.py,
	  pysal/spreg/diagnostics_tsls.py,
	  pysal/spreg/error_sp.py,
	  pysal/spreg/error_sp_het.py,
	  pysal/spreg/error_sp_hom.py,
	  pysal/spreg/ols.py,
	  pysal/spreg/probit.py,
	  pysal/spreg/robust.py,
	  pysal/spreg/summary_output.py,
	  pysal/spreg/tests/test_diagnostics.py,
	  pysal/spreg/tests/test_diagnostics_sp.py,
	  pysal/spreg/tests/test_diagnostics_tsls.py,
	  pysal/spreg/tests/test_error_sp.py,
	  pysal/spreg/tests/test_error_sp_het.py,
	  pysal/spreg/tests/test_error_sp_het_sparse.py,
	  pysal/spreg/tests/test_error_sp_hom.py,
	  pysal/spreg/tests/test_error_sp_hom_sparse.py,
	  pysal/spreg/tests/test_error_sp_sparse.py,
	  pysal/spreg/tests/test_ols.py,
	  pysal/spreg/tests/test_ols_sparse.py,
	  pysal/spreg/tests/test_probit.py,
	  pysal/spreg/tests/test_twosls.py,
	  pysal/spreg/tests/test_twosls_sp.py,
	  pysal/spreg/tests/test_twosls_sp_sparse.py,
	  pysal/spreg/tests/test_twosls_sparse.py,
	  pysal/spreg/twosls.py,
	  pysal/spreg/twosls_sp.py,
	  pysal/spreg/user_output.py,
	  pysal/spreg/utils.py: -Adding classic probit regression class -Adding spatial diagnostics for probit -Allowing x parameter to be either a numpy array or scipy sparse matrix in all regression classes -Adding additional unit tests -Various refactoring to streamline code base and improve long term maintainability -Contributions from Luc Anselin, Pedro Amaral, Daniel Arribas-Bel, David Folch and Nicholas Malizia

2012-07-03 18:59  sjsrey

	* pysal/spatial_dynamics/markov.py,
	  pysal/spatial_dynamics/tests/test_markov.py: - refactor significant move_types for clarity and fixing a logic bug


2012-06-20 04:50  sjsrey@gmail.com

	* doc/source/developers/docs/index.txt:
	  - added section for how to write a tutorial for new modules 
2012-06-20 02:45  sjsrey

	* doc/source/developers/docs/index.txt:
	  - updating doc building instructions

2012-06-06 18:58  phil.stphns

	* .build-osx10.6-py26.sh,
	  .build-osx10.6-py27.sh:
	  - local modifications for Frameworks builds

2012-06-05 20:56  phil.stphns

	* .build-osx10.6-py26.sh,
	  .build-osx10.6-py27.sh,
	  .build-osx10.7-py27.sh, .runTests.sh:
	  - adding experimental build and test scripts.

2012-06-05 16:43  schmidtc

	* pysal/cg/segmentLocator.py,
	  pysal/cg/shapes.py,
	  pysal/contrib/spatialnet/spatialnet.py:
	  initial snap function for spatialnet

2012-06-05 16:38  schmidtc

	* pysal/core/IOHandlers/pyShpIO.py,
	  pysal/core/util/shapefile.py,
	  pysal/core/util/tests/test_shapefile.py: Adding PolygonZ support to Shapefile IO

2012-05-24 21:57  sjsrey

	* pysal/esda/mapclassify.py: - truncate option for fisher_jenks sampling

2012-05-15 20:08  schmidtc

	* pysal/cg/segmentLocator.py,
	  pysal/cg/shapes.py: Added query to SegmentLocator

2012-05-11 22:17  sjsrey

	* pysal/esda/mapclassify.py: - added Fisher_Jenks_Sampled

2012-05-11 00:45  mhwang4

	* pysal/contrib/network/distances.csv,
	  pysal/contrib/network/simulator.py,
	  pysal/contrib/network/test_lincs.py,
	  pysal/contrib/network/test_weights.py,
	  pysal/contrib/network/weights.py: adding test code for distance-file-based weight generator; updates on simulator 

2012-05-10 22:37  mhwang4

	* pysal/contrib/network/klincs.py,
	  pysal/contrib/network/lincs.py,
	  pysal/contrib/network/test_klincs.py,
	  pysal/contrib/network/test_lincs.py: adding test code for network-constrained lisa

2012-05-10 21:11  mhwang4

	* pysal/contrib/network/crimes.dbf,
	  pysal/contrib/network/crimes.shp,
	  pysal/contrib/network/crimes.shx,
	  pysal/contrib/network/test_klincs.py: test code for local K function

2012-05-08 18:05  mhwang4

	* pysal/contrib/network/streets.dbf,
	  pysal/contrib/network/streets.shp,
	  pysal/contrib/network/streets.shx,
	  pysal/contrib/network/test_network.py: adding a test data set

2012-05-08 16:34  schmidtc

	* pysal/cg/segmentLocator.py,
	  pysal/cg/shapes.py,
	  pysal/core/FileIO.py: Adding start of segmentLocator, adding minimal slicing support to FileIO


2012-05-03 17:03  schmidtc

	* pysal/cg/shapes.py,
	  pysal/cg/tests/test_shapes.py: Adding solve for x support to Line. Cleaning up LineSegment's Line method.

2012-04-20 17:48  schmidtc

	* pysal/cg/shapes.py: adding arclen method to Chain object.

2012-04-19 16:37  dfolch

	* pysal/weights/Distance.py: reducing number of distance queries in Kernel from n^2 to n

2012-04-17 21:20  schmidtc

	* pysal/contrib/spatialnet/spatialnet.py: adding distance

2012-04-17 19:46  schmidtc

	* pysal/contrib/spatialnet/cleanNetShp.py,
	  pysal/contrib/spatialnet/spatialnet.py: Adding FNODE/TNODE to dbf when cleaning shapefiles. Added util function createSpatialNetworkShapefile Added SpatialNetwork class

2012-04-17 15:32  schmidtc

	* pysal/contrib/weights_viewer/weights_viewer.py: "revert back to the background when the point is outside of any unit" - request from serge

2012-04-11 02:50  schmidtc

	* pysal/cg/kdtree.py: Fixing user submitted bug,issue #206.

2012-04-10 22:00  dreamessence

	* pysal/weights/Wsets.py: Including w_clip in __all__

2012-04-10 21:58  dreamessence

	* pysal/weights/Wsets.py: Adding w_clip method to clip W matrices (sparse and/or pysal.W) with a second (binary) matrix

2012-04-10 21:57  schmidtc

	* pysal/contrib/spatialnet/beth_roads.shp,
	  pysal/contrib/spatialnet/beth_roads.shx,
	  pysal/contrib/spatialnet/cleanNetShp.py: Adding network shapefile cleaning tools and temporary sample data.  

2012-04-10 21:48  sjsrey

	* pysal/contrib/spatialnet/util.py: - more stubs for util mod

2012-04-10 19:58  sjsrey

	* pysal/contrib/spatialnet/util.py: - start of util module

2012-04-03 20:43  sjsrey

	* pysal/contrib/spatialnet: - new contrib module - integrate geodanet functional (move over from network) - wrap networkx

2012-04-03 01:21  schmidtc

	* pysal/cg/rtree.py: Adding pickle support to RTree


2012-03-28 23:27  mhwang4 
	* pysal/contrib/network/kernel.py,
	  pysal/contrib/network/kfuncs.py,
	  pysal/contrib/network/test_access.py,
	  pysal/contrib/network/test_kernel.py,
	  pysal/contrib/network/test_kfuncs.py,
	  pysal/contrib/network/test_network.py: adding examples for network-related modules

2012-03-19 15:33  schmidtc

	* pysal/core/IOHandlers/pyDbfIO.py: Adding support for writing Null dates

2012-03-14 21:04  phil.stphns

	* doc/source/developers/testing.txt,
	  doc/source/users/installation.txt: Small changes to user install instructions to highlight the ease with which pysal can be installed ;-> And, developer instructions for running the test suite from within a session if desired.

2012-03-03 00:00  phil.stphns

	* pysal/spatial_dynamics/markov.py: Potential source of dev docs pngmath latex fail.

2012-02-24 23:29  mhwang4

	* pysal/contrib/network/network.py: fixing bug in network.py

2012-02-20 19:50  phil.stphns

	* doc/source/developers/py3k.txt: Developer doc to explain setting up PySAL for Python3.

2012-02-20 16:18  schmidtc

	* pysal/esda/__init__.py: removing invalid __all__ from esda's init.  See #194

2012-02-16 23:15  phil.stphns

	* pysal/__init__.py,
	  pysal/core/util/shapefile.py: Minor changes to imports that cause py3tool to stumble.

2012-02-15 23:16  phil.stphns

	* doc/source/developers/py3k.txt,
	  doc/source/users/installation.txt: Modified links in user installation instructions.  Added more steps for developers setting up Python3 dev environments on OSX.

2012-02-14 21:55  schmidtc

	* pysal/esda/getisord.py: fixing side effect caused when changing the shape of y, creating a new view with reshape instead.

2012-02-14 21:21  schmidtc

	* pysal/esda/getisord.py: optimizing G_Local

2012-02-14 20:37  schmidtc

	* pysal/esda/getisord.py: optimizing G

2012-02-14 00:21  phil.stphns

	* doc/source/developers/index.txt,
	  doc/source/developers/py3k.txt,
	  doc/source/developers/release.txt: Adding early docs on Python 3 support. Modifying release instructions.

# PySAL 1.3.0, 2012-01-31

    * core/IOHandlers/pyDbfIO.py: Addressing issue #186

    * cg/shapes.py: fixing small bug in polygon constructor that causes
      an exception when an empty list is passed in for the holes.

    * cg/standalone.py: removing standalone centroid method. see issue
      #138.

    * esda/mapclassify.py, esda/tests/test_mapclassify.py: - new
      implementation of fisher jenks

    * spreg/__init__.py, spreg/diagnostics_sp.py,
      spreg/diagnostics_tsls.py, spreg/error_sp.py,
      spreg/error_sp_het.py, spreg/error_sp_hom.py, spreg/ols.py,
      spreg/robust.py, spreg/tests, spreg/twosls.py,
      spreg/twosls_sp.py, spreg/user_output.py, spreg/utils.py: Adding
      the following non-spatial/spatial regression modules:
      * Two Stage Least Squares
      * Spatial Two Stage Least Squares
      * GM Error (KP 98-99)
      * GM Error Homoskedasticity (Drukker et. al, 2010)
      * GM Error Heteroskedasticity (Arraiz et. al, 2010)
      * Anselin-Kelejian test for residual spatial autocorrelation of
      residuals from IV regression
      
      Adding also utility functions and other helper classes.
      
    * cg/standalone.py: slight improvment to get_shared_segments, in
      part to make it more readable.

    * cg/shapes.py, cg/tests/test_standalone.py: adding <,<=,>,>= tests
      to Point, this fixes a bug in the get_shared_segments function
      that was causing some LineSegments to be incorectly ordered
      because the default memory address was being used instead of the
      points location.

    * core/IOHandlers/tests/test_wkt.py, core/IOHandlers/wkt.py,
      core/util/tests/test_wkt.py, core/util/wkt.py,
      weights/tests/test_Distance.py, weights/tests/test_user.py,
      weights/user.py: Fixing small numerical errors n testing that
      resulted from changing the centroid algorithm.

    * esda/moran.py: another optimization for __crand see issue #188

    * weights/util.py: Added option for row-standardized SW in lat2SW.
      Implementing suggestion from Charlie in Issue 181 from
      StackOverflow

    * esda/moran.py: another optimization to __crand, see issue #188
      for details.

    * esda/moran.py: Optimized __crand in Local_Moran

    * cg/shapes.py, cg/standalone.py, contrib/shapely_ext.py:
      Adddressing issue #138, centroids for polygons with holes
      Fixing some issues with the shapely wrapper and out implemenation
      of __geo_interface__

    * weights/Distance.py: previous 'fix' to uniform kernel did not
      have correct dimensions

    * core/IOHandlers/arcgis_txt.py, core/IOHandlers/dat.py,
      weights/user.py: fixing rounding errors with docstrings

    * contrib/README, contrib/shared_perimeter_weights.py: Adding
      shared perimeter weights, see Issue #46

    * contrib/README, contrib/shapely_ext.py: moving shapely_ext into
      contrib

    * core/IOHandlers/pyDbfIO.py: Fixing issue with scientific notation
      is DBF files. #182

    * core/IOHandlers/pyShpIO.py: clockwise testing should only be
      performed on Polygons. #183

    * spreg/diagnostics_sp.py: Switching ints to floats in variance of
      Morans I for residuals to get correct results

    * core/util/shapefile.py, examples/__init__.py: Add a "get_path"
      function to examples module.
      pysal.examples.get_path('stl_hom.shp') will always return the
      correct system path to stl_hom.shp, no matter where it's run
      from. This is useful for testing.
      Modified shapefile tests to use the new function.

    * spreg/diagnostics.py: Adding check on condition_index to pick OLS
      (xtx) or IV (hth) model

    * core/IOHandlers/template.py: Updating template to pass unit
      testing.

    * core/util/shapefile.py: Fixing issue #180. Making shapefile
      opener case insensitive.

    * spatial_dynamics/interaction.py,
      spatial_dynamics/tests/test_interaction.py: Adding modified Knox
      and changes to existing tests in spatial_dynamics.

    * core/IOHandlers/arcgis_txt.py,
      core/IOHandlers/tests/test_arcgis_txt.py: fixing arcgis_txt.py so
      that it ignores self-neighbors with zero weights

    * core/FileIO.py: Updating library README.
      Removing docstrings from FileIO module.

    * contrib/README: adding contrib to installer and adding initial
      README

    * core/IOHandlers/gwt.py: rewrote GWT reader to avoid list appends.
      resulted in speed up of about 12x.

    * core/IOHandlers/pyDbfIO.py: implementing _get_col for dbf files.

    * core/IOHandlers/gwt.py: Adding a small fix to gwt reader, if the
      ids cannot be found in the associated DBF, they will be read in
      order from the GWT file.

    * contrib/weights_viewer/weights_viewer.py: Small change to
      identify polygons that are their own neighbor.

    * weights/Distance.py: removing incorrect kernel functions and
      fixing bug in uniform kernel

    * weights/util.py: refactoring insert_diagonal so that it can add
      or overwrite the diagonal weights

    * contrib, contrib/README, contrib/__init__.py,
      contrib/weights_viewer, contrib/weights_viewer/__init__.py,
      contrib/weights_viewer/transforms.py,
      contrib/weights_viewer/weights_viewer.py: Adding 1st contrib, a
      wxPython based Weights file viewer.


    * spatial_dynamics/markov.py: - handle case of zero transitions in
      spatial markov, consistent with treatment
      in classic markov

    * core/FileIO.py, core/IOHandlers/pyShpIO.py: Changes to allow
      reading of null polygons.

    * core/util/shapefile.py, core/util/tests/test_shapefile.py:
      refactoring shapefile reader, see issue #89

    * core/FileIO.py: small change to FileIO to allow FileFormat
      argument to be passed through

    * esda/getisord.py: fixing bug in local Z values for integer data

    * cg/__init__.py, weights/user.py, weights/util.py: adding radius
      option to user weights methods

    * cg/kdtree.py, common.py, weights/Distance.py,
      weights/tests/test_Distance.py: Distance weights can not be
      passed an instnace of KDTree instead of an array. If the KDTree
      is of type ArcKDTree, the weights returns will be based on
      ArcDistances. Adding tests for Arc cases off KNN and
      DistanceBand.

    * weights/util.py: - added function for local clustering
      coefficient - summary for W as a graph

    * cg/kdtree.py, cg/sphere.py: finishing up Arc_KDTree

    * weights/Distance.py: More doctest fixes.

    * region/maxp.py, spreg/diagnostics.py, weights/Distance.py,
      weights/user.py: Fixing the doctests for dusty python setup.

    * cg/kdtree.py, cg/sphere.py: adding spherical wrapper around scipy
      kdtree

    * cg/__init__.py, cg/sphere.py: Adding spherical distance tools to
      cg. Related to issue #168

    * core/IOHandlers/gwt.py, core/IOHandlers/tests/test_gwt.py:
      re-enabled gwt writing.
      'o' transform is used on all GWTs for writing (w is returned to
      existing transform on exit)
      Also, setting '_shpName' and '_varName' attributes on W's which
      are read in through gwt.
      the writer will check if these vars exist and use them for the
      header, this prevents metadata loss on simple copies

    * esda/join_counts.py: - fix for handling int array type

    * spreg/diagnostics.py: Adding more efficient constant check for
      spreg.

    * cg/shapes.py: adding __geo_interface__ and asShape adapter for
      Point, LineString and Polygon

    * spreg/diagnostics.py: minor change to t-stat function to
      accommodate future regression models

    * esda/mapclassify.py: - more general fix for #166


# PySAL 1.2.0, 2011-07-31

    * pysal/spreg/user_output.py: Fix for bug 162

    * pysal/spatial_dynamics/markov.py: Added markov mobility measures; addresses issue 137

    * pysal/weights/weights.py: Partially addressed issue 160 by removing the shimbel, order, and higher_order methods from W. 

    * doc/source/users/installation.txt: Adding known issue regarding GNU/Linux testing and random seeds; see ticket 52.

    * pysal/esda/geary.py: Adding sparse implementation of Geary's C; substantial gains on larger datasets. 

    * pysal/core/IOHandlers/mtx.py: Adding WSP2W function for fast conversion of sparse weights object (WSP) to pysal W.

    * pysal/esda/getisord.py: Adding Getis-Ord G test module

    * pysal/weights/util.py: Added function that inserts values along the main diagonal of a weights object

    * doc/source/users/tutorials: Fixed issue 76.

    * pysal/core/IOHandlers/mtx.py: Added an IOHandler for MatrixMarket MTX files

    * pysal/esda/moran.py: Optimized conditional randomization

    * pysal/weights/util.py: Re-adding full2W() method to convert full arrays into W objects; related to issue #136. 

    * pysal/core/IOHandlers/gal.py: Added sparse WSP (thin W); gal reader can return W or WSP

    * pysal/core/IOHandlers/pyDbfIO.py: Bug Fix, DBF files are not properly closed when opened in 'r' mode. See issue #155.

    * pysal/core/IOHandlers/stata_txt.py: Adding FileIO handlers for STATA text files

    * pysal/weights/user.py: Fixed issue #154, adding k option to User Kernel weights functions.

    * pysal/core/IOHandlers/mat.py: Adding an IOHandler for MATLAB mat file

    * pysal/core/IOHandlers/wk1.py: Adding an IO handler for wk1 file

    * pysal/core/IOHandlers/geobugs_txt.py: Adding an IO handler for geobugs text file.

    * pysal/core/IOHandlers/arcgis_swm.py: Added ArcGIS SWM file handler

    * pysal/core/IOHandlers/arcgis_dbf.py: Adding a spatial weights file in the (ArcGIS-style) DBF format. 

    * pysal/core/IOHandlers/arcgis_txt.py: Added ArcGIS ASCII file IO handler. 

    * pysal/core/IOHandlers/dat.py: Added DAT file handler.

    * pysal/cg/locators.py: Added point in polygon method for Polygon and PolygonLocator

    * pysal/weights/Distance.py: Optimized Kernel() method to run much faster for the case of adaptive bandwidths

    * pysal/weights/user.py: Added helper function in user.py to create scipy sparse matrix from a gal file

    * pysal/common.py: Added shallow copy method to Read-Only Dict to support multiprocessing.

    * pysal/spatial_dynamics/rank.py: More efficient regime weights

    * pysal/weights/Distance.py: Adding epanechnikov and bisquare kernel funtions

    * pysal/core/IOHandlers/pyDbfIO.py: Adding NULL support to numerical DBF fields; modifying PointLocator API to match PolygonLocator API 

    * pysal/cg/locators.py: Handles case when query rectangle is completely inside a polygon

    * pysal/cg/locators.py: Explicit polygon overlap hit test

    * pysal/cg/standalone.py: Adding point-polygon intersection support for polygons with holes.

    * pysal/spatial_dynamics/markov.py: Added homogeneity test.

    * pysal/spatial_dynamics/markov.py: Added spillover test in LISA_Markov.

    * pysal/cg/locators.py: Added Rtree based spatial index for polygonlocator.

    * pysal/cg/rtree.py: Added pure python Rtree module.

    * doc/source/developers/pep/pep-0010.txt: Added PEP 0010: Rtree module in pure python.

    * pysal/esda/geary.py: Fixed bug 144.

    * pysal/spatial_dynamics/markov.py: Added significance filtering of LISA markov.

    * doc/source/developers/pep/pep-0009.txt: Added new PEP, "PEP 0009: Add Python 3.x Support."

    * doc/source/developers/guidelines.txt: New release cycle schedules for 1.2 and 1.3.

    * doc/source/developers/release.txt: Updated pypi instructions; PySAL available on the Python Package Index via download, easy_install, and pip. 

# PySAL 1.1.0, 2011-01-31

    * pysal/core/FileIO.py, pysal/core/IOHandlers/pyDbfIO.py: Added missing value support to FileIO. Warnings will be issued when missing values are found and the value will be set to pysal.MISSINGVALUE, currently None, but the user can change it as needed.

    * pysal/spreg/: Added Spatial Regression module, spreg, and tests.  Added non-spatial diagnostic tests for OLS regression. 

    * pysal/core/IOHandlers/gwt.py: Fixing bottle neck in gwt reader, adding support for GeoDa Style ID's and DBF id_order.

    * pysal/cg/standalone.py: adding, distance_matrix, full distance matrix calculation using sparse matrices

    * pysal/core/util: Moved "converters" into core.util, allows them to be used independently of FileIO.

    * pysal/weights/Distance.py: Adding work around for bug in scipy spatial, see pysal issue #126

    * pysal/weights/user.py: Added build_lattice_shapefile in weights.user, which writes an ncol by nrow grid to a shapefile.

    * pysal/weights/Distance.py: fixed coincident point problem in knnW and made sure it returns k neighbors 
    * pysal/spatial_dynamics/interaction.py: Added a suite of spatio-temporal interaction tests including the Knox, Mantel, and Jacquez tests. 

    * pysal/weights/util.py: Added lat2SW, allows to create a sparse W matrix for a regular lattice.

    * pysal/tests/tests.py: - new 1.1 integration testing scheme.

    * pysal/esda/interaction.py: added standardized Mantel test and improved readability.

    * pysal/spatial_dynamics/directional.py: - adding directional LISA analytics

    * pysal/esda/mapclassify.py: Natural_Breaks will lower k for data with fewer than k unique values, prints warning.

    * pysal/region/randomregion.py: improvements to spatially constrained random region algorithm

    * pysal/esda/smoothing.py: Adding choynowski probabilities and SMR to smoothing.py

    * doc/source/developers/release.txt: - updating release cycle - release management

# PySAL 1.0.0, 2010-07-31 -- Initial release.
The following 13 authors contributed 216 commits.

* Dani Arribas-Bel
* David Folch
* Philip Stephens
* Serge Rey
* Wei Kang
* jlaura
* levi.john.wolf@gmail.com
* pedrovma

We closed a total of 86 issues, 33 pull requests and 53 regular issues;
this is the full list (generated with the script 
:file:`tools/github_stats.py`):

Pull Requests (33):

* :ghpull:`724`: add synchronization tool
* :ghpull:`733`: Fb/bump
* :ghpull:`731`: Small docfixes
* :ghpull:`730`: Contrib docs
* :ghpull:`728`: B179
* :ghpull:`727`: Geodf io
* :ghpull:`725`: try pinning scipy,numpy
* :ghpull:`723`: make sure to test all moran classes
* :ghpull:`720`: Moving natural breaks to a cleaner kmeans implementation
* :ghpull:`718`: force counts to be same length as bins
* :ghpull:`714`: Dev
* :ghpull:`715`: Heads
* :ghpull:`713`: Enh712
* :ghpull:`710`: Patsy/Pandas wrapper
* :ghpull:`711`: Travis fixes
* :ghpull:`706`: precommit hook
* :ghpull:`707`: Keep dev updated with any bugfixes into master
* :ghpull:`702`: fix for chi2 test 0 denominator and invocation of chi2 test in LISA_Markov
* :ghpull:`704`: Allcloser
* :ghpull:`703`: Swapping to Allclose and RTOL=.00005 in spreg
* :ghpull:`701`: By col array
* :ghpull:`700`: small optimization of bivariate moran motivated by #695
* :ghpull:`696`: Pypi
* :ghpull:`691`: Update doctest for one-off bug that was fixed with #690
* :ghpull:`690`: fix for lisa markov one off for significance indicator
* :ghpull:`689`: Clpy flex w
* :ghpull:`688`: pep 8 edits
* :ghpull:`687`: Change array assertions into allclose
* :ghpull:`686`: Moran local bivariate
* :ghpull:`684`: 591
* :ghpull:`682`: release instructions updated
* :ghpull:`681`: version bump for next dev cycle
* :ghpull:`680`: Rel1.10

Issues (53):

* :ghissue:`705`: spreg check valve
* :ghissue:`344`: Explore new dependency on ogr
* :ghissue:`459`: Problem with bandwidth
* :ghissue:`552`: Viz organization
* :ghissue:`491`: Test np.allclose() for unit tests
* :ghissue:`529`: Clarity needed on proper reference formatting in sphinx docs
* :ghissue:`699`: Trouble importing pysal - ImportError: DLL load failed
* :ghissue:`716`: `min_threshold_dist_from_shapefile` creating an island in some cases
* :ghissue:`724`: add synchronization tool
* :ghissue:`733`: Fb/bump
* :ghissue:`731`: Small docfixes
* :ghissue:`730`: Contrib docs
* :ghissue:`719`: pysal not working with matplotlib v1.5 for plot_lisa_cluster, plot_choropleth, etc.
* :ghissue:`728`: B179
* :ghissue:`727`: Geodf io
* :ghissue:`725`: try pinning scipy,numpy
* :ghissue:`723`: make sure to test all moran classes
* :ghissue:`720`: Moving natural breaks to a cleaner kmeans implementation
* :ghissue:`717`: esda.mapclassify return problematic counts when there is 0 occurrence in the last class
* :ghissue:`718`: force counts to be same length as bins
* :ghissue:`714`: Dev
* :ghissue:`712`: `block_weights` does not take argument `idVariable`
* :ghissue:`715`: Heads
* :ghissue:`713`: Enh712
* :ghissue:`710`: Patsy/Pandas wrapper
* :ghissue:`711`: Travis fixes
* :ghissue:`706`: precommit hook
* :ghissue:`708`: 2-3: is six a dependency or do we ship it?
* :ghissue:`707`: Keep dev updated with any bugfixes into master
* :ghissue:`702`: fix for chi2 test 0 denominator and invocation of chi2 test in LISA_Markov
* :ghissue:`704`: Allcloser
* :ghissue:`703`: Swapping to Allclose and RTOL=.00005 in spreg
* :ghissue:`698`: Py3merge
* :ghissue:`701`: By col array
* :ghissue:`700`: small optimization of bivariate moran motivated by #695
* :ghissue:`695`: Bivariate global moran's I formula
* :ghissue:`683`: Py3 Conversion Project
* :ghissue:`694`: Allclose in SPREG
* :ghissue:`696`: Pypi
* :ghissue:`691`: Update doctest for one-off bug that was fixed with #690
* :ghissue:`693`: Trouble installation: No module named 'shapes'
* :ghissue:`690`: fix for lisa markov one off for significance indicator
* :ghissue:`689`: Clpy flex w
* :ghissue:`688`: pep 8 edits
* :ghissue:`685`: BV Lisa 
* :ghissue:`687`: Change array assertions into allclose
* :ghissue:`686`: Moran local bivariate
* :ghissue:`677`: Make meta importable from base
* :ghissue:`684`: 591
* :ghissue:`682`: release instructions updated
* :ghissue:`679`: pysal.cg.sphere.fast_knn bug
* :ghissue:`681`: version bump for next dev cycle
* :ghissue:`680`: Rel1.10

v<1.10.0>, 2015-07-29

GitHub stats for 2015/01/31 - 2015/07/29

These lists are automatically generated, and may be incomplete or contain duplicates.

The following 20 authors contributed 334 commits.

* Charlie Schmidt
* Dani Arribas-Bel
* Daniel Arribas-Bel
* David C. Folch
* David Folch
* Jay
* Levi John Wolf
* Marynia
* Philip Stephens
* Serge Rey
* Sergio Rey
* Taylor Oshan
* The Gitter Badger
* Wei Kang
* jay
* jlaura
* ljw
* ljwolf
* luc
* pedrovma


We closed a total of 156 issues, 58 pull requests and 98 regular issues;
this is the full list (generated with the script 
:file:`tools/github_stats.py`):

Pull Requests (58):

* :ghpull:`675`: Update README.md
* :ghpull:`673`: Adding init at pdutilities so they are importable
* :ghpull:`672`: ENH: option to locate legend
* :ghpull:`669`: add nonsudo travis
* :ghpull:`666`: Cleaned up conflicts in ref branch
* :ghpull:`664`: Lisa map
* :ghpull:`663`: Examples
* :ghpull:`661`: Reorganization of examples 
* :ghpull:`657`: Assuncao test division errors
* :ghpull:`649`: Add a Gitter chat badge to README.md
* :ghpull:`647`: Addresses 646
* :ghpull:`645`: Update to weights module documentation for PySAL-REST
* :ghpull:`644`: removed test print statements from df2dbf
* :ghpull:`643`: using dtypes.name in df2dbf to avoid gotcha in type
* :ghpull:`642`: Updating copyright year
* :ghpull:`634`: allows non-symmetric distance matrices
* :ghpull:`641`: turning off generatetree
* :ghpull:`592`: adding check for version #591
* :ghpull:`636`: vertical line point simulation
* :ghpull:`639`: Snapping
* :ghpull:`640`: Add users to travis
* :ghpull:`627`: Networkrb
* :ghpull:`631`: Fixing typoes in analysis.py
* :ghpull:`626`: cast arrays over inconsistent kdtree return types
* :ghpull:`620`: adding explicit check for random region contiguity
* :ghpull:`619`: Fixing spreg's warnings
* :ghpull:`618`: initial folder with dbf utilities using pandas
* :ghpull:`616`: Adding isolation and theil indices to inequality._indices.py
* :ghpull:`615`: Network docs
* :ghpull:`614`: cleaning up pr testing
* :ghpull:`613`: test coverage to 98% on network
* :ghpull:`612`: small change for testing PR
* :ghpull:`611`: stubbed in minimal tests
* :ghpull:`607`: B603
* :ghpull:`602`: Documentation Extraction Notebook
* :ghpull:`606`: pct_nonzero was reporting a ratio not a percentage
* :ghpull:`604`: Contribpush
* :ghpull:`601`: Documentation Cleanup
* :ghpull:`599`: Casting bugfix from #598
* :ghpull:`600`: Updates for coveralls
* :ghpull:`598`: IO in Python 3
* :ghpull:`597`: Decoupling bbox from map_XXX_poly
* :ghpull:`595`: Removed testing line in travis.yml and added a .coveragerc file to manag...
* :ghpull:`590`: using numpy sum method
* :ghpull:`589`: Wconstructor
* :ghpull:`588`: Coveralls
* :ghpull:`585`: Fisher Jenks bug in `plot_choropleth`
* :ghpull:`584`: Alpha in plot chor
* :ghpull:`583`: Fixed 576
* :ghpull:`580`: working on #576
* :ghpull:`578`: Fixes #577
* :ghpull:`574`: Handle case where a region has a 0 share.
* :ghpull:`571`: Dict to unique value mapper
* :ghpull:`570`: numpy doc cleanup for weights module
* :ghpull:`569`: folium viz scripts
* :ghpull:`568`: inline with numpy doc spec (spatial_dynamics module)
* :ghpull:`567`: New/masterbump
* :ghpull:`566`: Fix for 1.9.0 missing file in setup.py

Issues (98):

* :ghissue:`675`: Update README.md
* :ghissue:`658`: Travis.CI """Legacy""" architecture
* :ghissue:`667`: Examples Not Found
* :ghissue:`673`: Adding init at pdutilities so they are importable
* :ghissue:`672`: ENH: option to locate legend
* :ghissue:`669`: add nonsudo travis
* :ghissue:`671`: Shapefile Read - PolygonM Attribute Error
* :ghissue:`670`: examples README markdown files reformatting
* :ghissue:`668`: Wconstructor
* :ghissue:`666`: Cleaned up conflicts in ref branch
* :ghissue:`664`: Lisa map
* :ghissue:`662`: Pep8
* :ghissue:`665`: Refs
* :ghissue:`663`: Examples
* :ghissue:`573`: Examples
* :ghissue:`661`: Reorganization of examples 
* :ghissue:`656`: Assuncao rate improper division
* :ghissue:`657`: Assuncao test division errors
* :ghissue:`280`: handle multi-segment links in net_shp_io.py
* :ghissue:`649`: Add a Gitter chat badge to README.md
* :ghissue:`647`: Addresses 646
* :ghissue:`646`: arc distance in knnW
* :ghissue:`645`: Update to weights module documentation for PySAL-REST
* :ghissue:`644`: removed test print statements from df2dbf
* :ghissue:`643`: using dtypes.name in df2dbf to avoid gotcha in type
* :ghissue:`603`: Polygon.contains_point does not correctly process multipart polygons.
* :ghissue:`642`: Updating copyright year
* :ghissue:`623`: reading road shapfiles into network
* :ghissue:`608`: Scipy Sparse Graph
* :ghissue:`621`: network distance speedup
* :ghissue:`632`: network point snapping
* :ghissue:`633`: point to point distances on network
* :ghissue:`635`: simulating points on vertical lines
* :ghissue:`634`: allows non-symmetric distance matrices
* :ghissue:`641`: turning off generatetree
* :ghissue:`637`: speedup distance computations
* :ghissue:`592`: adding check for version #591
* :ghissue:`628`: Re-enable doctests
* :ghissue:`636`: vertical line point simulation
* :ghissue:`639`: Snapping
* :ghissue:`640`: Add users to travis
* :ghissue:`638`: Add users to Travis
* :ghissue:`627`: Networkrb
* :ghissue:`622`: New network branch from clean master
* :ghissue:`630`: NetworkG api is broken
* :ghissue:`631`: Fixing typoes in analysis.py
* :ghissue:`625`: Installation - Binstar and Anaconda
* :ghissue:`624`: Network topology
* :ghissue:`629`: changes to spreg tests for travis
* :ghissue:`166`: pysal.esda.mapclassify.Fisher_Jenks  -   local variable 'best' referenced before assignment
* :ghissue:`626`: cast arrays over inconsistent kdtree return types
* :ghissue:`596`: [question] unsupervised classification
* :ghissue:`620`: adding explicit check for random region contiguity
* :ghissue:`617`: Random_Region not respecting contiguity constraint
* :ghissue:`619`: Fixing spreg's warnings
* :ghissue:`618`: initial folder with dbf utilities using pandas
* :ghissue:`616`: Adding isolation and theil indices to inequality._indices.py
* :ghissue:`615`: Network docs
* :ghissue:`614`: cleaning up pr testing
* :ghissue:`613`: test coverage to 98% on network
* :ghissue:`612`: small change for testing PR
* :ghissue:`611`: stubbed in minimal tests
* :ghissue:`607`: B603
* :ghissue:`602`: Documentation Extraction Notebook
* :ghissue:`606`: pct_nonzero was reporting a ratio not a percentage
* :ghissue:`605`: RTree Weights
* :ghissue:`604`: Contribpush
* :ghissue:`601`: Documentation Cleanup
* :ghissue:`554`: Beginning documentation cleanup
* :ghissue:`599`: Casting bugfix from #598
* :ghissue:`600`: Updates for coveralls
* :ghissue:`598`: IO in Python 3
* :ghissue:`597`: Decoupling bbox from map_XXX_poly
* :ghissue:`595`: Removed testing line in travis.yml and added a .coveragerc file to manag...
* :ghissue:`586`: Look at using Coveralls
* :ghissue:`590`: using numpy sum method
* :ghissue:`589`: Wconstructor
* :ghissue:`588`: Coveralls
* :ghissue:`576`: Predecessor lists inconsistencies
* :ghissue:`585`: Fisher Jenks bug in `plot_choropleth`
* :ghissue:`584`: Alpha in plot chor
* :ghissue:`583`: Fixed 576
* :ghissue:`582`: Fixes #576
* :ghissue:`581`: Network
* :ghissue:`580`: working on #576
* :ghissue:`575`: Network from Lattice
* :ghissue:`578`: Fixes #577
* :ghissue:`577`: bug in FileIO.cast
* :ghissue:`574`: Handle case where a region has a 0 share.
* :ghissue:`343`: Edge Segmentation
* :ghissue:`571`: Dict to unique value mapper
* :ghissue:`570`: numpy doc cleanup for weights module
* :ghissue:`569`: folium viz scripts
* :ghissue:`568`: inline with numpy doc spec (spatial_dynamics module)
* :ghissue:`567`: New/masterbump
* :ghissue:`564`: Bug in setup.py
* :ghissue:`566`: Fix for 1.9.0 missing file in setup.py
* :ghissue:`565`: Bsetup


v<1.9.1>, 2015-01-31

GitHub stats for 2015/01/30 - 2015/01/31 

These lists are automatically generated, and may be incomplete or contain duplicates.

The following 4 authors contributed 14 commits.

* Dani Arribas-Bel
* Serge Rey
* Sergio Rey
* jlaura


We closed a total of 8 issues, 3 pull requests and 5 regular issues;
this is the full list (generated with the script 
:file:`tools/github_stats.py`):

Pull Requests (3):

* :ghpull:`566`: Fix for 1.9.0 missing file in setup.py
* :ghpull:`563`: Updating release instructions
* :ghpull:`561`: Rolling over to 1.10

Issues (5):

* :ghissue:`566`: Fix for 1.9.0 missing file in setup.py
* :ghissue:`565`: Bsetup
* :ghissue:`563`: Updating release instructions
* :ghissue:`562`: adjustments to release management
* :ghissue:`561`: Rolling over to 1.10


v<1.9.0>, 2015-01-30

GitHub stats for 2014/07/25 - 2015/01/30 

These lists are automatically generated, and may be incomplete or contain duplicates.

The following 12 authors contributed 131 commits.

* Andy Reagan
* Dani Arribas-Bel
* Jay
* Levi John Wolf
* Philip Stephens
* Qunshan
* Serge Rey
* jlaura
* ljwolf
* luc


We closed a total of 113 issues, 44 pull requests and 69 regular issues;
this is the full list (generated with the script 
:file:`tools/github_stats.py`):

Pull Requests (44):

* :ghpull:`560`: modifying import scheme for network module
* :ghpull:`559`: Network2
* :ghpull:`558`: Network2
* :ghpull:`557`: Network2
* :ghpull:`556`: Added analytical functions and edge segmentation
* :ghpull:`550`: Network2
* :ghpull:`553`: correction in denominator of spatial tau. 
* :ghpull:`547`: Updates to get network integrated
* :ghpull:`544`: update .gitignore
* :ghpull:`543`: k nearest neighbor gwt example file for baltimore points (with k=4) added to examples directory
* :ghpull:`542`: new format nat_queen.gal file added to examples directory
* :ghpull:`541`: Update tutorial docs for new book
* :ghpull:`540`: doc: updating instructions for anaconda and enthought
* :ghpull:`539`: doc: pysal is now on sagemathcloud
* :ghpull:`538`: Clean up of cg and fixes of other doctests/formats
* :ghpull:`536`: adding entry for getis ord module
* :ghpull:`537`: new opendata module for contrib
* :ghpull:`535`: Add method for extracting data columns as Numpy array rather than list
* :ghpull:`534`: added geogrid to __all__ in sphere.py
* :ghpull:`533`: added geogrid function to create a grid of points on a sphere
* :ghpull:`532`: new functions to deal with spherical geometry: lat-lon conversion, degre...
* :ghpull:`530`: I390
* :ghpull:`528`: Replacing 0 by min value in choropleths
* :ghpull:`526`: B166
* :ghpull:`525`: copyright update
* :ghpull:`524`: New homogeneity tests for general case and spatial markov as a special case
* :ghpull:`523`: pointing to github.io pages
* :ghpull:`520`: Same typo. Toolkit.
* :ghpull:`518`: Update util.py
* :ghpull:`519`: Typo
* :ghpull:`517`: Documentation correction for Prais Conditional Mobility Index
* :ghpull:`516`: ENH for https://github.com/PySAL/PySAL.github.io/issues/17
* :ghpull:`515`: BUG: conditional check for extension of lower bound of colorbar to conta...
* :ghpull:`514`: ENH: adding the user_defined classification
* :ghpull:`513`: rewriting to not use ipython notebook --pylab=line
* :ghpull:`512`: Viz
* :ghpull:`508`: Adding barebones pysal2matplotlib options in viz
* :ghpull:`511`: DOC updating news
* :ghpull:`507`: Sched
* :ghpull:`510`: BUG: fix for #509
* :ghpull:`506`: 1.9dev
* :ghpull:`505`: REL bumping master to 1.9.0dev
* :ghpull:`504`: Release prep 1.8
* :ghpull:`503`: Grid for landing page

Issues (69):

* :ghissue:`560`: modifying import scheme for network module
* :ghissue:`559`: Network2
* :ghissue:`558`: Network2
* :ghissue:`557`: Network2
* :ghissue:`556`: Added analytical functions and edge segmentation
* :ghissue:`555`: Added edge segmentation by distance
* :ghissue:`550`: Network2
* :ghissue:`553`: correction in denominator of spatial tau. 
* :ghissue:`549`: Network2
* :ghissue:`547`: Updates to get network integrated
* :ghissue:`548`: Installation Issues
* :ghissue:`546`: Network2
* :ghissue:`545`: Network
* :ghissue:`544`: update .gitignore
* :ghissue:`543`: k nearest neighbor gwt example file for baltimore points (with k=4) added to examples directory
* :ghissue:`542`: new format nat_queen.gal file added to examples directory
* :ghissue:`541`: Update tutorial docs for new book
* :ghissue:`540`: doc: updating instructions for anaconda and enthought
* :ghissue:`539`: doc: pysal is now on sagemathcloud
* :ghissue:`538`: Clean up of cg and fixes of other doctests/formats
* :ghissue:`536`: adding entry for getis ord module
* :ghissue:`537`: new opendata module for contrib
* :ghissue:`535`: Add method for extracting data columns as Numpy array rather than list
* :ghissue:`534`: added geogrid to __all__ in sphere.py
* :ghissue:`533`: added geogrid function to create a grid of points on a sphere
* :ghissue:`532`: new functions to deal with spherical geometry: lat-lon conversion, degre...
* :ghissue:`390`: add option to have local moran quadrant codes align with geoda
* :ghissue:`530`: I390
* :ghissue:`528`: Replacing 0 by min value in choropleths
* :ghissue:`526`: B166
* :ghissue:`176`: contrib module for proj 4
* :ghissue:`178`: contrib module for gdal/org
* :ghissue:`203`: implement network class in spatialnet
* :ghissue:`204`: pysal-networkx util functions
* :ghissue:`209`: csv reader enhancement
* :ghissue:`215`: Add a tutorial for the spreg module
* :ghissue:`244`: ps.knnW_from_shapefile returns wrong W ids when idVariable specified
* :ghissue:`246`: Only use idVariable in W when writing out to file
* :ghissue:`283`: Create new nodes at intersections of edges
* :ghissue:`291`: Enum links around regions hangs
* :ghissue:`292`: Handle multiple filaments within a region in the Wed construction
* :ghissue:`302`: Handle hole polygons when constructing wed
* :ghissue:`309`: Develop consistent solution for precision induced errors in doctests across platforms
* :ghissue:`350`: reading/writing weights file with spaces in the ids
* :ghissue:`450`: x_name and summary method not consistent in ols
* :ghissue:`521`: Nosetests don't accept setup.cfg
* :ghissue:`509`: ESDA bin type inconsistency
* :ghissue:`525`: copyright update
* :ghissue:`524`: New homogeneity tests for general case and spatial markov as a special case
* :ghissue:`523`: pointing to github.io pages
* :ghissue:`520`: Same typo. Toolkit.
* :ghissue:`522`: Nosetests for python3 porting
* :ghissue:`518`: Update util.py
* :ghissue:`519`: Typo
* :ghissue:`517`: Documentation correction for Prais Conditional Mobility Index
* :ghissue:`516`: ENH for https://github.com/PySAL/PySAL.github.io/issues/17
* :ghissue:`515`: BUG: conditional check for extension of lower bound of colorbar to conta...
* :ghissue:`514`: ENH: adding the user_defined classification
* :ghissue:`513`: rewriting to not use ipython notebook --pylab=line
* :ghissue:`512`: Viz
* :ghissue:`508`: Adding barebones pysal2matplotlib options in viz
* :ghissue:`511`: DOC updating news
* :ghissue:`507`: Sched
* :ghissue:`510`: BUG: fix for #509
* :ghissue:`502`: spreg.ml_lag.ML_Lag is very very very time-consuming?
* :ghissue:`506`: 1.9dev
* :ghissue:`505`: REL bumping master to 1.9.0dev
* :ghissue:`504`: Release prep 1.8
* :ghissue:`503`: Grid for landing page


v<1.8.0>, 2014-07-25

GitHub stats for 2014/01/29 - 2014/07/25 

These lists are automatically generated, and may be incomplete or contain duplicates.

The following 8 authors contributed 281 commits.

* Dani Arribas-Bel
* Jay
* Philip Stephens
* Serge Rey
* Sergio Rey
* jlaura
* pedrovma
* sjsrey


We closed a total of 160 issues, 60 pull requests and 100 regular issues;
this is the full list (generated with the script 
:file:`tools/github_stats.py`):

Pull Requests (60):

* :ghpull:`503`: Grid for landing page
* :ghpull:`501`: Two figs rather than three
* :ghpull:`500`: More efficient higher order operations
* :ghpull:`499`: renamed nat_queen.gal for #452
* :ghpull:`497`: ENH Deprecation warning for regime_weights #486
* :ghpull:`494`: Enables testing against two versions of SciPy shipped with the last two Ubuntu LTS versions.
* :ghpull:`490`: Fix for #487
* :ghpull:`492`: BUG cleaning up temporary files for #398
* :ghpull:`493`: Phil: Skipping several tests that fail due to precision under older scipy
* :ghpull:`489`: test suite fixes
* :ghpull:`488`: More tests to skip if scipy less than 11
* :ghpull:`484`: ENH: cleaning up more test generated files
* :ghpull:`483`: Forwarding Phil's commit: skipping doctests, conditional skip of unit tests
* :ghpull:`482`: DOC cleaning up files after running doctests #398
* :ghpull:`481`: DOC contrib updates and links
* :ghpull:`480`: DOC cleaning up doctests
* :ghpull:`479`: ENH Changing regime_weights to block_weights for #455
* :ghpull:`478`: DOC: link fixes
* :ghpull:`477`: cKDTree for #460
* :ghpull:`476`: redefining w.remap_ids to take only a single arg
* :ghpull:`475`: Adding docstrings and error check to fix #471
* :ghpull:`470`: fixing order of args for api consistency. 
* :ghpull:`469`: Idfix for #449
* :ghpull:`463`: updating gitignore
* :ghpull:`462`: ENH: handle the case of an ergodic distribution where one state has 0 probability
* :ghpull:`458`: ENH: Vagrantfile for PySAL devs and workshops
* :ghpull:`447`: Clusterpy
* :ghpull:`456`: BUG: fix for #451 handling W or WSP in higher_order_sp
* :ghpull:`454`: Foobar
* :ghpull:`443`: Updating spreg: several minor bug and documentation fixes.
* :ghpull:`453`: Resolving conflicts
* :ghpull:`448`: Wsp
* :ghpull:`445`: ENH: unique qualitative color ramp. Also refactoring for future ipython deprecation of --pylab=inline
* :ghpull:`446`: Wmd
* :ghpull:`444`: Scipy dependency
* :ghpull:`442`: Wmd
* :ghpull:`441`: fixed kernel wmd for updated wmd structure
* :ghpull:`440`: ENH: sidebar for Releases and installation doc update
* :ghpull:`439`: - events
* :ghpull:`438`: ENH: pruning to respect flake8
* :ghpull:`437`: BUG: fix for removal of scipy.stat._support #436
* :ghpull:`433`: Rank markov
* :ghpull:`424`: testing
* :ghpull:`431`: FOSS4G
* :ghpull:`430`: Network
* :ghpull:`429`: moving analytics out of wed class and into their own module
* :ghpull:`428`: Network
* :ghpull:`427`: devel docs
* :ghpull:`425`: Viz2contrib
* :ghpull:`423`: Update news.rst
* :ghpull:`422`: ENH: Update doc instructions for napoleon dependency
* :ghpull:`421`: Adding files used in some examples as per Luc's request.
* :ghpull:`419`: Doc fixes 1.7
* :ghpull:`393`: Doc fixes 1.7
* :ghpull:`417`: ENH hex lattice W for #416
* :ghpull:`415`: Temporarily commenting out tests that are blocking Travis.
* :ghpull:`407`: Viz: Moving into contrib/viz in master
* :ghpull:`404`: version change
* :ghpull:`401`: fixes #388
* :ghpull:`402`: release changes

Issues (100):

* :ghissue:`503`: Grid for landing page
* :ghissue:`501`: Two figs rather than three
* :ghissue:`500`: More efficient higher order operations
* :ghissue:`452`: nat_queen.gal example file
* :ghissue:`499`: renamed nat_queen.gal for #452
* :ghissue:`486`: add a deprecation warning on regime_weights
* :ghissue:`497`: ENH Deprecation warning for regime_weights #486
* :ghissue:`449`: Lower order neighbor included in higher order
* :ghissue:`487`: Issue with w.weights when row-standardizing
* :ghissue:`398`: running test suite generates files
* :ghissue:`358`: Graph weights
* :ghissue:`338`: ENH: Move Geary's C calculations to Cython.
* :ghissue:`494`: Enables testing against two versions of SciPy shipped with the last two Ubuntu LTS versions.
* :ghissue:`490`: Fix for #487
* :ghissue:`492`: BUG cleaning up temporary files for #398
* :ghissue:`493`: Phil: Skipping several tests that fail due to precision under older scipy
* :ghissue:`489`: test suite fixes
* :ghissue:`485`: Revert "ENH: cleaning up more test generated files"
* :ghissue:`488`: More tests to skip if scipy less than 11
* :ghissue:`484`: ENH: cleaning up more test generated files
* :ghissue:`483`: Forwarding Phil's commit: skipping doctests, conditional skip of unit tests
* :ghissue:`482`: DOC cleaning up files after running doctests #398
* :ghissue:`481`: DOC contrib updates and links
* :ghissue:`480`: DOC cleaning up doctests
* :ghissue:`455`: regime weights vs block weights
* :ghissue:`479`: ENH Changing regime_weights to block_weights for #455
* :ghissue:`478`: DOC: link fixes
* :ghissue:`460`: Optimize KDTree
* :ghissue:`477`: cKDTree for #460
* :ghissue:`472`: Check for any side effects from new id remapping in w.sparse
* :ghissue:`473`: update all user space functions for new w.remap_ids
* :ghissue:`476`: redefining w.remap_ids to take only a single arg
* :ghissue:`263`: Transition to scipy.spatial.cKDTree from scipy.spatial.KDTree
* :ghissue:`414`: Travis build is killing nosetests
* :ghissue:`335`: Weights transformation docs
* :ghissue:`471`: add docstring example for w.remap_ids
* :ghissue:`475`: Adding docstrings and error check to fix #471
* :ghissue:`405`: ENH: Handling ids in W (Leave open for discussion)
* :ghissue:`470`: fixing order of args for api consistency. 
* :ghissue:`469`: Idfix for #449
* :ghissue:`467`: redirect pysal.org to new dynamic landing page
* :ghissue:`466`: design the grid for the notebooks
* :ghissue:`464`: design new dynamic landing page for github.io
* :ghissue:`465`: move news out of docs and into dynamic landing page
* :ghissue:`468`: Move dynamic items out of sphinx docs and into dynamic landing page
* :ghissue:`463`: updating gitignore
* :ghissue:`451`: docs for higher_order_sp have wrong argument types
* :ghissue:`462`: ENH: handle the case of an ergodic distribution where one state has 0 probability
* :ghissue:`458`: ENH: Vagrantfile for PySAL devs and workshops
* :ghissue:`447`: Clusterpy
* :ghissue:`456`: BUG: fix for #451 handling W or WSP in higher_order_sp
* :ghissue:`457`: This is a test to see if pull request notifications get sent out to the list
* :ghissue:`454`: Foobar
* :ghissue:`443`: Updating spreg: several minor bug and documentation fixes.
* :ghissue:`453`: Resolving conflicts
* :ghissue:`412`: On travis and darwin test_ml_error_regimes.py hangs 
* :ghissue:`448`: Wsp
* :ghissue:`435`: Will spatial durbin model be added in the near future?
* :ghissue:`445`: ENH: unique qualitative color ramp. Also refactoring for future ipython deprecation of --pylab=inline
* :ghissue:`446`: Wmd
* :ghissue:`444`: Scipy dependency
* :ghissue:`442`: Wmd
* :ghissue:`441`: fixed kernel wmd for updated wmd structure
* :ghissue:`440`: ENH: sidebar for Releases and installation doc update
* :ghissue:`439`: - events
* :ghissue:`438`: ENH: pruning to respect flake8
* :ghissue:`436`: Scipy 0.14 induced breakage
* :ghissue:`437`: BUG: fix for removal of scipy.stat._support #436
* :ghissue:`408`: Use of `platform.system()` to determine platform
* :ghissue:`403`: Scipy dependency
* :ghissue:`434`: W Object Metadata Attribute
* :ghissue:`433`: Rank markov
* :ghissue:`424`: testing
* :ghissue:`432`: Implementation of rank Markov classes
* :ghissue:`431`: FOSS4G
* :ghissue:`430`: Network
* :ghissue:`429`: moving analytics out of wed class and into their own module
* :ghissue:`420`: Local Moran's I,  I Attribute Undefined
* :ghissue:`418`: Extended pysal.weights.user.build_lattice_shapefile 
* :ghissue:`428`: Network
* :ghissue:`427`: devel docs
* :ghissue:`426`: dev docs
* :ghissue:`425`: Viz2contrib
* :ghissue:`423`: Update news.rst
* :ghissue:`422`: ENH: Update doc instructions for napoleon dependency
* :ghissue:`421`: Adding files used in some examples as per Luc's request.
* :ghissue:`419`: Doc fixes 1.7
* :ghissue:`393`: Doc fixes 1.7
* :ghissue:`416`: Add hexagonal lattice option for lat2W
* :ghissue:`417`: ENH hex lattice W for #416
* :ghissue:`409`: add wiki page on viz module design
* :ghissue:`413`: Temporary fix for https://github.com/pysal/pysal/issues/412
* :ghissue:`415`: Temporarily commenting out tests that are blocking Travis.
* :ghissue:`407`: Viz: Moving into contrib/viz in master
* :ghissue:`406`: Viz: pruning old code and adding more examples for TAZ paper
* :ghissue:`380`: Pep 8 and Line Length
* :ghissue:`404`: version change
* :ghissue:`401`: fixes #388
* :ghissue:`388`: update testing procedures docs
* :ghissue:`402`: release changes

v<1.7.0>, 2014-01-29

36d268f Philip Stephens -Merge pull request #400 from sjsrey/mldoc
c2c4741 Serge Rey -Formatting ml docs
685f5e3 Sergio Rey -Merge pull request #399 from sjsrey/master
481ccb4 Serge Rey -correct thanks
4a5cce3 Sergio Rey -Update index.txt
1fe7aeb Philip Stephens -Merge pull request #396 from sjsrey/mldoc
e731278 Serge Rey -EHN: fixing link to bleeding edge docs.
e4e9930 Serge Rey -ENH: adding ml docs to api
9b3c77e Serge Rey -Merge branch 'master' of github.com:pysal/pysal
dda3c01 Philip Stephens -Merge pull request #389 from dfolch/master
74b26d5 Philip Stephens -Merge pull request #392 from pedrovma/spreg17
b47ba84 pedrovma -Bump.
3d8504c Sergio Rey -Merge pull request #386 from pastephens/master
f9b59ea Philip Stephens -Merge branch 'master' of https://github.com/pysal/pysal
429e19e pedrovma -Upgrading to spreg 1.7.
c698747 David Folch -removing legacy speedup hack that is no longer relevant
88177d0 Sergio Rey -Merge pull request #387 from sjsrey/scipy13
64a4089 Serge Rey -BUG: sorting ijs for asymmetries
5539ef5 Sergio Rey -Merge pull request #1 from sjsrey/scipy13
8a86951 Serge Rey -BUG: fixes for scipy .0.9.0 to 0.13.0 induced errors
fe02796 Philip Stephens -tweaking travis to only run master commits
8c1fbe8 jlaura -Merge pull request #385 from sjsrey/docupdate
b71aedc Serge Rey -ENH: update date
4f237e4 Sergio Rey -Merge pull request #384 from sjsrey/moran
01da3be Serge Rey -ENH: Analytical p-values for Moran are two-tailed by default #337
918fe60 Philip Stephens -further travis tweaks
3920d73 Sergio Rey -Merge pull request #382 from sjsrey/st_docs
d90bc70 Serge Rey -DOC: updating refs for concordance algorithm
0db2790 Philip Stephens -tweaks to travis
063e057 Philip Stephens -upgrading scipy on travis
f90e742 Philip Stephens -Merge branch 'master' of https://github.com/pysal/pysal
edc9c07 Dani Arribas-Bel -Merge pull request #379 from sjsrey/b244
82479bb Serge Rey -BUG: fix for the comment https://github.com/pysal/pysal/issues/244#issuecomment-30055558
57ba485 jlaura -Update README.md
981ed31 Sergio Rey -Merge pull request #377 from darribas/master
3320c39 darribas -Changing cmap default in plot_choropleth so every type defaults to its own adecuate colormap
e063bee darribas -Fixing ignorance of argument cmap in base_choropleth_unique
1f10906 Dani Arribas-Bel -Merge pull request #375 from sjsrey/viz
94aa3e7 Dani Arribas-Bel -Merge pull request #376 from pedrovma/baltim_data
7568b0b pedrovma -Adding Baltimore example dataset for use with LM models.
5b23f89 Serge Rey -greys for classless map
d4eae1e Dani Arribas-Bel -Merge pull request #374 from sjsrey/viz
652440d Serge Rey -shrinking colorbar
c17bf67 Sergio Rey -Merge pull request #373 from darribas/master
a71c3cb darribas -Fixing minor conflict to merge darribas viz branch into darribas master
ec27e30 Dani Arribas-Bel -Merge pull request #372 from sjsrey/viz
8c03170 Serge Rey -option for resolution of output figs
3fc5bd4 Philip Stephens -Merge branch 'master' of https://github.com/pysal/pysal
2b5cb23 jlaura -Merge pull request #371 from sjsrey/geopandas
469afa7 Serge Rey -fix for #370
59cdafc jlaura -Merge pull request #369 from pedrovma/south_data
6b88e13 jlaura -Merge pull request #368 from schmidtc/issue367
40fe928 pedrovma -Adding south data to be used in ML doctests.
bcc257e schmidtc -fixes #367
87e057f jlaura -Merge pull request #366 from sjsrey/ml_lag
a64eb27 Serge Rey -queen contiguity for nat.shp
77add5c Sergio Rey -Merge pull request #365 from sjsrey/news
82464ef Serge Rey -narsc workshop
fd79424 Sergio Rey -Merge pull request #364 from sjsrey/news
bc7f25a Serge Rey -Merge branch 'master' of https://github.com/sjsrey/pysal
d669913 David Folch -Merge pull request #363 from sjsrey/maxp
22f9e36 Serge Rey -update example for bug fix #362
fac3b8a Serge Rey -- update tests for bug fix #362
44b4b06 Sergio Rey -Merge pull request #1 from sjsrey/maxp
1e6f1e5 Serge Rey -- fix for #362
68ab3e9 Sergio Rey -Merge pull request #361 from sjsrey/components
aa27c7e Serge Rey -doc test fix
7c08208 Serge Rey -putting Graph class back in for component checking
003b519 Serge Rey -alternative efficient component checker
2080e62 Serge Rey -- fixing doc
4fda442 Serge Rey -Merge branch 'components' of github.com:sjsrey/pysal into components
e9e613b Serge Rey -reverting back to old component check
83d855e Serge Rey -updating example
9defd86 jlaura -Merge pull request #360 from sjsrey/components
6f92335 Serge Rey -more efficient connectivity test
ebde3d1 Dani Arribas-Bel -Adding try/except for ogr since it's only used to reprojection methods but not on the plotting toolkit
5b170eb Sergio Rey -Merge pull request #356 from sjsrey/classification
c9dac41 Serge Rey -- update unit tests for reshaping jenks caspal
d9b06e2 Sergio Rey -Merge pull request #355 from sjsrey/cleanup/moran
dc589e8 darribas -Adding caution note when plotting points to the notebook. Ideally, we wanna be able to build a PathCollection out of the XYs, but for now we rely on plt.scatter, which gets the job done but has some problems.
2224b95 darribas -Including support for points in  base_choropleth_unique and base_choropleth_classless
ac2d08a darribas -Modifying example to show how to do choropleth mapping on points
270786e darribas -Adding support for choropleth plotting on point map objects (this may come from map_point_shp or from a simple matplotlib scatter
e56697c Sergio Rey -Merge pull request #357 from jlaura/newstyle_wed
4c67c2f Jay -errors in segmentation fixed
512cc76 Serge Rey -have Jenks-Caspal bins be a one dimensional array - to be consistent with all other classifiers
5254859 Philip Stephens -Merge branch 'master' of https://github.com/pysal/pysal
788ecab Serge -pruning
5b6b7b6 Serge -pruning
eb7e9a1 Jay -bug fix and all pointers filled for external edges
e47aa7a Jay -Node insertion, precursor to segmentation.
18a44d1 darribas -*Replacing shp by map_obj in medium layer functionality. *Bringing everything else in line with it *Adding example for line colorig and mixing overlaying of points.
bd041b1 darribas -Replacing shp_link by shp as input for medium and low-level layers. This brings much more flexibility and opens the door to plot formats other than shapefiles (e.g. geojson)
c74a361 darribas -Adding IP notebook to exemplify and keep track of development of mapping module
d23c882 darribas -Minor fixes
4b82a76 darribas -New commit message* Replacing map_poly_shp_lonlat for map_poly_shp in base_choropleth_classif/unique/classless * removed 'projection' from base_choropleth_classif/unique/classless * Allow base_choropleth_classif/unique/classless to plot multi-part polygons properly * changes streamlined to generic plot_choropleth * Added dependency on pandas for rapid reindexing (this is done externally on the method _expand_values to it is easy to drop the dependency when neccesary/time available)
7a0eaec darribas -Merge branch 'viz' of github.com:darribas/pysal into viz
5536424 darribas -Merge branch 'master' of github.com:darribas/pysal
e54ce16 Sergio Rey -Merge pull request #353 from darribas/master
819ee60 darribas -Adding immediate todo on head of the file
946772d darribas -Passing k to base_choropleth_classif from plot_choropleth. This should fix Issue #352
f299b45 darribas -Merge branch 'master' of https://github.com/pysal/pysal
f044f43 Jay -Added W generation
5f48446 jlaura -Merge pull request #348 from sjsrey/master
938a1ae Serge Rey -- adding nn stats to point based methods
a86a051 Philip Stephens -removing dependency tracking service, it was ruby only
1e24fde Philip Stephens -testing dependency tracking service
3aa410c Philip Stephens -Merge pull request #347 from pedrovma/w_silence_island
03990f6 pedrovma -Extending PR #310 (silence island warnings) to include w.transform.
160001a Sergio Rey -Merge pull request #346 from jlaura/newstyle_wed
44989f9 Sergio Rey -Merge pull request #345 from sjsrey/master
2fd99b8 Sergio Rey -Update README.md
bdcc6a8 Jay -NCSR with uniform distribution
769aa03 Jay -Fixed snapping
2561071 Jay -saved notebook and updated readme
3784783 Jay -ReadMe for Changes
019e16b Sergio Rey -Merge pull request #334 from jseabold/fix-build-example-dirs
1889885 Skipper Seabold -BLD: Correctly install package_data dirs.
ff4e355 Serge Rey -- assignments
c5b0cc0 Serge Rey -- reorg
a4f5642 Serge Rey -Merge branch 'network' of github.com:pysal/pysal into network
a95fec8 jlaura -Update README.md
1713145 Serge Rey -Merge branch 'master' of github.com:pysal/pysal into network
ede75c0 Sergio Rey -Merge pull request #329 from jlaura/wed_polar
7399cf2 Jay -Single-source shortest path notebook
9eb3fc1 Philip Stephens -Merge pull request #331 from sjsrey/docfix
ef9c82a Serge Rey -- sphinx doctest markup fix
1e2b6b3 jlaura -Update README.md
e19bffa jlaura -Merge pull request #330 from pysal/b328
6afc30b Serge Rey -- tutorial doc fixes for #328
c7239f1 Serge Rey -- b328 fix
d5fec13 Serge Rey -- fix for #328  making all p-values one-tailed
16b5e6e Jay -enumeration working with filaments
9507bbc jlaura -Update README.md
eef8eec Serge Rey -- stub for design of module
2707d60 Jay -Filaments in polar coordinates
b64f9e2 Serge Rey -Documentation for the development of network module
b90876e Serge Rey -Merge branch 'network' of github.com:pysal/pysal into network
ddad2a5 Philip Stephens -Merge pull request #326 from sjsrey/doc
6b0cd08 Serge Rey -- update release schedule
4cc7bca Jay -bisecting for single point working
79c77d9 jlaura -Merge pull request #324 from pysal/bf_id
9f4c7c9 Serge Rey -id is a keyword
72b1f85 Sergio Rey -Merge pull request #323 from jlaura/network
b5cdae0 Jay -fix to shp2graph
846dce2 Jay -Brute force for point outside network
d6c2ef4 Jay -Added length computation, alter global morans
b7e1465 Jay -Added new pointer to reader/writer
616d62d Jay -LISA and Global Morans on the network
16f84d6 Jay -Added explicit point external to network warning
34f4d8e Jay -update to the ipython notebook
e359e59 Jay -JSON and cPickle Bianry WED Reader/Writer
5373c82 Sergio Rey -Merge pull request #322 from jlaura/network
059d99c Jay -wed into class, tests added
aa5969d Sergio Rey -Merge pull request #320 from pastephens/master
a18000b Philip Stephens -version added info
5b8d490 Philip Stephens -typo
d31a22a Philip Stephens -stubs for cg docs
4dbdfe3 schmidtc -fixes #318
35a0317 Jay -Merge branch 'master' of https://github.com/pysal/pysal into network
77e8387 Jay -Merge branch 'geojson' of https://github.com/pysal/pysal into network
ad670c5 Sergio Rey -Merge pull request #317 from pastephens/master
628f27e Philip Stephens -merging local changes
f9dcb3e Philip Stephens -simplified install instructions
f2fab4c Serge Rey -- notebook on w construction for geojson
830826b Serge Rey -prototyping W from geojson
b10240d Serge Rey -created with "ogr2ogr -lco WRITE_BBOX=YES -f "GeoJSON" columbus.json columbus.shp"
d546926 Philip Stephens -merging with pull
d711011 darribas -Merge branch 'rod'
8bef782 darribas -Merge branch 'rod' of https://github.com/pysal/pysal into rod
03c1003 pedrovma -Merge pull request #315 from sjsrey/rod
950fe8b Serge Rey -Replacing ROD with regular dictionary
b1f009f Philip Stephens -Changes to release docs.
028364a Sergio Rey -Update THANKS.txt
94f5916 Sergio Rey -Update INSTALL.txt

v<1.6.0>, 2013-07-31

5fa9d09 darribas -silent_island_warning implemented for w_union
6526c62 Sergio Rey -Update README.md
ea826c1 darribas -silent_island_warning implemented for w_intersection
335540a darribas -silent_island_warning implemented for w_difference
0a156cb darribas -silent_island_warning implemented for w_symmetric_difference. Previous commit included support of silent_island_warning for WSP2W as well
34d20d7 darribas -silent_island_warning implemented for w_clip
499815d pedrovma -Test fixing...
8778f75 pedrovma -Test fixing...
a799a13 pedrovma -Test fixing...
6482d81 pedrovma -Test fixing...
2752b1b pedrovma -Test fixing...
0c0a5bf pedrovma -Test fixing...
bbf9dcb pedrovma -Test fixing...
05c34ff pedrovma -Test fixing...
8a3986a Serge Rey -- preparing for release, version updates
9106cfe pedrovma -Matching travis results reg. precision issues.
3cd0ce1 Serge Rey -- updating changelog
74dadd6 pedrovma -Bump.
c7774fb Serge Rey -- update THANKS.txt - testing travis for timing out
cd98057 Serge Rey -- travis fix for multiprocessing permission error
86702f8 Serge Rey -- start of changelog for 1.6
3ee686d pedrovma -Reloading to check new results from Travis.
2de1d21 Serge Rey -- docs
ef72edc Serge Rey -- update docs
0716581 Serge Rey -- deal with multiprocessing on travis
b508c88 Serge Rey -- excluding network from 1.6 release
ff13e31 pedrovma -Matching Travis results. Multiprocessing errors still an issue.
5b916ba pedrovma -Adding Chow test on lambda and updating dynamics of regime_err_sep and regime_lag_sep in combom models.
b6e687f darribas -Patch to include switch for island warning as proposed in #295. The method  is modified as well to include the switch
7ea5f35 pedrovma -Fixing defaults
62ca76b pedrovma -Updating documentation and checking if there are more than 2 regimes when regimes methods are used.
3212249 pedrovma -Fixing documentation on 'name_regimes'
a782d50 pedrovma -Updating tests for integration with pysal 1.6
14f9181 pedrovma -Merging spreg_1.6 with my pysal fork.
817f2c2 Serge Rey -- having build_lattice_shapefile also create the associated dbf file - useful for testing our contiguity builders against geoda since dbf is   required by the latter
41d59a4 Serge Rey -- adding diagonal option to kernel weights in user.py
506d808 Serge Rey -update when added
b2ec3d4 Serge Rey -- updating api docs
9d45496 Serge Rey -- example and doctests for spatial gini
95635bb Serge Rey -updating release docs
bd2f924 darribas -Fixing doctest of towsp method by including isinstance(wsp, ps.weights.weights.WSP)
76183d7 darribas -Fixing doctest of towsp method by including type(wsp)
0c54181 darribas -Adding  method in W that calls WSP class for convenience and elegance. Related to issue #226
f3b23e8 Philip Stephens -adding source build to travis-ci
60930e7 Philip Stephens -adding new url for downloads
9bf7f5b Philip Stephens -modified release docs.
f98d4a9 Philip Stephens -interim ci
aa19028 Philip Stephens -Adding docs about installing in develop mode.
674112f Philip Stephens -starting rewrite of install docs
af0d9b3 Philip Stephens -working on doc tickets
200e77e Serge Rey -handle ties in knnW in doctest
d0d2dd2 Serge Rey -resetting README for pysal/pysal
6afb6ac Serge Rey -- updating docs for new api in interation.py
4c5572f Serge Rey -- updating tests for new api
fabd16a Serge Rey -- refactored signatures to use numpy arrays rather than event class
6367947 Serge Rey -- refactor knox for large samples
5fad3b2 Serge Rey -- updating travis test
06894d8 Serge Rey -- updated README
8b06e63 Serge Rey -- so only i get email when i commit locally
efbb7ff Serge Rey -- removing google pysal-dev circle
9859bda Serge Rey -- turning off gmail circle
51f6d3e Serge Rey -- fixing
46b1084 Serge Rey --docos
4e2c27a Philip Stephens -missing if statement added
d1a83fd Serge Rey -- fixing docs
8275d76 Serge Rey -- fix precision
87ea5cc Philip Stephens -adding to authors and quick test fix for linux
1cfb67f Serge Rey -cant easily remove idVariable, reverting
5933d1e Serge Rey -removing idvariable from Distance - causes too many issues
05f2573 Philip Stephens -removing coverage tests
fcb8c6f Philip Stephens -Knox using KDTree.
2237173 Serge Rey -with tests against previous implementation removed
233e59a Serge Rey -speed comparison for change to query_pairs in kdtree
fb78ea9 Serge Rey -removing test file
4d04575 Philip Stephens -testing
357a184 Serge Rey -second great idea
1fafc2b Serge Rey -on a plane commit 1
fef6eae Philip Stephens -fix
86c17ac Serge Rey -- test file
a619f62 Philip Stephens -interim ci
1a9d881 Serge Rey -- knox test using kdtrees
7459c44 Serge Rey -Fixing reference to missing shapefile Fixing one rounding error induced test
5616b12 Serge Rey -refactored to avoid second loop in explicit queen or rook check
d3d2f71 Philip Stephens -Revert "Changed doctest path calls to account for modified shapefile."
da1d8a1 Philip Stephens -Changed doctest path calls to account for modified shapefile.
f591c99 Philip Stephens -progress on permutations of knox for larger datasets
8d31cde Serge Rey -Testing integration of spatialnet creation and reading into wed
11de6f3 Jay -Fixed wed_modular.py
077658a Serge Rey -adding new test case for wed extraction from a spatialnet shapefile
bbb10b4 Philip Stephens -saving state of development
44076b7 Serge Rey -- update doc test
6fdd94d Serge Rey -- moved regions_from_graph into wed_modular - documented all functions and cleaned up
5bd27c3 Serge Rey -- wrapping in functions
3ad162f Serge Rey -- working version of wed_modular module - starting point for clean up
2380f15 Philip Stephens -Copy of sphinx install docs. Closes #251
5687700 Philip Stephens -tweaks to install instructions
9ffd432 Serge Rey -- updating for switch from svn to git
fdaf521 Philip Stephens -Fixing 250
5ba4fdf Serge Rey -Fixes #249 Closes #249
d89944d Pedro -Adding docs for each regimes estimator
f03bb63 Serge Rey -- updating docs for spatial regimes in spreg
a49d0f7 Philip Stephens -Adding info to setup script.
1f27605 Philip Stephens -mainly docs
04f8a31 Philip Stephens -Adding test coverage with nose, data collected and presented on coveralls.io
6db978b Philip Stephens -last changes
137e088 Philip Stephens -added bigdata parameter
7ca81c2 Philip Stephens -got Knox stat working in alt form
24c1fcc Philip Stephens -workign on refactoring the space-time matrices for the Knox test [ci-skip]
28013f0 Serge Rey -- enumeration of cw edges for faces
baa8f60 Serge Rey -- hole is now included and enumeration of links (cw) around nodes works for all nodes. - isolated nodes also handled in enumeration of links around nodes.
33741c8 Serge Rey -- filaments inserted and pointers updated - have to add hole polygon and isolated nodes, but almost there!!!!!!!!!
416d3db Serge Rey -- pointers updated for edges of connected components
c34e274 Serge Rey -- convex/between edge test as start of testing for insertion of multiple   internal filaments in one region.
78d96b1 Serge Rey -- filament insertion and pointer updates
ced2c5b Serge Rey -- filament insertion (inc)
ba4263f Jay -Logic roughed in for filaments [ci skip]
cf3b0bc Jay -updated wed ipynb [ci skip]
33ce81e Serge Rey -- refactoring of wed construction (incomplete)
0fc16fc Jay -modular WED Pulled Apart 2 funcs in 1 cell
bf73b90 Jay -modular WED
3163377 Serge Rey -- new modular wed construction
e50b31d Jay -added test_wed additions to test_wed2
1cbc941 Serge Rey -- isolated nodes handled
d28b97f Serge Rey -- isolated filament handled
6188fd5 Serge Rey -- hole component handled
a96040b Serge Rey -- getting connected components (current 14,15,16  and 25,26,27 are not   included)
3aa31a5 Jay -Added boolean arg to include or exclude holes [ci skip]
d07876d Jay -Filament identification [ci skip]
0139ea5 Philip Stephens -Slight speed improvement getting rid of append calls in reading shapefile and building x,y lists.
43010b5 Serge Rey -- fixed logic problem with enum for v1, starting on components
8737918 Pedro -Adding more meaningful error message to inverse distance weights
01f52f6 Serge Rey -- replacing code that got deleted previously
7c4c6e1 Philip Stephens -Replacing deleted files.
a8da725 Philip Stephens -added date support to spacetimeevents class, a date column to example dbf.
90c4730 Philip Stephens -logic works, numeric test still failing
b8e43e1 Philip Stephens -saving progress on interaction
81f2408 Serge Rey -- handling external end-node-filament
7de6253 Serge Rey -- adding end node filament handling - edge enumeration around node working
f542b9a Serge -- adding end node filament handling - edge enumeration around node working
d7e3a57 Philip Stephens -[ci skip] disabling nose-progressive so travis output looks best
fe03013 Dani Arribas-Bel -Adding set of diversity indices to inequality module under _indices.py for now. Still lacks doctests, unittests, and a few others will be added
951b6f5 Dani Arribas-Bel -Adding try/except to the import of Basemap to allow the use of the module when there is no Basemap installation
89003eb Serge Rey -- adding wed for eberly example
665ef22 Serge Rey -- fixed 7,2 failure
71fc9ad Serge Rey -start of adding gini and other inequality measures
f7b7bcc Phil Stephens -Adding nose-progressive plugin to test suite. Devs can run test suite with 'make test'.
f5db7bf Serge Rey -- updating copyright
07574b5 Serge Rey -- docs
478d2cb Philip Stephens -Adding requirement. Removing redundancy.
916a6ca Serge Rey -- more island check updates
edd9960 Serge Rey -- more island check doctest changes
ad1a91c Serge Rey -- updating doctests for island check
ce77772 Serge Rey -- fixing doctests to incorporate new island warning
554a30b Serge Rey -- silencing floating point warning
4f76862 Serge Rey -- moving default contiguity builder back to binning from rtree
b99665b Jay -Eberly
d911344 Jay -mp removed, passing nosetests on my machine serial
f005675 Serge Rey -improved binning algorithm for contiguity builder
4a69557 Serge Rey -- double checking threshold in Distance Band - new example to show functionality
7256f13 Serge Rey -- fix handling of idVariable for knnW
31bb36e Jay -bug fixes [ci skip]
a2d2dd4 Jay -WEberly - WED Building [ci skip]
3abc55e Serge Rey -- fixing doctests for new check/reporting for islands
756ac05 Serge Rey -- adding warning if islands exist upon W instantiation
db097a6 Jay -Weberly, bug fix, c and cc link remaining
d5cc6f9 Jay -All but start / end working
033963d Jay -Integration to WEberly error fixed [ci skip]
22b931a Serge Rey -- removing main for doc tests which can be run from nosetests. - updating testing docs
bf753e9 Jay -Integration to WEberly started [ci skip]
6506e07 Serge Rey -- typo
aede375 Serge Rey -- replacing double quotes around multi word ids with strings joined with   underscores
cf029e8 Serge Rey -- changes to wrap string ids in gwt writer - see https://github.com/pysal/pysal/issues/244#issuecomment-16707353
626ac08 Serge Rey -- adding shapefile and variable name to gwt objects created in user space
3c84bb0 Jay -Working version 4.19 [ci skip]
7d77da9 darribas -Include warning in sp_att when rho is outside (-1, 1), ammends #243 although the true problem (pearsonr in diagnostics_tsls) will still raise an error
3719d21 Jay -working WED [ci skip]
b4ce294 Serge Rey -checking edges
f4bb412 Jay -excessive print statements removed. ci skip
9f7dee6 Jay -SUCCESS! ci skip
9077615 Phil Stephens -Note, [ci skip] anywhere in your commit message causes Travis to NOT build a test run.
cb072c4 Jay -getting there
d3b36bc Serge Rey -correcting typo user told me about
19ea051 Jay -trivial working
b9ea577 Jay -eberly cycles - edge issue still
d5153e3 Serge Rey -more refinement of wed from plannar graph
edff44b Philip Stephens -adding git ignore file
8093f21 Serge Rey -wed from minimum cycle basis
b5bcead Serge Rey -handle filaments
9a8927a Serge Rey -face extraction using horton algorithm
10d66c1 Serge Rey -updating readme formatting
59f3750 schmidtc -adding Universal newline support to csvReader, fixes #235
09e813f Serge Rey -- updating notifications
f8b0a26 Serge Rey -- fixing Distance.py and testing travis message
d1ec0f2 Phil Stephens -quieting pip output and fix one doctest
927e799 Phil Stephens -adding networkx, tweaks to travis config
5971bb1 Serge Rey -neighbors from wed
28f0e55 Serge Rey -adding robust segment intersection tests
3bcac73 Serge Rey -adding doubly connected edge list to network module
86f0fea darribas -Adding methods to read line and point shapefiles and improving the method to append different collections to one axes. Still in progress
b61cb55 Serge Rey -- fixing introduced bug in knnW_arc
801e78d Serge Rey -Handle point sets with large percentage of duplicate points
dbafbc4 serge -update pointer to github
427a620 Serge Rey -dealing with filaments
23216ef Serge Rey -Fixed cw enumeration of links incident to a node
0a51a53 Serge Rey -- readme
5f4cab4 sjsrey -cw enumeration not working for all nodes
f2e65d3 Serge Rey -- cw traversal of edges incident with a node
90d150c sjsrey -- version debug for travis
24598a8 sjsrey -- noting move to org
9fb8a17 sjsrey -- fixing tutorial tests
5a14f9e serge -- cleaning up weights tests
6265b3b Serge Rey -- fixing doc tests
7e8c4fe Serge Rey -- testing after move to org
37fc8d4 Serge Rey -- testing post commit emails
bed7f6e Phil Stephens -removed files
eab2895 Phil Stephens -removed virginia_queen files
bcef010 Serge Rey -- adding diagonal argument to Kernel weights - adding doctest evaluation to Distance.py
02d27e9 Phil Stephens -adding libgeos-dev
1126d71 Phil Stephens -pipe build output to null
37dbb35 Phil Stephens -adding -y flag to pip uninstall
06d56e9 Phil Stephens -adding libgeos_c install, pysal from pip
4c53277 Phil Stephens -trying to quiet output, using Makefile
74448e8 Phil Stephens -find setup.py
4634fb1 Phil Stephens -test install in venv and build
5d58723 Phil Stephens -working out travis-ci doctest configuration
5e905d3 Phil Stephens -adding numpydoc
33a5298 Phil Stephens -tweaks travis config
5c85f50 Phil Stephens -tweaking service configs
4ed1201 Josh Kalderimis -use the correct syntax for sysytem_site_packages
954b6d2 Phil Stephens -stop!
311eca8 Phil Stephens -ssp=true
c601bca Phil Stephens -numpy first
54b0afe Phil Stephens -ok, so travis is serious about not using system site packages.
2b912cc Phil Stephens -doh
28994df Phil Stephens -better yaml
ce1d89e Phil Stephens -testing
b535d3e Phil Stephens -testing
440a772 Phil Stephens -tweaking pip requirements file
34a74e2 Phil Stephens -tweaking travis file
33b13aa Serge Rey -- new links
8e09d7b Serge Rey -- setting up travis
d33001e Sergio Rey -Update CHANGELOG.txt
9d4de66 Serge Rey -- added authors
ab672c9 Serge Rey -- modified knnW to speed up dict construction
4edd2ab Serge Rey -- update cr
39e6564 Phil Stephens -syncing install instructions with docs
9e98db9 Phil Stephens -adding website favicon; chrome does not empty cache properly!!

 * migration to github from svn
   svn2git http://pysal.googlecode.com/svn --authors ~/Dropbox/pysal/src/pysal/authors.txt --verbose

v<1.5.0>, 2013-01-31

2013-01-29 20:36  phil.stphns

	* doc/source/users/installation.txt: updating and simplifying user
	  install instructions.

2013-01-18 16:17  sjsrey

	* Adding regime classes for all GM methods and OLS available in
	  pysal.spreg, i.e. OLS, TSLS, spatial lag models, spatial error models
	  and SARAR models. All tests and heteroskedasticity
	  corrections/estimators currently available in pysal.spreg apply to
	  regime models (e.g. White, HAC and KP-HET). With the regimes, it is
	  possible to estimate models that have:
	  -- Common or regime-specific error variance;
	  -- Common or regime-specific coefficients for all variables or for a
	  selection of variables;
	  -- Common or regime-specific constant term;
	  - Various refactoring to streamline code base and improve long term
	    maintainability
	    - Contributions from Luc Anselin, Pedro Amaral, Daniel Arribas-Bel
	      and David Folch

2013-01-18 14:08  schmidtc

	* pysal/common.py: implemented deepcopy for ROD, see #237

2013-01-08 12:28  dreamessence

	* pysal/contrib/spatialnet/__init__.py: Adding __init__.py to make it importable

2012-12-31 22:53  schmidtc

	* pysal/core/IOHandlers/gwt.py: adding kwt support, see #232

2012-12-21 20:53  sjsrey@gmail.com

	* pysal/__init__.py, pysal/cg/rtree.py,
	  pysal/contrib/weights_viewer/weights_viewer.py,
	  pysal/weights/weights.py: - turning off randomization in rtree

2012-12-06 16:34  dfolch

	* pysal/contrib/shapely_ext.py: adding unary_union() to shapely
	  contrib; note this only works with shapely version 1.2.16 or higher


2012-11-29 13:39  dreamessence 

	* pysal/contrib/viz/mapping.py: Added option in setup_ax to pass
	  pre-existing axes object to append.  It is optional and it enables,
	  for instance, to embed several different maps in one single figure

2012-11-20 00:23  dfolch

	* pysal/contrib/shapely_ext.py: adding shapely's cascaded_union
	  function to contrib

2012-11-12 18:08  dreamessence

	* pysal/contrib/viz/mapping.py: -Adding transCRS method to convert
	  points from one prj to another arbitrary one -Adding map_poly_shp to
	  be able to plot shapefiles in arbitrary projections, not needing to
	  be in lonlat and not depending on Basemap

2012-11-09 15:40  sjsrey@gmail.com

	* pysal/weights/weights.py:
	  - distinguish between intrinsic symmetry and general symmetry
	
2012-11-02 17:48  schmidtc

	* pysal/weights/user.py, pysal/weights/util.py: Adding Minkowski
	  p-norm to min_threshold_dist_from_shapefile, see issue #221

2012-10-19 22:35  sjsrey@gmail.com

	* pysal/weights/weights.py:
	  explicitly prohibit chaining of transformations - all
	  transformations are only applied to the original weights at
	  instantiation

2012-10-19 17:38  sjsrey@gmail.com

	* pysal/spatial_dynamics/markov.py:
	  - fixing bug in permutation matrix to reorder kronecker product in
	    the join test

2012-10-17 17:55  sjsrey@gmail.com

	* pysal/weights/util.py:
	  -
	  higher order contiguity for WSP objects

2012-10-17 15:43  sjsrey@gmail.com

	* pysal/weights/user.py:
	  -
	  id_order attribute was always NONE for wsp created from
	  
	  queen/rook_from_shapefile with sparse=True

2012-10-16 19:25  schmidtc

	* pysal/weights/util.py: improving memory usage of
	  get_points_array_from_shapefile, no need to read entire shapefile
	  into memory.

2012-10-15 00:44  dreamessence

	* pysal/contrib/viz/mapping.py: First attempt to refactor Serge's code
	  for choropleth mapping.  It now offers a more general and flexible
	  architecture.  Still lots of work and extensions left.  The module
	  is explained in a notebook available as a gist at
	  https://gist.github.com/3890284 and viewable at
	  http://nbviewer.ipython.org/3890284/

2012-10-12 18:34  schmidtc

	* pysal/contrib/spatialnet/spatialnet.py: modified SpatialNetwork.snap
	  to calculate and return the snapped point

2012-10-12 17:05  dfolch

	* pysal/contrib/viz/mapping.py: made edits to unique_values_map to
	  allow for unlimited number of categories; I commented out the
	  previous code so these changes can easily be rolled back if it
	  breaks something somewhere else

2012-10-12 15:03  schmidtc

	* pysal/cg/segmentLocator.py: Fixing issue with segmentLocator, when
	  query point is extreamly far from the grid boundary, overflow errors
	  were causing the KDTree to not return any results.  Changed both
	  KDtree's to use Float64 and share the same data.  Previously,
	  cKDTree was using float64 and KDtree was using int32.

2012-10-11 08:12  dreamessence

	* pysal/contrib/viz/__init__.py: Adding __init__.py to viz module to
	  make it importable

2012-08-31 02:57  phil.stphns

	* pysal/spreg/tests/test_diagnostics.py,
	  pysal/spreg/tests/test_diagnostics_sp.py,
	  pysal/spreg/tests/test_diagnostics_tsls.py,
	  pysal/spreg/tests/test_error_sp.py,
	  pysal/spreg/tests/test_error_sp_het.py,
	  pysal/spreg/tests/test_error_sp_het_sparse.py,
	  pysal/spreg/tests/test_error_sp_hom.py,
	  pysal/spreg/tests/test_error_sp_hom_sparse.py,
	  pysal/spreg/tests/test_error_sp_sparse.py,
	  pysal/spreg/tests/test_ols.py,
	  pysal/spreg/tests/test_ols_sparse.py,
	  pysal/spreg/tests/test_probit.py,
	  pysal/spreg/tests/test_twosls.py,
	  pysal/spreg/tests/test_twosls_sp.py,
	  pysal/spreg/tests/test_twosls_sp_sparse.py,
	  pysal/spreg/tests/test_twosls_sparse.py:
	  - autopep8 -iv spreg/tests/*.py - nosetests pysal - no fixes needed

2012-08-31 01:16  phil.stphns

	* pysal/spreg/diagnostics.py,
	  pysal/spreg/diagnostics_sp.py,
	  pysal/spreg/diagnostics_tsls.py,
	  pysal/spreg/error_sp.py,
	  pysal/spreg/error_sp_het.py,
	  pysal/spreg/error_sp_hom.py,
	  pysal/spreg/ols.py,
	  pysal/spreg/probit.py,
	  pysal/spreg/robust.py,
	  pysal/spreg/summary_output.py,
	  pysal/spreg/twosls.py,
	  pysal/spreg/twosls_sp.py,
	  pysal/spreg/user_output.py,
	  pysal/spreg/utils.py:
	  -
	  autopep8 -iv spreg/*.py - fixed autopep8-introduced doctest failures
	  - fixed lingering scientific notation test failures

2012-08-31 00:26  phil.stphns

	* pysal/esda/gamma.py,
	  pysal/esda/join_counts.py,
	  pysal/esda/mapclassify.py,
	  pysal/esda/mixture_smoothing.py,
	  pysal/esda/moran.py,
	  pysal/esda/smoothing.py:
	  -
	  autopep8 fixes - make sure to run unit and doc tests before
	  committing - one autofix breaks long lines, and thus breaks some
	  doctests; must be
	  
	  fixed manually

2012-08-31 00:10  phil.stphns

	* pysal/esda/getisord.py:
	  -
	  using autopep8 module - call: autopep8 -vi getisord.py

2012-08-30 23:18  phil.stphns

	* pysal/esda/geary.py:
	  -
	  pep8 clear - removed wildcard import

2012-08-26 22:53  phil.stphns

	* pysal/spatial_dynamics/directional.py,
	  pysal/spatial_dynamics/ergodic.py,
	  pysal/spatial_dynamics/interaction.py,
	  pysal/spatial_dynamics/markov.py,
	  pysal/spatial_dynamics/rank.py,
	  pysal/spatial_dynamics/util.py:
	  -pep8 and pylint fixes -clean wildcard imports

2012-08-26 21:03  phil.stphns

	* pysal/region/maxp.py,
	  pysal/region/randomregion.py:
	  -
	  cleaning up imports

2012-08-26 18:16  phil.stphns

	* pysal/region/maxp.py:
	  -
	  style fixes with pep8 - cmd line call: pep8 --show-source
	  --ignore=E128,E302,E501,E502,W293,W291
	  
	  region/maxp.py

2012-08-26 17:47  phil.stphns

	* pysal/common.py,
	  pysal/examples/README.txt,
	  pysal/region/components.py,
	  pysal/region/randomregion.py:
	  -
	  using pep8 module

2012-08-24 20:47  schmidtc

	* pysal/network,
	  pysal/network/__init__.py: adding network module

2012-08-21 22:53  phil.stphns

	* doc/source/_templates/ganalytics_layout.html:
	  -
	  updating analytics tracker

2012-08-17 17:11  sjsrey@gmail.com

	* pysal/contrib/spatialnet/util.py:
	  -
	  more utility functions for pysal
	  -
	  networkx interop

2012-08-16 23:44  phil.stphns

	* setup.py:
	  -
	  tweak for build names

2012-08-12 13:15  dreamessence

	* doc/source/index.txt:
	  Adding announcement links to landing page

2012-08-11 17:38  sjsrey

	* LICENSE.txt:
	  -
	  update

2012-08-09 17:19  phil.stphns

	* doc/source/developers/pep/pep-0008.txt:
	  updating
	  spatial
	  db
	  pep

2012-08-08 17:22  schmidtc

	* pysal/weights/Distance.py:
	  Fixing bug in Kernel weights that causes erroneous results when
	  using ArcDistances.  See issue #218.

2012-08-04 21:14  sjsrey

	* doc/source/developers/docs/index.txt:
	  -
	  fixed
	  links

2012-08-04 21:03  sjsrey

	* doc/source/developers/docs/index.txt:
	  -
	  hints
	  on
	  editing
	  docs
	  

2012-08-04 20:14  phil.stphns

	* doc/source/developers/pep/pep-0011.txt:
	  note
	  about
	  travis-ci
	  and
	  github

2012-08-04 16:24  sjsrey

	* doc/source/developers/pep/pep-0011.txt:
	  PEP-0011
	  

2012-08-04 16:22  sjsrey

	* doc/source/developers/pep/index.txt:
	  -
	  PEP 0011 Move from Google Code to Github

2012-08-04 04:42  sjsrey

	* doc/source/index.txt:
	  - broken link

2012-08-04 04:35  sjsrey

	* doc/source/index.txt:
	  - news updates

2012-08-04 04:24  sjsrey

	* doc/source/index.txt:
	  - reorg

2012-08-02 02:32  sjsrey

	* pysal/examples/__init__.py:
	  -
	  moving back to r1049 but leaving r1310 in history for ideas on
	  moving forward - we need to distinguish between using examples in
	  the doctests (which the users see) and for the developers since we
	  are no longer distributing examples with the source

2012-08-02 01:49  sjsrey

	* pysal/examples/__init__.py:
	  -
	  correct conditional this time (i hope)

2012-08-02 01:36  sjsrey

	* pysal/examples/__init__.py:
	  -
	  compromise
	  -
	  returns pth rather than None if file does not exist

2012-08-02 00:58  sjsrey

	* pysal/examples/__init__.py:
	  -
	  link to examples download

2012-08-02 00:42  sjsrey

	* pysal/examples/__init__.py:
	  -
	  explicit check if examples are actually present





v<1.4.0>, 2012-07-31

2013-01-31 


2012-07-31 21:30  sjsrey@gmail.com

	* pysal/spatial_dynamics/ergodic.py,
	  pysal/spatial_dynamics/rank.py:
	  - docs/example

2012-07-31 20:47  sjsrey@gmail.com

	* pysal/spreg/tests/test_error_sp_hom.py:
	  - rounding/precision issue

2012-07-31 20:27  sjsrey@gmail.com

	* pysal/spatial_dynamics/directional.py,
	  pysal/spatial_dynamics/tests/test_directional.py:
	  - fixing pvalue bug

2012-07-31 20:24  sjsrey@gmail.com

	* doc/source/users/tutorials/dynamics.txt:
	  - fixed rounding problem

2012-07-31 19:58  sjsrey@gmail.com

	* doc/source/index.txt,
	  doc/source/users/tutorials/autocorrelation.txt,
	  doc/source/users/tutorials/dynamics.txt,
	  doc/source/users/tutorials/econometrics.txt,
	  doc/source/users/tutorials/fileio.txt,
	  doc/source/users/tutorials/index.txt,
	  doc/source/users/tutorials/intro.txt,
	  doc/source/users/tutorials/region.txt,
	  doc/source/users/tutorials/smoothing.txt,
	  doc/source/users/tutorials/weights.txt:
	  - adding links to API for more details

2012-07-31 19:05  sjsrey@gmail.com

	* pysal/spatial_dynamics/directional.py:
	  - consistency on pvalues for randomization

2012-07-31 19:02  sjsrey@gmail.com

	* pysal/weights/Distance.py:
	  - docs

2012-07-31 18:58  sjsrey@gmail.com

	* doc/source/users/tutorials/dynamics.txt:
	  - seed issue 

2012-07-31 18:36  sjsrey@gmail.com

	* doc/source/users/tutorials/autocorrelation.txt:
	  - closing issue 214

2012-07-31 18:19  sjsrey@gmail.com

	* doc/source/users/tutorials/autocorrelation.txt:
	  - fixing random.seed issues in doctests

2012-07-31 17:31  schmidtc

	* pysal/cg/shapes.py,
	  pysal/cg/tests/test_shapes.py:
	  Fixing small bugs with VerticleLines and testing

2012-07-31 16:26  sjsrey@gmail.com

	* doc/source/developers/guidelines.txt,
	  doc/source/users/installation.txt:
	  - updating docs 



2012-07-26 15:24  schmidtc

	* pysal/core/FileIO.py,
	  pysal/core/Tables.py:
	 Fixing issue #190

2012-07-24 16:32  schmidtc

	* pysal/cg/sphere.py:
	Allowing linear2arcdist function to maintin 'inf', this allows compatability with Scipy's KDTree and addresses issue 208.  

2012-07-24 16:07  schmidtc

	* pysal/cg/locators.py,
	  pysal/core/FileIO.py,
	  pysal/core/Tables.py:
	  Addressing issue 212, renaming nested and private classes to begin with an underscore.  By default sphinx does not try to document private object, which avoids what appears to be a a bug in Sphinx.

2012-07-17 22:06  sjsrey@gmail.com

	* pysal/spreg/probit.py: pedro doc fixes

2012-07-17 15:07  schmidtc

	* pysal/cg/segmentLocator.py,
	  pysal/cg/tests/test_segmentLocator.py: Cleaned up fix for Issue 211

2012-07-13 22:50  sjsrey@gmail.com

	* doc/source/users/tutorials/autocorrelation.txt: fixing sphinx weirdness in footnotes 

2012-07-13 22:37  sjsrey@gmail.com

	* doc/source/users/tutorials/autocorrelation.txt: update for new default parameter values

2012-07-13 22:13  sjsrey@gmail.com

	* pysal/esda/geary.py,
	  pysal/esda/tests/test_geary.py: consistency on transformation and permutation args

2012-07-13 19:59  sjsrey@gmail.com

	* doc/source/users/tutorials/dynamics.txt,
	  pysal/__init__.py,
	  pysal/spatial_dynamics/rank.py: - update user tutorial and __init__

2012-07-13 19:33  sjsrey@gmail.com

	* pysal/spatial_dynamics/rank.py,
	  pysal/spatial_dynamics/tests/test_rank.py: - O(n log n) algorithm for spatial tau (old one was O(n^2)) - closing ticket http://code.google.com/p/pysal/issues/detail?id=83

2012-07-13 17:57  schmidtc

	* pysal/core/IOHandlers/pyDbfIO.py,
	  pysal/core/IOHandlers/tests/test_pyDbfIO.py: Adding better support for writing Null values to DBF.  See issue #193

2012-07-13 15:55  schmidtc

	* pysal/core/util/shapefile.py,
	  pysal/core/util/tests/test_shapefile.py: Cleaning up support for ZM points, polylines and polygons in the shapefile reader. Added unit tests for same.

2012-07-13 15:42  sjsrey@gmail.com

	* doc/source/library/esda/gamma.txt: - update version info 

2012-07-13 15:37  sjsrey@gmail.com

	* doc/source/library/esda/gamma.txt,
	  doc/source/library/esda/index.txt: - adding gamma to api docs

2012-07-13 00:21  sjsrey@gmail.com

	* pysal/esda/gamma.py: optimizations 

2012-07-12 21:28  schmidtc

	* pysal/core/IOHandlers/pyDbfIO.py: Disabling mising value warning for DBF files.  See issue #185

2012-07-12 21:07  schmidtc

	* pysal/cg/segmentLocator.py,
	  pysal/cg/shapes.py,
	  pysal/cg/tests/test_segmentLocator.py,
	  pysal/contrib/spatialnet/spatialnet.py: Adding unittests for segmentLocator (including one that fails see #211). Added VerticalLine class to represent verticle LineSegments. Updated __all__ in segmentLocator. Minor comment formatting in spatialnet.

2012-07-12 19:41  lanselin@gmail.com

	* doc/source/users/tutorials/autocorrelation.txt: tutorial for gamma index

2012-07-12 19:40  lanselin@gmail.com

	* pysal/esda/gamma.py,
	  pysal/esda/tests/test_gamma.py: gamma with generic function

2012-07-12 14:17  sjsrey@gmail.com

	* pysal/__init__.py: - gamma index added

2012-07-12 03:14  lanselin@gmail.com

	* pysal/esda/tests/test_gamma.py: tests for gamma

2012-07-12 03:13  lanselin@gmail.com

	* pysal/esda/gamma.py: gamma index of spatial autocorrelation

2012-07-12 03:11  lanselin@gmail.com

	* pysal/esda/__init__.py: gamma index 

2012-07-11 21:32  lanselin@gmail.com

	* pysal/esda/join_counts.py,
	  pysal/esda/tests/test_join_counts.py: join counts without analytical results, new permutation 

2012-07-11 21:32  lanselin@gmail.com

	* doc/source/users/tutorials/autocorrelation.txt: updated docs for join counts

2012-07-10 21:13  lanselin@gmail.com

	* doc/source/users/tutorials/autocorrelation.txt: docs for join count in autocorrelation

2012-07-10 21:12  lanselin@gmail.com

	* pysal/esda/join_counts.py,
	  pysal/esda/tests/test_join_counts.py: additional test in join counts, docs added

2012-07-10 19:24  lanselin@gmail.com

	* pysal/esda/join_counts.py,
	  pysal/esda/tests/test_join_counts.py: join counts with permutations for BB, updated tests to include permutations

2012-07-09 04:22  sjsrey

	* pysal/weights/weights.py:
	  - fixing bug luc identified with regard to mean_neighbor property.  wrong key name was used in cache dictionary.  

2012-07-07 17:00  sjsrey

	* pysal/__init__.py: update for spreg and contrib inclusion


2012-07-07 16:51  sjsrey

	* pysal/spatial_dynamics/markov.py: - updating doc strings

2012-07-07 16:17  sjsrey

	* pysal/spreg/probit.py:
	  - fixing doc string and refs 

2012-07-06 21:58  dfolch

	* doc/source/library/spreg/probit.txt: txt file to include probit in the HTML docs

2012-07-06 21:11  dfolch

	* pysal/spreg/tests/test_ols_sparse.py: fixing unittest error; still no solution to scientific notation formatting in doctests

2012-07-06 20:24  dfolch

	* pysal/spreg/__init__.py,
	  pysal/spreg/diagnostics.py,
	  pysal/spreg/diagnostics_sp.py,
	  pysal/spreg/diagnostics_tsls.py,
	  pysal/spreg/error_sp.py,
	  pysal/spreg/error_sp_het.py,
	  pysal/spreg/error_sp_hom.py,
	  pysal/spreg/ols.py,
	  pysal/spreg/probit.py,
	  pysal/spreg/robust.py,
	  pysal/spreg/summary_output.py,
	  pysal/spreg/tests/test_diagnostics.py,
	  pysal/spreg/tests/test_diagnostics_sp.py,
	  pysal/spreg/tests/test_diagnostics_tsls.py,
	  pysal/spreg/tests/test_error_sp.py,
	  pysal/spreg/tests/test_error_sp_het.py,
	  pysal/spreg/tests/test_error_sp_het_sparse.py,
	  pysal/spreg/tests/test_error_sp_hom.py,
	  pysal/spreg/tests/test_error_sp_hom_sparse.py,
	  pysal/spreg/tests/test_error_sp_sparse.py,
	  pysal/spreg/tests/test_ols.py,
	  pysal/spreg/tests/test_ols_sparse.py,
	  pysal/spreg/tests/test_probit.py,
	  pysal/spreg/tests/test_twosls.py,
	  pysal/spreg/tests/test_twosls_sp.py,
	  pysal/spreg/tests/test_twosls_sp_sparse.py,
	  pysal/spreg/tests/test_twosls_sparse.py,
	  pysal/spreg/twosls.py,
	  pysal/spreg/twosls_sp.py,
	  pysal/spreg/user_output.py,
	  pysal/spreg/utils.py: -Adding classic probit regression class -Adding spatial diagnostics for probit -Allowing x parameter to be either a numpy array or scipy sparse matrix in all regression classes -Adding additional unit tests -Various refactoring to streamline code base and improve long term maintainability -Contributions from Luc Anselin, Pedro Amaral, Daniel Arribas-Bel, David Folch and Nicholas Malizia

2012-07-03 18:59  sjsrey

	* pysal/spatial_dynamics/markov.py,
	  pysal/spatial_dynamics/tests/test_markov.py: - refactor significant move_types for clarity and fixing a logic bug


2012-06-20 04:50  sjsrey@gmail.com

	* doc/source/developers/docs/index.txt:
	  - added section for how to write a tutorial for new modules 
2012-06-20 02:45  sjsrey

	* doc/source/developers/docs/index.txt:
	  - updating doc building instructions

2012-06-06 18:58  phil.stphns

	* .build-osx10.6-py26.sh,
	  .build-osx10.6-py27.sh:
	  - local modifications for Frameworks builds

2012-06-05 20:56  phil.stphns

	* .build-osx10.6-py26.sh,
	  .build-osx10.6-py27.sh,
	  .build-osx10.7-py27.sh, .runTests.sh:
	  - adding experimental build and test scripts.

2012-06-05 16:43  schmidtc

	* pysal/cg/segmentLocator.py,
	  pysal/cg/shapes.py,
	  pysal/contrib/spatialnet/spatialnet.py:
	  initial snap function for spatialnet

2012-06-05 16:38  schmidtc

	* pysal/core/IOHandlers/pyShpIO.py,
	  pysal/core/util/shapefile.py,
	  pysal/core/util/tests/test_shapefile.py: Adding PolygonZ support to Shapefile IO

2012-05-24 21:57  sjsrey

	* pysal/esda/mapclassify.py: - truncate option for fisher_jenks sampling

2012-05-15 20:08  schmidtc

	* pysal/cg/segmentLocator.py,
	  pysal/cg/shapes.py: Added query to SegmentLocator

2012-05-11 22:17  sjsrey

	* pysal/esda/mapclassify.py: - added Fisher_Jenks_Sampled

2012-05-11 00:45  mhwang4

	* pysal/contrib/network/distances.csv,
	  pysal/contrib/network/simulator.py,
	  pysal/contrib/network/test_lincs.py,
	  pysal/contrib/network/test_weights.py,
	  pysal/contrib/network/weights.py: adding test code for distance-file-based weight generator; updates on simulator 

2012-05-10 22:37  mhwang4

	* pysal/contrib/network/klincs.py,
	  pysal/contrib/network/lincs.py,
	  pysal/contrib/network/test_klincs.py,
	  pysal/contrib/network/test_lincs.py: adding test code for network-constrained lisa

2012-05-10 21:11  mhwang4

	* pysal/contrib/network/crimes.dbf,
	  pysal/contrib/network/crimes.shp,
	  pysal/contrib/network/crimes.shx,
	  pysal/contrib/network/test_klincs.py: test code for local K function

2012-05-08 18:05  mhwang4

	* pysal/contrib/network/streets.dbf,
	  pysal/contrib/network/streets.shp,
	  pysal/contrib/network/streets.shx,
	  pysal/contrib/network/test_network.py: adding a test data set

2012-05-08 16:34  schmidtc

	* pysal/cg/segmentLocator.py,
	  pysal/cg/shapes.py,
	  pysal/core/FileIO.py: Adding start of segmentLocator, adding minimal slicing support to FileIO


2012-05-03 17:03  schmidtc

	* pysal/cg/shapes.py,
	  pysal/cg/tests/test_shapes.py: Adding solve for x support to Line. Cleaning up LineSegment's Line method.

2012-04-20 17:48  schmidtc

	* pysal/cg/shapes.py: adding arclen method to Chain object.

2012-04-19 16:37  dfolch

	* pysal/weights/Distance.py: reducing number of distance queries in Kernel from n^2 to n

2012-04-17 21:20  schmidtc

	* pysal/contrib/spatialnet/spatialnet.py: adding distance

2012-04-17 19:46  schmidtc

	* pysal/contrib/spatialnet/cleanNetShp.py,
	  pysal/contrib/spatialnet/spatialnet.py: Adding FNODE/TNODE to dbf when cleaning shapefiles. Added util function createSpatialNetworkShapefile Added SpatialNetwork class

2012-04-17 15:32  schmidtc

	* pysal/contrib/weights_viewer/weights_viewer.py: "revert back to the background when the point is outside of any unit" - request from serge

2012-04-11 02:50  schmidtc

	* pysal/cg/kdtree.py: Fixing user submitted bug,issue #206.

2012-04-10 22:00  dreamessence

	* pysal/weights/Wsets.py: Including w_clip in __all__

2012-04-10 21:58  dreamessence

	* pysal/weights/Wsets.py: Adding w_clip method to clip W matrices (sparse and/or pysal.W) with a second (binary) matrix

2012-04-10 21:57  schmidtc

	* pysal/contrib/spatialnet/beth_roads.shp,
	  pysal/contrib/spatialnet/beth_roads.shx,
	  pysal/contrib/spatialnet/cleanNetShp.py: Adding network shapefile cleaning tools and temporary sample data.  

2012-04-10 21:48  sjsrey

	* pysal/contrib/spatialnet/util.py: - more stubs for util mod

2012-04-10 19:58  sjsrey

	* pysal/contrib/spatialnet/util.py: - start of util module

2012-04-03 20:43  sjsrey

	* pysal/contrib/spatialnet: - new contrib module - integrate geodanet functional (move over from network) - wrap networkx

2012-04-03 01:21  schmidtc

	* pysal/cg/rtree.py: Adding pickle support to RTree


2012-03-28 23:27  mhwang4 
	* pysal/contrib/network/kernel.py,
	  pysal/contrib/network/kfuncs.py,
	  pysal/contrib/network/test_access.py,
	  pysal/contrib/network/test_kernel.py,
	  pysal/contrib/network/test_kfuncs.py,
	  pysal/contrib/network/test_network.py: adding examples for network-related modules

2012-03-19 15:33  schmidtc

	* pysal/core/IOHandlers/pyDbfIO.py: Adding support for writing Null dates

2012-03-14 21:04  phil.stphns

	* doc/source/developers/testing.txt,
	  doc/source/users/installation.txt: Small changes to user install instructions to highlight the ease with which pysal can be installed ;-> And, developer instructions for running the test suite from within a session if desired.

2012-03-03 00:00  phil.stphns

	* pysal/spatial_dynamics/markov.py: Potential source of dev docs pngmath latex fail.

2012-02-24 23:29  mhwang4

	* pysal/contrib/network/network.py: fixing bug in network.py

2012-02-20 19:50  phil.stphns

	* doc/source/developers/py3k.txt: Developer doc to explain setting up PySAL for Python3.

2012-02-20 16:18  schmidtc

	* pysal/esda/__init__.py: removing invalid __all__ from esda's init.  See #194

2012-02-16 23:15  phil.stphns

	* pysal/__init__.py,
	  pysal/core/util/shapefile.py: Minor changes to imports that cause py3tool to stumble.

2012-02-15 23:16  phil.stphns

	* doc/source/developers/py3k.txt,
	  doc/source/users/installation.txt: Modified links in user installation instructions.  Added more steps for developers setting up Python3 dev environments on OSX.

2012-02-14 21:55  schmidtc

	* pysal/esda/getisord.py: fixing side effect caused when changing the shape of y, creating a new view with reshape instead.

2012-02-14 21:21  schmidtc

	* pysal/esda/getisord.py: optimizing G_Local

2012-02-14 20:37  schmidtc

	* pysal/esda/getisord.py: optimizing G

2012-02-14 00:21  phil.stphns

	* doc/source/developers/index.txt,
	  doc/source/developers/py3k.txt,
	  doc/source/developers/release.txt: Adding early docs on Python 3 support. Modifying release instructions.

v<1.3.0>, 2012-01-31

    * core/IOHandlers/pyDbfIO.py: Addressing issue #186

    * cg/shapes.py: fixing small bug in polygon constructor that causes
      an exception when an empty list is passed in for the holes.

    * cg/standalone.py: removing standalone centroid method. see issue
      #138.

    * esda/mapclassify.py, esda/tests/test_mapclassify.py: - new
      implementation of fisher jenks

    * spreg/__init__.py, spreg/diagnostics_sp.py,
      spreg/diagnostics_tsls.py, spreg/error_sp.py,
      spreg/error_sp_het.py, spreg/error_sp_hom.py, spreg/ols.py,
      spreg/robust.py, spreg/tests, spreg/twosls.py,
      spreg/twosls_sp.py, spreg/user_output.py, spreg/utils.py: Adding
      the following non-spatial/spatial regression modules:
      * Two Stage Least Squares
      * Spatial Two Stage Least Squares
      * GM Error (KP 98-99)
      * GM Error Homoskedasticity (Drukker et. al, 2010)
      * GM Error Heteroskedasticity (Arraiz et. al, 2010)
      * Anselin-Kelejian test for residual spatial autocorrelation of
      residuals from IV regression
      
      Adding also utility functions and other helper classes.
      
    * cg/standalone.py: slight improvment to get_shared_segments, in
      part to make it more readable.

    * cg/shapes.py, cg/tests/test_standalone.py: adding <,<=,>,>= tests
      to Point, this fixes a bug in the get_shared_segments function
      that was causing some LineSegments to be incorectly ordered
      because the default memory address was being used instead of the
      points location.

    * core/IOHandlers/tests/test_wkt.py, core/IOHandlers/wkt.py,
      core/util/tests/test_wkt.py, core/util/wkt.py,
      weights/tests/test_Distance.py, weights/tests/test_user.py,
      weights/user.py: Fixing small numerical errors n testing that
      resulted from changing the centroid algorithm.

    * esda/moran.py: another optimization for __crand see issue #188

    * weights/util.py: Added option for row-standardized SW in lat2SW.
      Implementing suggestion from Charlie in Issue 181 from
      StackOverflow

    * esda/moran.py: another optimization to __crand, see issue #188
      for details.

    * esda/moran.py: Optimized __crand in Local_Moran

    * cg/shapes.py, cg/standalone.py, contrib/shapely_ext.py:
      Adddressing issue #138, centroids for polygons with holes
      Fixing some issues with the shapely wrapper and out implemenation
      of __geo_interface__

    * weights/Distance.py: previous 'fix' to uniform kernel did not
      have correct dimensions

    * core/IOHandlers/arcgis_txt.py, core/IOHandlers/dat.py,
      weights/user.py: fixing rounding errors with docstrings

    * contrib/README, contrib/shared_perimeter_weights.py: Adding
      shared perimeter weights, see Issue #46

    * contrib/README, contrib/shapely_ext.py: moving shapely_ext into
      contrib

    * core/IOHandlers/pyDbfIO.py: Fixing issue with scientific notation
      is DBF files. #182

    * core/IOHandlers/pyShpIO.py: clockwise testing should only be
      performed on Polygons. #183

    * spreg/diagnostics_sp.py: Switching ints to floats in variance of
      Morans I for residuals to get correct results

    * core/util/shapefile.py, examples/__init__.py: Add a "get_path"
      function to examples module.
      pysal.examples.get_path('stl_hom.shp') will always return the
      correct system path to stl_hom.shp, no matter where it's run
      from. This is useful for testing.
      Modified shapefile tests to use the new function.

    * spreg/diagnostics.py: Adding check on condition_index to pick OLS
      (xtx) or IV (hth) model

    * core/IOHandlers/template.py: Updating template to pass unit
      testing.

    * core/util/shapefile.py: Fixing issue #180. Making shapefile
      opener case insensitive.

    * spatial_dynamics/interaction.py,
      spatial_dynamics/tests/test_interaction.py: Adding modified Knox
      and changes to existing tests in spatial_dynamics.

    * core/IOHandlers/arcgis_txt.py,
      core/IOHandlers/tests/test_arcgis_txt.py: fixing arcgis_txt.py so
      that it ignores self-neighbors with zero weights

    * core/FileIO.py: Updating library README.
      Removing docstrings from FileIO module.

    * contrib/README: adding contrib to installer and adding initial
      README

    * core/IOHandlers/gwt.py: rewrote GWT reader to avoid list appends.
      resulted in speed up of about 12x.

    * core/IOHandlers/pyDbfIO.py: implementing _get_col for dbf files.

    * core/IOHandlers/gwt.py: Adding a small fix to gwt reader, if the
      ids cannot be found in the associated DBF, they will be read in
      order from the GWT file.

    * contrib/weights_viewer/weights_viewer.py: Small change to
      identify polygons that are their own neighbor.

    * weights/Distance.py: removing incorrect kernel functions and
      fixing bug in uniform kernel

    * weights/util.py: refactoring insert_diagonal so that it can add
      or overwrite the diagonal weights

    * contrib, contrib/README, contrib/__init__.py,
      contrib/weights_viewer, contrib/weights_viewer/__init__.py,
      contrib/weights_viewer/transforms.py,
      contrib/weights_viewer/weights_viewer.py: Adding 1st contrib, a
      wxPython based Weights file viewer.


    * spatial_dynamics/markov.py: - handle case of zero transitions in
      spatial markov, consistent with treatment
      in classic markov

    * core/FileIO.py, core/IOHandlers/pyShpIO.py: Changes to allow
      reading of null polygons.

    * core/util/shapefile.py, core/util/tests/test_shapefile.py:
      refactoring shapefile reader, see issue #89

    * core/FileIO.py: small change to FileIO to allow FileFormat
      argument to be passed through

    * esda/getisord.py: fixing bug in local Z values for integer data

    * cg/__init__.py, weights/user.py, weights/util.py: adding radius
      option to user weights methods

    * cg/kdtree.py, common.py, weights/Distance.py,
      weights/tests/test_Distance.py: Distance weights can not be
      passed an instnace of KDTree instead of an array. If the KDTree
      is of type ArcKDTree, the weights returns will be based on
      ArcDistances. Adding tests for Arc cases off KNN and
      DistanceBand.

    * weights/util.py: - added function for local clustering
      coefficient - summary for W as a graph

    * cg/kdtree.py, cg/sphere.py: finishing up Arc_KDTree

    * weights/Distance.py: More doctest fixes.

    * region/maxp.py, spreg/diagnostics.py, weights/Distance.py,
      weights/user.py: Fixing the doctests for dusty python setup.

    * cg/kdtree.py, cg/sphere.py: adding spherical wrapper around scipy
      kdtree

    * cg/__init__.py, cg/sphere.py: Adding spherical distance tools to
      cg. Related to issue #168

    * core/IOHandlers/gwt.py, core/IOHandlers/tests/test_gwt.py:
      re-enabled gwt writing.
      'o' transform is used on all GWTs for writing (w is returned to
      existing transform on exit)
      Also, setting '_shpName' and '_varName' attributes on W's which
      are read in through gwt.
      the writer will check if these vars exist and use them for the
      header, this prevents metadata loss on simple copies

    * esda/join_counts.py: - fix for handling int array type

    * spreg/diagnostics.py: Adding more efficient constant check for
      spreg.

    * cg/shapes.py: adding __geo_interface__ and asShape adapter for
      Point, LineString and Polygon

    * spreg/diagnostics.py: minor change to t-stat function to
      accommodate future regression models

    * esda/mapclassify.py: - more general fix for #166


v<1.2.0>, 2011-07-31

    * pysal/spreg/user_output.py: Fix for bug 162

    * pysal/spatial_dynamics/markov.py: Added markov mobility measures; addresses issue 137

    * pysal/weights/weights.py: Partially addressed issue 160 by removing the shimbel, order, and higher_order methods from W. 

    * doc/source/users/installation.txt: Adding known issue regarding GNU/Linux testing and random seeds; see ticket 52.

    * pysal/esda/geary.py: Adding sparse implementation of Geary's C; substantial gains on larger datasets. 

    * pysal/core/IOHandlers/mtx.py: Adding WSP2W function for fast conversion of sparse weights object (WSP) to pysal W.

    * pysal/esda/getisord.py: Adding Getis-Ord G test module

    * pysal/weights/util.py: Added function that inserts values along the main diagonal of a weights object

    * doc/source/users/tutorials: Fixed issue 76.

    * pysal/core/IOHandlers/mtx.py: Added an IOHandler for MatrixMarket MTX files

    * pysal/esda/moran.py: Optimized conditional randomization

    * pysal/weights/util.py: Re-adding full2W() method to convert full arrays into W objects; related to issue #136. 

    * pysal/core/IOHandlers/gal.py: Added sparse WSP (thin W); gal reader can return W or WSP

    * pysal/core/IOHandlers/pyDbfIO.py: Bug Fix, DBF files are not properly closed when opened in 'r' mode. See issue #155.

    * pysal/core/IOHandlers/stata_txt.py: Adding FileIO handlers for STATA text files

    * pysal/weights/user.py: Fixed issue #154, adding k option to User Kernel weights functions.

    * pysal/core/IOHandlers/mat.py: Adding an IOHandler for MATLAB mat file

    * pysal/core/IOHandlers/wk1.py: Adding an IO handler for wk1 file

    * pysal/core/IOHandlers/geobugs_txt.py: Adding an IO handler for geobugs text file.

    * pysal/core/IOHandlers/arcgis_swm.py: Added ArcGIS SWM file handler

    * pysal/core/IOHandlers/arcgis_dbf.py: Adding a spatial weights file in the (ArcGIS-style) DBF format. 

    * pysal/core/IOHandlers/arcgis_txt.py: Added ArcGIS ASCII file IO handler. 

    * pysal/core/IOHandlers/dat.py: Added DAT file handler.

    * pysal/cg/locators.py: Added point in polygon method for Polygon and PolygonLocator

    * pysal/weights/Distance.py: Optimized Kernel() method to run much faster for the case of adaptive bandwidths

    * pysal/weights/user.py: Added helper function in user.py to create scipy sparse matrix from a gal file

    * pysal/common.py: Added shallow copy method to Read-Only Dict to support multiprocessing.

    * pysal/spatial_dynamics/rank.py: More efficient regime weights

    * pysal/weights/Distance.py: Adding epanechnikov and bisquare kernel funtions

    * pysal/core/IOHandlers/pyDbfIO.py: Adding NULL support to numerical DBF fields; modifying PointLocator API to match PolygonLocator API 

    * pysal/cg/locators.py: Handles case when query rectangle is completely inside a polygon

    * pysal/cg/locators.py: Explicit polygon overlap hit test

    * pysal/cg/standalone.py: Adding point-polygon intersection support for polygons with holes.

    * pysal/spatial_dynamics/markov.py: Added homogeneity test.

    * pysal/spatial_dynamics/markov.py: Added spillover test in LISA_Markov.

    * pysal/cg/locators.py: Added Rtree based spatial index for polygonlocator.

    * pysal/cg/rtree.py: Added pure python Rtree module.

    * doc/source/developers/pep/pep-0010.txt: Added PEP 0010: Rtree module in pure python.

    * pysal/esda/geary.py: Fixed bug 144.

    * pysal/spatial_dynamics/markov.py: Added significance filtering of LISA markov.

    * doc/source/developers/pep/pep-0009.txt: Added new PEP, "PEP 0009: Add Python 3.x Support."

    * doc/source/developers/guidelines.txt: New release cycle schedules for 1.2 and 1.3.

    * doc/source/developers/release.txt: Updated pypi instructions; PySAL available on the Python Package Index via download, easy_install, and pip. 

v<1.1.0>, 2011-01-31

    * pysal/core/FileIO.py, pysal/core/IOHandlers/pyDbfIO.py: Added missing value support to FileIO. Warnings will be issued when missing values are found and the value will be set to pysal.MISSINGVALUE, currently None, but the user can change it as needed.

    * pysal/spreg/: Added Spatial Regression module, spreg, and tests.  Added non-spatial diagnostic tests for OLS regression. 

    * pysal/core/IOHandlers/gwt.py: Fixing bottle neck in gwt reader, adding support for GeoDa Style ID's and DBF id_order.

    * pysal/cg/standalone.py: adding, distance_matrix, full distance matrix calculation using sparse matrices

    * pysal/core/util: Moved "converters" into core.util, allows them to be used independently of FileIO.

    * pysal/weights/Distance.py: Adding work around for bug in scipy spatial, see pysal issue #126

    * pysal/weights/user.py: Added build_lattice_shapefile in weights.user, which writes an ncol by nrow grid to a shapefile.

    * pysal/weights/Distance.py: fixed coincident point problem in knnW and made sure it returns k neighbors 
    * pysal/spatial_dynamics/interaction.py: Added a suite of spatio-temporal interaction tests including the Knox, Mantel, and Jacquez tests. 

    * pysal/weights/util.py: Added lat2SW, allows to create a sparse W matrix for a regular lattice.

    * pysal/tests/tests.py: - new 1.1 integration testing scheme.

    * pysal/esda/interaction.py: added standardized Mantel test and improved readability.

    * pysal/spatial_dynamics/directional.py: - adding directional LISA analytics

    * pysal/esda/mapclassify.py: Natural_Breaks will lower k for data with fewer than k unique values, prints warning.

    * pysal/region/randomregion.py: improvements to spatially constrained random region algorithm

    * pysal/esda/smoothing.py: Adding choynowski probabilities and SMR to smoothing.py

    * doc/source/developers/release.txt: - updating release cycle - release management

# v<1.0.0>, 2010-07-31 -- Initial release.
