from fastapi import FastAPI

import air

app = air.Air()
api = FastAPI()


@app.get("/")
def landing_page():
    return air.layouts.picocss(
        air.Head(air.Title("Awesome SaaS")),
        air.Body(
            air.H1("Awesome SaaS"),
            air.P(air.A("API Docs", target="_blank", href="/api/docs")),
        ),
    )


@api.get("/")
def api_root():
    return {"message": "Awesome SaaS is powered by FastAPI"}


app.mount("/api", api)
