from .tags import CaseTag


class A(CaseTag):
    """Defines an SVG hyperlink"""

    pass


class Animate(CaseTag):
    """Defines animation on an SVG element"""

    pass


class AnimateMotion(CaseTag):
    """Defines how an element moves along a motion path"""

    pass


class AnimateTransform(CaseTag):
    """Animates transform attributes on an element"""

    pass


class Circle(CaseTag):
    """Defines a circle"""

    pass


class ClipPath(CaseTag):
    """Defines a clipping path"""

    pass


class Defs(CaseTag):
    """Defines reusable objects"""

    pass


class Desc(CaseTag):
    """Defines a description of an element"""

    pass


class Ellipse(CaseTag):
    """Defines an ellipse"""

    pass


class FeBlend(CaseTag):
    """Defines image blending"""

    pass


class FeColorMatrix(CaseTag):
    """Applies a matrix transformation on color values"""

    pass


class FeComponentTransfer(CaseTag):
    """Performs component-wise remapping of data"""

    pass


class FeComposite(CaseTag):
    """Performs image compositing"""

    pass


class FeConvolveMatrix(CaseTag):
    """Applies a matrix convolution filter"""

    pass


class FeDiffuseLighting(CaseTag):
    """Lights an image using diffuse lighting"""

    pass


class FeDisplacementMap(CaseTag):
    """Displaces an image using another image"""

    pass


class FeDistantLight(CaseTag):
    """Defines a distant light source"""

    pass


class FeDropShadow(CaseTag):
    """Creates a drop shadow effect"""

    pass


class FeFlood(CaseTag):
    """Fills the filter region with a color"""

    pass


class FeFuncA(CaseTag):
    """Defines the alpha transfer function"""

    pass


class FeFuncB(CaseTag):
    """Defines the blue transfer function"""

    pass


class FeFuncG(CaseTag):
    """Defines the green transfer function"""

    pass


class FeFuncR(CaseTag):
    """Defines the red transfer function"""

    pass


class FeGaussianBlur(CaseTag):
    """Applies Gaussian blur to an image"""

    pass


class FeImage(CaseTag):
    """Refers to an external image"""

    pass


class FeMerge(CaseTag):
    """Merges multiple filter nodes"""

    pass


class FeMergeNode(CaseTag):
    """Defines a node for feMerge"""

    pass


class FeMorphology(CaseTag):
    """Applies morphological operations"""

    pass


class FeOffset(CaseTag):
    """Offsets an image"""

    pass


class FePointLight(CaseTag):
    """Defines a point light source"""

    pass


class FeSpecularLighting(CaseTag):
    """Lights an image using specular lighting"""

    pass


class FeSpotLight(CaseTag):
    """Defines a spot light source"""

    pass


class FeTile(CaseTag):
    """Tiles an image to fill a rectangle"""

    pass


class FeTurbulence(CaseTag):
    """Creates turbulence noise"""

    pass


class Filter(CaseTag):
    """Defines a filter effect"""

    pass


class ForeignObject(CaseTag):
    """Allows inclusion of foreign XML"""

    pass


class G(CaseTag):
    """Groups SVG elements"""

    pass


class Image(CaseTag):
    """Embeds an image"""

    pass


class Line(CaseTag):
    """Defines a line"""

    pass


class LinearGradient(CaseTag):
    """Defines a linear gradient"""

    pass


class Marker(CaseTag):
    """Defines a graphic for drawing on lines"""

    pass


class Mask(CaseTag):
    """Defines a mask"""

    pass


class Metadata(CaseTag):
    """Defines metadata"""

    pass


class Mpath(CaseTag):
    """Defines a motion path"""

    pass


class Path(CaseTag):
    """Defines a path"""

    pass


class Pattern(CaseTag):
    """Defines a pattern"""

    pass


class Polygon(CaseTag):
    """Defines a polygon"""

    pass


class Polyline(CaseTag):
    """Defines a polyline"""

    pass


class RadialGradient(CaseTag):
    """Defines a radial gradient"""

    pass


class Rect(CaseTag):
    """Defines a rectangle"""

    pass


class Script(CaseTag):
    """Defines a script"""

    pass


class Set(CaseTag):
    """Sets an attribute value"""

    pass


class Stop(CaseTag):
    """Defines a gradient stop"""

    pass


class Style(CaseTag):
    """Defines style information"""

    pass


class Svg(CaseTag):
    """Defines an SVG document fragment"""

    pass


class Switch(CaseTag):
    """Defines conditional processing"""

    pass


class Symbol(CaseTag):
    """Defines a reusable symbol"""

    pass


class Text(CaseTag):
    """Defines text content"""

    pass


class TextPath(CaseTag):
    """Defines text along a path"""

    pass


class Title(CaseTag):
    """Defines a title for the SVG document"""

    pass


class Tspan(CaseTag):
    """Defines a text span"""

    pass


class Use(CaseTag):
    """References another element"""

    pass


class View(CaseTag):
    """Defines a view"""

    pass
