/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import java.io.FileDescriptor;
import java.io.IOException;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.Group;
import org.jruby.ext.posix.LibC;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXFactory;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.Passwd;

final class LazyPOSIX
implements POSIX {
    private final POSIXHandler handler;
    private final boolean useNativePosix;
    private volatile POSIX posix;

    LazyPOSIX(POSIXHandler handler, boolean useNativePosix) {
        this.handler = handler;
        this.useNativePosix = useNativePosix;
    }

    private final POSIX posix() {
        return this.posix != null ? this.posix : this.loadPOSIX();
    }

    private final synchronized POSIX loadPOSIX() {
        return this.posix != null ? this.posix : (this.posix = POSIXFactory.loadPOSIX(this.handler, this.useNativePosix));
    }

    public FileStat allocateStat() {
        return this.posix().allocateStat();
    }

    public int chmod(String filename, int mode) {
        return this.posix().chmod(filename, mode);
    }

    public int chown(String filename, int user, int group) {
        return this.posix().chown(filename, user, group);
    }

    public int endgrent() {
        return this.posix().endgrent();
    }

    public int endpwent() {
        return this.posix().endpwent();
    }

    public int errno() {
        return this.posix().errno();
    }

    public void errno(int value) {
        this.posix().errno(value);
    }

    public int exec(String path, String ... args) {
        return this.posix().exec(path, args);
    }

    public int exec(String path, String[] args, String[] envp) {
        return this.posix().exec(path, args, envp);
    }

    public int execv(String path, String[] argv) {
        return this.posix().execv(path, argv);
    }

    public int execve(String path, String[] argv, String[] envp) {
        return this.posix().execve(path, argv, envp);
    }

    public int fork() {
        return this.posix().fork();
    }

    public FileStat fstat(FileDescriptor descriptor) {
        return this.posix().fstat(descriptor);
    }

    public int fstat(FileDescriptor descriptor, FileStat stat) {
        return this.posix().fstat(descriptor, stat);
    }

    public int getegid() {
        return this.posix().getegid();
    }

    public int geteuid() {
        return this.posix().geteuid();
    }

    public int getgid() {
        return this.posix().getgid();
    }

    public Group getgrent() {
        return this.posix().getgrent();
    }

    public Group getgrgid(int which) {
        return this.posix().getgrgid(which);
    }

    public Group getgrnam(String which) {
        return this.posix().getgrnam(which);
    }

    public String getlogin() {
        return this.posix().getlogin();
    }

    public int getpgid() {
        return this.posix().getpgid();
    }

    public int getpgid(int pid) {
        return this.posix().getpgid(pid);
    }

    public int getpgrp() {
        return this.posix().getpgrp();
    }

    public int getpid() {
        return this.posix().getpid();
    }

    public int getppid() {
        return this.posix().getppid();
    }

    public int getpriority(int which, int who) {
        return this.posix().getpriority(which, who);
    }

    public Passwd getpwent() {
        return this.posix().getpwent();
    }

    public Passwd getpwnam(String which) {
        return this.posix().getpwnam(which);
    }

    public Passwd getpwuid(int which) {
        return this.posix().getpwuid(which);
    }

    public int getuid() {
        return this.posix().getuid();
    }

    public boolean isatty(FileDescriptor descriptor) {
        return this.posix().isatty(descriptor);
    }

    public int kill(int pid, int signal) {
        return this.posix().kill(pid, signal);
    }

    public int lchmod(String filename, int mode) {
        return this.posix().lchmod(filename, mode);
    }

    public int lchown(String filename, int user, int group) {
        return this.posix().lchown(filename, user, group);
    }

    public int link(String oldpath, String newpath) {
        return this.posix().link(oldpath, newpath);
    }

    public FileStat lstat(String path) {
        return this.posix().lstat(path);
    }

    public int lstat(String path, FileStat stat) {
        return this.posix().lstat(path, stat);
    }

    public int mkdir(String path, int mode) {
        return this.posix().mkdir(path, mode);
    }

    public String readlink(String path) throws IOException {
        return this.posix().readlink(path);
    }

    public int setegid(int egid) {
        return this.posix().setegid(egid);
    }

    public int seteuid(int euid) {
        return this.posix().seteuid(euid);
    }

    public int setgid(int gid) {
        return this.posix().setgid(gid);
    }

    public int setgrent() {
        return this.posix().setgrent();
    }

    public int setpgid(int pid, int pgid) {
        return this.posix().setpgid(pid, pgid);
    }

    public int setpgrp(int pid, int pgrp) {
        return this.posix().setpgrp(pid, pgrp);
    }

    public int setpriority(int which, int who, int prio) {
        return this.posix().setpriority(which, who, prio);
    }

    public int setpwent() {
        return this.posix().setpwent();
    }

    public int setsid() {
        return this.posix().setsid();
    }

    public int setuid(int uid) {
        return this.posix().setuid(uid);
    }

    public FileStat stat(String path) {
        return this.posix().stat(path);
    }

    public int stat(String path, FileStat stat) {
        return this.posix().stat(path, stat);
    }

    public int symlink(String oldpath, String newpath) {
        return this.posix().symlink(oldpath, newpath);
    }

    public int umask(int mask) {
        return this.posix().umask(mask);
    }

    public int utimes(String path, long[] atimeval, long[] mtimeval) {
        return this.posix().utimes(path, atimeval, mtimeval);
    }

    public int wait(int[] status) {
        return this.posix().wait(status);
    }

    public int waitpid(int pid, int[] status, int flags) {
        return this.posix().waitpid(pid, status, flags);
    }

    public boolean isNative() {
        return this.posix().isNative();
    }

    public LibC libc() {
        return this.posix().libc();
    }

    public String getenv(String envName) {
        return this.posix().getenv(envName);
    }

    public int setenv(String envName, String envValue, int overwrite) {
        return this.posix().setenv(envName, envValue, overwrite);
    }

    public int unsetenv(String envName) {
        return this.posix().unsetenv(envName);
    }
}

