package aQute.bnd.annotation.component;

import java.lang.annotation.*;

@Retention(RetentionPolicy.CLASS)
@Target(ElementType.TYPE)
public @interface Component {
    String RNAME                = "LaQute/bnd/annotation/component/Component;";
    String PROVIDE              = "provide";
    String NAME                 = "name";
    String FACTORY              = "factory";
    String SERVICEFACTORY       = "servicefactory";
    String IMMEDIATE            = "immediate";
    String CONFIGURATION_POLICY = "configurationPolicy";
    String ENABLED              = "enabled";
    String PROPERTIES           = "properties";

    String name() default "";

    Class<?>[] provide() default Object.class;

    boolean factory() default false;

    boolean servicefactory() default false;

    boolean enabled() default true;

    boolean immediate() default false;

    ConfigurationPolicy configurationPolicy() default ConfigurationPolicy.optional;

    String[] properties() default "";
}
