CREATE TABLE "user_subscription_tiers" (
	"id" bigint PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY (sequence name "user_subscription_tiers_id_seq" INCREMENT BY 1 MINVALUE 1 START WITH 1 CACHE 1),
	"created_at" timestamp with time zone DEFAULT now() NOT NULL,
	"name" text NOT NULL,
	"stripe_product_id" text DEFAULT '' NOT NULL,
	"index_chat_messages" bigint DEFAULT '0'
);
--> statement-breakpoint
CREATE TABLE "user_usage" (
	"user_id" uuid PRIMARY KEY DEFAULT gen_random_uuid() NOT NULL,
	"index_chat_message_count" bigint DEFAULT '0' NOT NULL,
	"index_chat_message_count_since_reset" bigint DEFAULT '0' NOT NULL,
	"prev_index_chat_message_count" bigint DEFAULT '0' NOT NULL,
	"reset_time" timestamp with time zone DEFAULT now() NOT NULL,
	"reset_reason" text DEFAULT 'signup' NOT NULL
);
--> statement-breakpoint
ALTER TABLE "workspaces" ALTER COLUMN "subscription_id" DROP DEFAULT;--> statement-breakpoint
ALTER TABLE "workspaces" ALTER COLUMN "subscription_id" DROP NOT NULL;--> statement-breakpoint
ALTER TABLE "users" ADD COLUMN "tier_id" bigint DEFAULT '1' NOT NULL;--> statement-breakpoint
ALTER TABLE "users" ADD COLUMN "subscription_id" text;--> statement-breakpoint
ALTER TABLE "user_usage" ADD CONSTRAINT "user_usage_user_id_fkey" FOREIGN KEY ("user_id") REFERENCES "public"."users"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "users" ADD CONSTRAINT "users_tier_id_fkey" FOREIGN KEY ("tier_id") REFERENCES "public"."user_subscription_tiers"("id") ON DELETE no action ON UPDATE no action;