import { config } from 'dotenv';
import { defineConfig } from 'drizzle-kit';

config({ path: '.env.local' });

export default defineConfig({
  dialect: 'postgresql',
  dbCredentials: {
    url: process.env.DATABASE_URL!,
  },
  schema: './lib/db/migrations/schema.ts',
  out: './lib/db/migrations',
  entities: {
    roles: {
      provider: 'supabase',
    }
  }
});
