import { Tag } from "lucide-react";
import React from "react";

import ManageTags from "@/components/tags/manage-tags";
import { Badge } from "@/components/ui/badge";
import { DropdownMenuTrigger } from "@/components/ui/dropdown-menu";

const Tags = () => (
  <ManageTags>
    <DropdownMenuTrigger asChild>
      <Badge className="cursor-pointer min-w-8" variant="secondary">
        <Tag className="size-3 min-w-3 mr-2" />
        <span className="text-xs truncate">Tags</span>
      </Badge>
    </DropdownMenuTrigger>
  </ManageTags>
);

export default Tags;
