// This file is @generated by prost-build.
#[allow(dead_code)]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct QueueExistsRequest {
    #[prost(string, tag = "1")]
    pub queue_id: ::prost::alloc::string::String,
}
#[allow(dead_code)]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct CreateQueueRequest {
    #[prost(string, tag = "1")]
    pub queue_id: ::prost::alloc::string::String,
}
#[allow(dead_code)]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct CreateQueueIfNotExistsRequest {
    #[prost(string, tag = "1")]
    pub queue_id: ::prost::alloc::string::String,
}
#[allow(dead_code)]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct CreateQueueIfNotExistsResponse {
    #[prost(string, tag = "1")]
    pub queue_id: ::prost::alloc::string::String,
    #[prost(bool, tag = "2")]
    pub created: bool,
}
#[allow(dead_code)]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DropQueueRequest {
    #[prost(string, tag = "1")]
    pub queue_id: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IngestRequest {
    #[prost(message, repeated, tag = "1")]
    pub doc_batches: ::prost::alloc::vec::Vec<DocBatch>,
    #[prost(enumeration = "CommitType", tag = "2")]
    pub commit: i32,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct IngestResponse {
    #[prost(uint64, tag = "1")]
    pub num_docs_for_processing: u64,
}
/// Fetch messages with position strictly after `start_after`.
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct FetchRequest {
    #[prost(string, tag = "1")]
    pub index_id: ::prost::alloc::string::String,
    #[prost(uint64, optional, tag = "2")]
    pub start_after: ::core::option::Option<u64>,
    #[prost(uint64, optional, tag = "3")]
    pub num_bytes_limit: ::core::option::Option<u64>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct FetchResponse {
    #[prost(uint64, optional, tag = "1")]
    pub first_position: ::core::option::Option<u64>,
    #[prost(message, optional, tag = "2")]
    pub doc_batch: ::core::option::Option<DocBatch>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DocBatch {
    #[prost(string, tag = "1")]
    pub index_id: ::prost::alloc::string::String,
    #[prost(bytes = "vec", tag = "2")]
    pub doc_buffer: ::prost::alloc::vec::Vec<u8>,
    #[prost(uint32, repeated, tag = "3")]
    pub doc_lengths: ::prost::alloc::vec::Vec<u32>,
}
/// Suggest to truncate the queue.
///
/// This function allows the queue to remove all records up to and
/// including `up_to_offset_included`.
///
/// The role of this truncation is to release memory and disk space.
///
/// There are no guarantees that the record will effectively be removed.
/// Nothing might happen, or the truncation might be partial.
///
/// In other words, truncating from a position, and fetching records starting
/// earlier than this position can yield undefined result:
/// the truncated records may or may not be returned.
#[allow(dead_code)]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct SuggestTruncateRequest {
    #[prost(string, tag = "1")]
    pub index_id: ::prost::alloc::string::String,
    #[prost(uint64, tag = "2")]
    pub up_to_position_included: u64,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct TailRequest {
    #[prost(string, tag = "1")]
    pub index_id: ::prost::alloc::string::String,
}
#[allow(dead_code)]
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ListQueuesRequest {}
#[allow(dead_code)]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ListQueuesResponse {
    #[prost(string, repeated, tag = "1")]
    pub queues: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Specifies if the ingest request should block waiting for the records to be committed.
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum CommitType {
    /// The request doesn't wait for commit
    Auto = 0,
    /// The request waits for the next scheduled commit to finish.
    WaitFor = 1,
    /// The request forces an immediate commit after the last document in the batch and waits for
    /// it to finish.
    Force = 2,
}
impl CommitType {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Auto => "Auto",
            Self::WaitFor => "WaitFor",
            Self::Force => "Force",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "Auto" => Some(Self::Auto),
            "WaitFor" => Some(Self::WaitFor),
            "Force" => Some(Self::Force),
            _ => None,
        }
    }
}
/// Generated client implementations.
pub mod ingest_service_client {
    #![allow(
        unused_variables,
        dead_code,
        missing_docs,
        clippy::wildcard_imports,
        clippy::let_unit_value,
    )]
    use tonic::codegen::*;
    use tonic::codegen::http::Uri;
    #[derive(Debug, Clone)]
    pub struct IngestServiceClient<T> {
        inner: tonic::client::Grpc<T>,
    }
    impl IngestServiceClient<tonic::transport::Channel> {
        /// Attempt to create a new client by connecting to a given endpoint.
        pub async fn connect<D>(dst: D) -> Result<Self, tonic::transport::Error>
        where
            D: TryInto<tonic::transport::Endpoint>,
            D::Error: Into<StdError>,
        {
            let conn = tonic::transport::Endpoint::new(dst)?.connect().await?;
            Ok(Self::new(conn))
        }
    }
    impl<T> IngestServiceClient<T>
    where
        T: tonic::client::GrpcService<tonic::body::Body>,
        T::Error: Into<StdError>,
        T::ResponseBody: Body<Data = Bytes> + std::marker::Send + 'static,
        <T::ResponseBody as Body>::Error: Into<StdError> + std::marker::Send,
    {
        pub fn new(inner: T) -> Self {
            let inner = tonic::client::Grpc::new(inner);
            Self { inner }
        }
        pub fn with_origin(inner: T, origin: Uri) -> Self {
            let inner = tonic::client::Grpc::with_origin(inner, origin);
            Self { inner }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> IngestServiceClient<InterceptedService<T, F>>
        where
            F: tonic::service::Interceptor,
            T::ResponseBody: Default,
            T: tonic::codegen::Service<
                http::Request<tonic::body::Body>,
                Response = http::Response<
                    <T as tonic::client::GrpcService<tonic::body::Body>>::ResponseBody,
                >,
            >,
            <T as tonic::codegen::Service<
                http::Request<tonic::body::Body>,
            >>::Error: Into<StdError> + std::marker::Send + std::marker::Sync,
        {
            IngestServiceClient::new(InterceptedService::new(inner, interceptor))
        }
        /// Compress requests with the given encoding.
        ///
        /// This requires the server to support it otherwise it might respond with an
        /// error.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.send_compressed(encoding);
            self
        }
        /// Enable decompressing responses.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.accept_compressed(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_decoding_message_size(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_encoding_message_size(limit);
            self
        }
        /// Ingests document in a given queue.
        ///
        /// Upon any kind of error, the client should
        ///
        /// * retry to get at least once delivery.
        /// * not retry to get at most once delivery.
        ///
        /// Exactly once delivery is not supported yet.
        pub async fn ingest(
            &mut self,
            request: impl tonic::IntoRequest<super::IngestRequest>,
        ) -> std::result::Result<tonic::Response<super::IngestResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/ingest_service.IngestService/Ingest",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("ingest_service.IngestService", "Ingest"));
            self.inner.unary(req, path, codec).await
        }
        /// Fetches record from a given queue.
        ///
        /// Records are returned in order.
        ///
        /// The returned `FetchResponse` object is meant to be read with the
        /// `crate::iter_records` function.
        ///
        /// Fetching does not necessarily return all of the available records.
        /// If returning all records would exceed `FETCH_PAYLOAD_LIMIT` (2MB),
        /// the response will be partial.
        pub async fn fetch(
            &mut self,
            request: impl tonic::IntoRequest<super::FetchRequest>,
        ) -> std::result::Result<tonic::Response<super::FetchResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/ingest_service.IngestService/Fetch",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("ingest_service.IngestService", "Fetch"));
            self.inner.unary(req, path, codec).await
        }
        /// Returns a batch containing the last records.
        ///
        /// It returns the last documents, from the newest
        /// to the oldest, and stops as soon as `FETCH_PAYLOAD_LIMIT` (2MB)
        /// is exceeded.
        pub async fn tail(
            &mut self,
            request: impl tonic::IntoRequest<super::TailRequest>,
        ) -> std::result::Result<tonic::Response<super::FetchResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/ingest_service.IngestService/Tail",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("ingest_service.IngestService", "Tail"));
            self.inner.unary(req, path, codec).await
        }
    }
}
