% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarities.R
\name{similarities}
\alias{similarities}
\title{Apply a function to a list of similarities}
\usage{
similarities(sim, func, ...)
}
\arguments{
\item{sim}{list of similarities to be joined. All similarities must have the
same dimensions. The genes are assumed to be in the same order for all the
matrices.}

\item{func}{function to perform on those similarities: \code{prod},
\code{sum}... It should accept as many arguments as similarities matrices
are provided, and should use numbers.}

\item{...}{Other arguments passed to the function \code{func}. Usually na.rm
or similar.}
}
\value{
A matrix of the size of the similarities
}
\description{
Function to join list of similarities by a function provided by the user.
}
\note{
It doesn't check that the columns and rows of the matrices are in the
same order or are the same.
}
\examples{
set.seed(100)
a <- seq2mat(LETTERS[1:5], rnorm(10))
b <- seq2mat(LETTERS[1:5], seq(from = 0.1, to = 1, by = 0.1))
sim <- list(b, a)
similarities(sim, weighted.prod, c(0.5, 0.5))
# Note the differences in the sign of some values
similarities(sim, weighted.sum, c(0.5, 0.5))
}
\seealso{
\code{\link{weighted}} for functions that can be used, and
\code{\link{addSimilarities}} for a wrapper to one of them
}
\author{
Lluís Revilla
}
