% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathSim.R
\docType{methods}
\name{pathSim}
\alias{pathSim}
\alias{pathSim,character,character,GeneSetCollection-method}
\title{Calculates the Dice similarity between pathways}
\usage{
pathSim(pathway1, pathway2, info)

\S4method{pathSim}{character,character,GeneSetCollection}(pathway1, pathway2,
  info)
}
\arguments{
\item{pathway1, pathway2}{A single pathway to calculate the similarity}

\item{info}{A list or a GeneSetCollection of genes and the pathways they are
involved.}
}
\value{
The similarity between those pathways or all the similarities
between each comparison.
}
\description{
Calculates the similarity between pathways using dice similarity score.
\code{diceSim} is used to calculate similarities between the two pathways.
}
\section{Methods (by class)}{
\itemize{
\item \code{pathway1 = character,pathway2 = character,info = GeneSetCollection}: Calculates all the similarities of a GeneSetCollection
and combine them using \code{combineScoresPar}
}}

\examples{
if (require("reactome.db")){
    # Extracts the paths of all genes of org.Hs.eg.db from reactome
    genes.react <- as.list(reactomeEXTID2PATHID)
    (paths <- sample(unique(unlist(genes.react)), 2))
    pathSim(paths[1], paths[2], genes.react)
} else {
    warning('You need reactome.db package for this example')
}
}
\seealso{
\code{\link{conversions}} help page to transform Dice score to Jaccard
score.
\code{\link{mpathSim}} for multiple pairwise comparison of pathways.
}
\author{
Lluís Revilla
}
