% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpathSim.R
\docType{methods}
\name{mpathSim}
\alias{mpathSim}
\alias{mpathSim,character,GeneSetCollection,ANY-method}
\alias{mpathSim,missing,GeneSetCollection,ANY-method}
\alias{mpathSim,missing,list,ANY-method}
\alias{mpathSim,missing,list,missing-method}
\title{Calculates the Dice similarity between pathways}
\usage{
mpathSim(pathways, info, method = NULL, ...)

\S4method{mpathSim}{character,GeneSetCollection,ANY}(pathways, info,
  method = NULL, ...)

\S4method{mpathSim}{missing,GeneSetCollection,ANY}(pathways, info,
  method = NULL, ...)

\S4method{mpathSim}{missing,list,ANY}(pathways, info, method = NULL, ...)

\S4method{mpathSim}{missing,list,missing}(pathways, info, method = NULL, ...)
}
\arguments{
\item{pathways}{Pathways to calculate the similarity for}

\item{info}{A list of genes and the pathways they are involved or a
GeneSetCollection object}

\item{method}{To combine the scores of each pathway, one of \code{c("avg",
"max", "rcmax", "rcmax.avg", "BMA")}, if NULL returns the matrix of
similarities.}

\item{...}{Other arguments passed to \code{\link{combineScoresPar}}}
}
\value{
The similarity between those pathways or all the similarities
between each comparison.
}
\description{
Calculates the similarity between several pathways using dice similarity score.
If one needs the matrix of similarities between pathways set the argument
methods to \code{NULL}.
}
\section{Methods (by class)}{
\itemize{
\item \code{pathways = character,info = GeneSetCollection,method = ANY}: Calculates the similarity between the provided pathways
of the GeneSetCollection using \code{combineScoresPar}

\item \code{pathways = missing,info = GeneSetCollection,method = ANY}: Calculates all the similarities of the
GeneSetCollection and combine them using \code{combineScoresPar}

\item \code{pathways = missing,info = list,method = ANY}: Calculates all the similarities of the list and
combine them using \code{combineScoresPar}

\item \code{pathways = missing,info = list,method = missing}: Calculates all the similarities of the list
}}

\note{
\code{pathways} accept named characters, and then the output will have
the names
}
\examples{
if (require("reactome.db")){
    genes.react <- as.list(reactomeEXTID2PATHID)
    (pathways <- sample(unique(unlist(genes.react)), 10))
    mpathSim(pathways, genes.react, NULL)
    named_paths <- structure(
        c("R-HSA-112310", "R-HSA-112316", "R-HSA-112315"),
        .Names = c("Neurotransmitter Release Cycle",
                   "Neuronal System",
                   "Transmission across Chemical Synapses"))
    mpathSim(named_paths, genes.react, NULL)
} else {
    warning('You need reactome.db package for this example')
}
}
\seealso{
\code{\link{pathSim}} For single pairwise comparison.
\code{\link{conversions}} To convert the Dice similarity to Jaccard similarity
}
