% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mclusterSim.R
\docType{methods}
\name{mclusterSim}
\alias{mclusterSim}
\alias{mclusterSim,list,GeneSetCollection-method}
\title{Similarity score between clusters of genes based on pathways similarity}
\usage{
mclusterSim(clusters, info, method = "max", ...)

\S4method{mclusterSim}{list,GeneSetCollection}(clusters, info, method = "max",
  ...)
}
\arguments{
\item{clusters}{A list of clusters of genes to be found in \code{id}.}

\item{info}{A list or a GeneSetCollection of genes and the pathways they are
involved.}

\item{method}{one of \code{c("avg", "max", "rcmax", "rcmax.avg", "BMA",
"reciprocal")}, see Details.}

\item{...}{Other arguments passed to \code{combineScores}}
}
\value{
\code{mclusterSim} returns a matrix with the similarity scores for
each cluster comparison.
}
\description{
Looks for the similarity between genes in groups. Once the pathways for each
cluster are found they are combined using code{\link{combineScores}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{clusters = list,info = GeneSetCollection}: Calculates all the similarities of the GeneSetCollection
and combine them using \code{\link{combineScoresPar}}
}}

\examples{
if (require("org.Hs.eg.db")) {
    #Extract the paths of all genes of org.Hs.eg.db from KEGG (last update in
    # data of June 31st 2011)
    genes.kegg <- as.list(org.Hs.egPATH)

    clusters <- list(cluster1 = c("18", "81", "10"),
                     cluster2 = c("100", "10", "1"),
                     cluster3 = c("18", "10", "83"))
    mclusterSim(clusters, genes.kegg)
    mclusterSim(clusters, genes.kegg, "avg")
} else {
    warning('You need org.Hs.eg.db package for this example')
}
}
\seealso{
For a different approach see \code{\link{clusterGeneSim}},
\code{\link{combineScores}} and \code{\link{conversions}}
}
\author{
Lluís Revilla
}
