% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineSources.R
\name{combineSources}
\alias{combineSources}
\title{Combine different sources of pathways}
\usage{
combineSources(...)
}
\arguments{
\item{...}{Lists of genes and their pathways.}
}
\value{
A single list with the pathways of each source on the same gene.
}
\description{
Given several sources of pathways with the same for the same id of the genes
it merge them.
}
\details{
It assumes that the identifier of the genes are the same for both sources
but if many aren't equal it issues a warning. Only unique pathways
identifiers are returned.
}
\examples{
DB1 <- list(g1 = letters[6:8], g2 = letters[1:5], g3 = letters[4:7])
DB2 <- list(g1 = c("one", "two"), g2 = c("three", "four"),
         g3 = c("another", "two"))
combineSources(DB1, DB2)
combineSources(DB1, DB1)
DB3 <- list(g1 = c("one", "two"), g2 = c("three", "four"),
         g4 = c("five", "six", "seven"), g5 = c("another", "two"))
combineSources(DB1, DB3) # A warning is expected
}
