% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterSim.R
\docType{methods}
\name{clusterSim}
\alias{clusterSim}
\alias{clusterSim,character,character,GeneSetCollection-method}
\title{Similarity score between clusters of genes based on pathways similarity}
\usage{
clusterSim(cluster1, cluster2, info, method = "max", ...)

\S4method{clusterSim}{character,character,GeneSetCollection}(cluster1, cluster2,
  info, method = "max", ...)
}
\arguments{
\item{cluster1, cluster2}{A vector with genes.}

\item{info}{A list or a GeneSetCollection of genes and the pathways they are
involved.}

\item{method}{one of \code{c("avg", "max", "rcmax", "rcmax.avg", "BMA",
"reciprocal")}, see Details.}

\item{...}{Other arguments passed to \code{combineScores}}
}
\value{
\code{clusterSim} returns a similarity score of the two clusters
}
\description{
Looks for the similarity between genes in groups
}
\details{
Once the pathways for each cluster are found they are combined using
\code{\link{combineScores}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{cluster1 = character,cluster2 = character,info = GeneSetCollection}: Calculates all the similarities of the
GeneSetCollection and combine them using \code{\link{combineScoresPar}}
}}

\examples{
if (require("org.Hs.eg.db")) {
    #Extract the paths of all genes of org.Hs.eg.db from KEGG (last update in
    # data of June 31st 2011)
    genes.kegg <- as.list(org.Hs.egPATH)
    clusterSim(c("9", "15", "10"), c("33", "19", "20"), genes.kegg)
    clusterSim(c("9", "15", "10"), c("33", "19", "20"), genes.kegg, NULL)
    clusterSim(c("9", "15", "10"), c("33", "19", "20"), genes.kegg, "avg")
} else {
    warning('You need org.Hs.eg.db package for this example')
}
}
\seealso{
For a different approach see \code{\link{clusterGeneSim}},
\code{\link{combineScores}} and \code{\link{conversions}}
}
\author{
Lluís Revilla
}
