% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarities.R
\name{addSimilarities}
\alias{addSimilarities}
\title{Additive integration of similarities}
\usage{
addSimilarities(x, bio_mat, weights = c(0.5, 0.18, 0.1, 0.22))
}
\arguments{
\item{x}{A matrix with the similarity of expression}

\item{bio_mat}{A list of matrices of the same dimension as x.}

\item{weights}{A numeric vector of weight to multiply each similarity}
}
\value{
A square matrix of the same dimensions as the input matrices.
}
\description{
Function that use the previously calculated similarities into a single
similarity matrix.
}
\details{
The total weight can't be higher than 1 to prevent values above
1 but can be below 1. It uses weighted.sum with abs = TRUE internally.
}
\examples{
set.seed(100)
a <- seq2mat(LETTERS[1:5], rnorm(10))
b <- seq2mat(LETTERS[1:5], seq(from = 0.1, to = 1, by = 0.1))
sim <- list(b)
addSimilarities(a, sim, c(0.5, 0.5))
}
\seealso{
\code{\link{similarities}}, \code{\link{weighted}}.
}
\author{
Lluís Revilla
}
