% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AintoB.R
\name{AintoB}
\alias{AintoB}
\title{Insert a matrix into another}
\usage{
AintoB(A, B)
}
\arguments{
\item{A}{A matrix to be inserted.}

\item{B}{A matrix to insert in.}
}
\value{
A matrix with the values of A in the matrix B.
}
\description{
Insert values from a matrix into another matrix based on the rownames and
colnames replacing the values.
}
\details{
If all the genes with pathway information are already calculated but you
would like to use more genes when performing analysis. insert the once you
have calculated on the matrix of genes.
}
\examples{
B <- matrix(ncol = 10, nrow = 10,
    dimnames = list(letters[1:10], letters[1:10]))
A <- matrix(c(1:15), byrow=TRUE, nrow=5,
    dimnames = list(letters[1:5], letters[1:3]))
AintoB(A, B)

# Mixed orders
colnames(A) <- c("c", "h", "e")
rownames(A) <- c("b", "a", "f", "c", "j")
AintoB(A, B)

# Missing colums or rows
colnames(A) <- c("d", "f", "k")
AintoB(A, B)
}
\author{
Lluís Revilla
}
