/*
 ***** BEGIN LICENSE BLOCK *****
 * Version: EPL 1.0/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Eclipse Public
 * License Version 1.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.eclipse.org/legal/epl-v10.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * Copyright (C) 2013-2017 The JRuby Team (jruby@jruby.org)
 * 
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the EPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the EPL, the GPL or the LGPL.
 ***** END LICENSE BLOCK *****/
package org.jruby.ext.ripper;

public class YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

           88,   88,  134,  134,  377,  213,  675,  249,  249,  249, 
          575,  646,  275,  249,  249,  633,  426,  249,  227,  417, 
          304,  419,  307,  107,  306,  301,  323,  290,  290,  525, 
          229,  290,  351,  527,  464,  695,  287,  287,  227,  626, 
          287,  714,  673,   88,  639,  748,  259,  349,  639,  249, 
          229,  359,  291,  291,   83,   83,  291,  627,  690,  329, 
          486,  764,  766,  629,  701,  637,  133,  133,  642,  640, 
          723,  639,  704,    8,  214,  214,  133,  271,  439,  659, 
          714,  273,  947,    8,  330,  334,  713,  639,  575,  713, 
          288,  294,  674,  639,  295,  214,  303,  349,  255,  253, 
          256,  771,  809,  560,  639,  639,  629,  869,  637,  513, 
          432,  133,  434,  430,  353,  309,  639,  272,   86,  829, 
          214,  429,  674,  876,  300,  863,  249,  313,   88,  560, 
          760,  735,    8,  838, 1033,   72,  639,  639,  296,  259, 
          522,   74,  448,  560,   73,  522,  386,  254,  780,  890, 
          449,  902,  571,  639,  639,  738,  674,  909,  598,  106, 
          106,  133,  375,  379,  850,  639,  106,  106,  106,  375, 
          775,  299,  106,  106,  521,   86,  106,  499,  741,  524, 
          460,  674,  782,  372,  377,  375,  557,  411,  255,  380, 
          375,  558,   72,  639,  593,   71,  634,  378,  303,  408, 
          761,  575,  106,  639,  776,  342,  474,  639,  106,  431, 
          309,  435,  566,  822,  634,  300,  653,  560,  373,  376, 
          374,  773, 1033,  832,  563,  564,  314,  566,  593,  808, 
          299,   88,  748,  860,  437,  947,  408,  254,  438,  431, 
          814,   53,  508,  593,  376,  500,  501,  575,  535,  536, 
          583,  376,  639,  408,  342,  538,  965,  364,  249,  249, 
          543,  366,  575,  486,  574,  529,  560,  376,  565,  408, 
          821,  585,  466,  465,  714,  802,  255,  566,  370,  574, 
          533,  372,  413,  421,  583,  106,  585,  106,  545,  414, 
          418,  259,  846,  573,  249,  411,  249,  249,  323,  583, 
          249,  869,  249,  422,  392,   83,   75,   88,  290,  423, 
          290,  566,  427,   88,  876,   88,  428,  287,  575,  287, 
          287,  713,  713,   81,  249,  254,  566,  573,  516,   61, 
           62,   63,   64,  291,  817,  291,  515,  545,   79,  550, 
          383,  384,  573,  752,  551,  748,  349,  748,  303,  469, 
          470,  443,  950,   72,  259,  302,   83,   75,  639,  639, 
          955,  957,  917,  959,  639,  960,  639,  511,  451,  698, 
          454,  487,  440,  490,   81,  560,  249,  249,  249,  249, 
           88,  249,  249,  639,  461,  284,  560,  646,  462,   79, 
          106,  672,  247,  247,  247,   92,   92,  135,  135,  961, 
          443,  640,  626,  639,  640,  323,  969,  276,  655,  271, 
          133,  973,  271,  273,  249,  639,  273,  106,  106,  249, 
          627,  249,   88,  349,  915,  249,  249,  302,   88,  639, 
          848,  748, 1017,  939,  596,  652,    8,  287,   92,  652, 
          639,  249,  350,   88,  249,  560,  386,  309,  639,  272, 
          663,  529,  272,  106,   88,  106,  106,  249,  598,  106, 
          812,  106,   88,  463,  287, 1007,  106,  592,  593,  594, 
          595,  249,  106,   74,  106,  560,   73,  835,  696,  986, 
          287,  842,   83,  106,  643,  638,  647,  133,  638,  593, 
          657,  661,  350,  466,  287,  379,  714,  475, 1082,  721, 
          748,  249,  748,   88,  700,  700, 1009, 1049, 1051, 1052, 
         1053,  436,  638,  227,   88,  372,  377,  535,  536,  712, 
          639,  380,  375,   92,  538,  229,  593,  566,  638,  378, 
          249,  468,  349,  455,  748,  106,  106,  106,  106,  106, 
          106,  106,  638,  593,  713,  583,   17,  639, 1038, 1060, 
          373,  376,  374,  287,   95,   95,  598,   83,  731,  593, 
          535,  536,  575,  639,  575, 1084,  277,  538,  824,  821, 
          214,  529,  566,  106,   83,   75,  638,  639,  106,  574, 
          106,  106,  583,  545,  106,  106,  585,  106,  573,  102, 
          102,  471,   81,  563,  564,   17,  133,   95,  482,  583, 
          106,  638,  106,  106,  392,  598,   76,   79,  443,  566, 
           84,  639,  842,  106,  255,  583,  106,  588,  781,  639, 
          545,  106,  589,  639,  481,  573,   92,  788,  383,  384, 
          106,  505,  102,  786,  639,  639,  639,   83,   75,  385, 
         1069,  792,  566,  247,  247,   77,  795,  485,  834,  849, 
          639,  385,  349,  545,  122,   81,   82,   76,  573,  509, 
          106,   84,  106,  254,   80,  249,   88,  788,  639,  944, 
           79,  400,  514,  106,  510,  402,  403,   88,  816,  815, 
          443,  474,   95,  526,  788,  496,  474,  498,   78,  106, 
          674,  520,  227,  534,  652,  639,   77,  528,  788,  639, 
          656,  806,   92,  122,  229,  249, 1004,   82,   92,  519, 
           92,  639, 1006,  813,  664,   80,  133,  102,  545,  503, 
          529,  852,  853,  103,  854,   88,  910,  639,  639,  788, 
          349,  476,  785,  639,  549,  433,  476,  509,  584,   78, 
          791,  350,  874,  587,  682,  791,  687,  685,  214,  214, 
          697,  716,  509,  717,  843, 1015,  807,  718,   88,   88, 
          639,  247,  247,  247,  247,  724,  597,  598,  416,   96, 
          433,  732,  727,  743,  785,   92,   88,  791,   88,   83, 
           88,  249,  249,  744,  509,   95,  753,  249,  249,   59, 
           60,  754,  755,  757,  133,  763,  839,  249,   17,   17, 
           17,  349,  765,  767,   17,   17,  769,   17,  770,  535, 
          536,  537,  774,  783,  328,  332,  538,   92,  350,   88, 
          102,  107,  249,   92,  106,  106, 1047,  784,  789,  676, 
          790,  116,  859,   88,   88,   88,  106,  799,   92,  800, 
          512,  803,  919,   97,  810,  821,  898,  900,   16,   92, 
          827,  598,  905,  907,  828,  512,  830,   92, 1076,  831, 
          497,   95,  647,  833,  106,  133,  845,   95,  312,   95, 
          861,  455,  639,  639,  700,   76,   96,  896,   17,   84, 
          116,  903,  517,  518,  106,  443,  722,  512,  598,  904, 
          515,  977,  920,  535,  536,  540,  102,   16,   92,   17, 
          538,  249,  102,   91,  102,  922,  924,  639,  928,   92, 
          933,  122,  515,  931,   77,   88,   88,  106,  106,  932, 
          940,  598, 1001,  514,  433,   82,   88,  350,  874,  934, 
          945,   17, 1042,   80,   95,  106,  941,  106,   76,  106, 
          106,  106,   84,  948,  949,  874,  106,  106,  951,   97, 
          509,  952,  205,  953,  639,  133,  106,   78,  122,  433, 
         1023,  954,  956,  639,  639,  639,  982,  958,  962,  102, 
          639,  963,  433,  610,  966,  651,   95,   77,  106,  433, 
          433,  106,   95,   97,  968,   88,  133,  970,   82,  972, 
          978, 1014,  106,  106,  106,  979,   80,   95, 1016,  981, 
           97,  205,   88,  639,   88,  413,  433,  433,   95, 1010, 
           88,  102,  414,  415,  433,  433,   95,  102, 1011, 1026, 
           78,  509, 1034, 1048,  133, 1036, 1037, 1039,  509,  509, 
          515, 1050,  102,  874,  610, 1054,   96, 1056, 1058,  249, 
         1061,  433,  639,  102,   88,  715, 1066,  350, 1074, 1086, 
          247,  102,  509,  719,  720,  610,  126,   95, 1083,  639, 
          106,   92,  287,  788,  626,  110,  492,  639,   95,  628, 
           96,  728,   92,  627,  106,  106,  611,  632,  116,  628, 
          628,  318,  632,  459,  634,  106,  639,   96,  116,  628, 
          247,  639,  102,  115,  745,  639,  553,  554,  555,  556, 
           16,   16,   16,  102,  374,  312,   16,   16,  639,   16, 
          638,  115,  312,  312,  110,  473,  362,  514,  614,  479, 
           92,  586,  413,  137,  512,  350,  729,  515,  216,  414, 
          442,  512,  512,  856,  515,  515, 1073,  611,  110,  610, 
          459,  864,  115,  796,  106,  639,  509,  987,  873,  515, 
          885,  877, 1028,   92,   92,  512,  515,  515,  611,  878, 
          514,  106,  884,  106, 1029,   91,  318,  514,  514,  106, 
          278,   92,  911,   92,  514,   92,  858, 1018,    0,  872, 
           16,  875, 1072,  492,  535,  536,  540,  509,  532,    0, 
            0,  538,  882,    0,  509,  509,  350,    0,  106,   91, 
          610,   16,    0,  106,    0,    0,    0,  247,  639,  708, 
          492,  801,    0,  639,   92,  639,   91,    0,   97,  683, 
           95,  610,  126,    0,    0,    0,  492,    0,   92,   92, 
           92,   95,    0,   16,  811,  757,    0,    0,    0,   51, 
          492,    0,    0,  103,    0,    0,  509,    0,  205,   51, 
          205,  205,  205,  205,  205,  102,    0,    0,    0,  205, 
          745,    0,  553,  554,  555,  556,  102,  515,    0,    0, 
          515,  126,   96,    0,  515,  515,    0,  103,  515,   95, 
          844,   97,  205,  205,    0,    0,  135,    0,  847,    0, 
          205,  205,  205,  205,  103,    0,  639,  113,   51,  492, 
          639,  639,    0,  312,    0,   96,    0,    0,    0,  862, 
           92,   92,   95,   95,  102,  443,  422, 1002, 1041,    0, 
          413,   92,  110,    0,  433,    0,  422,  414,  458,    0, 
           95,    0,   95,    0,   95,  610,  205,    0,  758,    0, 
         1019,    0, 1021,    0, 1022,  506,  113,  102,  102, 1024, 
          115,  651,  413,  318,  514,  135, 1032,  779,  779,  414, 
          472,  514,  514,    0,    0,  102,    0,  102,   96,  102, 
          921,    0, 1020,   95,    0,  422,    0,  413,  512,    0, 
           92,   98, 1027,  509,  414,  507, 1031,   95,   95,   95, 
          509,  509,  779,    0,  286,  286,  610,   92,  286,   92, 
            0,   99,    0,    0,  794,   92,    0,  101,  102,  794, 
          866,  514,  553,  554,  555,  556,  943,  610,  514,  514, 
          310,  312,  102,  102,  102,  413,  286,  286,  516,  352, 
          354,    0,  414,  531,   91,  610, 1077,    0,    0,   92, 
            0,  794, 1078,    0, 1080,    0,    0, 1081,  517,  820, 
          331,  823,   53,  823,  519,    0,    0,  535,  536,  542, 
          318,  823,   53,   55,  538,    0,    0,    0,    0,   95, 
           95,  100, 1090,   55, 1079,    0, 1003,    0,    0,  126, 
           95,    0,  881,  509,  553,  554,  555,  556,  557,    0, 
          509,  509,  686,  558,   96,  117,  610,   91,    0,    0, 
          694,   51,   51,   51,  102,  102,   51,   51,   51,    0, 
           51,   53,  103,  433,    0,  102,  559,  610,  518,  758, 
           51,    0,   55,    0,  561,  562,  563,  564,    0,   51, 
           51,    0,   51,   51,   51,   51,   51,    0,    0,   95, 
          312,    0,    0,  758,  117,    0,    0,  312,  312,    0, 
            0,    0,  413,  614,  113,  413,   95,    0,   95,  414, 
         1035,  433,  414, 1040,   95,    0,    0,  611,  433,  433, 
          565,    0,  779,    0,  102,  103,  516,    0,  422,  422, 
          422,   51,    0,  422,  422,  422,  926,  422,    0,  930, 
            0,  102,    0,  102,  198,  433,    0,  422,   95,  102, 
            0,    0,   51,    0,    0,    0,  422,  422,    0,  422, 
          422,  422,  422,  422,    0,  512,  117,  535,  536,  546, 
          118,    0,  512,  512,  538,  535,  536,  585,  611,  107, 
            0,    0,  538,  102,   51,    0,  118,    0,  480,  480, 
          480,    0,  120,  198,  422,  480,  284,    0,  124,  611, 
          758,  422,  422,    0,    0,    0,  284,    0,  422,  286, 
          286,  286,  354,  107,  286,  516,    0,    0,    0,  118, 
            0,    0,  516,  516,    0,  286,    0,  286,  286,  422, 
          107,    0,  476,  477,  478,  517,  504,  480,    0,    0, 
          284,  519,  517,  517,    0,    0,    0,  124,  519,  519, 
            0,  517,    0,  823,    0,  284,  119,    0,    0,    0, 
          312,  422,    0,    0,   53,   53,   53,    0,    0,   53, 
           53,   53,    0,   53,    0,   55,   55,   55,    0,  617, 
           55,   55,   55,   53,   55,  378,  379,  380,  381,  382, 
            0,    0,   53,   53,   55,   53,   53,   53,   53,   53, 
            0,    0,  117,   55,   55,  518,   55,   55,   55,   55, 
           55,    0,  518,  518,  599,  600,  601,  602,  603,  604, 
          605,  606,  607,  608,  609,  610,  611,  612,  613,  614, 
          615,  616,  617,  618,  619,  620,  621,  622,  623,  624, 
            0,  462,  462,  462,   53,  286,  870,  871,  462,   98, 
          644,  102,  648,    0,  208,   55,  286,  662,  492,    0, 
          683,  823,    0,  516,  894,   53,  895,    0,  897,    0, 
          516,  516,  286,    0,    0,  650,   55,    0,    0,  660, 
            0,    0,  745,   98,  553,  554,  555,  556,  286,    0, 
          644,  693,  662,    0,    0,  286,    0,   53,  520,    0, 
           98,    0,  286,  208,    0,    0,    0,  927,   55,    0, 
          286,  286,    0,    0,  286,    0,  746,    0,  650,    0, 
            0,  936,  937,  938,  747,    0,    0,  118,    0,    0, 
          516,    0,    0,  709,  711,    0,    0,  331,  725,  726, 
          198,    0,  198,  198,  198,  198,  198,    0,  107,  120, 
          286,  198,  119,  286,    0,  124,    0,    0,  284,  284, 
          284,  286,  514,  284,  284,  284,    0,  284,  617,    0, 
          514,    0,    0,  711,  198,  198,  331,  284,  284,    0, 
            0,   99,  198,  198,  198,  198,  284,  284,  517,  284, 
          284,  284,  284,  284,    0,  517,  517,  312,  120,    0, 
            0,  119,    0,  985,  312,  312,  468,  468,  468,    0, 
          614,  107,  286,  468, 1005,   99,  617,    0,    0,    0, 
            0,  242,  121,  617,  617,    0,    0,    0,  198,  613, 
          519,  242,   99,  518,    0,  772,    0,    0,  284,    0, 
            0,  284,    0,  284,    0,    0,  617,  541,    0,  544, 
          617,  547,  112,    0,    0,    0,    0,  547,    0,  284, 
          292,  617,  517,  123,    0,  242,    0,    0,    0,    0, 
          292,  121,    0,  745,  286,  553,  554,  555,  556,  242, 
          242,    0,    0,    0,  242,    0,  121,    0,    0,    0, 
         1043,  284, 1044,  617,    0,    0,    0,  797, 1045,    0, 
            0,  112,    0,  520,  285,    0,   94,  746,    0,    0, 
          125,  286,  123,    0,    0,  946,    0,    0,   98,  292, 
          626,  626,  626,    0,    0,    0,  626,  626,    0,  626, 
          312,    0, 1075,  511,  818,  520,    0,  286,    0,  286, 
           94,    0,  520,  520,  613,  312,  286,  286,    0,    0, 
          208,    0,  208,  208,  208,  208,  208,   94,    0,  125, 
          840,  208,  841,    0,    0,  541,  385,  516,   93,  711, 
          331,    0,  516,  286,  516,  516,    0,  312,    0,    0, 
          516,   98,  398,  399,  208,  208,    0,  512,    0,    0, 
            0,  614,  208,  208,  208,  208,  857,    0,  400,    0, 
          626,    0,  402,  403,  404,  405,  120,  385,    0,  119, 
          509,    0,  899,  901,    0,  511,    0,    0,  906,  908, 
          509,  626,    0,  398,  399,    0,    0,  912,  693,  286, 
            0,    0,    0,  916,  742,    0,    0,    0,  208,  400, 
            0,  401,    0,  402,  403,  404,  405,    0,    0,  408, 
           99,  409,  914,  626,  509,    0,  899,  901,    0,  906, 
          908,    0,    0,  286,    0,    0,    0,  519,  509,  509, 
          518,  110,  742,  509,  519,  519,    0,  518,  518,  121, 
            0,    0,  617,  242,  242,  242,  935,    0,  242,  242, 
          242,    0,  242,    0,    0,    0,    0,    0,    0,  517, 
            0,  509,  242,  242,    0,    0,  517,  517,    0,  112, 
            0,  242,  242,   99,  242,  242,  242,  242,  242,    0, 
          123,    0,  292,  292,  292,  980,  242,  292,  292,  292, 
          617,  292,  983,  613,    0,    0,    0,  617,  617,    0, 
          520,    0,  286,  613,    0,  242,  242,  520,  520,  512, 
          242,  242,    0,  292,  292,  292,  292,  292,    0,  512, 
          242,  617,  983,  242,  617,  984,  242,  125,  242,  286, 
          511,    0,    0,    0,    0,   94,  611,  511,  511,    0, 
          614,  613,    0,    0,  242,    0,    0,    0,  613,  613, 
            0,    0,  331,  512,  613,    0,  242,    0,    0,  292, 
            0,    0,  292,  112,    0,    0,    0,  512,  512,    0, 
          113,  385,  512,    0,  312,  613,  242,    0,    0,    0, 
            0,  312,  312,  292,  512,    0,    0,  614,  614,    0, 
            0,  512,  512,    0,    0,  614,  614,  611,   94,    0, 
          512,  614,    0,  400,    0,  312,    0,  402,  403,  404, 
          405,    0,  511,    0,    0,  292,    0,    0,  611,  511, 
          511,  193,  614,    0,    0,    0,    0,  610,  610,  610, 
          286,  610,  509,  509,  509,  610,  610,  509,  509,  509, 
          610,  509,  610,  610,  610,  610,  610,  610,  610,    0, 
          610,  509,  509,  610,  610,  610,  610,  610,  610,  610, 
          509,  509,  610,  509,  509,  509,  509,  509,    0,  610, 
          193,    0,  610,  610,  610,  509,  610,  610,  610,  610, 
          610,  610,  610,  610,  610,  610,  610,  509,  509,  509, 
          509,  509,  509,  509,  509,  509,  509,  509,  509,  509, 
          509,   94,    0,  509,  509,  509,  509,  610,  521,  509, 
          610,  610,  509,  610,  610,  509,  610,  509,  610,  509, 
          610,  509,  610,  509,  509,  509,  509,  509,  509,  509, 
          610,  509,  610,  509,    0,  610,  610,  610,  610,  610, 
          610,  105,    0,    0,  610,  509,  610,  610,  512,  610, 
          610,  610,  610,    0,    0,    0,    0,    0,    0,    0, 
          111,    0,  610,  610,  610,  509,  611,  611,  611,    0, 
          611,  512,  512,  512,  611,  611,  512,  512,  512,  611, 
          512,  611,  611,  611,  611,  611,  611,  611,  617,  611, 
          512,  512,  611,  611,  611,  611,  611,  611,  611,  512, 
          512,  611,  512,  512,  512,  512,  512,    0,  611,  111, 
          893,  611,  611,  611,  512,  611,  611,  611,  611,  611, 
          611,  611,  611,  611,  611,  611,  512,  512,  512,  512, 
          512,  512,  512,  512,  512,  512,  512,  512,  512,  512, 
           92,  510,  512,  512,  512,  512,  611,  524,  512,  611, 
          611,  512,  611,  611,  512,  611,  512,  611,  512,  611, 
          512,  611,  512,  512,  512,  512,  512,  512,  512,  611, 
          512,  611,  512,    0,  611,  611,  611,  611,  611,  611, 
            0,    0,  617,  611,  512,  611,  611,  510,  611,  611, 
          611,  611,  617,  745,    0,  553,  554,  555,  556,    0, 
            0,  611,  611,  611,  512,  967,  627,  627,  627,  971, 
            0,    0,  627,  627,    0,  627,    0,  193,    0,  193, 
          193,  193,  193,  193,    0,    0,  617,  746,  193,    0, 
            0,    0,  385,    0,    0,    0,  113,  611,    0,  517, 
          617,  617,    0,  124,    0,  617,    0,  517,  398,  399, 
            0,  193,  193,    0,    0,    0,    0,    0,    0,  193, 
          193,  193,  193,    0,  400,    0,  401,    0,  402,  403, 
          404,  405,    0,  617,    0,    0,  124,  617,  745,    0, 
          553,  554,  555,  556,  557,  512,  627,    0,    0,  558, 
            0,    0,  512,  512,    0,    0,    0,  893,  611,    0, 
          893,    0,  893,    0,  893,  193,    0,  627,    0,    0, 
            0,    0,  559,    0,    0,    0,    0,  111,    0,  611, 
            0,  613,  563,  564,    0,  617,    0,    0,    0,    0, 
            0,  613,  617,  617,    0,    0,    0,    0,  613,  627, 
            0,    0,    0,    0,    0, 1055,    0,    0, 1057, 1059, 
            0,    0, 1062, 1063,    0,    0,    0,    0,    0,  617, 
            0,    0,    0,    0,    0,  613,  565,    0,    0,    0, 
            0,    0,    0,    0,    0,  111,    0,    0,  510,  613, 
          613,    0,  123,    0,  613,  510,  510,    0,  893,    0, 
          893,    0,  893,    0,    0,  893,    0,    0,    0, 1085, 
         1087, 1088, 1089,    0,    0,    0,    0,    0,    0,    0, 
            0, 1091,  613,    0,    0,    0,    0,    0,    0,    0, 
          893,    0,    0,    0,  510,    0,    0,    0,    0,    0, 
            0,  510,  510,  175,    0,    0,    0,    0,    0,  613, 
          613,  613,    0,  613,  617,  617,  617,  613,  613,  617, 
          617,  617,  613,  617,  613,  613,  613,  613,  613,  613, 
          613,    0,  617,  617,  617,  613,  613,  613,  613,  613, 
          613,  613,  617,  617,  613,  617,  617,  617,  617,  617, 
            0,  613,  175,    0,  613,  613,  613,  617,  613,  613, 
          613,  613,  613,  613,  613,  613,  613,  613,  613,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  104,    0,  617,  617,  617,  617,  613, 
          176,  617,  613,  613,  617,  613,  613,  617,  613,  617, 
          613,  617,  613,  617,  613,  617,  617,  617,  617,  617, 
          617,  617,  613,  617,  617,  617,    0,  613,  613,  613, 
          613,  613,  613,   95,    0,    0,  613,  617,  613,  613, 
          613,  613,  613,  613,  613,    0,    0,    0,    0,  176, 
            0,    0,  114,    0,  613,  613,  613,  617,  613,  613, 
          613,    0,  613,  613,  613,  613,  613,  613,  613,  613, 
          613,  613,  613,  613,  613,  613,  613,  613,  613,  613, 
          513,  613,  613,  613,  613,  613,  613,  613,  613,  613, 
          613,  613,  613,  613,  613,  613,  613,  613,  613,    0, 
          613,  114,    0,  613,  613,  613,  613,  613,  613,  613, 
          613,  613,  613,  613,  613,  613,  613,  613,  613,  613, 
          613,  613,  613,  613,  613,  613,  613,  613,  613,  613, 
          613,  613,  109,  513,  613,  613,  613,  613,  613,    0, 
          613,  613,  613,  613,  613,  613,  613,  613,  613,  613, 
          613,  613,  613,  613,  613,  613,  613,  613,  613,  613, 
          613,  613,  613,  613,  613,    0,  613,  613,  613,  613, 
          613,  613,    0,    0,  614,  613,  613,  613,  613,  302, 
          613,  613,  613,  613,  614,    0,    0,    0,    0,    0, 
            0,    0,    0,  613,  613,  613,  613,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  175, 
            0,  175,  175,  175,  175,  175,    0,    0,  614,    0, 
          175,    0,    0,    0,    0,    0,    0,    0,  123,  613, 
            0,  519,  614,  614,    0,  125,    0,  614,    0,  519, 
            0,    0,    0,  175,  175,    0,    0,    0,    0,    0, 
            0,  175,  175,  175,  175,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  614,    0,    0,  114,    0, 
            0,    0,    0,    0,    0,    0,    0,  613,    0,    0, 
            0,    0,    0,    0,  613,  613,    0,    0,    0,    0, 
          613,    0,    0,    0,    0,    0,  176,  175,  176,  176, 
          176,  176,  176,    0,    0,    0,    0,  176,    0,  114, 
            0,  613,    0,  303,    0,    0,    0,  513,  518,    0, 
            0,    0,    0,  303,  513,  513,  518,    0,    0,    0, 
          176,  176,    0,    0,    0,    0,    0,    0,  176,  176, 
          176,  176,    0,    0,    0,    0,    0,    0,    0,  385, 
          386,  387,  388,  389,  390,  391,  392,  303,  394,  395, 
            0,    0,    0,    0,    0,  398,  399,  128,    0,    0, 
          513,  303,  303,    0,    0,    0,  303,  513,  513,    0, 
            0,  400,    0,  401,  176,  402,  403,  404,  405,  406, 
          407,  408,    0,  409,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  303,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  302,    0,    0,    0, 
            0,    0,    0,  302,  302,  177,    0,    0,    0,    0, 
            0,  614,  614,  614,    0,  614,  614,  614,  614,  614, 
          614,  614,  614,  614,  614,  614,  614,  614,  614,  614, 
          614,  614,  614,    0,  614,  614,  614,  614,  614,  614, 
          614,  614,  614,  614,  614,  614,  614,  614,  614,  614, 
          614,  614,    0,  614,  177,    0,  614,  614,  614,  614, 
          614,  614,  614,  614,  614,  614,  614,  614,  614,  614, 
          614,  614,  614,  614,  614,  614,  614,  614,  614,  614, 
          614,  614,  614,  614,  614,  106,    0,  614,  614,  614, 
          614,  614,  134,  614,  614,  614,  614,  614,  614,  614, 
          614,  614,  614,  614,  614,  614,  614,  614,  614,  614, 
          614,  614,  614,  614,  614,  614,  614,  614,    0,  614, 
          614,  614,  614,  614,  614,  108,    0,    0,  614,  614, 
          614,  614,  614,  614,  614,  614,  614,    0,    0,    0, 
            0,  134,    0,    0,  128,    0,  614,  614,  614,  614, 
          612,  612,  612,    0,  612,  303,  303,  303,  612,  612, 
          303,  303,  303,  612,  303,  612,  612,  612,  612,  612, 
          612,  612,  313,  612,  303,  303,  612,  612,  612,  612, 
          612,  612,  612,  303,  303,  612,  303,  303,  303,  303, 
          303,    0,  612,  128,    0,  612,  612,  612,  303,  612, 
          612,  612,  612,  612,  612,  612,  612,  612,  612,  612, 
          303,  303,  303,  303,  303,  303,  303,  303,  303,  303, 
          303,  303,  303,  303,    0,  302,  303,  303,  303,  303, 
          612,    0,  303,  612,  612,  303,  612,  612,  303,  612, 
          303,  612,  303,  612,  303,  612,  303,  303,  303,  303, 
          303,  303,  303,  612,  303,  612,  303,    0,  612,  612, 
          612,  612,  612,  612,    0,    0,  618,  612,  303,  612, 
          612,    0,  612,  612,  612,  612,  618,    0,    0,    0, 
            0,    0,    0,    0,    0,  612,  612,  612,  303,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  177,    0,  177,  177,  177,  177,  177,    0,    0, 
          618,    0,  177,    0,    0,    0,    0,    0,    0,    0, 
          125,  614,    0,  520,  618,  618,    0,    0,    0,  618, 
            0,  520,    0,    0,    0,  177,  177,    0,    0,    0, 
            0,    0,    0,  177,  177,  177,  177,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  618,    0,    0, 
          127,    0,    0,    0,    0,    0,    0,    0,    0,  614, 
            0,    0,    0,    0,    0,    0,  614,  614,    0,    0, 
            0,    0,  614,    0,    0,    0,    0,    0,  134,  177, 
          134,  134,  134,  134,  134,    0,    0,    0,    0,  134, 
            0,  128,    0,  614,    0,  619,    0,    0,    0,  313, 
          509,    0,    0,    0,    0,  619,  313,  313,  509,    0, 
            0,    0,  134,  134,    0,    0,    0,    0,    0,    0, 
          134,  134,  134,  134,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  619, 
          385,  386,  387,  388,  389,  390,  391,  392,  393,  394, 
          395,    0,  302,  619,  619,    0,  398,  399,  619,  302, 
          302,    0,    0,    0,    0,    0,  134,    0,    0,    0, 
            0,    0,  400,    0,  401,    0,  402,  403,  404,  405, 
          406,  407,  408,    0,  409,    0,  619,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  135,    0,    0, 
            0,    0,    0,  615,  615,  615,    0,  615,  618,  618, 
          618,  615,  615,  618,  618,  618,  615,  618,  615,  615, 
          615,  615,  615,  615,  615,    0,  618,  618,  618,  615, 
          615,  615,  615,  615,  615,  615,  618,  618,  615,  618, 
          618,  618,  618,  618,    0,  615,  135,    0,  615,  615, 
          615,  618,  615,  615,  615,  615,  615,  615,  615,  615, 
          615,  615,  615,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,    0,    0,  618, 
          618,  618,  618,  615,    0,  618,  615,  615,  618,  615, 
          615,  618,  615,  618,  615,  618,  615,  618,  615,  618, 
          618,  618,  618,  618,  618,  618,  615,  618,  618,  618, 
            0,  615,  615,  615,  615,  615,  615,    0,    0,    0, 
          615,  618,  615,  615,    0,  615,  615,  615,  615,  348, 
            0,    0,    0,    0,    0,    0,    0,    0,  615,  615, 
          615,  618,  616,  616,  616,    0,  616,  619,  619,  619, 
          616,  616,  619,  619,  619,  616,  619,  616,  616,  616, 
          616,  616,  616,  616,    0,  619,  619,  619,  616,  616, 
          616,  616,  616,  616,  616,  619,  619,  616,  619,  619, 
          619,  619,  619,    0,  616,    0,    0,  616,  616,  616, 
          619,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  619,  619,  619,  619,  619,  619,  619,  619, 
          619,  619,  619,  619,  619,  619,    0,    0,  619,  619, 
          619,  619,  616,    0,  619,  616,  616,  619,  616,  616, 
          619,  616,  619,  616,  619,  616,  619,  616,  619,  619, 
          619,  619,  619,  619,  619,  616,  619,  619,  619,    0, 
          616,  616,  616,  616,  616,  616,    0,    0,  312,  616, 
          619,  616,  616,    0,  616,  616,  616,  616,  312,  385, 
            0,    0,    0,    0,  390,  391,    0,  616,  616,  616, 
          619,    0,    0,    0,    0,  398,  399,    0,    0,    0, 
            0,    0,    0,  135,    0,  135,  135,  135,  135,  135, 
            0,  400,  312,  401,  135,  402,  403,  404,  405,  406, 
          407,  408,    0,  409,    0,  512,  312,  312,    0,  126, 
            0,  312,    0,  512,    0,    0,    0,  135,  135,    0, 
            0,    0,    0,    0,    0,  135,  135,  135,  135,    0, 
            0,    0,    4,    5,    6,    0,    8,    0,    0,  312, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          108,  109,   17,   18,    0,    0,    0,    0,  110,  111, 
          112,  335,  336,  337,  338,    0,    0,  117,    0,    0, 
            0,  135,    0,    0,  118,    0,    0,  339,  340,  341, 
            0,  342,   35,  343,  344,  345,  346,  432,   40,    0, 
            0,  127,    0,    0,    0,    0,    0,  432,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  347,    0,    0,  130,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  432,    0,    0,    0,    0,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,  432,    0,    0,   58, 
          432,   59,   60,    0,   61,   62,   63,   64,  552,    0, 
          553,  554,  555,  556,  557,    0,    0,   65,   66,  558, 
            0,    0,    0,    0,    0,    0,    0,    0,  432,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  559,  560,    0,    0,    0,    0,    0,    0, 
          561,  562,  563,  564,    0,  614,  614,  614,    0,  614, 
          312,  312,  312,  614,  614,  312,  312,  312,  614,  312, 
          614,  614,  614,  614,  614,  614,  614,    0,    0,  312, 
          312,  614,  614,  614,  614,  614,  614,  614,  312,  312, 
          614,  312,  312,  312,  312,  312,  565,  614,    0,    0, 
          614,  614,  614,  312,  614,  614,  614,  614,  614,  614, 
          614,  614,  614,  614,  614,  312,  312,  312,  312,  312, 
          312,  312,  312,  312,  312,  312,  312,  312,  312,    0, 
            0,  312,  312,  312,  312,  614,    0,  312,  614,  614, 
          312,  614,  614,  312,  614,  312,  614,  312,  614,  312, 
          614,  312,  312,  312,  312,  312,  312,  312,  614,  312, 
            0,  312,    0,  614,  614,  614,  614,  614,  614,    0, 
            0,    0,  614,  312,  614,  614,  880,  614,  614,  614, 
          614,  654,    0,    0,    0,  892,    0,    0,    0,    0, 
          614,  614,  614,  312,  279,  279,  279,    0,  279,  432, 
          432,  432,  279,  279,  432,  432,  432,  279,  432,  279, 
          279,  279,  279,  279,  279,  279,    0,  432,  432,  432, 
          279,  279,  279,  279,  279,  279,  279,  432,  432,  279, 
          432,  432,  432,  432,  432,    0,  279,    0,    0,  279, 
          279,  279,    0,  279,  279,  279,  279,  279,  279,  279, 
          279,  279,  279,  279,  432,  432,  432,  432,  432,  432, 
          432,  432,  432,  432,  432,  432,  432,  432,    0,    0, 
          432,  432,  432,  432,  279,    0,  432,  279,    0,  432, 
          279,  279,  432,  279,  432,  279,  432,  279,  432,  279, 
          432,  432,  432,  432,  432,  432,  432,  279,  432,  432, 
          432,    0,  279,  279,  279,  279,  279,  279,    0,    0, 
          639,  279,    0,  279,  279,    0,  279,  279,  279,  279, 
          639,    0,    0,    0,    0,    0,    0,    0,    0,  279, 
          279,  279,  432,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  552,    0,  553,  554, 
          555,  556,  557,    0,  639,    0,    0,  558,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  639, 
            0,    0,  892,  639,    0,  892,    0, 1030,    0,  892, 
          559,  677,    0,    0,    0,    0,    0,    0,  561,  562, 
          563,  564,    0,    0,    4,    5,    6,    0,    8,    0, 
            0,  639,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  108,  109,   17,   18,    0,    0,    0,    0, 
          110,  111,  112,  335,  336,  337,  338,    0,    0,  117, 
            0,    0,    0,    0,  565,    0,  118,    0,    0,  339, 
          340,  341,    0,  342,   35,  343,  344,  345,  346,  319, 
           40,    0,    0,  127,    0,    0,    0,    0,    0,  319, 
            0,    0,    0,  892,    0,  892,    0,  892,    0,    0, 
          892,    0,    0,    0,  347,    0,    0,  130,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  319,    0,  892,    0,    0,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,  319,    0, 
            0,   58,  319,   59,   60,    0,   61,   62,   63,   64, 
          552,    0,  553,  554,  555,  556,  557,    0,    0,   65, 
           66,  558,    0,    0,    0,    0,    0,    0,    0,    0, 
          319,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  559,    0,    0,    0,    0,    0, 
            0,    0,  561,  562,  563,  564,    0,  279,  279,  279, 
            0,  279,  639,  639,  639,  279,  279,  639,  639,  639, 
          279,  639,  279,  279,  279,  279,  279,  279,  279,    0, 
          639,  639,  639,  279,  279,  279,  279,  279,  279,  279, 
          639,  639,  279,  639,  639,  639,  639,  639,  565,  279, 
            0,    0,  279,  279,  279,    0,  279,  279,  279,  279, 
          279,  279,  279,  279,  279,  279,  279,  639,  639,  639, 
          639,  639,  639,  639,  639,  639,  639,  639,  639,  639, 
          639,  258,    0,  639,  639,  639,  639,  279,    0,  639, 
          279,  258,  639,  279,  279,  639,  279,  639,  279,  639, 
          279,  639,  279,  639,  639,  639,  639,  639,  639,  639, 
          279,  639,  639,  639,    0,  279,  279,  279,  279,  279, 
          279,    0,    0,    0,  279,  258,  279,  279,    0,  279, 
          279,  279,  279,    0,    0,    0,    0,    0,    0,  258, 
          258,    0,  279,  279,  279,  639,  279,  279,  279,    0, 
          279,  319,  319,  319,  279,  279,  319,  319,  319,  279, 
          319,  279,  279,  279,  279,  279,  279,  279,    0,    0, 
          319,  319,  279,  279,  279,  279,  279,  279,  279,  319, 
          319,  279,  319,  319,  319,  319,  319,    0,  279,    0, 
            0,  279,  279,  279,    0,  279,  279,  279,  279,  279, 
          279,  279,  279,  279,  279,  279,  319,  319,  319,  319, 
          319,  319,  319,  319,  319,  319,  319,  319,  319,  319, 
            0,    0,  319,  319,  319,  319,  279,    0,  319,  279, 
            0,  319,  279,  279,  319,  279,  319,  279,  319,  279, 
          319,  279,  319,  319,  319,  319,  319,  319,  319,  279, 
          319,  509,  319,    0,  279,  279,  279,  279,  279,  279, 
            0,  509,    0,  279,    0,  279,  279,    0,  279,  279, 
          279,  279,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  279,  279,  279,  319,  881,    0,  553,  554,  555, 
          556,  557,    0,    0,    0,   91,  558,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          509,    0,  110,    0,  509,    0,    0,    0,    0,  559, 
            0,    0,    0,    0,    0,    0,    0,  561,  562,  563, 
          564,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  509,  258,  258,  258,    0,    0,  258,  258, 
          258,    0,  258,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  258,  258,    0,    0,    0,    0,    0,    0, 
            0,  258,  258,  565,  258,  258,  258,  258,  258,    0, 
            0,    0,    0,    0,    0,    0,  258,    0,    0,    0, 
          512,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          512,  385,  386,  387,  388,  389,  390,  391,    0,    0, 
          394,  395,    0,    0,    0,    0,    0,  398,  399,    0, 
          258,    0,    0,  258,    0,    0,  258,    0,  258,    0, 
            0,    0,    0,  400,   94,  401,    0,  402,  403,  404, 
          405,  406,  407,  408,  258,  409,  640,  635,    0,  512, 
          641,  113,    0,  512,  183,  184,  258,  185,  186,  187, 
          188,  189,  190,  191,    0,    0,  192,  193,    0,    0, 
            0,  194,  195,  196,  197,    0,  258,    0,    0,    0, 
            0,  512,    0,    0,    0,    0,    0,    0,  199,  200, 
            0,  201,  202,  203,  204,  205,  206,  207,  208,  209, 
          210,  211,    0,    0,  212,    0,    0,    0,  610,  610, 
          610,    0,  610,  509,  509,  509,  610,  610,    0,  509, 
          509,  610,  509,  610,  610,  610,  610,  610,  610,  610, 
            0,  610,    0,    0,  610,  610,  610,  610,  610,  610, 
          610,  509,  509,  610,  509,  509,  509,  509,  509,    0, 
          610,    0,    0,  610,  610,  610,    0,  610,  610,  610, 
          610,  610,  610,  610,  610,  610,  610,  610,  509,  509, 
          509,  509,  509,  509,  509,  509,  509,  509,  509,  509, 
          509,  509,  410,    0,  509,  509,  509,  509,  610,  521, 
          105,  610,  610,  509,  610,  610,    0,  610,    0,  610, 
          509,  610,  509,  610,  509,  509,  509,  509,  509,  509, 
          509,  610,  509,  610,  509,    0,  610,  610,  610,  610, 
          610,  610,    0,    0,  105,  610,    0,  610,  610,    0, 
          610,  610,  610,  610,    0,    0,    0,    0,    0,    0, 
            0,  105,    0,  610,  610,  610,  509,  611,  611,  611, 
            0,  611,  512,  512,  512,  611,  611,    0,  512,  512, 
          611,  512,  611,  611,  611,  611,  611,  611,  611,    0, 
          611,  617,    0,  611,  611,  611,  611,  611,  611,  611, 
          512,  512,  611,  512,  512,  512,  512,  512,    0,  611, 
            0,    0,  611,  611,  611,    0,  611,  611,  611,  611, 
          611,  611,  611,  611,  611,  611,  611,  512,  512,  512, 
          512,  512,  512,  512,  512,  512,  512,  512,  512,  512, 
          512,  410,    0,  512,  512,  512,  512,  611,  524,    0, 
          611,  611,  512,  611,  611,    0,  611,    0,  611,  512, 
          611,  512,  611,  512,  512,  512,  512,  512,  512,  512, 
          611,  512,  611,  512,    0,  611,  611,  611,  611,  611, 
          611,    0,    0,  617,  611,    0,  611,  611,    0,  611, 
          611,  611,  611,  617,    0,    0,    0,    0,    0,    0, 
            0,    0,  611,  611,  611,  512,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  105,    0,    0, 
            0,    0,    0,    0,    0,    0,  798,    0,    0,    0, 
            0,    0,  617,    0,  124,    0,  617,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  385,  386,  387,  388, 
          389,  390,  391,  392,  393,  394,  395,    0,  396,  397, 
            0,    0,  398,  399,  617,    0,    0,    0,    0,  105, 
          617,    0,    0,    0,    0,    0,    0,    0,  400,    0, 
          401,    0,  402,  403,  404,  405,  406,  407,  408,    0, 
          409,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  613,    0,    0,    0,    0,    0,  617,    0, 
            0,    0,  613,    0,    0,  617,  617,    0,    0,    0, 
            0,  613,  105,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  617,    0,    0,    0,  104,    0,    0,    0, 
            0,    0,    0,    0,    0,  804,    0,    0,    0,    0, 
            0,  613,    0,  123,    0, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

          613,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          385,  386,  387,  388,  389,  390,  391,  392,  393,  394, 
          395,    0,  396,  397,    0,    0,  398,  399,  613,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  400,    0,  401,    0,  402,  403,  404,  405, 
          406,  407,  408,    0,  409,  613,  613,  613,    0,  613, 
          617,  617,  617,  613,  613,    0,  617,  617,  613,  617, 
          613,  613,  613,  613,  613,  613,  613,    0,  617,    0, 
            0,  613,  613,  613,  613,  613,  613,  613,  617,  617, 
          613,  617,  617,  617,  617,  617,    0,  613,    0,    0, 
          613,  613,  613,    0,  613,  613,  613,  613,  613,  613, 
          613,  613,  613,  613,  613,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  410, 
            0,  617,  617,  617,  617,  613,    0,  104,  613,  613, 
          617,  613,  613,    0,  613,    0,  613,  617,  613,  617, 
          613,  617,  617,  617,  617,  617,  617,  617,  613,  617, 
          617,  617,    0,  613,  613,  613,  613,  613,  613,    0, 
            0,  104,  613,    0,  613,  613,    0,  613,  613,  613, 
          613,    0,    0,    0,    0,    0,    0,    0,  104,    0, 
          613,  613,  613,  617,  613,  613,  613,    0,  613,  613, 
          613,  613,  613,  613,    0,  613,  613,  613,  613,  613, 
          613,  613,  613,  613,  613,  613,    0,  613,  613,    0, 
          613,  613,  613,  613,  613,  613,  613,  613,  613,  613, 
          613,  613,  613,  613,  613,    0,  613,    0,    0,  613, 
          613,  613,    0,  613,  613,  613,  613,  613,  613,  613, 
          613,  613,  613,  613,  613,  613,  613,  613,  613,  613, 
          613,  613,  613,  613,  613,  613,  613,  613,    0,    0, 
          613,  613,  613,  613,  613,    0,    0,  613,  613,  613, 
          613,  613,    0,  613,    0,  613,  613,  613,  613,  613, 
          613,  613,  613,  613,  613,  613,  613,  613,  613,  613, 
          613,    0,  613,  613,  613,  613,  613,  613,    0,    0, 
          614,  613,    0,  613,  613,    0,  613,  613,  613,  613, 
          614,    0,    0,  101,    0,    0,    0,    0,    0,  613, 
          613,  613,  613,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  106,    0,    0,  101,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  614, 
            0,  125,    0,  614,  101,    0,    0,    0,    0,    0, 
            0,    0,    0,  385,  386,  387,  388,  389,  390,  391, 
          392,  393,  394,  395,    0,  396,  397,    0,    0,  398, 
          399,  614,    0,    0,  519,    0,  104,  613,    0,    0, 
            0,    0,    0,    0,    0,  400,    0,  401,    0,  402, 
          403,  404,  405,  406,  407,  408,    0,  409,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  312, 
            0,    0,    0,    0,    0,  613,    0,    0,    0,  312, 
            0,    0,  613,  613,    0,    0,    0,    0,  613,  104, 
            0,  626,  627,    0,    0,  628,    0,    0,    0,  183, 
          184,    0,  185,  186,  187,  188,  189,  190,  191,  613, 
            0,  192,  193,  107,    0,    0,  194,  195,  196,  197, 
            0,    0,    0,    0,    0,    0,  299,    0,  312,    0, 
          126,    0,  312,  199,  200,    0,  201,  202,  203,  204, 
          205,  206,  207,  208,  209,  210,  211,    0,    0,  212, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          312,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  614,  614,  614, 
            0,  614,  614,  614,  614,  614,  614,    0,  614,  614, 
          614,  614,  614,  614,  614,  614,  614,  614,  614,    0, 
          614,    0,  101,  614,  614,  614,  614,  614,  614,  614, 
          614,  614,  614,  614,  614,  614,  614,  614,    0,  614, 
            0,    0,  614,  614,  614,    0,  614,  614,  614,  614, 
          614,  614,  614,  614,  614,  614,  614,  614,  614,  614, 
          614,  614,  614,  614,  614,  614,  614,  614,  614,  614, 
          614,  519,    0,  614,  614,  614,  614,  614,  519,  519, 
          614,  614,  614,  614,  614,  101,  614,    0,  614,  614, 
          614,  614,  614,  614,  614,  614,  614,  614,  614,  614, 
          614,  614,  614,  614,    0,  614,  614,  614,  614,  614, 
          614,    0,    0,    0,  614,    0,  614,  614,  639,  614, 
          614,  614,  614,    0,    0,    0,    0,    0,  639,    0, 
            0,    0,  614,  614,  614,  614,  614,  614,  614,    0, 
          614,  312,  312,  312,  614,  614,    0,  312,  312,  614, 
          312,  614,  614,  614,  614,  614,  614,  614,    0,    0, 
            0,    0,  614,  614,  614,  614,  614,  614,  614,  312, 
          312,  614,  312,  312,  312,  312,  312,  639,  614,    0, 
            0,  614,  614,  614,    0,  614,  614,  614,  614,  614, 
          614,  614,  614,  614,  614,  614,  312,  312,  312,  312, 
          312,  312,  312,  312,  312,  312,  312,  312,  312,  312, 
            0,    0,  312,  312,  312,  312,  614,    0,    0,  614, 
          614,  312,  614,  614,    0,  614,    0,  614,  312,  614, 
          312,  614,  312,  312,  312,  312,  312,  312,  312,  614, 
          312,    0,  312,    0,  614,  614,  614,  614,  614,  614, 
            0,    0,  433,  614,    0,  614,  614,    0,  614,  614, 
          614,  614,  433,    0,    0,    0,    0,    0,    0,    0, 
            0,  614,  614,  614,  312,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  433,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          433,  433,    0,  122,    0,  433,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  303,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  433,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  879,    0,    0,  879,    0,    0,  127, 
            0,    0,  889,    0,    0,  279,  279,  279,  410,  279, 
          639,  639,  639,  279,  279,  639,  639,  639,  279,  639, 
          279,  279,  279,  279,  279,  279,  279,    0,  639,  639, 
          639,  279,  279,  279,  279,  279,  279,  279,  639,  639, 
          279,  639,  639,  639,  639,  639,    0,  279,  127,    0, 
          279,  279,  279,    0,  279,  279,  279,  279,  279,  279, 
          279,  279,  279,  279,  279,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  639,    0,    0,    0, 
          313,    0,    0,  639,  639,  279,    0,    0,  279,  432, 
          639,  279,  279,    0,  279,    0,  279,    0,  279,  432, 
          279,    0,    0,    0,    0,    0,    0,    0,  279,    0, 
          639,  639,    0,  279,  279,  279,  279,  279,  279,    0, 
            0,    0,  279,    0,  279,  279,    0,  279,  279,  279, 
          279,    0,    0,  432,    0,    0,    0,    0,    0,    0, 
          279,  279,  279,  639,  433,  433,  433,  432,  432,  433, 
          433,  433,  432,  433,    0,    0,    0,    0,    0,    0, 
            0,    0,  433,  433,  433,    0,    0,    0,    0,    0, 
            0,    0,  433,  433,    0,  433,  433,  433,  433,  433, 
          432,    0,    0,    0,    0,    0,    0,  433,    0,  889, 
            0,    0,  889,    0,  879,    0,  889,    0,    0,  433, 
          433,  433,  433,  433,  433,  433,  433,  433,  433,  433, 
          433,  433,  433,    0,    0,  433,  433,  433,  433,    0, 
            0,  433,    0,    0,  433,    0,    0,  433,    0,  433, 
            0,  433,  515,  433,    0,  433,  433,  433,  433,  433, 
          433,  433,  515,  433,  433,  433,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  127,  433,    0,    0, 
            0,    0,  385,  386,  387,  388,  389,  390,  391,  392, 
          393,  394,  395,    0,  396,  397,  515,  433,  398,  399, 
          889,    0,  889,    0,  889,    0,    0,  889,    0,    0, 
          515,  515,    0,  116,  400,  515,  401,    0,  402,  403, 
          404,  405,  406,  407,  408,    0,  409,    0,    0,    0, 
            0,    0,  889,    0,    0,    0,    0,  313,    0,    0, 
            0,    0,    0,  515,  313,  313,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           43,  432,  432,  432,    0,    0,  432,  432,  432,    0, 
          432,    0,    0,    0,    0,    0,    0,    0,    0,  432, 
          432,  432,    0,    0,    0,    0,    0,    0,    0,  432, 
          432,    0,  432,  432,  432,  432,  432,    0,    0,    0, 
            0,    0,    0,    0,  432,  514,    0,    0,    0,   43, 
            0,    0,    0,    0,    0,  514,  432,  432,  432,  432, 
          432,  432,  432,  432,  432,  432,  432,  432,  432,  432, 
            0,    0,  432,  432,  432,  432,    0,    0,  432,    0, 
            0,  432,    0,    0,  432,    0,  432,    0,  432,  514, 
          432,    0,  432,  432,  432,  432,  432,  432,  432,    0, 
          432,  432,  432,  514,  514,    0,  115,    0,  514,    0, 
            0,    0,    0,    0,  432,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  432,    0,  514,    0,    0,    0, 
            0,    0,    0,    0,  515,  515,  515,    0,    0,  515, 
          515,  515,    0,  515,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  515,  515,    0,    0,    0,    0,    0, 
            0,    0,  515,  515,    0,  515,  515,  515,  515,  515, 
            0,    0,    0,    0,    0,    0,    0,  515,  516,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  516,  515, 
          515,  515,  515,  515,  515,  515,  515,  515,  515,  515, 
          515,  515,  515,    0,    0,  515,  515,  515,  515,    0, 
          527,  515,    0,    0,  515,    0,    0,  515,    0,  515, 
            0,  515,  516,  515,    0,  515,  515,  515,  515,  515, 
          515,  515,    0,  515,    0,  515,  516,  516,    0,  117, 
            0,  516,   43,   43,   43,    0,    0,  515,   43,   43, 
            0,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  515,    0,  516, 
            0,    0,    0,   43,   43,   43,   43,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,   25,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   25,  514,  514,  514, 
            0,    0,  514,  514,  514,    0,  514,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  514,  514,    0,    0, 
            0,    0,   43,    0,    0,  514,  514,    0,  514,  514, 
          514,  514,  514,    0,    0,    0,    0,    0,    0,    0, 
          514,  517,    0,   43,    0,   25,    0,    0,    0,    0, 
            0,  517,  514,  514,  514,  514,  514,  514,  514,  514, 
          514,  514,  514,  514,  514,  514,    0,    0,  514,  514, 
          514,  514,    0,  526,  514,   43,    0,  514,    0,    0, 
          514,    0,  514,    0,  514,  517,  514,    0,  514,  514, 
          514,  514,  514,  514,  514,    0,  514,    0,  514,  517, 
          517,    0,  118,    0,  517,    0,    0,    0,    0,    0, 
          514,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          514,    0,  517,    0,    0,    0,    0,    0,    0,    0, 
          516,  516,  516,    0,    0,  516,  516,  516,    0,  516, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  516, 
          516,    0,    0,    0,    0,    0,    0,    0,  516,  516, 
            0,  516,  516,  516,  516,  516,    0,    0,    0,    0, 
            0,    0,    0,  516,  519,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  519,  516,  516,  516,  516,  516, 
          516,  516,  516,  516,  516,  516,  516,  516,  516,    0, 
            0,  516,  516,  516,  516,    0,  528,  516,    0,    0, 
          516,    0,    0,  516,    0,  516,    0,  516,  519,  516, 
            0,  516,  516,  516,  516,  516,  516,  516,    0,  516, 
            0,  516,  519,  519,    0,  120,    0,  519,   25,   25, 
           25,    0,    0,  516,   25,   25,    0,   25,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  100,    0,    0, 
            0,    0,    0,  516,    0,  519,    0,    0,    0,   25, 
           25,   25,   25,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  100,    0,  517,  517,  517,    0,    0,  517,  517, 
          517,    0,  517,    0,    0,    0,    0,    0,  100,    0, 
            0,    0,  517,  517,    0,    0,    0,    0,   25,    0, 
            0,  517,  517,    0,  517,  517,  517,  517,  517,    0, 
            0,    0,    0,    0,    0,    0,  517,  518,  518,   25, 
            0,    0,    0,    0,    0,    0,    0,  518,  517,  517, 
          517,  517,  517,  517,  517,  517,  517,  517,  517,  517, 
          517,  517,    0,    0,  517,  517,  517,  517,    0,  529, 
          517,   25,    0,  517,    0,    0,  517,    0,  517,    0, 
          517,  518,  517,    0,  517,  517,  517,  517,  517,  517, 
          517,    0,  517,    0,  517,  518,  518,    0,  119,    0, 
          518,    0,    0,    0,    0,    0,  517,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  517,    0,  518,    0, 
            0,    0,    0,    0,    0,    0,  519,  519,  519,    0, 
            0,  519,  519,  519,    0,  519,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  519,  519,    0,    0,    0, 
            0,    0,    0,    0,  519,  519,    0,  519,  519,  519, 
          519,  519,    0,    0,    0,    0,    0,    0,    0,  519, 
          520,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          520,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,    0,    0,  519,  519,  519, 
          519,    0,  531,  519,    0,    0,  519,    0,    0,  519, 
            0,  519,    0,  519,  520,  519,  100,  519,  519,  519, 
          519,  519,  519,  519,    0,  519,    0,  519,  520,  520, 
            0,  121,  106,  520,    0,    0,    0,    0,    0,  519, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  102,    0,    0,    0,    0,    0,  519, 
            0,  520,    0,    0,    0,  518,  106,    0,    0,    0, 
            0,    0,  518,  518,    0,    0,    0,    0,    0,  100, 
            0,    0,    0,  106,    0,    0,    0,  102,    0,  518, 
          518,  518,    0,    0,  518,  518,  518,    0,  518,    0, 
            0,    0,    0,    0,  102,    0,    0,    0,  518,  518, 
            0,    0,    0,  614,    0,    0,    0,  518,  518,    0, 
          518,  518,  518,  518,  518,    0,    0,    0,    0,    0, 
            0,    0,  518,  511,  520,    0,    0,    0,    0,    0, 
            0,    0,    0,  511,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,    0,    0, 
          518,  518,  518,  518,    0,  530,  518,    0,    0,  518, 
            0,    0,  518,    0,  518,    0,  518,  511,  518,    0, 
          518,  518,  518,  518,  518,  518,  518,    0,  518,    0, 
          518,  511,  511,    0,  112,    0,  511,    0,    0,    0, 
            0,    0,  518,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  518,    0,  511,    0,    0,    0,    0,    0, 
            0,    0,  520,  520,  520,    0,    0,  520,  520,  520, 
            0,  520,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  520,  520,    0,    0,    0,    0,    0,    0,    0, 
          520,  520,    0,  520,  520,  520,  520,  520,    0,    0, 
            0,    0,    0,    0,    0,  520,  510,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  510,  520,  520,  520, 
          520,  520,  520,  520,  520,  520,  520,  520,  520,  520, 
          520,  106,  614,  520,  520,  520,  520,    0,  532,  520, 
            0,    0,  520,    0,    0,  520,    0,  520,   93,  520, 
          510,  520,  102,  520,  520,  520,  520,  520,  520,  520, 
            0,  520,    0,  520,  510,  510,    0,  111,   92,  510, 
            0,    0,    0,    0,    0,  520,    0,    0,    0,    0, 
          614,    0,   93,    0,    0,    0,    0,  614,  614,   95, 
            0,    0,    0,  614,  106,  520,    0,  510,    0,   93, 
            0,  520,   92,    0,    0,    0,    0,    0,  520,  520, 
            0,    0,    0,    0,  614,  102,    0,    0,    0,   92, 
            0,    0,    0,   95,    0,  511,  511,  511,    0,  511, 
          511,  511,  511,    0,  511,    0,    0,    0,    0,    0, 
           95,    0,    0,    0,  511,  511,    0,    0,    0,  510, 
            0,    0,    0,  511,  511,    0,  511,  511,  511,  511, 
          511,    0,    0,    0,    0,    0,    0,    0,  511,  513, 
          513,    0,    0,    0,    0,    0,    0,    0,    0,  513, 
          511,  511,  511,  511,  511,  511,  511,  511,  511,  511, 
          511,  511,  511,  511,    0,    0,  511,  511,  511,  511, 
            0,  523,  511,    0,    0,  511,    0,    0,  511,    0, 
          511,    0,  511,  513,  511,    0,  511,  511,  511,  511, 
          511,  511,  511,    0,  511,    0,  511,  513,  513,    0, 
          114,    0,  513,    0,    0,    0,    0,    0,  511,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  511,    0, 
          513,    0,    0,    0,    0,    0,    0,    0,  510,  510, 
          510,    0,    0,  510,  510,  510,    0,  510,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  510,  510,    0, 
            0,    0,    0,    0,    0,    0,  510,  510,    0,  510, 
          510,  510,  510,  510,    0,    0,    0,    0,    0,    0, 
            0,  510,  639,    0,    0,    0,    0,   93,    0,    0, 
            0,    0,  639,  510,  510,  510,  510,  510,  510,  510, 
          510,  510,  510,  510,  510,  510,  510,   92,    0,  510, 
          510,  510,  510,    0,  522,  510,    0,    0,  510,    0, 
            0,  510,    0,  510,    0,  510,  639,  510,   95,  510, 
          510,  510,  510,  510,  510,  510,  511,  510,    0,  510, 
          639,  639,    0,  511,  511,  639,    0,    0,    0,    0, 
           93,  510,    0,    0,    0,    0,  510,    0,    0,    0, 
            0,    0,    0,  510,  510,  109,    0,    0,    0,    0, 
           92,  510,    0,  639,    0,    0,    0,  513,    0,    0, 
            0,    0,    0,    0,  513,  513,    0,    0,    0,    0, 
            0,   95,    0,    0,    0,    0,    0,    0,    0,  109, 
            0,  513,  513,  513,    0,    0,  513,  513,  513,    0, 
          513,    0,    0,    0,    0,    0,  109,    0,    0,    0, 
          513,  513,    0,    0,    0,    0,    0,    0,    0,  513, 
          513,    0,  513,  513,  513,  513,  513,    0,    0,    0, 
            0,    0,    0,    0,  513,  302,  302,    0,    0,    0, 
            0,    0,    0,    0,    0,  302,  513,  513,  513,  513, 
          513,  513,  513,  513,  513,  513,  513,  513,  513,  513, 
            0,    0,  513,  513,  513,  513,    0,  525,  513,    0, 
            0,  513,    0,    0,  513,    0,  513,  108,  513,  302, 
          513,    0,  513,  513,  513,  513,  513,  513,  513,    0, 
          513,    0,  513,  302,  302,    0,  128,    0,  302,    0, 
            0,    0,    0,    0,  513,    0,    0,    0,    0,    0, 
            0,  108,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  513,    0,  302,    0,  108,    0, 
            0,    0,    0,    0,  639,  639,  639,    0,    0,  639, 
          639,  639,    0,  639,    0,    0,    0,    0,    0,    0, 
            0,    0,  639,  639,  639,    0,    0,    0,  313,    0, 
            0,    0,  639,  639,    0,  639,  639,  639,  639,  639, 
            0,    0,    0,    0,    0,    0,    0,  639,  313,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  313,  639, 
          639,  639,  639,  639,  639,  639,  639,  639,  639,  639, 
          639,  639,  639,    0,    0,  639,  639,  639,  639,    0, 
            0,  639,    0,    0,  639,    0,    0,  639,    0,  639, 
            0,  639,  313,  639,  109,  639,  639,  639,  639,  639, 
          639,  639,    0,  639,  639,  639,  313,  313,    0,  127, 
            0,  313,    0,    0,    0,    0,    0,  639,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  639,    0,  313, 
            0,    0,    0,  302,    0,    0,    0,    0,    0,    0, 
          302,  302,    0,    0,    0,    0,    0,  109,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  302,  302,  302, 
            0,    0,  302,  302,  302,    0,  302,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  302,  302,    0,    0, 
            0,    0,    0,    0,    0,  302,  302,    0,  302,  302, 
          302,  302,  302,    0,    0,    0,    0,    0,    0,    0, 
          302,  453,    0,    0,    0,    0,  108,    0,    0,    0, 
            0,  453,  302,  302,  302,  302,  302,  302,  302,  302, 
          302,  302,  302,  302,  302,  302,    0,    0,  302,  302, 
          302,  302,    0,    0,  302,    0,    0,  302,    0,    0, 
          302,    0,  302,    0,  302,  453,  302,    0,  302,  302, 
          302,  302,  302,  302,  302,  313,  302,    0,  302,  453, 
          453,    0,  313,  313,  453,    0,    0,    0,    0,  108, 
          302,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          302,    0,  453,    0,    0,    0,    0,    0,    0,    0, 
          313,  313,  313,    0,    0,  313,  313,  313,    0,  313, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  313, 
          313,    0,    0,    0,    0,    0,    0,    0,  313,  313, 
            0,  313,  313,  313,  313,  313,    0,    0,    0,    0, 
            0,    0,    0,  313,  324,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  324,  313,  313,  313,  313,  313, 
          313,  313,  313,  313,  313,  313,  313,  313,  313,    0, 
            0,  313,  313,  313,  313,    0,    0,  313,    0,    0, 
          313,    0,    0,  313,    0,  313,    0,  313,  324,  313, 
            0,  313,  313,  313,  313,  313,  313,  313,    0,  313, 
            0,  313,  324,  324,    0,    0,    0,  324,    0,    0, 
            0,    0,    0,  313,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  313,    0,  324,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  453,  453,  453,    0,    0,  453,  453, 
          453,    0,  453,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  453,  453,    0,    0,    0,    0,    0,    0, 
            0,  453,  453,    0,  453,  453,  453,  453,  453,    0, 
            0,    0,    0,    0,    0,    0,  453,  260,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  260,  453,  453, 
          453,  453,  453,  453,  453,  453,  453,  453,  453,  453, 
          453,  453,    0,    0,  453,  453,  453,  453,    0,    0, 
          453,    0,    0,  453,    0,    0,  453,    0,  453,    0, 
          453,  260,  453,    0,  453,  453,  453,  453,  453,  453, 
          453,    0,  453,    0,  453,  260,  260,    0,    0,    0, 
          260,    0,    0,    0,    0,    0,  453,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  453,    0,  356,    0, 
            0,    0,    0,    0,    0,    0,  324,  324,  324,    0, 
            0,  324,  324,  324,    0,  324,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  324,  324,    0,    0,    0, 
            0,    0,    0,    0,  324,  324,    0,  324,  324,  324, 
          324,  324,    0,    0,    0,    0,    0,    0,    0,  324, 
          319,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          319,  324,  324,  324,  324,  324,  324,  324,  324,  324, 
          324,  324,  324,  324,  324,    0,    0,  324,  324,  324, 
          324,    0,    0,  324,    0,    0,  324,    0,    0,  324, 
            0,  324,    0,  324,  319,  324,    0,  324,  324,  324, 
          324,  324,  324,  324,    0,  324,    0,  324,  319,  319, 
            0,    0,    0,  319,    0,    0,    0,    0,    0,  324, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  324, 
            0,  319,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  260, 
          260,  260,    0,    0,  260,  260,  260,    0,  260,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  260,  260, 
            0,    0,    0,    0,    0,    0,    0,  260,  260,    0, 
          260,  260,  260,  260,  260,    0,    0,    0,    0,    0, 
            0,    0,  260,  504,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  504,  260,  260,  260,  260,  260,  260, 
          260,  260,  260,  260,  260,  356,  260,  260,    0,    0, 
          260,  260,  356,  356,    0,    0,  260,    0,    0,  260, 
            0,    0,  260,    0,  260,    0,  260,  504,  260,    0, 
          260,  260,  260,  260,  260,  260,  260,    0,  260,    0, 
          260,  504,  504,    0,    0,    0,  504,    0,    0,    0, 
            0,    0,  260,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  260,    0,  504,    0,    0,    0,    0,    0, 
            0,    0,  319,  319,  319,    0,    0,  319,  319,  319, 
            0,  319,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  319,  319,    0,    0,    0,    0,    0,    0,    0, 
          319,  319,    0,  319,  319,  319,  319,  319,    0,    0, 
            0,    0,    0,    0,    0,  319,  352,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  352,  319,  319,  319, 
          319,  319,  319,  319,  319,  319,  319,  319,  319,  319, 
          319,    0,    0,  319,  319,  319,  319,    0,    0,  319, 
            0,    0,  319,    0,    0,  319,    0,  319,    0,  319, 
          352,  319,    0,  319,  319,  319,  319,  319,  319,  319, 
            0,  319,    0,  319,    0,  352,    0,    0,    0,  352, 
            0,    0,    0,    0,    0,  319,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  319,    0,  352,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   52,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   52,  504,  504,  504,    0,    0, 
          504,  504,  504,    0,  504,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  504,  504,    0,    0,    0,    0, 
            0,    0,    0,  504,  504,    0,  504,  504,  504,  504, 
          504,    0,    0,    0,    0,    0,    0,    0,  504,  353, 
            0,    0,    0,   52,    0,    0,    0,    0,    0,  353, 
            0,  504,  504,  504,  504,  504,  504,  504,  504,  504, 
          504,  504,  504,  504,    0,    0,  504,  504,  504,  504, 
            0,    0,  504,    0,    0,  504,    0,    0,  504,    0, 
          504,    0,  504,  353,  504,    0,  504,  504,  504,  504, 
          504,  504,  504,    0,  504,    0,  504,    0,  353,    0, 
            0,    0,  353,    0,    0,    0,    0,    0,  504,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  504,    0, 
          353,    0,    0,    0,    0,    0,    0,    0,  352,  352, 
          352,    0,    0,  352,  352,  352,    0,  352,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  352,  352,    0, 
            0,    0,    0,    0,    0,    0,  352,  352,    0,  352, 
          352,  352,  352,  352,    0,    0,    0,    0,    0,    0, 
            0,    0,  316,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  316,  352,  352,  352,  352,  352,  352,  352, 
          352,  352,  352,  352,  352,  352,  352,    0,    0,  352, 
          352,  352,  352,    0,    0,  352,    0,    0,  352,    0, 
            0,  352,    0,  352,    0,  352,  316,  352,    0,  352, 
          352,  352,  352,  352,  352,  352,    0,  352,    0,  352, 
            0,  316,    0,    0,    0,  316,   52,   52,   52,    0, 
            0,   52,   52,   52,    0,   52,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   52,    0,    0,    0,    0, 
            0,  352,    0,  316,    0,    0,    0,   52,   52,   52, 
           52,   52,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  353,  353,  353,    0,    0,  353,  353,  353,    0, 
          353,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          353,  353,    0,    0,    0,    0,   52,    0,    0,  353, 
          353,    0,  353,  353,  353,  353,  353,    0,    0,    0, 
            0,    0,    0,    0,    0,  238,    0,   52,    0,    0, 
            0,    0,    0,    0,    0,  238,  353,  353,  353,  353, 
          353,  353,  353,  353,  353,  353,  353,  353,  353,  353, 
            0,    0,  353,  353,  353,  353,    0,    0,  353,   52, 
            0,  353,    0,    0,  353,    0,  353,    0,  353,  238, 
          353,    0,  353,  353,  353,  353,  353,  353,  353,    0, 
          353,    0,  353,  238,  238,    0,    0,    0,  238,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  353,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  316,  316,  316,    0,    0,  316, 
          316,  316,    0,  316,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  316,  316,    0,    0,    0,    0,    0, 
            0,    0,  316,  316,    0,  316,  316,  316,  316,  316, 
            0,    0,    0,    0,    0,    0,    0,    0,  235,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  235,  316, 
          316,  316,  316,  316,  316,  316,  316,  316,  316,  316, 
          316,  316,  316,    0,    0,  316,  316,  316,  316,    0, 
            0,  316,    0,    0,  316,    0,    0,  316,    0,  316, 
            0,  316,  235,  316,    0,  316,  316,  316,  316,  316, 
          316,  316,    0,  316,    0,  316,  235,  235,  634,  635, 
            0,  235,  636,    0,    0,    0,  183,  184,    0,  185, 
          186,  187,  188,  189,  190,  191,    0,    0,  192,  193, 
            0,    0,    0,  194,  195,  196,  197,  316,    0,    0, 
            0,    0,    0,  299,    0,    0,    0,    0,    0,    0, 
          199,  200,    0,  201,  202,  203,  204,  205,  206,  207, 
          208,  209,  210,  211,    0,    0,  212,  238,  238,  238, 
            0,    0,  238,  238,  238,    0,  238,    0,  232,    0, 
            0,    0,    0,    0,    0,    0,  238,  238,  232,    0, 
            0,    0,    0,    0,    0,  238,  238,    0,  238,  238, 
          238,  238,  238,    0,    0,    0,    0,    0,    0,    0, 
          238,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  232,  238,  238,  238,  238,  238,  238,  238, 
          238,  238,  238,    0,  238,  238,  232,  232,  238,  238, 
            0,  232,    0,    0,  238,    0,    0,  238,    0,    0, 
          238,    0,  238,    0,  238,    0,  238,    0,  238,  238, 
          238,  238,  238,  238,  238,    0,  238,    0,  238,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          238,    0,    0,    0,    0,    0,    0,    0,  234,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  234,    0, 
          238,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          235,  235,  235,    0,    0,  235,  235,  235,    0,  235, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  235, 
          235,    0,  234,    0,    0,    0,    0,    0,  235,  235, 
            0,  235,  235,  235,  235,  235,  234,  234,    0,    0, 
            0,  234,    0,  235,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  235,  235,  235,  235, 
          235,  235,  235,  235,  235,  235,    0,  235,  235,    0, 
            0,  235,  235,    0,    0,    0,    0,  235,    0,    0, 
          235,    0,    0,  235,    0,  235,    0,  235,    0,  235, 
            0,  235,  235,  235,  235,  235,  235,  235,    0,  235, 
            0,  235,    0,    0,    0,    0,    0,    0,  233,    0, 
            0,    0,    0,  235,    0,    0,    0,    0,  233,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          232,  232,  232,  235,    0,  232,  232,  232,    0,  232, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  232, 
          232,    0,  233,    0,    0,    0,    0,    0,  232,  232, 
            0,  232,  232,  232,  232,  232,  233,  233,    0,    0, 
            0,  233,    0,  232,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  232,  232,  232,  232, 
          232,  232,  232,  232,  232,  232,    0,  232,  232,    0, 
            0,  232,  232,    0,    0,    0,    0,  232,    0,    0, 
          232,    0,    0,  232,    0,  232,    0,  232,  236,  232, 
            0,  232,  232,  232,  232,  232,  232,  232,  236,  232, 
            0,  232,    0,    0,    0,    0,    0,    0,    0,    0, 
          234,  234,  234,  232,    0,  234,  234,  234,    0,  234, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  234, 
          234,    0,  236,  232,    0,    0,    0,    0,  234,  234, 
            0,  234,  234,  234,  234,  234,  236,  236,    0,    0, 
            0,  236,    0,  234,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  234,  234,  234,  234, 
          234,  234,  234,  234,  234,  234,    0,  234,  234,    0, 
            0,  234,  234,    0,    0,    0,    0,  234,    0,    0, 
          234,    0,    0,  234,    0,  234,    0,  234,    0,  234, 
            0,  234,  234,  234,  234,  234,  234,  234,    0,  234, 
            0,  234,    0,    0,    0,    0,    0,    0,  433,    0, 
            0,    0,    0,  234,    0,    0,    0,    0,  433,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          233,  233,  233,  234,    0,  233,  233,  233,    0,  233, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  233, 
          233,    0,  103,    0,    0,    0,    0,    0,  233,  233, 
            0,  233,  233,  233,  233,  233,    0,  433,    0,  122, 
            0,  433,    0,  233,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  233,  233,  233,  233, 
          233,  233,  233,  233,  233,  233,    0,  233,  233,  433, 
            0,  233,  233,    0,    0,    0,    0,  233,    0,    0, 
          233,    0,    0,  233,    0,  233,    0,  233,  515,  233, 
            0,  233,  233,  233,  233,  233,  233,  233,  515,  233, 
            0,  233,    0,    0,    0,    0,    0,    0,    0,    0, 
          236,  236,  236,  233,    0,  236,  236,  236,    0,  236, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  236, 
          236,    0,   97,  233,    0,    0,    0,    0,  236,  236, 
            0,  236,  236,  236,  236,  236,    0,  515,    0,  116, 
            0,  515,    0,  236,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  236,  236,  236,  236, 
          236,  236,  236,  236,  236,  236,    0,  236,  236,  515, 
            0,  236,  236,    0,    0,    0,    0,  236,    0,    0, 
          236,    0,    0,  236,    0,  236,    0,  236,    0,  236, 
          514,  236,  236,  236,  236,  236,  236,  236,    0,  236, 
          514,  236,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  236,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          433,  433,  433,  236,   96,    0,  433,  433,    0,  433, 
            0,    0,    0,    0,    0,    0,    0,    0,  433,  514, 
            0,  115,    0,  514,    0,    0,    0,    0,  433,  433, 
            0,  433,  433,  433,  433,  433,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  514,    0,    0,    0,  433,  433,  433,  433,  433, 
          433,  433,  433,  433,  433,  433,  433,  433,  433,  516, 
            0,  433,  433,  433,  433,    0,    0,    0,    0,  516, 
          433,    0,    0,    0,    0,    0,    0,  433,    0,  433, 
            0,  433,  433,  433,  433,  433,  433,  433,    0,  433, 
          433,  433,    0,    0,    0,    0,    0,    0,    0,    0, 
          515,  515,  515,   98,    0,    0,  515,  515,    0,  515, 
            0,    0,    0,    0,    0,    0,    0,    0,  516,    0, 
          117,    0,  516,  433,    0,    0,    0,    0,  515,  515, 
            0,  515,  515,  515,  515,  515,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          516,    0,    0,    0,    0,  515,  515,  515,  515,  515, 
          515,  515,  515,  515,  515,  515,  515,  515,  515,    0, 
            0,  515,  515,  515,  515,    0,  527,    0,    0,    0, 
          515,    0,    0,    0,    0,    0,    0,  515,    0,  515, 
            0,  515,  515,  515,  515,  515,  515,  515,  517,  515, 
            0,  515,    0,    0,    0,    0,    0,    0,  517,    0, 
            0,    0,  514,  514,  514,    0,    0,    0,  514,  514, 
            0,  514,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  515,    0,    0,    0,    0,    0,    0, 
          514,  514,   99,  514,  514,  514,  514,  514,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  517,    0,  118, 
            0,  517,    0,    0,    0,    0,    0,  514,  514,  514, 
          514,  514,  514,  514,  514,  514,  514,  514,  514,  514, 
          514,    0,    0,  514,  514,  514,  514,    0,  526,  517, 
            0,    0,  514,    0,    0,    0,    0,    0,    0,  514, 
            0,  514,  290,  514,  514,  514,  514,  514,  514,  514, 
            0,  514,  290,  514,    0,    0,    0,    0,    0,    0, 
            0,  516,  516,  516,    0,    0,    0,  516,  516,    0, 
          516,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  514,  286,    0,    0,  516, 
          516,    0,  516,  516,  516,  516,  516,    0,    0,    0, 
          519,  290,    0,    0,    0,    0,    0,    0,    0,    0, 
          519,    0,    0,    0,    0,    0,  516,  516,  516,  516, 
          516,  516,  516,  516,  516,  516,  516,  516,  516,  516, 
            0,    0,  516,  516,  516,  516,    0,  528,    0,    0, 
            0,  516,    0,    0,  101,    0,    0,    0,  516,    0, 
          516,    0,  516,  516,  516,  516,  516,  516,  516,  519, 
          516,  120,  516,  519,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  519,    0,    0,  516,    0,    0,    0,    0,    0, 
          517,  517,  517,    0,    0,    0,  517,  517,    0,  517, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  517,  517, 
            0,  517,  517,  517,  517,  517,    0,    0,    0,  518, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  518, 
            0,    0,    0,    0,    0,  517, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

          517,  517,  517,  517,  517,  517,  517,  517,  517,  517, 
          517,  517,  517,    0,    0,  517,  517,  517,  517,    0, 
          529,    0,    0,    0,  517,    0,    0,  100,    0,    0, 
            0,  517,    0,  517,    0,  517,  517,  517,  517,  517, 
          517,  517,  518,  517,  119,  517,  518,    0,  290,  290, 
          290,    0,    0,  290,  290,  290,    0,  290,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  518,    0,    0,  517,    0,  290, 
          290,  290,  290,  290,    0,    0,    0,    0,    0,    0, 
            0,    0,  520,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  520,    0,    0,    0,  519,  519,  519,    0, 
            0,    0,  519,  519,    0,  519,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  290,    0,    0,  290,    0, 
            0,    0,    0,    0,  519,  519,  102,  519,  519,  519, 
          519,  519,    0,    0,    0,    0,    0,    0,    0,  290, 
            0,  520,    0,  121,    0,  520,    0,    0,    0,    0, 
            0,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,    0,    0,  519,  519,  519, 
          519,  290,  531,  520,    0,    0,  519,    0,    0,    0, 
            0,    0,    0,  519,    0,  519,    0,  519,  519,  519, 
          519,  519,  519,  519,  511,  519,    0,  519,    0,    0, 
            0,    0,    0,    0,  511,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  519, 
            0,    0,    0,    0,    0,  518,  518,  518,   93,    0, 
            0,  518,  518,    0,  518,    0,    0,    0,    0,    0, 
            0,    0,    0,  511,    0,  112,    0,  511,    0,    0, 
            0,    0,    0,  518,  518,    0,  518,  518,  518,  518, 
          518,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  511,    0,    0,    0,    0, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  510,    0,  518,  518,  518,  518, 
            0,  530,    0,    0,  510,  518,    0,    0,    0,    0, 
            0,    0,  518,    0,  518,    0,  518,  518,  518,  518, 
          518,  518,  518,    0,  518,    0,  518,    0,    0,    0, 
            0,    0,    0,    0,  520,  520,  520,    0,   92,    0, 
          520,  520,    0,  520,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  510,    0,  111,    0,  510,  518,    0, 
            0,    0,  520,  520,    0,  520,  520,  520,  520,  520, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  510,    0,    0,    0,  520, 
          520,  520,  520,  520,  520,  520,  520,  520,  520,  520, 
          520,  520,  520,    0,    0,  520,  520,  520,  520,    0, 
          532,    0,    0,    0,  520,    0,    0,    0,    0,    0, 
            0,  520,    0,  520,  513,  520,  520,  520,  520,  520, 
          520,  520,    0,  520,  513,  520,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  511,  511,  511,    0, 
            0,    0,  511,  511,    0,  511,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  520,   95,    0, 
            0,    0,    0,    0,  511,  511,    0,  511,  511,  511, 
          511,  511,    0,  513,    0,  114,    0,  513,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  511,  511,  511,  511,  511,  511,  511,  511,  511, 
          511,  511,  511,  511,  511,  513,    0,  511,  511,  511, 
          511,    0,  523,    0,    0,    0,  511,    0,    0,    0, 
            0,    0,    0,  511,  302,  511,    0,  511,  511,  511, 
          511,  511,  511,  511,  302,  511,    0,  511,    0,    0, 
            0,    0,    0,    0,    0,    0,  510,  510,  510,    0, 
            0,    0,  510,  510,    0,  510,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  109,  511, 
            0,    0,    0,    0,  510,  510,    0,  510,  510,  510, 
          510,  510,    0,  302,    0,  128,    0,  302,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  510,  510,  510,  510,  510,  510,  510,  510,  510, 
          510,  510,  510,  510,  510,  302,    0,  510,  510,  510, 
          510,    0,  522,    0,    0,    0,  510,    0,    0,    0, 
            0,    0,    0,  510,    0,  510,  313,  510,  510,  510, 
          510,  510,  510,  510,    0,  510,  313,  510,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  513,  513,  513,  510, 
          108,    0,  513,  513,    0,  513,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  313,    0,  127,    0,  313, 
            0,    0,    0,    0,  513,  513,    0,  513,  513,  513, 
          513,  513,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  313,    0,    0, 
            0,  513,  513,  513,  513,  513,  513,  513,  513,  513, 
          513,  513,  513,  513,  513,  230,    0,  513,  513,  513, 
          513,    0,  525,    0,    0,  230,  513,    0,    0,    0, 
            0,    0,    0,  513,    0,  513,    0,  513,  513,  513, 
          513,  513,  513,  513,    0,  513,    0,  513,    0,    0, 
            0,    0,    0,    0,    0,    0,  302,  302,  302,  230, 
            0,    0,  302,  302,    0,  302,    0,    0,    0,    0, 
            0,    0,    0,  230,  230,    0,    0,    0,  230,  513, 
            0,    0,    0,    0,  302,  302,    0,  302,  302,  302, 
          302,  302,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  302,  302,  302,  302,  302,  302,  302,  302,  302, 
          302,  302,  302,  302,  302,    0,    0,  302,  302,  302, 
          302,    0,  231,    0,    0,    0,  302,    0,    0,    0, 
            0,    0,  231,  302,    0,  302,    0,  302,  302,  302, 
          302,  302,  302,  302,    0,  302,    0,  302,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  313,  313, 
          313,    0,    0,    0,  313,  313,  231,  313,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  302, 
          231,  231,    0,    0,    0,  231,  313,  313,    0,  313, 
          313,  313,  313,  313,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  313,  313,  313,  313,  313,  313,  313, 
          313,  313,  313,  313,  313,  313,  313,    0,    0,  313, 
          313,  313,  313,    0,    0,    0,    0,    0,  313,    0, 
            0,    0,    0,    0,    0,  313,    0,  313,    0,  313, 
          313,  313,  313,  313,  313,  313,    0,  313,    0,  313, 
            0,    0,    0,    0,    0,    0,    0,  230,  230,  230, 
            0,    0,  230,  230,  230,    0,  230,    0,  254,    0, 
            0,    0,    0,    0,    0,    0,  230,  230,  254,    0, 
            0,  313,    0,    0,    0,  230,  230,    0,  230,  230, 
          230,  230,  230,    0,    0,    0,    0,    0,    0,    0, 
          230,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  254,  230,  230,  230,  230,  230,  230,  230, 
          230,  230,  230,    0,  230,  230,  254,  254,  230,  230, 
            0,  254,    0,    0,  230,    0,    0,  230,    0,    0, 
          230,    0,  230,    0,    0,    0,  230,    0,    0,    0, 
          230,  230,  230,  230,  230,    0,  230,    0,  230,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          230,    0,    0,    0,  231,  231,  231,    0,    0,  231, 
          231,  231,    0,  231,    0,  255,    0,    0,    0,    0, 
          230,    0,    0,  231,  231,  255,    0,    0,    0,    0, 
            0,    0,  231,  231,    0,  231,  231,  231,  231,  231, 
            0,    0,    0,    0,    0,    0,    0,  231,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  255, 
          231,  231,  231,  231,  231,  231,  231,  231,  231,  231, 
            0,  231,  231,  255,  255,  231,  231,    0,  255,    0, 
            0,  231,    0,    0,  231,    0,    0,  231,    0,  231, 
            0,    0,    0,  231,    0,    0,    0,  231,  231,  231, 
          231,  231,    0,  231,    0,  231,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  231,    0,    0, 
            0,    0,    0,    0,  241,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  241,    0,    0,  231,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          254,  254,  254,    0,    0,  254,  254,  254,  241,  254, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  254, 
          254,    0,  241,  241,    0,    0,    0,  241,  254,  254, 
            0,  254,  254,  254,  254,  254,    0,    0,    0,    0, 
            0,    0,    0,  254,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  254,  254,  254,  254, 
          254,  254,  254,  254,  254,  254,    0,  254,  254,    0, 
            0,  254,  254,    0,    0,    0,    0,  254,    0,    0, 
          254,  239,    0,  254,    0,  254,    0,    0,    0,  254, 
            0,  239,    0,    0,    0,  254,  254,  254,    0,  254, 
            0,  254,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  254,    0,    0,    0,  255,  255,  255, 
            0,    0,  255,  255,  255,  239,  255,    0,    0,    0, 
            0,    0,    0,  254,    0,    0,  255,  255,    0,  239, 
          239,    0,    0,    0,  239,  255,  255,    0,  255,  255, 
          255,  255,  255,    0,    0,    0,    0,    0,    0,    0, 
          255,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  255,  255,  255,  255,  255,  255,  255, 
          255,  255,  255,    0,  255,  255,    0,    0,  255,  255, 
            0,    0,    0,    0,  255,    0,    0,  255,    0,    0, 
          255,    0,  255,    0,    0,    0,  255,    0,    0,    0, 
            0,    0,  255,  255,  255,    0,  255,    0,  255,    0, 
            0,    0,    0,    0,    0,    0,  241,  241,  241,    0, 
          255,  241,  241,  241,    0,  241,    0,  240,    0,    0, 
            0,    0,    0,    0,    0,  241,  241,  240,    0,    0, 
          255,    0,    0,    0,  241,  241,    0,  241,  241,  241, 
          241,  241,    0,    0,    0,    0,    0,    0,    0,  241, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  240,  241,  241,  241,  241,  241,  241,  241,  241, 
          241,  241,    0,  241,  241,  240,  240,    0,    0,    0, 
          240,    0,    0,  241,    0,    0,  241,    0,    0,  241, 
            0,  241,    0,    0,    0,  241,    0,    0,    0,    0, 
            0,  241,  241,  241,    0,  241,    0,  241,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  241, 
            0,    0,    0,  239,  239,  239,    0,    0,  239,  239, 
          239,    0,  239,    0,  244,    0,    0,    0,    0,  241, 
            0,    0,  239,  239,  244,    0,    0,    0,    0,    0, 
            0,  239,  239,    0,  239,  239,  239,  239,  239,    0, 
            0,    0,    0,    0,    0,    0,  239,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  244,  239, 
          239,  239,  239,  239,  239,  239,  239,  239,  239,    0, 
          239,  239,  244,  244,    0,    0,    0,  244,    0,    0, 
          239,    0,    0,  239,    0,    0,  239,    0,  239,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  239,  239, 
          239,    0,  239,    0,  239,    0,    0,    0,    0,    0, 
            0,  246,    0,    0,    0,    0,  239,    0,    0,    0, 
            0,  246,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  239,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  246,    0,    0,    0,  240, 
          240,  240,    0,    0,  240,  240,  240,    0,  240,  246, 
          246,    0,    0,    0,  246,    0,    0,    0,  240,  240, 
            0,    0,    0,    0,    0,    0,    0,  240,  240,    0, 
          240,  240,  240,  240,  240,    0,    0,    0,    0,    0, 
            0,    0,  240,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  240,  240,  240,  240,  240, 
          240,  240,  240,  240,  240,    0,  240,  240,    0,    0, 
          245,    0,    0,    0,    0,    0,  240,    0,    0,  240, 
          245,    0,  240,    0,  240,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  240,  240,  240,    0,  240,    0, 
          240,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  240,    0,  245,    0,  244,  244,  244,    0, 
            0,  244,  244,  244,    0,  244,    0,    0,  245,  245, 
            0,    0,  240,  245,    0,  244,  244,    0,    0,    0, 
            0,    0,    0,    0,  244,  244,    0,  244,  244,  244, 
          244,  244,    0,    0,    0,    0,    0,    0,    0,  244, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  244,  244,  244,  244,  244,  244,  244,  244, 
          244,  244,    0,  244,  244,    0,    0,    0,    0,    0, 
            0,    0,  243,  244,    0,    0,  244,    0,    0,  244, 
            0,  244,  243,    0,    0,    0,    0,    0,    0,    0, 
            0,  244,  244,  246,  246,  246,    0,  244,  246,  246, 
          246,    0,  246,    0,    0,    0,    0,    0,    0,  244, 
            0,    0,  246,  246,    0,    0,  243,    0,    0,    0, 
            0,  246,  246,    0,  246,  246,  246,  246,  246,  244, 
          243,  243,    0,    0,    0,  243,  246,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  246, 
          246,  246,  246,  246,  246,  246,  246,  246,  246,    0, 
          246,  246,    0,    0,    0,    0,    0,    0,    0,    0, 
          246,    0,    0,  246,    0,    0,  246,    0,  246,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  246,  246, 
          247,    0,    0,    0,  246,    0,    0,    0,    0,    0, 
          247,    0,    0,    0,    0,    0,  246,    0,    0,    0, 
            0,    0,  245,  245,  245,    0,    0,  245,  245,  245, 
            0,  245,    0,    0,    0,    0,  246,    0,    0,    0, 
            0,  245,  245,    0,  247,    0,    0,    0,    0,    0, 
          245,  245,    0,  245,  245,  245,  245,  245,  247,  247, 
            0,    0,    0,  247,    0,  245,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  245,  245, 
          245,  245,  245,  245,  245,  245,  245,  245,    0,  245, 
          245,    0,    0,    0,    0,    0,    0,    0,    0,  245, 
            0,    0,  245,  248,    0,  245,    0,  245,    0,    0, 
            0,    0,    0,  248,    0,    0,    0,  245,  245,    0, 
            0,    0,    0,  245,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  245,    0,    0,    0,    0, 
            0,    0,    0,    0,  243,  243,  243,  248,    0,  243, 
          243,  243,    0,  243,    0,  245,    0,    0,    0,    0, 
            0,  248,  248,  243,  243,    0,  248,    0,    0,    0, 
            0,    0,  243,  243,    0,  243,  243,  243,  243,  243, 
            0,    0,    0,    0,    0,    0,    0,  243,    0,  249, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  249, 
          243,  243,  243,  243,  243,  243,  243,  243,  243,  243, 
            0,  243,  243,    0,    0,    0,    0,    0,    0,    0, 
            0,  243,    0,    0,  243,    0,    0,  243,    0,  243, 
            0,    0,    0,  249,    0,    0,    0,    0,    0,  243, 
          243,    0,    0,    0,    0,  243,    0,  249,  249,    0, 
            0,    0,  249,    0,    0,    0,    0,  243,    0,    0, 
            0,    0,  247,  247,  247,    0,    0,  247,  247,  247, 
            0,  247,    0,    0,    0,  256,    0,  243,    0,    0, 
            0,  247,  247,    0,    0,  256,    0,    0,    0,    0, 
          247,  247,    0,  247,  247,  247,  247,  247,    0,    0, 
            0,    0,    0,    0,    0,  247,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  256, 
            0,    0,    0,    0,  247,  247,    0,    0,    0,  247, 
          247,    0,    0,  256,  256,    0,    0,    0,  256,  247, 
            0,    0,  247,    0,    0,  247,    0,  247,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  247,    0,  248,  248,  248,    0,    0, 
          248,  248,  248,    0,  248,  247,    0,    0,  250,    0, 
            0,    0,    0,    0,  248,  248,    0,    0,  250,    0, 
            0,    0,    0,  248,  248,  247,  248,  248,  248,  248, 
          248,    0,    0,    0,    0,    0,    0,    0,  248,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  250,    0,    0,    0,    0,  248,  248,    0, 
            0,    0,  248,  248,    0,    0,  250,  250,    0,    0, 
            0,  250,  248,    0,    0,  248,    0,    0,  248,    0, 
          248,  249,  249,  249,    0,    0,  249,  249,  249,    0, 
          249,    0,    0,    0,  251,    0,  248,    0,    0,    0, 
          249,  249,    0,    0,  251,    0,    0,    0,  248,  249, 
          249,    0,  249,  249,  249,  249,  249,    0,    0,    0, 
            0,    0,    0,    0,  249,    0,    0,    0,  248,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  251,    0, 
            0,    0,    0,  249,  249,    0,    0,    0,  249,  249, 
            0,    0,  251,  251,    0,    0,    0,  251,  249,    0, 
            0,  249,    0,    0,  249,    0,  249,  256,  256,  256, 
            0,    0,  256,  256,  256,    0,  256,    0,    0,    0, 
          257,    0,  249,    0,    0,    0,  256,  256,    0,    0, 
          257,    0,    0,    0,  249,  256,  256,    0,  256,  256, 
          256,  256,  256,    0,    0,    0,    0,    0,    0,    0, 
          256,    0,    0,    0,  249,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  257,    0,    0,    0,    0,  256, 
          256,    0,    0,    0,  256,  256,    0,    0,  257,  257, 
            0,    0,    0,  257,  256,    0,    0,  256,    0,    0, 
          256,    0,  256,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  256,    0, 
          250,  250,  250,    0,    0,  250,  250,  250,    0,  250, 
          256,    0,    0,  228,    0,    0,    0,    0,    0,  250, 
          250,    0,    0,  228,    0,    0,    0,    0,  250,  250, 
          256,  250,  250,  250,  250,  250,    0,    0,    0,    0, 
            0,    0,    0,  250,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  228,    0,    0, 
            0,    0,  250,  250,    0,    0,    0,  250,  250,    0, 
            0,  228,  228,    0,    0,    0,  228,  250,    0,    0, 
          250,    0,    0,  250,    0,  250,  251,  251,  251,    0, 
            0,  251,  251,  251,    0,  251,    0,    0,    0,  229, 
            0,  250,    0,    0,    0,  251,  251,    0,    0,  229, 
            0,    0,    0,  250,  251,  251,    0,  251,  251,  251, 
          251,  251,    0,    0,    0,    0,    0,    0,    0,  251, 
            0,    0,    0,  250,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  229,    0,    0,    0,    0,  251,  251, 
            0,    0,    0,  251,  251,    0,    0,  229,  229,    0, 
            0,    0,  229,  251,    0,    0,  251,    0,    0,  251, 
            0,  251,  257,  257,  257,    0,    0,  257,  257,  257, 
            0,  257,    0,    0,    0,  227,    0,  251,    0,    0, 
            0,  257,  257,    0,    0,  227,    0,    0,    0,  251, 
          257,  257,    0,  257,  257,  257,  257,  257,    0,    0, 
            0,    0,    0,    0,    0,  257,    0,    0,    0,  251, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  227, 
            0,    0,    0,    0,    0,  257,    0,    0,    0,  257, 
          257,    0,    0,  227,  227,    0,    0,    0,    0,  257, 
            0,    0,  257,    0,    0,  257,    0,  257,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  257,    0,  228,  228,  228,    0,    0, 
          228,  228,  228,    0,  228,  257,    0,    0,  226,    0, 
            0,    0,    0,    0,  228,  228,    0,    0,  226,    0, 
            0,    0,    0,  228,  228,  257,  228,  228,  228,  228, 
          228,    0,    0,    0,    0,    0,    0,    0,  228,    0, 
            0,    0,    0,    0,    0,    0,    0,  224,    0,    0, 
            0,    0,  226,    0,    0,    0,    0,  224,    0,    0, 
            0,    0,    0,    0,    0,    0,  226,  226,    0,    0, 
            0,    0,  228,    0,    0,  228,    0,    0,  228,    0, 
          228,  229,  229,  229,    0,    0,  229,  229,  229,    0, 
          229,  224,    0,    0,    0,    0,  228,    0,    0,    0, 
          229,  229,    0,    0,    0,  224,  224,    0,  228,  229, 
          229,    0,  229,  229,  229,  229,  229,    0,    0,    0, 
            0,    0,    0,    0,  229,    0,    0,    0,  228,    0, 
            0,    0,    0,  225,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  225,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  229,    0, 
            0,  229,    0,    0,  229,    0,  229,  227,  227,  227, 
            0,    0,  227,  227,  227,    0,  227,  225,    0,    0, 
            0,    0,  229,    0,    0,    0,  227,  227,    0,    0, 
            0,  225,  225,    0,  229,  227,  227,    0,  227,  227, 
          227,  227,  227,    0,    0,    0,    0,    0,    0,    0, 
          227,    0,    0,    0,  229,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  227,    0,    0,  227,  222,    0, 
          227,    0,  227,    0,    0,    0,    0,    0,  222,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  227,    0, 
          226,  226,  226,    0,    0,  226,  226,  226,    0,  226, 
          227,    0,    0,    0,    0,    0,    0,  223,    0,  226, 
          226,    0,  222,    0,    0,    0,    0,  223,  226,  226, 
          227,  226,  226,  226,  226,  226,  222,  222,    0,  224, 
          224,  224,    0,  226,  224,  224,  224,    0,  224,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  224,  224, 
            0,  223,    0,    0,    0,    0,    0,  224,  224,    0, 
          224,  224,  224,  224,  224,  223,  223,  226,    0,    0, 
          226,    0,  224,  226,    0,  226,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  226,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  226,    0,    0,  224,    0,    0,  224, 
            0,    0,  224,    0,  224,  225,  225,  225,    0,    0, 
          225,  225,  225,  226,  225,    0,  218,    0,    0,    0, 
          224,    0,    0,    0,  225,  225,  218,    0,    0,    0, 
            0,    0,  224,  225,  225,    0,  225,  225,  225,  225, 
          225,    0,    0,    0,    0,    0,    0,    0,  225,    0, 
            0,    0,  224,    0,    0,  220,    0,    0,    0,    0, 
          218,    0,    0,    0,    0,  220,    0,    0,    0,    0, 
            0,    0,    0,    0,  218,  218,    0,    0,    0,    0, 
            0,    0,  225,    0,    0,  225,    0,    0,  225,    0, 
          225,    0,    0,    0,    0,    0,    0,    0,    0,  220, 
            0,    0,    0,    0,    0,    0,  225,    0,    0,    0, 
            0,    0,    0,  220,  220,    0,    0,    0,  225,    0, 
          222,  222,  222,    0,    0,  222,  222,  222,    0,  222, 
            0,    0,    0,    0,    0,    0,    0,    0,  225,  222, 
          222,    0,    0,    0,    0,    0,    0,    0,  222,  222, 
            0,  222,  222,  222,  222,  222,    0,    0,    0,  223, 
          223,  223,    0,  222,  223,  223,  223,    0,  223,    0, 
          259,    0,    0,    0,    0,    0,    0,    0,  223,  223, 
          259,    0,    0,    0,    0,    0,    0,  223,  223,    0, 
          223,  223,  223,  223,  223,    0,    0,  222,    0,    0, 
          222,    0,  223,  222,    0,  222,    0,    0,    0,    0, 
            0,    0,    0,    0,  259,    0,    0,    0,    0,    0, 
            0,  222,    0,    0,    0,    0,    0,    0,  259,  259, 
            0,    0,    0,  222,    0,    0,  223,    0,    0,  223, 
            0,    0,  223,    0,  223,    0,    0,    0,    0,    0, 
            0,    0,    0,  222,    0,    0,  221,    0,    0,    0, 
          223,    0,    0,    0,    0,    0,  221,    0,    0,    0, 
            0,    0,  223,    0,    0,    0,    0,    0,  218,  218, 
          218,    0,    0,  218,  218,  218,    0,  218,    0,    0, 
            0,    0,  223,    0,    0,  261,    0,  218,  218,    0, 
          221,    0,    0,    0,    0,  261,  218,  218,    0,  218, 
          218,  218,  218,  218,  221,  221,    0,  220,  220,  220, 
            0,  218,  220,  220,  220,    0,  220,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  220,  220,    0,  261, 
            0,    0,    0,    0,    0,  220,  220,    0,  220,  220, 
          220,  220,  220,    0,  261,  218,    0,    0,  218,    0, 
          220,  218,    0,  218,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  218, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  218,    0,    0,  220,    0,    0,  220,  219,    0, 
          220,    0,  220,    0,    0,    0,    0,    0,  219,    0, 
            0,  218,    0,    0,    0,    0,    0,    0,  220,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          220,    0,  259,  259,  259,    0,    0,  259,  259,  259, 
            0,  259,  219,    0,    0,    0,    0,    0,    0,    0, 
          220,  259,  259,    0,    0,    0,  219,  219,    0,    0, 
          259,  259,    0,  259,  259,  259,  259,  259,    0,    0, 
            0,    0,    0,    0,    0,  259,    0,    0,    0,    0, 
            0,    0,    0,    0,  217,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  217,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  259, 
            0,    0,  259,    0,    0,  259,    0,  259,  221,  221, 
          221,    0,    0,  221,  221,  221,    0,  221,  217,    0, 
            0,    0,    0,  259,    0,    0,    0,  221,  221,    0, 
            0,    0,  217,  217,    0,  259,  221,  221,    0,  221, 
          221,  221,  221,  221,    0,    0,    0,  261,  261,  261, 
            0,  221,  261,  261,  261,  259,  261,    0,    0,    0, 
          286,    0,    0,    0,    0,    0,  261,  261,    0,    0, 
          286,    0,    0,    0,    0,  261,  261,    0,  261,  261, 
          261,  261,  261,    0,    0,  221,    0,    0,  221,    0, 
          261,  221,    0,  221,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  640,  286,    0,    0,    0,    0,  221, 
            0,    0,    0,  640,    0,    0,    0,    0,    0,  286, 
            0,  221,    0,    0,  261,    0,    0,  261,    0,    0, 
          261,    0,  261,    0,    0,    0,    0,    0,    0,    0, 
            0,  221,    0,    0,    0,    0,    0,    0,  261,    0, 
          219,  219,  219,    0,    0,  219,  219,  219,    0,  219, 
          261,    0,  640,    0,    0,    0,    0,    0,    0,  219, 
          219,    0,    0,    0,    0,    0,    0,    0,  219,  219, 
          261,  219,  219,  219,  219,    0,    0,    0,    0,   60, 
            0,    0,    0,  219,    0,    0,    0,    0,    0,   60, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  219,    0,    0, 
          219,    0,    0,  219,    0,  219,  217,  217,  217,    0, 
            0,  217,  217,  217,    0,  217,    0,   64,   60,    0, 
            0,  219,    0,    0,    0,  217,  217,   64,    0,    0, 
            0,    0,    0,  219,  217,  217,    0,  217,  217,  217, 
          217,    0,    0,    0,    0,    0,    0,    0,    0,  217, 
            0,    0,    0,  219,    0,    0,   62,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   62,    0,    0,    0, 
            0,    0,  291,    0,    0,    0,   64,    0,    0,    0, 
            0,    0,  291,  217,    0,    0,  217,    0,    0,  217, 
            0,  217,  286,  286,  286,    0,    0,  286,  286,  286, 
            0,  286,    0,    0,    0,    0,    0,  217,    0,    0, 
            0,  286,  286,    0,    0,   62,  287,    0,    0,  217, 
          286,  286,    0,  286,  286,  286,  286,  286,    0,    0, 
            0,  291,    0,    0,    0,  640,  640,  640,    0,  217, 
          640,  640,  640,    0,  640,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  640,  640,    0,    0,    0,    0, 
            0,    0,    0,  640,  640,    0,  640,  640,  640,  640, 
          640,    0,  286,    0,    0,  286,    0,  286,    0,    0, 
            0,    0,    0,    0,    0,  217,    0,    0,    0,    0, 
            0,    0,    0,  286,    0,  217,    0,    0,    0,    0, 
            0,  289,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  289,    0,    0,    0,  640,    0,    0,  640,    0, 
          640,   60,   60,   60,    0,  286,   60,   60,   60,  261, 
           60,    0,    0,    0,    0,    0,  640,    0,    0,    0, 
           60,   60,    0,    0,  217,  284,    0,    0,    0,   60, 
           60,    0,   60,   60,   60,   60,   60,  303,    0,    0, 
          289,    0,    0,    0,    0,    0,    0,    0,  640,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   64, 
           64,   64,    0,    0,   64,   64,   64,    0,   64,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   64,   64, 
            0,   60,    0,    0,   60,    0,    0,   64,   64,    0, 
           64,   64,   64,   64,   64,    0,    0,    0,   62,   62, 
           62,    0,   60,   62,   62,   62,    0,   62,    0,    0, 
            0,    0,    0,    0,  291,  291,  291,   62,   62,  291, 
          291,  291,    0,  291,    0,    0,   62,   62,    0,   62, 
           62,   62,   62,   62,   60,    0,    0,    0,    0,   64, 
            0,    0,   64,    0,    0,  291,  291,  291,  291,  291, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           64,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  129,    0,   62,    0, 
            0,   62,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  291,   64,    0,  291,    0,    0,    0,    0,   62, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  291,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  129,    0,  217,  217,  217, 
            0,   62,    0,  217,  217,    0,  217,    0,    0,    0, 
            0,    0,    0,  289,  289,  289,    0,  291,    0,  289, 
          289,    0,  289,    0,    0,  217,  217,  509,  217,  217, 
          217,  217,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  289,  289,  289,  289,  289,    0, 
            0,    0,    0,    0,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,  217,    0,    0, 
           19,   20,   21,  234,  235,  236,  237,  130,    0,  117, 
            0,    0,    0,  289,    0,    0,   28,    0,  217,  238, 
          239,  240,    0,  241,   35,  242,  243,  244,  245,  280, 
           40,   41,   42,   43,  289,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          217,    0,    0,    0,  246,    0,  130,  130,    0,    0, 
           46,   47,    0,   48,    0,  281,  289,  282,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  283,    0,    0, 
            0,    0,   52,  284,   54,   55,   56,   57,  512,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   65, 
           66,  285,  129,  129,  129,  129,  129,  129,  129,  129, 
          129,  129,  129,    0,    0,  129,  129,    0,  129,  129, 
          129,  129,  129,  129,  129,    0,  610,    0,    0,  129, 
          129,  129,  129,  129,  129,  129,  129,    0,  129,    0, 
            0,    0,    0,    0,  129,  129,    0,  129,  129,  129, 
          129,    0,  129,  129,  129,  129,  129,  129,    0,  129, 
          129,  129,  129,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  509,    0,    0,    0,    0,    0, 
            0,  509,  509,  129,    0,  129,  129,  610,    0,  129, 
          129,    0,  129,    0,  129,    0,    0,    0,  129,    0, 
            0,    0,    0,  129,    0,    0,  129,    0,  610,    0, 
            0,  129,  129,  129,  129,  129,  129,  617,    0,    0, 
          129,    0,  129,  129,    0,  129,  129,  129,  129,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  129,  129, 
            0,    0,    0,  130,  130,  130,  130,  130,  130,  130, 
          130,  130,  130,  130,    0,    0,  130,  130,    0,  130, 
          130,  130,  130,  130,  130,  130,    0,  611,    0,    0, 
          130,  130,  130,  130,  130,  130,  130,  130,    0,  130, 
            0,    0,    0,    0,    0,  130,  130,    0,  130,  130, 
          130,  130,    0,  130,  130,  130,  130,  130,  130,    0, 
          130,  130,  130,  130,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  512,    0,    0,    0,    0, 
            0,    0,  512,  512,  130,    0,  130,  130,  611,    0, 
          130,  130,    0,  130,    0,  130,    0,    0,    0,  130, 
            0,    0,    0,    0,  130,    0,    0,  130,    0,  611, 
            0,    0,  130,  130,  130,  130,  130,  130,  312,    0, 
            0,  130,    0,  130,  130,    0,  130,  130,  130,  130, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  130, 
          130,    0,  129,  129,  129,  129,  129,  129,  129,  129, 
          129,  129,  129,    0,    0,  129,  129,    0,  129,  129, 
          129,  129,  129,  129,  129,    0,  617,    0,    0,  129, 
          129,  129,  129,  129,  129,  129,  130,    0,  129,    0, 
            0,    0,    0,    0,  129,  129,    0,  129,  129,  129, 
          129,    0,  129,  129,  129,  129,  129,  129,    0,  129, 
          129,  129,  129,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  617,    0,    0,    0,    0,    0, 
            0,  617,  617,  129,    0,  130,  129,  613,    0,  129, 
          129,    0,  129,    0,  129,    0,    0,    0,  129,    0, 
            0,    0,    0,  129,    0,    0,  129,    0,  617,    0, 
            0,  129,  129,  129,  129,  129,  129,  313,    0,    0, 
          129,    0,  129,  129,    0,  129,  129,  129,  129,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  129,  129, 
            0,    0,    0,  130,  130,  130,  130,  130,  130,  130, 
          130,  130,  130,  130,    0,    0,  130,  130,    0,  130, 
          130,  130,  130,  130,  130,  130,    0,    0,    0,    0, 
          130,  130,  130,  130,  130,  130,  130,  357,    0,  130, 
            0,    0,    0,    0,    0,  130,  130,    0,  130,  130, 
          130,  130,    0,  130,  130,  130,  130,  130,  130,    0, 
          130,  130,  130,  130,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  312,    0,    0,    0,    0, 
            0,    0,  312,  312,  130,    0,  357,  130,  614,    0, 
          130,  130,    0,  130,    0,  130,    0,    0,    0,  130, 
            0,    0,    0,    0,  130,    0,    0,  130,    0,    0, 
            0,    0,  130,  130,  130,  130,  130,  130,    0,    0, 
            0,  130,    0,  130,  130,    0,  130,  130,  130,  130, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  130, 
          130,    0,  130,  130,  130,  130,  130,  130,  130,  130, 
          130,  130,  130,    0,    0,  130,  130,    0,  130,  130, 
          130,  130,  130,  130,  130,    0,    0,    0,    0,  130, 
          130,  130,  130,  130,  130,  130,  304,    0,  130,    0, 
            0,    0,    0,    0,  130,  130,    0,  130,  130,  130, 
          130,    0,  130,  130,  130,  130,  130,  130,    0,  130, 
          130,  130,  130,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  313,    0,    0,    0,    0,    0, 
            0,  313,  313,  130,    0,  304,  130,    0,    0,  130, 
          130,    0,  130,    0,  130,    0,    0,    0,  130,    0, 
            0,    0,    0,  130,    0,    0,  130,    0,    0,    0, 
            0,  130,  130,  130,  130,  130,  130,    0,    0,    0, 
          130,    0,  130,  130,    0,  130,  130,  130,  130,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  130,  130, 
            0,    0,    0,  357,  357,  357,  357,  357,  357,  357, 
          357,  357,  357,  357,    0,  357,  357,  357,  357,  357, 
          357,  357,  357,  357,  357,  357,    0,    0,    0,    0, 
          357,  357,  357,  357,  357,  357,  357,  537,    0,  357, 
            0,    0,    0,    0,    0,  357,  357,    0,  357,  357, 
          357,  357,    0,  357,  357,  357,  357,  357,  357,    0, 
          357,  357,  357,  357,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  357,    0,  537,  357,    0,    0, 
          357,  357,    0,  357,    0,  357,    0,    0,    0,  357, 
            0,    0,    0,    0,    0,    0,    0,  357,    0,    0, 
            0,    0,  357,  357,  357,  357,  357,  357,    0,    0, 
            0,  357,    0,  357,  357,    0,  357,  357,  357,  357, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  357, 
          357,    0,  304,  304,  304,  304,  304,  304,  304,  304, 
          304,  304,  304,    0,    0,  304,  304,    0,  304,  304, 
          304,  304,  304,  304,  304,    0,    0,  639,    0,  304, 
          304,  304,  304,  304,  304,  304,    0,    0,  304,    0, 
            0,    0,    0,    0,  304,  304,    0,  304,  304,  304, 
          304,    0,  304,  304,  304,  304,  304,  304,    0,  304, 
          304,  304,  304,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  639,    0,    0,    0, 
            0,    0,    0,  304,    0,    0,  304,    0,    0,  304, 
          304,    0,  304,    0,  304,    0,    0,    0,  304,    0, 
            0,    0,    0,    0,    0,    0,  304,    0,   18,    0, 
            0,  304,  304,  304,  304,  304,  304,    0,    0,    0, 
          304,    0,  304,  304,    0,  304,  304,  304,  304,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  304,  304, 
            0,    0,    0,  537,  537,  537,  537,  537,  537,  537, 
          537,  537,  537,  537,    0,    0,  537,  537,    0,  537, 
          537,  537,  537,  537,  537,  537,  639,    0,    0,    0, 
          537,  537,  537,  537,  537,  537,  537,    0,    0,  537, 
            0,    0,    0,    0,    0,  537,  537,    0,  537,  537, 
          537,  537,    0,  537,  537,  537,  537,  537,  537,    0, 
          537,  537,  537,  537,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  639,    0,    0,    0,    0, 
            0,    0,    0,    0,  537,    0,    0,  537,    0,    0, 
          537,  537,    0,  537,    0,  537,    0,    0,    0,  537, 
            0,    0,    0,    0,    0,    0,    0,  537,    0,    0, 
            0,    0,  537,  537,  537,  537,  537,  537,    0,    0, 
            0,  537,    0,  537,  537,    0,  537,  537,  537,  537, 
            0,    0,    0,  639,  639,  639,  639,  639,  639,  537, 
          537,  639,  639,  639,    0, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

            0,    0,  639,    0,  639,  639,  639,  639,  639,  639, 
          639,  255,    0,    0,    0,  639,  639,  639,  639,  639, 
          639,  639,    0,    0,  639,    0,    0,    0,    0,    0, 
          639,  639,    0,  639,  639,  639,  639,    0,  639,  639, 
          639,  639,  639,  639,    0,  639,  639,  639,  639,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          254,    0,    0,    0,    0,    0,    0,    0,    0,  639, 
            0,    0,  639,    0,    0,  639,  639,    0,  639,    0, 
          639,    0,    0,    0,  639,    0,    0,    0,    0,    0, 
            0,    0,  639,    0,    0,    0,    0,  639,  639,  639, 
          639,  639,  639,    0,    0,    0,  639,    0,  639,  639, 
            0,  639,  639,  639,  639,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  639,  639,    0,  639,  639,  639, 
          639,  639,  639,    0,    0,    0,  639,  639,    0,    0, 
          306,  639,    0,  639,  639,  639,  639,  639,  639,  639, 
            0,    0,    0,    0,  639,  639,  639,  639,  639,  639, 
          639,    0,    0,  639,    0,    0,    0,    0,    0,  639, 
          639,    0,  639,  639,  639,  639,    0,  639,  639,  639, 
          639,  639,  639,    0,  639,  639,  639,  639,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  639,    0, 
            0,  639,    0,    0,  639,  639,    0,  639,    0,  639, 
            0,    0,    0,  639,    0,    0,    0,    0,    0,    0, 
            0,  639,    0,    0,  639,    0,  639,  639,  639,  639, 
          639,  639,    0,    0,    0,  639,    0,  639,  639,    0, 
          639,  639,  639,  639,    0,    0,    0,    0,    4,    5, 
            6,    0,    8,  639,  639,    0,    9,   10,    0,  303, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,  234,  235,  236, 
          237,    0,    0,   26,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,  238,  239,  240,    0,  241,   35,  242, 
          243,  244,  245,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  246,    0, 
            0,  130,    0,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,    0,    0,  308,  308,  308, 
            0,  308,    0,   65,   66,  308,  308,    0,    0,    0, 
          308,    0,  308,  308,  308,  308,  308,  308,  308,    0, 
            0,    0,    0,  308,  308,  308,  308,  308,  308,  308, 
            0,    0,  308,    0,    0,    0,    0,    0,    0,  308, 
            0,    0,  308,  308,  308,    0,  308,  308,  308,  308, 
          308,  308,    0,  308,  308,  308,  308,  468,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  308,    0,    0, 
          308,    0,  306,  308,  308,    0,  308,    0,    0,    0, 
            0,    0,  308,    0,    0,    0,    0,    0,    0,    0, 
          308,    0,    0,    0,    0,  308,  308,  308,  308,  308, 
          308,    0,    0,    0,  308,    0,  308,  308,    0,  308, 
          308,  308,  308,    0,    0,    0,    4,    5,    6,    0, 
            8,    0,  308,  308,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,  234,  235,  236,  237,    0, 
            0,   26,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,  238,  239,  240,    0,  241,   35,  242,  243,  244, 
          245,    0,   40,   41,   42,   43,  468,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  246,    0,    0,  130, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,   51, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,    0,    0,    4,    5,    6,    7,    8, 
            0,   65,   66,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,    0,    0,   27,   28,   29,   30, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   44,    0,    0,   45,    0, 
            0,   46,   47,    0,   48,    0,   49,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,   51,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,    0,    0,    4,    5,    6,    7,  316,    0, 
           65,   66,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,    0,   26, 
            0,    0,    0,    0,    0,   27,   28,    0,   30,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   44,    0,    0,   45,    0,    0, 
           46,   47,    0,   48,    0,   49,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,   51,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,    3,    4,    5,    6,    7,    8,    0,   65, 
           66,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,    0,    0,    0,    0,   19, 
           20,   21,   22,   23,   24,   25,    0,    0,   26,    0, 
            0,    0,    0,    0,   27,   28,   29,   30,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   44,    0,    0,   45,    0,    0,   46, 
           47,    0,   48,    0,   49,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,   51,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
            0,  315,    4,    5,    6,    7,  316,    0,   65,   66, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,   26,    0,    0, 
            0,    0,    0,   27,   28,    0,   30,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   44,    0,    0,  317,    0,    0,   46,   47, 
            0,   48,    0,   49,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,   51,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,    0, 
          315,    4,    5,    6,    7,  316,    0,   65,   66,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
            0,    0,   27,   28,    0,   30,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   44,    0,    0,   45,    0,    0,   46,   47,    0, 
           48,    0,   49,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,   51,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,    0,    0, 
            4,    5,    6,    0,    8,    0,   65,   66,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,  234, 
          235,  236,  237,    0,    0,  117,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  238,  239,  240,    0,  241, 
           35,  242,  243,  244,  245,  280,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          246,    0,    0,  130,    0,    0,   46,   47,    0,   48, 
            0,  281,    0,  282,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  283,    0,    0,    0,    0,   52,  284, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,    0,    0,    0, 
            4,    5,    6,    0,    8,   65,   66,  285,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  108,  109, 
           17,   18,    0,    0,    0,    0,  110,  111,  112,  234, 
          235,  236,  237,    0,    0,  117,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  238,  239,  240,    0,  241, 
           35,  242,  243,  244,  245,  280,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          246,    0,    0,  130,    0,    0,   46,   47,    0,   48, 
            0,  710,    0,  282,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  283,    0,    0,    0,    0,   52,  284, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,    0,    0,    0, 
          279,  279,  279,    0,  279,   65,   66,  285,  279,  279, 
            0,    0,    0,  279,    0,  279,  279,  279,  279,  279, 
          279,  279,    0,    0,    0,    0,  279,  279,  279,  279, 
          279,  279,  279,    0,    0,  279,    0,    0,    0,    0, 
            0,    0,  279,    0,    0,  279,  279,  279,    0,  279, 
          279,  279,  279,  279,  279,  279,  279,  279,  279,  279, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          279,    0,    0,  279,    0,    0,  279,  279,    0,  279, 
            0,  279,    0,  279,    0,  279,    0,    0,    0,    0, 
            0,    0,    0,  279,    0,    0,    0,    0,  279,  279, 
          279,  279,  279,  279,    0,    0,    0,  279,    0,  279, 
          279,    0,  279,  279,  279,  279,    0,    0,    0,    0, 
            4,    5,    6,    0,    8,  279,  279,  279,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  108,  109, 
           17,   18,    0,    0,    0,    0,  110,  111,  112,  234, 
          235,  236,  237,    0,    0,  117,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  238,  239,  240,    0,  241, 
           35,  242,  243,  244,  245,  280,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          246,    0,    0,  130,    0,    0,   46,   47,    0,   48, 
            0,  281,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  283,    0,    0,    0,    0,   52,  284, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,    0,    0,    0, 
            4,    5,    6,    0,    8,   65,   66,  285,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  108,  109, 
           17,   18,    0,    0,    0,    0,  110,  111,  112,  234, 
          235,  236,  237,    0,    0,  117,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  238,  239,  240,    0,  241, 
           35,  242,  243,  244,  245,  280,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          246,    0,    0,  130,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,  282,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  283,    0,    0,    0,    0,   52,  284, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,    0,    0,    0, 
            4,    5,    6,    0,    8,   65,   66,  285,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  108,  109, 
           17,   18,    0,    0,    0,    0,  110,  111,  112,  234, 
          235,  236,  237,    0,    0,  117,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  238,  239,  240,    0,  241, 
           35,  242,  243,  244,  245,  280,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          246,    0,    0,  130,    0,    0,   46,   47,    0,   48, 
            0,  710,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  283,    0,    0,    0,    0,   52,  284, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,    0,    0,    0, 
            4,    5,    6,    0,    8,   65,   66,  285,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  108,  109, 
           17,   18,    0,    0,    0,    0,  110,  111,  112,  234, 
          235,  236,  237,    0,    0,  117,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  238,  239,  240,    0,  241, 
           35,  242,  243,  244,  245,  280,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          246,    0,    0,  130,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  283,    0,    0,    0,    0,   52,  284, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,    0,    0,    0, 
            4,    5,    6,    7,    8,   65,   66,  285,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,   22, 
           23,   24,   25,    0,    0,   26,    0,    0,    0,    0, 
            0,   27,   28,   29,   30,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           44,    0,    0,   45,    0,    0,   46,   47,    0,   48, 
            0,   49,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,   51,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,    0,    0,    4, 
            5,    6,    7,    8,    0,   65,   66,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,   26,    0,    0,    0,    0,    0, 
           27,   28,    0,   30,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   44, 
            0,    0,   45,    0,    0,   46,   47,    0,   48,    0, 
           49,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,   51,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,    0,    0,    4,    5, 
            6,    0,    8,    0,   65,   66,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,  108,  109,   17,   18, 
            0,    0,    0,    0,  110,  111,  112,  234,  235,  236, 
          237,    0,    0,  117,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,  238,  239,  240,    0,  241,   35,  242, 
          243,  244,  245,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  246,    0, 
            0,  130,  503,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,  283,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,    0,    0,    4,    5,    6, 
            0,    8,    0,   65,   66,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,    0,    0,   19,   20,   21,  234,  235,  236,  237, 
            0,    0,  117,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,  238,  239,  240,    0,  241,   35,  242,  243, 
          244,  245,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  246,    0,    0, 
          130,    0,    0,   46,   47,    0,   48,    0,  645,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          283,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,    0,    0,    4,    5,    6,    0, 
            8,    0,   65,   66,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  108,  109,   17,   18,    0,    0, 
            0,    0,  110,  111,  112,  234,  235,  236,  237,    0, 
            0,  117,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,  238,  239,  240,    0,  241,   35,  242,  243,  244, 
          245,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  246,    0,    0,  130, 
            0,    0,   46,   47,    0,   48,    0,  281,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  283, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,    0,    0,    4,    5,    6,    0,    8, 
            0,   65,   66,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  108,  109,   17,   18,    0,    0,    0, 
            0,  110,  111,  112,  234,  235,  236,  237,    0,    0, 
          117,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
          238,  239,  240,    0,  241,   35,  242,  243,  244,  245, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  246,    0,    0,  130,    0, 
            0,   46,   47,    0,   48,    0,  645,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,  283,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,    0,    0,    4,    5,    6,    0,    8,    0, 
           65,   66,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  108,  109,   17,   18,    0,    0,    0,    0, 
          110,  111,  112,  234,  235,  236,  237,    0,    0,  117, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  238, 
          239,  240,    0,  241,   35,  242,  243,  244,  245,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  246,    0,    0,  130,    0,    0, 
           46,   47,    0,   48,    0,  913,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  283,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,    0,    4,    5,    6,    0,    8,    0,   65, 
           66,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  108,  109,   17,   18,    0,    0,    0,    0,  110, 
          111,  112,  234,  235,  236,  237,    0,    0,  117,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  238,  239, 
          240,    0,  241,   35,  242,  243,  244,  245,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  246,    0,    0,  130,    0,    0,   46, 
           47,    0,   48,    0,  710,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  283,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
            0,    0,  628,  628,  628,    0,  628,    0,   65,   66, 
          628,  628,    0,    0,    0,  628,    0,  628,  628,  628, 
          628,  628,  628,  628,    0,    0,    0,    0,  628,  628, 
          628,  628,  628,  628,  628,    0,    0,  628,    0,    0, 
            0,    0,    0,    0,  628,    0,    0,  628,  628,  628, 
            0,  628,  628,  628,  628,  628,  628,    0,  628,  628, 
          628,  628,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  628,    0,    0,  628,  628,    0,  628,  628, 
            0,  628,    0,    0,    0,    0,    0,  628,    0,    0, 
            0,    0,    0,    0,    0,  628,    0,    0,    0,    0, 
          628,  628,  628,  628,  628,  628,    0,    0,    0,  628, 
            0,  628,  628,    0,  628,  628,  628,  628,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,  628,  628,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
          234,  235,  236,  237,    0,    0,   26,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  238,  239,  240,    0, 
          241,   35,  242,  243,  244,  245,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  246,    0,    0,  130,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,   51,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,    0,    0, 
            4,    5,    6,    0,    8,    0,   65,   66,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  108,  109, 
           17,   18,    0,    0,    0,    0,  110,  111,  112,  234, 
          235,  236,  237,    0,    0,  117,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  238,  239,  240,    0,  241, 
           35,  242,  243,  244,  245,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          246,    0,    0,  130,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  283,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,    0,    0,    4, 
            5,    6,    0,    8,    0,   65,   66,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,  234,  235, 
          236,  237,    0,    0,  117,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,  238,  239,  240,    0,  241,   35, 
          242,  243,  244,  245,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  246, 
            0,    0,  130,    0,    0,   46,   47,    0,   48,    0, 
            0,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,  283,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,    0,    0,  628,  628, 
          628,    0,  628,    0,   65,   66,  628,  628,    0,    0, 
            0,  628,    0,  628,  628,  628,  628,  628,  628,  628, 
            0,    0,    0,    0,  628,  628,  628,  628,  628,  628, 
          628,    0,    0,  628,    0,    0,    0,    0,    0,    0, 
          628,    0,    0,  628,  628,  628,    0,  628,  628,  628, 
          628,  628,  628,    0,  628,  628,  628,  628,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  628,    0, 
            0,  628,    0,    0,  628,  628,    0,  628,    0,    0, 
            0,    0,    0,  628,    0,    0,    0,    0,    0,    0, 
            0,  628,    0,    0,    0,    0,  628,  628,  628,  628, 
          628,  628,    0,    0,    0,  628,    0,  628,  628,    0, 
          628,  628,  628,  628,    0,    0,    0,    4,    5,    6, 
            0,    8,    0,  628,  628,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  108,  109,   17,   18,    0, 
            0,    0,    0,  110,  111,  112,  113,  114,  115,  116, 
            0,    0,  117,    0,    0,    0,    0,    0,    0,  118, 
            0,    0,  119,  120,  121,    0,  122,   35,  123,  124, 
          125,  126,    0,   40,    0,    0,  127,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  128,    0,    0,    0,  129,    0,    0, 
          130,    0,    0,   46,   47,    0,   48,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,    0,    0,    4,    5,    6,    0, 
            8,    0,   65,   66,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  108,  109,   17,   18,    0,    0, 
            0,    0,  110,  111,  112,  262,  263,  264,  265,    0, 
            0,  117,    0,    0,    0,    0,    0,    0,  118,    0, 
            0,  266,  267,  268,    0,  269,   35,  270,  271,  272, 
          273,    0,   40,    0,    0,  127,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  274,    0,    0,   45, 
            0,    0,   46,   47,    0,   48,    0,   49,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,    0,    0,    4,    5,    6,    0,    8, 
            0,   65,   66,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  108,  109,   17,   18,    0,    0,    0, 
            0,  110,  111,  112,  335,  336,  337,  338,    0,    0, 
          117,    0,    0,    0,    0,    0,    0,  118,    0,    0, 
          339,  340,  341,    0,  342,   35,  343,  344,  345,  346, 
            0,   40,    0,    0,  127,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  347,    0,    0,  424,    0, 
            0,   46,   47,    0,   48,    0,  425,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,    0,    0,    4,    5,    6,    0,    8,    0, 
           65,   66,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  108,  109,   17,   18,    0,    0,    0,    0, 
          110,  111,  112,  113,  114,  115,  116,    0,    0,  117, 
            0,    0,    0,    0,    0,    0,  118,    0,    0,  119, 
          120,  121,    0,  122,   35,  123,  124,  125,  126,    0, 
           40,    0,    0,  127,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  129,    0,    0,  130,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,    0,    4,    5,    6,    0,    8,    0,   65, 
           66,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  108,  109,   17,   18,    0,    0,    0,    0,  110, 
          111,  112,  335,  336,  337,  338,    0,    0,  117,    0, 
            0,    0,    0,    0,    0,  118,    0,    0,  339,  340, 
          341,    0,  342,   35,  343,  344,  345,  346,    0,   40, 
            0,    0,  127,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  347,    0,    0,  424,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
            0,    0,    4,    5,    6,    0,    8,    0,   65,   66, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          108,  109,   17,   18,    0,    0,    0,    0,  110,  111, 
          112,  113,  114,  115,  116,    0,    0,  117,    0,    0, 
            0,    0,    0,    0,  118,    0,    0,  119,  120,  121, 
            0,  974,   35,  123,  124,  975,  126,    0,   40,    0, 
            0,  127,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  976,    0,    0,  130,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,   65,   66,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  108, 
          109,   17,   18,    0,    0,    0,    0,  110,  111,  112, 
          988,  989,  990,  991,    0,    0,  117,    0,    0,    0, 
            0,    0,    0,  118,    0,    0,  992,  993,  994,    0, 
          995,   35,  996,  997,  998,  999,    0,   40,    0,    0, 
          127,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0, 1000,    0,    0,  130,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,  138,  139, 
          140,  141,  142,  143,  144,  145,   65,   66,  146,  147, 
          148,  149,  150,    0,    0,  151,  152,  153,  154,  155, 
          156,  157,    0,    0,  158,  159,  160,  218,  219,  220, 
          221,  165,  166,  167,  168,  169,  170,  171,  172,  173, 
          174,  175,  176,  222,  223,  224,    0,  225,  181,  305, 
            0,  226,    0,    0,    0,  183,  184,    0,  185,  186, 
          187,  188,  189,  190,  191,    0,    0,  192,  193,    0, 
            0,    0,  194,  195,  196,  197,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  199, 
          200,    0,  201,  202,  203,  204,  205,  206,  207,  208, 
          209,  210,  211,    0,    0,  212,   52,  138,  139,  140, 
          141,  142,  143,  144,  145,    0,    0,  146,  147,  148, 
          149,  150,    0,    0,  151,  152,  153,  154,  155,  156, 
          157,    0,    0,  158,  159,  160,  218,  219,  220,  221, 
          165,  166,  167,  168,  169,  170,  171,  172,  173,  174, 
          175,  176,  222,  223,  224,    0,  225,  181,    0,    0, 
          226,    0,    0,    0,  183,  184,    0,  185,  186,  187, 
          188,  189,  190,  191,    0,    0,  192,  193,    0,    0, 
            0,  194,  195,  196,  197,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  199,  200, 
            0,  201,  202,  203,  204,  205,  206,  207,  208,  209, 
          210,  211,    0,    0,  212,   52,  138,  139,  140,  141, 
          142,  143,  144,  145,    0,    0,  146,  147,  148,  149, 
          150,    0,    0,  151,  152,  153,  154,  155,  156,  157, 
            0,    0,  158,  159,  160,  161,  162,  163,  164,  165, 
          166,  167,  168,  169,  170,  171,  172,  173,  174,  175, 
          176,  177,  178,  179,    0,  180,  181,  123,  124,  182, 
          126,    0,    0,  183,  184,    0,  185,  186,  187,  188, 
          189,  190,  191,    0,    0,  192,  193,    0,    0,    0, 
          194,  195,  196,  197,    0,    0,    0,    0,    0,    0, 
          198,    0,    0,    0,    0,    0,    0,  199,  200,    0, 
          201,  202,  203,  204,  205,  206,  207,  208,  209,  210, 
          211,    0,    0,  212,  138,  139,  140,  141,  142,  143, 
          144,  145,    0,    0,  146,  147,  148,  149,  150,    0, 
            0,  151,  152,  153,  154,  155,  156,  157,    0,    0, 
          158,  159,  160,  218,  219,  220,  221,  165,  166,  167, 
          168,  169,  170,  171,  172,  173,  174,  175,  176,  222, 
          223,  224,    0,  225,  181,  355,  356,  226,  357,    0, 
            0,  183,  184,    0,  185,  186,  187,  188,  189,  190, 
          191,    0,    0,  192,  193,    0,    0,    0,  194,  195, 
          196,  197,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  199,  200,    0,  201,  202, 
          203,  204,  205,  206,  207,  208,  209,  210,  211,    0, 
            0,  212,  138,  139,  140,  141,  142,  143,  144,  145, 
            0,    0,  146,  147,  148,  149,  150,    0,    0,  151, 
          152,  153,  154,  155,  156,  157,    0,    0,  158,  159, 
          160,  218,  219,  220,  221,  165,  166,  167,  168,  169, 
          170,  171,  172,  173,  174,  175,  176,  222,  223,  224, 
            0,  225,  181,    0,    0,  226,    0,    0,    0,  183, 
          184,    0,  185,  186,  187,  188,  189,  190,  191,    0, 
            0,  192,  193,    0,    0,    0,  194,  195,  196,  197, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  199,  200,    0,  201,  202,  203,  204, 
          205,  206,  207,  208,  209,  210,  211,  669,  627,  212, 
            0,  670,    0,    0,    0,  183,  184,    0,  185,  186, 
          187,  188,  189,  190,  191,    0,    0,  192,  193,    0, 
            0,    0,  194,  195,  196,  197,    0,    0,    0,    0, 
            0,    0,  299,    0,    0,    0,    0,    0,    0,  199, 
          200,    0,  201,  202,  203,  204,  205,  206,  207,  208, 
          209,  210,  211,  640,  635,  212,    0,  641,    0,    0, 
            0,  183,  184,    0,  185,  186,  187,  188,  189,  190, 
          191,    0,    0,  192,  193,    0,    0,    0,  194,  195, 
          196,  197,    0,    0,    0,    0,    0,    0,  299,    0, 
            0,    0,    0,    0,    0,  199,  200,    0,  201,  202, 
          203,  204,  205,  206,  207,  208,  209,  210,  211,  688, 
          627,  212,    0,  689,    0,    0,    0,  183,  184,    0, 
          185,  186,  187,  188,  189,  190,  191,    0,    0,  192, 
          193,    0,    0,    0,  194,  195,  196,  197,    0,    0, 
            0,    0,    0,    0,  299,    0,    0,    0,    0,    0, 
            0,  199,  200,    0,  201,  202,  203,  204,  205,  206, 
          207,  208,  209,  210,  211,  691,  635,  212,    0,  692, 
            0,    0,    0,  183,  184,    0,  185,  186,  187,  188, 
          189,  190,  191,    0,    0,  192,  193,    0,    0,    0, 
          194,  195,  196,  197,    0,    0,    0,    0,    0,    0, 
          299,    0,    0,    0,    0,    0,    0,  199,  200,    0, 
          201,  202,  203,  204,  205,  206,  207,  208,  209,  210, 
          211,  702,  627,  212,    0,  703,    0,    0,    0,  183, 
          184,    0,  185,  186,  187,  188,  189,  190,  191,    0, 
            0,  192,  193,    0,    0,    0,  194,  195,  196,  197, 
            0,    0,    0,    0,    0,    0,  299,    0,    0,    0, 
            0,    0,    0,  199,  200,    0,  201,  202,  203,  204, 
          205,  206,  207,  208,  209,  210,  211,  705,  635,  212, 
            0,  706,    0,    0,    0,  183,  184,    0,  185,  186, 
          187,  188,  189,  190,  191,    0,    0,  192,  193,    0, 
            0,    0,  194,  195,  196,  197,    0,    0,    0,    0, 
            0,    0,  299,    0,    0,    0,    0,    0,    0,  199, 
          200,    0,  201,  202,  203,  204,  205,  206,  207,  208, 
          209,  210,  211,  733,  627,  212,    0,  734,    0,    0, 
            0,  183,  184,    0,  185,  186,  187,  188,  189,  190, 
          191,    0,    0,  192,  193,    0,    0,    0,  194,  195, 
          196,  197,    0,    0,    0,    0,    0,    0,  299,    0, 
            0,    0,    0,    0,    0,  199,  200,    0,  201,  202, 
          203,  204,  205,  206,  207,  208,  209,  210,  211,  736, 
          635,  212,    0,  737,    0,    0,    0,  183,  184,    0, 
          185,  186,  187,  188,  189,  190,  191,    0,    0,  192, 
          193,    0,    0,    0,  194,  195,  196,  197,    0,    0, 
            0,    0,    0,    0,  299,    0,    0,    0,    0,    0, 
            0,  199,  200,    0,  201,  202,  203,  204,  205,  206, 
          207,  208,  209,  210,  211, 1064,  627,  212,    0, 1065, 
            0,    0,    0,  183,  184,    0,  185,  186,  187,  188, 
          189,  190,  191,    0,    0,  192,  193,    0,    0,    0, 
          194,  195,  196,  197,    0,    0,    0,    0,    0,    0, 
          299,    0,    0,    0,    0,    0,    0,  199,  200,    0, 
          201,  202,  203,  204,  205,  206,  207,  208,  209,  210, 
          211, 1067,  627,  212,    0, 1068,    0,    0,    0,  183, 
          184,    0,  185,  186,  187,  188,  189,  190,  191,    0, 
            0,  192,  193,    0,    0,    0,  194,  195,  196,  197, 
            0,    0,    0,    0,    0,    0,  299,    0,    0,    0, 
            0,    0,    0,  199,  200,    0,  201,  202,  203,  204, 
          205,  206,  207,  208,  209,  210,  211, 1070,  635,  212, 
            0, 1071,    0,    0,    0,  183,  184,    0,  185,  186, 
          187,  188,  189,  190,  191,    0,    0,  192,  193,    0, 
            0,    0,  194,  195,  196,  197,    0,    0,    0,    0, 
            0,    0,  299,    0,    0,    0,    0,    0,    0,  199, 
          200,    0,  201,  202,  203,  204,  205,  206,  207,  208, 
          209,  210,  211,    0,    0,  212, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

            2,    3,    4,    5,   74,    6,  445,    9,   10,   11, 
          369,  423,   14,   15,   16,  416,   99,   19,    7,   88, 
           26,   90,   28,    3,   27,   21,   45,   15,   16,  330, 
            7,   19,   49,  334,  253,  465,   15,   16,   27,    0, 
           19,  485,  443,   45,   10,  559,   11,   49,   10,   51, 
           27,   52,   15,   16,    2,    3,   19,    0,  459,   47, 
          291,  573,  574,  415,  470,  417,    4,    5,  420,   10, 
          505,   10,  473,    0,    6,    7,   14,   10,  129,  427, 
          524,   10,  861,   10,   47,   48,  482,   10,  447,  485, 
           15,   16,  444,   59,   19,   27,   10,   99,   10,   10, 
           11,  582,  673,   59,   10,   10,  458,  757,  460,  317, 
          106,   49,  118,  104,   51,   10,   10,   10,   44,  690, 
           52,  104,  474,  765,   21,  752,  128,   43,  130,   59, 
          305,  532,   59,  704,  970,   61,   59,  305,  341,  104, 
           10,   10,  328,   10,   10,   10,   59,   59,  591,  776, 
          336,  786,  369,   59,   59,  534,  508,  792,   59,    2, 
            3,   99,  280,   10,  735,   59,    9,   10,   11,  280, 
          325,  341,   15,   16,   44,   44,   19,  308,   32,   44, 
          249,  533,  625,   10,   10,  280,  312,  282,   10,   10, 
           10,  317,   61,    0,   10,   61,  345,   10,   10,  305, 
          375,  560,   45,   10,  359,   10,  275,  375,   51,  106, 
          362,  127,   44,  684,  363,  112,  424,   10,   10,   10, 
           10,   32, 1058,  694,  350,  351,  310,   59,   44,  668, 
          341,  233,  746,  747,  306, 1014,  342,   59,  310,  136, 
          679,  366,  311,   59,  362,  376,  377,   44,  371,  372, 
           10,  362,   59,  359,   59,  378,  883,   32,  260,  261, 
          383,   32,   59,  494,   44,  348,   59,  362,  394,  375, 
          269,   44,  271,  256,  718,  654,   10,   10,   32,   59, 
          349,   32,  328,  338,   44,  128,   59,  130,   10,  335, 
          336,  256,  727,   10,  296,  282,  298,  299,  317,   59, 
          302,  951,  304,   44,   59,   10,   10,  309,  296,   61, 
          298,   44,   61,  315,  956,  317,  338,  296,  677,  298, 
          299,  717,  718,   10,  326,   59,   59,   44,  319,  379, 
          380,  381,  382,  296,  682,  298,  319,   59,   10,  373, 
          290,  291,   59,  560,  378,  859,  348,  861,   10,  260, 
          261,   10,  864,  279,  319,  341,   61,   61,  264,  264, 
          872,  873,  805,  875,  269,  877,   10,  315,   44,  281, 
          310,  296,  357,  298,   61,  305,  378,  379,  380,  381, 
          382,  383,  384,  345,  338,   44,  342,  799,   61,   61, 
          233,  442,    9,   10,   11,    2,    3,    4,    5,  880, 
           59,  342,  363,  342,  345,  424,  887,   14,  425,  342, 
          348,  892,  345,  342,  416,   59,  345,  260,  261,  421, 
          363,  423,  424,  425,  803,  427,  428,  341,  430,  395, 
          731,  945,  946,  839,  382,  423,  363,  416,   45,  427, 
          363,  443,   49,  445,  446,  375,  359,  342,  342,  342, 
          430,  534,  345,  296,  456,  298,  299,  459,  359,  302, 
          677,  304,  464,  338,  443,  936,  309,  378,  379,  380, 
          381,  473,  315,  342,  317,  342,  342,  696,  466,  918, 
          459,  712,  430,  326,  421,  417,  423,  425,  420,  305, 
          427,  428,   99,  271,  473,  342,  940,  279, 1069,  502, 
         1014,  503, 1016,  505,  469,  470,  936, 1019, 1020, 1021, 
         1022,  128,  444,  502,  516,  342,  342,  371,  372,  482, 
          417,  342,  342,  130,  378,  502,  342,  359,  460,  342, 
          532,   59,  534,  267, 1048,  378,  379,  380,  381,  382, 
          383,  384,  474,  359,  940,  305,   10,  444,  987, 1030, 
          342,  342,  342,  532,    2,    3,   10,  505,  521,  375, 
          371,  372,  359,  460,  923, 1077,   14,  378,  268,  269, 
          502,  654,  305,  416,  279,  279,  508,  474,  421,  359, 
          423,  424,  342,  305,  427,  428,  359,  430,  305,    2, 
            3,  310,  279,  350,  351,   59,  534,   45,   44,  359, 
          443,  533,  445,  446,  359,   59,   10,  279,  267,  342, 
           10,  508,  843,  456,   10,  375,  459,  373,  624,   10, 
          342,  464,  378,  267,  339,  342,  233,  633,  290,  291, 
          473,  362,   45,  629,  263,  264,  533,  342,  342,  317, 
         1041,  637,  375,  260,  261,   10,  642,   44,   44,  732, 
           10,  317,  654,  375,   10,  342,   10,   61,  375,  317, 
          503,   61,  505,   59,   10,  667,  668,  673,   59,  859, 
          342,  349,  342,  516,  338,  353,  354,  679,  681,  680, 
          339,  373,  130,  363,  690,  302,  378,  304,   10,  532, 
         1042,  345,  681,   44,  682,  339,   61,  310,  704,   59, 
           44,  666,  309,   59,  681,  707,  925,   61,  315,  326, 
          317,   10,  931,  678,  347,   61,  654,  130,  373,  341, 
          803,  308,  309,   44,  311,  727,  796,  263,  264,  735, 
          732,  373,  629,  269,  373,   91,  378,   44,  373,   61, 
          637,  348,  763,  373,  262,  642,  267,  264,  680,  681, 
          264,  342,   59,   44,  717,  945,  667,   44,  760,  761, 
           59,  378,  379,  380,  381,  363,  383,  384,   91,    2, 
           91,   44,  362,   32,  671,  382,  778,  674,  780,  727, 
          782,  783,  784,   61,   91,  233,  306,  789,  790,  376, 
          377,  306,   44,   59,  732,   44,  707,  799,  262,  263, 
          264,  803,   44,   44,  268,  269,  306,  271,   44,  371, 
          372,  373,   32,  338,   47,   48,  378,  424,  425,  821, 
          233,   44,  824,  430,  667,  668, 1016,  338,  338,  446, 
          338,   10,   44,  835,  836,  837,  679,   61,  445,   44, 
           44,   44,  807,   44,  264,  269,  783,  784,   10,  456, 
          338,  305,  789,  790,  338,   59,  338,  464, 1048,  338, 
          302,  309,  799,  264,  707,  803,  363,  315,   91,  317, 
           44,  267,  263,  264,  839,  279,   44,   58,  342,  279, 
           59,  338,  324,  325,  727,   91,  503,   91,  342,  345, 
           91,  893,  264,  371,  372,  373,  309,   59,  505,  363, 
          378,  903,  315,   44,  317,  264,  339,  267,  263,  516, 
          338,  267,   91,  824,  279,  917,  918,  760,  761,  264, 
           44,  375,  924,   91,  280,  279,  928,  534,  949,  264, 
           44,  395, 1001,  279,  382,  778,  363,  780,  342,  782, 
          783,  784,  342,  342,   44,  966,  789,  790,   44,   10, 
           91,  264,   10,  363,   10,  893,  799,  279,  279,  280, 
          962,   44,   44,  262,  263,  264,  903,   44,   61,  382, 
          269,   44,  328,  280,   44,  423,  424,  342,  821,  335, 
          336,  824,  430,   44,   44,  987,  924,   44,  342,  359, 
          264,   44,  835,  836,  837,  363,  342,  445,   44,  264, 
           61,   59, 1004,   59, 1006,  328,  362,  328,  456,  264, 
         1012,  424,  335,  336,  335,  336,  464,  430,  264,  359, 
          342,  328,  310,   44,  962,  363,  264,  310,  335,  336, 
           91,   44,  445, 1054,  341,   44,   10,   44,   44, 1041, 
           44,  362,   10,  456, 1046,  487,  264,  654,  264,   44, 
          667,  464,  359,  495,  496,  362,  279,  505,  395,  345, 
          903,  668, 1041, 1069,  271,   10,  299,  363,  516,  341, 
           44,  513,  679,  271,  917,  918,  280,  345,  279,  342, 
           58,   45,  363,   91,  345,  928,  264,   61,  267,  345, 
          707,   59,  505,   10,  306,  342,  308,  309,  310,  311, 
          262,  263,  264,  516,   70,  328,  268,  269,  359,  271, 
         1042,  279,  335,  336,   59,   91,   54,   91,  341,  284, 
          727,  371,  328,    5,  328,  732,  516,  328,    6,  335, 
          336,  335,  336,  740,  335,  336, 1044,  341,  279,  280, 
           91,  755,   59,  642,  987, 1042,   91,  923,  763,  328, 
          776,  765,  966,  760,  761,  359,  335,  336,  362,  767, 
          328, 1004,  776, 1006,  968,   10,  130,  335,  336, 1012, 
           14,  778,  796,  780,   91,  782,  746,  951,   -1,  763, 
          342,  765, 1043,  416,  371,  372,  373,  328,   91,   -1, 
           -1,  378,  776,   -1,  335,  336,  803,   -1, 1041,   44, 
          341,  363,   -1, 1046,   -1,   -1,   -1,  824,  264,  396, 
          443,  653,   -1,  269,  821,  271,   61,   -1,  279,  452, 
          668,  362,   10,   -1,   -1,   -1,  459,   -1,  835,  836, 
          837,  679,   -1,  395,  676,   59,   -1,   -1,   -1,    0, 
          473,   -1,   -1,   10,   -1,   -1,   91,   -1,  306,   10, 
          308,  309,  310,  311,  312,  668,   -1,   -1,   -1,  317, 
          306,   -1,  308,  309,  310,  311,  679,  328,   -1,   -1, 
          328,   59,  505,   -1,  335,  336,   -1,   44,  336,  727, 
          722,  342,  340,  341,   -1,   -1,  893,   -1,  730,   -1, 
          348,  349,  350,  351,   61,   -1,  264,   10,   59,  532, 
          268,  269,   -1,   91,   -1,  279,   -1,   -1,   -1,  751, 
          917,  918,  760,  761,  727,   91,    0,  924,   91,   -1, 
          328,  928,  267,   -1,   91,   -1,   10,  335,  336,   -1, 
          778,   -1,  780,   -1,  782,  280,  394,   -1,  571,   -1, 
          954,   -1,  956,   -1,  958,  309,   59,  760,  761,  963, 
          267,  799,  328,  317,  328,  962,  970,  590,  591,  335, 
          336,  335,  336,   -1,   -1,  778,   -1,  780,  342,  782, 
          812,   -1,  956,  821,   -1,   59,   -1,  328,   91,   -1, 
          987,   44,  966,  328,  335,  336,  970,  835,  836,  837, 
          335,  336,  625,   -1,   15,   16,  341, 1004,   19, 1006, 
           -1,   44,   -1,   -1,  637, 1012,   -1,   44,  821,  642, 
          306,  328,  308,  309,  310,  311,  858,  362,  335,  336, 
           41,   42,  835,  836,  837,  328,   47,   48,   91,   50, 
           51,   -1,  335,  336,  279,  280, 1050,   -1,   -1, 1046, 
           -1,  674, 1056,   -1, 1058,   -1,   -1, 1061,   91,  682, 
           48,  684,    0,  686,   91,   -1,   -1,  371,  372,  373, 
          424,  694,   10,    0,  378,   -1,   -1,   -1,   -1,  917, 
          918,   44, 1086,   10, 1058,   -1,  924,   -1,   -1,  267, 
          928,   -1,  306,  328,  308,  309,  310,  311,  312,   -1, 
          335,  336,  456,  317,  727,   10,  341,  342,   -1,   -1, 
          464,  262,  263,  264,  917,  918,  267,  268,  269,   -1, 
          271,   59,  279,  280,   -1,  928,  340,  362,   91,  752, 
          281,   -1,   59,   -1,  348,  349,  350,  351,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,  987, 
          328,   -1,   -1,  776,   59,   -1,   -1,  335,  336,   -1, 
           -1,   -1,  328,  341,  267,  328, 1004,   -1, 1006,  335, 
          336,  328,  335,  336, 1012,   -1,   -1,  280,  335,  336, 
          394,   -1,  805,   -1,  987,  342,   91,   -1,  262,  263, 
          264,  342,   -1,  267,  268,  269,  819,  271,   -1,  822, 
           -1, 1004,   -1, 1006,   10,  362,   -1,  281, 1046, 1012, 
           -1,   -1,  363,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,  328,  279,  371,  372,  373, 
           10,   -1,  335,  336,  378,  371,  372,  373,  341,   10, 
           -1,   -1,  378, 1046,  395,   -1,  279,   -1,  371,  372, 
          373,   -1,  279,   59,  328,  378,    0,   -1,   10,  362, 
          883,  335,  336,   -1,   -1,   -1,   10,   -1,  342,  280, 
          281,  282,  283,   44,  285,  328,   -1,   -1,   -1,   59, 
           -1,   -1,  335,  336,   -1,  296,   -1,  298,  299,  363, 
           61,   -1,  280,  281,  282,  328,  307,  285,   -1,   -1, 
           44,  328,  335,  336,   -1,   -1,   -1,   59,  335,  336, 
           -1,   91,   -1,  936,   -1,   59,  279,   -1,   -1,   -1, 
           91,  395,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,  262,  263,  264,   -1,   91, 
          267,  268,  269,  281,  271,  293,  294,  295,  296,  297, 
           -1,   -1,  290,  291,  281,  293,  294,  295,  296,  297, 
           -1,   -1,  267,  290,  291,  328,  293,  294,  295,  296, 
          297,   -1,  335,  336,  385,  386,  387,  388,  389,  390, 
          391,  392,  393,  394,  395,  396,  397,  398,  399,  400, 
          401,  402,  403,  404,  405,  406,  407,  408,  409,  410, 
           -1,  371,  372,  373,  342,  416,  760,  761,  378,   10, 
          421,   44,  423,   -1,   10,  342,  427,  428, 1041,   -1, 
         1043, 1044,   -1,  328,  778,  363,  780,   -1,  782,   -1, 
          335,  336,  443,   -1,   -1,  423,  363,   -1,   -1,  427, 
           -1,   -1,  306,   44,  308,  309,  310,  311,  459,   -1, 
          461,  462,  463,   -1,   -1,  466,   -1,  395,   91,   -1, 
           61,   -1,  473,   59,   -1,   -1,   -1,  821,  395,   -1, 
          481,  482,   -1,   -1,  485,   -1,  340,   -1,  466,   -1, 
           -1,  835,  836,  837,  348,   -1,   -1,  267,   -1,   -1, 
           91,   -1,   -1,  481,  482,   -1,   -1,  485,  509,  510, 
          306,   -1,  308,  309,  310,  311,  312,   -1,  279,   10, 
          521,  317,   10,  524,   -1,  267,   -1,   -1,  262,  263, 
          264,  532,  328,  267,  268,  269,   -1,  271,  280,   -1, 
          336,   -1,   -1,  521,  340,  341,  524,  281,  282,   -1, 
           -1,   10,  348,  349,  350,  351,  290,  291,  328,  293, 
          294,  295,  296,  297,   -1,  335,  336,  328,   59,   -1, 
           -1,   59,   -1,  917,  335,  336,  371,  372,  373,   -1, 
          341,  342,  583,  378,  928,   44,  328,   -1,   -1,   -1, 
           -1,    0,   10,  335,  336,   -1,   -1,   -1,  394,  341, 
           91,   10,   61,   91,   -1,  583,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,   -1,   44,  361,   -1,  363, 
          362,  365,   10,   -1,   -1,   -1,   -1,  371,   -1,  363, 
            0,   59,   91,   10,   -1,   44,   -1,   -1,   -1,   -1, 
           10,   59,   -1,  306,  645,  308,  309,  310,  311,   58, 
           59,   -1,   -1,   -1,   63,   -1,  279,   -1,   -1,   -1, 
         1004,  395, 1006,   91,   -1,   -1,   -1,  645, 1012,   -1, 
           -1,   59,   -1,   91,   44,   -1,   10,  340,   -1,   -1, 
           10,  682,   59,   -1,   -1,  348,   -1,   -1,  279,   59, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           44,   -1, 1046,   91,  682,  328,   -1,  708,   -1,  710, 
           44,   -1,  335,  336,   91,   59,  717,  718,   -1,   -1, 
          306,   -1,  308,  309,  310,  311,  312,   61,   -1,   59, 
          708,  317,  710,   -1,   -1,  479,  317,  328,   44,  717, 
          718,   -1,  328,  744,  335,  336,   -1,   91,   -1,   -1, 
          336,  342,  333,  334,  340,  341,   -1,   91,   -1,   -1, 
           -1,   91,  348,  349,  350,  351,  744,   -1,  349,   -1, 
          342,   -1,  353,  354,  355,  356,  267,  317,   -1,  267, 
            0,   -1,  783,  784,   -1,   91,   -1,   -1,  789,  790, 
           10,  363,   -1,  333,  334,   -1,   -1,  798,  799,  800, 
           -1,   -1,   -1,  804,  548,   -1,   -1,   -1,  394,  349, 
           -1,  351,   -1,  353,  354,  355,  356,   -1,   -1,  359, 
          279,  361,  800,  395,   44,   -1,  827,  828,   -1,  830, 
          831,   -1,   -1,  834,   -1,   -1,   -1,  328,   58,   59, 
          328,   61,  586,   63,  335,  336,   -1,  335,  336,  267, 
           -1,   -1,  280,  262,  263,  264,  834,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   91,  281,  282,   -1,   -1,  335,  336,   -1,  267, 
           -1,  290,  291,  342,  293,  294,  295,  296,  297,   -1, 
          267,   -1,  262,  263,  264,  896,  305,  267,  268,  269, 
          328,  271,  903,  280,   -1,   -1,   -1,  335,  336,   -1, 
          328,   -1,  913,  341,   -1,  324,  325,  335,  336,    0, 
          329,  330,   -1,  293,  294,  295,  296,  297,   -1,   10, 
          339,  359,  933,  342,  362,  913,  345,  267,  347,  940, 
          328,   -1,   -1,   -1,   -1,  279,  280,  335,  336,   -1, 
          280,  328,   -1,   -1,  363,   -1,   -1,   -1,  335,  336, 
           -1,   -1,  940,   44,  341,   -1,  375,   -1,   -1,  339, 
           -1,   -1,  342,  279,   -1,   -1,   -1,   58,   59,   -1, 
           61,  317,   63,   -1,  328,  362,  395,   -1,   -1,   -1, 
           -1,  335,  336,  363,  328,   -1,   -1,  341,  328,   -1, 
           -1,  335,  336,   -1,   -1,  335,  336,  341,  342,   -1, 
           91,  341,   -1,  349,   -1,  359,   -1,  353,  354,  355, 
          356,   -1,  328,   -1,   -1,  395,   -1,   -1,  362,  335, 
          336,   10,  362,   -1,   -1,   -1,   -1,  257,  258,  259, 
         1041,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           59,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   44,   -1,  333,  334,  335,  336,  337,  338,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,  363,   -1,  365,  366,  367,  368,  369, 
          370,   44,   -1,   -1,  374,  375,  376,  377,   91,  379, 
          380,  381,  382,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,  392,  393,  394,  395,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   91,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   59, 
          776,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           44,   91,  333,  334,  335,  336,  337,  338,  339,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,    0,  374,  375,  376,  377,   91,  379,  380, 
          381,  382,   10,  306,   -1,  308,  309,  310,  311,   -1, 
           -1,  392,  393,  394,  395,  884,  262,  263,  264,  888, 
           -1,   -1,  268,  269,   -1,  271,   -1,  306,   -1,  308, 
          309,  310,  311,  312,   -1,   -1,   44,  340,  317,   -1, 
           -1,   -1,  317,   -1,   -1,   -1,  279,  280,   -1,  328, 
           58,   59,   -1,   61,   -1,   63,   -1,  336,  333,  334, 
           -1,  340,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
          349,  350,  351,   -1,  349,   -1,  351,   -1,  353,  354, 
          355,  356,   -1,   91,   -1,   -1,  279,  280,  306,   -1, 
          308,  309,  310,  311,  312,  328,  342,   -1,   -1,  317, 
           -1,   -1,  335,  336,   -1,   -1,   -1,  963,  341,   -1, 
          966,   -1,  968,   -1,  970,  394,   -1,  363,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,   -1,   -1,  267,   -1,  362, 
           -1,    0,  350,  351,   -1,  328,   -1,   -1,   -1,   -1, 
           -1,   10,  335,  336,   -1,   -1,   -1,   -1,  341,  395, 
           -1,   -1,   -1,   -1,   -1, 1024,   -1,   -1, 1027, 1028, 
           -1,   -1, 1031, 1032,   -1,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   44,  394,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  279,   -1,   -1,  328,   58, 
           59,   -1,   61,   -1,   63,  335,  336,   -1, 1054,   -1, 
         1056,   -1, 1058,   -1,   -1, 1061,   -1,   -1,   -1, 1078, 
         1079, 1080, 1081,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1, 1090,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
         1086,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,   10,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   59,   -1,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   44,   -1,  333,  334,  335,  336,  337, 
           10,  339,  340,  341,  342,  343,  344,  345,  346,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,  363,   -1,  365,  366,  367, 
          368,  369,  370,   44,   -1,   -1,  374,  375,  376,  377, 
           91,  379,  380,  381,  382,   -1,   -1,   -1,   -1,   59, 
           -1,   -1,   10,   -1,  392,  393,  394,  395,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           91,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   59,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   44,   91,  333,  334,  335,  336,  337,   -1, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,  363,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,    0,  374,  375,  376,  377,   91, 
          379,  380,  381,  382,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  392,  393,  394,  395,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  306, 
           -1,  308,  309,  310,  311,  312,   -1,   -1,   44,   -1, 
          317,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,  280, 
           -1,  328,   58,   59,   -1,   61,   -1,   63,   -1,  336, 
           -1,   -1,   -1,  340,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,  349,  350,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,  279,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,  306,  394,  308,  309, 
          310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,  267, 
           -1,  362,   -1,    0,   -1,   -1,   -1,  328,  328,   -1, 
           -1,   -1,   -1,   10,  335,  336,  336,   -1,   -1,   -1, 
          340,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349, 
          350,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,   44,  326,  327, 
           -1,   -1,   -1,   -1,   -1,  333,  334,  279,   -1,   -1, 
          328,   58,   59,   -1,   -1,   -1,   63,  335,  336,   -1, 
           -1,  349,   -1,  351,  394,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1, 
           -1,   -1,   -1,  335,  336,   10,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   59,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   44,   -1,  333,  334,  335, 
          336,  337,   10,  339,  340,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,   -1,  365, 
          366,  367,  368,  369,  370,   44,   -1,   -1,  374,  375, 
          376,  377,   91,  379,  380,  381,  382,   -1,   -1,   -1, 
           -1,   59,   -1,   -1,   10,   -1,  392,  393,  394,  395, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   91,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   59,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   91,  333,  334,  335,  336, 
          337,   -1,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,  363,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,    0,  374,  375,  376, 
          377,   -1,  379,  380,  381,  382,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  392,  393,  394,  395,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  306,   -1,  308,  309,  310,  311,  312,   -1,   -1, 
           44,   -1,  317,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          279,  280,   -1,  328,   58,   59,   -1,   -1,   -1,   63, 
           -1,  336,   -1,   -1,   -1,  340,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,  349,  350,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
          279,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1, 
           -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,  306,  394, 
          308,  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317, 
           -1,  267,   -1,  362,   -1,    0,   -1,   -1,   -1,  328, 
          328,   -1,   -1,   -1,   -1,   10,  335,  336,  336,   -1, 
           -1,   -1,  340,  341,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,  349,  350,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  328,   58,   59,   -1,  333,  334,   63,  335, 
          336,   -1,   -1,   -1,   -1,   -1,  394,   -1,   -1,   -1, 
           -1,   -1,  349,   -1,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   59,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,  337,   -1,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,  363, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,  375,  376,  377,   -1,  379,  380,  381,  382,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392,  393, 
          394,  395,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,  337,   -1,  339,  340,  341,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,  363,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,    0,  374, 
          375,  376,  377,   -1,  379,  380,  381,  382,   10,  317, 
           -1,   -1,   -1,   -1,  322,  323,   -1,  392,  393,  394, 
          395,   -1,   -1,   -1,   -1,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,  306,   -1,  308,  309,  310,  311,  312, 
           -1,  349,   44,  351,  317,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   -1,  328,   58,   59,   -1,   61, 
           -1,   63,   -1,  336,   -1,   -1,   -1,  340,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,  349,  350,  351,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,   -1,   -1,   91, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,  394,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,    0,  313,   -1, 
           -1,  316,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   59,   -1,   -1,  374, 
           63,  376,  377,   -1,  379,  380,  381,  382,  306,   -1, 
          308,  309,  310,  311,  312,   -1,   -1,  392,  393,  317, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  340,  341,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,  349,  350,  351,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,  394,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,  337,   -1,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
           -1,  363,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,  375,  376,  377,  767,  379,  380,  381, 
          382,   44,   -1,   -1,   -1,  776,   -1,   -1,   -1,   -1, 
          392,  393,  394,  395,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,  267,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,  281,  282, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,  337,   -1,  339,  340,   -1,  342, 
          343,  344,  345,  346,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
          363,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
            0,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392, 
          393,  394,  395,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  306,   -1,  308,  309, 
          310,  311,  312,   -1,   44,   -1,   -1,  317,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   -1,  963,   63,   -1,  966,   -1,  968,   -1,  970, 
          340,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349, 
          350,  351,   -1,   -1,  257,  258,  259,   -1,  261,   -1, 
           -1,   91,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,  394,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,    0, 
          313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1, 1054,   -1, 1056,   -1, 1058,   -1,   -1, 
         1061,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1, 1086,   -1,   -1,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   59,   -1, 
           -1,  374,   63,  376,  377,   -1,  379,  380,  381,  382, 
          306,   -1,  308,  309,  310,  311,  312,   -1,   -1,  392, 
          393,  317,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  348,  349,  350,  351,   -1,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,  394,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,    0,   -1,  333,  334,  335,  336,  337,   -1,  339, 
          340,   10,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,  363,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   44,  376,  377,   -1,  379, 
          380,  381,  382,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,  392,  393,  394,  395,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,  337,   -1,  339,  340, 
           -1,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,    0,  363,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   10,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  392,  393,  394,  395,  306,   -1,  308,  309,  310, 
          311,  312,   -1,   -1,   -1,   44,  317,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1,  340, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,  350, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,  394,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,   -1,   -1,  333,  334,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
           -1,   -1,   -1,  349,   44,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,  363,  361,  306,  307,   -1,   59, 
          310,   61,   -1,   63,  314,  315,  375,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,  395,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349, 
           -1,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,   -1,   -1,  364,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,   -1,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   63,   -1,  333,  334,  335,  336,  337,  338, 
           10,  340,  341,  342,  343,  344,   -1,  346,   -1,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,  363,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   44,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   61,   -1,  392,  393,  394,  395,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,   -1,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,   91,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   63,   -1,  333,  334,  335,  336,  337,  338,   -1, 
          340,  341,  342,  343,  344,   -1,  346,   -1,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,  363,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,    0,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  392,  393,  394,  395,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  297,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,  333,  334,   91,   -1,   -1,   -1,   -1,  279, 
          280,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  349,   -1, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   -1, 
          361,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,  328,   -1, 
           -1,   -1,   10,   -1,   -1,  335,  336,   -1,   -1,   -1, 
           -1,  341,  342,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  362,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  297,   -1,   -1,   -1,   -1, 
           -1,   59,   -1,   61,   -1, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,  333,  334,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,   -1,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,   -1,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   63, 
           -1,  333,  334,  335,  336,  337,   -1,   10,  340,  341, 
          342,  343,  344,   -1,  346,   -1,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  363,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   44,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   61,   -1, 
          392,  393,  394,  395,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,   91,   -1, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,  337,   -1,   -1,  340,  341,  342, 
          343,  344,   -1,  346,   -1,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
          363,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
            0,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           10,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,  392, 
          393,  394,  395,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   61,   -1,   63,   61,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   91,   -1,   -1,   91,   -1,  279,  280,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   10, 
           -1,   -1,  335,  336,   -1,   -1,   -1,   -1,  341,  342, 
           -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,  362, 
           -1,  326,  327,   44,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   59,   -1, 
           61,   -1,   63,  348,  349,   -1,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,   -1,   -1,  364, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,   -1,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,   -1,  279,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,  328,   -1,  333,  334,  335,  336,  337,  335,  336, 
          340,  341,  342,  343,  344,  342,  346,   -1,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,  363,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,    0,  379, 
          380,  381,  382,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,  392,  393,  394,  395,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,   -1,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   59,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,  337,   -1,   -1,  340, 
          341,  342,  343,  344,   -1,  346,   -1,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,   -1,  363,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,    0,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  392,  393,  394,  395,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  767,   -1,   -1,  770,   -1,   -1,   10, 
           -1,   -1,  776,   -1,   -1,  257,  258,  259,   63,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   59,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1, 
           91,   -1,   -1,  335,  336,  337,   -1,   -1,  340,    0, 
          342,  343,  344,   -1,  346,   -1,  348,   -1,  350,   10, 
          352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1, 
          362,  363,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
          392,  393,  394,  395,  262,  263,  264,   58,   59,  267, 
          268,  269,   63,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  280,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,  963, 
           -1,   -1,  966,   -1,  968,   -1,  970,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,  349,    0,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   10,  361,  362,  363,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  267,  375,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   44,  395,  333,  334, 
         1054,   -1, 1056,   -1, 1058,   -1,   -1, 1061,   -1,   -1, 
           58,   59,   -1,   61,  349,   63,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,   -1,   -1,   -1, 
           -1,   -1, 1086,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   91,  335,  336,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  280, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,    0,   -1,   -1,   -1,   59, 
           -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349,   44, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   -1, 
          361,  362,  363,   58,   59,   -1,   61,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  395,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,  349,   44,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   -1,  363,   58,   59,   -1,   61, 
           -1,   63,  262,  263,  264,   -1,   -1,  375,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  395,   -1,   91, 
           -1,   -1,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,  342,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,    0,   -1,  363,   -1,   59,   -1,   -1,   -1,   -1, 
           -1,   10,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,  339,  395,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,  349,   44,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,   -1,  363,   58, 
           59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
          375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          395,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,  338,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,   44,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           -1,  363,   58,   59,   -1,   61,   -1,   63,  262,  263, 
          264,   -1,   -1,  375,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,  395,   -1,   91,   -1,   -1,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   61,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,  342,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   91,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,  338, 
          339,  395,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,   44,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   58,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  395,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,  338,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,  349,   44,  351,  279,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   -1,  363,   58,   59, 
           -1,   61,   10,   63,   -1,   -1,   -1,   -1,   -1,  375, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,  395, 
           -1,   91,   -1,   -1,   -1,  328,   44,   -1,   -1,   -1, 
           -1,   -1,  335,  336,   -1,   -1,   -1,   -1,   -1,  342, 
           -1,   -1,   -1,   61,   -1,   -1,   -1,   44,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   61,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,    0,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,  338,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,  349,   44,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   -1,  361,   -1, 
          363,   58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  395,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,  279,  280,  333,  334,  335,  336,   -1,  338,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   10,  349, 
           44,  351,  279,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,  363,   58,   59,   -1,   61,   10,   63, 
           -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1, 
          328,   -1,   44,   -1,   -1,   -1,   -1,  335,  336,   10, 
           -1,   -1,   -1,  341,  342,  395,   -1,   91,   -1,   61, 
           -1,  328,   44,   -1,   -1,   -1,   -1,   -1,  335,  336, 
           -1,   -1,   -1,   -1,  362,  342,   -1,   -1,   -1,   61, 
           -1,   -1,   -1,   44,   -1,  262,  263,  264,   -1,   91, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           61,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,    0, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,  349,   44,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,   -1,  363,   58,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,  375,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  395,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,    0,   -1,   -1,   -1,   -1,  279,   -1,   -1, 
           -1,   -1,   10,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,  279,   -1,  333, 
          334,  335,  336,   -1,  338,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,  349,   44,  351,  279,  353, 
          354,  355,  356,  357,  358,  359,  328,  361,   -1,  363, 
           58,   59,   -1,  335,  336,   63,   -1,   -1,   -1,   -1, 
          342,  375,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1, 
           -1,   -1,   -1,  335,  336,   10,   -1,   -1,   -1,   -1, 
          342,  395,   -1,   91,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1, 
           -1,  342,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   61,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,    0,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   10,  349,   44, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   -1, 
          361,   -1,  363,   58,   59,   -1,   61,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  395,   -1,   91,   -1,   61,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  280,  281,  282,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,  349,   44,  351,  279,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,  362,  363,   58,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  395,   -1,   91, 
           -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1, 
          335,  336,   -1,   -1,   -1,   -1,   -1,  342,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,    0,   -1,   -1,   -1,   -1,  279,   -1,   -1,   -1, 
           -1,   10,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,  349,   44,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,  328,  361,   -1,  363,   58, 
           59,   -1,  335,  336,   63,   -1,   -1,   -1,   -1,  342, 
          375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          395,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,   44,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           -1,  363,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  395,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,   44,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  395,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,  349,   44,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   -1,  363,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,  375, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  395, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,  349,   44,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   -1,  361,   -1, 
          363,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  395,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           44,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,  363,   -1,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  395,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,    0, 
           -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,  349,   44,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,   -1,  363,   -1,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,  375,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  395,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,  349,   44,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           -1,   59,   -1,   -1,   -1,   63,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,   -1,   -1,   -1,   -1, 
           -1,  395,   -1,   91,   -1,   -1,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,  342,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,   -1,  339,  395, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349,   44, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   -1, 
          361,   -1,  363,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  395,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,  349,   44,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   -1,  363,   58,   59,  306,  307, 
           -1,   63,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,  395,   -1,   -1, 
           -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,  349,   -1,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,   -1,   -1,  364,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   58,   59,  333,  334, 
           -1,   63,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,  349,   -1,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,   -1,  363,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
          395,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   -1, 
           -1,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,   -1,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,  395,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   -1, 
           -1,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,    0,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   10,  361, 
           -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,  375,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   44,  395,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   -1, 
           -1,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,   -1,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,  395,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   59,   -1,   61, 
           -1,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   91, 
           -1,  333,  334,   -1,   -1,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,    0,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   10,  361, 
           -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,  375,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   44,  395,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   59,   -1,   61, 
           -1,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   91, 
           -1,  333,  334,   -1,   -1,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,   -1,  351, 
            0,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           10,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,  395,   44,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  280,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,    0, 
           -1,  333,  334,  335,  336,   -1,   -1,   -1,   -1,   10, 
          342,   -1,   -1,   -1,   -1,   -1,   -1,  349,   -1,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
          362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   44,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           61,   -1,   63,  395,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,  338,   -1,   -1,   -1, 
          342,   -1,   -1,   -1,   -1,   -1,   -1,  349,   -1,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,    0,  361, 
           -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  395,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   44,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,   91, 
           -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,   -1,  349, 
           -1,  351,    0,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   10,  363,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  395,   44,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
            0,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,   -1,   -1, 
           -1,  342,   -1,   -1,   44,   -1,   -1,   -1,  349,   -1, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   59, 
          361,   61,  363,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,  395,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,  317, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,   -1,   -1,   -1,  342,   -1,   -1,   44,   -1,   -1, 
           -1,  349,   -1,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   59,  361,   61,  363,   63,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,  395,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   44,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  363, 
           -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,  395,  338,   91,   -1,   -1,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,    0,  361,   -1,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  395, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   44,   -1, 
           -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,    0,   -1,  333,  334,  335,  336, 
           -1,  338,   -1,   -1,   10,  342,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,   -1,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   44,   -1, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   61,   -1,   63,  395,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1, 
           -1,  349,   -1,  351,    0,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   10,  363,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  395,   44,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   91,   -1,  333,  334,  335, 
          336,   -1,  338,   -1,   -1,   -1,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,    0,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   10,  361,   -1,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  395, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   91,   -1,  333,  334,  335, 
          336,   -1,  338,   -1,   -1,   -1,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,  351,    0,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   10,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,  395, 
           44,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,    0,   -1,  333,  334,  335, 
          336,   -1,  338,   -1,   -1,   10,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   -1,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   44, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63,  395, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,    0,   -1,   -1,   -1,  342,   -1,   -1,   -1, 
           -1,   -1,   10,  349,   -1,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   -1,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   44,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  395, 
           58,   59,   -1,   -1,   -1,   63,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,   -1,   -1,   -1,  342,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   10,   -1, 
           -1,  395,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   58,   59,  333,  334, 
           -1,   63,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
          355,  356,  357,  358,  359,   -1,  361,   -1,  363,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          375,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,    0,   -1,   -1,   -1,   -1, 
          395,   -1,   -1,  281,  282,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   58,   59,  333,  334,   -1,   63,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,  355,  356,  357, 
          358,  359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,  395,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   44,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   58,   59,   -1,   -1,   -1,   63,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,   -1,  339,   -1,   -1, 
          342,    0,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   10,   -1,   -1,   -1,  357,  358,  359,   -1,  361, 
           -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   44,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,  395,   -1,   -1,  281,  282,   -1,   58, 
           59,   -1,   -1,   -1,   63,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,  333,  334, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,  357,  358,  359,   -1,  361,   -1,  363,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
          375,  267,  268,  269,   -1,  271,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   10,   -1,   -1, 
          395,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,  357,  358,  359,   -1,  361,   -1,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  375, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,    0,   -1,   -1,   -1,   -1,  395, 
           -1,   -1,  281,  282,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  357,  358, 
          359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  395,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342, 
           10,   -1,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  357,  358,  359,   -1,  361,   -1, 
          363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  375,   -1,   44,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   58,   59, 
           -1,   -1,  395,   63,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  357,  358,  262,  263,  264,   -1,  363,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,  375, 
           -1,   -1,  281,  282,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,  395, 
           58,   59,   -1,   -1,   -1,   63,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  357,  358, 
            0,   -1,   -1,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,  395,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   58,   59, 
           -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339, 
           -1,   -1,  342,    0,   -1,  345,   -1,  347,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,  357,  358,   -1, 
           -1,   -1,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   44,   -1,  267, 
          268,  269,   -1,  271,   -1,  395,   -1,   -1,   -1,   -1, 
           -1,   58,   59,  281,  282,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,  357, 
          358,   -1,   -1,   -1,   -1,  363,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,  375,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,    0,   -1,  395,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329, 
          330,   -1,   -1,   58,   59,   -1,   -1,   -1,   63,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  363,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,  375,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,  290,  291,  395,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,  324,  325,   -1, 
           -1,   -1,  329,  330,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   63,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,    0,   -1,  363,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   10,   -1,   -1,   -1,  375,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,  395,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
            0,   -1,  363,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           10,   -1,   -1,   -1,  375,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,  395,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,  324, 
          325,   -1,   -1,   -1,  329,  330,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   63,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  363,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
          375,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   10,   -1,   -1,   -1,   -1,  290,  291, 
          395,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,    0, 
           -1,  363,   -1,   -1,   -1,  281,  282,   -1,   -1,   10, 
           -1,   -1,   -1,  375,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,  395,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,  324,  325, 
           -1,   -1,   -1,  329,  330,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,    0,   -1,  363,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   10,   -1,   -1,   -1,  375, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,  395, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,  325,   -1,   -1,   -1,  329, 
          330,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  363,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,  375,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,  290,  291,  395,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   44,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   58,   59,   -1,  375,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,  395,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   44,   -1,   -1, 
           -1,   -1,  363,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   58,   59,   -1,  375,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,  395,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,    0,   -1, 
          345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  363,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
          375,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,  281, 
          282,   -1,   44,   -1,   -1,   -1,   -1,   10,  290,  291, 
          395,  293,  294,  295,  296,  297,   58,   59,   -1,  262, 
          263,  264,   -1,  305,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   58,   59,  339,   -1,   -1, 
          342,   -1,  305,  345,   -1,  347,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,  262,  263,  264,   -1,   -1, 
          267,  268,  269,  395,  271,   -1,    0,   -1,   -1,   -1, 
          363,   -1,   -1,   -1,  281,  282,   10,   -1,   -1,   -1, 
           -1,   -1,  375,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,  395,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,  375,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  395,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,  262, 
          263,  264,   -1,  305,  267,  268,  269,   -1,  271,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,  339,   -1,   -1, 
          342,   -1,  305,  345,   -1,  347,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           -1,   -1,   -1,  375,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  395,   -1,   -1,    0,   -1,   -1,   -1, 
          363,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,  395,   -1,   -1,    0,   -1,  281,  282,   -1, 
           44,   -1,   -1,   -1,   -1,   10,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,  262,  263,  264, 
           -1,  305,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   59,  339,   -1,   -1,  342,   -1, 
          305,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,  339,   -1,   -1,  342,    0,   -1, 
          345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,  395,   -1,   -1,   -1,   -1,   -1,   -1,  363,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          375,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          395,  281,  282,   -1,   -1,   -1,   58,   59,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   44,   -1, 
           -1,   -1,   -1,  363,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   58,   59,   -1,  375,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,  262,  263,  264, 
           -1,  305,  267,  268,  269,  395,  271,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,  339,   -1,   -1,  342,   -1, 
          305,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   44,   -1,   -1,   -1,   -1,  363, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,  375,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  395,   -1,   -1,   -1,   -1,   -1,   -1,  363,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
          375,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
          395,  293,  294,  295,  296,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,    0,   59,   -1, 
           -1,  363,   -1,   -1,   -1,  281,  282,   10,   -1,   -1, 
           -1,   -1,   -1,  375,  290,  291,   -1,  293,  294,  295, 
          296,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,  395,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   59,   -1,   -1,   -1, 
           -1,   -1,   10,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   59,   44,   -1,   -1,  375, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   59,   -1,   -1,   -1,  262,  263,  264,   -1,  395, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  363,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,  262,  263,  264,   -1,  395,  267,  268,  269,   44, 
          271,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   59,   44,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   10,   -1,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  395,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,  342,   -1,   -1,  345,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,  262,  263, 
          264,   -1,  363,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,  281,  282,  267, 
          268,  269,   -1,  271,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,  395,   -1,   -1,   -1,   -1,  342, 
           -1,   -1,  345,   -1,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,  342,   -1, 
           -1,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  339,  395,   -1,  342,   -1,   -1,   -1,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,  262,  263,  264, 
           -1,  395,   -1,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,  395,   -1,  268, 
          269,   -1,  271,   -1,   -1,  290,  291,   91,  293,  294, 
          295,  296,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,  342,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   10,   -1,  292, 
           -1,   -1,   -1,  342,   -1,   -1,  299,   -1,  363,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          395,   -1,   -1,   -1,  337,   -1,   59,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,  395,  350,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   91,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392, 
          393,  394,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   10,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,  337,   -1,   59,  340,  341,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,  357,   -1,   -1,  360,   -1,  362,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   91,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392,  393, 
           -1,   -1,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   -1,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   10,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
           -1,   -1,  335,  336,  337,   -1,   59,  340,  341,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,  357,   -1,   -1,  360,   -1,  362, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   91,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392, 
          393,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   10,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,  337,   -1,   59,  340,  341,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,  357,   -1,   -1,  360,   -1,  362,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   91,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392,  393, 
           -1,   -1,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   -1,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   10,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
           -1,   -1,  335,  336,  337,   -1,   59,  340,  341,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,  357,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392, 
          393,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   10,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,  337,   -1,   59,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,  357,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392,  393, 
           -1,   -1,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   10,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   59,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392, 
          393,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   10,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,  362,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392,  393, 
           -1,   -1,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   -1,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   10,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,   -1,  256,  257,  258,  259,  260,  261,  392, 
          393,  264,  265,  266,   -1, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   10,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,   -1,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
          348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  392,  393,   -1,  256,  257,  258, 
          259,  260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           10,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,   -1,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,  348, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,  363,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,  392,  393,   -1,  265,  266,   -1,   10, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,   -1,  392,  393,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,  342,  343,  344,   -1,  346,   -1,   -1,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,   -1,  392,  393,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340, 
           -1,   -1,  343,  344,   -1,  346,   -1,   -1,   -1,   -1, 
           -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360, 
           -1,   -1,   -1,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,   -1,   -1,  257,  258,  259,  260,  261, 
           -1,  392,  393,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,   -1,   -1,  257,  258,  259,  260,  261,   -1, 
          392,  393,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,  256,  257,  258,  259,  260,  261,   -1,  392, 
          393,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,  300,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,  256,  257,  258,  259,  260,  261,   -1,  392,  393, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344, 
           -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,   -1, 
          256,  257,  258,  259,  260,  261,   -1,  392,  393,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,   -1,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,   -1,  392,  393,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  392,  393,  394,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  392,  393,  394,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  392,  393,  394,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  392,  393,  394,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  392,  393,  394,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  392,  393,  394,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,   -1,   -1,   -1, 
          257,  258,  259,  260,  261,  392,  393,  394,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,  300,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,   -1,   -1,  257, 
          258,  259,  260,  261,   -1,  392,  393,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,   -1,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
          348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,   -1,  392,  393,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,  341,   -1,  343,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,   -1,  392,  393,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,   -1,  392,  393,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340, 
           -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1, 
           -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360, 
           -1,   -1,   -1,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
           -1,  392,  393,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1, 
          392,  393,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1,  392, 
          393,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,   -1,  392,  393, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,  341,   -1,  343,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,  392,  393,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,   -1,  392,  393,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,   -1,  392,  393,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
           -1,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,   -1,  392,  393,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,   -1,  392,  393,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  333,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,   -1,  392,  393,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340, 
           -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
           -1,  392,  393,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1, 
          392,  393,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1,  392, 
          393,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
           -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,   -1,  392,  393, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,   -1, 
           -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,  392,  393,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,   -1,   -1, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  257,  258, 
          259,  260,  261,  262,  263,  264,  392,  393,  267,  268, 
          269,  270,  271,   -1,   -1,  274,  275,  276,  277,  278, 
          279,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,  298, 
          299,  300,  301,  302,  303,  304,   -1,  306,  307,  308, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
          349,   -1,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,   -1,   -1,  364,  365,  257,  258,  259, 
          260,  261,  262,  263,  264,   -1,   -1,  267,  268,  269, 
          270,  271,   -1,   -1,  274,  275,  276,  277,  278,  279, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,  298,  299, 
          300,  301,  302,  303,  304,   -1,  306,  307,   -1,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349, 
           -1,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,   -1,   -1,  364,  365,  257,  258,  259,  260, 
          261,  262,  263,  264,   -1,   -1,  267,  268,  269,  270, 
          271,   -1,   -1,  274,  275,  276,  277,  278,  279,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,  298,  299,  300, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,   -1,   -1,  364,  257,  258,  259,  260,  261,  262, 
          263,  264,   -1,   -1,  267,  268,  269,  270,  271,   -1, 
           -1,  274,  275,  276,  277,  278,  279,  280,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,  298,  299,  300,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,   -1, 
           -1,  364,  257,  258,  259,  260,  261,  262,  263,  264, 
           -1,   -1,  267,  268,  269,  270,  271,   -1,   -1,  274, 
          275,  276,  277,  278,  279,  280,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,  298,  299,  300,  301,  302,  303,  304, 
           -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,  349,   -1,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  306,  307,  364, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
          349,   -1,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  306,  307,  364,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  306, 
          307,  364,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,  349,   -1,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  306,  307,  364,   -1,  310, 
           -1,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  306,  307,  364,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,  349,   -1,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  306,  307,  364, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
          349,   -1,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  306,  307,  364,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  306, 
          307,  364,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,  349,   -1,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  306,  307,  364,   -1,  310, 
           -1,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  306,  307,  364,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,  349,   -1,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  306,  307,  364, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
          349,   -1,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,   -1,   -1,  364, 
      };
   }

}
